"use client";
import { createFluentIcon } from "../utils/createFluentIcon";
export const AccessTimeFilled = ( /*#__PURE__*/createFluentIcon('AccessTimeFilled', "1em", ["M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16ZM6.99 8.6A.5.5 0 0 1 6 8.4c.02-.07.03-.14.07-.24a2 2 0 0 1 .25-.46c.26-.35.71-.7 1.42-.7A1.7 1.7 0 0 1 9.5 8.75c0 .35-.07.65-.2.9a1.8 1.8 0 0 1-.51.6c-.16.11-.33.22-.48.3l-.06.04c-.17.1-.3.19-.42.29-.4.34-.66.7-.77 1.12H9a.5.5 0 0 1 0 1H6.5a.5.5 0 0 1-.5-.5c0-1.01.47-1.77 1.17-2.38.2-.16.4-.29.57-.4l.06-.03.38-.24a.8.8 0 0 0 .23-.26c.05-.1.09-.23.09-.44a.8.8 0 0 0-.19-.53.7.7 0 0 0-.56-.22.7.7 0 0 0-.61.3 1 1 0 0 0-.15.3ZM11 7c.28 0 .5.22.5.5V10H13V7.5a.5.5 0 0 1 1 0v5a.5.5 0 0 1-1 0V11h-2a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5Z"]));
export const AccessTimeRegular = ( /*#__PURE__*/createFluentIcon('AccessTimeRegular', "1em", ["M6.99 8.6A.5.5 0 0 1 6 8.4a1.29 1.29 0 0 1 .07-.24 2 2 0 0 1 .25-.46c.26-.35.71-.7 1.42-.7A1.7 1.7 0 0 1 9.5 8.75c0 .35-.07.65-.2.9a1.8 1.8 0 0 1-.51.6c-.16.11-.33.22-.48.3l-.06.04c-.17.1-.3.19-.42.29-.4.34-.66.7-.77 1.12H9a.5.5 0 0 1 0 1H6.5a.5.5 0 0 1-.5-.5c0-1.01.47-1.77 1.17-2.38.2-.16.4-.29.57-.4l.06-.03.38-.24a.8.8 0 0 0 .23-.26c.05-.1.09-.23.09-.44a.8.8 0 0 0-.19-.53.7.7 0 0 0-.56-.22.7.7 0 0 0-.61.3 1 1 0 0 0-.15.3ZM11 7c.28 0 .5.22.5.5V10H13V7.5a.5.5 0 0 1 1 0v5a.5.5 0 0 1-1 0V11h-2a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5Zm-1-5a8 8 0 1 0 0 16 8 8 0 0 0 0-16Zm-7 8a7 7 0 1 1 14 0 7 7 0 0 1-14 0Z"]));
export const AccessibilityFilled = ( /*#__PURE__*/createFluentIcon('AccessibilityFilled', "1em", ["M10 6a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM5.47 4.15c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L6.7 8.53c.18.08.3.26.3.46v1.86a.5.5 0 0 1-.04.19l-1.84 4.55a1.75 1.75 0 0 0 3.25 1.32l1.4-3.46c.08-.21.38-.21.46 0l1.4 3.46a1.75 1.75 0 0 0 3.24-1.32l-1.83-4.54a.5.5 0 0 1-.04-.19V9c0-.2.12-.38.3-.46l2.67-1.19c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-1.28.57c-.24.1-.42.3-.52.52a3 3 0 0 1-5.46 0c-.1-.21-.28-.41-.52-.52l-1.28-.57Z"]));
export const AccessibilityRegular = ( /*#__PURE__*/createFluentIcon('AccessibilityRegular', "1em", ["M8.5 4.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM10 2a2.5 2.5 0 0 0-2.43 3.08l-2.1-.93c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L7 8.66v2.29l-1.88 4.64a1.75 1.75 0 0 0 3.25 1.32l1.55-3.85.03-.04L10 13h.04l.03.05 1.56 3.84a1.75 1.75 0 0 0 3.24-1.3L13 10.95v-2.3l2.97-1.32c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-2.1.93A2.51 2.51 0 0 0 10 2ZM4.07 5.44a.76.76 0 0 1 1-.38l3.91 1.75a2.5 2.5 0 0 0 2.04 0l3.91-1.75c.38-.17.83 0 1 .38.18.38 0 .82-.37.99L12.6 7.75a1 1 0 0 0-.59.91v2.3a1 1 0 0 0 .07.37l1.87 4.64a.75.75 0 0 1-1.39.56L11 12.68c-.36-.9-1.64-.9-2 0l-1.56 3.85a.75.75 0 1 1-1.39-.56l1.88-4.65a1 1 0 0 0 .07-.37V8.66a1 1 0 0 0-.6-.91L4.45 6.43a.74.74 0 0 1-.37-.99Z"]));
export const AccessibilityCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('AccessibilityCheckmarkFilled', "1em", ["M10 6a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM5.47 4.15c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L6.7 8.53c.18.08.3.26.3.46v1.86a.5.5 0 0 1-.04.19l-1.84 4.55a1.75 1.75 0 0 0 3.25 1.32l.08-.22A5.48 5.48 0 0 1 13 9.02V9c0-.2.12-.38.3-.46l2.67-1.19c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-1.28.57c-.24.1-.42.3-.52.52a3 3 0 0 1-5.46 0c-.1-.21-.28-.41-.52-.52l-1.28-.57ZM18 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const AccessibilityCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('AccessibilityCheckmarkRegular', "1em", ["M8.5 4.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM10 2a2.5 2.5 0 0 0-2.43 3.08l-2.1-.93c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L7 8.66v2.29l-1.88 4.64a1.75 1.75 0 0 0 3.25 1.32l.08-.22a5.46 5.46 0 0 1-.42-1.62l-.59 1.46a.75.75 0 1 1-1.39-.56l1.88-4.65a1 1 0 0 0 .07-.37V8.66a1 1 0 0 0-.6-.91L4.45 6.43a.74.74 0 0 1-.37-.99.76.76 0 0 1 1-.38l3.91 1.75a2.5 2.5 0 0 0 2.04 0l3.91-1.75c.38-.17.83 0 1 .38.18.38 0 .82-.37.99L12.6 7.75a1 1 0 0 0-.59.91v.55c.32-.1.66-.16 1-.19v-.36l2.97-1.32c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-2.1.93A2.51 2.51 0 0 0 10 2Zm8 12.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const AccessibilityErrorFilled = ( /*#__PURE__*/createFluentIcon('AccessibilityErrorFilled', "1em", ["M10 6a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM5.47 4.15c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L6.7 8.53c.18.08.3.26.3.46v1.86a.5.5 0 0 1-.04.19l-1.84 4.55a1.75 1.75 0 0 0 3.25 1.32l.08-.22A5.48 5.48 0 0 1 13 9.02V9c0-.2.12-.38.3-.46l2.67-1.19c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-1.28.57c-.24.1-.42.3-.52.52a3 3 0 0 1-5.46 0c-.1-.21-.28-.41-.52-.52l-1.28-.57ZM18 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM13.5 12a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.24Z"]));
export const AccessibilityErrorRegular = ( /*#__PURE__*/createFluentIcon('AccessibilityErrorRegular', "1em", ["M8.5 4.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM10 2a2.5 2.5 0 0 0-2.43 3.08l-2.1-.93c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L7 8.66v2.29l-1.88 4.64a1.75 1.75 0 0 0 3.25 1.32l.08-.22a5.46 5.46 0 0 1-.42-1.62l-.59 1.46a.75.75 0 1 1-1.39-.56l1.88-4.65a1 1 0 0 0 .07-.37V8.66a1 1 0 0 0-.6-.91L4.45 6.43a.74.74 0 0 1-.37-.99.76.76 0 0 1 1-.38l3.91 1.75a2.5 2.5 0 0 0 2.04 0l3.91-1.75c.38-.17.83 0 1 .38.18.38 0 .82-.37.99L12.6 7.75a1 1 0 0 0-.59.91v.55c.32-.1.66-.16 1-.19v-.36l2.97-1.32c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-2.1.93A2.5 2.5 0 0 0 10 2Zm8 12.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM13.5 12a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.24Z"]));
export const AccessibilityMoreFilled = ( /*#__PURE__*/createFluentIcon('AccessibilityMoreFilled', "1em", ["M14.87 15.6c.05.11.08.23.1.35a2.24 2.24 0 0 0-1.97-1.2c-.77 0-1.43.4-1.84 1l-.93-2.3a.25.25 0 0 0-.47 0l-.54 1.33c-.07 0-.14-.03-.22-.03a2.25 2.25 0 0 0-2.02 3.23 1.73 1.73 0 0 1-1.86-2.39l1.84-4.55a.5.5 0 0 0 .04-.19V9a.5.5 0 0 0-.3-.46L4.03 7.34a1.74 1.74 0 0 1-.88-2.31 1.76 1.76 0 0 1 2.32-.88l1.27.57c.25.1.43.3.52.52a3 3 0 0 0 5.47 0c.1-.21.27-.41.52-.52l1.27-.57c.89-.4 1.92 0 2.32.88.4.88 0 1.92-.88 2.31L13.3 8.53a.5.5 0 0 0-.3.46v1.87c0 .07.02.13.04.19l1.84 4.54ZM10 6a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm-1 9.75a1.25 1.25 0 1 0 0 2.5 1.25 1.25 0 0 0 0-2.5Zm4 0a1.25 1.25 0 1 0 0 2.5 1.25 1.25 0 0 0 0-2.5Zm4 0a1.25 1.25 0 1 0 0 2.5 1.25 1.25 0 0 0 0-2.5Z"]));
export const AccessibilityMoreRegular = ( /*#__PURE__*/createFluentIcon('AccessibilityMoreRegular', "1em", ["m9 12.68-.92 2.27c.28-.13.6-.2.92-.2.08 0 .15.03.23.03l.7-1.72c0-.03.01-.04.02-.04L10 13h.04l.03.05 1.1 2.7c.2-.3.46-.55.78-.73L11 12.68c-.37-.9-1.64-.9-2 0Zm7.84-7.65a1.76 1.76 0 0 0-2.31-.88l-2.1.94A2.51 2.51 0 0 0 10 1.99a2.5 2.5 0 0 0-2.43 3.1l-2.1-.94c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L7 8.66v2.29L5.12 15.6a1.75 1.75 0 0 0 1.86 2.38c-.14-.3-.23-.63-.23-.98-.1 0-.2-.02-.29-.05a.75.75 0 0 1-.41-.98l1.88-4.64a1 1 0 0 0 .07-.38V8.66a1 1 0 0 0-.6-.91L4.45 6.43a.74.74 0 0 1-.37-.98.76.76 0 0 1 1-.38L8.98 6.8a2.5 2.5 0 0 0 2.04 0l3.92-1.74c.38-.17.82 0 1 .38.17.37 0 .81-.38.98L12.6 7.75a1 1 0 0 0-.59.91v2.3a1 1 0 0 0 .07.38l1.41 3.48c.65.15 1.19.56 1.5 1.13a1.8 1.8 0 0 0-.1-.35L13 10.96v-2.3l2.97-1.32c.88-.4 1.28-1.43.88-2.3ZM10 6a1.5 1.5 0 1 1 0-3 1.5 1.5 0 0 1 0 3Zm.25 11a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM13 18.25a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Zm4 0a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const AccessibilityQuestionMarkFilled = ( /*#__PURE__*/createFluentIcon('AccessibilityQuestionMarkFilled', "1em", ["M10 6a2 2 0 1 0 0-4 2 2 0 0 0 0 4ZM5.47 4.15c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L6.7 8.53c.18.08.3.26.3.46v1.86a.5.5 0 0 1-.04.19l-1.84 4.55a1.75 1.75 0 0 0 3.25 1.32l.08-.22A5.48 5.48 0 0 1 13 9.02V9c0-.2.12-.38.3-.46l2.67-1.19c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-1.28.57c-.24.1-.42.3-.52.52a3 3 0 0 1-5.46 0c-.1-.21-.28-.41-.52-.52l-1.28-.57ZM18 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.5 1.88a.62.62 0 1 0 0 1.25.62.62 0 0 0 0-1.25Zm0-4.88c-1.05 0-1.86.82-1.85 1.96a.5.5 0 1 0 1-.01c0-.58.36-.95.85-.95.47 0 .85.4.85.95 0 .2-.07.32-.36.55l-.27.21c-.51.4-.72.72-.72 1.29a.5.5 0 0 0 1 .09v-.16c.02-.14.1-.25.35-.44l.28-.22c.5-.4.72-.73.72-1.32 0-1.1-.82-1.95-1.85-1.95Z"]));
export const AccessibilityQuestionMarkRegular = ( /*#__PURE__*/createFluentIcon('AccessibilityQuestionMarkRegular', "1em", ["M8.5 4.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0ZM10 2a2.5 2.5 0 0 0-2.43 3.08l-2.1-.93c-.88-.4-1.92 0-2.32.88-.4.88 0 1.92.88 2.31L7 8.66v2.29l-1.88 4.64a1.75 1.75 0 0 0 3.25 1.32l.08-.22a5.46 5.46 0 0 1-.42-1.62l-.59 1.46a.75.75 0 1 1-1.39-.56l1.88-4.65a1 1 0 0 0 .07-.37V8.66a1 1 0 0 0-.6-.91L4.45 6.43a.74.74 0 0 1-.37-.99.76.76 0 0 1 1-.38l3.91 1.75a2.5 2.5 0 0 0 2.04 0l3.91-1.75c.38-.17.83 0 1 .38.18.38 0 .82-.37.99L12.6 7.75a1 1 0 0 0-.59.91v.55c.32-.1.66-.16 1-.19v-.36l2.97-1.32c.88-.4 1.28-1.43.88-2.31a1.76 1.76 0 0 0-2.32-.88l-2.1.93A2.5 2.5 0 0 0 10 2Zm8 12.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.5 1.88a.62.62 0 1 0 0 1.25.62.62 0 0 0 0-1.25Zm0-4.88c-1.05 0-1.86.82-1.85 1.96a.5.5 0 1 0 1-.01c0-.58.36-.95.85-.95.47 0 .85.4.85.95 0 .2-.07.32-.36.55l-.27.21c-.51.4-.72.72-.72 1.29a.5.5 0 0 0 1 .09v-.16c.02-.14.1-.25.35-.44l.28-.22c.5-.4.72-.73.72-1.32 0-1.1-.82-1.95-1.85-1.95Z"]));
export const AddFilled = ( /*#__PURE__*/createFluentIcon('AddFilled', "1em", ["M10 2.25c.41 0 .75.34.75.75v6.25H17a.75.75 0 0 1 0 1.5h-6.25V17a.75.75 0 0 1-1.5 0v-6.25H3a.75.75 0 0 1 0-1.5h6.25V3c0-.41.34-.75.75-.75Z"]));
export const AddRegular = ( /*#__PURE__*/createFluentIcon('AddRegular', "1em", ["M10 2.5c.28 0 .5.22.5.5v6.5H17a.5.5 0 0 1 0 1h-6.5V17a.5.5 0 0 1-1 0v-6.5H3a.5.5 0 0 1 0-1h6.5V3c0-.28.22-.5.5-.5Z"]));
export const AddCircleColor = ( /*#__PURE__*/createFluentIcon('AddCircleColor', "1em", `<path d="M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Z" fill="url(#ic_fluent_add_circle_20_color__a)"/><path d="M6 10c0-.28.22-.5.5-.5h3v-3a.5.5 0 0 1 1 0v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3A.5.5 0 0 1 6 10Z" fill="url(#ic_fluent_add_circle_20_color__b)"/><defs><linearGradient id="ic_fluent_add_circle_20_color__a" x1="2.57" y1="5" x2="13.61" y2="16.47" gradientUnits="userSpaceOnUse"><stop stop-color="#52D17C"/><stop offset="1" stop-color="#22918B"/></linearGradient><linearGradient id="ic_fluent_add_circle_20_color__b" x1="7.5" y1="6.82" x2="9.95" y2="15.48" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#E3FFD9"/></linearGradient></defs>`, { color: true }));
export const AddCircleFilled = ( /*#__PURE__*/createFluentIcon('AddCircleFilled', "1em", ["M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0ZM6 10c0 .28.22.5.5.5h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3v-3a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0-.5.5Z"]));
export const AddCircleRegular = ( /*#__PURE__*/createFluentIcon('AddCircleRegular', "1em", ["M6 10c0-.28.22-.5.5-.5h3v-3a.5.5 0 0 1 1 0v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3A.5.5 0 0 1 6 10Zm4 8a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-1a7 7 0 1 1 0-14 7 7 0 0 1 0 14Z"]));
export const AddSquareFilled = ( /*#__PURE__*/createFluentIcon('AddSquareFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm7.5.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 1 0 1 0v-3h3a.5.5 0 1 0 0-1h-3v-3Z"]));
export const AddSquareRegular = ( /*#__PURE__*/createFluentIcon('AddSquareRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Zm6.5.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 1 0 1 0v-3h3a.5.5 0 1 0 0-1h-3v-3Z"]));
export const AddSquareMultipleFilled = ( /*#__PURE__*/createFluentIcon('AddSquareMultipleFilled', "1em", ["M16 5.27c.6.34 1 .99 1 1.73v6a4 4 0 0 1-4 4H7a2 2 0 0 1-1.73-1H13a3 3 0 0 0 3-3V5.27ZM15 5a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V5Zm-3 4a.5.5 0 0 1-.5.5h-2v2a.5.5 0 0 1-1 0v-2h-2a.5.5 0 1 1 0-1h2v-2a.5.5 0 1 1 1 0v2h2c.28 0 .5.22.5.5Z"]));
export const AddSquareMultipleRegular = ( /*#__PURE__*/createFluentIcon('AddSquareMultipleRegular', "1em", ["M16 5.27V13a3 3 0 0 1-3 3H5.27c.34.6.99 1 1.73 1h6a4 4 0 0 0 4-4V7a2 2 0 0 0-1-1.73ZM11.5 9.5a.5.5 0 0 0 0-1h-2v-2a.5.5 0 1 0-1 0v2h-2a.5.5 0 0 0 0 1h2v2a.5.5 0 0 0 1 0v-2h2ZM13 3a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h8Zm1 2a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V5Z"]));
export const AddStarburstColor = ( /*#__PURE__*/createFluentIcon('AddStarburstColor', "1em", `<path d="M11.1 1.3a.75.75 0 0 0-1.2 0L8.85 2.65a.5.5 0 0 1-.58.15l-1.6-.65a.75.75 0 0 0-1.03.6l-.24 1.7a.5.5 0 0 1-.42.44l-1.72.23a.75.75 0 0 0-.59 1.03l.65 1.6a.5.5 0 0 1-.15.59L1.79 9.4a.75.75 0 0 0 0 1.18l1.37 1.07a.5.5 0 0 1 .15.58l-.65 1.6c-.18.46.1.96.6 1.03l1.7.24c.23.03.4.2.43.42l.24 1.72c.07.48.57.77 1.03.59l1.6-.65a.5.5 0 0 1 .58.15l1.07 1.37c.3.39.88.39 1.18 0l1.06-1.37a.5.5 0 0 1 .59-.15l1.6.65c.45.18.96-.1 1.03-.6l.23-1.7a.5.5 0 0 1 .43-.43l1.72-.24a.75.75 0 0 0 .59-1.03l-.65-1.6a.5.5 0 0 1 .15-.58l1.37-1.07a.75.75 0 0 0 0-1.18l-1.37-1.06a.5.5 0 0 1-.15-.59l.65-1.6a.75.75 0 0 0-.6-1.03l-1.7-.23a.5.5 0 0 1-.44-.43l-.23-1.72a.75.75 0 0 0-1.03-.59l-1.6.65a.5.5 0 0 1-.59-.15L11.1 1.29Z" fill="url(#ic_fluent_add_starburst_20_color__a)"/><path d="M6.5 10c0-.28.22-.5.5-.5h3v-3a.5.5 0 0 1 1 0v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3H7a.5.5 0 0 1-.5-.5Z" fill="url(#ic_fluent_add_starburst_20_color__b)" fill-opacity=".95"/><defs><radialGradient id="ic_fluent_add_starburst_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-19.58616 -34.63252 33.172 -18.76018 22.15 21.62)"><stop stop-color="#FFC470"/><stop offset=".25" stop-color="#FF835C"/><stop offset=".55" stop-color="#F24A9D"/><stop offset=".81" stop-color="#B339F0"/></radialGradient><linearGradient id="ic_fluent_add_starburst_20_color__b" x1="13.94" y1="16.26" x2="5.55" y2="10.82" gradientUnits="userSpaceOnUse"><stop offset=".02" stop-color="#FFC8D7"/><stop offset=".81" stop-color="#fff"/></linearGradient></defs>`, { color: true }));
export const AddStarburstFilled = ( /*#__PURE__*/createFluentIcon('AddStarburstFilled', "1em", ["M9.4 1.3a.75.75 0 0 1 1.2 0l1.05 1.36a.5.5 0 0 0 .59.15l1.6-.65c.45-.18.96.1 1.03.6l.23 1.7c.04.23.21.4.43.44l1.72.23c.48.07.77.58.59 1.03l-.65 1.6a.5.5 0 0 0 .15.59l1.37 1.06c.39.3.39.88 0 1.18l-1.37 1.07a.5.5 0 0 0-.15.58l.65 1.6c.18.46-.1.96-.6 1.03l-1.7.24a.5.5 0 0 0-.44.42l-.23 1.72a.75.75 0 0 1-1.03.59l-1.6-.65a.5.5 0 0 0-.59.15l-1.06 1.37a.75.75 0 0 1-1.18 0l-1.07-1.37a.5.5 0 0 0-.58-.15l-1.6.65a.75.75 0 0 1-1.03-.6l-.24-1.7a.5.5 0 0 0-.42-.43l-1.72-.24a.75.75 0 0 1-.59-1.03l.65-1.6a.5.5 0 0 0-.15-.58l-1.37-1.07a.75.75 0 0 1 0-1.18l1.37-1.06a.5.5 0 0 0 .15-.59l-.65-1.6a.75.75 0 0 1 .6-1.03l1.7-.23a.5.5 0 0 0 .43-.43l.24-1.72a.75.75 0 0 1 1.03-.59l1.6.65c.2.09.45.02.58-.15l1.07-1.37ZM6.5 9.5a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3v-3a.5.5 0 0 0-1 0v3h-3Z"]));
export const AddStarburstRegular = ( /*#__PURE__*/createFluentIcon('AddStarburstRegular', "1em", ["M6.5 9.5a.5.5 0 1 0 0 1h3v3a.5.5 0 1 0 1 0v-3h3a.5.5 0 1 0 0-1h-3v-3a.5.5 0 1 0-1 0v3h-3Zm4.1-8.2a.75.75 0 0 0-1.2 0L8.35 2.65a.5.5 0 0 1-.58.15l-1.6-.65a.75.75 0 0 0-1.03.6l-.24 1.7a.5.5 0 0 1-.42.44l-1.72.23a.75.75 0 0 0-.6 1.03l.66 1.6a.5.5 0 0 1-.15.59L1.29 9.4a.75.75 0 0 0 0 1.18l1.37 1.07a.5.5 0 0 1 .15.58l-.65 1.6c-.18.46.1.96.6 1.03l1.7.24c.23.03.4.2.43.42l.24 1.72c.07.48.57.77 1.03.59l1.6-.65a.5.5 0 0 1 .58.15l1.07 1.37c.3.39.88.39 1.18 0l1.06-1.37a.5.5 0 0 1 .59-.15l1.6.65c.45.18.96-.1 1.03-.6l.23-1.7a.5.5 0 0 1 .43-.43l1.72-.24a.75.75 0 0 0 .59-1.03l-.65-1.6a.5.5 0 0 1 .15-.58l1.37-1.07a.75.75 0 0 0 0-1.18l-1.37-1.06a.5.5 0 0 1-.15-.59l.65-1.6a.75.75 0 0 0-.6-1.03l-1.71-.23a.5.5 0 0 1-.43-.43l-.23-1.72a.75.75 0 0 0-1.03-.59l-1.6.65a.5.5 0 0 1-.59-.15L10.6 1.29ZM9.12 3.26 10 2.16l.86 1.11a1.5 1.5 0 0 0 1.75.47l1.31-.53.2 1.4c.08.66.6 1.18 1.27 1.28l1.4.19-.53 1.3a1.5 1.5 0 0 0 .47 1.75l1.11.87-1.11.87a1.5 1.5 0 0 0-.47 1.75l.53 1.3-1.4.2a1.5 1.5 0 0 0-1.28 1.28l-.19 1.4-1.3-.54a1.5 1.5 0 0 0-1.76.47L10 17.84l-.87-1.11a1.5 1.5 0 0 0-1.75-.47l-1.3.53-.2-1.4a1.5 1.5 0 0 0-1.28-1.28l-1.4-.19.54-1.3a1.5 1.5 0 0 0-.47-1.75L2.16 10l1.1-.87a1.5 1.5 0 0 0 .48-1.74L3.2 6.08l1.4-.2a1.5 1.5 0 0 0 1.27-1.27l.2-1.4 1.3.53a1.5 1.5 0 0 0 1.75-.47Z"]));
export const AddSubtractCircleFilled = ( /*#__PURE__*/createFluentIcon('AddSubtractCircleFilled', "1em", ["M11.5 12a.5.5 0 1 0 0 1h3a.5.5 0 0 0 0-1h-3ZM10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-1a6.97 6.97 0 0 1-4.58-1.7l9.87-9.88A7 7 0 0 1 10 17ZM5.5 7c0-.28.22-.5.5-.5h1v-1a.5.5 0 0 1 1 0v1h1a.5.5 0 1 1 0 1H8v1a.5.5 0 0 1-1 0v-1H6a.5.5 0 0 1-.5-.5Z"]));
export const AddSubtractCircleRegular = ( /*#__PURE__*/createFluentIcon('AddSubtractCircleRegular', "1em", ["M11 12.5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm-3-7a.5.5 0 0 0-1 0v1H6a.5.5 0 1 0 0 1h1v1a.5.5 0 0 0 1 0v-1h1a.5.5 0 1 0 0-1H8v-1ZM10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-1a6.97 6.97 0 0 1-4.58-1.7l9.87-9.88A7 7 0 0 1 10 17Zm-5.3-2.42a7 7 0 0 1 9.87-9.87l-9.86 9.87Z"]));
export const AgentsColor = ( /*#__PURE__*/createFluentIcon('AgentsColor', "1em", `<path d="M13.18 2H10.5C8.77 7.02 6.82 12.62 6.82 18h6.49c.6 0 1.16-.31 1.48-.82l4-6.42c.29-.47.29-1.05 0-1.52l-3.8-6.11A2 2 0 0 0 13.17 2Z" fill="url(#ic_fluent_agents_20_color__a)"/><path d="M13.18 2H10.5C8.77 7.02 6.82 12.62 6.82 18h6.49c.6 0 1.16-.31 1.48-.82l4-6.42c.29-.47.29-1.05 0-1.52l-3.8-6.11A2 2 0 0 0 13.17 2Z" fill="url(#ic_fluent_agents_20_color__b)" fill-opacity=".5"/><path d="M13.25 2H6.68c-.6 0-1.15.3-1.47.82L1.27 9.07c-.36.57-.36 1.3 0 1.86l3.86 6.13c.35.56.96.91 1.62.94h.07a2 2 0 0 0 1.97-1.66l2.4-12.39A2 2 0 0 1 13.24 2Z" fill="url(#ic_fluent_agents_20_color__c)"/><path d="M13.25 2H6.68c-.6 0-1.15.3-1.47.82L1.27 9.07c-.36.57-.36 1.3 0 1.86l3.86 6.13c.35.56.96.91 1.62.94h.07a2 2 0 0 0 1.97-1.66l2.4-12.39A2 2 0 0 1 13.24 2Z" fill="url(#ic_fluent_agents_20_color__d)" fill-opacity=".4"/><defs><radialGradient id="ic_fluent_agents_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-87.88 17.7 4.84) scale(23.3302 18.6978)"><stop stop-color="#FFC470"/><stop offset=".25" stop-color="#FF835C"/><stop offset=".58" stop-color="#F24A9D"/><stop offset=".87" stop-color="#B339F0"/><stop offset="1" stop-color="#C354FF"/></radialGradient><radialGradient id="ic_fluent_agents_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-9.9932 -9.83058 9.94854 -10.1131 11.78 16.15)"><stop offset=".71" stop-color="#FFB357" stop-opacity="0"/><stop offset=".94" stop-color="#FFB357"/></radialGradient><radialGradient id="ic_fluent_agents_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-160.25 10.24 6.67) scale(22.9945 19.4416)"><stop offset=".22" stop-color="#4E46E2"/><stop offset=".58" stop-color="#625DF6"/><stop offset=".95" stop-color="#E37DFF"/></radialGradient><linearGradient id="ic_fluent_agents_20_color__d" x1="4.82" y1="8.63" x2="10.25" y2="9.91" gradientUnits="userSpaceOnUse"><stop stop-color="#7563F7" stop-opacity="0"/><stop offset=".99" stop-color="#4916AE"/></linearGradient></defs>`, { color: true }));
export const AgentsFilled = ( /*#__PURE__*/createFluentIcon('AgentsFilled', "1em", ["M9.08 18a3 3 0 0 0 .67-1.24l3.4-12.75V4c.07-.2 0-.53-.31-.6-.36-.09-.55.09-.64.28a1 1 0 0 0-.02.07L8.78 16.5a2.02 2.02 0 0 1-3.65.56l-3.86-6.13a1.75 1.75 0 0 1 0-1.86L5.2 2.82C5.53 2.3 6.09 2 6.69 2h4.23a3 3 0 0 0-.67 1.24l-3.4 12.75V16c-.07.2 0 .53.31.6.36.09.55-.09.63-.28a1 1 0 0 0 .03-.07l3.4-12.76a2.01 2.01 0 0 1 3.64-.55l3.93 6.3c.29.47.29 1.05 0 1.52l-4 6.42c-.32.5-.88.82-1.48.82H9.08Z"]));
export const AgentsRegular = ( /*#__PURE__*/createFluentIcon('AgentsRegular', "1em", ["M5.2 2.82C5.54 2.3 6.1 2 6.7 2H9.5a.5.5 0 0 1 0 1H6.69c-.26 0-.5.13-.63.35L2.1 9.6a.75.75 0 0 0 0 .8l3.87 6.13a1.02 1.02 0 0 0 1.84-.28l3.4-12.76a2.01 2.01 0 0 1 3.65-.54l3.92 6.3c.29.46.29 1.04 0 1.5l-4 6.43c-.32.5-.88.82-1.48.82H10.5a.5.5 0 0 1 0-1h2.8c.27 0 .5-.13.64-.35l4-6.42a.43.43 0 0 0 0-.46l-3.92-6.3a1.01 1.01 0 0 0-1.84.28L8.78 16.5a2.02 2.02 0 0 1-3.65.56l-3.86-6.13a1.75 1.75 0 0 1 0-1.86L5.2 2.82Z"]));
export const AgentsAddFilled = ( /*#__PURE__*/createFluentIcon('AgentsAddFilled', "1em", ["M15.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm-4.58-8a3 3 0 0 0-.67 1.24l-3.4 12.75V16c-.07.2 0 .53.3.6.36.09.56-.09.64-.28l.03-.07 3.4-12.76a2.01 2.01 0 0 1 3.64-.55l3.93 6.3c.19.3.25.66.19 1a5.48 5.48 0 0 0-7.68.72L13.15 4V4c.07-.2 0-.53-.31-.6-.36-.09-.56.09-.64.28l-.02.07-3.4 12.75a2.02 2.02 0 0 1-3.65.56l-3.86-6.13a1.75 1.75 0 0 1 0-1.86L5.2 2.82C5.53 2.3 6.09 2 6.69 2h4.23Zm4.58 10a.5.5 0 0 0-.5.5V14h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H16v-1.5a.5.5 0 0 0-.5-.5Z"]));
export const AgentsAddRegular = ( /*#__PURE__*/createFluentIcon('AgentsAddRegular', "1em", ["M15.5 10a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm-6-8a.5.5 0 0 1 0 1H6.69c-.26 0-.5.13-.64.35L2.11 9.6a.75.75 0 0 0 0 .8l3.87 6.13a1.02 1.02 0 0 0 1.84-.28l3.4-12.76a2.01 2.01 0 0 1 3.65-.54l3.92 6.3c.19.3.25.65.19.99a5.5 5.5 0 0 0-1.22-.75l-3.74-6.01a1.01 1.01 0 0 0-1.84.27L8.78 16.5a2.02 2.02 0 0 1-3.65.56l-3.86-6.13a1.75 1.75 0 0 1 0-1.86L5.2 2.82C5.53 2.3 6.09 2 6.69 2h2.8Zm6 10a.5.5 0 0 0-.5.5V14h-1.5a.5.5 0 0 0 0 1H15v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H16v-1.5a.5.5 0 0 0-.5-.5Z"]));
export const AirplaneFilled = ( /*#__PURE__*/createFluentIcon('AirplaneFilled', "1em", ["M9 2c.6 0 1.16.36 1.4.92l2.37 5.4 3.23-.2a1.88 1.88 0 0 1 2 1.76V10c0 1.04-.84 1.88-1.88 1.88H16l-3.23-.2-2.37 5.4c-.24.56-.8.92-1.4.92a.88.88 0 0 1-.88-.88v-.06l.7-5.63-2.46-.16-1.14 2.28a.8.8 0 0 1-.72.45.5.5 0 0 1-.5-.5v-2.38l-1.06-.06a1 1 0 0 1-.94-1v-.12a1 1 0 0 1 .94-1L4 8.88V6.5c0-.28.22-.5.5-.5.3 0 .59.17.72.45l1.14 2.28 2.46-.16L8.12 3A.88.88 0 0 1 9 2Z"]));
export const AirplaneRegular = ( /*#__PURE__*/createFluentIcon('AirplaneRegular', "1em", ["M8.78 8.29 8.1 2.81a1.16 1.16 0 0 1 1-1.3h.08l.17-.01c.6 0 1.13.35 1.37.9l2.51 5.74 2.75-.09c1.03-.03 1.9.73 2 1.74l.02.15V10c0 1.08-.87 1.95-1.96 1.95l-2.8-.1-2.52 5.75c-.24.55-.78.9-1.37.9h-.1a1.16 1.16 0 0 1-1.15-1.3l.68-5.5-2.14-.06-.96 1.67c-.24.43-.7.69-1.18.69a1 1 0 0 1-1-1v-1.47h-.16a1.53 1.53 0 0 1 0-3.05l.16-.01V7a1 1 0 0 1 1-1c.49 0 .94.26 1.18.69l.96 1.67 2.14-.07Zm.57-5.79h-.12a.16.16 0 0 0-.14.18l.82 6.57-3.84.13-1.26-2.2A.36.36 0 0 0 4.5 7v2.43l-.98.04a.53.53 0 0 0 0 1.06l.98.04V13h.08c.1-.03.18-.1.23-.18l1.26-2.2 3.84.13-.82 6.59c0 .09.07.16.16.16h.1a.5.5 0 0 0 .45-.3l2.79-6.36 3.46.11c.52 0 .95-.42.95-.95v-.03a.95.95 0 0 0-.98-.92l-3.43.11L9.8 2.8a.5.5 0 0 0-.45-.3Z"]));
export const AirplaneLandingFilled = ( /*#__PURE__*/createFluentIcon('AirplaneLandingFilled', "1em", ["m11.88 6-1.03-2.15C10.16 2.41 8 2.91 8 4.5v.74l2.77.76h1.11Zm-1.11 1a1 1 0 0 1-.27-.04L6 5.74V4.2c0-1.22-1.61-1.66-2.23-.6L2.24 6.19c-.57.96-.1 2.2.96 2.55l3.42 1.12-1.68 1.52c-1.17 1.08-.08 3 1.45 2.55l6.6-1.99 3.04 1A1.5 1.5 0 0 0 18 11.5V11a4 4 0 0 0-4-4h-3.23ZM2 17.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Z"]));
export const AirplaneLandingRegular = ( /*#__PURE__*/createFluentIcon('AirplaneLandingRegular', "1em", ["m12.36 7-1.5-3.15C10.15 2.41 8 2.91 8 4.5v1.78l-2-.54V4.2c0-1.22-1.61-1.66-2.23-.6L2.24 6.19c-.57.96-.1 2.2.96 2.55l3.42 1.12-1.68 1.52c-1.17 1.08-.08 3 1.45 2.55l6.6-1.99 3.04 1A1.5 1.5 0 0 0 18 11.5V11a4 4 0 0 0-4-4h-1.64Zm-1.1 0h-.5a1 1 0 0 1-.26-.04L9 6.56V4.5c0-.53.72-.7.95-.21L11.25 7ZM2 17.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm11.59-6.41a2 2 0 0 0-1.18-.01L6.1 12.97c-.51.15-.87-.49-.48-.85l1.67-1.53a1 1 0 0 0-.36-1.68L3.52 7.79a.75.75 0 0 1-.42-1.1L4.63 4.1c.1-.17.37-.1.37.1v1.92c0 .22.15.42.37.48l4.87 1.33a2 2 0 0 0 .53.07H14a3 3 0 0 1 3 3v.51a.5.5 0 0 1-.66.48l-2.39-.79-.36-.11Z"]));
export const AirplaneTakeOffFilled = ( /*#__PURE__*/createFluentIcon('AirplaneTakeOffFilled', "1em", ["m11.68 5.16-.38.33c-.23.21-.48.38-.74.46L4.76 7.9l-.6-1.23a1.19 1.19 0 0 0-.24-.34c-.62-.6-1.74-.27-1.9.62L2 7.16v2.99c0 1.2 1.18 2.04 2.32 1.65l3.02-1.04-.3 1.46c-.3 1.56 1.7 2.47 2.66 1.21l3.1-4 4.18-1.35c.84-.27 1.33-1.28.74-2.1-.52-.7-1.43-1.68-2.67-1.92a2.98 2.98 0 0 0-.88-.04 4.9 4.9 0 0 0-2.5 1.14Zm-2.57.22L5.38 6.62l-.04-.05a1.6 1.6 0 0 1 2.17-2.29l1.6 1.1ZM2.5 17a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z"]));
export const AirplaneTakeOffRegular = ( /*#__PURE__*/createFluentIcon('AirplaneTakeOffRegular', "1em", ["M14.5 4c-1.41-.01-2.63.96-3.2 1.49-.23.21-.48.38-.74.46l-.41.14L7.5 4.28a1.6 1.6 0 0 0-2.17 2.3l.7.88-1.28.43-.6-1.23C3.65 5.57 2 5.95 2 7.16v2.99c0 1.2 1.18 2.04 2.32 1.65l3.02-1.04-.3 1.46c-.3 1.56 1.7 2.47 2.66 1.21l3.1-4 4.18-1.35c.84-.27 1.33-1.28.74-2.1-.6-.8-1.7-1.97-3.22-1.98ZM7.04 7.13l-.9-1.17a.6.6 0 0 1 .8-.86L8.96 6.5l-1.92.64Zm4.94-.91c.55-.51 1.51-1.23 2.52-1.22 1 0 1.85.8 2.41 1.58.07.1.08.2.04.3-.04.1-.13.2-.28.25l-4.32 1.4a.5.5 0 0 0-.25.16l-3.19 4.13c-.32.42-.99.12-.88-.4l.29-1.47a1 1 0 0 0-1.3-1.14l-3.03 1.04c-.48.17-.99-.19-.99-.7V7.16c0-.05.02-.08.03-.1a.15.15 0 0 1 .08-.04l.1.01.06.07.78 1.62c.1.22.37.33.6.25l6.23-2.07c.43-.14.8-.4 1.1-.68ZM2.5 17a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z"]));
export const AlbumFilled = ( /*#__PURE__*/createFluentIcon('AlbumFilled', "1em", ["M2 6c0-1.1.9-2 2-2v12a2 2 0 0 1-2-2V6Zm7 2.5c0-.28.22-.5.5-.5h4c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5h-4a.5.5 0 0 1-.5-.5v-1ZM5 16V4h11a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H5Zm4.5-9C8.67 7 8 7.67 8 8.5v1c0 .83.67 1.5 1.5 1.5h4c.83 0 1.5-.67 1.5-1.5v-1c0-.83-.67-1.5-1.5-1.5h-4Z"], { flipInRtl: true }));
export const AlbumRegular = ( /*#__PURE__*/createFluentIcon('AlbumRegular', "1em", ["M8 8.5C8 7.67 8.67 7 9.5 7h4c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 8 9.5v-1ZM9.5 8a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-4ZM2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6Zm4 9h10a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6v10ZM5 5H4a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h1V5Z"], { flipInRtl: true }));
export const AlbumAddFilled = ( /*#__PURE__*/createFluentIcon('AlbumAddFilled', "1em", ["M4 4a2 2 0 0 0-2 2v3.26A5.49 5.49 0 0 1 4 8.2V4Zm12 12h-5.6a5.48 5.48 0 0 0 0-5h3.1c.83 0 1.5-.67 1.5-1.5v-1c0-.83-.67-1.5-1.5-1.5h-4C8.67 7 8 7.67 8 8.5v.1a5.48 5.48 0 0 0-3-.58V4h11a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2Zm-2.5-6H9.74A5.53 5.53 0 0 0 9 9.26V8.5c0-.28.22-.5.5-.5h4c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5ZM10 13.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V13H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V14h1.5a.5.5 0 0 0 0-1H6v-1.5Z"], { flipInRtl: true }));
export const AlbumAddRegular = ( /*#__PURE__*/createFluentIcon('AlbumAddRegular', "1em", ["M2 6c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-5.6c.16-.32.3-.65.4-1H16a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6v3.02a5.57 5.57 0 0 0-1 0V5H4a1 1 0 0 0-1 1v2.6c-.36.18-.7.4-1 .66V6Zm11.5 5h-3.1a5.5 5.5 0 0 0-.66-1h3.76a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0-.5.5v.76a5.5 5.5 0 0 0-1-.66v-.1C8 7.67 8.67 7 9.5 7h4c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5ZM10 13.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V13H3.5a.5.5 0 0 0 0 1H5v1.5a.5.5 0 0 0 1 0V14h1.5a.5.5 0 0 0 0-1H6v-1.5Z"], { flipInRtl: true }));
export const AlertColor = ( /*#__PURE__*/createFluentIcon('AlertColor', "1em", `<path d="M13 15a3 3 0 1 1-6.01 0 3 3 0 0 1 6 0Z" fill="url(#ic_fluent_alert_20_color__a)"/><path d="M9.99 2a5.92 5.92 0 0 1 5.98 5.36l.02.22V11.4l.95 2.6.03.08.01.09.01.09c0 .31-.2.59-.52.7l-.12.04H3.74a.75.75 0 0 1-.74-.76v-.11l.04-.13.95-2.59V7.57A5.9 5.9 0 0 1 10 2Z" fill="url(#ic_fluent_alert_20_color__b)"/><defs><linearGradient id="ic_fluent_alert_20_color__a" x1="10.01" y1="14.5" x2="10.01" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#EB4824"/><stop offset="1" stop-color="#FFCD0F" stop-opacity=".99"/></linearGradient><linearGradient id="ic_fluent_alert_20_color__b" x1="17.01" y1="15" x2="4.51" y2="4" gradientUnits="userSpaceOnUse"><stop stop-color="#FF6F47"/><stop offset="1" stop-color="#FFCD0F"/></linearGradient></defs>`, { color: true }));
export const AlertFilled = ( /*#__PURE__*/createFluentIcon('AlertFilled', "1em", ["M12.45 16a2.5 2.5 0 0 1-4.9 0h4.9ZM10 2a5.92 5.92 0 0 1 5.98 5.36l.02.22V11.4l.95 2.6.03.08.01.09v.08c0 .32-.19.6-.51.71l-.12.03-.11.01H3.75a.75.75 0 0 1-.74-.76v-.12l.04-.12L4 11.4V7.57A5.9 5.9 0 0 1 10 2Z"]));
export const AlertRegular = ( /*#__PURE__*/createFluentIcon('AlertRegular', "1em", ["M10 2a5.92 5.92 0 0 1 5.98 5.36l.02.22V11.4l.92 2.22a1 1 0 0 1 .06.17l.01.08.01.13a1 1 0 0 1-.75.97l-.11.02L16 15h-3.5v.17a2.5 2.5 0 0 1-5 0V15H4a1 1 0 0 1-.26-.03l-.13-.04a1 1 0 0 1-.6-1.05l.02-.13.05-.13L4 11.4V7.57A5.9 5.9 0 0 1 10 2Zm1.5 13h-3v.15a1.5 1.5 0 0 0 1.36 1.34l.14.01c.78 0 1.42-.6 1.5-1.36V15ZM10 3a4.9 4.9 0 0 0-4.98 4.38L5 7.6V11.5l-.04.2L4 14h12l-.96-2.3-.04-.2V7.61A4.9 4.9 0 0 0 10 3Z"]));
export const AlertBadgeColor = ( /*#__PURE__*/createFluentIcon('AlertBadgeColor', "1em", `<path d="M13 15a3 3 0 1 1-6.01 0 3 3 0 0 1 6 0Z" fill="url(#ic_fluent_alert_badge_20_color__a)"/><path d="M9.99 2a5.92 5.92 0 0 1 5.98 5.36l.02.22V11.4l.95 2.6.03.08.01.09.01.09c0 .31-.2.59-.52.7l-.12.04H3.74a.75.75 0 0 1-.74-.76v-.11l.04-.13.95-2.59V7.57A5.9 5.9 0 0 1 10 2Z" fill="url(#ic_fluent_alert_badge_20_color__b)"/><path d="M9.99 2a5.92 5.92 0 0 1 5.98 5.36l.02.22V11.4l.95 2.6.03.08.01.09.01.09c0 .31-.2.59-.52.7l-.12.04H3.74a.75.75 0 0 1-.74-.76v-.11l.04-.13.95-2.59V7.57A5.9 5.9 0 0 1 10 2Z" fill="url(#ic_fluent_alert_badge_20_color__c)" fill-opacity=".2"/><path d="M15 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z" fill="url(#ic_fluent_alert_badge_20_color__d)"/><defs><linearGradient id="ic_fluent_alert_badge_20_color__a" x1="10.01" y1="14.5" x2="10.01" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#EB4824"/><stop offset="1" stop-color="#FFCD0F" stop-opacity=".99"/></linearGradient><linearGradient id="ic_fluent_alert_badge_20_color__b" x1="17.01" y1="15" x2="4.51" y2="4" gradientUnits="userSpaceOnUse"><stop stop-color="#FF6F47"/><stop offset="1" stop-color="#FFCD0F"/></linearGradient><linearGradient id="ic_fluent_alert_badge_20_color__d" x1="13.14" y1="3.75" x2="16.29" y2="6.25" gradientUnits="userSpaceOnUse"><stop stop-color="#F83F54"/><stop offset="1" stop-color="#B91D6B"/></linearGradient><radialGradient id="ic_fluent_alert_badge_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-3.99997 5.50003 -5.91658 -4.3029 15 5)"><stop offset=".25" stop-color="#FFE994"/><stop offset=".65" stop-color="#FFE994" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const AlertBadgeFilled = ( /*#__PURE__*/createFluentIcon('AlertBadgeFilled', "1em", ["M12.45 16a2.5 2.5 0 0 1-4.9 0h4.9ZM10 2c1.09 0 2.11.28 3 .77a3 3 0 0 0 3 5.06v3.58l.95 2.59.03.08.01.09v.08c0 .32-.19.6-.51.71l-.12.03-.11.01H3.75a.75.75 0 0 1-.74-.76v-.12l.04-.12L4 11.4V7.57A5.9 5.9 0 0 1 10 2Zm5 5a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"]));
export const AlertBadgeRegular = ( /*#__PURE__*/createFluentIcon('AlertBadgeRegular', "1em", ["M10 2c1.09 0 2.11.28 3 .77-.26.23-.47.5-.64.8A5.16 5.16 0 0 0 10 3a4.9 4.9 0 0 0-4.98 4.38L5 7.6V11.5l-.04.2L4 14h12l-.96-2.3-.04-.2V8a3 3 0 0 0 1-.17v3.57l.92 2.22a1 1 0 0 1 .06.17l.01.08.01.13a1 1 0 0 1-.75.97l-.11.02L16 15h-3.5v.17a2.5 2.5 0 0 1-5 0V15H4a1 1 0 0 1-.26-.03l-.13-.04a1 1 0 0 1-.6-1.05l.02-.13.05-.13L4 11.4V7.57A5.9 5.9 0 0 1 10 2Zm1.5 13h-3v.15a1.5 1.5 0 0 0 1.36 1.34l.14.01c.78 0 1.42-.6 1.5-1.36V15Zm1.7-10.89A2 2 0 0 1 15 3a2 2 0 1 1-1.8 1.11Z"]));
export const AlertOffFilled = ( /*#__PURE__*/createFluentIcon('AlertOffFilled', "1em", ["M4 7.57c.04-.82.24-1.59.58-2.28L2.15 2.85a.5.5 0 1 1 .7-.7l15 15a.5.5 0 0 1-.7.7L14.3 15H3.75a.75.75 0 0 1-.74-.76v-.12l.04-.12L4 11.4V7.57Zm13 6.68c0 .18-.06.34-.16.46L5.79 3.66A6.1 6.1 0 0 1 9.99 2a5.92 5.92 0 0 1 6 5.36v.22l.01.22v3.6l.95 2.6.03.08.01.09v.08ZM12.45 16a2.5 2.5 0 0 1-4.9 0h4.9Z"]));
export const AlertOffRegular = ( /*#__PURE__*/createFluentIcon('AlertOffRegular', "1em", ["M4 7.57c.04-.82.24-1.59.58-2.28L2.15 2.85a.5.5 0 1 1 .7-.7l15 15a.5.5 0 0 1-.7.7L14.3 15h-1.8v.17a2.5 2.5 0 0 1-5 0V15H4a1 1 0 0 1-.26-.03l-.13-.04a1 1 0 0 1-.6-1.05l.02-.13.05-.13L4 11.4V7.57ZM13.3 14 5.34 6.05a4.6 4.6 0 0 0-.32 1.33L5 7.6V11.5l-.04.2L4 14h9.3Zm-1.8 1h-3v.14a1.5 1.5 0 0 0 1.36 1.34l.14.01c.78 0 1.42-.6 1.5-1.36V15Zm3.54-3.32.87 2.1.86.85c.15-.17.23-.4.23-.64v-.13l-.02-.08a1 1 0 0 0-.06-.17L16 11.4V7.58l-.02-.22A5.92 5.92 0 0 0 10 2a6.1 6.1 0 0 0-4.21 1.66l.7.71A5.1 5.1 0 0 1 10 3a4.9 4.9 0 0 1 5 4.6l.01.21v3.69l.04.2Z"]));
export const AlertOnFilled = ( /*#__PURE__*/createFluentIcon('AlertOnFilled', "1em", ["M1.8 2.1a.5.5 0 1 0-.6.8l2 1.5a.5.5 0 1 0 .6-.8l-2-1.5ZM1 7a.5.5 0 0 0 0 1h1.5a.5.5 0 0 0 0-1H1Zm11.45 9a2.5 2.5 0 0 1-4.9 0h4.9ZM10 2a5.92 5.92 0 0 1 5.98 5.35l.02.23V11.4l.95 2.6.03.08.01.09v.08c0 .32-.19.6-.51.71l-.12.03-.11.01H3.75a.75.75 0 0 1-.74-.76v-.12l.04-.13.95-2.58V7.57A5.9 5.9 0 0 1 10 2Zm8.9.2a.5.5 0 0 0-.7-.1l-2 1.5a.5.5 0 0 0 .6.8l2-1.5a.5.5 0 0 0 .1-.7Zm.6 5.3A.5.5 0 0 0 19 7h-1.5a.5.5 0 0 0 0 1H19a.5.5 0 0 0 .5-.5Z"]));
export const AlertOnRegular = ( /*#__PURE__*/createFluentIcon('AlertOnRegular', "1em", ["M1.8 2.1a.5.5 0 1 0-.6.8l2 1.5a.5.5 0 1 0 .6-.8l-2-1.5ZM1 7a.5.5 0 0 0 0 1h1.5a.5.5 0 0 0 0-1H1Zm9-5a5.92 5.92 0 0 1 5.98 5.35l.02.23V11.4l.92 2.22a1 1 0 0 1 .06.17l.01.08.01.13a1 1 0 0 1-.75.97l-.11.02L16 15h-3.5v.16a2.5 2.5 0 0 1-5 0V15H4a1 1 0 0 1-.26-.03l-.13-.04a1 1 0 0 1-.6-1.05l.02-.13.05-.13L4 11.4V7.57A5.9 5.9 0 0 1 10 2Zm1.5 13h-3v.14a1.5 1.5 0 0 0 1.36 1.35l.14.01c.78 0 1.42-.6 1.5-1.36V15ZM10 3a4.9 4.9 0 0 0-4.98 4.38L5 7.6V11.5l-.04.2L4 14h12l-.96-2.3-.04-.2V7.61A4.9 4.9 0 0 0 10 3Zm8.9-.8a.5.5 0 0 0-.7-.1l-2 1.5a.5.5 0 0 0 .6.8l2-1.5a.5.5 0 0 0 .1-.7Zm.6 5.3A.5.5 0 0 0 19 7h-1.5a.5.5 0 0 0 0 1H19a.5.5 0 0 0 .5-.5Z"]));
export const AlertSnoozeFilled = ( /*#__PURE__*/createFluentIcon('AlertSnoozeFilled', "1em", ["M10 2c.89 0 1.74.19 2.5.52A1.5 1.5 0 0 0 14 4h.63l-1.3 1.83A1.47 1.47 0 0 0 12 5H9.45l-.18.02h-.04a1.5 1.5 0 0 0-.33 2.86l-.58.69-.1.13-.01.04A1.5 1.5 0 0 0 9.5 11h2.54l.18-.02h.05a1.5 1.5 0 0 0 1.09-2.12c.19.09.4.14.64.14h2v2.4l.95 2.6.03.08.01.09v.08c0 .32-.19.6-.51.71l-.12.03-.11.01H3.75a.75.75 0 0 1-.74-.76v-.12l.04-.12L4 11.4V7.57A5.9 5.9 0 0 1 10 2Zm2.45 14a2.5 2.5 0 0 1-4.9 0h4.9ZM14 2h3.5c.37 0 .6.4.45.71l-.04.08L14.96 7h2.54a.5.5 0 0 1 .09 1h-3.6a.5.5 0 0 1-.44-.71l.04-.08L16.54 3H14a.5.5 0 0 1-.1-1h.1ZM9.5 6H12c.4 0 .62.43.43.75l-.05.07L10.57 9H12a.5.5 0 0 1 .09 1h-2.6a.5.5 0 0 1-.42-.75l.04-.07L10.93 7H9.5a.5.5 0 0 1-.1-1h.1Z"]));
export const AlertSnoozeRegular = ( /*#__PURE__*/createFluentIcon('AlertSnoozeRegular', "1em", ["M5 11.5V8.05a5 5 0 0 1 6.36-4.87.5.5 0 1 0 .27-.96A6 6 0 0 0 4 8v3.4l-.92 2.22A1 1 0 0 0 4 15h3.5a2.5 2.5 0 0 0 5 0H16a1 1 0 0 0 .92-1.38L16 11.4V10a.5.5 0 0 0-1 0v1.5c0 .07.01.13.04.2L16 14H4l.96-2.3a.5.5 0 0 0 .04-.2ZM8.5 15h3a1.5 1.5 0 0 1-3 0ZM14 2h3.5c.38 0 .6.4.45.71l-.04.08L14.96 7h2.54a.5.5 0 0 1 .09 1H14a.5.5 0 0 1-.45-.71l.04-.08L16.54 3H14a.5.5 0 0 1-.09-1H14ZM9.5 6H12c.4 0 .62.43.43.75l-.04.07L10.57 9H12a.5.5 0 0 1 .1 1H9.5a.5.5 0 0 1-.43-.75l.05-.07L10.93 7H9.5a.5.5 0 0 1-.09-1h.1Z"]));
export const AlertUrgentColor = ( /*#__PURE__*/createFluentIcon('AlertUrgentColor', "1em", `<path d="M12 16a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z" fill="url(#ic_fluent_alert_urgent_20_color__a)"/><path d="M2.47 12.25a5.16 5.16 0 1 1 9.42-4.2l1.22 2.75 1.67 1.62c.38.37.27 1-.22 1.22l-9.73 4.33a.75.75 0 0 1-1.05-.65L3.68 15l-1.21-2.75Z" fill="url(#ic_fluent_alert_urgent_20_color__b)"/><path d="M13.45 1.5a.75.75 0 1 0-.68 1.34 7.75 7.75 0 0 1 4.22 7.23.75.75 0 0 0 1.5.06l.01-.38c0-3.6-2.06-6.72-5.05-8.25Z" fill="url(#ic_fluent_alert_urgent_20_color__c)"/><path d="M12.92 4.08a.75.75 0 1 0-.82 1.26 5.25 5.25 0 0 1 2.4 4.33.75.75 0 1 0 1.5-.02 6.75 6.75 0 0 0-3.08-5.57Z" fill="url(#ic_fluent_alert_urgent_20_color__d)"/><defs><linearGradient id="ic_fluent_alert_urgent_20_color__a" x1="9.5" y1="15.5" x2="10.67" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#EB4824"/><stop offset="1" stop-color="#FFCD0F" stop-opacity=".99"/></linearGradient><linearGradient id="ic_fluent_alert_urgent_20_color__b" x1="14.5" y1="14.5" x2="3.42" y2="7" gradientUnits="userSpaceOnUse"><stop stop-color="#FF6F47"/><stop offset="1" stop-color="#FFCD0F"/></linearGradient><linearGradient id="ic_fluent_alert_urgent_20_color__c" x1="13.36" y1="2.68" x2="17.58" y2="11.59" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#5B2AB5"/></linearGradient><linearGradient id="ic_fluent_alert_urgent_20_color__d" x1="13.36" y1="2.68" x2="17.58" y2="11.59" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#5B2AB5"/></linearGradient></defs>`, { color: true }));
export const AlertUrgentFilled = ( /*#__PURE__*/createFluentIcon('AlertUrgentFilled', "1em", ["M2.47 12.25a5.16 5.16 0 0 1 9.42-4.2l1.22 2.75 1.67 1.62c.38.37.27 1-.22 1.22l-9.73 4.33a.75.75 0 0 1-1.05-.65L3.68 15l-1.21-2.75Zm6.36 5.09a1.49 1.49 0 0 0 2.68-1.2l-2.68 1.2Zm3.26-12.61a.5.5 0 0 1 .69-.14 6.17 6.17 0 0 1 2.91 4.91.5.5 0 1 1-1 0c0-.13 0-.26-.02-.39a5.17 5.17 0 0 0-2.45-3.69.5.5 0 0 1-.13-.7Zm.49-2.49a.5.5 0 0 1 .68-.16c2.46 1.5 4.58 3.8 4.74 7.9a.5.5 0 0 1-1 .04c-.14-3.68-2-5.7-4.26-7.09a.5.5 0 0 1-.16-.69Z"]));
export const AlertUrgentRegular = ( /*#__PURE__*/createFluentIcon('AlertUrgentRegular', "1em", ["M13.26 2.08a.5.5 0 1 0-.52.85C15 4.31 16.86 6.34 17 10.02a.5.5 0 0 0 1-.04c-.16-4.1-2.28-6.4-4.74-7.9ZM12.1 4.73a.5.5 0 0 1 .69-.14 6.17 6.17 0 0 1 2.91 4.91.5.5 0 0 1-1 0c0-.13 0-.26-.02-.39a5.17 5.17 0 0 0-2.45-3.69.5.5 0 0 1-.13-.7Zm-7.01.7a5.16 5.16 0 0 0-2.61 6.82L3.69 15l.09 2.32c.02.53.57.87 1.05.65l9.73-4.33c.49-.21.6-.85.22-1.22L13.1 10.8 11.9 8.05a5.16 5.16 0 0 0-6.81-2.61Zm-1.7 6.41a4.16 4.16 0 0 1 7.6-3.38l1.3 2.92 1.54 1.5-9.06 4.03-.08-2.14-1.3-2.93Zm7.3 6.04c-.68.3-1.46.05-1.85-.54l2.68-1.2c.19.7-.16 1.44-.83 1.74Z"]));
export const AlignBottomFilled = ( /*#__PURE__*/createFluentIcon('AlignBottomFilled', "1em", ["M2.5 17a.5.5 0 0 1 0-1h15a.5.5 0 0 1 0 1h-15ZM4 13c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v8Zm7 0c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-1a2 2 0 0 0-2 2v5Z"]));
export const AlignBottomRegular = ( /*#__PURE__*/createFluentIcon('AlignBottomRegular', "1em", ["M2 16.5c0 .28.22.5.5.5h15a.5.5 0 0 0 0-1h-15a.5.5 0 0 0-.5.5Zm9-3.5c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-1a2 2 0 0 0-2 2v5Zm2 1a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1h-1Zm-7 1a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6Zm-1-2a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v8Z"]));
export const AlignCenterHorizontalFilled = ( /*#__PURE__*/createFluentIcon('AlignCenterHorizontalFilled', "1em", ["M18 9.5a.5.5 0 0 1-.5.5H16v2a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-2H9v4a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-4H2.5a.5.5 0 0 1 0-1H4V5c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v4h2V7c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v2h1.5c.28 0 .5.22.5.5Z"]));
export const AlignCenterHorizontalRegular = ( /*#__PURE__*/createFluentIcon('AlignCenterHorizontalRegular', "1em", ["M18 9.5a.5.5 0 0 1-.5.5H16v2a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-2H9v4a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-4H2.5a.5.5 0 0 1 0-1H4V5c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v4h2V7c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v2h1.5c.28 0 .5.22.5.5ZM5 14a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v9Zm7-2a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-1a1 1 0 0 0-1 1v5Z"]));
export const AlignCenterVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignCenterVerticalFilled', "1em", ["M10.5 18a.5.5 0 0 1-.5-.5V16H8a2 2 0 0 1-2-2v-1c0-1.1.9-2 2-2h2V9H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h4V2.5a.5.5 0 0 1 1 0V4h4a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-4v2h2a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-2v1.5a.5.5 0 0 1-.5.5Z"]));
export const AlignCenterVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignCenterVerticalRegular', "1em", ["M10.5 18a.5.5 0 0 1-.5-.5V16H8a2 2 0 0 1-2-2v-1c0-1.1.9-2 2-2h2V9H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h4V2.5a.5.5 0 0 1 1 0V4h4a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-4v2h2a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2h-2v1.5a.5.5 0 0 1-.5.5ZM6 5a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h9a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6Zm2 7a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1H8Z"]));
export const AlignEndHorizontalFilled = ( /*#__PURE__*/createFluentIcon('AlignEndHorizontalFilled', "1em", ["M16 17.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z", "M10 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h2a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-2Z"]));
export const AlignEndHorizontalRegular = ( /*#__PURE__*/createFluentIcon('AlignEndHorizontalRegular', "1em", ["M16.5 18a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Z", "M10 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h2a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-2ZM9 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1V6Z"]));
export const AlignEndVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignEndVerticalFilled', "1em", ["M4 10c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-2Z", "M2 16.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Z"]));
export const AlignEndVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignEndVerticalRegular', "1em", ["M6 8a2 2 0 0 0-2 2v2c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2H6Zm-1 2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-2Z", "M2 16.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Z"]));
export const AlignLeftFilled = ( /*#__PURE__*/createFluentIcon('AlignLeftFilled', "1em", ["M3.5 2a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-.5-.5ZM7 11a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h5a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H7ZM5 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6Z"]));
export const AlignLeftRegular = ( /*#__PURE__*/createFluentIcon('AlignLeftRegular', "1em", ["M3.5 2a.5.5 0 0 0-.5.5v15a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-.5-.5ZM7 11a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h5a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H7Zm-1 2a1 1 0 0 1 1-1h5a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1v-1ZM5 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6Zm2-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H7Z"]));
export const AlignRightFilled = ( /*#__PURE__*/createFluentIcon('AlignRightFilled', "1em", ["M16.5 2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM13 11a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-1c0-1.1.9-2 2-2h5Zm2-5a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V6Z"]));
export const AlignRightRegular = ( /*#__PURE__*/createFluentIcon('AlignRightRegular', "1em", ["M16.5 2c.28 0 .5.22.5.5v15a.5.5 0 0 1-1 0v-15c0-.28.22-.5.5-.5ZM13 11a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-1c0-1.1.9-2 2-2h5Zm1 2a1 1 0 0 0-1-1H8a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-1Zm1-7a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V6Zm-2-1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h8Z"]));
export const AlignSpaceAroundHorizontalFilled = ( /*#__PURE__*/createFluentIcon('AlignSpaceAroundHorizontalFilled', "1em", ["M6 4a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H6Zm0 7a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H6Z"]));
export const AlignSpaceAroundHorizontalRegular = ( /*#__PURE__*/createFluentIcon('AlignSpaceAroundHorizontalRegular', "1em", ["M6 4a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H6ZM5 6a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V6Zm1 5a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H6Zm-1 2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-1Z"]));
export const AlignSpaceAroundVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignSpaceAroundVerticalFilled', "1em", ["M7.5 16c.83 0 1.5-.67 1.5-1.5v-9C9 4.67 8.33 4 7.5 4h-2C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h2Zm7 0c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5h-2c-.83 0-1.5.67-1.5 1.5v9c0 .83.67 1.5 1.5 1.5h2Z"]));
export const AlignSpaceAroundVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignSpaceAroundVerticalRegular', "1em", ["M6 4h1a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2ZM5 6v8a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1Zm8-2a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1Zm-1 2a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1V6Z"]));
export const AlignSpaceBetweenHorizontalFilled = ( /*#__PURE__*/createFluentIcon('AlignSpaceBetweenHorizontalFilled', "1em", ["M6 1a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H6Zm0 13a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H6Z"]));
export const AlignSpaceBetweenHorizontalRegular = ( /*#__PURE__*/createFluentIcon('AlignSpaceBetweenHorizontalRegular', "1em", ["M6 1a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H6ZM5 3a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V3Zm1 11a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H6Zm-1 2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-1Z"]));
export const AlignSpaceBetweenVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignSpaceBetweenVerticalFilled', "1em", ["M3 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H3Z", "M16 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1Z"]));
export const AlignSpaceBetweenVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignSpaceBetweenVerticalRegular', "1em", ["M3 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H3ZM2 6a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V6Z", "M16 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1Zm-1 2a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1V6Z"]));
export const AlignSpaceEvenlyHorizontalFilled = ( /*#__PURE__*/createFluentIcon('AlignSpaceEvenlyHorizontalFilled', "1em", ["M4 16a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1Z", "M10 16a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1Z", "M16 16a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1Z"]));
export const AlignSpaceEvenlyHorizontalRegular = ( /*#__PURE__*/createFluentIcon('AlignSpaceEvenlyHorizontalRegular', "1em", ["M3 16a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H3Zm-1-2a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v8Zm7 2a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H9Zm-1-2a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H9a1 1 0 0 0-1 1v8Zm7 2a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-1Zm-1-2a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1h-1a1 1 0 0 0-1 1v8Z"]));
export const AlignSpaceEvenlyVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignSpaceEvenlyVerticalFilled', "1em", ["M6 1a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H6Z", "M6 13a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H6Z", "M6 7a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2H6Z"]));
export const AlignSpaceEvenlyVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignSpaceEvenlyVerticalRegular', "1em", ["M4 3c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V3Zm2-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H6Z", "M4 15c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v1a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-1Zm2-1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-1a1 1 0 0 0-1-1H6Z", "M6 7a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2H6ZM5 9a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V9Z"]));
export const AlignSpaceFitVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignSpaceFitVerticalFilled', "1em", ["M6 1a2 2 0 0 0-2 2v4.5c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H6Z", "M6 10.5a2 2 0 0 0-2 2V17c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-4.5a2 2 0 0 0-2-2H6Z"]));
export const AlignSpaceFitVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignSpaceFitVerticalRegular', "1em", ["M6 1a2 2 0 0 0-2 2v4.5c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H6ZM5 3a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v4.5a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V3Z", "M6 10.5a2 2 0 0 0-2 2V17c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-4.5a2 2 0 0 0-2-2H6Zm-1 2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1V17a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-4.5Z"]));
export const AlignStartHorizontalFilled = ( /*#__PURE__*/createFluentIcon('AlignStartHorizontalFilled', "1em", ["M3 17.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z", "M8 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h2a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H8Z"]));
export const AlignStartHorizontalRegular = ( /*#__PURE__*/createFluentIcon('AlignStartHorizontalRegular', "1em", ["M3.5 18a.5.5 0 0 1-.5-.5v-15a.5.5 0 0 1 1 0v15a.5.5 0 0 1-.5.5Z", "M8 4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h2a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H8ZM7 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V6Z"]));
export const AlignStartVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignStartVerticalFilled', "1em", ["M2.5 3a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z", "M6 6a2 2 0 0 0-2 2v2c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6Z"]));
export const AlignStartVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignStartVerticalRegular', "1em", ["M2 3.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Z", "M6 6a2 2 0 0 0-2 2v2c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H6ZM5 8a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V8Z"]));
export const AlignStraightenFilled = ( /*#__PURE__*/createFluentIcon('AlignStraightenFilled', "1em", ["M5.35 4.52A3 3 0 0 0 3.07 8.1l.1.4h13l-.7-3.15a3 3 0 0 0-3.57-2.28L5.35 4.52Zm-.82 10.13-.7-3.15h13.01l.1.4a3 3 0 0 1-2.29 3.58L8.1 16.93a3 3 0 0 1-3.57-2.28ZM1 10c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2A.5.5 0 0 1 1 10Zm5 0c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2A.5.5 0 0 1 6 10Zm5.5-.5a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-2Zm4.5.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5Z"]));
export const AlignStraightenRegular = ( /*#__PURE__*/createFluentIcon('AlignStraightenRegular', "1em", ["M3.07 8.1a3 3 0 0 1 2.28-3.58l6.55-1.45a3 3 0 0 1 3.58 2.28l.7 3.15h-1.03l-.65-2.93a2 2 0 0 0-2.38-1.52L5.57 5.5a2 2 0 0 0-1.52 2.38l.13.62H3.16l-.09-.4Zm12.75 3.4h1.02l.09.4a3 3 0 0 1-2.28 3.58L8.1 16.93a3 3 0 0 1-3.58-2.28l-.7-3.15h1.03l.65 2.93a2 2 0 0 0 2.39 1.52l6.54-1.45a2 2 0 0 0 1.52-2.38l-.13-.62ZM1 10c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2A.5.5 0 0 1 1 10Zm5 0c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2A.5.5 0 0 1 6 10Zm5.5-.5a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-2Zm4.5.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5Z"]));
export const AlignStretchHorizontalFilled = ( /*#__PURE__*/createFluentIcon('AlignStretchHorizontalFilled', "1em", ["M3 17.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z", "M16 17.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z", "M13 16a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H7a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h6Z", "M15 7a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v1Z"]));
export const AlignStretchHorizontalRegular = ( /*#__PURE__*/createFluentIcon('AlignStretchHorizontalRegular', "1em", ["M3 17.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z", "M16 17.5a.5.5 0 0 0 1 0v-15a.5.5 0 0 0-1 0v15Z", "M13 16a2 2 0 0 0 2-2v-1a2 2 0 0 0-2-2H7a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h6Zm1-2a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1v-1a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v1Z", "M15 7a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v1Zm-2 1a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h6Z"]));
export const AlignStretchVerticalFilled = ( /*#__PURE__*/createFluentIcon('AlignStretchVerticalFilled', "1em", ["M2.5 3a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z", "M2.5 16a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z", "M4 13c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v6Z", "M13 15a2 2 0 0 1-2-2V7c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2h-1Z"]));
export const AlignStretchVerticalRegular = ( /*#__PURE__*/createFluentIcon('AlignStretchVerticalRegular', "1em", ["M2.5 3a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z", "M2.5 16a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1h-15Z", "M4 13c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v6Zm2 1a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1H6Z", "M13 15h1a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2h-1a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2Zm-1-2V7a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v6a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1Z"]));
export const AlignTopFilled = ( /*#__PURE__*/createFluentIcon('AlignTopFilled', "1em", ["M2 3.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5ZM11 7c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2V7ZM6 5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H6Z"]));
export const AlignTopRegular = ( /*#__PURE__*/createFluentIcon('AlignTopRegular', "1em", ["M2 3.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5ZM11 7c0-1.1.9-2 2-2h1a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2V7Zm2-1a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1h-1ZM6 5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H6ZM5 7a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V7Z"]));
export const AnimalCatFilled = ( /*#__PURE__*/createFluentIcon('AnimalCatFilled', "1em", ["M4.97 18H13v-1.5a2.5 2.5 0 0 0-2.5-2.5h-1a.5.5 0 0 1 0-1h1a3.5 3.5 0 0 1 3.5 3.5V18h.25c.47 0 .9-.2 1.21-.5h.04v-.04c.29-.3.47-.72.47-1.18v-7.6a2.12 2.12 0 0 0 1.7-3.24l-.5-.81c-.38-.63-1.06-1-1.8-1h-1.43v-.64a.99.99 0 0 0-.99-.99 2.45 2.45 0 0 0-2.44 2.45V7.9a4.28 4.28 0 0 0-2.95 1.58 6.69 6.69 0 0 0-1.04 1.8c-.23.46-.39.96-.47 1.49l-.01.06A17.04 17.04 0 0 0 5.63 17h-.66a1.97 1.97 0 0 1-1.44-3.32l.92-.98a3.59 3.59 0 0 0-.09-4.99l-.9-.9a.5.5 0 1 0-.7.7l.9.9a2.59 2.59 0 0 1 .06 3.6l-.92 1A2.97 2.97 0 0 0 4.97 18Z"]));
export const AnimalCatRegular = ( /*#__PURE__*/createFluentIcon('AnimalCatRegular', "1em", ["M4.97 18h9.28c.95 0 1.72-.77 1.72-1.72v-7.6a2.12 2.12 0 0 0 1.7-3.24l-.5-.81c-.38-.63-1.06-1-1.8-1h-1.43v-.64a.99.99 0 0 0-.99-.99 2.45 2.45 0 0 0-2.44 2.45V7.9a4.28 4.28 0 0 0-2.95 1.58 8.11 8.11 0 0 0-1.52 3.35A17.04 17.04 0 0 0 5.63 17h-.66a1.97 1.97 0 0 1-1.44-3.32l.92-.98a3.59 3.59 0 0 0-.09-4.99l-.9-.9a.5.5 0 1 0-.7.7l.9.9a2.59 2.59 0 0 1 .06 3.6l-.92 1A2.97 2.97 0 0 0 4.97 18Zm7.97-15v1.12c0 .28.22.5.5.5h1.93c.4 0 .75.2.96.53l.5.81c.46.75-.08 1.72-.95 1.72h-.41a.5.5 0 0 0-.5.5v8.1c0 .4-.32.72-.72.72h-.72v-.72a2.93 2.93 0 0 0-2.93-2.93H9.6a.5.5 0 0 0 0 1h1.01c1.07 0 1.93.87 1.93 1.93V17h-5.9A18 18 0 0 1 7 13.05c.26-1.1.67-2.16 1.32-2.93A3.32 3.32 0 0 1 11 8.88a.5.5 0 0 0 .5-.5V4.45c0-.8.64-1.44 1.43-1.45Z"]));
export const AnimalDogFilled = ( /*#__PURE__*/createFluentIcon('AnimalDogFilled', "1em", ["M12 2c-.33 0-.81.1-1.23.4-.44.31-.77.84-.77 1.6v1.25c0 .13.04.34.16.5.09.12.25.25.59.25.34 0 .5-.13.6-.26a.9.9 0 0 0 .15-.49.5.5 0 1 1 1 0c0 .3-.08.71-.35 1.08-.28.39-.74.67-1.4.67-.32 0-.6-.06-.82-.18a6.5 6.5 0 0 1-1.78 3.83 7.47 7.47 0 0 0-1.89 3.48A9.33 9.33 0 0 0 6 15.95v.08a1.34 1.34 0 0 1-.13.5.82.82 0 0 1-.28.32c-.12.08-.3.15-.59.15a2 2 0 0 1-1.2-3.6.5.5 0 1 0-.6-.8A3 3 0 0 0 5 18h8v-.5c0-.4-.19-1.05-.73-1.33-.19-.1-.44-.17-.77-.17h-1a.5.5 0 0 1 0-1h1c.18 0 .34.01.5.04V12.5a.5.5 0 0 1 1 0v2.95c.79.57 1 1.52 1 2.05v.5h2.5a.5.5 0 0 0 .5-.5c0-.87-.3-1.52-.8-1.95-.36-.29-.78-.45-1.2-.51V7h.5c.83 0 1.5-.67 1.5-1.5V4.28a1 1 0 0 0-.49-.85l-1.78-1.07A2.5 2.5 0 0 0 13.45 2H12Z"]));
export const AnimalDogRegular = ( /*#__PURE__*/createFluentIcon('AnimalDogRegular', "1em", ["M10.77 2.4c.42-.3.9-.4 1.23-.4h1.45c.45 0 .9.12 1.28.36l1.78 1.07c.3.18.49.5.49.85V5.5c0 .83-.67 1.5-1.5 1.5H15v8.04c.42.06.84.22 1.2.51.5.43.8 1.08.8 1.95a.5.5 0 0 1-.5.5H5a3 3 0 0 1-1.8-5.4.5.5 0 0 1 .6.8A2 2 0 0 0 5 17c.29 0 .47-.07.59-.15.12-.08.21-.2.28-.32A1.34 1.34 0 0 0 6 16v-.05a4.69 4.69 0 0 1 .03-.5c.04-.33.1-.8.23-1.32.27-1.05.8-2.4 1.89-3.48C9.99 8.8 10 6.33 10 5.5V4c0-.76.33-1.29.77-1.6Zm.15 4.5a7.51 7.51 0 0 1-2.07 4.45 6.47 6.47 0 0 0-1.61 3.02 8.33 8.33 0 0 0-.24 1.6v.06a1.78 1.78 0 0 1-.03.29 2.34 2.34 0 0 1-.22.68h6.17c-.1-.32-.3-.65-.65-.83-.19-.1-.44-.17-.77-.17h-1a.5.5 0 0 1 0-1h1c.18 0 .34.01.5.04V12.5a.5.5 0 0 1 1 0v2.95c.58.42.85 1.04.95 1.55h2a1.2 1.2 0 0 0-.4-.68A1.64 1.64 0 0 0 14.5 16a.5.5 0 0 1-.5-.5v-9c0-.28.22-.5.5-.5h1a.5.5 0 0 0 .5-.5V4.28l-1.78-1.07a1.5 1.5 0 0 0-.77-.21H12c-.17 0-.44.06-.65.2-.18.14-.35.36-.35.8v1.5c0 .09.03.23.1.33.06.08.16.17.4.17.24 0 .34-.09.4-.17.07-.1.1-.24.1-.33a.5.5 0 0 1 1 0c0 .25-.07.6-.3.92-.24.33-.64.58-1.2.58-.22 0-.4-.04-.58-.1ZM7 16h-.5Z"]));
export const AnimalPawPrintColor = ( /*#__PURE__*/createFluentIcon('AnimalPawPrintColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M4 14a6 6 0 0 1 12 0c0 .99-.5 1.75-1.21 2.25-.7.5-1.6.75-2.48.75H7.69c-.88 0-1.78-.25-2.48-.75A2.72 2.72 0 0 1 4 14Z" fill="url(#ic_fluent_animal_paw_print_20_color__a)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 4.25c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25-.83 2.25-2 2.25-2-1.08-2-2.25ZM3 4.5c-1.17 0-2 1.08-2 2.25S1.83 9 3 9s2-1.08 2-2.25S4.17 4.5 3 4.5Zm12 2.25c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25S18.17 9 17 9s-2-1.08-2-2.25Zm-4.5-2.5c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25-.83 2.25-2 2.25-2-1.08-2-2.25Z" fill="url(#ic_fluent_animal_paw_print_20_color__b)"/><defs><radialGradient id="ic_fluent_animal_paw_print_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 -9 14.4 0 10.5 9.5)"><stop stop-color="#EB4824"/><stop offset="1" stop-color="#FF921F"/></radialGradient><linearGradient id="ic_fluent_animal_paw_print_20_color__a" x1="6.85" y1="9.2" x2="10.78" y2="17.55" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#FF921F"/><stop offset="1" stop-color="#EB4824"/></linearGradient></defs>`, { color: true }));
export const AnimalPawPrintFilled = ( /*#__PURE__*/createFluentIcon('AnimalPawPrintFilled', "1em", ["M5.5 4.25c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25-.83 2.25-2 2.25-2-1.08-2-2.25ZM3 4.5c-1.17 0-2 1.08-2 2.25S1.83 9 3 9s2-1.08 2-2.25S4.17 4.5 3 4.5Zm12 2.25c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25S18.17 9 17 9s-2-1.08-2-2.25Zm-4.5-2.5c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25-.83 2.25-2 2.25-2-1.08-2-2.25ZM4 14a6 6 0 0 1 12 0c0 .99-.5 1.75-1.21 2.25-.7.5-1.6.75-2.48.75H7.69c-.88 0-1.78-.25-2.48-.75A2.72 2.72 0 0 1 4 14Z"]));
export const AnimalPawPrintRegular = ( /*#__PURE__*/createFluentIcon('AnimalPawPrintRegular', "1em", ["M6.5 4.25c0-.77.52-1.25 1-1.25s1 .48 1 1.25-.52 1.25-1 1.25-1-.48-1-1.25ZM7.5 2c-1.17 0-2 1.08-2 2.25s.83 2.25 2 2.25 2-1.08 2-2.25S8.67 2 7.5 2ZM3 5.5c-.48 0-1 .48-1 1.25S2.52 8 3 8s1-.48 1-1.25S3.48 5.5 3 5.5ZM1 6.75c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25S4.17 9 3 9 1 7.92 1 6.75ZM17 5.5c-.48 0-1 .48-1 1.25S16.52 8 17 8s1-.48 1-1.25-.52-1.25-1-1.25Zm-2 1.25c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25S18.17 9 17 9s-2-1.08-2-2.25ZM12.5 3c-.48 0-1 .48-1 1.25s.52 1.25 1 1.25 1-.48 1-1.25S12.98 3 12.5 3Zm-2 1.25c0-1.17.83-2.25 2-2.25s2 1.08 2 2.25-.83 2.25-2 2.25-2-1.08-2-2.25ZM5 14a5 5 0 0 1 10 0c0 .6-.3 1.09-.79 1.44-.5.36-1.2.56-1.9.56H7.69c-.7 0-1.4-.2-1.9-.56-.5-.35-.79-.83-.79-1.44Zm5-6a6 6 0 0 0-6 6c0 .99.5 1.75 1.21 2.25.7.5 1.6.75 2.48.75h4.62c.88 0 1.78-.25 2.48-.75S16 15 16 14a6 6 0 0 0-6-6Z"]));
export const AnimalRabbitFilled = ( /*#__PURE__*/createFluentIcon('AnimalRabbitFilled', "1em", ["m12.68 4.38 4.23 4.23a2.78 2.78 0 0 1-2.6 4.67v.16c0 .86-.7 1.56-1.57 1.56H11v-1.25c0-.54-.28-.98-.67-1.28-.38-.3-.9-.47-1.43-.47H7.5a.5.5 0 1 0 0 1h1.4c.33 0 .62.1.82.26.2.15.28.33.28.49V15H5.56C4.7 15 4 14.3 4 13.44v-2.21A2.12 2.12 0 1 1 6.05 8.3C6.5 8.11 7 8 7.52 8h3.28c.47 0 .92.1 1.33.26l.08-.13c.11-.19.23-.4.38-.55l-1.55-1.56a1.16 1.16 0 1 1 1.64-1.64Z"]));
export const AnimalRabbitRegular = ( /*#__PURE__*/createFluentIcon('AnimalRabbitRegular', "1em", ["M10.51 15.01h2.12c.91 0 1.68-.57 1.99-1.37.88.07 1.79-.23 2.46-.9a3.15 3.15 0 0 0 0-4.45l-4.22-4.22c-.59-.59-1.55-.59-2.14 0-.6.6-.6 1.56 0 2.15l1.34 1.33c-.12.16-.22.33-.3.5a3.55 3.55 0 0 0-.54-.05H7.54c-.33 0-.65.05-.95.13A2.5 2.5 0 1 0 4 11.95v.93c0 1.18.95 2.13 2.12 2.13h4.39Zm1.64-10.23L16.38 9a2.15 2.15 0 0 1-2 3.6l-.56-.13-.06.56c-.07.56-.54.99-1.12.99h-1.62v-.1C11 12.78 9.99 12 8.89 12H7.5a.5.5 0 0 0 0 1h1.39c.69 0 1.12.46 1.12.91v.1H6.12c-.62 0-1.12-.5-1.12-1.13v-1.33A2.55 2.55 0 0 1 7.54 9h3.68c.23 0 .46.03.68.1l.42.11.18-.4c.1-.26.26-.57.47-.79l.5-.48-2.04-2.02a.52.52 0 0 1 0-.74c.2-.2.52-.2.72 0Zm-6.5 3.77a3.55 3.55 0 0 0-1.6 2.38 1.5 1.5 0 1 1 1.6-2.38Z"]));
export const AnimalRabbitOffFilled = ( /*#__PURE__*/createFluentIcon('AnimalRabbitOffFilled', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L7.3 8.01c-.44.02-.86.13-1.25.3A2.12 2.12 0 1 0 4 11.22v2.21C4 14.3 4.7 15 5.56 15H10v-1.25c0-.16-.08-.34-.28-.49-.2-.15-.49-.26-.82-.26H7.5a.5.5 0 0 1 0-1h1.4c.54 0 1.05.17 1.43.47.39.3.67.74.67 1.28V15h1.74c.43 0 .82-.18 1.1-.45l3.3 3.3a.5.5 0 0 0 .71-.7l-15-15Zm14.06 10.39c-.42.42-.94.67-1.48.77l-5.3-5.3h.67c.47 0 .92.09 1.33.25l.08-.13c.11-.19.23-.4.38-.55l-1.55-1.56a1.16 1.16 0 1 1 1.64-1.64l4.23 4.23a2.78 2.78 0 0 1 0 3.93Z"]));
export const AnimalRabbitOffRegular = ( /*#__PURE__*/createFluentIcon('AnimalRabbitOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L7.3 8.01c-.24.02-.48.06-.7.12A2.5 2.5 0 1 0 4 11.95v.93c0 1.18.95 2.13 2.12 2.13h6.51c.47 0 .9-.15 1.26-.41l3.26 3.25a.5.5 0 0 0 .7-.7l-15-15Zm10.32 11.73c-.16.08-.34.13-.54.13h-1.62v-.1C11 12.78 9.99 12 8.89 12H7.5a.5.5 0 0 0 0 1h1.39c.69 0 1.12.46 1.12.91v.1H6.12c-.62 0-1.12-.5-1.12-1.13v-1.33A2.55 2.55 0 0 1 7.54 9h.75l4.88 4.88ZM5.66 8.54a3.55 3.55 0 0 0-1.6 2.38 1.5 1.5 0 1 1 1.6-2.38Zm10.71 3.48c-.44.44-1.02.65-1.6.62l.9.9a3.15 3.15 0 0 0 1.41-5.26l-4.22-4.22c-.59-.59-1.55-.59-2.14 0-.6.6-.6 1.56 0 2.15l1.34 1.33c-.12.16-.22.33-.3.5a3.55 3.55 0 0 0-.54-.05h-1.1l1 1h.1c.23 0 .46.03.68.1l.42.11.18-.4c.1-.26.26-.57.47-.79l.5-.48-2.04-2.02a.52.52 0 0 1 0-.74c.2-.2.52-.2.72 0L16.38 9c.84.84.84 2.2 0 3.04Z"]));
export const AnimalTurtleFilled = ( /*#__PURE__*/createFluentIcon('AnimalTurtleFilled', "1em", ["M9.1 4c-1.47 0-2.5.55-3.21 1.38a7.5 7.5 0 0 0-1.36 2.77L4.27 9H2.5a.5.5 0 0 0-.5.5c0 1.08.5 2.1 1.3 2.63l-.44 1.07a1.31 1.31 0 0 0 1.2 1.81h1.47c.5 0 .97-.3 1.19-.75l.47-1c1.31.18 2.64.18 3.95 0l.48 1c.21.46.67.75 1.18.75h1.45a1.31 1.31 0 0 0 1.21-1.8l-.5-1.21h1.7c.68 0 1.34-.52 1.34-1.26V10c0-1.14-.99-2-2.12-2H13.8a6.9 6.9 0 0 0-1.4-2.63A4.28 4.28 0 0 0 9.1 4Zm5.57 7-.57-2h1.78c.66 0 1.12.49 1.12 1v.74c0 .09-.11.26-.33.26h-2Zm-2.5 2.08c.65-.14 1.3-.32 1.93-.55l.44 1.05a.31.31 0 0 1-.29.43H12.8a.31.31 0 0 1-.28-.18l-.35-.75Zm-7.95-.55c.64.23 1.29.41 1.95.55l-.36.75a.31.31 0 0 1-.28.18H4.07a.3.3 0 0 1-.29-.43l.44-1.05ZM3.97 10l-.34 1.12c-.27-.26-.5-.65-.58-1.12h.92Z"]));
export const AnimalTurtleRegular = ( /*#__PURE__*/createFluentIcon('AnimalTurtleRegular', "1em", ["M9.1 4c-1.47 0-2.5.55-3.21 1.38a7.5 7.5 0 0 0-1.36 2.77L4.27 9H2.5a.5.5 0 0 0-.5.5c0 1.08.5 2.1 1.3 2.63l-.44 1.07a1.31 1.31 0 0 0 1.2 1.81h1.47c.5 0 .97-.3 1.19-.75l.47-1c1.31.18 2.64.18 3.95 0l.48 1c.21.46.67.75 1.18.75h1.45a1.31 1.31 0 0 0 1.21-1.8l-.5-1.21h1.7c.68 0 1.34-.52 1.34-1.26V10c0-1.14-.99-2-2.12-2H13.8a6.9 6.9 0 0 0-1.4-2.63A4.28 4.28 0 0 0 9.1 4Zm5.57 7-.57-2h1.78c.66 0 1.12.49 1.12 1v.74c0 .09-.11.26-.33.26h-2Zm-.57 1.53.44 1.05a.31.31 0 0 1-.29.43H12.8a.31.31 0 0 1-.28-.18l-.35-.75c.65-.14 1.3-.32 1.93-.55Zm-7.93.55-.36.75a.31.31 0 0 1-.28.18H4.07a.31.31 0 0 1-.29-.43l.44-1.05c.64.23 1.29.41 1.95.55Zm-2.54-1.96c-.27-.26-.5-.65-.58-1.12h.92l-.34 1.12ZM5.5 8.44c.27-.91.6-1.77 1.15-2.4A3.03 3.03 0 0 1 9.1 5c1.2 0 2 .43 2.56 1.05.59.63.96 1.5 1.23 2.39l.9 3.13c-3 1.1-6.25 1.1-9.25 0l.95-3.13Z"]));
export const AppFolderFilled = ( /*#__PURE__*/createFluentIcon('AppFolderFilled', "1em", ["M5 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V6Zm0 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-2Zm6-6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1V6Zm0 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1v-2ZM2 5a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v10a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V5Zm3-2a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H5Z"]));
export const AppFolderRegular = ( /*#__PURE__*/createFluentIcon('AppFolderRegular', "1em", ["M5 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V6Zm3 0H6v2h2V6Zm-3 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1v-2Zm3 0H6v2h2v-2Zm4-7a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1h-2Zm0 1h2v2h-2V6Zm-1 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1v-2Zm3 0h-2v2h2v-2ZM5 2a3 3 0 0 0-3 3v10a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3V5a3 3 0 0 0-3-3H5ZM3 5c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Z"]));
export const AppGenericFilled = ( /*#__PURE__*/createFluentIcon('AppGenericFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9ZM4 7h12v7.5c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 4 14.5V7Zm2 1a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1H6Zm0 1h2v5H6V9Zm4.5 1a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM10 8.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const AppGenericRegular = ( /*#__PURE__*/createFluentIcon('AppGenericRegular', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9ZM5.5 4C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5h-9ZM16 7H4v7.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V7ZM5 9a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V9Zm3 0H6v5h2V9Zm2 1.5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm.5-2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const AppRecentFilled = ( /*#__PURE__*/createFluentIcon('AppRecentFilled', "1em", ["M7 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H7ZM2 6c0-1.1.9-2 2-2v12a2 2 0 0 1-2-2V6Zm14 10V4a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2Z"]));
export const AppRecentRegular = ( /*#__PURE__*/createFluentIcon('AppRecentRegular', "1em", ["M7 2a2 2 0 0 0-2 2H4a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h1c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2h1a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1a2 2 0 0 0-2-2H7Zm8 3h1a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1h-1V5ZM5 15H4a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h1v10ZM6 4a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V4Z"]));
export const AppTitleFilled = ( /*#__PURE__*/createFluentIcon('AppTitleFilled', "1em", ["M7 3a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h6a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H7ZM4.5 17a.5.5 0 0 0 0 1h11a.5.5 0 0 0 0-1h-11Z"]));
export const AppTitleRegular = ( /*#__PURE__*/createFluentIcon('AppTitleRegular', "1em", ["M4 6a3 3 0 0 1 3-3h6a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H7a3 3 0 0 1-3-3V6Zm3-2a2 2 0 0 0-2 2v6c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H7ZM4 17.5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Z"]));
export const ApprovalsAppColor = ( /*#__PURE__*/createFluentIcon('ApprovalsAppColor', "1em", `<path d="M10.2 1.3a1 1 0 0 0-1.4 1.4l.3.31A7.5 7.5 0 1 0 17 10.5a1 1 0 1 0-2 0 5.5 5.5 0 1 1-5.93-5.48l-.28.27a1 1 0 0 0 1.42 1.42l2-2a1 1 0 0 0 0-1.42l-2-2Z" fill="url(#ic_fluent_approvals_app_20_color__a)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M13.7 7.3a1 1 0 0 1 0 1.4l-4 4a1 1 0 0 1-1.4 0l-1.5-1.5a1 1 0 0 1 1.4-1.4l.8.79 3.3-3.3a1 1 0 0 1 1.4 0Z" fill="url(#ic_fluent_approvals_app_20_color__b)"/><defs><linearGradient id="ic_fluent_approvals_app_20_color__a" x1="2" y1="2.39" x2="6.86" y2="20.81" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_approvals_app_20_color__b" x1="12.83" y1="8.2" x2="6.04" y2="11.57" gradientUnits="userSpaceOnUse"><stop stop-color="#42B870"/><stop offset="1" stop-color="#309C61"/></linearGradient></defs>`, { color: true }));
export const ApprovalsAppFilled = ( /*#__PURE__*/createFluentIcon('ApprovalsAppFilled', "1em", ["M9.78.72a.75.75 0 0 0-1.06 1.06L9.94 3H9.5a7.5 7.5 0 1 0 7.5 7.5.75.75 0 0 0-1.5 0 6 6 0 1 1-6.06-6l-.72.72a.75.75 0 0 0 1.06 1.06l2.25-2.25c.3-.3.3-.77 0-1.06L9.78.72Zm3.74 6.24c.3.29.3.76.02 1.06l-3.85 4a.75.75 0 0 1-1.08 0l-1.65-1.71a.75.75 0 1 1 1.08-1.04l1.11 1.15 3.31-3.44c.29-.3.76-.3 1.06-.02Z"]));
export const ApprovalsAppRegular = ( /*#__PURE__*/createFluentIcon('ApprovalsAppRegular', "1em", ["M9.85 1.15a.5.5 0 1 0-.7.7L10.29 3H9.5a7.5 7.5 0 1 0 7.5 7.5.5.5 0 0 0-1 0A6.5 6.5 0 1 1 9.5 4h.8L9.14 5.15a.5.5 0 1 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2Zm3.5 5.99c.2.2.2.5.01.7l-3.85 4a.5.5 0 0 1-.72 0l-1.65-1.7a.5.5 0 0 1 .72-.7l1.29 1.34 3.49-3.63c.2-.2.5-.2.7-.01Z"]));
export const AppsColor = ( /*#__PURE__*/createFluentIcon('AppsColor', "1em", `<path d="M3 4.5C3 3.67 3.67 3 4.5 3H9c.83 0 1.5.67 1.5 1.5V9a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V4.5Z" fill="url(#ic_fluent_apps_20_color__a)"/><path d="M15.5 9.5c.83 0 1.5.67 1.5 1.5v4.5c0 .83-.67 1.5-1.5 1.5H11a1 1 0 0 1-1-1v-5.5a1 1 0 0 1 1-1h4.5Z" fill="url(#ic_fluent_apps_20_color__b)"/><path d="M10.5 16a1 1 0 0 1-1 1h-5A1.5 1.5 0 0 1 3 15.5v-5a1 1 0 0 1 1-1h5.5a1 1 0 0 1 1 1V16Z" fill="url(#ic_fluent_apps_20_color__c)"/><path d="M12.94 2.44a1.5 1.5 0 0 1 2.12 0l2.5 2.5a1.5 1.5 0 0 1 0 2.12l-2.5 2.5a1.5 1.5 0 0 1-2.12 0l-2.5-2.5a1.5 1.5 0 0 1 0-2.12l2.5-2.5Z" fill="url(#ic_fluent_apps_20_color__d)"/><defs><linearGradient id="ic_fluent_apps_20_color__a" x1="3" y1="3" x2="9.98" y2="10.48" gradientUnits="userSpaceOnUse"><stop stop-color="#B9C0C7"/><stop offset="1" stop-color="#889096"/></linearGradient><linearGradient id="ic_fluent_apps_20_color__b" x1="17" y1="16.46" x2="10.05" y2="9.98" gradientUnits="userSpaceOnUse"><stop stop-color="#63686E"/><stop offset="1" stop-color="#889096"/></linearGradient><linearGradient id="ic_fluent_apps_20_color__c" x1="3" y1="9.5" x2="10.5" y2="14.32" gradientUnits="userSpaceOnUse"><stop stop-color="#55595E"/><stop offset="1" stop-color="#383B3D"/></linearGradient><linearGradient id="ic_fluent_apps_20_color__d" x1="16.56" y1="8.15" x2="12.12" y2="2.68" gradientUnits="userSpaceOnUse"><stop stop-color="#2764E7"/><stop offset="1" stop-color="#36DFF1"/></linearGradient></defs>`, { color: true }));
export const AppsFilled = ( /*#__PURE__*/createFluentIcon('AppsFilled', "1em", ["M4.5 17A1.5 1.5 0 0 1 3 15.65V4.5c0-.78.6-1.42 1.36-1.5H9c.78 0 1.42.6 1.5 1.36v.4l2.19-2.27a1.5 1.5 0 0 1 2-.14l.12.1 2.76 2.72c.55.55.6 1.42.11 2.02l-.1.11-2.31 2.2h.23c.78 0 1.42.6 1.5 1.36v4.64c0 .78-.6 1.42-1.36 1.5H4.5Zm5-6.5H4v5c0 .22.14.4.33.47l.08.02.09.01h5v-5.5Zm6 0h-5V16h5a.5.5 0 0 0 .5-.4V11a.5.5 0 0 0-.41-.5h-.09Zm-5-2.79V9.5h1.79L10.5 7.71ZM9 4.01H4.5a.5.5 0 0 0-.5.4v5.1h5.5v-5a.5.5 0 0 0-.33-.48l-.08-.02H9Z"]));
export const AppsRegular = ( /*#__PURE__*/createFluentIcon('AppsRegular', "1em", ["M4.5 17A1.5 1.5 0 0 1 3 15.65V4.5c0-.78.6-1.42 1.36-1.5H9c.78 0 1.42.6 1.5 1.36v.4l2.19-2.27a1.5 1.5 0 0 1 2-.14l.12.1 2.76 2.72c.55.55.6 1.42.11 2.02l-.1.11-2.31 2.2h.23c.78 0 1.42.6 1.5 1.36v4.64c0 .78-.6 1.42-1.36 1.5H4.5Zm5-6.5H4v5c0 .22.14.4.33.47l.08.02.09.01h5v-5.5Zm6 0h-5V16h5a.5.5 0 0 0 .5-.4V11a.5.5 0 0 0-.41-.5h-.09Zm-5-2.79V9.5h1.79L10.5 7.71ZM9 4.01H4.5a.5.5 0 0 0-.5.4v5.1h5.5v-5a.5.5 0 0 0-.33-.48l-.08-.02H9Zm5.12-.84a.5.5 0 0 0-.64-.05l-.07.06-2.62 2.71a.5.5 0 0 0-.05.63l.06.07 2.61 2.62c.17.17.43.2.62.07l.08-.06 2.76-2.63a.5.5 0 0 0 .05-.64l-.05-.06-2.75-2.72Z"]));
export const AppsAddInFilled = ( /*#__PURE__*/createFluentIcon('AppsAddInFilled', "1em", ["M15.5 2.75a.75.75 0 0 0-1.5 0V4.5h-1.75a.75.75 0 0 0 0 1.5H14v1.75a.75.75 0 0 0 1.5 0V6h1.75a.75.75 0 0 0 0-1.5H15.5V2.75ZM5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2v-3.75a2 2 0 0 0-2-2h-4.25V5a2 2 0 0 0-2-2H5Zm4.25 2v4.25H4.5V5c0-.28.22-.5.5-.5h3.75c.28 0 .5.22.5.5Zm0 5.75v4.75H5a.5.5 0 0 1-.5-.5v-4.25h4.75Zm1.5 0H15c.28 0 .5.22.5.5V15a.5.5 0 0 1-.5.5h-4.25v-4.75Z"]));
export const AppsAddInRegular = ( /*#__PURE__*/createFluentIcon('AppsAddInRegular', "1em", ["M14.5 2.5c.28 0 .5.22.5.5v2h2a.5.5 0 0 1 0 1h-2v2a.5.5 0 0 1-1 0V6h-2a.5.5 0 0 1 0-1h2V3c0-.28.22-.5.5-.5ZM3 5c0-1.1.9-2 2-2h3.5a2 2 0 0 1 2 2v4.5H15a2 2 0 0 1 2 2V15a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5Zm6.5 4.5V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v4.5h5.5Zm-5.5 1V15a1 1 0 0 0 1 1h4.5v-5.5H4Zm6.5 5.5H15a1 1 0 0 0 1-1v-3.5a1 1 0 0 0-1-1h-4.5V16Z"]));
export const AppsAddInOffFilled = ( /*#__PURE__*/createFluentIcon('AppsAddInOffFilled', "1em", ["M3.28 3.98 2.15 2.85a.5.5 0 1 1 .7-.7l15 15a.5.5 0 0 1-.7.7l-1.13-1.13A2 2 0 0 1 15 17H5a2 2 0 0 1-2-2V5a2 2 0 0 1 .28-1.02ZM14.79 15.5l-4.04-4.04v4.04h4.04ZM8.54 9.25 4.5 5.21v4.04h4.04ZM9.25 5v2.13l1.5 1.5V5a2 2 0 0 0-2-2H5.12l1.5 1.5h2.13c.28 0 .5.22.5.5Zm3.62 5.75-1.5-1.5H15a2 2 0 0 1 2 2v3.63l-1.5-1.5v-2.13a.5.5 0 0 0-.5-.5h-2.13Zm2.63-8a.75.75 0 0 0-1.5 0V4.5h-1.75a.75.75 0 0 0 0 1.5H14v1.75a.75.75 0 0 0 1.5 0V6h1.75a.75.75 0 0 0 0-1.5H15.5V2.75Zm-6.25 8H4.5V15c0 .28.22.5.5.5h4.25v-4.75Z"]));
export const AppsAddInOffRegular = ( /*#__PURE__*/createFluentIcon('AppsAddInOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7l1.13 1.13A2 2 0 0 0 3 5v10c0 1.1.9 2 2 2h10a2 2 0 0 0 1.02-.28l1.13 1.13a.5.5 0 0 0 .7-.7l-15-15Zm12.4 13.82A1 1 0 0 1 15 16h-4.5v-4.8l4.76 4.77ZM8.8 9.5H4V5a1 1 0 0 1 .03-.26L8.8 9.5ZM9.5 5v2.38l1 1V5a2 2 0 0 0-2-2H5.12l1 1H8.5a1 1 0 0 1 1 1Zm3.12 5.5-1-1H15a2 2 0 0 1 2 2v3.38l-1-1V11.5a1 1 0 0 0-1-1h-2.38Zm1.88-8c.28 0 .5.22.5.5v2h2a.5.5 0 0 1 0 1h-2v2a.5.5 0 0 1-1 0V6h-2a.5.5 0 0 1 0-1h2V3c0-.28.22-.5.5-.5ZM4 10.5h5.5V16H5a1 1 0 0 1-1-1v-4.5Z"]));
export const AppsListColor = ( /*#__PURE__*/createFluentIcon('AppsListColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M8 4a1 1 0 0 1 1-1h8a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1Zm0 6a1 1 0 0 1 1-1h8a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1Zm0 6a1 1 0 0 1 1-1h8a1 1 0 1 1 0 2H9a1 1 0 0 1-1-1Z" fill="url(#ic_fluent_apps_list_20_color__a)"/><path d="M2 15.5c0-.83.67-1.5 1.5-1.5h1c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5h-1A1.5 1.5 0 0 1 2 16.5v-1Zm0-6C2 8.67 2.67 8 3.5 8h1C5.33 8 6 8.67 6 9.5v1c0 .83-.67 1.5-1.5 1.5h-1A1.5 1.5 0 0 1 2 10.5v-1Zm0-6C2 2.67 2.67 2 3.5 2h1C5.33 2 6 2.67 6 3.5v1C6 5.33 5.33 6 4.5 6h-1A1.5 1.5 0 0 1 2 4.5v-1Z" fill="url(#ic_fluent_apps_list_20_color__b)"/><defs><linearGradient id="ic_fluent_apps_list_20_color__a" x1="6.5" y1="1" x2="17" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#36DFF1"/><stop offset="1" stop-color="#0094F0"/></linearGradient><linearGradient id="ic_fluent_apps_list_20_color__b" x1="2.95" y1="4.13" x2="4.99" y2="17.15" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient></defs>`, { color: true }));
export const AppsListFilled = ( /*#__PURE__*/createFluentIcon('AppsListFilled', "1em", ["M8 4.5c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5Zm0 6c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5Zm0 6c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5Zm-6-1c0-.83.67-1.5 1.5-1.5h1c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5h-1A1.5 1.5 0 0 1 2 16.5v-1Zm0-6C2 8.67 2.67 8 3.5 8h1C5.33 8 6 8.67 6 9.5v1c0 .83-.67 1.5-1.5 1.5h-1A1.5 1.5 0 0 1 2 10.5v-1Zm0-6C2 2.67 2.67 2 3.5 2h1C5.33 2 6 2.67 6 3.5v1C6 5.33 5.33 6 4.5 6h-1A1.5 1.5 0 0 1 2 4.5v-1Z"]));
export const AppsListRegular = ( /*#__PURE__*/createFluentIcon('AppsListRegular', "1em", ["M2 3.5C2 2.67 2.67 2 3.5 2h1C5.33 2 6 2.67 6 3.5v1C6 5.33 5.33 6 4.5 6h-1A1.5 1.5 0 0 1 2 4.5v-1ZM3.5 3a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1ZM2 9.5C2 8.67 2.67 8 3.5 8h1C5.33 8 6 8.67 6 9.5v1c0 .83-.67 1.5-1.5 1.5h-1A1.5 1.5 0 0 1 2 10.5v-1ZM3.5 9a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1ZM2 15.5c0-.83.67-1.5 1.5-1.5h1c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5h-1A1.5 1.5 0 0 1 2 16.5v-1Zm1.5-.5a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1ZM8 4.5c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5Zm0 6c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5Zm0 6c0-.28.22-.5.5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5Z"]));
export const AppsListDetailColor = ( /*#__PURE__*/createFluentIcon('AppsListDetailColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M9 5a1 1 0 0 1 1-1h7a1 1 0 1 1 0 2h-7a1 1 0 0 1-1-1Zm0 3a1 1 0 0 1 1-1h5a1 1 0 1 1 0 2h-5a1 1 0 0 1-1-1Zm0 4a1 1 0 0 1 1-1h7a1 1 0 1 1 0 2h-7a1 1 0 0 1-1-1Zm0 3a1 1 0 0 1 1-1h5a1 1 0 1 1 0 2h-5a1 1 0 0 1-1-1Z" fill="url(#ic_fluent_apps_list_detail_20_color__a)"/><path d="M3.5 4C2.67 4 2 4.67 2 5.5v2C2 8.33 2.67 9 3.5 9h2C6.33 9 7 8.33 7 7.5v-2C7 4.67 6.33 4 5.5 4h-2Zm0 7c-.83 0-1.5.67-1.5 1.5v2c0 .83.67 1.5 1.5 1.5h2c.83 0 1.5-.67 1.5-1.5v-2c0-.83-.67-1.5-1.5-1.5h-2Z" fill="url(#ic_fluent_apps_list_detail_20_color__b)"/><defs><linearGradient id="ic_fluent_apps_list_detail_20_color__a" x1="7.65" y1="2.29" x2="17.1" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="#36DFF1"/><stop offset="1" stop-color="#0094F0"/></linearGradient><linearGradient id="ic_fluent_apps_list_detail_20_color__b" x1="3.19" y1="5.6" x2="5.74" y2="15.36" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient></defs>`, { color: true }));
export const AppsListDetailFilled = ( /*#__PURE__*/createFluentIcon('AppsListDetailFilled', "1em", ["M3.5 4C2.67 4 2 4.67 2 5.5v2C2 8.33 2.67 9 3.5 9h2C6.33 9 7 8.33 7 7.5v-2C7 4.67 6.33 4 5.5 4h-2Zm6 1a.5.5 0 0 0 0 1h8a.5.5 0 0 0 0-1h-8Zm0 2a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Zm-6 4c-.83 0-1.5.67-1.5 1.5v2c0 .83.67 1.5 1.5 1.5h2c.83 0 1.5-.67 1.5-1.5v-2c0-.83-.67-1.5-1.5-1.5h-2Zm6 1a.5.5 0 0 0 0 1h8a.5.5 0 0 0 0-1h-8Zm0 2a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Z"]));
export const AppsListDetailRegular = ( /*#__PURE__*/createFluentIcon('AppsListDetailRegular', "1em", ["M3.5 4C2.67 4 2 4.67 2 5.5v2C2 8.33 2.67 9 3.5 9h2C6.33 9 7 8.33 7 7.5v-2C7 4.67 6.33 4 5.5 4h-2ZM3 5.5c0-.28.22-.5.5-.5h2c.28 0 .5.22.5.5v2a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5v-2ZM9.5 5a.5.5 0 0 0 0 1h8a.5.5 0 0 0 0-1h-8Zm0 2a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Zm-6 4c-.83 0-1.5.67-1.5 1.5v2c0 .83.67 1.5 1.5 1.5h2c.83 0 1.5-.67 1.5-1.5v-2c0-.83-.67-1.5-1.5-1.5h-2ZM3 12.5c0-.28.22-.5.5-.5h2c.28 0 .5.22.5.5v2a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5v-2Zm6.5-.5a.5.5 0 0 0 0 1h8a.5.5 0 0 0 0-1h-8Zm0 2a.5.5 0 0 0 0 1h6a.5.5 0 0 0 0-1h-6Z"]));
export const AppsSettingsFilled = ( /*#__PURE__*/createFluentIcon('AppsSettingsFilled', "1em", ["M15.5 17h-5.1c.16-.32.3-.65.4-1h4.7a.5.5 0 0 0 .5-.41V11a.5.5 0 0 0-.41-.5H10.5v1.7a5.51 5.51 0 0 0-1-1.47v-.23h-.22c-.44-.4-.94-.75-1.49-1H9.5v-5a.5.5 0 0 0-.33-.47l-.08-.02L9 4H4.5a.5.5 0 0 0-.5.41V9.2c-.35.1-.68.24-1 .4V4.5c0-.78.6-1.42 1.36-1.5H9c.78 0 1.42.6 1.5 1.36v.39l2.19-2.26a1.5 1.5 0 0 1 2-.14l.12.1 2.76 2.72c.55.55.6 1.42.11 2.01l-.1.12-2.31 2.2h.23c.78 0 1.42.6 1.5 1.36v4.64c0 .78-.6 1.42-1.36 1.5h-.14Zm-5-9.3v1.8h1.79L10.5 7.7Zm-7.43 3.74a2 2 0 0 1-1.43 2.48l-.47.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 3 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 8 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55ZM5.5 15.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const AppsSettingsRegular = ( /*#__PURE__*/createFluentIcon('AppsSettingsRegular', "1em", ["M15.5 17h-5.1c.16-.32.3-.65.4-1h4.7a.5.5 0 0 0 .5-.41V11a.5.5 0 0 0-.41-.5H10.5v1.7a5.51 5.51 0 0 0-1-1.47v-.23h-.22c-.44-.4-.94-.75-1.49-1H9.5v-5a.5.5 0 0 0-.33-.47l-.08-.02L9 4H4.5a.5.5 0 0 0-.5.41V9.2c-.35.1-.68.24-1 .4V4.5c0-.78.6-1.42 1.36-1.5H9c.78 0 1.42.6 1.5 1.36v.39l2.19-2.26a1.5 1.5 0 0 1 2-.14l.12.1 2.76 2.72c.55.55.6 1.42.11 2.01l-.1.12-2.31 2.2h.23c.78 0 1.42.6 1.5 1.36v4.64c0 .78-.6 1.42-1.36 1.5h-.14Zm-5-9.3v1.8h1.79L10.5 7.7Zm3.62-4.53a.5.5 0 0 0-.64-.05l-.07.06-2.62 2.71a.5.5 0 0 0-.05.63l.06.07 2.62 2.62c.16.17.42.2.61.07l.08-.06 2.76-2.63a.5.5 0 0 0 .06-.64l-.06-.07-2.75-2.7ZM3.07 11.44a2 2 0 0 1-1.43 2.48l-.47.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 3 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 8 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55ZM5.5 15.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const AppsShieldFilled = ( /*#__PURE__*/createFluentIcon('AppsShieldFilled', "1em", ["M15.5 17H8.42c.16-.3.3-.64.39-1h.69v-5.5H6.98a4.76 4.76 0 0 1-1.35-1H9.5v-5a.5.5 0 0 0-.33-.47l-.08-.02L9 4H4.5a.5.5 0 0 0-.5.41v4.67c-.22.08-.43.2-.6.39a5.7 5.7 0 0 1-.4.38V4.5c0-.78.6-1.42 1.36-1.5H9c.78 0 1.42.6 1.5 1.36v.39l2.19-2.26a1.5 1.5 0 0 1 2-.14l.12.1 2.76 2.72c.55.55.6 1.42.11 2.01l-.1.12-2.31 2.2h.23c.78 0 1.42.6 1.5 1.36v4.64c0 .78-.6 1.42-1.36 1.5h-.14Zm0-6.5h-5V16h5a.5.5 0 0 0 .5-.41V11a.5.5 0 0 0-.41-.5h-.09Zm-5-2.8v1.8h1.79L10.5 7.7Zm-5.62 2.46c.5.53 1.48 1.38 2.68 1.55a.5.5 0 0 1 .44.48v2.33c0 3.12-2.78 4.25-3.39 4.46a.34.34 0 0 1-.22 0c-.6-.2-3.39-1.34-3.39-4.46v-2.33c0-.24.2-.44.44-.48a4.95 4.95 0 0 0 2.68-1.55c.2-.21.56-.21.76 0Z"]));
export const AppsShieldRegular = ( /*#__PURE__*/createFluentIcon('AppsShieldRegular', "1em", ["M15.5 17H8.42c.16-.3.3-.64.39-1h.69v-5.5H6.98a4.76 4.76 0 0 1-1.35-1H9.5v-5a.5.5 0 0 0-.33-.47l-.08-.02L9 4H4.5a.5.5 0 0 0-.5.41v4.67c-.22.08-.43.2-.6.39a5.7 5.7 0 0 1-.4.38V4.5c0-.78.6-1.42 1.36-1.5H9c.78 0 1.42.6 1.5 1.36v.39l2.19-2.26a1.5 1.5 0 0 1 2-.14l.12.1 2.76 2.72c.55.55.6 1.42.11 2.01l-.1.12-2.31 2.2h.23c.78 0 1.42.6 1.5 1.36v4.64c0 .78-.6 1.42-1.36 1.5h-.14Zm0-6.5h-5V16h5a.5.5 0 0 0 .5-.41V11a.5.5 0 0 0-.41-.5h-.09Zm-5-2.8v1.8h1.79L10.5 7.7Zm3.62-4.53a.5.5 0 0 0-.64-.05l-.07.06-2.62 2.71a.5.5 0 0 0-.05.63l.06.07 2.61 2.62c.17.17.43.2.62.07l.08-.06 2.76-2.63a.5.5 0 0 0 .05-.64l-.05-.07-2.75-2.7Zm-9.24 6.99c.5.53 1.48 1.38 2.68 1.55a.5.5 0 0 1 .44.48v2.33c0 3.12-2.78 4.25-3.39 4.46a.34.34 0 0 1-.22 0c-.6-.2-3.39-1.34-3.39-4.46v-2.33c0-.24.2-.44.44-.48a4.95 4.95 0 0 0 2.68-1.55c.2-.21.56-.21.76 0Z"]));
export const ArchiveFilled = ( /*#__PURE__*/createFluentIcon('ArchiveFilled', "1em", ["M2 4.25C2 3.56 2.56 3 3.25 3h13.5c.69 0 1.25.56 1.25 1.25v1.5C18 6.44 17.44 7 16.75 7H3.25C2.56 7 2 6.44 2 5.75v-1.5ZM3 8h14v6a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V8Zm5.5 2a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const ArchiveRegular = ( /*#__PURE__*/createFluentIcon('ArchiveRegular', "1em", ["M8.5 10a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM2 4.75C2 3.78 2.78 3 3.75 3h12.5c.97 0 1.75.78 1.75 1.75v1.5c0 .7-.4 1.3-1 1.58V14a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V7.83c-.6-.28-1-.88-1-1.58v-1.5ZM3.75 4a.75.75 0 0 0-.75.75v1.5c0 .41.34.75.75.75h12.5c.41 0 .75-.34.75-.75v-1.5a.75.75 0 0 0-.75-.75H3.75ZM4 8v6c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V8H4Z"]));
export const ArchiveArrowBackFilled = ( /*#__PURE__*/createFluentIcon('ArchiveArrowBackFilled', "1em", ["M2 4.25C2 3.56 2.56 3 3.25 3h13.5c.69 0 1.25.56 1.25 1.25v1.5C18 6.44 17.44 7 16.75 7H3.25C2.56 7 2 6.44 2 5.75v-1.5ZM3 8h14v1.6a5.48 5.48 0 0 0-5.66.4H8.5a.5.5 0 0 0 0 1h1.76a5.48 5.48 0 0 0-.66 6H6a3 3 0 0 1-3-3V8Zm11.5 11a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const ArchiveArrowBackRegular = ( /*#__PURE__*/createFluentIcon('ArchiveArrowBackRegular', "1em", ["M8.5 10a.5.5 0 0 0 0 1h1.76c.31-.38.67-.72 1.08-1H8.5ZM6 16h3.2c.1.35.24.68.4 1H6a3 3 0 0 1-3-3V7.83c-.6-.28-1-.88-1-1.58v-1.5C2 3.78 2.78 3 3.75 3h12.5c.97 0 1.75.78 1.75 1.75v1.5c0 .7-.4 1.3-1 1.58V9.6c-.32-.16-.65-.3-1-.4V8H4v6c0 1.1.9 2 2 2ZM3.75 4a.75.75 0 0 0-.75.75v1.5c0 .41.34.75.75.75h12.5c.41 0 .75-.34.75-.75v-1.5a.75.75 0 0 0-.75-.75H3.75ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const ArchiveClockFilled = ( /*#__PURE__*/createFluentIcon('ArchiveClockFilled', "1em", ["M19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5H16a.5.5 0 0 0 0-1h-1v-1.5a.5.5 0 0 0-.5-.5Z", "M17 9.6a5.48 5.48 0 0 0-5.66.4H8.5a.5.5 0 0 0 0 1h1.76a5.48 5.48 0 0 0-.66 6H6a3 3 0 0 1-3-3V8h14v1.6Z", "M16.75 3c.69 0 1.25.56 1.25 1.25v1.5C18 6.44 17.44 7 16.75 7H3.25C2.56 7 2 6.44 2 5.75v-1.5C2 3.56 2.56 3 3.25 3h13.5Z"]));
export const ArchiveClockRegular = ( /*#__PURE__*/createFluentIcon('ArchiveClockRegular', "1em", ["M19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5H16a.5.5 0 0 0 0-1h-1v-1.5a.5.5 0 0 0-.5-.5Z", "M16.25 3c.97 0 1.75.78 1.75 1.75v1.5c0 .7-.4 1.3-1 1.58V9.6c-.32-.16-.65-.3-1-.4V8H4v6c0 1.1.9 2 2 2h3.2c.1.35.24.68.4 1H6a3 3 0 0 1-3-3V7.83c-.6-.28-1-.88-1-1.58v-1.5C2 3.78 2.78 3 3.75 3h12.5ZM3.75 4a.75.75 0 0 0-.75.75v1.5c0 .41.34.75.75.75h12.5c.41 0 .75-.34.75-.75v-1.5a.75.75 0 0 0-.75-.75H3.75Z", "M11.34 10c-.4.28-.77.62-1.08 1H8.5a.5.5 0 0 1 0-1h2.84Z"]));
export const ArchiveMultipleFilled = ( /*#__PURE__*/createFluentIcon('ArchiveMultipleFilled', "1em", ["M3.5 2C2.67 2 2 2.67 2 3.5v1C2 5.33 2.67 6 3.5 6h11c.83 0 1.5-.67 1.5-1.5v-1c0-.83-.67-1.5-1.5-1.5h-11ZM15 7H3v5.5A3.5 3.5 0 0 0 6.5 16h5a3.5 3.5 0 0 0 3.5-3.5V7ZM7 8.5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5ZM8.5 18c-.95 0-1.82-.38-2.45-1h6.45a3.5 3.5 0 0 0 3.5-3.5V7.09c.58.2 1 .76 1 1.41v5a4.5 4.5 0 0 1-4.5 4.5h-4Z"]));
export const ArchiveMultipleRegular = ( /*#__PURE__*/createFluentIcon('ArchiveMultipleRegular', "1em", ["M7.5 8a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Zm-4-6C2.67 2 2 2.67 2 3.5v2c0 .66.42 1.21 1 1.42A.5.5 0 0 0 3 7v5.5A3.5 3.5 0 0 0 6.5 16h5a3.5 3.5 0 0 0 3.5-3.5V7a.5.5 0 0 0 0-.08c.58-.2 1-.76 1-1.42v-2c0-.83-.67-1.5-1.5-1.5h-11ZM4 12.5V7h10v5.5a2.5 2.5 0 0 1-2.5 2.5h-5A2.5 2.5 0 0 1 4 12.5Zm-1-9c0-.28.22-.5.5-.5h11c.28 0 .5.22.5.5v2a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-2ZM8.5 18c-.95 0-1.82-.38-2.45-1h6.45a3.5 3.5 0 0 0 3.5-3.5V7.09c.58.2 1 .76 1 1.41v5a4.5 4.5 0 0 1-4.5 4.5h-4Z"]));
export const ArchiveSettingsFilled = ( /*#__PURE__*/createFluentIcon('ArchiveSettingsFilled', "1em", ["M2 4.25C2 3.56 2.56 3 3.25 3h13.5c.69 0 1.25.56 1.25 1.25v1.5C18 6.44 17.44 7 16.75 7H3.25C2.56 7 2 6.44 2 5.75v-1.5ZM3 8h14v1.6a5.48 5.48 0 0 0-5.66.4H8.5a.5.5 0 0 0 0 1h1.76a5.48 5.48 0 0 0-.66 6H6a3 3 0 0 1-3-3V8Zm9.07 3.44a2 2 0 0 1-1.43 2.48l-.46.12a4.7 4.7 0 0 0 0 1.02l.35.08A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.29.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const ArchiveSettingsRegular = ( /*#__PURE__*/createFluentIcon('ArchiveSettingsRegular', "1em", ["M2 4.75C2 3.78 2.78 3 3.75 3h12.5c.97 0 1.75.78 1.75 1.75v1.5c0 .7-.4 1.3-1 1.58V9.6c-.32-.16-.65-.3-1-.4V8H4v6c0 1.1.9 2 2 2h3.2c.1.35.24.68.4 1H6a3 3 0 0 1-3-3V7.83c-.6-.28-1-.88-1-1.58v-1.5ZM3.75 4a.75.75 0 0 0-.75.75v1.5c0 .41.34.75.75.75h12.5c.41 0 .75-.34.75-.75v-1.5a.75.75 0 0 0-.75-.75H3.75Zm4.75 6h2.84c-.4.28-.77.62-1.08 1H8.5a.5.5 0 0 1 0-1Zm3.57 1.44a2 2 0 0 1-1.43 2.48l-.46.12a4.7 4.7 0 0 0 0 1.02l.35.08A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.29.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const ArrowAutofitContentFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitContentFilled', "1em", ["M5.35 3.65c.2.2.2.5 0 .7L4.71 5H7.5a.5.5 0 0 1 0 1H4.7l.65.65a.5.5 0 1 1-.7.7l-1.5-1.5a.5.5 0 0 1 0-.7l1.5-1.5c.2-.2.5-.2.7 0ZM5.5 9A2.5 2.5 0 0 0 3 11.5v3A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-3A2.5 2.5 0 0 0 14.5 9h-9Zm.5 3.5h8a.5.5 0 0 1 0 1H6a.5.5 0 0 1 0-1Zm8.65-8.15a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-1.5 1.5a.5.5 0 0 1-.7-.7l.64-.65H12.5a.5.5 0 0 1 0-1h2.8l-.65-.65Z"]));
export const ArrowAutofitContentRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitContentRegular', "1em", ["M5.35 3.65c.2.2.2.5 0 .7L4.71 5H7.5a.5.5 0 0 1 0 1H4.7l.65.65a.5.5 0 1 1-.7.7l-1.5-1.5a.5.5 0 0 1 0-.7l1.5-1.5c.2-.2.5-.2.7 0ZM5.5 9A2.5 2.5 0 0 0 3 11.5v3A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-3A2.5 2.5 0 0 0 14.5 9h-9ZM4 11.5c0-.83.67-1.5 1.5-1.5h9c.83 0 1.5.67 1.5 1.5v3c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 4 14.5v-3Zm2 1a.5.5 0 0 0 0 1h8a.5.5 0 0 0 0-1H6Zm8.65-8.15a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-1.5 1.5a.5.5 0 0 1-.7-.7l.64-.65H12.5a.5.5 0 0 1 0-1h2.8l-.65-.65Z"]));
export const ArrowAutofitDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitDownFilled', "1em", ["m15.71 14.77-.7.73V2.75a.75.75 0 1 0-1.5 0v12.76l-.72-.74a.75.75 0 0 0-1.08 1.04l1.82 1.88a1 1 0 0 0 1.44 0l1.82-1.88a.75.75 0 0 0-1.08-1.04ZM5 17a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h6.25a.75.75 0 0 1 0 1.5H5a.5.5 0 0 0-.5.5v10c0 .28.22.5.5.5h4.25a.75.75 0 0 1 0 1.5H5Z"]));
export const ArrowAutofitDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitDownRegular', "1em", ["M16.14 15.2 15 16.36V2.5a.5.5 0 1 0-1 0v13.87l-1.14-1.18a.5.5 0 1 0-.72.7l1.82 1.88c.3.3.79.3 1.08 0l1.82-1.88a.5.5 0 1 0-.72-.7ZM5 17a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h6.5a.5.5 0 0 1 0 1H5a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h4.5a.5.5 0 1 1 0 1H5Z"]));
export const ArrowAutofitHeightFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitHeightFilled', "1em", ["m15 4.5.71.73A.75.75 0 0 0 16.8 4.2l-1.82-1.88a1 1 0 0 0-1.44 0l-1.82 1.88a.75.75 0 0 0 1.08 1.04l.71-.74v2.76a.75.75 0 0 0 1.5 0V4.5ZM3 5c0-1.1.9-2 2-2h4.25a.75.75 0 0 1 0 1.5H5a.5.5 0 0 0-.5.5v10c0 .28.22.5.5.5h4.25a.75.75 0 0 1 0 1.5H5a2 2 0 0 1-2-2V5Zm12.71 9.77-.7.73v-2.75a.75.75 0 1 0-1.5 0v2.76l-.72-.74a.75.75 0 0 0-1.08 1.04l1.82 1.88a1 1 0 0 0 1.44 0l1.82-1.88a.75.75 0 0 0-1.08-1.04Z"]));
export const ArrowAutofitHeightRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitHeightRegular', "1em", ["m15 3.63 1.14 1.18a.5.5 0 1 0 .72-.7l-1.82-1.88a.75.75 0 0 0-1.08 0L12.14 4.1a.5.5 0 1 0 .72.7L14 3.63V7.5a.5.5 0 0 0 1 0V3.63ZM3 5c0-1.1.9-2 2-2h4.5a.5.5 0 0 1 0 1H5a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h4.5a.5.5 0 0 1 0 1H5a2 2 0 0 1-2-2V5Zm13.14 10.2L15 16.36V12.5a.5.5 0 1 0-1 0v3.87l-1.14-1.18a.5.5 0 1 0-.72.7l1.82 1.88c.3.3.79.3 1.08 0l1.82-1.88a.5.5 0 1 0-.72-.7Z"]));
export const ArrowAutofitHeightDottedFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitHeightDottedFilled', "1em", ["m15.71 5.23-1.46-1.51-1.46 1.51a.75.75 0 0 1-1.08-1.04l1.82-1.88a1 1 0 0 1 1.44 0l1.82 1.88a.75.75 0 0 1-1.08 1.04Zm0 9.54-1.46 1.51-1.46-1.51a.75.75 0 0 0-1.08 1.04l1.82 1.88a1 1 0 0 0 1.44 0l1.82-1.88a.75.75 0 0 0-1.08-1.04ZM14.25 12c.42 0 .75.34.75.75v.5a.75.75 0 1 1-1.5 0v-.5c0-.41.34-.75.75-.75Zm.75-1.75a.75.75 0 1 1-1.5 0v-.5a.75.75 0 0 1 1.5 0v.5ZM14.25 8c.42 0 .75-.34.75-.75v-.5a.75.75 0 1 0-1.5 0v.5c0 .41.34.75.75.75ZM5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h4.25a.75.75 0 0 0 0-1.5H5a.5.5 0 0 1-.5-.5V5c0-.28.22-.5.5-.5h4.25a.75.75 0 0 0 0-1.5H5Z"]));
export const ArrowAutofitHeightDottedRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitHeightDottedRegular', "1em", ["M16.14 4.8 14.5 3.12l-1.64 1.7a.5.5 0 0 1-.72-.7l1.82-1.88c.3-.3.79-.3 1.08 0l1.82 1.88a.5.5 0 1 1-.72.7ZM5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h4.5a.5.5 0 0 0 0-1H5a1 1 0 0 1-1-1V5a1 1 0 0 1 1-1h4.5a.5.5 0 0 0 0-1H5Zm9.5 2c.28 0 .5.22.5.5V7a.5.5 0 1 1-1 0V5.5c0-.28.23-.5.5-.5Zm.5 8a.5.5 0 1 0-1 0v1.5a.5.5 0 0 0 1 0V13Zm-.5-4c.28 0 .5.22.5.5v1a.5.5 0 1 1-1 0v-1c0-.28.23-.5.5-.5Zm1.64 6.2-1.64 1.69-1.64-1.7a.5.5 0 1 0-.72.7l1.82 1.88c.3.3.79.3 1.08 0l1.82-1.88a.5.5 0 1 0-.72-.7Z"]));
export const ArrowAutofitHeightInFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitHeightInFilled', "1em", ["m14.78 7.78 2-2a.75.75 0 0 0-1.06-1.06l-.72.72V2.75a.75.75 0 0 0-1.5 0v2.69l-.72-.72a.75.75 0 1 0-1.06 1.06l2 2c.3.3.77.3 1.06 0ZM3 5c0-1.1.9-2 2-2h4.25a.75.75 0 0 1 0 1.5H5a.5.5 0 0 0-.5.5v10c0 .28.22.5.5.5h4.25a.75.75 0 0 1 0 1.5H5a2 2 0 0 1-2-2V5Zm13.78 9.22-2-2a.75.75 0 0 0-1.06 0l-2 2a.75.75 0 1 0 1.06 1.06l.72-.72v2.69a.75.75 0 0 0 1.5 0v-2.69l.72.72a.75.75 0 1 0 1.06-1.06Z"]));
export const ArrowAutofitHeightInRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitHeightInRegular', "1em", ["m14.85 7.85 2-2a.5.5 0 0 0-.7-.7L15 6.29V2.5a.5.5 0 0 0-1 0v3.8l-1.15-1.15a.5.5 0 0 0-.7.7l2 2c.2.2.5.2.7 0ZM3 5c0-1.1.9-2 2-2h4.5a.5.5 0 0 1 0 1H5a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h4.5a.5.5 0 0 1 0 1H5a2 2 0 0 1-2-2V5Zm13.85 9.15-2-2a.5.5 0 0 0-.7 0l-2 2a.5.5 0 0 0 .7.7L14 13.71v3.79a.5.5 0 0 0 1 0v-3.8l1.15 1.15a.5.5 0 0 0 .7-.7Z"]));
export const ArrowAutofitUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitUpFilled', "1em", ["m15.71 5.23-.7-.73v12.75a.75.75 0 1 1-1.5 0V4.49l-.72.74a.75.75 0 0 1-1.08-1.04l1.82-1.88a1 1 0 0 1 1.44 0l1.82 1.88a.75.75 0 0 1-1.08 1.04ZM5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h6.25a.75.75 0 0 0 0-1.5H5a.5.5 0 0 1-.5-.5V5c0-.28.22-.5.5-.5h4.25a.75.75 0 0 0 0-1.5H5Z"]));
export const ArrowAutofitUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitUpRegular', "1em", ["M16.14 4.8 15 3.64V17.5a.5.5 0 1 1-1 0V3.63L12.86 4.8a.5.5 0 0 1-.72-.7l1.82-1.88c.3-.3.79-.3 1.08 0l1.82 1.88a.5.5 0 1 1-.72.7ZM5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h6.5a.5.5 0 0 0 0-1H5a1 1 0 0 1-1-1V5a1 1 0 0 1 1-1h4.5a.5.5 0 0 0 0-1H5Z"]));
export const ArrowAutofitWidthFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitWidthFilled', "1em", ["m15.5 15-.73.71a.75.75 0 1 0 1.04 1.08l1.89-1.82a1 1 0 0 0 0-1.44l-1.89-1.82a.75.75 0 0 0-1.04 1.08l.74.71h-2.76a.75.75 0 0 0 0 1.5h2.75ZM15 3a2 2 0 0 1 2 2v4.25a.75.75 0 0 1-1.5 0V5a.5.5 0 0 0-.5-.5H5a.5.5 0 0 0-.5.5v4.25a.75.75 0 0 1-1.5 0V5c0-1.1.9-2 2-2h10ZM5.23 15.71l-.73-.7h2.75a.75.75 0 1 0 0-1.5H4.5l.73-.72a.75.75 0 0 0-1.04-1.08l-1.88 1.82a1 1 0 0 0 0 1.44l1.88 1.82a.75.75 0 0 0 1.04-1.08Z"]));
export const ArrowAutofitWidthRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitWidthRegular', "1em", ["m16.37 15-1.18 1.14a.5.5 0 1 0 .7.72l1.88-1.82c.3-.3.3-.78 0-1.08l-1.88-1.82a.5.5 0 1 0-.7.72L16.38 14H12.5a.5.5 0 1 0 0 1h3.87ZM15 3a2 2 0 0 1 2 2v4.5a.5.5 0 0 1-1 0V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v4.5a.5.5 0 0 1-1 0V5c0-1.1.9-2 2-2h10ZM4.81 16.14 3.63 15H7.5a.5.5 0 1 0 0-1H3.63l1.18-1.14a.5.5 0 0 0-.7-.72l-1.88 1.82c-.3.3-.3.79 0 1.08l1.89 1.82a.5.5 0 1 0 .69-.72Z"]));
export const ArrowAutofitWidthDottedFilled = ( /*#__PURE__*/createFluentIcon('ArrowAutofitWidthDottedFilled', "1em", ["m14.77 15.71 1.51-1.46-1.51-1.46a.75.75 0 1 1 1.04-1.08l1.89 1.82a1 1 0 0 1 0 1.44l-1.89 1.82a.75.75 0 0 1-1.04-1.08Zm-9.54 0-1.5-1.46 1.5-1.46a.75.75 0 0 0-1.04-1.08l-1.88 1.82a1 1 0 0 0 0 1.44l1.88 1.82a.75.75 0 0 0 1.04-1.08ZM8 14.25c0 .42-.33.75-.75.75h-.5a.75.75 0 1 1 0-1.5h.5c.42 0 .75.34.75.75Zm1.75.75a.75.75 0 1 1 0-1.5h.5a.75.75 0 0 1 0 1.5h-.5Zm2.25-.75c0 .42.34.75.75.75h.5a.75.75 0 1 0 0-1.5h-.5a.75.75 0 0 0-.75.75ZM17 5a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v4.25a.75.75 0 0 0 1.5 0V5c0-.28.22-.5.5-.5h10c.28 0 .5.22.5.5v4.25a.75.75 0 1 0 1.5 0V5Z"]));
export const ArrowAutofitWidthDottedRegular = ( /*#__PURE__*/createFluentIcon('ArrowAutofitWidthDottedRegular', "1em", ["m15.2 16.14 1.7-1.64-1.7-1.64a.5.5 0 0 1 .69-.72l1.88 1.82c.3.3.3.79 0 1.08l-1.88 1.82a.5.5 0 1 1-.7-.72ZM17 5a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v4.5a.5.5 0 0 0 1 0V5a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1v4.5a.5.5 0 1 0 1 0V5Zm-2 9.5a.5.5 0 0 1-.5.5H13a.5.5 0 1 1 0-1h1.5c.28 0 .5.23.5.5ZM7 15a.5.5 0 1 0 0-1H5.5a.5.5 0 0 0 0 1H7Zm4-.5a.5.5 0 0 1-.5.5h-1a.5.5 0 1 1 0-1h1c.28 0 .5.23.5.5Zm-6.19 1.64-1.7-1.64 1.7-1.64a.5.5 0 0 0-.7-.72l-1.88 1.82c-.3.3-.3.79 0 1.08l1.89 1.82a.5.5 0 1 0 .69-.72Z"]));
export const ArrowBetweenDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowBetweenDownFilled', "1em", ["M5 1.75a.75.75 0 0 0-1.5 0v.5C3.5 3.22 4.28 4 5.25 4h9C15.22 4 16 3.22 16 2.25v-.5a.75.75 0 0 0-1.5 0v.5c0 .14-.11.25-.25.25h-9A.25.25 0 0 1 5 2.25v-.5ZM9.75 5c.41 0 .75.34.75.75v6.69l2.97-2.97a.75.75 0 1 1 1.06 1.06l-4.25 4.25c-.3.3-.77.3-1.06 0l-4.25-4.25a.75.75 0 1 1 1.06-1.06L9 12.44V5.75c0-.41.34-.75.75-.75ZM3.5 17.75c0-.97.78-1.75 1.75-1.75h9c.97 0 1.75.78 1.75 1.75v.5a.75.75 0 0 1-1.5 0v-.5a.25.25 0 0 0-.25-.25h-9a.25.25 0 0 0-.25.25v.5a.75.75 0 0 1-1.5 0v-.5Z"]));
export const ArrowBetweenDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowBetweenDownRegular', "1em", ["M4 2a.5.5 0 0 0-1 0v.5C3 3.33 3.67 4 4.5 4h10c.83 0 1.5-.67 1.5-1.5V2a.5.5 0 0 0-1 0v.5a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5V2Zm5.5 3c.28 0 .5.22.5.5v7.8l3.65-3.65a.5.5 0 0 1 .7.7l-4.5 4.5a.5.5 0 0 1-.7 0l-4.5-4.5a.5.5 0 0 1 .7-.7L9 13.29V5.5c0-.28.22-.5.5-.5ZM3 17.5c0-.83.67-1.5 1.5-1.5h10c.83 0 1.5.67 1.5 1.5v.5a.5.5 0 0 1-1 0v-.5a.5.5 0 0 0-.5-.5h-10a.5.5 0 0 0-.5.5v.5a.5.5 0 0 1-1 0v-.5Z"]));
export const ArrowBetweenUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowBetweenUpFilled', "1em", ["M5 18.25a.75.75 0 0 1-1.5 0v-.5c0-.97.78-1.75 1.75-1.75h9c.97 0 1.75.78 1.75 1.75v.5a.75.75 0 0 1-1.5 0v-.5a.25.25 0 0 0-.25-.25h-9a.25.25 0 0 0-.25.25v.5ZM9.75 15c.41 0 .75-.34.75-.75V7.56l2.97 2.97a.75.75 0 1 0 1.06-1.06l-4.25-4.25a.75.75 0 0 0-1.06 0L4.97 9.47a.75.75 0 1 0 1.06 1.06L9 7.56v6.69c0 .41.34.75.75.75ZM3.5 2.25C3.5 3.22 4.28 4 5.25 4h9C15.22 4 16 3.22 16 2.25v-.5a.75.75 0 0 0-1.5 0v.5c0 .14-.11.25-.25.25h-9A.25.25 0 0 1 5 2.25v-.5a.75.75 0 0 0-1.5 0v.5Z"]));
export const ArrowBetweenUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowBetweenUpRegular', "1em", ["M4 18a.5.5 0 0 1-1 0v-.5c0-.83.67-1.5 1.5-1.5h10c.83 0 1.5.67 1.5 1.5v.5a.5.5 0 0 1-1 0v-.5a.5.5 0 0 0-.5-.5h-10a.5.5 0 0 0-.5.5v.5Zm5.5-3a.5.5 0 0 0 .5-.5V6.7l3.65 3.65a.5.5 0 0 0 .7-.7l-4.5-4.5a.5.5 0 0 0-.7 0l-4.5 4.5a.5.5 0 0 0 .7.7L9 6.71v7.79c0 .28.22.5.5.5ZM3 2.5C3 3.33 3.67 4 4.5 4h10c.83 0 1.5-.67 1.5-1.5V2a.5.5 0 0 0-1 0v.5a.5.5 0 0 1-.5.5h-10a.5.5 0 0 1-.5-.5V2a.5.5 0 0 0-1 0v.5Z"]));
export const ArrowBidirectionalLeftRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowBidirectionalLeftRightFilled', "1em", ["M7.78 5.72c.3.3.3.77 0 1.06L5.56 9h8.88l-2.22-2.22a.75.75 0 0 1 1.06-1.06l3.5 3.5c.3.3.3.77 0 1.06l-3.5 3.5a.75.75 0 1 1-1.06-1.06l2.22-2.22H5.56l2.22 2.22a.75.75 0 1 1-1.06 1.06l-3.5-3.5a.75.75 0 0 1 0-1.06l3.5-3.5c.3-.3.77-.3 1.06 0Z"]));
export const ArrowBidirectionalLeftRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowBidirectionalLeftRightRegular', "1em", ["M7.35 5.65c.2.2.2.5 0 .7L4.71 9h10.58l-2.64-2.65a.5.5 0 0 1 .7-.7l3.5 3.5c.2.2.2.5 0 .7l-3.5 3.5a.5.5 0 0 1-.7-.7L15.29 10H4.71l2.64 2.65a.5.5 0 0 1-.7.7l-3.5-3.5a.5.5 0 0 1 0-.7l3.5-3.5c.2-.2.5-.2.7 0Z"]));
export const ArrowBidirectionalUpDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowBidirectionalUpDownFilled', "1em", ["M6.78 7.78a.75.75 0 0 1-1.06-1.06l3.5-3.5c.3-.3.77-.3 1.06 0l3.5 3.5a.75.75 0 0 1-1.06 1.06L10.5 5.56v8.88l2.22-2.22a.75.75 0 1 1 1.06 1.06l-3.5 3.5c-.3.3-.77.3-1.06 0l-3.5-3.5a.75.75 0 1 1 1.06-1.06L9 14.44V5.56L6.78 7.78Z"]));
export const ArrowBidirectionalUpDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowBidirectionalUpDownRegular', "1em", ["M6.35 7.35a.5.5 0 1 1-.7-.7l3.5-3.5c.2-.2.5-.2.7 0l3.5 3.5a.5.5 0 0 1-.7.7L10 4.71v10.58l2.65-2.64a.5.5 0 0 1 .7.7l-3.5 3.5a.5.5 0 0 1-.7 0l-3.5-3.5a.5.5 0 0 1 .7-.7L9 15.29V4.71L6.35 7.35Z"]));
export const ArrowBounceFilled = ( /*#__PURE__*/createFluentIcon('ArrowBounceFilled', "1em", ["M2.75 6a.75.75 0 0 0-.75.75v6.5a.75.75 0 0 0 1.5 0V8.56l6.47 6.47c.3.3.77.3 1.06 0l6.75-6.75a.75.75 0 0 0-1.06-1.06l-6.22 6.22L4.56 7.5h4.69a.75.75 0 0 0 0-1.5h-6.5Z"]));
export const ArrowBounceRegular = ( /*#__PURE__*/createFluentIcon('ArrowBounceRegular', "1em", ["M2.5 6a.5.5 0 0 0-.5.5v7a.5.5 0 0 0 1 0V7.7l7.15 7.15c.2.2.5.2.7 0l7-7a.5.5 0 0 0-.7-.7l-6.65 6.64L3.7 7h5.8a.5.5 0 0 0 0-1h-7Z"]));
export const ArrowCircleDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownFilled', "1em", ["M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-4.65.85a.5.5 0 0 0-.7-.7l-2.15 2.14V6.5a.5.5 0 0 0-1 0v5.8l-2.15-2.15a.5.5 0 0 0-.7.7l3 3c.2.2.5.2.7 0l3-3Z"]));
export const ArrowCircleDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownRegular', "1em", ["m13.35 10.85-3 3a.5.5 0 0 1-.7 0l-3-3a.5.5 0 0 1 .7-.7l2.15 2.14V6.5a.5.5 0 0 1 1 0v5.8l2.15-2.15a.5.5 0 0 1 .7.7ZM10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm7-8a7 7 0 1 1-14 0 7 7 0 0 1 14 0Z"]));
export const ArrowCircleDownDoubleFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownDoubleFilled', "1em", ["M7.35 13.85 9 12.21a.5.5 0 1 0-.7-.71l-.8.8V6.5a.5.5 0 0 0-1 0v5.8l-.8-.8a.5.5 0 1 0-.7.7l1.65 1.65c.2.2.5.2.7 0ZM18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-4.65 3.85L15 12.21a.5.5 0 1 0-.7-.71l-.8.8V6.5a.5.5 0 0 0-1 0v5.8l-.8-.8a.5.5 0 1 0-.7.7l1.65 1.65c.2.2.5.2.7 0Z"]));
export const ArrowCircleDownDoubleRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownDoubleRegular', "1em", ["m9 12.2-1.65 1.65a.5.5 0 0 1-.7 0L5 12.21a.5.5 0 1 1 .7-.71l.8.8V6.5a.5.5 0 0 1 1 0v5.8l.8-.8a.5.5 0 1 1 .7.7Zm1 5.8a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm7-8a7 7 0 1 1-14 0 7 7 0 0 1 14 0Zm-3.65 3.85L15 12.21a.5.5 0 1 0-.7-.71l-.8.8V6.5a.5.5 0 0 0-1 0v5.8l-.8-.8a.5.5 0 1 0-.7.7l1.65 1.65c.2.2.5.2.7 0Z"]));
export const ArrowCircleDownRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownRightFilled', "1em", ["M10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16Zm2.85 10.86a.5.5 0 0 1-.35.14h-5a.5.5 0 0 1 0-1h3.8L7.14 7.85a.5.5 0 1 1 .7-.7L12 11.29V7.5a.5.5 0 0 1 1 0v5a.5.5 0 0 1-.14.35Z"]));
export const ArrowCircleDownRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownRightRegular', "1em", ["M12.85 12.86a.5.5 0 0 1-.35.14h-5a.5.5 0 0 1 0-1h3.8L7.14 7.85a.5.5 0 1 1 .7-.7L12 11.29V7.5a.5.5 0 0 1 1 0v5a.5.5 0 0 1-.14.35ZM10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm7-8a7 7 0 1 1-14 0 7 7 0 0 1 14 0Z"]));
export const ArrowCircleDownSplitFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownSplitFilled', "1em", ["M18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-9.2 2.41a.5.5 0 1 0-.71-.7l-.59.58V9h5v3.3l-.59-.6a.5.5 0 0 0-.7.71l1.44 1.44c.2.2.5.2.7 0l1.44-1.44a.5.5 0 0 0-.7-.7l-.59.58V8.5A.5.5 0 0 0 13 8h-2.5V5.5a.5.5 0 0 0-1 0V8H7a.5.5 0 0 0-.5.5v3.8l-.59-.6a.5.5 0 0 0-.7.71l1.44 1.44c.2.2.5.2.7 0l1.44-1.44Z"]));
export const ArrowCircleDownSplitRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownSplitRegular', "1em", ["m8.8 12.41-1.45 1.44a.5.5 0 0 1-.7 0L5.2 12.41a.5.5 0 0 1 .7-.7l.59.58V8.5c0-.28.22-.5.5-.5h2.5V5.5a.5.5 0 0 1 1 0V8H13c.28 0 .5.22.5.5v3.8l.59-.6a.5.5 0 0 1 .7.71l-1.44 1.44a.5.5 0 0 1-.7 0l-1.44-1.44a.5.5 0 0 1 .7-.7l.59.58V9h-5v3.3l.59-.6a.5.5 0 1 1 .7.71ZM10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm7-8a7 7 0 1 1-14 0 7 7 0 0 1 14 0Z"]));
export const ArrowCircleDownUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownUpFilled', "1em", ["M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm-1-5.8-1.65 1.65a.5.5 0 0 1-.7 0L5 12.21a.5.5 0 1 1 .7-.71l.8.8V6.5a.5.5 0 0 1 1 0v5.8l.8-.8a.5.5 0 1 1 .7.7Zm6-4.4a.5.5 0 0 1-.7.7l-.8-.8v5.8a.5.5 0 0 1-1 0V7.7l-.8.8a.5.5 0 1 1-.7-.7l1.65-1.65c.2-.2.5-.2.7 0L15 7.79Z"]));
export const ArrowCircleDownUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleDownUpRegular', "1em", ["M7.35 13.85 9 12.21a.5.5 0 1 0-.7-.71l-.8.8V6.5a.5.5 0 0 0-1 0v5.8l-.8-.8a.5.5 0 1 0-.7.7l1.65 1.65c.2.2.5.2.7 0ZM15 7.8l-1.65-1.64a.5.5 0 0 0-.7 0L11 7.79a.5.5 0 1 0 .7.71l.8-.8v5.8a.5.5 0 1 0 1 0V7.7l.8.8a.5.5 0 1 0 .7-.7ZM18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-8 7a7 7 0 1 0 0-14 7 7 0 0 0 0 14Z"]));
export const ArrowCircleLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleLeftFilled', "1em", ["M10 18a8 8 0 1 1 0-16 8 8 0 0 1 0 16Zm-.85-4.65a.5.5 0 0 0 .7-.7L7.71 10.5h5.79a.5.5 0 0 0 0-1H7.7l2.15-2.15a.5.5 0 0 0-.7-.7l-3 3a.5.5 0 0 0 0 .7l3 3Z"]));
export const ArrowCircleLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleLeftRegular', "1em", ["m9.15 13.35-3-3a.5.5 0 0 1 0-.7l3-3a.5.5 0 1 1 .7.7L7.71 9.5h5.79a.5.5 0 0 1 0 1H7.7l2.15 2.15a.5.5 0 0 1-.7.7ZM2 10a8 8 0 1 0 16 0 8 8 0 0 0-16 0Zm8 7a7 7 0 1 1 0-14 7 7 0 0 1 0 14Z"]));
export const ArrowCircleRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleRightFilled', "1em", ["M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm.85-4.65a.5.5 0 0 1-.7-.7l2.14-2.15H6.5a.5.5 0 0 1 0-1h5.8l-2.15-2.15a.5.5 0 0 1 .7-.7l3 3c.2.2.2.5 0 .7l-3 3Z"]));
export const ArrowCircleRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleRightRegular', "1em", ["m10.85 13.35 3-3a.5.5 0 0 0 0-.7l-3-3a.5.5 0 0 0-.7.7l2.14 2.15H6.5a.5.5 0 0 0 0 1h5.8l-2.15 2.15a.5.5 0 0 0 .7.7ZM18 10a8 8 0 1 1-16 0 8 8 0 0 1 16 0Zm-8 7a7 7 0 1 0 0-14 7 7 0 0 0 0 14Z"]));
export const ArrowCircleUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpFilled', "1em", ["M2 10a8 8 0 1 1 16 0 8 8 0 0 1-16 0Zm4.65-.85a.5.5 0 1 0 .7.7L9.5 7.71v5.79a.5.5 0 0 0 1 0V7.7l2.15 2.15a.5.5 0 0 0 .7-.7l-3-3a.5.5 0 0 0-.7 0l-3 3Z"]));
export const ArrowCircleUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpRegular', "1em", ["m6.65 9.15 3-3c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7L10.5 7.71v5.79a.5.5 0 0 1-1 0V7.7L7.35 9.86a.5.5 0 0 1-.7-.7ZM10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16Zm-7 8a7 7 0 1 1 14 0 7 7 0 0 1-14 0Z"]));
export const ArrowCircleUpLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpLeftFilled', "1em", ["M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16ZM7.15 7.14A.5.5 0 0 1 7.5 7h5a.5.5 0 0 1 0 1H8.7l4.15 4.15a.5.5 0 0 1-.7.7L8 8.71v3.79a.5.5 0 0 1-1 0v-5a.5.5 0 0 1 .14-.35Z"]));
export const ArrowCircleUpLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpLeftRegular', "1em", ["M7.15 7.14A.5.5 0 0 1 7.5 7h5a.5.5 0 0 1 0 1H8.7l4.15 4.15a.5.5 0 0 1-.7.7L8 8.71v3.79a.5.5 0 0 1-1 0v-5a.5.5 0 0 1 .14-.35ZM10 2a8 8 0 1 0 0 16 8 8 0 0 0 0-16Zm-7 8a7 7 0 1 1 14 0 7 7 0 0 1-14 0Z"]));
export const ArrowCircleUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpRightFilled', "1em", ["M10 18a8 8 0 1 1 0-16 8 8 0 0 1 0 16Zm2.85-10.86A.5.5 0 0 0 12.5 7h-5a.5.5 0 0 0 0 1h3.8l-4.15 4.15a.5.5 0 0 0 .7.7L12 8.71v3.79a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-.14-.35Z"]));
export const ArrowCircleUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpRightRegular', "1em", ["M12.85 7.14A.5.5 0 0 0 12.5 7h-5a.5.5 0 0 0 0 1h3.8l-4.15 4.15a.5.5 0 0 0 .7.7L12 8.71v3.79a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-.14-.35ZM10 2a8 8 0 1 1 0 16 8 8 0 0 1 0-16Zm7 8a7 7 0 1 0-14 0 7 7 0 0 0 14 0Z"]));
export const ArrowCircleUpSparkleFilled = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpSparkleFilled', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM17.5 12c-.27 0-.52-.08-.74-.23a1.4 1.4 0 0 1-.48-.62l-.26-.8a.52.52 0 0 0-.14-.22.64.64 0 0 0-.22-.14l-.77-.25c-.27-.1-.49-.26-.65-.48a1.3 1.3 0 0 1-.12-1.3 1.32 1.32 0 0 1-.45-.22 1.51 1.51 0 0 1-.52-.69l-.36-1.09a1.27 1.27 0 0 0-.29-.47 1.3 1.3 0 0 0-.47-.3l-1.06-.34A1.41 1.41 0 0 1 10 3.5a1.4 1.4 0 0 1 .95-1.35l.22-.07a8 8 0 1 0 6.59 9.9l-.26.02ZM6.65 9.15l3-3c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7L10.5 7.71v5.79a.5.5 0 0 1-1 0V7.7L7.35 9.86a.5.5 0 0 1-.7-.7Z"]));
export const ArrowCircleUpSparkleRegular = ( /*#__PURE__*/createFluentIcon('ArrowCircleUpSparkleRegular', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM17.5 12c-.26 0-.51-.08-.73-.22A7 7 0 1 1 10.1 3a1.42 1.42 0 0 1 .86-.85l.22-.07a8 8 0 1 0 6.59 9.9l-.26.02ZM6.65 9.15l3-3c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7L10.5 7.71v5.79a.5.5 0 0 1-1 0V7.7L7.35 9.86a.5.5 0 0 1-.7-.7Z"]));
export const ArrowClockwiseFilled = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseFilled', "1em", ["M4 10a6 6 0 0 1 9.97-4.5h-1.22a.75.75 0 0 0 0 1.5h3c.41 0 .75-.34.75-.75v-3a.75.75 0 0 0-1.5 0v1.16a7.5 7.5 0 1 0 2.5 5.31.75.75 0 0 0-1.5.06V10a6 6 0 0 1-12 0Z"]));
export const ArrowClockwiseRegular = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseRegular', "1em", ["M4 10a6 6 0 0 1 10.47-4H12.5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-1 0v1.6a7 7 0 1 0 1.98 4.36.5.5 0 1 0-1 .08L16 10a6 6 0 0 1-12 0Z"]));
export const ArrowClockwiseDashesColor = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseDashesColor', "1em", `<path d="M10 2c-.42 0-.84.03-1.25.1a1 1 0 0 0 .31 1.97 6.05 6.05 0 0 1 1.7-.02 1 1 0 1 0 .26-1.99A8.07 8.07 0 0 0 10 2Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__a)"/><path d="M10 2c-.42 0-.84.03-1.25.1a1 1 0 0 0 .31 1.97 6.05 6.05 0 0 1 1.7-.02 1 1 0 1 0 .26-1.99A8.07 8.07 0 0 0 10 2Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__b)"/><path d="M13.92 3.03a1 1 0 1 0-.98 1.74c.37.2.71.45 1.03.73H13a1 1 0 1 0 0 2h3.5a1 1 0 0 0 1-1V3a1 1 0 1 0-2 0v1.2c-.47-.46-1-.85-1.58-1.17Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__c)"/><path d="M13.92 3.03a1 1 0 1 0-.98 1.74c.37.2.71.45 1.03.73H13a1 1 0 1 0 0 2h3.5a1 1 0 0 0 1-1V3a1 1 0 1 0-2 0v1.2c-.47-.46-1-.85-1.58-1.17Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__d)"/><path d="M6.47 5.14A1 1 0 0 0 5.3 3.53c-.68.5-1.28 1.09-1.77 1.77a1 1 0 0 0 1.61 1.17c.38-.5.82-.95 1.33-1.33Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__e)"/><path d="M6.47 5.14A1 1 0 0 0 5.3 3.53c-.68.5-1.28 1.09-1.77 1.77a1 1 0 0 0 1.61 1.17c.38-.5.82-.95 1.33-1.33Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__f)"/><path d="M4.07 9.06a1 1 0 0 0-1.97-.31 8.05 8.05 0 0 0 0 2.5 1 1 0 0 0 1.97-.31 6.05 6.05 0 0 1 0-1.88Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__g)"/><path d="M4.07 9.06a1 1 0 0 0-1.97-.31 8.05 8.05 0 0 0 0 2.5 1 1 0 0 0 1.97-.31 6.05 6.05 0 0 1 0-1.88Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__h)"/><path d="M17.92 11.14a1 1 0 0 0-1.98-.28c-.04.28-.1.56-.18.83a1 1 0 0 0 1.92.57c.1-.36.18-.74.24-1.12Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__i)"/><path d="M17.92 11.14a1 1 0 0 0-1.98-.28c-.04.28-.1.56-.18.83a1 1 0 0 0 1.92.57c.1-.36.18-.74.24-1.12Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__j)"/><path d="M5.14 13.53a1 1 0 1 0-1.61 1.17c.5.68 1.09 1.28 1.77 1.77a1 1 0 0 0 1.17-1.61c-.5-.38-.95-.82-1.33-1.33Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__k)"/><path d="M5.14 13.53a1 1 0 1 0-1.61 1.17c.5.68 1.09 1.28 1.77 1.77a1 1 0 0 0 1.17-1.61c-.5-.38-.95-.82-1.33-1.33Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__l)"/><path d="M16.04 15.24a1 1 0 1 0-1.5-1.31c-.38.43-.82.8-1.3 1.12a1 1 0 0 0 1.08 1.68 8.04 8.04 0 0 0 1.72-1.49Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__m)"/><path d="M16.04 15.24a1 1 0 1 0-1.5-1.31c-.38.43-.82.8-1.3 1.12a1 1 0 0 0 1.08 1.68 8.04 8.04 0 0 0 1.72-1.49Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__n)"/><path d="M9.06 15.93a1 1 0 0 0-.31 1.97 8.06 8.06 0 0 0 2.39.02 1 1 0 0 0-.28-1.98 6.06 6.06 0 0 1-1.8-.01Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__o)"/><path d="M9.06 15.93a1 1 0 0 0-.31 1.97 8.06 8.06 0 0 0 2.39.02 1 1 0 0 0-.28-1.98 6.06 6.06 0 0 1-1.8-.01Z" fill="url(#ic_fluent_arrow_clockwise_dashes_20_color__p)"/><defs><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__a" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__b" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__c" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__d" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__e" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__f" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__g" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__h" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__i" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__j" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__k" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__l" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__m" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__n" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__o" x1="4.25" y1="2" x2="18" y2="23" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_20_color__p" x1="9.96" y1=".1" x2="13.57" y2="27.14" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient></defs>`, { color: true }));
export const ArrowClockwiseDashesFilled = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseDashesFilled', "1em", ["M16.5 3.25a.75.75 0 0 0-1.5 0v1.16a7.48 7.48 0 0 0-3.42-1.74c-.44-.1-.83.26-.83.7 0 .39.29.7.66.8.97.23 1.84.7 2.56 1.33h-1.22a.75.75 0 0 0 0 1.5h3c.41 0 .75-.34.75-.75v-3Zm-8.08-.58c.44-.1.83.26.83.7 0 .39-.29.7-.66.8-.61.14-1.2.39-1.72.7a.83.83 0 0 1-1.02-.08c-.32-.32-.3-.85.08-1.1a7.46 7.46 0 0 1 2.5-1.02Zm8.2 8.08c-.38 0-.7.29-.79.66-.14.61-.39 1.2-.7 1.72-.2.32-.19.75.09 1.02.31.32.84.3 1.08-.08.49-.75.84-1.6 1.03-2.5.1-.43-.26-.82-.7-.82Zm-5.2 5.08a.83.83 0 0 0-.67.8c0 .44.39.8.83.7.9-.19 1.74-.54 2.49-1.03.38-.24.4-.77.08-1.09a.83.83 0 0 0-1.02-.09c-.53.32-1.1.57-1.72.71Zm-4.55-.7a.83.83 0 0 0-1.02.08c-.32.32-.3.85.08 1.1.75.48 1.6.83 2.5 1.02.43.1.82-.26.82-.7 0-.39-.29-.7-.66-.8-.61-.14-1.2-.39-1.72-.7Zm-2.7-3.72a.83.83 0 0 0-.8-.66c-.44 0-.8.39-.7.83.2.9.55 1.74 1.03 2.49.24.38.77.4 1.09.08.27-.27.29-.7.09-1.02a5.96 5.96 0 0 1-.71-1.72Zm.71-4.54a.83.83 0 0 0-.1-1.02c-.31-.32-.84-.3-1.08.08a7.46 7.46 0 0 0-1.03 2.5c-.1.43.26.82.7.82.39 0 .7-.29.8-.66.15-.62.39-1.2.71-1.72Z"]));
export const ArrowClockwiseDashesRegular = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseDashesRegular', "1em", ["M16 3.5a.5.5 0 0 0-1 0v1.6c-.98-1-2.26-1.7-3.7-1.98a.48.48 0 0 0-.55.48c0 .26.19.47.44.52A6 6 0 0 1 14.47 6H12.5a.5.5 0 0 0 0 1h3.02c.3-.01.5-.25.48-.51V3.5Zm-7.3-.38c.29-.05.55.18.55.48 0 .26-.19.47-.44.52-.77.15-1.5.46-2.13.88a.54.54 0 0 1-.67-.05.48.48 0 0 1 .05-.74 6.96 6.96 0 0 1 2.63-1.09Zm7.7 7.63a.54.54 0 0 0-.52.44c-.15.77-.46 1.5-.88 2.13-.14.21-.13.5.05.67.22.22.57.2.74-.05.53-.78.9-1.67 1.09-2.63a.48.48 0 0 0-.48-.56Zm-5.21 5.13a.54.54 0 0 0-.44.52c0 .3.26.53.56.48a6.96 6.96 0 0 0 2.63-1.1.47.47 0 0 0 .05-.73.54.54 0 0 0-.67-.05c-.64.42-1.36.73-2.13.88ZM6.69 15a.54.54 0 0 0-.68.05c-.22.22-.2.57.05.74.78.53 1.67.9 2.63 1.09.3.05.56-.18.56-.48a.54.54 0 0 0-.44-.52A5.97 5.97 0 0 1 6.68 15Zm-2.57-3.81a.54.54 0 0 0-.52-.44c-.3 0-.53.26-.48.56.18.96.56 1.85 1.1 2.63.16.25.51.27.73.05.18-.18.2-.46.05-.67a5.97 5.97 0 0 1-.88-2.13ZM5 6.69A.54.54 0 0 0 4.95 6a.48.48 0 0 0-.74.05 6.96 6.96 0 0 0-1.09 2.63c-.05.3.18.56.48.56.26 0 .47-.19.52-.44.15-.77.46-1.5.88-2.13Z"]));
export const ArrowClockwiseDashesSettingsColor = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseDashesSettingsColor', "1em", `<path d="M8.75 2.1a8.05 8.05 0 0 1 2.27-.04 1 1 0 1 1-.25 1.99 6.06 6.06 0 0 0-1.71.02 1 1 0 1 1-.31-1.97Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__a)"/><path d="M8.75 2.1a8.05 8.05 0 0 1 2.27-.04 1 1 0 1 1-.25 1.99 6.06 6.06 0 0 0-1.71.02 1 1 0 1 1-.31-1.97Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__b)"/><path d="M12.56 3.4a1 1 0 0 1 1.36-.37c.58.32 1.1.71 1.58 1.16V3a1 1 0 1 1 2 0v3.5a1 1 0 0 1-1 1H13a1 1 0 1 1 0-2h.97a6.02 6.02 0 0 0-1.03-.73 1 1 0 0 1-.38-1.36Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__c)"/><path d="M12.56 3.4a1 1 0 0 1 1.36-.37c.58.32 1.1.71 1.58 1.16V3a1 1 0 1 1 2 0v3.5a1 1 0 0 1-1 1H13a1 1 0 1 1 0-2h.97a6.02 6.02 0 0 0-1.03-.73 1 1 0 0 1-.38-1.36Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__d)"/><path d="M6.47 5.14A1 1 0 0 0 5.3 3.53c-.68.5-1.28 1.09-1.77 1.77a1 1 0 0 0 1.61 1.17c.38-.5.82-.95 1.33-1.33Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__e)"/><path d="M6.47 5.14A1 1 0 0 0 5.3 3.53c-.68.5-1.28 1.09-1.77 1.77a1 1 0 0 0 1.61 1.17c.38-.5.82-.95 1.33-1.33Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__f)"/><path d="M3.24 7.92a1 1 0 0 1 .83 1.14 6.05 6.05 0 0 0 0 1.88 1 1 0 0 1-1.97.31 8.05 8.05 0 0 1 0-2.5 1 1 0 0 1 1.14-.83Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__g)"/><path d="M3.24 7.92a1 1 0 0 1 .83 1.14 6.05 6.05 0 0 0 0 1.88 1 1 0 0 1-1.97.31 8.05 8.05 0 0 1 0-2.5 1 1 0 0 1 1.14-.83Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__h)"/><path d="M3.75 13.3a1 1 0 0 1 1.4.23c.37.5.81.95 1.32 1.33a1 1 0 0 1-1.17 1.61 8.04 8.04 0 0 1-1.77-1.77 1 1 0 0 1 .22-1.4Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__i)"/><path d="M3.75 13.3a1 1 0 0 1 1.4.23c.37.5.81.95 1.32 1.33a1 1 0 0 1-1.17 1.61 8.04 8.04 0 0 1-1.77-1.77 1 1 0 0 1 .22-1.4Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__j)"/><path d="M7.92 16.76a1 1 0 0 1 1.14-.83c.26.04.52.06.8.07l.1.03.34.08c.56.13.9.7.73 1.26l-.12.42a1 1 0 0 0-.04.16 8.07 8.07 0 0 1-2.12-.05 1 1 0 0 1-.83-1.14Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__k)"/><path d="M7.92 16.76a1 1 0 0 1 1.14-.83c.26.04.52.06.8.07l.1.03.34.08c.56.13.9.7.73 1.26l-.12.42a1 1 0 0 0-.04.16 8.07 8.07 0 0 1-2.12-.05 1 1 0 0 1-.83-1.14Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__l)"/><path d="M10.64 13.92a2 2 0 0 0 1.43-2.48l-.16-.55c.25-.2.53-.37.82-.5l.34.36a2 2 0 0 0 2.9 0l.33-.35c.3.14.58.32.84.52l-.13.42a2 2 0 0 0 1.46 2.52l.35.09a4.7 4.7 0 0 1 0 1.01l-.45.12a2 2 0 0 0-1.43 2.48l.15.55c-.25.2-.53.37-.82.5l-.34-.36a2 2 0 0 0-2.9 0l-.33.35c-.3-.14-.58-.32-.84-.52l.13-.42a2 2 0 0 0-1.46-2.52l-.35-.09a4.71 4.71 0 0 1 0-1.01l.46-.12Zm4.86.58a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z" fill="url(#ic_fluent_arrow_clockwise_dashes_settings_20_color__m)"/><defs><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__a" x1="4.25" y1="2" x2="3.58" y2="22.53" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__b" x1="9.96" y1=".1" x2="22.05" y2="22.58" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__c" x1="4.25" y1="2" x2="3.58" y2="22.53" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__d" x1="9.96" y1=".1" x2="22.05" y2="22.58" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__e" x1="4.25" y1="2" x2="3.58" y2="22.53" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__f" x1="9.96" y1=".1" x2="22.05" y2="22.58" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__g" x1="4.25" y1="2" x2="3.58" y2="22.53" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__h" x1="9.96" y1=".1" x2="22.05" y2="22.58" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__i" x1="4.25" y1="2" x2="3.58" y2="22.53" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__j" x1="9.96" y1=".1" x2="22.05" y2="22.58" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__k" x1="4.25" y1="2" x2="3.58" y2="22.53" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset=".92" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__l" x1="9.96" y1=".1" x2="22.05" y2="22.58" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_arrow_clockwise_dashes_settings_20_color__m" x1="16.67" y1="18.29" x2="12.28" y2="10.74" gradientUnits="userSpaceOnUse"><stop stop-color="#70777D"/><stop offset="1" stop-color="#B9C0C7"/></linearGradient></defs>`, { color: true }));
export const ArrowClockwiseDashesSettingsFilled = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseDashesSettingsFilled', "1em", ["M16.5 3.25a.75.75 0 0 0-1.5 0v1.16a7.48 7.48 0 0 0-3.42-1.74c-.44-.1-.83.26-.83.7 0 .39.29.7.66.8.97.23 1.84.7 2.56 1.33h-1.22a.75.75 0 0 0 0 1.5h3c.41 0 .75-.34.75-.75v-3Zm-8.08-.58c.44-.1.83.26.83.7 0 .39-.29.7-.66.8-.61.14-1.2.39-1.72.7a.83.83 0 0 1-1.02-.08c-.32-.32-.3-.85.08-1.1a7.46 7.46 0 0 1 2.5-1.02ZM6.87 15.12a.83.83 0 0 0-1.02.1c-.32.31-.3.84.08 1.08.75.49 1.6.84 2.5 1.03.43.1.82-.26.82-.7 0-.39-.29-.7-.66-.8-.61-.14-1.2-.39-1.72-.7Zm-2.7-3.71a.83.83 0 0 0-.8-.66c-.44 0-.8.39-.7.83.2.9.55 1.74 1.03 2.49.24.38.77.4 1.09.08.27-.27.29-.7.09-1.02a5.96 5.96 0 0 1-.71-1.72Zm.71-4.54a.83.83 0 0 0-.1-1.02c-.31-.32-.84-.3-1.08.08a7.46 7.46 0 0 0-1.03 2.5c-.1.43.26.82.7.82.39 0 .7-.29.8-.66.15-.62.39-1.2.71-1.72Zm7.19 4.57a2 2 0 0 1-1.43 2.48l-.46.12a4.7 4.7 0 0 0 0 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.29.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const ArrowClockwiseDashesSettingsRegular = ( /*#__PURE__*/createFluentIcon('ArrowClockwiseDashesSettingsRegular', "1em", ["M16 3.5a.5.5 0 0 0-1 0v1.6c-.98-1-2.26-1.7-3.7-1.98a.48.48 0 0 0-.55.48c0 .26.19.47.44.52A6 6 0 0 1 14.47 6H12.5a.5.5 0 0 0 0 1h3c.3 0 .52-.25.5-.51V3.5Zm-7.3-.38c.29-.05.55.18.55.48 0 .26-.19.47-.44.52-.77.15-1.5.46-2.13.88a.54.54 0 0 1-.67-.05.48.48 0 0 1 .05-.74 6.96 6.96 0 0 1 2.63-1.09ZM6.67 15a.54.54 0 0 0-.67.05c-.22.22-.2.57.05.74.78.53 1.67.9 2.63 1.09.3.05.56-.18.56-.48a.54.54 0 0 0-.44-.52A5.97 5.97 0 0 1 6.68 15Zm-2.56-3.81a.54.54 0 0 0-.52-.44c-.3 0-.53.26-.48.56.18.96.56 1.85 1.1 2.63.16.25.51.27.73.05.18-.18.2-.46.05-.67a5.97 5.97 0 0 1-.88-2.13ZM5 6.69A.54.54 0 0 0 4.95 6a.48.48 0 0 0-.74.05 6.96 6.96 0 0 0-1.09 2.63c-.05.3.18.56.48.56.26 0 .47-.19.52-.44.15-.77.46-1.5.88-2.13Zm7.07 4.75a2 2 0 0 1-1.43 2.48l-.46.12a4.7 4.7 0 0 0 0 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.29.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const ArrowCollapseAllFilled = ( /*#__PURE__*/createFluentIcon('ArrowCollapseAllFilled', "1em", ["M2 4.75c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.75Zm8 3c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75Zm-3.72-.53a.75.75 0 0 0-1.06 0l-2.5 2.5a.75.75 0 1 0 1.06 1.06L5 9.56v5.69a.75.75 0 0 0 1.5 0V9.56l1.22 1.22a.75.75 0 1 0 1.06-1.06l-2.5-2.5Z"], { flipInRtl: true }));
export const ArrowCollapseAllRegular = ( /*#__PURE__*/createFluentIcon('ArrowCollapseAllRegular', "1em", ["M2 4.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm3.15 2.65c.2-.2.5-.2.7 0l2.5 2.5a.5.5 0 0 1-.7.7L6 8.71v6.79a.5.5 0 0 1-1 0V8.7l-1.65 1.65a.5.5 0 0 1-.7-.7l2.5-2.5ZM17.5 8h-7a.5.5 0 0 1 0-1h7a.5.5 0 0 1 0 1Z"], { flipInRtl: true }));
export const ArrowCounterclockwiseFilled = ( /*#__PURE__*/createFluentIcon('ArrowCounterclockwiseFilled', "1em", ["M16 10a6 6 0 0 0-9.97-4.5h1.22a.75.75 0 0 1 0 1.5h-3a.75.75 0 0 1-.75-.75v-3a.75.75 0 0 1 1.5 0v1.16a7.5 7.5 0 1 1-2.5 5.31.75.75 0 1 1 1.5.06V10a6 6 0 0 0 12 0Z"]));
export const ArrowCounterclockwiseRegular = ( /*#__PURE__*/createFluentIcon('ArrowCounterclockwiseRegular', "1em", ["M16 10A6 6 0 0 0 5.53 6H7.5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v1.6a7 7 0 1 1-1.98 4.36.5.5 0 0 1 1 .08L4 10a6 6 0 0 0 12 0Z"]));
export const ArrowCounterclockwiseDashesFilled = ( /*#__PURE__*/createFluentIcon('ArrowCounterclockwiseDashesFilled', "1em", ["M3.5 3.25a.75.75 0 1 1 1.5 0V4.4a7.48 7.48 0 0 1 3.42-1.73c.44-.1.83.26.83.7 0 .39-.29.7-.66.8-.97.23-1.84.7-2.56 1.33h1.22a.75.75 0 0 1 0 1.5h-3a.75.75 0 0 1-.75-.75v-3Zm8.08-.58c-.44-.1-.83.26-.83.7 0 .39.29.7.66.8.61.14 1.2.39 1.72.7.32.2.75.19 1.02-.08.32-.32.3-.85-.08-1.1a7.46 7.46 0 0 0-2.5-1.02Zm-8.2 8.08c.38 0 .7.29.78.66.15.61.4 1.2.72 1.72.2.32.18.75-.1 1.02-.31.32-.84.3-1.08-.08a7.46 7.46 0 0 1-1.04-2.5c-.09-.43.26-.82.71-.82Zm5.2 5.08c.38.1.67.41.67.8 0 .44-.4.8-.83.7-.9-.19-1.74-.54-2.5-1.03-.37-.24-.4-.77-.07-1.09.27-.27.7-.29 1.02-.09.53.32 1.1.57 1.72.71Zm4.55-.7a.83.83 0 0 1 1.02.08c.32.32.3.85-.08 1.1-.75.48-1.6.83-2.5 1.02-.43.1-.82-.26-.82-.7 0-.39.29-.7.66-.8.61-.14 1.2-.39 1.72-.7Zm2.7-3.72c.1-.37.4-.66.8-.66.44 0 .8.39.7.83-.2.9-.55 1.74-1.03 2.49-.24.38-.77.4-1.09.08a.83.83 0 0 1-.1-1.02c.33-.53.57-1.1.72-1.72Zm-.71-4.54a.83.83 0 0 1 .1-1.02c.31-.32.84-.3 1.08.08.48.75.84 1.6 1.03 2.5.1.43-.26.82-.7.82a.83.83 0 0 1-.8-.66c-.15-.62-.39-1.2-.71-1.72Z"]));
export const ArrowCounterclockwiseDashesRegular = ( /*#__PURE__*/createFluentIcon('ArrowCounterclockwiseDashesRegular', "1em", ["M4 3.5a.5.5 0 0 1 1 0v1.6c.98-1 2.26-1.7 3.7-1.98.29-.05.55.18.55.48 0 .26-.19.47-.44.52A6 6 0 0 0 5.53 6H7.5a.5.5 0 0 1 0 1H4.48A.49.49 0 0 1 4 6.49V3.5Zm7.3-.38a.48.48 0 0 0-.55.48c0 .26.19.47.44.52.77.15 1.5.46 2.13.88.21.14.5.13.67-.05a.48.48 0 0 0-.05-.74 6.96 6.96 0 0 0-2.63-1.09Zm-7.7 7.63c.26 0 .47.19.52.44.15.77.46 1.5.88 2.13.14.21.13.5-.05.67a.48.48 0 0 1-.74-.05 6.96 6.96 0 0 1-1.09-2.63.48.48 0 0 1 .48-.56Zm5.21 5.13c.25.05.44.26.44.52 0 .3-.26.53-.56.48a6.96 6.96 0 0 1-2.63-1.1.48.48 0 0 1-.05-.73c.18-.18.46-.2.67-.05.64.42 1.36.73 2.13.88Zm4.5-.88c.22-.14.5-.13.68.05.22.22.2.57-.05.74-.78.53-1.67.9-2.63 1.09a.48.48 0 0 1-.56-.48c0-.26.19-.47.44-.52.77-.15 1.5-.46 2.13-.88Zm2.57-3.81a.54.54 0 0 1 .52-.44c.3 0 .53.26.48.56a6.96 6.96 0 0 1-1.1 2.63.48.48 0 0 1-.73.05.54.54 0 0 1-.05-.67c.42-.64.73-1.36.88-2.13ZM15 6.69a.54.54 0 0 1 .05-.68c.22-.22.57-.2.74.05.53.78.9 1.67 1.09 2.63.05.3-.18.56-.48.56a.54.54 0 0 1-.52-.44A5.97 5.97 0 0 0 15 6.68Z"]));
export const ArrowCounterclockwiseInfoFilled = ( /*#__PURE__*/createFluentIcon('ArrowCounterclockwiseInfoFilled', "1em", ["M17.5 9.89c-.47-.3-1-.55-1.55-.7A6 6 0 0 0 6.03 5.5h1.22a.75.75 0 0 1 0 1.5h-3a.75.75 0 0 1-.75-.75v-3a.75.75 0 0 1 1.5 0v1.16a7.5 7.5 0 0 1 12.5 5.48ZM2.5 10a7.5 7.5 0 0 0 7.39 7.5c-.3-.47-.55-1-.7-1.55A6 6 0 0 1 4 9.78a.75.75 0 1 0-1.5-.06V10Zm7.5 4.5a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0Zm4.5 2.5a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v2c0 .28.22.5.5.5Zm0-5.13a.62.62 0 1 0 0 1.25.62.62 0 0 0 0-1.24Z"]));
export const ArrowCounterclockwiseInfoRegular = ( /*#__PURE__*/createFluentIcon('ArrowCounterclockwiseInfoRegular', "1em", ["M16.99 9.6c-.33-.17-.68-.3-1.04-.4A6 6 0 0 0 5.53 6H7.5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v1.6a7 7 0 0 1 11.99 4.5ZM3 10a7 7 0 0 0 6.6 6.99c-.17-.33-.3-.68-.4-1.04a6 6 0 0 1-5.18-6.41.5.5 0 1 0-1-.08A7.1 7.1 0 0 0 3 10Zm7 4.5a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0Zm4.5 2.5a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v2c0 .28.22.5.5.5Zm0-5.13a.62.62 0 1 0 0 1.25.62.62 0 0 0 0-1.24Z"]));
export const ArrowCurveDownLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowCurveDownLeftFilled', "1em", ["M13.39 3.14a.75.75 0 1 0-.78-1.28 7.2 7.2 0 0 0-2.98 3.13A11.6 11.6 0 0 0 8.75 10v5.44l-2.72-2.72a.75.75 0 1 0-1.06 1.06l4 4c.3.3.77.3 1.06 0l4-4a.75.75 0 0 0-1.06-1.06l-2.72 2.72V10c0-1.95.25-3.32.74-4.37a5.71 5.71 0 0 1 2.4-2.49Z"]));
export const ArrowCurveDownLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowCurveDownLeftRegular', "1em", ["M13.26 2.93a.5.5 0 0 0-.52-.86A6.95 6.95 0 0 0 9.86 5.1C9.26 6.38 9 7.96 9 10v6.3l-3.15-3.15a.5.5 0 1 0-.7.7l4 4c.2.2.5.2.7 0l4-4a.5.5 0 0 0-.7-.7L10 16.29V10c0-1.96.25-3.38.76-4.47a5.96 5.96 0 0 1 2.5-2.6Z"]));
export const ArrowCurveDownRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowCurveDownRightFilled', "1em", ["M6.61 3.14a.75.75 0 1 1 .78-1.28 7.2 7.2 0 0 1 2.98 3.13c.63 1.33.88 2.96.88 5.01v5.44l2.72-2.72a.75.75 0 1 1 1.06 1.06l-4 4c-.3.3-.77.3-1.06 0l-4-4a.75.75 0 0 1 1.06-1.06l2.72 2.72V10c0-1.95-.25-3.32-.74-4.37a5.71 5.71 0 0 0-2.4-2.49Z"]));
export const ArrowCurveDownRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowCurveDownRightRegular', "1em", ["M6.74 2.93a.5.5 0 1 1 .52-.86 6.95 6.95 0 0 1 2.88 3.03c.6 1.28.86 2.86.86 4.9v6.3l3.15-3.15a.5.5 0 0 1 .7.7l-4 4a.5.5 0 0 1-.7 0l-4-4a.5.5 0 1 1 .7-.7L10 16.29V10c0-1.96-.25-3.38-.76-4.47a5.96 5.96 0 0 0-2.5-2.6Z"]));
export const ArrowCurveUpLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowCurveUpLeftFilled', "1em", ["M6.03 7.03a.75.75 0 0 1-1.06-1.06l4-4c.3-.3.77-.3 1.06 0l4 4a.75.75 0 0 1-1.06 1.06l-2.72-2.72v5.44c0 1.95.25 3.32.74 4.37a5.71 5.71 0 0 0 2.4 2.49.75.75 0 1 1-.78 1.28 7.2 7.2 0 0 1-2.98-3.13 11.6 11.6 0 0 1-.88-5.01V4.31L6.03 7.03Z"]));
export const ArrowCurveUpLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowCurveUpLeftRegular', "1em", ["M5.85 6.85a.5.5 0 1 1-.7-.7l4-4c.2-.2.5-.2.7 0l4 4a.5.5 0 0 1-.7.7L10 3.71V10c0 1.96.25 3.38.76 4.47a5.96 5.96 0 0 0 2.5 2.6.5.5 0 0 1-.52.86 6.95 6.95 0 0 1-2.88-3.03C9.26 13.62 9 12.04 9 10V3.7L5.85 6.86Z"]));
export const ArrowCurveUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowCurveUpRightFilled', "1em", ["M13.97 7.03a.75.75 0 1 0 1.06-1.06l-4-4a.75.75 0 0 0-1.06 0l-4 4a.75.75 0 0 0 1.06 1.06l2.72-2.72v5.44c0 1.95-.25 3.32-.74 4.37a5.71 5.71 0 0 1-2.4 2.49.75.75 0 1 0 .78 1.28 7.2 7.2 0 0 0 2.98-3.13c.63-1.33.88-2.96.88-5.01V4.31l2.72 2.72Z"]));
export const ArrowCurveUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowCurveUpRightRegular', "1em", ["M14.15 6.85a.5.5 0 0 0 .7-.7l-4-4a.5.5 0 0 0-.7 0l-4 4a.5.5 0 1 0 .7.7L10 3.71V10c0 1.96-.25 3.38-.76 4.47a5.96 5.96 0 0 1-2.5 2.6.5.5 0 0 0 .52.86 6.95 6.95 0 0 0 2.88-3.03c.6-1.28.86-2.86.86-4.9V3.7l3.15 3.15Z"]));
export const ArrowDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowDownFilled', "1em", ["M16.8 11.27a.75.75 0 0 0-1.1-1.04l-4.95 5.24V2.75a.75.75 0 0 0-1.5 0v12.73l-4.96-5.25a.75.75 0 0 0-1.09 1.04l6.07 6.41a1 1 0 0 0 1.45 0l6.07-6.41Z"]));
export const ArrowDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowDownRegular', "1em", ["M16.87 10.84a.5.5 0 1 0-.74-.68l-5.63 6.17V2.5a.5.5 0 0 0-1 0v13.83l-5.63-6.17a.5.5 0 0 0-.74.68l6.31 6.91a.75.75 0 0 0 1.11 0l6.32-6.91Z"]));
export const ArrowDownExclamationFilled = ( /*#__PURE__*/createFluentIcon('ArrowDownExclamationFilled', "1em", ["M3 5a3 3 0 0 1 6 0c0 2.25-.79 5.21-1.22 6.69C7.54 12.49 6.8 13 6 13s-1.54-.52-1.78-1.31C3.8 10.2 3 7.23 3 5Zm1 11a2 2 0 1 1 4 0 2 2 0 0 1-4 0ZM15 2.5a.5.5 0 0 0-1 0v13.8l-2.15-2.15a.5.5 0 0 0-.7.7l3 3c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7L15 16.29V2.5Z"]));
export const ArrowDownExclamationRegular = ( /*#__PURE__*/createFluentIcon('ArrowDownExclamationRegular', "1em", ["M4 5a2 2 0 1 1 4 0c0 2.09-.75 4.93-1.18 6.4-.1.36-.43.6-.82.6a.84.84 0 0 1-.82-.6C4.75 9.91 4 7.07 4 5Zm2-3a3 3 0 0 0-3 3c0 2.23.79 5.2 1.22 6.69C4.46 12.48 5.2 13 6 13s1.54-.52 1.78-1.31C8.2 10.2 9 7.25 9 5a3 3 0 0 0-3-3ZM5 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm9-11.5a.5.5 0 0 0-1 0v13.8l-2.15-2.15a.5.5 0 0 0-.7.7l3 3c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7L15 16.29V2.5Z"]));
export const ArrowDownLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowDownLeftFilled', "1em", ["M12 16.25c0 .41-.34.75-.75.75h-7.5a.75.75 0 0 1-.75-.75v-7.5a.75.75 0 1 1 1.5 0v5.69L15.72 3.22a.75.75 0 1 1 1.06 1.06L5.56 15.5h5.7c.4 0 .74.34.74.75Z"]));
export const ArrowDownLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowDownLeftRegular', "1em", ["M11.5 16a.5.5 0 0 1 0 1h-8a.5.5 0 0 1-.5-.5v-8a.5.5 0 0 1 1 0v6.8L16.15 3.14a.5.5 0 1 1 .7.7L4.71 16h6.79Z"]));
export const ArrowDownRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowDownRightFilled', "1em", ["M8 16.25c0 .41.34.75.75.75h7.5c.41 0 .75-.34.75-.75v-7.5a.75.75 0 1 0-1.5 0v5.69L4.28 3.22a.75.75 0 1 0-1.06 1.06L14.44 15.5h-5.7a.75.75 0 0 0-.74.75Z"], { flipInRtl: true }));
export const ArrowDownRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowDownRightRegular', "1em", ["M8.5 16a.5.5 0 0 0 0 1h8a.5.5 0 0 0 .5-.5v-8a.5.5 0 0 0-1 0v6.8L3.85 3.14a.5.5 0 1 0-.7.7L15.29 16H8.5Z"], { flipInRtl: true }));
export const ArrowDownloadFilled = ( /*#__PURE__*/createFluentIcon('ArrowDownloadFilled', "1em", ["M15.24 16.5a.75.75 0 0 1 .1 1.5H4.76a.75.75 0 0 1-.1-1.5h10.6ZM10 2c.38 0 .7.28.75.65V12.95l2.97-2.98c.27-.26.68-.29.98-.07l.08.07c.27.27.3.68.07.98l-.07.08-4.24 4.25-.07.07-.1.05-.03.03-.1.03-.11.03-.07.01H10l-.15-.01-.08-.03a.73.73 0 0 1-.26-.14l-4.29-4.29A.75.75 0 0 1 6.2 9.9l.08.07 2.97 2.97V2.75c0-.41.34-.75.75-.75Z"]));
export const ArrowDownloadRegular = ( /*#__PURE__*/createFluentIcon('ArrowDownloadRegular', "1em", ["M15.5 17a.5.5 0 0 1 .09 1H4.5a.5.5 0 0 1-.09-1H15.5ZM10 2a.5.5 0 0 1 .5.41V14.3l3.64-3.65a.5.5 0 0 1 .64-.06l.07.06c.17.17.2.44.06.63l-.06.07-4.5 4.5a.5.5 0 0 1-.25.14L10 16a.5.5 0 0 1-.4-.2l-4.46-4.45a.5.5 0 0 1 .64-.76l.07.06 3.65 3.64V2.5c0-.27.22-.5.5-.5Z"]));
export const ArrowDownloadOffFilled = ( /*#__PURE__*/createFluentIcon('ArrowDownloadOffFilled', "1em", ["m9.25 9.96-7.1-7.1a.5.5 0 1 1 .7-.71l15 15a.5.5 0 0 1-.7.7l-4.6-4.59-2.01 2.02-.07.06-.1.06-.03.02-.1.04-.11.03-.07.01H10l-.15-.01-.08-.03a.73.73 0 0 1-.26-.14l-4.29-4.29A.75.75 0 0 1 6.2 9.9l.08.07 2.97 2.97V9.96Zm2.24 2.24-.74-.74v1.48l.74-.74Zm2.48-.35-1.06-1.06.8-.82c.27-.26.7-.29.99-.07l.08.07c.27.27.3.68.07.98l-.07.08-.81.82ZM9.25 7.13l1.5 1.5V2.65a.75.75 0 0 0-1.5.1v4.38Zm6 9.37a.75.75 0 0 1 .1 1.5H4.75a.75.75 0 0 1-.1-1.5h10.6Z"]));
export const ArrowDownloadOffRegular = ( /*#__PURE__*/createFluentIcon('ArrowDownloadOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L9.5 10.2v4.09l-3.65-3.64-.07-.06a.5.5 0 0 0-.64.76l4.46 4.46c.1.11.24.19.4.19l.1-.01a.5.5 0 0 0 .26-.14l2.39-2.4 4.4 4.4a.5.5 0 0 0 .7-.7l-15-15Zm9.2 10.6-1.55 1.54V11.2l1.54 1.55Zm2.11-.7-.7-.72.68-.68a.5.5 0 0 1 .64-.06l.07.06c.17.17.2.44.06.63l-.06.07-.69.7ZM9.5 7.37l1 1V2.4a.5.5 0 0 0-1 .1v4.87Zm6 9.62a.5.5 0 0 1 .09 1H4.5a.5.5 0 0 1-.09-1H15.5Z"]));
export const ArrowEjectFilled = ( /*#__PURE__*/createFluentIcon('ArrowEjectFilled', "1em", ["M11.2 4.6c-.6-.8-1.8-.8-2.4 0l-4.5 6A1.5 1.5 0 0 0 5.5 13h9a1.5 1.5 0 0 0 1.2-2.4l-4.5-6ZM4 15a.5.5 0 0 0 0 1h12a.5.5 0 0 0 0-1H4Z"]));
export const ArrowEjectRegular = ( /*#__PURE__*/createFluentIcon('ArrowEjectRegular', "1em", ["M9.6 5.2a.5.5 0 0 1 .8 0l4.5 6a.5.5 0 0 1-.4.8h-9a.5.5 0 0 1-.4-.8l4.5-6Zm1.6-.6c-.6-.8-1.8-.8-2.4 0l-4.5 6A1.5 1.5 0 0 0 5.5 13h9a1.5 1.5 0 0 0 1.2-2.4l-4.5-6ZM4 15a.5.5 0 0 0 0 1h12a.5.5 0 0 0 0-1H4Z"]));
export const ArrowEnterFilled = ( /*#__PURE__*/createFluentIcon('ArrowEnterFilled', "1em", ["M7.75 17.5a.75.75 0 0 1 0-1.5H14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H7.75a.75.75 0 0 1 0-1.5H14A3.5 3.5 0 0 1 17.5 6v8a3.5 3.5 0 0 1-3.5 3.5H7.75Zm0-11.3a.75.75 0 0 1 1.05.04l3 3.25c.27.29.27.73 0 1.02l-3 3.25a.75.75 0 1 1-1.1-1.02l1.84-1.99H1.75a.75.75 0 0 1 0-1.5h7.79l-1.84-2a.75.75 0 0 1 .04-1.05Z"]));
export const ArrowEnterRegular = ( /*#__PURE__*/createFluentIcon('ArrowEnterRegular', "1em", ["M7.5 17a.5.5 0 0 1 0-1H14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H7.5a.5.5 0 0 1 0-1H14a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H7.5Zm.15-10.85c.2-.2.5-.2.7 0l3.5 3.5c.2.2.2.5 0 .7l-3.5 3.5a.5.5 0 0 1-.7-.7l2.64-2.65H1.5a.5.5 0 0 1 0-1h8.8L7.64 6.85a.5.5 0 0 1 0-.7Z"]));
export const ArrowEnterLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowEnterLeftFilled', "1em", ["m4.64 12.5 2.87 2.7a.75.75 0 0 1-1.02 1.1l-4.25-4a.75.75 0 0 1 0-1.1l4.25-4A.75.75 0 1 1 7.5 8.3L4.64 11h10.11c.97 0 1.75-.78 1.75-1.75v-4.5a.75.75 0 0 1 1.5 0v4.5c0 1.8-1.46 3.25-3.25 3.25H4.65Z"]));
export const ArrowEnterLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowEnterLeftRegular', "1em", ["m3.76 12 3.33 3.14a.5.5 0 0 1-.68.72l-4.25-4a.5.5 0 0 1 0-.72l4.25-4a.5.5 0 1 1 .68.72L3.76 11H15a2 2 0 0 0 2-2V4.5a.5.5 0 0 1 1 0V9a3 3 0 0 1-3 3H3.76Z"]));
export const ArrowEnterUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowEnterUpFilled', "1em", ["M8.8 2.24a.75.75 0 0 0-1.1 0l-4 4.25A.75.75 0 1 0 4.8 7.5l2.7-2.87v10.11c0 1.8 1.46 3.25 3.25 3.25h4.5a.75.75 0 0 0 0-1.5h-4.5c-.97 0-1.75-.78-1.75-1.75V4.65l2.7 2.86a.75.75 0 1 0 1.1-1.02l-4-4.25Z"]));
export const ArrowEnterUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowEnterUpRegular', "1em", ["M8.86 2.16a.5.5 0 0 0-.72 0l-4 4.25a.5.5 0 0 0 .72.68L8 3.76V15a3 3 0 0 0 3 3h4.5a.5.5 0 0 0 0-1H11a2 2 0 0 1-2-2V3.76l3.14 3.33a.5.5 0 0 0 .72-.68l-4-4.25Z"]));
export const ArrowExitFilled = ( /*#__PURE__*/createFluentIcon('ArrowExitFilled', "1em", ["M12.25 17.5a.75.75 0 0 0 0-1.5H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h6.25a.75.75 0 0 0 0-1.5H6A3.5 3.5 0 0 0 2.5 6v8A3.5 3.5 0 0 0 6 17.5h6.25Zm1.5-11.3a.75.75 0 0 1 1.05.04l3 3.25c.27.29.27.73 0 1.02l-3 3.25a.75.75 0 1 1-1.1-1.02l1.84-1.99H7.75a.75.75 0 0 1 0-1.5h7.79l-1.84-2a.75.75 0 0 1 .04-1.05Z"]));
export const ArrowExitRegular = ( /*#__PURE__*/createFluentIcon('ArrowExitRegular', "1em", ["M12.5 17a.5.5 0 0 0 0-1H6a2 2 0 0 1-2-2V6c0-1.1.9-2 2-2h6.5a.5.5 0 0 0 0-1H6a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h6.5Zm1.15-10.85c.2-.2.5-.2.7 0l3.5 3.5c.2.2.2.5 0 .7l-3.5 3.5a.5.5 0 0 1-.7-.7l2.64-2.65H7.5a.5.5 0 0 1 0-1h8.8l-2.65-2.65a.5.5 0 0 1 0-.7Z"]));
export const ArrowExpandFilled = ( /*#__PURE__*/createFluentIcon('ArrowExpandFilled', "1em", ["M3.75 3a.75.75 0 0 0-.75.75v3.5a.75.75 0 0 0 1.5 0V5.56l2.22 2.22a.75.75 0 0 0 1.06-1.06L5.56 4.5h1.69a.75.75 0 0 0 0-1.5h-3.5Zm0 14a.75.75 0 0 1-.75-.75v-3.5a.75.75 0 0 1 1.5 0v1.69l2.22-2.22a.75.75 0 0 1 1.06 1.06L5.56 15.5h1.69a.75.75 0 0 1 0 1.5h-3.5ZM17 3.75a.75.75 0 0 0-.75-.75h-3.5a.75.75 0 0 0 0 1.5h1.69l-2.22 2.22a.75.75 0 0 0 1.06 1.06l2.22-2.22v1.69a.75.75 0 0 0 1.5 0v-3.5ZM16.25 17c.41 0 .75-.34.75-.75v-3.5a.75.75 0 0 0-1.5 0v1.69l-2.22-2.22a.75.75 0 1 0-1.06 1.06l2.22 2.22h-1.69a.75.75 0 0 0 0 1.5h3.5Z"]));
export const ArrowExpandRegular = ( /*#__PURE__*/createFluentIcon('ArrowExpandRegular', "1em", ["M3.5 3a.5.5 0 0 0-.5.5v4a.5.5 0 0 0 1 0V4.7l3.15 3.15a.5.5 0 1 0 .7-.7L4.71 4H7.5a.5.5 0 0 0 0-1h-4Zm0 14a.5.5 0 0 1-.5-.5v-4a.5.5 0 0 1 1 0v2.8l3.15-3.15a.5.5 0 0 1 .7.7L4.71 16H7.5a.5.5 0 0 1 0 1h-4ZM17 3.5a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0 0 1h2.8l-3.15 3.15a.5.5 0 0 0 .7.7L16 4.71V7.5a.5.5 0 0 0 1 0v-4ZM16.5 17a.5.5 0 0 0 .5-.5v-4a.5.5 0 0 0-1 0v2.8l-3.15-3.15a.5.5 0 0 0-.7.7L15.29 16H12.5a.5.5 0 0 0 0 1h4Z"]));
export const ArrowExpandAllFilled = ( /*#__PURE__*/createFluentIcon('ArrowExpandAllFilled', "1em", ["M2 4.75c0-.41.34-.75.75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.75Zm8 3c0-.41.34-.75.75-.75h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1-.75-.75Zm-1.22 5.53-2.5 2.5c-.3.3-.77.3-1.06 0l-2.5-2.5a.75.75 0 1 1 1.06-1.06L5 13.44V7.75a.75.75 0 0 1 1.5 0v5.69l1.22-1.22a.75.75 0 0 1 1.06 1.06Z"], { flipInRtl: true }));
export const ArrowExpandAllRegular = ( /*#__PURE__*/createFluentIcon('ArrowExpandAllRegular', "1em", ["M2 4.5c0-.28.22-.5.5-.5h15a.5.5 0 0 1 0 1h-15a.5.5 0 0 1-.5-.5Zm3.15 11.35c.2.2.5.2.7 0l2.5-2.5a.5.5 0 0 0-.7-.7L6 14.29V7.5a.5.5 0 0 0-1 0v6.8l-1.65-1.65a.5.5 0 0 0-.7.7l2.5 2.5ZM17.5 8h-7a.5.5 0 0 1 0-1h7a.5.5 0 0 1 0 1Z"], { flipInRtl: true }));
export const ArrowExportFilled = ( /*#__PURE__*/createFluentIcon('ArrowExportFilled', "1em", ["M2.75 3.75c.41 0 .75.34.75.75v11a.75.75 0 0 1-1.5 0v-11c0-.41.34-.75.75-.75ZM5 10c0-.41.34-.75.75-.75h10.19l-2.72-2.72a.75.75 0 0 1 1.06-1.06l4 4a.77.77 0 0 1 .15.22.75.75 0 0 1-.15.84l-4 4a.75.75 0 1 1-1.06-1.06l2.72-2.72H5.75A.75.75 0 0 1 5 10Z"], { flipInRtl: true }));
export const ArrowExportRegular = ( /*#__PURE__*/createFluentIcon('ArrowExportRegular', "1em", ["M2.5 4c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5ZM5 10c0-.28.22-.5.5-.5h10.8l-3.15-3.15a.5.5 0 0 1 .7-.7l4 4a.5.5 0 0 1 0 .7l-4 4a.5.5 0 0 1-.7-.7l3.14-3.15H5.5A.5.5 0 0 1 5 10Z"], { flipInRtl: true }));
export const ArrowExportLtrFilled = ( /*#__PURE__*/createFluentIcon('ArrowExportLtrFilled', "1em", ["M2.75 3.75c.41 0 .75.34.75.75v11a.75.75 0 0 1-1.5 0v-11c0-.41.34-.75.75-.75ZM5 10c0-.41.34-.75.75-.75h10.19l-2.72-2.72a.75.75 0 0 1 1.06-1.06l4 4a.77.77 0 0 1 .15.22.75.75 0 0 1-.15.84l-4 4a.75.75 0 1 1-1.06-1.06l2.72-2.72H5.75A.75.75 0 0 1 5 10Z"]));
export const ArrowExportLtrRegular = ( /*#__PURE__*/createFluentIcon('ArrowExportLtrRegular', "1em", ["M2.5 4c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5ZM5 10c0-.28.22-.5.5-.5h10.8l-3.15-3.15a.5.5 0 0 1 .7-.7l4 4a.5.5 0 0 1 0 .7l-4 4a.5.5 0 0 1-.7-.7l3.14-3.15H5.5A.5.5 0 0 1 5 10Z"]));
export const ArrowExportRtlFilled = ( /*#__PURE__*/createFluentIcon('ArrowExportRtlFilled', "1em", ["M17.25 3.75a.75.75 0 0 0-.75.75v11a.75.75 0 0 0 1.5 0v-11a.75.75 0 0 0-.75-.75ZM15 10a.75.75 0 0 0-.75-.75H4.06l2.72-2.72a.75.75 0 0 0-1.06-1.06l-4 4a.76.76 0 0 0-.22.53.75.75 0 0 0 .22.53l4 4a.75.75 0 1 0 1.06-1.06l-2.72-2.72h10.19c.41 0 .75-.34.75-.75Z"]));
export const ArrowExportRtlRegular = ( /*#__PURE__*/createFluentIcon('ArrowExportRtlRegular', "1em", ["M17.5 4a.5.5 0 0 0-.5.5v11a.5.5 0 0 0 1 0v-11a.5.5 0 0 0-.5-.5ZM15 10a.5.5 0 0 0-.5-.5H3.7l3.15-3.15a.5.5 0 0 0-.7-.7l-4 4a.5.5 0 0 0 0 .7l4 4a.5.5 0 0 0 .7-.7L3.71 10.5H14.5a.5.5 0 0 0 .5-.5Z"]));
export const ArrowExportUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowExportUpFilled', "1em", ["M10.53 1.72a.75.75 0 0 0-1.06 0l-4 4a.75.75 0 0 0 1.06 1.06l2.72-2.72v10.19a.75.75 0 0 0 1.5 0V4.06l2.72 2.72a.75.75 0 1 0 1.06-1.06l-4-4ZM4.5 16.5a.75.75 0 0 0 0 1.5h11a.75.75 0 0 0 0-1.5h-11Z"], { flipInRtl: true }));
export const ArrowExportUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowExportUpRegular', "1em", ["M9.65 2.15c.2-.2.5-.2.7 0l4 4a.5.5 0 0 1-.7.7L10.5 3.71V14.5a.5.5 0 0 1-1 0V3.7L6.35 6.86a.5.5 0 1 1-.7-.7l4-4ZM4 17.5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5Z"], { flipInRtl: true }));
export const ArrowFitFilled = ( /*#__PURE__*/createFluentIcon('ArrowFitFilled', "1em", ["M5.8 6.72c.28.3.28.77-.01 1.06L4.57 9h3.68a.75.75 0 0 1 0 1.5H4.56l1.22 1.22a.75.75 0 1 1-1.06 1.06l-2.5-2.5a.75.75 0 0 1 0-1.06l2.51-2.5c.3-.3.77-.3 1.06 0Zm8.42 0c.3-.3.77-.3 1.06 0l2.5 2.5c.3.3.3.77 0 1.06l-2.5 2.5a.75.75 0 1 1-1.06-1.06l1.22-1.22h-3.69a.75.75 0 0 1 0-1.5h3.69l-1.22-1.22a.75.75 0 0 1 0-1.06Z"]));
export const ArrowFitRegular = ( /*#__PURE__*/createFluentIcon('ArrowFitRegular', "1em", ["M5.35 6.65c.2.2.2.5 0 .7L3.71 9H8.5a.5.5 0 0 1 0 1H3.7l1.65 1.65a.5.5 0 0 1-.7.7l-2.5-2.5a.5.5 0 0 1 0-.7l2.5-2.5c.2-.2.5-.2.7 0Zm9.3 0c.2-.2.5-.2.7 0l2.5 2.5c.2.2.2.5 0 .7l-2.5 2.5a.5.5 0 0 1-.7-.7L16.29 10H11.5a.5.5 0 0 1 0-1h4.8l-1.65-1.65a.5.5 0 0 1 0-.7Z"]));
export const ArrowFitInFilled = ( /*#__PURE__*/createFluentIcon('ArrowFitInFilled', "1em", ["M5.21 7.78a.75.75 0 1 1 1.06-1.06l2.5 2.5a.75.75 0 0 1 .01 1.06l-2.5 2.5a.75.75 0 0 1-1.06-1.06l1.22-1.22H2.75a.75.75 0 0 1 0-1.5h3.68L5.21 7.78Zm9.58 0a.75.75 0 0 0-1.06-1.06l-2.5 2.5a.75.75 0 0 0-.01 1.06l2.5 2.5a.75.75 0 1 0 1.06-1.06l-1.22-1.22h3.69a.75.75 0 0 0 0-1.5h-3.68l1.22-1.22Z"]));
export const ArrowFitInRegular = ( /*#__PURE__*/createFluentIcon('ArrowFitInRegular', "1em", ["M5.65 7.35a.5.5 0 1 1 .7-.7l2.5 2.5c.2.2.2.5 0 .7l-2.5 2.5a.5.5 0 0 1-.7-.7L7.29 10H2.5a.5.5 0 0 1 0-1h4.8L5.64 7.35Zm8.7 0a.5.5 0 0 0-.7-.7l-2.5 2.5a.5.5 0 0 0 0 .7l2.5 2.5a.5.5 0 0 0 .7-.7L12.71 10h4.79a.5.5 0 0 0 0-1h-4.8l1.65-1.65Z"]));
export const ArrowFlowDiagonalUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowFlowDiagonalUpRightFilled', "1em", ["M10.5 4a.5.5 0 0 0 0 1h3.8l-6.56 6.55a3 3 0 1 0 .7.7L15 5.72V9.5a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-.5-.5h-5Z"], { flipInRtl: true }));
export const ArrowFlowDiagonalUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowFlowDiagonalUpRightRegular', "1em", ["M10.5 4a.5.5 0 0 0 0 1h3.8l-6.56 6.55a3 3 0 1 0 .7.7L15 5.72V9.5a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-.5-.5h-5ZM4 14a2 2 0 1 1 4 0 2 2 0 0 1-4 0Z"], { flipInRtl: true }));
export const ArrowFlowUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowFlowUpRightFilled', "1em", ["M14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5Z"], { flipInRtl: true }));
export const ArrowFlowUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowFlowUpRightRegular', "1em", ["M14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5ZM7 13a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"], { flipInRtl: true }));
export const ArrowFlowUpRightRectangleMultipleFilled = ( /*#__PURE__*/createFluentIcon('ArrowFlowUpRightRectangleMultipleFilled', "1em", ["M11 12.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5v4a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-4Zm8 2a.5.5 0 0 0-1 0V17a1 1 0 0 1-1 1h-3.5a.5.5 0 0 0 0 1H17a2 2 0 0 0 2-2v-2.5ZM14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5Z"], { flipInRtl: true }));
export const ArrowFlowUpRightRectangleMultipleRegular = ( /*#__PURE__*/createFluentIcon('ArrowFlowUpRightRectangleMultipleRegular', "1em", ["M11 12.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5v4a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-4Zm8 2a.5.5 0 0 0-1 0V17a1 1 0 0 1-1 1h-3.5a.5.5 0 0 0 0 1H17a2 2 0 0 0 2-2v-2.5ZM14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5ZM7 13a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"], { flipInRtl: true }));
export const ArrowForwardFilled = ( /*#__PURE__*/createFluentIcon('ArrowForwardFilled', "1em", ["M12.22 4.78a.75.75 0 0 1 1.06-1.06l4.5 4.5c.3.3.3.77 0 1.06l-4.5 4.5a.75.75 0 1 1-1.06-1.06l3.22-3.22H9.25a5.75 5.75 0 0 0-5.75 5.75.75.75 0 0 1-1.5 0C2 11.25 5.25 8 9.25 8h6.19l-3.22-3.22Z"], { flipInRtl: true }));
export const ArrowForwardRegular = ( /*#__PURE__*/createFluentIcon('ArrowForwardRegular', "1em", ["M12.65 3.65a.5.5 0 0 0 0 .7L16.29 8H9.5A7.5 7.5 0 0 0 2 15.5a.5.5 0 0 0 1 0A6.5 6.5 0 0 1 9.5 9h6.8l-3.65 3.65a.5.5 0 0 0 .7.7l4.5-4.5a.5.5 0 0 0 0-.7l-4.5-4.5a.5.5 0 0 0-.7 0Z"], { flipInRtl: true }));
export const ArrowForwardDownLightningFilled = ( /*#__PURE__*/createFluentIcon('ArrowForwardDownLightningFilled', "1em", ["M13.43 4.75 15.7 7h-3.95c-2.8-.1-4.49-1.62-4.49-3.75a.75.75 0 0 0-1.5 0v.21C5.87 6.42 8.35 8.5 12 8.5h3.69l-2.26 2.26-.07.08a.75.75 0 0 0 1.14.98l3.53-3.54a.75.75 0 0 0 .09-.1l.03-.06.05-.1.03-.1.02-.1V7.68l-.01-.06-.02-.07-.03-.09-.05-.1-.04-.05-.07-.08-3.53-3.54-.09-.07a.75.75 0 0 0-.98 1.14ZM2.5 16h1.75l-.59 2.36c-.12.48.46.83.83.49l4.87-4.55a.75.75 0 0 0-.51-1.3h-1.1l.78-2.34a.5.5 0 0 0-.47-.66H4.59a.5.5 0 0 0-.47.3l-2.08 5c-.14.34.1.7.46.7Z"], { flipInRtl: true }));
export const ArrowForwardDownLightningRegular = ( /*#__PURE__*/createFluentIcon('ArrowForwardDownLightningRegular', "1em", ["M13.61 4.32 16.3 7h-4.55C8.8 6.9 7 5.27 7 3a.5.5 0 0 0-1 0v.2C6.12 6.03 8.48 8 12 8h4.3l-2.69 2.68-.06.07a.5.5 0 0 0 .77.64l3.55-3.55.05-.07.04-.08.02-.06.02-.09v-.06.02a.5.5 0 0 0-.01-.1v-.03l-.03-.06-.03-.06-.05-.07-3.56-3.57-.07-.06a.5.5 0 0 0-.64.77ZM2.51 16h1.74l-.59 2.36c-.12.48.46.83.83.49l4.87-4.55a.75.75 0 0 0-.51-1.3h-1.1l.78-2.34a.5.5 0 0 0-.47-.66H4.59a.5.5 0 0 0-.47.3l-2.08 5c-.14.34.1.7.46.7Z"], { flipInRtl: true }));
export const ArrowForwardDownPersonFilled = ( /*#__PURE__*/createFluentIcon('ArrowForwardDownPersonFilled', "1em", ["M13.43 4.74 15.7 7h-3.95c-2.8-.1-4.49-1.62-4.49-3.75a.75.75 0 0 0-1.5 0v.21C5.87 6.42 8.35 8.5 12 8.5h3.69l-2.26 2.26-.07.08a.75.75 0 0 0 1.13.98l3.54-3.54a.75.75 0 0 0 .09-.1l.03-.06.05-.1.03-.1.02-.1V7.68l-.01-.06-.02-.07-.03-.09-.05-.1-.04-.05-.07-.08-3.54-3.54-.08-.07a.75.75 0 0 0-.98 1.13ZM7.5 11a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM9 15.5C9 16.74 8 18 5.5 18S2 16.75 2 15.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"], { flipInRtl: true }));
export const ArrowForwardDownPersonRegular = ( /*#__PURE__*/createFluentIcon('ArrowForwardDownPersonRegular', "1em", ["M13.61 4.32 16.3 7h-4.55C8.8 6.9 7 5.27 7 3a.5.5 0 0 0-1 0v.2C6.11 6.03 8.48 8 12 8h4.3l-2.69 2.68-.06.07a.5.5 0 0 0 .77.64l3.55-3.55.05-.07.04-.08.02-.06.02-.09v-.06.02a.5.5 0 0 0-.01-.1v-.03l-.03-.06-.03-.06-.05-.07-3.56-3.57-.07-.06a.5.5 0 0 0-.64.77ZM7.5 11a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM9 15.5C9 16.74 8 18 5.5 18S2 16.75 2 15.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"], { flipInRtl: true }));
export const ArrowHookDownLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowHookDownLeftFilled', "1em", ["M6 4.75c0-.41.34-.75.75-.75h4.5c1.59 0 2.7.62 3.53 1.59C15.6 6.54 16 7.79 16 9c0 1.22-.3 2.46-1.12 3.41A4.62 4.62 0 0 1 11.25 14H6.56l2.22 2.22a.75.75 0 1 1-1.06 1.06l-3.5-3.5a.75.75 0 0 1 .02-1.08l3.5-3.25a.75.75 0 0 1 1.02 1.1l-2.1 1.95h4.59c1.16 0 1.86-.44 2.4-1.07.55-.64.85-1.52.85-2.43 0-.9-.3-1.79-.85-2.43a2.92 2.92 0 0 0-2.4-1.07h-4.5A.75.75 0 0 1 6 4.75Z"], { flipInRtl: true }));
export const ArrowHookDownLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowHookDownLeftRegular', "1em", ["M6 4.5c0-.28.22-.5.5-.5H11c1.64 0 2.9.62 3.75 1.57C15.59 6.52 16 7.77 16 9s-.41 2.48-1.25 3.43A4.85 4.85 0 0 1 11 14H5.7l2.65 2.65a.5.5 0 0 1-.7.7l-3.5-3.5a.5.5 0 0 1 0-.7l3.5-3.5a.5.5 0 1 1 .7.7L5.71 13H11c1.36 0 2.35-.5 3-1.24.66-.74 1-1.74 1-2.76 0-1.02-.34-2.02-1-2.76A3.86 3.86 0 0 0 11 5H6.5a.5.5 0 0 1-.5-.5Z"], { flipInRtl: true }));
export const ArrowHookDownRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowHookDownRightFilled', "1em", ["M9 14c.06 0-.06 0 0 0h4.65l-2.27 2.27a.75.75 0 1 0 1.06 1.06l3.35-3.35a.75.75 0 0 0 .21-.64.75.75 0 0 0-.21-.45l-3.25-3.24a.75.75 0 1 0-1.06 1.06l1.8 1.79H9a3.5 3.5 0 1 1 0-7h4.25a.75.75 0 0 0 0-1.5H9a5 5 0 0 0 0 10Z"], { flipInRtl: true }));
export const ArrowHookDownRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowHookDownRightRegular', "1em", ["M4 9a5 5 0 0 1 5-5h4.5a.5.5 0 0 1 0 1H9a4 4 0 1 0 0 8h5.3l-2.7-2.7a.5.5 0 1 1 .7-.7l3.54 3.53a.5.5 0 0 1 .13.5.5.5 0 0 1-.14.25L12.3 17.4a.5.5 0 0 1-.71-.7l2.7-2.71H9a5 5 0 0 1-5-5Z"], { flipInRtl: true }));
export const ArrowHookUpLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowHookUpLeftFilled', "1em", ["M6 15.25c0 .41.34.75.75.75h4.5a4.4 4.4 0 0 0 3.53-1.59A5.24 5.24 0 0 0 16 11c0-1.22-.3-2.46-1.12-3.41A4.62 4.62 0 0 0 11.25 6H6.56l2.22-2.22a.75.75 0 0 0-1.06-1.06l-3.5 3.5a.75.75 0 0 0 .02 1.08l3.5 3.25a.75.75 0 0 0 1.02-1.1L6.66 7.5h4.59c1.16 0 1.86.44 2.4 1.07.55.64.85 1.52.85 2.43 0 .9-.3 1.79-.85 2.43a2.92 2.92 0 0 1-2.4 1.07h-4.5a.75.75 0 0 0-.75.75Z"], { flipInRtl: true }));
export const ArrowHookUpLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowHookUpLeftRegular', "1em", ["M6 15.5c0 .28.22.5.5.5H11c1.64 0 2.9-.62 3.75-1.57A5.16 5.16 0 0 0 16 11c0-1.23-.41-2.48-1.25-3.43A4.85 4.85 0 0 0 11 6H5.7l2.65-2.65a.5.5 0 1 0-.7-.7l-3.5 3.5a.5.5 0 0 0 0 .7l3.5 3.5a.5.5 0 0 0 .7-.7L5.71 7H11c1.36 0 2.35.5 3 1.24.66.74 1 1.74 1 2.76 0 1.02-.34 2.02-1 2.76A3.86 3.86 0 0 1 11 15H6.5a.5.5 0 0 0-.5.5Z"], { flipInRtl: true }));
export const ArrowHookUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowHookUpRightFilled', "1em", ["M9 6c.06 0-.06 0 0 0h4.65l-2.27-2.27a.75.75 0 1 1 1.06-1.06l3.35 3.35c.17.18.24.42.21.64a.75.75 0 0 1-.21.45l-3.25 3.24a.75.75 0 1 1-1.06-1.06l1.8-1.79H9a3.5 3.5 0 1 0 0 7h4.25a.75.75 0 0 1 0 1.5H9A5 5 0 0 1 9 6Z"], { flipInRtl: true }));
export const ArrowHookUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowHookUpRightRegular', "1em", ["M4 11a5 5 0 0 0 5 5h4.5a.5.5 0 0 0 0-1H9a4 4 0 0 1 0-8h5.3l-2.7 2.7a.5.5 0 1 0 .7.7l3.54-3.53a.5.5 0 0 0 .13-.5.5.5 0 0 0-.14-.25L12.3 2.6a.5.5 0 1 0-.71.7L14.29 6H9a5 5 0 0 0-5 5Z"], { flipInRtl: true }));
export const ArrowImportFilled = ( /*#__PURE__*/createFluentIcon('ArrowImportFilled', "1em", ["M17.25 3.75c.41 0 .75.34.75.75v11a.75.75 0 0 1-1.5 0v-11c0-.41.34-.75.75-.75ZM2 10c0-.41.34-.75.75-.75h10.19l-2.72-2.72a.75.75 0 1 1 1.06-1.06l4 4a.77.77 0 0 1 .15.22.75.75 0 0 1-.15.84l-4 4a.75.75 0 1 1-1.06-1.06l2.72-2.72H2.75A.75.75 0 0 1 2 10Z"], { flipInRtl: true }));
export const ArrowImportRegular = ( /*#__PURE__*/createFluentIcon('ArrowImportRegular', "1em", ["M17.5 4c.28 0 .5.22.5.5v11a.5.5 0 0 1-1 0v-11c0-.28.22-.5.5-.5ZM2 10c0-.28.22-.5.5-.5h10.8l-3.15-3.15a.5.5 0 0 1 .7-.7l4 4A.5.5 0 0 1 15 10a.5.5 0 0 1-.15.35l-4 4a.5.5 0 0 1-.7-.7l3.14-3.15H2.5A.5.5 0 0 1 2 10Z"], { flipInRtl: true }));
export const ArrowJoinFilled = ( /*#__PURE__*/createFluentIcon('ArrowJoinFilled', "1em", ["M4.5 2c.28 0 .5.22.5.5C5 6.12 7.88 9 11.5 9h.8l-1.15-1.15a.5.5 0 0 1 .7-.7l2 2c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7L12.29 10h-.79A6.46 6.46 0 0 0 5 16.5a.5.5 0 0 1-1 0 7.45 7.45 0 0 1 4.78-7A7.45 7.45 0 0 1 4 2.5c0-.28.22-.5.5-.5Zm5.53 9.2A5.43 5.43 0 0 0 7 13.3v.7c0 1.1.9 2 2 2h6a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v.7a5.43 5.43 0 0 0 3.03 2.1 1.5 1.5 0 0 1 2.53-1.36l2 2a1.5 1.5 0 0 1 0 2.12l-2 2a1.5 1.5 0 0 1-2.53-1.37Z"]));
export const ArrowJoinRegular = ( /*#__PURE__*/createFluentIcon('ArrowJoinRegular', "1em", ["M5 2.5a.5.5 0 0 0-1 0 7.45 7.45 0 0 0 4.78 7 7.45 7.45 0 0 0-4.78 7 .5.5 0 0 0 1 0c0-3.62 2.88-6.5 6.5-6.5h.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L12.29 9h-.79A6.46 6.46 0 0 1 5 2.5ZM8.5 4a.5.5 0 0 0 0 1H15c.52 0 1 .48 1 1v7c0 .52-.48 1-1 1H8.5a.5.5 0 0 0 0 1H15c1.08 0 2-.92 2-2V6c0-1.08-.92-2-2-2H8.5Z"]));
export const ArrowLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowLeftFilled', "1em", ["M8.73 16.8a.75.75 0 0 0 1.03-1.1l-5.24-4.95h12.73a.75.75 0 0 0 0-1.5H4.52l5.24-4.96A.75.75 0 1 0 8.73 3.2L2.31 9.27a1 1 0 0 0 0 1.46l6.42 6.07Z"]));
export const ArrowLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowLeftRegular', "1em", ["M9.16 16.87a.5.5 0 1 0 .67-.74L3.67 10.5H17.5a.5.5 0 0 0 0-1H3.67l6.16-5.63a.5.5 0 0 0-.67-.74L2.24 9.44a.75.75 0 0 0 0 1.11l6.92 6.32Z"]));
export const ArrowMaximizeFilled = ( /*#__PURE__*/createFluentIcon('ArrowMaximizeFilled', "1em", ["M15.75 3.5c.41 0 .75.34.75.75v6a.75.75 0 0 1-1.5 0V6.06L6.06 15h4.19a.75.75 0 0 1 0 1.5h-6a.75.75 0 0 1-.75-.75v-6a.75.75 0 0 1 1.5 0v4.19L13.94 5H9.75a.75.75 0 0 1 0-1.5h6Z"]));
export const ArrowMaximizeRegular = ( /*#__PURE__*/createFluentIcon('ArrowMaximizeRegular', "1em", ["M15.5 4c.28 0 .5.22.5.5v6a.5.5 0 0 1-1 0V5.7L5.7 15h4.8a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5v-6a.5.5 0 0 1 1 0v4.8L14.3 5H9.5a.5.5 0 0 1 0-1h6Z"]));
export const ArrowMaximizeTopLeftBottomRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowMaximizeTopLeftBottomRightFilled', "1em", ["M10.25 3.5a.75.75 0 0 1 0 1.5H6.06L15 13.94V9.75a.75.75 0 0 1 1.5 0v6c0 .41-.34.75-.75.75h-6a.75.75 0 0 1 0-1.5h4.19L5 6.06v4.19a.75.75 0 0 1-1.5 0v-6c0-.41.34-.75.75-.75h6Z"]));
export const ArrowMaximizeTopLeftBottomRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowMaximizeTopLeftBottomRightRegular', "1em", ["M10.5 4a.5.5 0 0 1 0 1H5.7l9.3 9.3V9.5a.5.5 0 0 1 1 0v6a.5.5 0 0 1-.5.5h-6a.5.5 0 0 1 0-1h4.8L5 5.7v4.8a.5.5 0 0 1-1 0v-6c0-.28.22-.5.5-.5h6Z"]));
export const ArrowMaximizeVerticalFilled = ( /*#__PURE__*/createFluentIcon('ArrowMaximizeVerticalFilled', "1em", ["M9.58 1.33a.6.6 0 0 1 .84 0l2.13 2.13a.6.6 0 0 1-.85.84l-1.1-1.1v4.3a.6.6 0 1 1-1.2 0V3.2L8.3 4.3a.6.6 0 0 1-.85-.84l2.13-2.13ZM3.9 10c0-.33.27-.6.6-.6h11a.6.6 0 1 1 0 1.2h-11a.6.6 0 0 1-.6-.6Zm6.7 6.8v-4.3a.6.6 0 0 0-1.2 0v4.3l-1.1-1.1a.6.6 0 0 0-.85.85l2.13 2.12a.6.6 0 0 0 .84 0l2.13-2.12a.6.6 0 1 0-.85-.85l-1.1 1.1Z"]));
export const ArrowMaximizeVerticalRegular = ( /*#__PURE__*/createFluentIcon('ArrowMaximizeVerticalRegular', "1em", ["M9.65 1.4c.2-.2.5-.2.7 0l2.12 2.13a.5.5 0 0 1-.7.7L10.5 2.96V7.5a.5.5 0 0 1-1 0V2.96L8.23 4.23a.5.5 0 1 1-.7-.7L9.65 1.4ZM4 10c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1h-11A.5.5 0 0 1 4 10Zm6.5 7.04V12.5a.5.5 0 0 0-1 0v4.54l-1.27-1.27a.5.5 0 1 0-.7.7l2.12 2.13c.2.2.5.2.7 0l2.12-2.12a.5.5 0 0 0-.7-.71l-1.27 1.27Z"]));
export const ArrowMinimizeFilled = ( /*#__PURE__*/createFluentIcon('ArrowMinimizeFilled', "1em", ["M3.75 11h4.5c.38 0 .7.28.74.65l.01.1v4.5a.75.75 0 0 1-1.5.1v-2.79l-4.47 4.47a.75.75 0 0 1-1.13-.98l.07-.08 4.47-4.47H3.75a.75.75 0 0 1-.74-.65l-.01-.1c0-.38.28-.7.65-.74l.1-.01h4.5-4.5Zm14.28-9.03c.27.27.3.68.07.98l-.07.08L13.06 8h3.19c.38 0 .7.28.74.65l.01.1c0 .38-.28.7-.65.74l-.1.01h-5a.75.75 0 0 1-.74-.65l-.01-.1v-5a.75.75 0 0 1 1.5-.1v3.29l4.97-4.97c.3-.3.77-.3 1.06 0Z"]));
export const ArrowMinimizeRegular = ( /*#__PURE__*/createFluentIcon('ArrowMinimizeRegular', "1em", ["M8.5 11c.28 0 .5.22.5.5v5a.5.5 0 0 1-1 0v-3.8l-5.15 5.15a.5.5 0 0 1-.7-.7L7.29 12H3.5a.5.5 0 0 1 0-1h5Zm8.65-8.85a.5.5 0 1 1 .7.7L12.71 8h3.79a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5v-5a.5.5 0 0 1 1 0v3.8l5.15-5.15Z"]));
export const ArrowMinimizeTopLeftBottomRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowMinimizeTopLeftBottomRightFilled', "1em", ["M16.25 11h.1c.37.06.65.37.65.75v.1a.75.75 0 0 1-.75.65h-2.69l4.47 4.47.07.08a.75.75 0 0 1-1.13.98l-4.47-4.47v2.79a.75.75 0 0 1-1.5-.1v-4.6a.75.75 0 0 1 .75-.65h4.5ZM1.97 1.97c.3-.3.77-.3 1.06 0L8 6.94V3.65a.75.75 0 0 1 1.5.1v5.1a.75.75 0 0 1-.75.65h-5.1A.75.75 0 0 1 3 8.74v-.1A.75.75 0 0 1 3.76 8h3.19L1.97 3.03l-.07-.08a.75.75 0 0 1 .07-.98Z"]));
export const ArrowMinimizeTopLeftBottomRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowMinimizeTopLeftBottomRightRegular', "1em", ["M16.5 11a.5.5 0 0 1 0 1h-3.8l5.15 5.15a.5.5 0 0 1-.7.7L12 12.71v3.79a.5.5 0 1 1-1 0v-5c0-.28.22-.5.5-.5h5ZM2.15 2.15c.2-.2.5-.2.7 0L8 7.29V3.5a.5.5 0 1 1 1 0v5a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1 0-1h3.8L2.14 2.85a.5.5 0 0 1 0-.7Z"]));
export const ArrowMinimizeVerticalFilled = ( /*#__PURE__*/createFluentIcon('ArrowMinimizeVerticalFilled', "1em", ["M9.75 1.5c.41 0 .75.34.75.75v2.69l.72-.72a.75.75 0 1 1 1.06 1.06l-2 2c-.3.3-.77.3-1.06 0l-2-2a.75.75 0 0 1 1.06-1.06l.72.72V2.25c0-.41.34-.75.75-.75ZM3.5 9.75c0-.41.34-.75.75-.75h11a.75.75 0 0 1 0 1.5h-11a.75.75 0 0 1-.75-.75Zm8.78 4.47-2-2a.75.75 0 0 0-1.06 0l-2 2a.75.75 0 1 0 1.06 1.06l.72-.72v2.69a.75.75 0 0 0 1.5 0v-2.69l.72.72a.75.75 0 1 0 1.06-1.06Z"]));
export const ArrowMinimizeVerticalRegular = ( /*#__PURE__*/createFluentIcon('ArrowMinimizeVerticalRegular', "1em", ["M9.5 1c.28 0 .5.22.5.5v3.8l1.15-1.15a.5.5 0 0 1 .7.7l-2 2a.5.5 0 0 1-.7 0l-2-2a.5.5 0 1 1 .7-.7L9 5.29V1.5c0-.28.22-.5.5-.5Zm-6 8.5c0-.28.22-.5.5-.5h11a.5.5 0 0 1 0 1H4a.5.5 0 0 1-.5-.5Zm6.5 4.2v3.8a.5.5 0 0 1-1 0v-3.8l-1.15 1.15a.5.5 0 0 1-.7-.7l2-2c.2-.2.5-.2.7 0l2 2a.5.5 0 0 1-.7.7L10 13.71Z"]));
export const ArrowMoveFilled = ( /*#__PURE__*/createFluentIcon('ArrowMoveFilled', "1em", ["M10.53 2.22a.75.75 0 0 0-1.06 0L7.22 4.47a.75.75 0 0 0 1.06 1.06l.97-.97v2.69a.75.75 0 0 0 1.5 0V4.56l.97.97a.75.75 0 1 0 1.06-1.06l-2.25-2.25ZM2.22 9.47c-.3.3-.3.77 0 1.06l2.25 2.25a.75.75 0 0 0 1.06-1.06l-.97-.97h2.69a.75.75 0 0 0 0-1.5H4.56l.97-.97a.75.75 0 0 0-1.06-1.06L2.22 9.47Zm8.31 8.31 2.25-2.25a.75.75 0 1 0-1.06-1.06l-.97.97v-2.69a.75.75 0 0 0-1.5 0v2.69l-.97-.97a.75.75 0 0 0-1.06 1.06l2.25 2.25c.3.3.77.3 1.06 0Zm5-10.56 2.25 2.25c.3.3.3.77 0 1.06l-2.25 2.25a.75.75 0 1 1-1.06-1.06l.97-.97h-2.69a.75.75 0 0 1 0-1.5h2.69l-.97-.97a.75.75 0 0 1 1.06-1.06Z"]));
export const ArrowMoveRegular = ( /*#__PURE__*/createFluentIcon('ArrowMoveRegular', "1em", ["M10.35 2.15a.5.5 0 0 0-.7 0l-2.5 2.5a.5.5 0 1 0 .7.7L9.5 3.71V7.5a.5.5 0 0 0 1 0V3.7l1.65 1.65a.5.5 0 0 0 .7-.7l-2.5-2.5Zm-8.2 7.5a.5.5 0 0 0 0 .7l2.5 2.5a.5.5 0 0 0 .7-.7L3.71 10.5H7.5a.5.5 0 0 0 0-1H3.7l1.65-1.65a.5.5 0 1 0-.7-.7l-2.5 2.5ZM10 18a.5.5 0 0 1-.35-.15l-2.5-2.5a.5.5 0 0 1 .7-.7l1.65 1.64V12.5a.5.5 0 0 1 1 0v3.8l1.65-1.65a.5.5 0 0 1 .7.7l-2.5 2.5A.5.5 0 0 1 10 18Zm7.85-7.65a.5.5 0 0 0 0-.7l-2.5-2.5a.5.5 0 0 0-.7.7l1.64 1.65H12.5a.5.5 0 0 0 0 1h3.8l-1.65 1.65a.5.5 0 0 0 .7.7l2.5-2.5Z"]));
export const ArrowMoveInwardFilled = ( /*#__PURE__*/createFluentIcon('ArrowMoveInwardFilled', "1em", ["M13.03 3.72c.3.3.3.77 0 1.06l-2.5 2.5c-.3.3-.77.3-1.06 0l-2.5-2.5a.75.75 0 0 1 1.06-1.06l1.22 1.22V1.75a.75.75 0 0 1 1.5 0v3.19l1.22-1.22c.3-.3.77-.3 1.06 0ZM3.72 6.97c.3-.3.77-.3 1.06 0l2.5 2.5c.3.3.3.77 0 1.06l-2.5 2.5a.75.75 0 0 1-1.06-1.06l1.22-1.22H1.75a.75.75 0 0 1 0-1.5h3.19L3.72 8.03a.75.75 0 0 1 0-1.06Zm11.5 0a.75.75 0 1 1 1.06 1.06l-1.22 1.22h3.19a.75.75 0 0 1 0 1.5h-3.19l1.22 1.22a.75.75 0 1 1-1.06 1.06l-2.5-2.5a.75.75 0 0 1 0-1.06l2.5-2.5Zm-2.19 9.31c.3-.3.3-.77 0-1.06l-2.5-2.5a.75.75 0 0 0-1.06 0l-2.5 2.5a.75.75 0 1 0 1.06 1.06l1.22-1.22v3.19a.75.75 0 0 0 1.5 0v-3.19l1.22 1.22c.3.3.77.3 1.06 0Z"]));
export const ArrowMoveInwardRegular = ( /*#__PURE__*/createFluentIcon('ArrowMoveInwardRegular', "1em", ["M7.15 16.35c.2.2.5.2.7 0l1.65-1.64v3.79a.5.5 0 0 0 1 0v-3.8l1.65 1.65a.5.5 0 0 0 .7-.7l-2.5-2.5a.5.5 0 0 0-.7 0l-2.5 2.5a.5.5 0 0 0 0 .7Zm9.2-8.5a.5.5 0 0 0-.7-.7l-2.5 2.5a.5.5 0 0 0 0 .7l2.5 2.5a.5.5 0 0 0 .7-.7l-1.64-1.65h3.79a.5.5 0 0 0 0-1h-3.8l1.65-1.65Zm-12.7 0a.5.5 0 1 1 .7-.7l2.5 2.5c.2.2.2.5 0 .7l-2.5 2.5a.5.5 0 0 1-.7-.7l1.64-1.65H1.5a.5.5 0 0 1 0-1h3.8L3.64 7.85Zm4.2-4.2a.5.5 0 1 0-.7.7l2.5 2.5c.2.2.5.2.7 0l2.5-2.5a.5.5 0 0 0-.7-.7L10.5 5.29V1.5a.5.5 0 0 0-1 0v3.8L7.85 3.64Z"]));
export const ArrowNextFilled = ( /*#__PURE__*/createFluentIcon('ArrowNextFilled', "1em", ["M13.75 4.75c.38 0 .7.28.74.65l.01.1v9a.75.75 0 0 1-1.5.1V5.5c0-.41.34-.75.75-.75Zm-8.28.22a.75.75 0 0 1 .98-.07l.08.07 4.5 4.5c.27.27.3.68.07.98l-.07.08-4.5 4.5a.75.75 0 0 1-1.13-.98l.07-.08L9.44 10 5.47 6.03a.75.75 0 0 1 0-1.06Z"], { flipInRtl: true }));
export const ArrowNextRegular = ( /*#__PURE__*/createFluentIcon('ArrowNextRegular', "1em", ["M13.5 5a.5.5 0 0 1 .5.41v9.09a.5.5 0 0 1-1 .09V5.5c0-.28.22-.5.5-.5Zm-7.85.15a.5.5 0 0 1 .63-.06l.07.06 4.5 4.5c.18.17.2.44.06.63l-.06.07-4.5 4.5a.5.5 0 0 1-.76-.63l.06-.07L9.79 10 5.65 5.85a.5.5 0 0 1 0-.7Z"], { flipInRtl: true }));
export const ArrowOutlineDownLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowOutlineDownLeftFilled', "1em", ["M3.67 17.99A1.5 1.5 0 0 1 2 16.33l1.08-9.7a1.5 1.5 0 0 1 2.55-.9L6.7 6.8l4.36-4.36a1.5 1.5 0 0 1 2.12 0l4.37 4.37a1.5 1.5 0 0 1 0 2.12l-4.36 4.36 1.06 1.07a1.5 1.5 0 0 1-.9 2.55L3.67 18Z"]));
export const ArrowOutlineDownLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowOutlineDownLeftRegular', "1em", ["M3 16.44a.5.5 0 0 0 .56.56l9.7-1.08a.5.5 0 0 0 .3-.85l-1.42-1.42a.5.5 0 0 1 0-.71l4.71-4.72a.5.5 0 0 0 0-.7l-4.37-4.37a.5.5 0 0 0-.7 0L7.06 7.86a.5.5 0 0 1-.7 0L4.92 6.44a.5.5 0 0 0-.85.3L3 16.44ZM3.67 18A1.5 1.5 0 0 1 2 16.33l1.08-9.7a1.5 1.5 0 0 1 2.55-.9L6.7 6.8l4.36-4.36a1.5 1.5 0 0 1 2.12 0l4.37 4.37a1.5 1.5 0 0 1 0 2.12l-4.36 4.36 1.06 1.07a1.5 1.5 0 0 1-.9 2.55L3.67 18Z"]));
export const ArrowOutlineUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowOutlineUpRightFilled', "1em", ["M16.33 2c.96-.1 1.77.71 1.66 1.67l-1.08 9.7a1.5 1.5 0 0 1-2.55.9L13.3 13.2l-4.36 4.36a1.5 1.5 0 0 1-2.12 0l-4.37-4.37a1.5 1.5 0 0 1 0-2.12L6.8 6.7 5.74 5.64a1.5 1.5 0 0 1 .89-2.55L16.33 2Z"]));
export const ArrowOutlineUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowOutlineUpRightRegular', "1em", ["M17 3.56a.5.5 0 0 0-.56-.56l-9.7 1.08a.5.5 0 0 0-.3.85l1.42 1.42a.5.5 0 0 1 0 .71l-4.71 4.72a.5.5 0 0 0 0 .7l4.37 4.37c.2.2.5.2.7 0l4.72-4.71c.2-.2.51-.2.7 0l1.43 1.42c.3.3.8.12.85-.3L17 3.56ZM16.33 2c.96-.1 1.77.7 1.66 1.66l-1.08 9.7a1.5 1.5 0 0 1-2.55.9L13.3 13.2l-4.36 4.36a1.5 1.5 0 0 1-2.12 0l-4.37-4.37a1.5 1.5 0 0 1 0-2.12L6.8 6.7 5.74 5.64a1.5 1.5 0 0 1 .89-2.55L16.33 2Z"]));
export const ArrowParagraphFilled = ( /*#__PURE__*/createFluentIcon('ArrowParagraphFilled', "1em", ["M17.25 2c.41 0 .75.34.75.75v2.5A2.75 2.75 0 0 1 15.25 8h-3.8l1.36 1.5a.75.75 0 0 1-1.12 1L9.2 7.75a.75.75 0 0 1 0-1L11.7 4a.75.75 0 0 1 1.12 1l-1.36 1.5h3.8c.69 0 1.25-.56 1.25-1.25v-2.5c0-.41.34-.75.75-.75ZM8.3 9.5a.75.75 0 1 0-1.1 1L8.55 12h-5.8a.75.75 0 0 0 0 1.5h5.8L7.2 15a.75.75 0 0 0 1.1 1l2.5-2.75a.75.75 0 0 0 0-1L8.3 9.5Z"]));
export const ArrowParagraphRegular = ( /*#__PURE__*/createFluentIcon('ArrowParagraphRegular', "1em", ["M12.15 10.85a.5.5 0 0 0 .7-.7L10.71 8h4.79A2.5 2.5 0 0 0 18 5.5v-3s0-.5-.5-.5-.5.5-.5.5v3c0 .83-.67 1.5-1.5 1.5h-4.8l2.15-2.15a.5.5 0 0 0-.7-.7l-3 3a.5.5 0 0 0 0 .7l3 3Zm-4.3-1.7a.5.5 0 1 0-.7.7L9.29 12H2.5s-.5 0-.5.5.5.5.5.5h6.8l-2.15 2.15a.5.5 0 0 0 .7.7l3-3a.5.5 0 0 0 0-.7l-3-3Z"]));
export const ArrowPreviousFilled = ( /*#__PURE__*/createFluentIcon('ArrowPreviousFilled', "1em", ["M6 4.75c-.38 0-.7.28-.74.65l-.01.1v9a.75.75 0 0 0 1.5.1V5.5A.75.75 0 0 0 6 4.75Zm8.28.22a.75.75 0 0 0-.98-.07l-.08.07-4.5 4.5a.75.75 0 0 0-.07.98l.07.08 4.5 4.5a.75.75 0 0 0 1.13-.98l-.07-.08L10.31 10l3.97-3.97c.3-.3.3-.77 0-1.06Z"], { flipInRtl: true }));
export const ArrowPreviousRegular = ( /*#__PURE__*/createFluentIcon('ArrowPreviousRegular', "1em", ["M6 5a.5.5 0 0 0-.5.41v9.09a.5.5 0 0 0 1 .09V5.5A.5.5 0 0 0 6 5Zm7.85.15a.5.5 0 0 0-.63-.06l-.07.06-4.5 4.5a.5.5 0 0 0-.06.63l.06.07 4.5 4.5a.5.5 0 0 0 .76-.63l-.06-.07L9.71 10l4.14-4.15a.5.5 0 0 0 0-.7Z"], { flipInRtl: true }));
export const ArrowRedoFilled = ( /*#__PURE__*/createFluentIcon('ArrowRedoFilled', "1em", ["M13.14 6.5h-2.39a.75.75 0 1 0 0 1.5h4.4c.47 0 .85-.38.85-.85v-4.4a.75.75 0 0 0-1.5 0V5.7l-3.06-2.66a5.25 5.25 0 0 0-6.88 7.92l8.17 7.1a.75.75 0 1 0 .98-1.13l-8.17-7.1a3.75 3.75 0 1 1 4.92-5.66l2.68 2.33Z"], { flipInRtl: true }));
export const ArrowRedoRegular = ( /*#__PURE__*/createFluentIcon('ArrowRedoRegular', "1em", ["M15 2.5a.5.5 0 0 1 1 0v4.9a.6.6 0 0 1-.6.6h-4.9a.5.5 0 0 1 0-1h3.6l-3.48-3.02a4 4 0 1 0-5.24 6.04l8.17 7.1a.5.5 0 1 1-.66.76l-8.17-7.1a5 5 0 1 1 6.56-7.55L15 6.46V2.5Z"], { flipInRtl: true }));
export const ArrowRepeat1Filled = ( /*#__PURE__*/createFluentIcon('ArrowRepeat1Filled', "1em", ["M15.75 6.01c.18 0 .35.06.48.17a4.98 4.98 0 0 1 1.74 4.4c-.46-.23-.95-.4-1.47-.49V10a3.5 3.5 0 0 0-1.26-2.69.75.75 0 0 1 .5-1.3Zm-5.38 7.49c-.18.47-.3.98-.35 1.5H8.56l1.22 1.22c.27.27.3.68.08.98l-.08.08a.75.75 0 0 1-.97.07l-.09-.07-2.5-2.5a.75.75 0 0 1-.07-.98l.07-.08 2.5-2.5a.75.75 0 0 1 1.14.98l-.08.08-1.22 1.22h1.81Zm-.15-10.78a.75.75 0 0 1 .98-.07l.08.07 2.5 2.5.08.08c.19.26.2.62 0 .89l-.08.09-2.5 2.5-.08.07c-.26.2-.62.2-.88.01l-.1-.08-.07-.08a.75.75 0 0 1 0-.89l.07-.09 1.22-1.22H7a3.5 3.5 0 0 0-3.5 3.3v.2c0 1.08.5 2.05 1.26 2.7.15.13.24.32.24.54a.75.75 0 0 1-1.25.56A5 5 0 0 1 6.78 5h4.66l-1.22-1.22-.07-.08a.75.75 0 0 1 .07-.98ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.95-2.66a.62.62 0 0 0-.68.23c-.21.3-.58.73-1.1.98a.5.5 0 1 0 .45.9c.3-.15.56-.34.78-.53v3.08a.5.5 0 0 0 1 0v-4.08a.61.61 0 0 0-.45-.58Z"]));
export const ArrowRepeat1Regular = ( /*#__PURE__*/createFluentIcon('ArrowRepeat1Regular', "1em", ["M16.5 6.67a.5.5 0 0 1 .3.1l.08.07.01.02a4.98 4.98 0 0 1 1.08 3.72c-.31-.15-.64-.28-.98-.37a4 4 0 0 0-.88-2.73.5.5 0 0 1 .39-.81ZM10.2 14c-.08.32-.15.66-.18 1H6.7l1.65 1.65c.18.17.2.44.06.63l-.06.07a.5.5 0 0 1-.63.06l-.07-.06-2.5-2.5a.5.5 0 0 1-.06-.63l.06-.07 2.5-2.5a.5.5 0 0 1 .76.63l-.06.07L6.72 14h.14L7 14h3.2Zm1.45-11.35a.5.5 0 0 1 .63-.06l.07.06 2.5 2.5.06.07a.5.5 0 0 1 0 .56l-.06.07-2.5 2.5-.07.06a.5.5 0 0 1-.56 0l-.07-.06-.06-.07a.5.5 0 0 1 0-.56l.06-.07L13.28 6h-.14L13 6H7a4 4 0 0 0-3.1 6.52c.06.09.1.2.1.31a.5.5 0 0 1-.9.3A4.99 4.99 0 0 1 6.77 5h6.52l-1.65-1.65-.06-.07a.5.5 0 0 1 .06-.63ZM20 15.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.95-2.66a.62.62 0 0 0-.68.23c-.21.3-.58.73-1.1.98a.5.5 0 1 0 .45.9c.3-.15.56-.34.78-.53v3.08a.5.5 0 0 0 1 0v-4.08a.61.61 0 0 0-.45-.58Z"]));
export const ArrowRepeatAllFilled = ( /*#__PURE__*/createFluentIcon('ArrowRepeatAllFilled', "1em", ["M15.75 6.01c.18 0 .34.06.47.17a5 5 0 0 1-3 8.82H8.56l1.22 1.22c.27.27.3.68.07.98l-.07.08a.75.75 0 0 1-.98.07l-.08-.07-2.5-2.5a.75.75 0 0 1-.07-.98l.07-.08 2.5-2.5a.75.75 0 0 1 1.13.98l-.07.08-1.22 1.22H13a3.5 3.5 0 0 0 3.5-3.3V10a3.5 3.5 0 0 0-1.26-2.69.75.75 0 0 1 .5-1.3Zm-5.53-3.29a.75.75 0 0 1 .98-.07l.08.07 2.5 2.5.07.08c.2.26.2.62.01.89l-.08.09-2.5 2.5-.08.07c-.26.2-.62.2-.89.01l-.09-.08-.07-.08a.75.75 0 0 1-.01-.89l.08-.09 1.22-1.22H7a3.5 3.5 0 0 0-3.5 3.3v.2c0 1.08.49 2.05 1.26 2.7.15.13.24.32.24.54a.75.75 0 0 1-1.25.56A5 5 0 0 1 6.78 5h4.66l-1.22-1.22-.07-.08a.75.75 0 0 1 .07-.98Z"], { flipInRtl: true }));
export const ArrowRepeatAllRegular = ( /*#__PURE__*/createFluentIcon('ArrowRepeatAllRegular', "1em", ["M16.5 6.67a.5.5 0 0 1 .3.1l.08.07.01.02A5 5 0 0 1 13.22 15L13 15H6.7l1.65 1.65c.18.17.2.44.06.63l-.06.07a.5.5 0 0 1-.63.06l-.07-.06-2.5-2.5a.5.5 0 0 1-.06-.63l.06-.07 2.5-2.5a.5.5 0 0 1 .76.63l-.06.07L6.72 14h.14L7 14h6a4 4 0 0 0 3.11-6.52.5.5 0 0 1 .39-.81Zm-4.85-4.02a.5.5 0 0 1 .63-.06l.07.06 2.5 2.5.06.07a.5.5 0 0 1 0 .56l-.06.07-2.5 2.5-.07.06a.5.5 0 0 1-.56 0l-.07-.06-.06-.07a.5.5 0 0 1 0-.56l.06-.07L13.28 6h-.14L13 6H7a4 4 0 0 0-3.1 6.52c.06.09.1.2.1.31a.5.5 0 0 1-.9.3A4.99 4.99 0 0 1 6.77 5h6.52l-1.65-1.65-.06-.07a.5.5 0 0 1 .06-.63Z"], { flipInRtl: true }));
export const ArrowRepeatAllOffFilled = ( /*#__PURE__*/createFluentIcon('ArrowRepeatAllOffFilled', "1em", ["M2.22 2.22a.75.75 0 0 1 .98-.07l.08.07 14.5 14.5.07.08a.75.75 0 0 1-1.05 1.05l-.08-.07-2.86-2.85c-.18.03-.37.05-.57.06L13 15H8.56l1.22 1.22c.27.27.3.68.07.98l-.07.08a.75.75 0 0 1-.98.07l-.08-.07-2.5-2.5a.75.75 0 0 1-.07-.98l.07-.08 2.5-2.5a.75.75 0 0 1 1.13.98l-.07.08-1.22 1.22h3.88L5.69 6.75A3.5 3.5 0 0 0 3.5 9.81V10c0 1.08.49 2.05 1.26 2.7.15.13.24.32.24.54a.75.75 0 0 1-1.25.56 4.98 4.98 0 0 1 .82-8.17L2.22 3.28l-.07-.08a.75.75 0 0 1 .07-.98Zm13.53 3.79c.18 0 .34.06.47.17a4.98 4.98 0 0 1 .03 7.62l-1.06-1.07a3.5 3.5 0 0 0 .05-5.42.75.75 0 0 1 .5-1.3Zm-5.53-3.3a.75.75 0 0 1 .98-.06l.08.07 2.5 2.5.07.08c.2.26.2.62.01.89l-.08.09-2.5 2.5-.02.02-1.06-1.06.02-.02 1.22-1.22H8.95L7.45 5h3.99l-1.22-1.22-.07-.08a.75.75 0 0 1 .07-.98Z"], { flipInRtl: true }));
export const ArrowRepeatAllOffRegular = ( /*#__PURE__*/createFluentIcon('ArrowRepeatAllOffRegular', "1em", ["M2.15 2.15a.5.5 0 0 1 .63-.06l.07.06 15 15 .06.07a.5.5 0 0 1-.7.7l-.06-.07-3-2.98a5 5 0 0 1-.85.12L13 15H6.7l1.65 1.65c.18.17.2.44.06.63l-.06.07a.5.5 0 0 1-.63.06l-.07-.06-2.5-2.5a.5.5 0 0 1-.06-.63l.06-.07 2.5-2.5a.5.5 0 0 1 .76.63l-.06.07L6.72 14h.14L7 14h6l.28-.01-7.72-7.72a4 4 0 0 0-1.66 6.25c.06.09.1.2.1.31a.5.5 0 0 1-.9.3A4.99 4.99 0 0 1 4.8 5.5L2.15 2.85l-.06-.07a.5.5 0 0 1 .06-.63ZM16.5 6.67a.5.5 0 0 1 .3.1l.08.07.01.02a4.98 4.98 0 0 1-.83 7.1l-.71-.72a4 4 0 0 0 .76-5.76.5.5 0 0 1 .39-.81ZM12.28 2.6l.07.06 2.5 2.5c.18.17.2.44.06.63l-.06.07-2.5 2.5a.5.5 0 0 1-.76-.63l.06-.07L13.28 6h-.14L13 6H8.1l-1-1h6.2l-1.65-1.65a.5.5 0 0 1-.06-.63l.06-.07a.5.5 0 0 1 .63-.06Z"], { flipInRtl: true }));
export const ArrowReplyFilled = ( /*#__PURE__*/createFluentIcon('ArrowReplyFilled', "1em", ["M7.78 4.78a.75.75 0 0 0-1.06-1.06l-4.5 4.5c-.3.3-.3.77 0 1.06l4.5 4.5a.75.75 0 0 0 1.06-1.06L4.56 9.5h6.19a5.75 5.75 0 0 1 5.75 5.75.75.75 0 0 0 1.5 0c0-4-3.25-7.25-7.25-7.25H4.56l3.22-3.22Z"], { flipInRtl: true }));
export const ArrowReplyRegular = ( /*#__PURE__*/createFluentIcon('ArrowReplyRegular', "1em", ["M7.35 3.65c.2.2.2.5 0 .7L3.71 8h6.79a7.5 7.5 0 0 1 7.5 7.5.5.5 0 0 1-1 0A6.5 6.5 0 0 0 10.5 9H3.7l3.65 3.65a.5.5 0 0 1-.7.7l-4.5-4.5a.5.5 0 0 1 0-.7l4.5-4.5c.2-.2.5-.2.7 0Z"], { flipInRtl: true }));
export const ArrowReplyAllFilled = ( /*#__PURE__*/createFluentIcon('ArrowReplyAllFilled', "1em", ["M7.78 4.78a.75.75 0 0 0-1.06-1.06l-4.5 4.5c-.3.3-.3.77 0 1.06l4.5 4.5a.75.75 0 0 0 1.06-1.06L3.81 8.75l3.97-3.97Zm3.5 0a.75.75 0 0 0-1.06-1.06l-4.5 4.5c-.3.3-.3.77 0 1.06l4.5 4.5a.75.75 0 1 0 1.06-1.06L8.06 9.5h2.69a5.75 5.75 0 0 1 5.75 5.75.75.75 0 0 0 1.5 0c0-4-3.25-7.25-7.25-7.25H8.06l3.22-3.22Z"], { flipInRtl: true }));
export const ArrowReplyAllRegular = ( /*#__PURE__*/createFluentIcon('ArrowReplyAllRegular', "1em", ["M7.35 3.65c.2.2.2.5 0 .7L3.21 8.5l4.14 4.15a.5.5 0 0 1-.7.7l-4.5-4.5a.5.5 0 0 1 0-.7l4.5-4.5c.2-.2.5-.2.7 0Zm3 0c.2.2.2.5 0 .7L6.71 8h3.79a7.5 7.5 0 0 1 7.5 7.5.5.5 0 0 1-1 0A6.5 6.5 0 0 0 10.5 9H6.7l3.65 3.65a.5.5 0 0 1-.7.7l-4.5-4.5a.5.5 0 0 1 0-.7l4.5-4.5c.2-.2.5-.2.7 0Z"], { flipInRtl: true }));
export const ArrowReplyDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowReplyDownFilled', "1em", ["M17.25 4c.41 0 .75.34.75.75 0 4-3.25 7.25-7.25 7.25H4.56l3.22 3.22a.75.75 0 1 1-1.06 1.06l-4.5-4.5a.75.75 0 0 1 0-1.06l4.5-4.5a.75.75 0 0 1 1.06 1.06L4.56 10.5h6.19a5.75 5.75 0 0 0 5.75-5.75c0-.41.34-.75.75-.75Z"], { flipInRtl: true }));
export const ArrowReplyDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowReplyDownRegular', "1em", ["M17.5 4c.28 0 .5.22.5.5a7.5 7.5 0 0 1-7.5 7.5H3.7l3.65 3.65a.5.5 0 0 1-.7.7l-4.5-4.5a.5.5 0 0 1 0-.7l4.5-4.5a.5.5 0 1 1 .7.7L3.71 11h6.79A6.5 6.5 0 0 0 17 4.5c0-.28.22-.5.5-.5Z"], { flipInRtl: true }));
export const ArrowResetFilled = ( /*#__PURE__*/createFluentIcon('ArrowResetFilled', "1em", ["M6.03 2.47c.3.3.3.77 0 1.06L4.81 4.75H11A6.25 6.25 0 1 1 4.75 11a.75.75 0 0 1 1.5 0A4.75 4.75 0 1 0 11 6.25H4.81l1.22 1.22a.75.75 0 0 1-1.06 1.06l-2.5-2.5a.75.75 0 0 1 0-1.06l2.5-2.5c.3-.3.77-.3 1.06 0Z"], { flipInRtl: true }));
export const ArrowResetRegular = ( /*#__PURE__*/createFluentIcon('ArrowResetRegular', "1em", ["M5.85 2.65c.2.2.2.5 0 .7L4.21 5H11a6 6 0 1 1-6 6 .5.5 0 0 1 1 0 5 5 0 1 0 5-5H4.2l1.65 1.65a.5.5 0 1 1-.7.7l-2.5-2.5a.5.5 0 0 1 0-.7l2.5-2.5c.2-.2.5-.2.7 0Z"], { flipInRtl: true }));
export const ArrowRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowRightFilled', "1em", ["M11.27 3.2a.75.75 0 0 0-1.04 1.1l5.24 4.95H2.75a.75.75 0 0 0 0 1.5h12.73l-5.25 4.96a.75.75 0 1 0 1.04 1.09l6.41-6.07a1 1 0 0 0 0-1.46l-6.41-6.06Z"]));
export const ArrowRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowRightRegular', "1em", ["M10.84 3.13a.5.5 0 0 0-.68.74l6.17 5.63H2.5a.5.5 0 0 0 0 1h13.83l-6.17 5.63a.5.5 0 0 0 .68.74l6.91-6.32a.75.75 0 0 0 0-1.1l-6.91-6.32Z"]));
export const ArrowRotateClockwiseFilled = ( /*#__PURE__*/createFluentIcon('ArrowRotateClockwiseFilled', "1em", ["M10 3.5A6.5 6.5 0 0 0 3.5 10 .75.75 0 0 1 2 10a8 8 0 1 1 12.66 6.5h1.09a.75.75 0 0 1 0 1.5h-3a.75.75 0 0 1-.75-.75v-3a.75.75 0 0 1 1.5 0v1.23A6.5 6.5 0 0 0 10 3.5Zm2.5 6.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0ZM11 10a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"], { flipInRtl: true }));
export const ArrowRotateClockwiseRegular = ( /*#__PURE__*/createFluentIcon('ArrowRotateClockwiseRegular', "1em", ["M3 10a7 7 0 1 1 10 6.33V14.5a.5.5 0 0 0-1 0v3c0 .28.22.5.5.5h3a.5.5 0 0 0 0-1h-1.62A8 8 0 1 0 2 10a.5.5 0 0 0 1 0Zm7 2a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0-1a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"], { flipInRtl: true }));
export const ArrowRotateCounterclockwiseFilled = ( /*#__PURE__*/createFluentIcon('ArrowRotateCounterclockwiseFilled', "1em", ["M10 3.5a6.5 6.5 0 0 1 6.5 6.5.75.75 0 0 0 1.5 0 8 8 0 1 0-12.66 6.5H4.25a.75.75 0 0 0 0 1.5h3c.41 0 .75-.34.75-.75v-3a.75.75 0 0 0-1.5 0v1.23A6.5 6.5 0 0 1 10 3.5ZM7.5 10a2.5 2.5 0 1 0 5 0 2.5 2.5 0 0 0-5 0ZM9 10a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z"], { flipInRtl: true }));
export const ArrowRotateCounterclockwiseRegular = ( /*#__PURE__*/createFluentIcon('ArrowRotateCounterclockwiseRegular', "1em", ["M17 10a7 7 0 1 0-10 6.33V14.5a.5.5 0 0 1 1 0v3a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1 0-1h1.62A8 8 0 1 1 18 10a.5.5 0 0 1-1 0Zm-7 2a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm0-1a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"], { flipInRtl: true }));
export const ArrowRoutingFilled = ( /*#__PURE__*/createFluentIcon('ArrowRoutingFilled', "1em", ["M14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5Z"]));
export const ArrowRoutingRegular = ( /*#__PURE__*/createFluentIcon('ArrowRoutingRegular', "1em", ["M14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5ZM7 13a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"]));
export const ArrowRoutingRectangleMultipleFilled = ( /*#__PURE__*/createFluentIcon('ArrowRoutingRectangleMultipleFilled', "1em", ["M11 12.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5v4a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-4Zm8 2a.5.5 0 0 0-1 0V17a1 1 0 0 1-1 1h-3.5a.5.5 0 0 0 0 1H17a2 2 0 0 0 2-2v-2.5ZM14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5Z"]));
export const ArrowRoutingRectangleMultipleRegular = ( /*#__PURE__*/createFluentIcon('ArrowRoutingRectangleMultipleRegular', "1em", ["M11 12.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5v4a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-4Zm8 2a.5.5 0 0 0-1 0V17a1 1 0 0 1-1 1h-3.5a.5.5 0 0 0 0 1H17a2 2 0 0 0 2-2v-2.5ZM14.31 3.15a.5.5 0 0 0-.7.7l2.64 2.65H12A2.5 2.5 0 0 0 9.5 9v2c0 .83-.67 1.5-1.5 1.5h-.04a3 3 0 1 0 0 1H8a2.5 2.5 0 0 0 2.5-2.5V9c0-.83.67-1.5 1.5-1.5h4.25l-2.64 2.65a.5.5 0 1 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5ZM7 13a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"]));
export const ArrowShuffleFilled = ( /*#__PURE__*/createFluentIcon('ArrowShuffleFilled', "1em", ["M15.78 3.72a.75.75 0 1 0-1.06 1.06l.75.75c-3.09.28-4.88 2.2-6.47 3.9l-.05.06C7.2 11.38 5.65 13 2.75 13a.75.75 0 0 0 0 1.5c3.58 0 5.53-2.09 7.25-3.94l.05-.05c1.58-1.7 2.98-3.17 5.34-3.46l-.67.67a.75.75 0 0 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2ZM2.75 5.5c2.78 0 4.58 1.26 6.05 2.7l-.48.5-.1.1-.45.49C6.42 7.97 4.99 7 2.75 7a.75.75 0 1 1 0-1.5Zm12.72 8.97c-2.34-.21-3.94-1.37-5.27-2.66l.49-.51.09-.1.45-.49c1.17 1.14 2.4 2.02 4.16 2.24l-.67-.67a.75.75 0 1 1 1.06-1.06l2 2c.3.3.3.77 0 1.06l-2 2a.75.75 0 1 1-1.06-1.06l.75-.75Z"]));
export const ArrowShuffleRegular = ( /*#__PURE__*/createFluentIcon('ArrowShuffleRegular', "1em", ["M15.85 4.15a.5.5 0 0 0-.7.7L16.3 6c-3.33.07-5.29 1.9-7.1 3.6l-.04.03C7.28 11.4 5.53 13 2.5 13a.5.5 0 0 0 0 1c3.45 0 5.45-1.87 7.3-3.6l.04-.03C11.68 8.65 13.4 7.07 16.3 7l-1.14 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2ZM2.5 6c2.81 0 4.66 1.24 6.26 2.64l-.28.26-.46.43C6.52 8.03 4.92 7 2.5 7a.5.5 0 0 1 0-1Zm13.8 8c-2.7-.06-4.5-1.28-6.06-2.64l.28-.26.46-.43c1.46 1.27 3 2.27 5.31 2.33l-1.14-1.15a.5.5 0 0 1 .7-.7l2 2c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7L16.3 14Z"]));
export const ArrowShuffleOffFilled = ( /*#__PURE__*/createFluentIcon('ArrowShuffleOffFilled', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7l3 3a7.9 7.9 0 0 0-2.4-.35.75.75 0 0 0 0 1.5c2.24 0 3.67.97 5.02 2.29l.4-.42.7.7C7.14 11.44 5.6 13 2.75 13a.75.75 0 0 0 0 1.5c3.53 0 5.47-2.03 7.18-3.86l.7.7c-.13.16-.28.31-.43.47.85.82 1.8 1.6 3 2.1l1.43 1.42a.75.75 0 0 0 1.04 1.04l1.48 1.48a.5.5 0 0 0 .7-.7l-15-15Zm12.16 10.74 2.08 2.08.69-.69c.3-.3.3-.77 0-1.06l-2-2a.75.75 0 1 0-1.06 1.06l.67.67a6.32 6.32 0 0 1-.38-.06Zm-4.75-4.75 1.06 1.06a6.92 6.92 0 0 1 4.07-2.15l-.67.67a.75.75 0 0 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2a.75.75 0 1 0-1.06 1.06l.75.75c-2.3.21-3.9 1.34-5.21 2.6Z"]));
export const ArrowShuffleOffRegular = ( /*#__PURE__*/createFluentIcon('ArrowShuffleOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L6.09 6.8A8.12 8.12 0 0 0 2.5 6a.5.5 0 1 0 0 1c2.42 0 4.02 1.02 5.52 2.33l.31-.3.7.72C7.2 11.45 5.48 13 2.5 13a.5.5 0 0 0 0 1c3.4 0 5.4-1.83 7.25-3.55l.7.71-.2.2c.53.47 1.1.92 1.72 1.32l5.18 5.17a.5.5 0 0 0 .7-.7l-15-15Zm12.12 10.7 1.14 1.14h.19l-.1.1.71.7.94-.94a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L16.29 13a7.5 7.5 0 0 1-1.32-.15ZM10.52 8.4l.71.71c1.39-1.16 2.9-2.05 5.06-2.1l-1.14 1.14a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L16.3 6c-2.54.06-4.28 1.14-5.78 2.4Z"]));
export const ArrowSortFilled = ( /*#__PURE__*/createFluentIcon('ArrowSortFilled', "1em", ["M14.84 16.72a.76.76 0 0 1-.59.28.73.73 0 0 1-.53-.22l-3-3a.75.75 0 0 1 1.06-1.07l1.72 1.73V3.75a.75.75 0 0 1 1.5 0v10.68l1.72-1.71a.75.75 0 1 1 1.06 1.06l-2.94 2.94ZM6.34 3.28A.76.76 0 0 0 5.75 3c-.2 0-.38.07-.53.22l-3 3A.75.75 0 0 0 3.28 7.3L5 5.56v10.69a.75.75 0 0 0 1.5 0V5.57l1.72 1.71a.75.75 0 1 0 1.06-1.06L6.34 3.28Z"]));
export const ArrowSortRegular = ( /*#__PURE__*/createFluentIcon('ArrowSortRegular', "1em", ["M2.35 7.35 5 4.71V16.5a.5.5 0 0 0 1 0V4.7l2.65 2.65a.5.5 0 0 0 .7-.7l-3.49-3.5A.5.5 0 0 0 5.5 3a.5.5 0 0 0-.39.18L1.65 6.65a.5.5 0 1 0 .7.7Zm15.3 5.3L15 15.29V3.5a.5.5 0 0 0-1 0v11.8l-2.65-2.65a.5.5 0 0 0-.7.7l3.49 3.5a.5.5 0 0 0 .36.15.5.5 0 0 0 .39-.18l3.46-3.47a.5.5 0 1 0-.7-.7Z"]));
export const ArrowSortDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowSortDownFilled', "1em", ["M9.75 17c.23 0 .45-.1.59-.28l2.94-2.94a.75.75 0 0 0-1.06-1.06l-1.72 1.71V3.75a.75.75 0 0 0-1.5 0v10.7L7.28 12.7a.75.75 0 1 0-1.06 1.06l3 3.01c.15.15.34.22.53.22Z"]));
export const ArrowSortDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowSortDownRegular', "1em", ["m10 15.29 2.65-2.64a.5.5 0 0 1 .7.7L9.9 16.82a.5.5 0 0 1-.74.03h-.01l-3.5-3.5a.5.5 0 1 1 .71-.7L9 15.29V3.5a.5.5 0 0 1 1 0v11.79Z"]));
export const ArrowSortDownLinesFilled = ( /*#__PURE__*/createFluentIcon('ArrowSortDownLinesFilled', "1em", ["M15 2.75a.75.75 0 0 0-1.5 0v12.57l-1.45-1.58a.75.75 0 0 0-1.1 1.02l2.75 3a.75.75 0 0 0 1.1 0l2.75-3a.75.75 0 0 0-1.1-1.02L15 15.32V2.75ZM2.75 3.5a.75.75 0 0 0 0 1.5h8.5a.75.75 0 0 0 0-1.5h-8.5ZM5 7.25c0-.41.34-.75.75-.75h5.5a.75.75 0 0 1 0 1.5h-5.5A.75.75 0 0 1 5 7.25ZM8.75 9.5a.75.75 0 0 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5Z"]));
export const ArrowSortDownLinesRegular = ( /*#__PURE__*/createFluentIcon('ArrowSortDownLinesRegular', "1em", ["M15 2.5a.5.5 0 0 0-1 0v13.8l-2.15-2.15a.5.5 0 0 0-.7.7l3 3c.2.2.5.2.7 0l3-3a.5.5 0 0 0-.7-.7L15 16.29V2.5ZM2.5 4a.5.5 0 0 0 0 1h9a.5.5 0 0 0 0-1h-9ZM5 7.5c0-.28.22-.5.5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5ZM8.5 10a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const ArrowSortUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowSortUpFilled', "1em", ["M9.75 3c.23 0 .45.1.59.28l2.94 2.94a.75.75 0 0 1-1.06 1.06L10.5 5.57v10.68a.75.75 0 0 1-1.5 0V5.55L7.28 7.3a.75.75 0 1 1-1.06-1.06l3-3.01A.73.73 0 0 1 9.75 3Z"]));
export const ArrowSortUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowSortUpRegular', "1em", ["M9 4.71 6.35 7.35a.5.5 0 1 1-.7-.7L9.1 3.18a.5.5 0 0 1 .74-.03h.01l3.5 3.5a.5.5 0 1 1-.71.7L10 4.71V16.5a.5.5 0 0 1-1 0V4.71Z"]));
export const ArrowSortUpLinesFilled = ( /*#__PURE__*/createFluentIcon('ArrowSortUpLinesFilled', "1em", ["M15 17.25a.75.75 0 0 1-1.5 0V4.68l-1.45 1.58a.75.75 0 0 1-1.1-1.02l2.75-3a.75.75 0 0 1 1.1 0l2.75 3a.75.75 0 0 1-1.1 1.02L15 4.68v12.57ZM2.75 16.5a.75.75 0 0 1 0-1.5h8.5a.75.75 0 0 1 0 1.5h-8.5ZM5 12.75c0 .41.34.75.75.75h5.5a.75.75 0 0 0 0-1.5h-5.5a.75.75 0 0 0-.75.75Zm3.75-2.25a.75.75 0 0 1 0-1.5h2.5a.75.75 0 0 1 0 1.5h-2.5Z"]));
export const ArrowSortUpLinesRegular = ( /*#__PURE__*/createFluentIcon('ArrowSortUpLinesRegular', "1em", ["M15 17.5a.5.5 0 0 1-1 0V3.7l-2.15 2.15a.5.5 0 0 1-.7-.7l3-3c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7L15 3.71V17.5ZM2.5 16a.5.5 0 0 1 0-1h9a.5.5 0 0 1 0 1h-9ZM5 12.5c0 .28.22.5.5.5h6a.5.5 0 0 0 0-1h-6a.5.5 0 0 0-.5.5ZM8.5 10a.5.5 0 0 1 0-1h3a.5.5 0 0 1 0 1h-3Z"]));
export const ArrowSplitFilled = ( /*#__PURE__*/createFluentIcon('ArrowSplitFilled', "1em", ["M10 3c.41 0 .75.34.75.75V8h2.24a2 2 0 0 1 2 2v4.44l1.23-1.22a.75.75 0 1 1 1.06 1.06l-2.5 2.5c-.3.3-.77.3-1.07 0l-2.5-2.5a.75.75 0 1 1 1.07-1.06l1.21 1.22V10a.5.5 0 0 0-.5-.5H7a.5.5 0 0 0-.5.5v4.44l1.23-1.22a.75.75 0 0 1 1.06 1.06l-2.5 2.5a.75.75 0 0 1-1.06 0l-2.5-2.5a.75.75 0 1 1 1.06-1.06L5 14.44V10c0-1.1.9-2 2-2h2.25V3.75c0-.41.34-.75.75-.75Z"]));
export const ArrowSplitRegular = ( /*#__PURE__*/createFluentIcon('ArrowSplitRegular', "1em", ["M10 3c.28 0 .5.22.5.5V8H13a2 2 0 0 1 2 2v5.3l1.65-1.65a.5.5 0 0 1 .7.7l-2.5 2.5a.5.5 0 0 1-.7 0l-2.5-2.5a.5.5 0 0 1 .7-.7L14 15.29V10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v5.3l1.65-1.65a.5.5 0 0 1 .7.7l-2.5 2.5a.5.5 0 0 1-.7 0l-2.5-2.5a.5.5 0 0 1 .7-.7L5 15.29V10c0-1.1.9-2 2-2h2.5V3.5c0-.28.22-.5.5-.5Z"]));
export const ArrowSprintFilled = ( /*#__PURE__*/createFluentIcon('ArrowSprintFilled', "1em", ["M10 6.5a3 3 0 1 0 0 6h6.44l-.72-.72a.75.75 0 1 1 1.06-1.06l2 2c.3.3.3.77 0 1.06l-2 2a.75.75 0 1 1-1.06-1.06l.72-.72H10a4.5 4.5 0 1 1 4.03-2.5h-1.8a3 3 0 0 0-2.24-5Zm-7.25 6h2.64c.38.59.87 1.1 1.45 1.5H2.75a.75.75 0 0 1 0-1.5Z"]));
export const ArrowSprintRegular = ( /*#__PURE__*/createFluentIcon('ArrowSprintRegular', "1em", ["M10 6a3.5 3.5 0 1 0 0 7h7.3l-1.15-1.15a.5.5 0 0 1 .7-.7l2 2c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7L17.29 14H10a4.5 4.5 0 1 1 3.74-2h-1.29A3.49 3.49 0 0 0 10 6Zm-7.5 7h3.26c.31.38.67.72 1.08 1H2.5a.5.5 0 0 1 0-1Z"]));
export const ArrowSquareColor = ( /*#__PURE__*/createFluentIcon('ArrowSquareColor', "1em", `<path d="M5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H5Z" fill="url(#ic_fluent_arrow_square_20_color__a)"/><path d="M10.5 6.5a.5.5 0 0 0-1 0v5.8L6.85 9.64a.5.5 0 1 0-.7.7l3.5 3.5c.2.2.5.2.7 0l3.5-3.5a.5.5 0 0 0-.7-.7l-2.65 2.64V6.5Z" fill="url(#ic_fluent_arrow_square_20_color__b)"/><defs><linearGradient id="ic_fluent_arrow_square_20_color__a" x1="3.5" y1="5.63" x2="14.5" y2="14.38" gradientUnits="userSpaceOnUse"><stop stop-color="#36DFF1"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_arrow_square_20_color__b" x1="7.54" y1="6.62" x2="14" y2="20.62" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient></defs>`, { color: true }));
export const ArrowSquareDownColor = ( /*#__PURE__*/createFluentIcon('ArrowSquareDownColor', "1em", `<path d="M5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H5Z" fill="url(#ic_fluent_arrow_square_down_20_color__a)"/><path d="M10.5 6.5a.5.5 0 0 0-1 0v5.8L6.85 9.64a.5.5 0 1 0-.7.7l3.5 3.5c.2.2.5.2.7 0l3.5-3.5a.5.5 0 0 0-.7-.7l-2.65 2.64V6.5Z" fill="url(#ic_fluent_arrow_square_down_20_color__b)"/><defs><linearGradient id="ic_fluent_arrow_square_down_20_color__a" x1="3.5" y1="5.63" x2="14.5" y2="14.38" gradientUnits="userSpaceOnUse"><stop stop-color="#36DFF1"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_arrow_square_down_20_color__b" x1="7.54" y1="6.62" x2="14" y2="20.62" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient></defs>`, { color: true }));
export const ArrowSquareDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowSquareDownFilled', "1em", ["M5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H5Zm5.5 3.5v5.8l2.65-2.65a.5.5 0 0 1 .7.7l-3.5 3.5a.5.5 0 0 1-.7 0l-3.5-3.5a.5.5 0 0 1 .7-.7l2.65 2.64V6.5a.5.5 0 0 1 1 0Z"]));
export const ArrowSquareDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowSquareDownRegular', "1em", ["M10.5 6.5a.5.5 0 0 0-1 0v5.8L6.85 9.64a.5.5 0 1 0-.7.7l3.5 3.5c.2.2.5.2.7 0l3.5-3.5a.5.5 0 1 0-.7-.7l-2.65 2.64V6.5ZM5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H5ZM4 5a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V5Z"]));
export const ArrowSquareUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowSquareUpRightFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm9.7 1.04a.5.5 0 0 0-.2-.04h-5a.5.5 0 0 0 0 1h3.8l-4.15 4.15a.5.5 0 0 0 .7.7L12 8.71v3.79a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-.14-.35.5.5 0 0 0-.17-.11Z"]));
export const ArrowSquareUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowSquareUpRightRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Zm8.7 1.04a.5.5 0 0 1 .3.46v5a.5.5 0 0 1-1 0V8.7l-4.15 4.15a.5.5 0 0 1-.7-.7L11.29 8H7.5a.5.5 0 0 1 0-1h5a.5.5 0 0 1 .2.04Z"]));
export const ArrowStepBackFilled = ( /*#__PURE__*/createFluentIcon('ArrowStepBackFilled', "1em", ["M7.85 3.15c.2.2.2.5 0 .7L4.71 7H10a8 8 0 0 1 6.94 4.04.5.5 0 1 1-.88.5A7 7 0 0 0 10 8H4.7l3.15 3.15a.5.5 0 0 1-.7.7L3.15 7.87a.5.5 0 0 1-.01-.72l4-4c.19-.2.5-.2.7 0ZM12 15a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"]));
export const ArrowStepBackRegular = ( /*#__PURE__*/createFluentIcon('ArrowStepBackRegular', "1em", ["M7.85 3.15c.2.2.2.5 0 .7L4.71 7H10a8 8 0 0 1 6.94 4.04.5.5 0 1 1-.88.5A7 7 0 0 0 10 8H4.7l3.15 3.15a.5.5 0 0 1-.7.7L3.15 7.87a.5.5 0 0 1-.01-.72l4-4c.19-.2.5-.2.7 0ZM8 15a2 2 0 1 1 4 0 2 2 0 0 1-4 0Zm2-1a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const ArrowStepInFilled = ( /*#__PURE__*/createFluentIcon('ArrowStepInFilled', "1em", ["M12 16a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM10 2c.28 0 .5.22.5.5v7.8l3.15-3.15a.5.5 0 0 1 .7.7l-4 4a.5.5 0 0 1-.7 0l-4-4a.5.5 0 1 1 .7-.7l3.15 3.14V2.5c0-.28.22-.5.5-.5Z"]));
export const ArrowStepInRegular = ( /*#__PURE__*/createFluentIcon('ArrowStepInRegular', "1em", ["M10 15a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0Zm2-14c.28 0 .5.22.5.5v7.8l3.15-3.15a.5.5 0 0 1 .7.7l-4 4a.5.5 0 0 1-.7 0l-4-4a.5.5 0 1 1 .7-.7l3.15 3.14V2.5c0-.28.22-.5.5-.5Z"]));
export const ArrowStepInDiagonalDownLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowStepInDiagonalDownLeftFilled', "1em", ["M16.85 3.15c.2.2.2.5 0 .7L9.71 11h4.79a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5v-6a.5.5 0 0 1 1 0v4.8l7.15-7.15c.2-.2.5-.2.7 0ZM5 17a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"]));
export const ArrowStepInDiagonalDownLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowStepInDiagonalDownLeftRegular', "1em", ["M16.85 3.15c.2.2.2.5 0 .7L9.71 11h4.79a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5v-6a.5.5 0 0 1 1 0v4.8l7.15-7.15c.2-.2.5-.2.7 0ZM7 15a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm-1 0a1 1 0 1 0-2 0 1 1 0 0 0 2 0Z"]));
export const ArrowStepInLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowStepInLeftFilled', "1em", ["M4 12a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm14-2a.5.5 0 0 1-.5.5H9.7l3.15 3.15a.5.5 0 0 1-.7.7l-4-4a.5.5 0 0 1 0-.7l4-4a.5.5 0 0 1 .7.7L9.71 9.5h7.79c.28 0 .5.22.5.5Z"]));
export const ArrowStepInLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowStepInLeftRegular', "1em", ["M5 10a1 1 0 1 0-2 0 1 1 0 0 0 2 0ZM4 8a2 2 0 1 1 0 4 2 2 0 0 1 0-4Zm14 2a.5.5 0 0 1-.5.5H9.7l3.15 3.15a.5.5 0 0 1-.7.7l-4-4a.5.5 0 0 1 0-.7l4-4a.5.5 0 0 1 .7.7L9.71 9.5h7.79c.28 0 .5.22.5.5Z"]));
export const ArrowStepInRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowStepInRightFilled', "1em", ["M16 8a2 2 0 1 1 0 4 2 2 0 0 1 0-4ZM2 10c0-.28.22-.5.5-.5h7.8L7.14 6.35a.5.5 0 1 1 .7-.7l4 4c.2.2.2.5 0 .7l-4 4a.5.5 0 0 1-.7-.7l3.14-3.15H2.5A.5.5 0 0 1 2 10Z"]));
export const ArrowStepInRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowStepInRightRegular', "1em", ["M15 10a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm1 2a2 2 0 1 1 0-4 2 2 0 0 1 0 4ZM2 10c0-.28.22-.5.5-.5h7.8L7.14 6.35a.5.5 0 1 1 .7-.7l4 4c.2.2.2.5 0 .7l-4 4a.5.5 0 0 1-.7-.7l3.14-3.15H2.5A.5.5 0 0 1 2 10Z"]));
export const ArrowStepOutFilled = ( /*#__PURE__*/createFluentIcon('ArrowStepOutFilled', "1em", ["M12 16a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm-2-4a.5.5 0 0 0 .5-.5V3.7l3.15 3.15a.5.5 0 0 0 .7-.7l-4-4a.5.5 0 0 0-.7 0l-4 4a.5.5 0 1 0 .7.7L9.5 3.71v7.79c0 .28.22.5.5.5Z"]));
export const ArrowStepOutRegular = ( /*#__PURE__*/createFluentIcon('ArrowStepOutRegular', "1em", ["M10 15a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0Zm2-4a.5.5 0 0 0 .5-.5V3.7l3.15 3.15a.5.5 0 0 0 .7-.7l-4-4a.5.5 0 0 0-.7 0l-4 4a.5.5 0 1 0 .7.7L9.5 3.71v7.79c0 .28.22.5.5.5Z"]));
export const ArrowStepOverFilled = ( /*#__PURE__*/createFluentIcon('ArrowStepOverFilled', "1em", ["M12.15 3.15a.5.5 0 0 0 0 .7L15.29 7H10a8 8 0 0 0-6.94 4.04.5.5 0 1 0 .88.5A7 7 0 0 1 10 8h5.3l-3.15 3.15a.5.5 0 1 0 .7.7l3.99-3.98a.5.5 0 0 0 .01-.72l-4-4a.5.5 0 0 0-.7 0ZM8 15a2 2 0 1 0 4 0 2 2 0 0 0-4 0Z"], { flipInRtl: true }));
export const ArrowStepOverRegular = ( /*#__PURE__*/createFluentIcon('ArrowStepOverRegular', "1em", ["M12.15 3.15a.5.5 0 0 0 0 .7L15.29 7H10a8 8 0 0 0-6.94 4.04.5.5 0 1 0 .88.5A7 7 0 0 1 10 8h5.3l-3.15 3.15a.5.5 0 1 0 .7.7l3.99-3.98a.5.5 0 0 0 .01-.72l-4-4a.5.5 0 0 0-.7 0ZM12 15a2 2 0 1 0-4 0 2 2 0 0 0 4 0Zm-2-1a1 1 0 1 1 0 2 1 1 0 0 1 0-2Z"], { flipInRtl: true }));
export const ArrowSwapFilled = ( /*#__PURE__*/createFluentIcon('ArrowSwapFilled', "1em", ["M12.78 3.22a.75.75 0 1 0-1.06 1.06L13.44 6H4.75a.75.75 0 0 0 0 1.5h8.69l-1.72 1.72a.75.75 0 1 0 1.06 1.06l3-3c.3-.3.3-.77 0-1.06l-3-3Zm-4.5 7.56a.75.75 0 1 0-1.06-1.06l-3 3a.75.75 0 0 0 0 1.06l3 3a.75.75 0 0 0 1.06-1.06L6.56 14h8.69a.75.75 0 0 0 0-1.5H6.56l1.72-1.72Z"], { flipInRtl: true }));
export const ArrowSwapRegular = ( /*#__PURE__*/createFluentIcon('ArrowSwapRegular', "1em", ["M12.15 3.15c.2-.2.5-.2.7 0l3 3c.2.2.2.5 0 .7l-3 3a.5.5 0 0 1-.7-.7L14.29 7H4.5a.5.5 0 0 1 0-1h9.8l-2.15-2.15a.5.5 0 0 1 0-.7Zm-4.3 7c.2.2.2.5 0 .7L5.71 13h9.79a.5.5 0 0 1 0 1H5.7l2.15 2.15a.5.5 0 0 1-.7.7l-3-3a.5.5 0 0 1 0-.7l3-3c.2-.2.5-.2.7 0Z"], { flipInRtl: true }));
export const ArrowSyncColor = ( /*#__PURE__*/createFluentIcon('ArrowSyncColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M8.3.3a1 1 0 0 1 1.4 0l2.5 2.5a1 1 0 0 1 0 1.4L9.7 6.7a1 1 0 0 1-1.4-1.4l.7-.7a5.5 5.5 0 0 0-2.51 9.63 1 1 0 0 1-1.28 1.54A7.49 7.49 0 0 1 9.14 2.55l-.85-.84a1 1 0 0 1 0-1.42Zm5.11 4.08a1 1 0 0 1 1.41-.12 7.49 7.49 0 0 1-3.96 13.2l.85.83a1 1 0 0 1-1.42 1.42l-2.5-2.5a1 1 0 0 1 0-1.42l2.5-2.5a1 1 0 0 1 1.42 1.42l-.7.7a5.5 5.5 0 0 0 2.53-9.62 1 1 0 0 1-.13-1.41Z" fill="url(#ic_fluent_arrow_sync_20_color__a)"/><defs><linearGradient id="ic_fluent_arrow_sync_20_color__a" x1="14" y1="16.5" x2="6" y2="0" gradientUnits="userSpaceOnUse"><stop stop-color="#22918B"/><stop offset="1" stop-color="#20AC9D"/></linearGradient></defs>`, { color: true }));
export const ArrowSyncFilled = ( /*#__PURE__*/createFluentIcon('ArrowSyncFilled', "1em", ["M9.89 3.75a6.25 6.25 0 0 0-3.63 11.26.75.75 0 0 1-.9 1.2 7.75 7.75 0 0 1 4-13.93l-.6-.59A.75.75 0 0 1 9.82.63l2.12 2.12c.3.3.3.77 0 1.06L9.82 5.93a.75.75 0 0 1-1.06-1.06L9.9 3.75Zm.22 12.5a6.25 6.25 0 0 0 3.63-11.26.75.75 0 0 1 .9-1.2 7.75 7.75 0 0 1-4 13.93l.6.59a.75.75 0 1 1-1.06 1.06l-2.12-2.12a.75.75 0 0 1 0-1.06l2.12-2.13a.75.75 0 1 1 1.06 1.07l-1.13 1.12Z"], { flipInRtl: true }));
export const ArrowSyncRegular = ( /*#__PURE__*/createFluentIcon('ArrowSyncRegular', "1em", ["M11.41 3.64a.5.5 0 0 0 0-.71L9.3.8a.5.5 0 0 0-.7.7l1 1a7.5 7.5 0 0 0-4.08 13.5.5.5 0 0 0 .6-.8A6.5 6.5 0 0 1 10.14 3.5L8.59 5.04a.5.5 0 0 0 .7.7l2.12-2.11ZM8.6 16.36a.5.5 0 0 0 0 .71l2.12 2.12a.5.5 0 0 0 .7-.7l-1-1a7.5 7.5 0 0 0 4.07-13.5.5.5 0 1 0-.59.8A6.5 6.5 0 0 1 9.86 16.5l1.55-1.55a.5.5 0 1 0-.7-.7l-2.12 2.11Z"], { flipInRtl: true }));
export const ArrowSyncCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('ArrowSyncCheckmarkFilled', "1em", ["M11.41 3.64a.5.5 0 0 0 0-.71L9.3.8a.5.5 0 0 0-.7.7l1 1a7.5 7.5 0 0 0-4.08 13.5.5.5 0 0 0 .6-.8A6.5 6.5 0 0 1 11.4 3.66l.01-.02ZM8.6 16.36l.01-.01c.41.09.83.14 1.27.15h-.01.07A6.5 6.5 0 0 0 13.9 4.8a.5.5 0 1 1 .6-.8 7.5 7.5 0 0 1-4.07 13.5l1 .98a.5.5 0 1 1-.71.71l-2.12-2.12a.5.5 0 0 1 0-.7ZM15 10a5 5 0 1 1-10 0 5 5 0 0 1 10 0Zm-2.65-1.85a.5.5 0 0 0-.7 0L9 10.79 7.85 9.65a.5.5 0 1 0-.7.7l1.5 1.5c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"], { flipInRtl: true }));
export const ArrowSyncCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('ArrowSyncCheckmarkRegular', "1em", ["M11.41 3.64a.5.5 0 0 0 0-.71L9.3.8a.5.5 0 0 0-.7.7l1 1a7.5 7.5 0 0 0-4.08 13.5.5.5 0 0 0 .6-.8A6.5 6.5 0 0 1 11.4 3.66l.01-.02ZM8.6 16.36l.01-.01c.41.09.83.14 1.27.15h-.01a6.48 6.48 0 0 0 4.74-1.9 6.5 6.5 0 0 0-.7-9.8.5.5 0 1 1 .6-.8 7.5 7.5 0 0 1-4.07 13.5l.98.98a.5.5 0 1 1-.7.71l-2.12-2.12a.5.5 0 0 1 0-.7Zm3.76-8.21c.2.2.2.5 0 .7l-3 3a.5.5 0 0 1-.7 0l-1.5-1.5a.5.5 0 0 1 .7-.7L9 10.79l2.65-2.64c.2-.2.5-.2.7 0ZM5 10a5 5 0 1 1 10 0 5 5 0 0 1-10 0Zm5-4a4 4 0 1 0 0 8 4 4 0 0 0 0-8Z"], { flipInRtl: true }));
export const ArrowSyncCircleFilled = ( /*#__PURE__*/createFluentIcon('ArrowSyncCircleFilled', "1em", ["M10 18a8 8 0 1 1 0-16 8 8 0 0 1 0 16Zm3.5-8a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v.7a3.5 3.5 0 0 0-5.6-.53.5.5 0 1 0 .74.66 2.5 2.5 0 0 1 4.15.67h-.79a.5.5 0 1 0 0 1h2Zm-7.5.5v2a.5.5 0 0 0 1 0v-.7a3.5 3.5 0 0 0 5.6.53.5.5 0 0 0-.74-.66A2.5 2.5 0 0 1 7.71 11h.79a.5.5 0 0 0 0-1h-2a.5.5 0 0 0-.5.5Z"], { flipInRtl: true }));
export const ArrowSyncCircleRegular = ( /*#__PURE__*/createFluentIcon('ArrowSyncCircleRegular', "1em", ["M10 3a7 7 0 1 1 0 14 7 7 0 0 1 0-14Zm8 7a8 8 0 1 0-16 0 8 8 0 0 0 16 0Zm-8-2.5c1.02 0 1.9.62 2.3 1.5h-.8a.5.5 0 1 0 0 1h2a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v.7a3.5 3.5 0 0 0-5.6-.53.5.5 0 0 0 .74.66A2.5 2.5 0 0 1 10 7.5Zm-3 4.3v.7a.5.5 0 0 1-1 0v-2c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-.8a2.5 2.5 0 0 0 4.16.67.5.5 0 0 1 .75.66A3.5 3.5 0 0 1 7 11.8Z"], { flipInRtl: true }));
export const ArrowSyncDismissFilled = ( /*#__PURE__*/createFluentIcon('ArrowSyncDismissFilled', "1em", ["M11.41 3.64a.5.5 0 0 0 0-.71L9.3.8a.5.5 0 0 0-.7.7l1 1a7.5 7.5 0 0 0-4.08 13.5.5.5 0 0 0 .6-.8 6.5 6.5 0 0 1 5.28-11.55l.02-.02ZM8.6 16.36l.02-.02a6.48 6.48 0 0 0 5.99-1.74 6.5 6.5 0 0 0-.7-9.8.5.5 0 1 1 .6-.8 7.5 7.5 0 0 1-4.07 13.5l.98.98a.5.5 0 1 1-.7.71l-2.12-2.12a.5.5 0 0 1 0-.7ZM15 10a5 5 0 1 1-10 0 5 5 0 0 1 10 0Zm-3.15-1.15a.5.5 0 0 0-.7-.7L10 9.29 8.85 8.15a.5.5 0 0 0-.7.7L9.29 10l-1.14 1.15a.5.5 0 1 0 .7.7L10 10.71l1.15 1.14a.5.5 0 0 0 .7-.7L10.71 10l1.14-1.15Z"], { flipInRtl: true }));
export const ArrowSyncDismissRegular = ( /*#__PURE__*/createFluentIcon('ArrowSyncDismissRegular', "1em", ["M11.41 2.93c.2.2.2.51 0 .7l-.01.02a6.48 6.48 0 0 0-6 1.75 6.5 6.5 0 0 0 .7 9.8.5.5 0 1 1-.6.8A7.5 7.5 0 0 1 9.59 2.5l-1-.99a.5.5 0 0 1 .71-.7l2.12 2.12Zm-2.8 13.42-.02.01a.5.5 0 0 0 0 .71l2.12 2.12a.5.5 0 0 0 .7-.7l-1-1a7.5 7.5 0 0 0 4.07-13.5.5.5 0 1 0-.59.8 6.5 6.5 0 0 1-5.3 11.55Zm3.24-8.2c.2.2.2.5 0 .7L10.71 10l1.14 1.15a.5.5 0 0 1-.7.7L10 10.71l-1.15 1.14a.5.5 0 0 1-.7-.7L9.29 10 8.15 8.85a.5.5 0 1 1 .7-.7L10 9.29l1.15-1.14c.2-.2.5-.2.7 0ZM5 10a5 5 0 1 1 10 0 5 5 0 0 1-10 0Zm5-4a4 4 0 1 0 0 8 4 4 0 0 0 0-8Z"], { flipInRtl: true }));
export const ArrowSyncOffFilled = ( /*#__PURE__*/createFluentIcon('ArrowSyncOffFilled', "1em", ["M9.89 3.75a6.24 6.24 0 0 0-3.12.9L5.68 3.56a7.73 7.73 0 0 1 3.67-1.28l-.59-.59A.75.75 0 0 1 9.82.63l2.12 2.12c.3.3.3.77 0 1.06L9.82 5.93a.75.75 0 0 1-1.06-1.06L9.9 3.75ZM4.18 4.88a7.75 7.75 0 0 0 1.18 11.33.75.75 0 1 0 .9-1.2 6.25 6.25 0 0 1-1.02-9.06l8.81 8.8a6.23 6.23 0 0 1-3.94 1.5l1.13-1.12a.75.75 0 0 0-1.06-1.07L8.06 16.2c-.3.29-.3.76 0 1.06l2.12 2.12a.75.75 0 1 0 1.06-1.06l-.59-.59a7.72 7.72 0 0 0 4.47-1.9l2.03 2.03a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7l2.03 2.03Zm11.17 8.35 1.09 1.09a7.75 7.75 0 0 0-1.8-10.53.75.75 0 0 0-.9 1.2 6.25 6.25 0 0 1 1.6 8.24Z"], { flipInRtl: true }));
export const ArrowSyncOffRegular = ( /*#__PURE__*/createFluentIcon('ArrowSyncOffRegular', "1em", ["M11.41 3.64a.5.5 0 0 0 0-.71L9.3.8a.5.5 0 0 0-.7.7l1 1c-1.3.07-2.6.48-3.73 1.23l.73.73a6.49 6.49 0 0 1 3.55-.98L8.59 5.05a.5.5 0 0 0 .7.7l2.12-2.11ZM4.35 5.06a7.5 7.5 0 0 0 1.16 10.95.5.5 0 0 0 .6-.8 6.5 6.5 0 0 1-1.04-9.44l9.16 9.17a6.48 6.48 0 0 1-4.37 1.56l1.55-1.55a.5.5 0 1 0-.7-.7l-2.12 2.11a.5.5 0 0 0 0 .71l2.12 2.12a.5.5 0 0 0 .7-.7l-1-1a7.47 7.47 0 0 0 4.53-1.85l2.2 2.21a.5.5 0 0 0 .71-.7l-15-15a.5.5 0 1 0-.7.7l2.2 2.21ZM15.3 4.7a7.5 7.5 0 0 1 .96 9.44l-.73-.73A6.5 6.5 0 0 0 13.9 4.8a.5.5 0 1 1 .6-.8c.29.21.56.45.81.7Z"], { flipInRtl: true }));
export const ArrowTrendingFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingFilled', "1em", ["M17.94 5.46a.75.75 0 0 0-.7-.46h-5.49a.75.75 0 0 0 0 1.5h3.69l-4.94 4.94-1.97-1.97a.75.75 0 0 0-1.06 0l-5.25 5.25a.75.75 0 1 0 1.06 1.06L8 11.06l1.97 1.97c.3.3.77.3 1.06 0l5.47-5.47v3.69a.75.75 0 0 0 1.5 0v-5.5c0-.1-.02-.2-.06-.29Z"], { flipInRtl: true }));
export const ArrowTrendingRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingRegular', "1em", ["M17.96 5.3a.5.5 0 0 0-.46-.3h-6a.5.5 0 0 0 0 1h4.8l-5.8 5.8-2.15-2.15a.5.5 0 0 0-.7 0l-5.5 5.5a.5.5 0 0 0 .7.7L8 10.71l2.15 2.14c.2.2.5.2.7 0L17 6.71v4.79a.5.5 0 0 0 1 0v-6a.5.5 0 0 0-.04-.2Z"], { flipInRtl: true }));
export const ArrowTrendingCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingCheckmarkFilled', "1em", ["M16.75 3a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-1.5 0v-2.8l-4.5 4.1a.75.75 0 0 1-1.03-.02L9 8.06l-4.72 4.72a.75.75 0 0 1-1.06-1.06l5.25-5.25a.75.75 0 0 1 1.06 0l1.5 1.5 3.79-3.47h-2.57a.75.75 0 1 1 0-1.5h4.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-1.62-1.83a.5.5 0 0 0-.7-.05l-3.15 2.7-1.18-1.17a.5.5 0 0 0-.7.7l1.5 1.5c.18.19.48.2.68.03l3.5-3a.5.5 0 0 0 .05-.7Z"], { flipInRtl: true }));
export const ArrowTrendingCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingCheckmarkRegular', "1em", ["M16.5 3c.28 0 .5.22.5.5v4a.5.5 0 0 1-1 0V4.7l-4.65 4.65a.5.5 0 0 1-.7 0L9 7.71l-5.15 5.14a.5.5 0 0 1-.7-.7l5.5-5.5a.5.5 0 0 1 .7 0L11 8.29 15.3 4h-2.8a.5.5 0 0 1 0-1h4ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-1.62-1.83a.5.5 0 0 0-.7-.05l-3.15 2.7-1.18-1.17a.5.5 0 0 0-.7.7l1.5 1.5c.18.19.48.2.68.03l3.5-3a.5.5 0 0 0 .05-.7Z"], { flipInRtl: true }));
export const ArrowTrendingDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingDownFilled', "1em", ["M17.94 14.54a.75.75 0 0 1-.7.46h-5.49a.75.75 0 0 1 0-1.5h3.69L10.5 8.56l-1.97 1.97c-.3.3-.77.3-1.06 0L2.22 5.28a.75.75 0 0 1 1.06-1.06L8 8.94l1.97-1.97c.3-.3.77-.3 1.06 0l5.47 5.47V8.75a.75.75 0 0 1 1.5 0v5.5c0 .1-.02.2-.06.29Z"], { flipInRtl: true }));
export const ArrowTrendingDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingDownRegular', "1em", ["M17.96 14.7a.5.5 0 0 1-.46.3h-6a.5.5 0 0 1 0-1h4.8l-5.8-5.8-2.15 2.15a.5.5 0 0 1-.7 0l-5.5-5.5a.5.5 0 1 1 .7-.7L8 9.29l2.15-2.14c.2-.2.5-.2.7 0L17 13.29V8.5a.5.5 0 0 1 1 0v6a.5.5 0 0 1-.04.2Z"], { flipInRtl: true }));
export const ArrowTrendingLinesColor = ( /*#__PURE__*/createFluentIcon('ArrowTrendingLinesColor', "1em", `<path d="M17 10a1 1 0 1 0-2 0v7a1 1 0 1 0 2 0v-7Z" fill="url(#ic_fluent_arrow_trending_lines_20_color__a)"/><path d="M9 12a1 1 0 1 0-2 0v5a1 1 0 1 0 2 0v-5Z" fill="url(#ic_fluent_arrow_trending_lines_20_color__b)"/><path d="M5 15a1 1 0 1 0-2 0v2a1 1 0 1 0 2 0v-2Z" fill="url(#ic_fluent_arrow_trending_lines_20_color__c)"/><path d="M12 13a1 1 0 0 1 1 1v3a1 1 0 1 1-2 0v-3a1 1 0 0 1 1-1Z" fill="url(#ic_fluent_arrow_trending_lines_20_color__d)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14 4a1 1 0 1 1 0-2h3a1 1 0 0 1 1 1v3a1 1 0 1 1-2 0v-.59l-3.8 3.8a1 1 0 0 1-1.4 0L8.5 6.9l-4.3 4.3a1 1 0 0 1-1.4-1.42l5-5a1 1 0 0 1 1.4 0l2.3 2.3L14.59 4H14Z" fill="url(#ic_fluent_arrow_trending_lines_20_color__e)"/><defs><linearGradient id="ic_fluent_arrow_trending_lines_20_color__a" x1="17.91" y1="8.48" x2="2.09" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_arrow_trending_lines_20_color__b" x1="17.91" y1="8.48" x2="2.09" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_arrow_trending_lines_20_color__c" x1="17.91" y1="8.48" x2="2.09" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_arrow_trending_lines_20_color__d" x1="17.91" y1="8.48" x2="2.09" y2="18" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_arrow_trending_lines_20_color__e" x1="3.05" y1="11.5" x2="18" y2="1.22" gradientUnits="userSpaceOnUse"><stop stop-color="#22918B"/><stop offset="1" stop-color="#20AC9D"/></linearGradient></defs>`, { color: true }));
export const ArrowTrendingLinesFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingLinesFilled', "1em", ["M14 2.75c0-.41.34-.75.75-.75h2.5c.41 0 .75.34.75.75v2.5a.75.75 0 0 1-1.5 0v-.69l-4.47 4.47c-.3.3-.77.3-1.06 0L8.5 6.56l-4.22 4.22a.75.75 0 1 1-1.06-1.06l4.75-4.75c.3-.3.77-.3 1.06 0l2.47 2.47 3.94-3.94h-.69a.75.75 0 0 1-.75-.75ZM3.75 14c.41 0 .75.34.75.75v2.5a.75.75 0 0 1-1.5 0v-2.5c0-.41.34-.75.75-.75Zm4.75-2.25a.75.75 0 0 0-1.5 0v5.5a.75.75 0 0 0 1.5 0v-5.5ZM11.75 13c.41 0 .75.34.75.75v3.5a.75.75 0 0 1-1.5 0v-3.5c0-.41.34-.75.75-.75Zm4.75-3.25a.75.75 0 0 0-1.5 0v7.5a.75.75 0 0 0 1.5 0v-7.5Z"], { flipInRtl: true }));
export const ArrowTrendingLinesRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingLinesRegular', "1em", ["M14.5 2a.5.5 0 0 0 0 1h1.8l-4.8 4.8-2.65-2.65a.5.5 0 0 0-.7 0l-5 5a.5.5 0 0 0 .7.7L8.5 6.21l2.65 2.64c.2.2.5.2.7 0L17 3.71V5.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-.5-.5h-3Zm1 7a.5.5 0 0 0-.5.5v8a.5.5 0 0 0 1 0v-8a.5.5 0 0 0-.5-.5Zm-8 2a.5.5 0 0 0-.5.5v6a.5.5 0 0 0 1 0v-6a.5.5 0 0 0-.5-.5Zm3.5 2.5a.5.5 0 0 1 1 0v4a.5.5 0 0 1-1 0v-4Zm-8 1a.5.5 0 0 1 1 0v3a.5.5 0 0 1-1 0v-3Z"], { flipInRtl: true }));
export const ArrowTrendingSettingsFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingSettingsFilled', "1em", ["M16.75 3a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-1.5 0V5.56l-4.22 4.22c-.3.3-.77.3-1.06 0L9 8.06l-4.72 4.72a.75.75 0 0 1-1.06-1.06l5.25-5.25c.3-.3.77-.3 1.06 0l1.72 1.72 3.69-3.69h-2.69a.75.75 0 0 1 0-1.5h4.5Zm-4.68 8.44a2 2 0 0 1-1.44 2.48l-.46.12a4.74 4.74 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"], { flipInRtl: true }));
export const ArrowTrendingSettingsRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingSettingsRegular', "1em", ["M16.5 3c.28 0 .5.22.5.5v4a.5.5 0 0 1-1 0V4.7l-4.65 4.65a.5.5 0 0 1-.7 0L9 7.71l-5.15 5.14a.5.5 0 0 1-.7-.7l5.5-5.5a.5.5 0 0 1 .7 0L11 8.29 15.3 4h-2.8a.5.5 0 0 1 0-1h4Zm-4.43 8.44a2 2 0 0 1-1.44 2.48l-.46.12a4.74 4.74 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"], { flipInRtl: true }));
export const ArrowTrendingSparkleFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingSparkleFilled', "1em", ["m5.88 2.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4L5.9 8.72a.42.42 0 0 1-.8 0l-.35-1.07a2.2 2.2 0 0 0-1.4-1.4L2.28 5.9a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0ZM16.75 6a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-1.5 0V8.56l-4.22 4.22c-.3.3-.77.3-1.06 0L9 11.06l-4.72 4.72a.75.75 0 0 1-1.06-1.06l5.25-5.25c.3-.3.77-.3 1.06 0l1.72 1.72 3.69-3.69h-2.69a.75.75 0 0 1 0-1.5h4.5Zm-.73 8.96.76.25h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .57 0l.25.77a1.58 1.58 0 0 0 1 1Z"], { flipInRtl: true }));
export const ArrowTrendingSparkleRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingSparkleRegular', "1em", ["m5.88 2.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4L5.9 8.72a.42.42 0 0 1-.8 0l-.35-1.07a2.2 2.2 0 0 0-1.4-1.4L2.28 5.9a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0ZM17 6.5a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0 0 1h2.8L11 11.3 9.35 9.64a.5.5 0 0 0-.7 0l-5.5 5.5a.5.5 0 0 0 .7.7L9 10.71l1.65 1.64a.5.5 0 0 0 .7 0L16 7.71v2.79a.5.5 0 0 0 1 0v-4Zm-.98 8.46.76.25h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .57 0l.25.77a1.58 1.58 0 0 0 1 1Z"], { flipInRtl: true }));
export const ArrowTrendingTextFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingTextFilled', "1em", ["M16.75 3a.75.75 0 0 1 .75.75v4.5a.75.75 0 0 1-1.5 0V5.56l-4.22 4.22c-.3.3-.77.3-1.06 0L9 8.06l-4.72 4.72a.75.75 0 0 1-1.06-1.06l5.25-5.25c.3-.3.77-.3 1.06 0l1.72 1.72 3.69-3.69h-2.69a.75.75 0 0 1 0-1.5h4.5ZM10 13c0-1.1.9-2 2-2h5a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-5a2 2 0 0 1-2-2v-4Zm6.5 3h-4a.5.5 0 1 0 0 1h4a.5.5 0 1 0 0-1Zm-4-3a.5.5 0 1 0 0 1h4a.5.5 0 1 0 0-1h-4Z"], { flipInRtl: true }));
export const ArrowTrendingTextRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingTextRegular', "1em", ["M17 3.5a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0 0 1h2.8L11 8.3 9.35 6.64a.5.5 0 0 0-.7 0l-5.5 5.5a.5.5 0 0 0 .7.7L9 7.71l1.65 1.64a.5.5 0 0 0 .7 0L16 4.71V7.5a.5.5 0 0 0 1 0v-4ZM10 13c0-1.1.9-2 2-2h5a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-5a2 2 0 0 1-2-2v-4Zm6.5 3h-4a.5.5 0 1 0 0 1h4a.5.5 0 1 0 0-1Zm-4-3a.5.5 0 1 0 0 1h4a.5.5 0 1 0 0-1h-4Z"], { flipInRtl: true }));
export const ArrowTrendingWrenchFilled = ( /*#__PURE__*/createFluentIcon('ArrowTrendingWrenchFilled', "1em", ["M16.75 3a.75.75 0 0 1 .75.75v4.5c0 .26-.14.5-.34.63a1.38 1.38 0 0 0-1.15-.9H16V5.56l-4.22 4.22c-.3.3-.77.3-1.06 0L9 8.06l-4.72 4.72a.75.75 0 0 1-1.06-1.06l5.25-5.25c.3-.3.77-.3 1.06 0l1.72 1.72 3.69-3.69h-2.69a.75.75 0 0 1 0-1.5h4.5Zm-.65 6.71c.26-.26.16-.7-.2-.74a3.5 3.5 0 0 0-3.71 4.66l-2.72 2.7a1.5 1.5 0 0 0 2.13 2.13l2.7-2.71a3.5 3.5 0 0 0 4.66-3.7c-.04-.37-.48-.48-.74-.22l-.97.97a1.5 1.5 0 1 1-2.12-2.12l.97-.97Z"], { flipInRtl: true }));
export const ArrowTrendingWrenchRegular = ( /*#__PURE__*/createFluentIcon('ArrowTrendingWrenchRegular', "1em", ["M16.5 3c.28 0 .5.22.5.5v4a.5.5 0 0 1-1 0V4.7l-4.65 4.65a.5.5 0 0 1-.7 0L9 7.71l-5.15 5.14a.5.5 0 0 1-.7-.7l5.5-5.5a.5.5 0 0 1 .7 0L11 8.29 15.3 4h-2.8a.5.5 0 0 1 0-1h4Zm-.4 6.71c.26-.26.16-.7-.2-.74a3.5 3.5 0 0 0-3.71 4.66l-2.72 2.7a1.5 1.5 0 0 0 2.13 2.13l2.7-2.71a3.5 3.5 0 0 0 4.66-3.7c-.04-.37-.48-.48-.74-.22l-.97.97a1.5 1.5 0 1 1-2.12-2.12l.97-.97Z"], { flipInRtl: true }));
export const ArrowTurnBidirectionalDownRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnBidirectionalDownRightFilled', "1em", ["M13.78 2.22a.75.75 0 1 0-1.06 1.06L15.44 6H9a3 3 0 0 0-3 3v6.44l-2.72-2.72a.75.75 0 0 0-1.06 1.06l4 4c.3.3.77.3 1.06 0l4-4a.75.75 0 1 0-1.06-1.06L7.5 15.44V9c0-.83.67-1.5 1.5-1.5h6.44l-2.72 2.72a.75.75 0 1 0 1.06 1.06l4-4c.3-.3.3-.77 0-1.06l-4-4Z"]));
export const ArrowTurnBidirectionalDownRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnBidirectionalDownRightRegular', "1em", ["M13.85 2.15a.5.5 0 0 0-.7.7L16.29 6H9a3 3 0 0 0-3 3v7.3l-3.15-3.15a.5.5 0 0 0-.7.7l4 4c.2.2.5.2.7 0l4-4a.5.5 0 0 0-.7-.7L7 16.29V9c0-1.1.9-2 2-2h7.3l-3.15 3.15a.5.5 0 0 0 .7.7l4-4a.5.5 0 0 0 0-.7l-4-4Z"]));
export const ArrowTurnDownLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnDownLeftFilled', "1em", ["M9.28 16.78c-.3.3-.77.3-1.06 0l-4-4a.75.75 0 0 1 0-1.06l4-4a.75.75 0 0 1 1.06 1.06L6.56 11.5H13c.83 0 1.5-.67 1.5-1.5V3.75a.75.75 0 0 1 1.5 0V10a3 3 0 0 1-3 3H6.56l2.72 2.72c.3.3.3.77 0 1.06Z"]));
export const ArrowTurnDownLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnDownLeftRegular', "1em", ["M8.85 16.85a.5.5 0 0 1-.7 0l-4-4a.5.5 0 0 1 0-.7l4-4a.5.5 0 1 1 .7.7L5.71 12H12a2 2 0 0 0 2-2V3.5a.5.5 0 0 1 1 0V10a3 3 0 0 1-3 3H5.7l3.15 3.15c.2.2.2.5 0 .7Z"]));
export const ArrowTurnDownRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnDownRightFilled', "1em", ["M10.72 16.78c.3.3.77.3 1.06 0l4-4c.3-.3.3-.77 0-1.06l-4-4a.75.75 0 1 0-1.06 1.06l2.72 2.72H7A1.5 1.5 0 0 1 5.5 10V3.75a.75.75 0 0 0-1.5 0V10a3 3 0 0 0 3 3h6.44l-2.72 2.72c-.3.3-.3.77 0 1.06Z"]));
export const ArrowTurnDownRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnDownRightRegular', "1em", ["M11.15 16.85c.2.2.5.2.7 0l4-4a.5.5 0 0 0 0-.7l-4-4a.5.5 0 0 0-.7.7L14.29 12H8a2 2 0 0 1-2-2V3.5a.5.5 0 0 0-1 0V10a3 3 0 0 0 3 3h6.3l-3.15 3.15a.5.5 0 0 0 0 .7Z"]));
export const ArrowTurnDownUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnDownUpFilled', "1em", ["M16.45 3.47a.75.75 0 0 0-1.03-.4l-5 2.5a.75.75 0 1 0 .67 1.35l3.24-1.62L10 15.12 5.44 4.45a.75.75 0 0 0-1.38.6l4.8 11.19c.43 1 1.85 1 2.29 0l4.6-10.46 1.3 3.25a.75.75 0 1 0 1.4-.56l-2-5Z"]));
export const ArrowTurnDownUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnDownUpRegular', "1em", ["M15.57 3a.5.5 0 0 1 .4.31l2 5a.5.5 0 1 1-.93.38L15.5 4.85l-4.59 11.52a1 1 0 0 1-1.85.03L4.04 4.7a.5.5 0 0 1 .92-.4L9.98 16l4.57-11.47-3.83 1.92a.5.5 0 1 1-.44-.9l4.98-2.49a.5.5 0 0 1 .3-.06Z"]));
export const ArrowTurnLeftDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnLeftDownFilled', "1em", ["M3.22 10.72c-.3.3-.3.77 0 1.06l4 4c.3.3.77.3 1.06 0l4-4a.75.75 0 1 0-1.06-1.06L8.5 13.44V7c0-.83.67-1.5 1.5-1.5h6.25a.75.75 0 0 0 0-1.5H10a3 3 0 0 0-3 3v6.44l-2.72-2.72a.75.75 0 0 0-1.06 0Z"]));
export const ArrowTurnLeftDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnLeftDownRegular', "1em", ["M3.15 11.15a.5.5 0 0 0 0 .7l4 4c.2.2.5.2.7 0l4-4a.5.5 0 0 0-.7-.7L8 14.29V8c0-1.1.9-2 2-2h6.5a.5.5 0 0 0 0-1H10a3 3 0 0 0-3 3v6.3l-3.15-3.15a.5.5 0 0 0-.7 0Z"]));
export const ArrowTurnLeftRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnLeftRightFilled', "1em", ["M15.53 15.45a.75.75 0 0 0 .4-1.03l-2.5-5a.75.75 0 1 0-1.35.67l1.62 3.24L3.88 9l10.67-4.57a.75.75 0 1 0-.6-1.38L2.77 7.86a1.25 1.25 0 0 0 0 2.29l10.46 4.6-3.25 1.3a.75.75 0 1 0 .56 1.4l5-2Z"]));
export const ArrowTurnLeftRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnLeftRightRegular', "1em", ["M16 14.57a.5.5 0 0 1-.31.4l-5 2a.5.5 0 0 1-.38-.93l3.84-1.54L2.63 9.91a1 1 0 0 1-.03-1.85l11.7-5.02a.5.5 0 0 1 .4.92L3 8.98l11.47 4.57-1.92-3.83a.5.5 0 0 1 .9-.44l2.49 4.98c.05.1.07.2.06.3Z"]));
export const ArrowTurnLeftUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnLeftUpFilled', "1em", ["M3.22 9.28a.75.75 0 0 1 0-1.06l4-4c.3-.3.77-.3 1.06 0l4 4a.75.75 0 0 1-1.06 1.06L8.5 6.56V13c0 .83.67 1.5 1.5 1.5h6.25a.75.75 0 0 1 0 1.5H10a3 3 0 0 1-3-3V6.56L4.28 9.28c-.3.3-.77.3-1.06 0Z"]));
export const ArrowTurnLeftUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnLeftUpRegular', "1em", ["M3.15 8.85a.5.5 0 0 1 0-.7l4-4c.2-.2.5-.2.7 0l4 4a.5.5 0 0 1-.7.7L8 5.71V12c0 1.1.9 2 2 2h6.5a.5.5 0 0 1 0 1H10a3 3 0 0 1-3-3V5.7L3.85 8.86a.5.5 0 0 1-.7 0Z"]));
export const ArrowTurnRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightFilled', "1em", ["M10.72 3.22c.3-.3.77-.3 1.06 0l4 4c.3.3.3.77 0 1.06l-4 4a.75.75 0 1 1-1.06-1.06l2.72-2.72H7c-.83 0-1.5.67-1.5 1.5v6.25a.75.75 0 0 1-1.5 0V10a3 3 0 0 1 3-3h6.44l-2.72-2.72a.75.75 0 0 1 0-1.06Z"]));
export const ArrowTurnRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightRegular', "1em", ["M11.15 3.15c.2-.2.5-.2.7 0l4 4c.2.2.2.5 0 .7l-4 4a.5.5 0 0 1-.7-.7L14.29 8H8a2 2 0 0 0-2 2v6.5a.5.5 0 0 1-1 0V10a3 3 0 0 1 3-3h6.3l-3.15-3.15a.5.5 0 0 1 0-.7Z"]));
export const ArrowTurnRightDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightDownFilled', "1em", ["M16.78 10.72c.3.3.3.77 0 1.06l-4 4c-.3.3-.77.3-1.06 0l-4-4a.75.75 0 1 1 1.06-1.06l2.72 2.72V7c0-.83-.67-1.5-1.5-1.5H3.75a.75.75 0 0 1 0-1.5H10a3 3 0 0 1 3 3v6.44l2.72-2.72c.3-.3.77-.3 1.06 0Z"]));
export const ArrowTurnRightDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightDownRegular', "1em", ["M16.85 11.15c.2.2.2.5 0 .7l-4 4a.5.5 0 0 1-.7 0l-4-4a.5.5 0 0 1 .7-.7L12 14.29V8a2 2 0 0 0-2-2H3.5a.5.5 0 0 1 0-1H10a3 3 0 0 1 3 3v6.3l3.15-3.15c.2-.2.5-.2.7 0Z"]));
export const ArrowTurnRightLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightLeftFilled', "1em", ["M4.47 15.45a.75.75 0 0 1-.4-1.03l2.5-5a.75.75 0 1 1 1.35.67L6.3 13.33 16.12 9 5.45 4.44a.75.75 0 0 1 .6-1.38l11.19 4.8c1 .43 1 1.85 0 2.29l-10.46 4.6 3.25 1.3a.75.75 0 1 1-.56 1.4l-5-2Z"]));
export const ArrowTurnRightLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightLeftRegular', "1em", ["M4 14.57a.5.5 0 0 0 .31.4l5 2a.5.5 0 1 0 .38-.93L5.85 14.5l11.52-4.59a1 1 0 0 0 .03-1.85L5.7 3.04a.5.5 0 0 0-.4.92L17 8.98 5.53 13.55l1.92-3.83a.5.5 0 1 0-.9-.44l-2.49 4.98a.5.5 0 0 0-.06.3Z"]));
export const ArrowTurnRightUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightUpFilled', "1em", ["M16.78 9.28c.3-.3.3-.77 0-1.06l-4-4a.75.75 0 0 0-1.06 0l-4 4a.75.75 0 0 0 1.06 1.06l2.72-2.72V13c0 .83-.67 1.5-1.5 1.5H3.75a.75.75 0 0 0 0 1.5H10a3 3 0 0 0 3-3V6.56l2.72 2.72c.3.3.77.3 1.06 0Z"]));
export const ArrowTurnRightUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnRightUpRegular', "1em", ["M16.85 8.85a.5.5 0 0 0 0-.7l-4-4a.5.5 0 0 0-.7 0l-4 4a.5.5 0 1 0 .7.7L12 5.71V12a2 2 0 0 1-2 2H3.5a.5.5 0 0 0 0 1H10a3 3 0 0 0 3-3V5.7l3.15 3.15c.2.2.5.2.7 0Z"]));
export const ArrowTurnUpDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnUpDownFilled', "1em", ["M16.45 16.53a.75.75 0 0 1-1.03.4l-5-2.5a.75.75 0 1 1 .67-1.35l3.24 1.62L10 4.88 5.44 15.55a.75.75 0 1 1-1.38-.6l4.8-11.19c.43-1 1.85-1 2.29 0l4.6 10.46 1.3-3.25a.75.75 0 0 1 1.4.56l-2 5Z"]));
export const ArrowTurnUpDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnUpDownRegular', "1em", ["M15.57 17a.5.5 0 0 0 .4-.31l2-5a.5.5 0 0 0-.93-.38l-1.54 3.84-4.59-11.52a1 1 0 0 0-1.85-.03L4.04 15.3a.5.5 0 0 0 .92.4L9.98 4l4.57 11.47-3.83-1.92a.5.5 0 0 0-.44.9l4.98 2.49c.1.05.2.07.3.06Z"]));
export const ArrowTurnUpLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowTurnUpLeftFilled', "1em", ["M9.28 3.22a.75.75 0 0 0-1.06 0l-4 4c-.3.3-.3.77 0 1.06l4 4a.75.75 0 0 0 1.06-1.06L6.56 8.5H13c.83 0 1.5.67 1.5 1.5v6.25a.75.75 0 0 0 1.5 0V10a3 3 0 0 0-3-3H6.56l2.72-2.72c.3-.3.3-.77 0-1.06Z"]));
export const ArrowTurnUpLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowTurnUpLeftRegular', "1em", ["M8.85 3.15a.5.5 0 0 0-.7 0l-4 4a.5.5 0 0 0 0 .7l4 4a.5.5 0 0 0 .7-.7L5.71 8H12a2 2 0 0 1 2 2v6.5a.5.5 0 0 0 1 0V10a3 3 0 0 0-3-3H5.7l3.15-3.15a.5.5 0 0 0 0-.7Z"]));
export const ArrowUndoFilled = ( /*#__PURE__*/createFluentIcon('ArrowUndoFilled', "1em", ["M6.86 6.5h2.39a.75.75 0 0 1 0 1.5h-4.4A.85.85 0 0 1 4 7.15v-4.4a.75.75 0 0 1 1.5 0V5.7l3.06-2.66a5.25 5.25 0 0 1 6.89 7.92l-8.17 7.1a.75.75 0 1 1-.99-1.13l8.17-7.1a3.75 3.75 0 1 0-4.92-5.66L6.86 6.5Z"], { flipInRtl: true }));
export const ArrowUndoRegular = ( /*#__PURE__*/createFluentIcon('ArrowUndoRegular', "1em", ["M5 2.5a.5.5 0 0 0-1 0v4.9c0 .33.27.6.6.6h4.9a.5.5 0 0 0 0-1H5.9l3.48-3.02a4 4 0 0 1 5.25 6.04l-8.17 7.1a.5.5 0 0 0 .65.76l8.17-7.1a5 5 0 0 0-6.56-7.55L5 6.46V2.5Z"], { flipInRtl: true }));
export const ArrowUpFilled = ( /*#__PURE__*/createFluentIcon('ArrowUpFilled', "1em", ["M3.2 8.73a.75.75 0 1 0 1.1 1.04l4.95-5.24v12.72a.75.75 0 0 0 1.5 0V4.52l4.95 5.25a.75.75 0 1 0 1.1-1.04l-6.08-6.41a1 1 0 0 0-1.45 0L3.2 8.73Z"], { flipInRtl: true }));
export const ArrowUpRegular = ( /*#__PURE__*/createFluentIcon('ArrowUpRegular', "1em", ["M3.13 9.16a.5.5 0 1 0 .74.68L9.5 3.67V17.5a.5.5 0 1 0 1 0V3.67l5.63 6.17a.5.5 0 0 0 .74-.68l-6.32-6.92a.75.75 0 0 0-1.1 0L3.13 9.16Z"], { flipInRtl: true }));
export const ArrowUpExclamationFilled = ( /*#__PURE__*/createFluentIcon('ArrowUpExclamationFilled', "1em", ["M3 5a3 3 0 0 1 6 0c0 2.25-.79 5.21-1.22 6.69C7.54 12.49 6.8 13 6 13s-1.54-.52-1.78-1.31C3.8 10.2 3 7.23 3 5Zm1 11a2 2 0 1 1 4 0 2 2 0 0 1-4 0ZM15 3.7v13.8a.5.5 0 0 1-1 0V3.7l-2.15 2.15a.5.5 0 0 1-.7-.7l3-3c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7L15 3.71Z"]));
export const ArrowUpExclamationRegular = ( /*#__PURE__*/createFluentIcon('ArrowUpExclamationRegular', "1em", ["M4 5a2 2 0 1 1 4 0c0 2.09-.75 4.93-1.18 6.4-.1.36-.43.6-.82.6a.84.84 0 0 1-.82-.6C4.75 9.91 4 7.07 4 5Zm2-3a3 3 0 0 0-3 3c0 2.23.79 5.2 1.22 6.69C4.46 12.48 5.2 13 6 13s1.54-.52 1.78-1.31C8.2 10.2 9 7.25 9 5a3 3 0 0 0-3-3ZM5 16a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm9-10.3v13.8a.5.5 0 0 1-1 0V3.7l-2.15 2.15a.5.5 0 0 1-.7-.7l3-3c.2-.2.5-.2.7 0l3 3a.5.5 0 0 1-.7.7L15 3.71Z"]));
export const ArrowUpLeftFilled = ( /*#__PURE__*/createFluentIcon('ArrowUpLeftFilled', "1em", ["M12 3.75a.75.75 0 0 0-.75-.75h-7.5a.75.75 0 0 0-.75.75v7.5a.75.75 0 0 0 1.5 0V5.56l11.22 11.22a.75.75 0 0 0 1.06-1.06L5.56 4.5h5.69c.41 0 .75-.34.75-.75Z"]));
export const ArrowUpLeftRegular = ( /*#__PURE__*/createFluentIcon('ArrowUpLeftRegular', "1em", ["M11.5 4a.5.5 0 0 0 0-1h-8a.5.5 0 0 0-.5.5v8a.5.5 0 0 0 1 0V4.7l12.15 12.15a.5.5 0 0 0 .7-.7L4.71 4h6.79Z"]));
export const ArrowUpRightFilled = ( /*#__PURE__*/createFluentIcon('ArrowUpRightFilled', "1em", ["M8 3.75c0-.41.34-.75.75-.75h7.5c.41 0 .75.34.75.75v7.5a.75.75 0 1 1-1.5 0V5.56L4.28 16.78a.75.75 0 0 1-1.06-1.06L14.44 4.5h-5.7A.75.75 0 0 1 8 3.75Z"]));
export const ArrowUpRightRegular = ( /*#__PURE__*/createFluentIcon('ArrowUpRightRegular', "1em", ["M8.5 4a.5.5 0 1 1 0-1h8c.28 0 .5.22.5.5v8a.5.5 0 0 1-1 0V4.7L3.85 16.86a.5.5 0 0 1-.7-.7L15.29 4H8.5Z"]));
export const ArrowUpRightDashesFilled = ( /*#__PURE__*/createFluentIcon('ArrowUpRightDashesFilled', "1em", ["M8.75 3a.75.75 0 0 0 0 1.5h5.69l-1.47 1.47a.75.75 0 0 0 1.06 1.06l1.47-1.47v5.69a.75.75 0 0 0 1.5 0v-7.5a.75.75 0 0 0-.75-.75h-7.5Zm3.03 6.28a.75.75 0 0 0-1.06-1.06l-2.5 2.5a.75.75 0 1 0 1.06 1.06l2.5-2.5Zm-5 5a.75.75 0 1 0-1.06-1.06l-2.75 2.75a.75.75 0 1 0 1.06 1.06l2.75-2.75Z"]));
export const ArrowUpRightDashesRegular = ( /*#__PURE__*/createFluentIcon('ArrowUpRightDashesRegular', "1em", ["M17 3.5a.5.5 0 0 0-.5-.5h-8a.5.5 0 0 0 0 1h6.8l-2.15 2.15a.5.5 0 0 0 .7.7L16 4.71v6.79a.5.5 0 1 0 1 0v-8ZM6.85 13.86a.5.5 0 0 0-.7-.7l-3 3a.5.5 0 0 0 .7.7l3-3Zm5-5.7c.2.2.2.5 0 .7l-3 3a.5.5 0 0 1-.7-.7l3-3c.2-.2.5-.2.7 0Z"]));
export const ArrowUploadFilled = ( /*#__PURE__*/createFluentIcon('ArrowUploadFilled', "1em", ["M4.5 2a.75.75 0 0 0 0 1.5H15A.75.75 0 0 0 15 2H4.5Zm6 15.35a.75.75 0 0 1-1.5-.1V7.05l-2.97 2.98-.08.07a.75.75 0 0 1-.98-1.14l4.29-4.28a.73.73 0 0 1 .26-.15l.08-.02.15-.02h.06l.07.01.12.03.09.04.04.02.09.06.07.06 4.24 4.26.07.08c.22.3.2.71-.07.98l-.08.07c-.3.22-.72.2-.98-.07L10.5 7.05V17.35Z"]));
export const ArrowUploadRegular = ( /*#__PURE__*/createFluentIcon('ArrowUploadRegular', "1em", ["M15 3a.5.5 0 0 0 .09-.99H4a.5.5 0 0 0-.09.98L4 3h11ZM9.5 18a.5.5 0 0 0 .5-.41V5.7l3.64 3.65c.17.18.44.2.64.06l.07-.06a.5.5 0 0 0 .06-.63l-.06-.07-4.5-4.5A.5.5 0 0 0 9.6 4h-.1a.5.5 0 0 0-.4.19L4.64 8.65a.5.5 0 0 0 .64.76l.07-.06L9 5.71V17.5c0 .28.22.5.5.5Z"]));
export const ArrowWrapFilled = ( /*#__PURE__*/createFluentIcon('ArrowWrapFilled', "1em", ["M13.75 3.5a3.25 3.25 0 0 1 0 6.5h-7.5a1.75 1.75 0 1 0 0 3.5h9.19l-.22-.22a.75.75 0 1 1 1.06-1.06l1.5 1.5c.3.3.3.77 0 1.06l-1.5 1.5a.75.75 0 1 1-1.06-1.06l.22-.22H6.25a3.25 3.25 0 0 1 0-6.5h7.5a1.75 1.75 0 1 0 0-3.5h-10a.75.75 0 0 1 0-1.5h10Z"]));
export const ArrowWrapRegular = ( /*#__PURE__*/createFluentIcon('ArrowWrapRegular', "1em", ["M14 4a3 3 0 1 1 0 6H6a2 2 0 1 0 0 4h10.3l-.65-.65a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-1.5 1.5a.5.5 0 0 1-.7-.7l.64-.65H6a3 3 0 1 1 0-6h8a2 2 0 1 0 0-4H3.5a.5.5 0 0 1 0-1H14Z"]));
export const ArrowWrapOffFilled = ( /*#__PURE__*/createFluentIcon('ArrowWrapOffFilled', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7l.98.98A.75.75 0 0 0 3.75 5h.54l3.5 3.5H6.25a3.25 3.25 0 1 0 0 6.5h8.04l.71.7a.75.75 0 0 0 .8.8l1.35 1.35a.5.5 0 0 0 .7-.7l-15-15ZM12.8 13.5H6.25a1.75 1.75 0 1 1 0-3.5h3.04l3.5 3.5Z", "M13.75 8.5h-3.13l1.5 1.5h1.63a3.25 3.25 0 0 0 0-6.5H5.62L7.12 5h6.63a1.75 1.75 0 1 1 0 3.5Z", "m17.34 15.22-2.33-2.33a.75.75 0 0 1 1.27-.67l1.5 1.5c.3.3.3.77 0 1.06l-.44.44Z"]));
export const ArrowWrapOffRegular = ( /*#__PURE__*/createFluentIcon('ArrowWrapOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7l1.17 1.18A.5.5 0 0 0 3.5 5h.8l4 4H6a3 3 0 1 0 0 6h8.3l1.35 1.35 1.5 1.5a.5.5 0 0 0 .7-.7l-15-15ZM13.3 14H6a2 2 0 1 1 0-4h3.3l4 4Z", "M14 9h-2.88l1 1H14a3 3 0 1 0 0-6H6.12l1 1H14a2 2 0 1 1 0 4Z", "M17.41 15.3 16.12 14h.17l-.64-.65a.5.5 0 0 1 .7-.7l1.5 1.5c.2.2.2.5 0 .7l-.44.44Z"]));
export const ArrowWrapUpToDownFilled = ( /*#__PURE__*/createFluentIcon('ArrowWrapUpToDownFilled', "1em", ["M4 13.75a3.25 3.25 0 0 0 6.5 0v-7.5a1.75 1.75 0 1 1 3.5 0v9.19l-.22-.22a.75.75 0 1 0-1.06 1.06l1.5 1.5c.3.3.77.3 1.06 0l1.5-1.5a.75.75 0 1 0-1.06-1.06l-.22.22V6.25a3.25 3.25 0 0 0-6.5 0v7.5a1.75 1.75 0 1 1-3.5 0v-10a.75.75 0 0 0-1.5 0v10Z"]));
export const ArrowWrapUpToDownRegular = ( /*#__PURE__*/createFluentIcon('ArrowWrapUpToDownRegular', "1em", ["M4 14a3 3 0 1 0 6 0V6a2 2 0 1 1 4 0v10.3l-.65-.65a.5.5 0 0 0-.7.7l1.5 1.5c.2.2.5.2.7 0l1.5-1.5a.5.5 0 0 0-.7-.7l-.65.64V6a3 3 0 1 0-6 0v8a2 2 0 1 1-4 0V3.5a.5.5 0 0 0-1 0V14Z"]));
export const ArrowsBidirectionalFilled = ( /*#__PURE__*/createFluentIcon('ArrowsBidirectionalFilled', "1em", ["M6.68 5.03c.2.08.32.26.32.47V8h6V5.5a.5.5 0 0 1 .87-.33l4 4.5a.5.5 0 0 1 0 .66l-4 4.5a.5.5 0 0 1-.87-.33V12H7v2.5a.5.5 0 0 1-.87.33l-4-4.5a.5.5 0 0 1 0-.66l4-4.5a.5.5 0 0 1 .55-.14Z"]));
export const ArrowsBidirectionalRegular = ( /*#__PURE__*/createFluentIcon('ArrowsBidirectionalRegular', "1em", ["M6.68 5.03c.2.08.32.26.32.47V8h6V5.5a.5.5 0 0 1 .87-.33l4 4.5a.5.5 0 0 1 0 .66l-4 4.5a.5.5 0 0 1-.87-.33V12H7v2.5a.5.5 0 0 1-.87.33l-4-4.5a.5.5 0 0 1 0-.66l4-4.5a.5.5 0 0 1 .55-.14ZM3.17 10 6 13.18V11.5c0-.28.22-.5.5-.5h7c.28 0 .5.22.5.5v1.68L16.83 10 14 6.82V8.5a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5V6.82L3.17 10Z"]));
export const AttachFilled = ( /*#__PURE__*/createFluentIcon('AttachFilled', "1em", ["m5.28 10.6 5.3-5.3a2.75 2.75 0 1 1 3.9 3.9L8.1 15.55a1.25 1.25 0 1 1-1.77-1.77L12 8.13a.75.75 0 0 0-1.06-1.06l-5.66 5.66a2.75 2.75 0 0 0 3.89 3.89l6.36-6.36a4.25 4.25 0 0 0-6-6.02l-5.31 5.3a.75.75 0 0 0 1.06 1.07Z"]));
export const AttachRegular = ( /*#__PURE__*/createFluentIcon('AttachRegular', "1em", ["m4.83 10.48 5.65-5.65a3 3 0 0 1 4.25 4.24L8 15.8a1.5 1.5 0 0 1-2.12-2.12l6-6.01a.5.5 0 1 0-.7-.71l-6 6.01a2.5 2.5 0 0 0 3.53 3.54l6.71-6.72a4 4 0 1 0-5.65-5.66L4.12 9.78a.5.5 0 0 0 .7.7Z"]));
export const AttachArrowRightFilled = ( /*#__PURE__*/createFluentIcon('AttachArrowRightFilled', "1em", ["m5.28 10.6 5.3-5.3A2.75 2.75 0 0 1 14.65 9c.56.02 1.1.12 1.6.29a4.25 4.25 0 0 0-6.73-5.05l-5.3 5.3a.75.75 0 0 0 1.06 1.07Zm2.83 4.96.9-.9c.01.63.13 1.22.34 1.78l-.18.18a2.75 2.75 0 0 1-3.89-3.89l5.66-5.66A.75.75 0 1 1 12 8.13L6.34 13.8a1.25 1.25 0 0 0 1.77 1.77ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const AttachArrowRightRegular = ( /*#__PURE__*/createFluentIcon('AttachArrowRightRegular', "1em", ["m4.83 10.48 5.65-5.65A3 3 0 0 1 14.79 9c.4.02.78.08 1.14.18a4 4 0 0 0-6.14-5.07L4.12 9.78a.5.5 0 0 0 .7.7ZM8 15.78l1-.99c.02.42.09.83.2 1.21l-.5.5a2.5 2.5 0 1 1-3.53-3.54l6.01-6.01a.5.5 0 1 1 .7.7l-6 6.02A1.5 1.5 0 0 0 8 15.79ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 1 0-.7.7L15.29 14H12.5a.5.5 0 1 0 0 1h2.8l-1.15 1.15a.5.5 0 1 0 .7.7l2-2Z"]));
export const AttachTextFilled = ( /*#__PURE__*/createFluentIcon('AttachTextFilled', "1em", ["M6.75 3.5c-1.24 0-2.25 1-2.25 2.25v7.5a.75.75 0 0 1-1.5 0v-7.5a3.75 3.75 0 0 1 7.5-.25v10.25a2.25 2.25 0 0 1-4.5 0V5.77a.75.75 0 0 1 1.5 0v9.98a.75.75 0 0 0 1.5 0v-10C9 4.51 8 3.5 6.75 3.5ZM12 8.25c0-.41.34-.75.75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Zm.75-3.75a.75.75 0 0 0 0 1.5h4.5a.75.75 0 0 0 0-1.5h-4.5ZM12 11.25c0-.41.34-.75.75-.75h4.5a.75.75 0 0 1 0 1.5h-4.5a.75.75 0 0 1-.75-.75Zm.75 2.25a.75.75 0 0 0 0 1.5h2a.75.75 0 0 0 0-1.5h-2Z"]));
export const AttachTextRegular = ( /*#__PURE__*/createFluentIcon('AttachTextRegular', "1em", ["M6.5 4A2.5 2.5 0 0 0 4 6.5V14a.5.5 0 0 1-1 0V6.5a3.5 3.5 0 1 1 7 0V15a2 2 0 0 1-4 0V6.5a.5.5 0 0 1 1 0V15a1 1 0 1 0 2 0V6.5A2.5 2.5 0 0 0 6.5 4ZM12 5.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1h-5Zm-.5 3.5c0-.28.22-.5.5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5Zm.5 2.5a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const AutoFitHeightFilled = ( /*#__PURE__*/createFluentIcon('AutoFitHeightFilled', "1em", ["M4.25 2a.75.75 0 0 0 0 1.5h11a.75.75 0 0 0 0-1.5h-11Zm0 14.5a.75.75 0 0 0 0 1.5h11a.75.75 0 0 0 0-1.5h-11Zm6.03-1.72 2-2a.75.75 0 1 0-1.06-1.06l-.72.72V7.56l.72.72a.75.75 0 1 0 1.06-1.06l-2-2a.75.75 0 0 0-1.06 0l-2 2a.75.75 0 0 0 1.06 1.06L9 7.56v4.88l-.72-.72a.75.75 0 0 0-1.06 1.06l2 2c.3.3.77.3 1.06 0Z"]));
export const AutoFitHeightRegular = ( /*#__PURE__*/createFluentIcon('AutoFitHeightRegular', "1em", ["M4 2a.5.5 0 0 0 0 1h11a.5.5 0 0 0 0-1H4Zm0 15a.5.5 0 0 0 0 1h11a.5.5 0 0 0 0-1H4ZM9.15 5.15c.2-.2.5-.2.7 0l2 2a.5.5 0 0 1-.7.7L10 6.71v6.58l1.15-1.14a.5.5 0 0 1 .7.7l-2 2a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .7-.7L9 13.29V6.71L7.85 7.85a.5.5 0 1 1-.7-.7l2-2Z"]));
export const AutoFitWidthFilled = ( /*#__PURE__*/createFluentIcon('AutoFitWidthFilled', "1em", ["M18 4.25a.75.75 0 0 0-1.5 0v11a.75.75 0 0 0 1.5 0v-11Zm-14.5 0a.75.75 0 0 0-1.5 0v11a.75.75 0 0 0 1.5 0v-11Zm1.72 6.03 2 2a.75.75 0 0 0 1.06-1.06l-.72-.72h4.88l-.72.72a.75.75 0 1 0 1.06 1.06l2-2c.3-.3.3-.77 0-1.06l-2-2a.75.75 0 1 0-1.06 1.06l.72.72H7.56l.72-.72a.75.75 0 0 0-1.06-1.06l-2 2c-.3.3-.3.77 0 1.06Z"]));
export const AutoFitWidthRegular = ( /*#__PURE__*/createFluentIcon('AutoFitWidthRegular', "1em", ["M18 4a.5.5 0 0 0-1 0v11a.5.5 0 0 0 1 0V4ZM3 4a.5.5 0 0 0-1 0v11a.5.5 0 0 0 1 0V4Zm11.85 5.15c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7L13.29 10H6.71l1.14 1.15a.5.5 0 0 1-.7.7l-2-2a.5.5 0 0 1 0-.7l2-2a.5.5 0 1 1 .7.7L6.71 9h6.58l-1.14-1.15a.5.5 0 0 1 .7-.7l2 2Z"]));
export const AutocorrectFilled = ( /*#__PURE__*/createFluentIcon('AutocorrectFilled', "1em", ["M2.17 14.75 8.03 4.16a2.25 2.25 0 0 1 3.94 0L14.1 8h3.15a.75.75 0 0 1 0 1.5h-2.26a4.25 4.25 0 1 1-2.89-1.49l.15-.01h.03l-1.84-3.25a.5.5 0 0 0-.87 0L3.47 15.5l-.06.12a.75.75 0 1 1-1.31-.73l.07-.13ZM9 12.25a2.75 2.75 0 1 0 5.5 0 2.75 2.75 0 0 0-5.5 0Z"]));
export const AutocorrectRegular = ( /*#__PURE__*/createFluentIcon('AutocorrectRegular', "1em", ["M9.14 5.48a1 1 0 0 1 1.72 0L12.98 9h-.48a3.75 3.75 0 1 0 2.3 1h2.7a.5.5 0 0 0 0-1h-3.35l-2.44-4.03a2 2 0 0 0-3.42 0L2.07 15.24a.5.5 0 0 0 .86.52L9.14 5.48ZM12.25 10a2.75 2.75 0 1 1 0 5.5 2.75 2.75 0 0 1 0-5.5Z"]));
export const AutosumFilled = ( /*#__PURE__*/createFluentIcon('AutosumFilled', "1em", ["M3.81 3.7a.75.75 0 0 1 .69-.45h11a.75.75 0 0 1 0 1.5H6.26l4.15 4.3c.26.28.28.72.03 1l-4.34 5.2h9.4a.75.75 0 0 1 0 1.5h-11a.75.75 0 0 1-.58-1.23l4.94-5.9-4.9-5.1a.75.75 0 0 1-.15-.81Z"]));
export const AutosumRegular = ( /*#__PURE__*/createFluentIcon('AutosumRegular', "1em", ["M4.04 3.8a.5.5 0 0 1 .46-.3h11a.5.5 0 1 1 0 1H5.67l4.56 4.73a.5.5 0 0 1 .02.67l-4.68 5.6h9.93a.5.5 0 1 1 0 1h-11a.5.5 0 0 1-.38-.82L9.2 9.6 4.14 4.35a.5.5 0 0 1-.1-.55Z"]));
export const BackpackFilled = ( /*#__PURE__*/createFluentIcon('BackpackFilled', "1em", ["M8 8.7c0-.39.31-.7.7-.7h2.6c.39 0 .7.31.7.7a.3.3 0 0 1-.3.3H8.3a.3.3 0 0 1-.3-.3ZM10 2a2.5 2.5 0 0 0-2.5 2.5v.04A6 6 0 0 0 4 10v2h12v-2a6 6 0 0 0-3.5-5.46V4.5A2.5 2.5 0 0 0 10 2Zm0 2c.5 0 1 .06 1.47.18a1.5 1.5 0 0 0-2.94 0C9 4.06 9.5 4 10 4ZM8.7 7h2.6c.94 0 1.7.76 1.7 1.7 0 .72-.58 1.3-1.3 1.3H8.3A1.3 1.3 0 0 1 7 8.7C7 7.76 7.76 7 8.7 7ZM7 14.5V13H4v2a3 3 0 0 0 3 3h6a3 3 0 0 0 3-3v-2H8v1.5a.5.5 0 0 1-1 0Z"]));
export const BackpackRegular = ( /*#__PURE__*/createFluentIcon('BackpackRegular', "1em", ["M8.7 7C7.76 7 7 7.76 7 8.7c0 .72.58 1.3 1.3 1.3h3.4c.72 0 1.3-.58 1.3-1.3 0-.94-.76-1.7-1.7-1.7H8.7ZM8 8.7c0-.39.31-.7.7-.7h2.6c.39 0 .7.31.7.7a.3.3 0 0 1-.3.3H8.3a.3.3 0 0 1-.3-.3ZM10 2a2.5 2.5 0 0 0-2.5 2.5v.04A6 6 0 0 0 4 10v5a3 3 0 0 0 3 3h6a3 3 0 0 0 3-3v-5a6 6 0 0 0-3.5-5.46V4.5A2.5 2.5 0 0 0 10 2Zm5 10H5v-2a5 5 0 0 1 10 0v2Zm-8 2.5a.5.5 0 0 0 1 0V13h7v2a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2v-2h2v1.5ZM10 4c-.5 0-1 .06-1.47.18a1.5 1.5 0 0 1 2.94 0A6.01 6.01 0 0 0 10 4Z"]));
export const BackpackAddFilled = ( /*#__PURE__*/createFluentIcon('BackpackAddFilled', "1em", ["M7.5 4.5a2.5 2.5 0 0 1 5 0v.04a6 6 0 0 1 3.45 4.65 5.5 5.5 0 0 0-3.07.05c.08-.16.12-.35.12-.54 0-.94-.76-1.7-1.7-1.7H8.7C7.76 7 7 7.76 7 8.7c0 .72.58 1.3 1.3 1.3h3.04a5.53 5.53 0 0 0-1.74 2H4v-2a6 6 0 0 1 3.5-5.46V4.5Zm3.97-.32a1.5 1.5 0 0 0-2.94 0 6.01 6.01 0 0 1 2.94 0ZM9 14.5c0-.52.07-1.02.2-1.5H8v1.5a.5.5 0 0 1-1 0V13H4v2a3 3 0 0 0 3 3h3.26A5.48 5.48 0 0 1 9 14.5ZM8.7 8a.7.7 0 0 0-.7.7c0 .17.13.3.3.3h3.4a.3.3 0 0 0 .3-.3.7.7 0 0 0-.7-.7H8.7ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const BackpackAddRegular = ( /*#__PURE__*/createFluentIcon('BackpackAddRegular', "1em", ["M10 2a2.5 2.5 0 0 0-2.5 2.5v.04A6 6 0 0 0 4 10v5a3 3 0 0 0 3 3h3.26a5.5 5.5 0 0 1-.66-1H7a2 2 0 0 1-2-2v-2h2v1.5a.5.5 0 0 0 1 0V13h1.2c.1-.35.24-.68.4-1H5v-2a5 5 0 0 1 9.9-.99c.36.03.71.1 1.05.18a6 6 0 0 0-3.45-4.65V4.5A2.5 2.5 0 0 0 10 2Zm0 2c-.5 0-1 .06-1.47.18a1.5 1.5 0 0 1 2.94 0A6.01 6.01 0 0 0 10 4Zm1.34 6c.46-.33.98-.59 1.54-.76.08-.16.12-.35.12-.54 0-.94-.76-1.7-1.7-1.7H8.7C7.76 7 7 7.76 7 8.7c0 .72.58 1.3 1.3 1.3h3.04ZM8 8.7c0-.39.31-.7.7-.7h2.6c.39 0 .7.31.7.7a.3.3 0 0 1-.3.3H8.3a.3.3 0 0 1-.3-.3Zm11 5.8a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const BackspaceFilled = ( /*#__PURE__*/createFluentIcon('BackspaceFilled', "1em", ["M8.28 4a2.5 2.5 0 0 0-1.7.66L2.8 8.16a2.5 2.5 0 0 0 0 3.68l3.79 3.5a2.5 2.5 0 0 0 1.7.66h7.21a2.5 2.5 0 0 0 2.5-2.5v-7A2.5 2.5 0 0 0 15.5 4H8.28Zm.87 3.15c.2-.2.5-.2.7 0L12 9.29l2.15-2.14a.5.5 0 0 1 .7.7L12.71 10l2.14 2.15a.5.5 0 0 1-.7.7L12 10.71l-2.15 2.14a.5.5 0 0 1-.7-.7L11.29 10 9.15 7.85a.5.5 0 0 1 0-.7Z"]));
export const BackspaceRegular = ( /*#__PURE__*/createFluentIcon('BackspaceRegular', "1em", ["M9.15 7.15c.2-.2.5-.2.7 0L12 9.29l2.15-2.14a.5.5 0 0 1 .7.7L12.71 10l2.14 2.15a.5.5 0 0 1-.7.7L12 10.71l-2.15 2.14a.5.5 0 0 1-.7-.7L11.29 10 9.15 7.85a.5.5 0 0 1 0-.7ZM6.59 4.66A2.5 2.5 0 0 1 8.29 4h7.21A2.5 2.5 0 0 1 18 6.5v7a2.5 2.5 0 0 1-2.5 2.5H8.28a2.5 2.5 0 0 1-1.7-.66l-3.78-3.5a2.5 2.5 0 0 1 0-3.68l3.79-3.5Zm1.7.34c-.38 0-.75.14-1.03.4L3.48 8.9a1.5 1.5 0 0 0 0 2.2l3.78 3.5c.28.26.65.4 1.02.4h7.22c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5H8.28Z"]));
export const BadgeFilled = ( /*#__PURE__*/createFluentIcon('BadgeFilled', "1em", ["M16 6a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm0 1a3 3 0 0 0 1-.17V15a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2h8.17A3 3 0 0 0 16 7Z"]));
export const BadgeRegular = ( /*#__PURE__*/createFluentIcon('BadgeRegular', "1em", ["M16 6a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm1 9V6.83A3 3 0 0 1 16 7v8a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V5a1 1 0 0 1 1-1h8a3 3 0 0 1 .17-1H5a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2Z"]));
export const BalloonFilled = ( /*#__PURE__*/createFluentIcon('BalloonFilled', "1em", ["M5 7a5 5 0 0 1 10 0c0 1.87-.66 3.6-1.6 4.86a5.06 5.06 0 0 1-2.9 2.1V14a1 1 0 0 0 1 1H14a2 2 0 0 1 2 2v.5a.5.5 0 0 1-1 0V17a1 1 0 0 0-1-1h-2.5a2 2 0 0 1-2-2v-.05a5.06 5.06 0 0 1-2.9-2.09C5.66 10.6 5 8.86 5 7Zm5.57-3a.5.5 0 1 0-.14 1c.81.11 1.46.76 1.57 1.57a.5.5 0 0 0 1-.14A2.86 2.86 0 0 0 10.56 4Z"]));
export const BalloonRegular = ( /*#__PURE__*/createFluentIcon('BalloonRegular', "1em", ["M10 4.43a.5.5 0 0 1 .57-.43 2.86 2.86 0 0 1 2.42 2.43.5.5 0 0 1-.99.14A1.86 1.86 0 0 0 10.43 5a.5.5 0 0 1-.43-.57ZM5 7a5 5 0 0 1 10 0c0 1.87-.66 3.6-1.6 4.86a5.06 5.06 0 0 1-2.9 2.1V14a1 1 0 0 0 1 1H14a2 2 0 0 1 2 2v.5a.5.5 0 0 1-1 0V17a1 1 0 0 0-1-1h-2.5a2 2 0 0 1-2-2v-.05a5.06 5.06 0 0 1-2.9-2.09C5.66 10.6 5 8.86 5 7Zm5-4a4 4 0 0 0-4 4c0 1.64.59 3.16 1.4 4.27C8.24 12.4 9.23 13 10 13s1.76-.6 2.6-1.73A7.31 7.31 0 0 0 14 7a4 4 0 0 0-4-4Z"]));
export const BarcodeScannerFilled = ( /*#__PURE__*/createFluentIcon('BarcodeScannerFilled', "1em", ["M2 5.75A2.75 2.75 0 0 1 4.75 3h.75a.75.75 0 0 1 0 1.5h-.75c-.69 0-1.25.56-1.25 1.25v.75a.75.75 0 0 1-1.5 0v-.75Zm11.75-2c0-.41.34-.75.75-.75h.75A2.75 2.75 0 0 1 18 5.75v.75a.75.75 0 0 1-1.5 0v-.75c0-.69-.56-1.25-1.25-1.25h-.75a.75.75 0 0 1-.75-.75Zm-11 9c.41 0 .75.34.75.75v.75c0 .69.56 1.25 1.25 1.25h.75a.75.75 0 0 1 0 1.5h-.75A2.75 2.75 0 0 1 2 14.25v-.75c0-.41.34-.75.75-.75Zm14.5 0c.41 0 .75.34.75.75v.75A2.75 2.75 0 0 1 15.25 17h-.75a.75.75 0 0 1 0-1.5h.75c.69 0 1.25-.56 1.25-1.25v-.75c0-.41.34-.75.75-.75ZM5.5 6c.41 0 .75.34.75.75v6.5a.75.75 0 0 1-1.5 0v-6.5c0-.41.34-.75.75-.75Zm3.75.75a.75.75 0 0 0-1.5 0v6.5a.75.75 0 0 0 1.5 0v-6.5ZM11.5 6c.41 0 .75.34.75.75v6.5a.75.75 0 0 1-1.5 0v-6.5c0-.41.34-.75.75-.75Zm3.75.75a.75.75 0 0 0-1.5 0v6.5a.75.75 0 0 0 1.5 0v-6.5Z"]));
export const BarcodeScannerRegular = ( /*#__PURE__*/createFluentIcon('BarcodeScannerRegular', "1em", ["M2 5.5A2.5 2.5 0 0 1 4.5 3h1a.5.5 0 0 1 0 1h-1C3.67 4 3 4.67 3 5.5v1a.5.5 0 0 1-1 0v-1Zm12-2c0-.28.22-.5.5-.5h1A2.5 2.5 0 0 1 18 5.5v1a.5.5 0 0 1-1 0v-1c0-.83-.67-1.5-1.5-1.5h-1a.5.5 0 0 1-.5-.5ZM2.5 13c.28 0 .5.22.5.5v1c0 .83.67 1.5 1.5 1.5h1a.5.5 0 0 1 0 1h-1A2.5 2.5 0 0 1 2 14.5v-1c0-.28.22-.5.5-.5Zm15 0c.28 0 .5.22.5.5v1a2.5 2.5 0 0 1-2.5 2.5h-1a.5.5 0 0 1 0-1h1c.83 0 1.5-.67 1.5-1.5v-1c0-.28.22-.5.5-.5Zm-12-7c.28 0 .5.22.5.5v7a.5.5 0 0 1-1 0v-7c0-.28.22-.5.5-.5Zm3.5.5a.5.5 0 0 0-1 0v7a.5.5 0 0 0 1 0v-7Zm2.5-.5c.28 0 .5.22.5.5v7a.5.5 0 0 1-1 0v-7c0-.28.22-.5.5-.5Zm3.5.5a.5.5 0 0 0-1 0v7a.5.5 0 0 0 1 0v-7Z"]));
export const BarcodeScannerAddFilled = ( /*#__PURE__*/createFluentIcon('BarcodeScannerAddFilled', "1em", ["M14.5 9a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9ZM2.75 12.75c.41 0 .75.34.75.75v.75c0 .69.56 1.25 1.25 1.25h.75a.75.75 0 0 1 0 1.5h-.75A2.75 2.75 0 0 1 2 14.25v-.75c0-.41.34-.75.75-.75ZM14.5 11a.5.5 0 0 0-.5.5V13h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V14h1.5a.5.5 0 0 0 0-1H15v-1.5a.5.5 0 0 0-.5-.5Zm-9-5c.41 0 .75.34.75.75v6.5a.75.75 0 0 1-1.5 0v-6.5c0-.41.34-.75.75-.75Zm3 0c.41 0 .75.34.75.75v5.1a5.5 5.5 0 0 0-.24 1.95.74.74 0 0 1-1.26-.55v-6.5c0-.41.34-.75.75-.75Zm3 0c.41 0 .75.34.75.75v1.73a5.5 5.5 0 0 0-1.5 1V6.75c0-.41.34-.75.75-.75Zm3 0c.41 0 .75.34.75.75v1.3a5.55 5.55 0 0 0-1.5 0v-1.3c0-.41.34-.75.75-.75Zm-9-3a.75.75 0 0 1 0 1.5h-.75c-.69 0-1.25.56-1.25 1.25v.75a.75.75 0 0 1-1.5 0v-.75A2.75 2.75 0 0 1 4.75 3h.75Zm9.75 0A2.75 2.75 0 0 1 18 5.75v.75a.75.75 0 0 1-1.5 0v-.75c0-.69-.56-1.25-1.25-1.25h-.75a.75.75 0 0 1 0-1.5h.75Z"]));
export const BarcodeScannerAddRegular = ( /*#__PURE__*/createFluentIcon('BarcodeScannerAddRegular', "1em", ["M14.5 9a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm-12 4c.28 0 .5.22.5.5v1c0 .83.67 1.5 1.5 1.5h1a.5.5 0 0 1 0 1h-1A2.5 2.5 0 0 1 2 14.5v-1c0-.28.22-.5.5-.5Zm12-2a.5.5 0 0 0-.5.5V13h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V14h1.5a.5.5 0 0 0 0-1H15v-1.5a.5.5 0 0 0-.5-.5Zm-9-5c.28 0 .5.22.5.5v7a.5.5 0 0 1-1 0v-7c0-.28.22-.5.5-.5Zm3 0c.28 0 .5.22.5.5v7a.5.5 0 0 1-1 0v-7c0-.28.22-.5.5-.5Zm3 0c.28 0 .5.22.5.5v2.1c-.36.18-.7.4-1 .66V6.5c0-.28.22-.5.5-.5Zm3 0c.28 0 .5.22.5.5v1.52a5.56 5.56 0 0 0-1 0V6.5c0-.28.22-.5.5-.5Zm-9-3a.5.5 0 0 1 0 1h-1C3.67 4 3 4.67 3 5.5v1a.5.5 0 0 1-1 0v-1A2.5 2.5 0 0 1 4.5 3h1Zm10 0A2.5 2.5 0 0 1 18 5.5v1a.5.5 0 0 1-1 0v-1c0-.83-.67-1.5-1.5-1.5h-1a.5.5 0 0 1 0-1h1Z"]));
export const BarcodeScannerDismissFilled = ( /*#__PURE__*/createFluentIcon('BarcodeScannerDismissFilled', "1em", ["M14.5 9a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9ZM2.75 12.75c.41 0 .75.34.75.75v.75c0 .69.56 1.25 1.25 1.25h.75a.75.75 0 0 1 0 1.5h-.75A2.75 2.75 0 0 1 2 14.25v-.75c0-.41.34-.75.75-.75Zm13.6-1.1a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM5.5 6c.41 0 .75.34.75.75v6.5a.75.75 0 0 1-1.5 0v-6.5c0-.41.34-.75.75-.75Zm3 0c.41 0 .75.34.75.75v5.1a5.5 5.5 0 0 0-.24 1.95.74.74 0 0 1-1.26-.55v-6.5c0-.41.34-.75.75-.75Zm3 0c.41 0 .75.34.75.75v1.73a5.5 5.5 0 0 0-1.5 1V6.75c0-.41.34-.75.75-.75Zm3 0c.41 0 .75.34.75.75v1.3a5.55 5.55 0 0 0-1.5 0v-1.3c0-.41.34-.75.75-.75Zm-9-3a.75.75 0 0 1 0 1.5h-.75c-.69 0-1.25.56-1.25 1.25v.75a.75.75 0 0 1-1.5 0v-.75A2.75 2.75 0 0 1 4.75 3h.75Zm9.75 0A2.75 2.75 0 0 1 18 5.75v.75a.75.75 0 0 1-1.5 0v-.75c0-.69-.56-1.25-1.25-1.25h-.75a.75.75 0 0 1 0-1.5h.75Z"]));
export const BarcodeScannerDismissRegular = ( /*#__PURE__*/createFluentIcon('BarcodeScannerDismissRegular', "1em", ["M14.5 9a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm-12 4c.28 0 .5.22.5.5v1c0 .83.67 1.5 1.5 1.5h1a.5.5 0 0 1 0 1h-1A2.5 2.5 0 0 1 2 14.5v-1c0-.28.22-.5.5-.5Zm13.85-1.35a.5.5 0 0 0-.7 0l-1.15 1.14-1.15-1.14a.5.5 0 1 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 1 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 1 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0 0-.7ZM5.5 6c.28 0 .5.22.5.5v7a.5.5 0 0 1-1 0v-7c0-.28.22-.5.5-.5Zm3 0c.28 0 .5.22.5.5v7a.5.5 0 0 1-1 0v-7c0-.28.22-.5.5-.5Zm3 0c.28 0 .5.22.5.5v2.1c-.36.18-.7.4-1 .66V6.5c0-.28.22-.5.5-.5Zm3 0c.28 0 .5.22.5.5v1.52a5.56 5.56 0 0 0-1 0V6.5c0-.28.22-.5.5-.5Zm-9-3a.5.5 0 0 1 0 1h-1C3.67 4 3 4.67 3 5.5v1a.5.5 0 0 1-1 0v-1A2.5 2.5 0 0 1 4.5 3h1Zm10 0A2.5 2.5 0 0 1 18 5.5v1a.5.5 0 0 1-1 0v-1c0-.83-.67-1.5-1.5-1.5h-1a.5.5 0 0 1 0-1h1Z"]));
export const Battery0Filled = ( /*#__PURE__*/createFluentIcon('Battery0Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13Z"]));
export const Battery0Regular = ( /*#__PURE__*/createFluentIcon('Battery0Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Z"]));
export const Battery10Filled = ( /*#__PURE__*/createFluentIcon('Battery10Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h13a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery10Regular = ( /*#__PURE__*/createFluentIcon('Battery10Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm13 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h13Z"]));
export const Battery1Filled = ( /*#__PURE__*/createFluentIcon('Battery1Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM2.75 7a.75.75 0 0 0-.75.75v4.5a.75.75 0 0 0 1.5 0v-4.5A.75.75 0 0 0 2.75 7Z"]));
export const Battery1Regular = ( /*#__PURE__*/createFluentIcon('Battery1Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm-.25 1c.41 0 .75.34.75.75v4.5a.75.75 0 0 1-1.5 0v-4.5c0-.41.34-.75.75-.75Z"]));
export const Battery2Filled = ( /*#__PURE__*/createFluentIcon('Battery2Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery2Regular = ( /*#__PURE__*/createFluentIcon('Battery2Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm1 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h1Z"]));
export const Battery3Filled = ( /*#__PURE__*/createFluentIcon('Battery3Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h2.5a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery3Regular = ( /*#__PURE__*/createFluentIcon('Battery3Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm2.5 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h2.5Z"]));
export const Battery4Filled = ( /*#__PURE__*/createFluentIcon('Battery4Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery4Regular = ( /*#__PURE__*/createFluentIcon('Battery4Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm4 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h4Z"]));
export const Battery5Filled = ( /*#__PURE__*/createFluentIcon('Battery5Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5.5a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery5Regular = ( /*#__PURE__*/createFluentIcon('Battery5Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm5.5 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h5.5Z"]));
export const Battery6Filled = ( /*#__PURE__*/createFluentIcon('Battery6Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery6Regular = ( /*#__PURE__*/createFluentIcon('Battery6Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm7 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h7Z"]));
export const Battery7Filled = ( /*#__PURE__*/createFluentIcon('Battery7Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h8.5a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery7Regular = ( /*#__PURE__*/createFluentIcon('Battery7Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm8.5 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h8.5Z"]));
export const Battery8Filled = ( /*#__PURE__*/createFluentIcon('Battery8Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery8Regular = ( /*#__PURE__*/createFluentIcon('Battery8Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm10 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h10Z"]));
export const Battery9Filled = ( /*#__PURE__*/createFluentIcon('Battery9Filled', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h11.5a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Z"]));
export const Battery9Regular = ( /*#__PURE__*/createFluentIcon('Battery9Regular', "1em", ["M16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h13ZM3 6a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3Zm11.5 1a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h11.5Z"]));
export const BatteryCharge0Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge0Filled', "1em", ["M6.23 6.18C5.81 7 6.42 8 7.35 8H8v1.67c0 1.4 1.88 1.85 2.52.6l2.25-4.45c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge0Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge0Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm3.05-3.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge10Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge10Filled', "1em", ["M6.23 6.18c-.13.27-.16.56-.1.82H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h13a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1h-3.83l.6-1.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge10Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge10Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm-.2 1c.12.55.6 1 1.23 1H8v1.67c0 1.4 1.88 1.85 2.52.6L12.17 7H16a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3.13Zm3.25-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge1Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge1Filled', "1em", ["M6.23 6.18C5.81 7 6.42 8 7.35 8H8v1.67c0 1.4 1.88 1.85 2.52.6l2.25-4.45c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18ZM2.75 7a.75.75 0 0 0-.75.75v4.5a.75.75 0 0 0 1.5 0v-4.5A.75.75 0 0 0 2.75 7Zm6.62-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge1Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge1Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1ZM2.75 7c.41 0 .75.34.75.75v4.5a.75.75 0 0 1-1.5 0v-4.5c0-.41.34-.75.75-.75Zm6.62-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryChargeFilled = ( /*#__PURE__*/createFluentIcon('BatteryChargeFilled', "1em", ["M6.23 6.18C5.81 7 6.42 8 7.35 8H8v1.67c0 1.4 1.88 1.85 2.52.6l2.25-4.45c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryChargeRegular = ( /*#__PURE__*/createFluentIcon('BatteryChargeRegular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm3.05-3.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge2Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge2Filled', "1em", ["M6.23 6.18C5.81 7 6.42 8 7.35 8H8v1.67c0 1.4 1.88 1.85 2.52.6l2.25-4.45c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18ZM3 7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1H3Zm6.37-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge2Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge2Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1ZM4 7a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h1Zm5.37-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge3Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge3Filled', "1em", ["M6.23 6.18c-.2.4-.16.83.03 1.17A1 1 0 0 0 5.5 7H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h2.5a1 1 0 0 0 1-1V8a1 1 0 0 0-.11-.46c.22.27.56.46.96.46H8v1.67c0 1.4 1.88 1.85 2.52.6l2.25-4.45c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge3Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge3Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1ZM5.5 7a1 1 0 0 1 .76.35l.13.2A1 1 0 0 1 6.5 8v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h2.5Zm3.87-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge4Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge4Filled', "1em", ["M6.23 6.18c-.13.27-.16.56-.1.82H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1V9.67c0 1.4 1.88 1.85 2.52.6l2.25-4.45c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge4Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge4Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm-.2 1c.12.55.6 1 1.23 1H8v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3.13Zm3.25-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge5Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge5Filled', "1em", ["M6.23 6.18c-.13.27-.16.56-.1.82H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5.5a1 1 0 0 0 1-1v-1.01c.4-.05.8-.28 1.02-.72l2.25-4.45c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge5Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge5Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm-.2 1c.12.55.6 1 1.23 1H8v1.67c0 .9.78 1.4 1.5 1.32V12a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3.13Zm3.25-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge6Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge6Filled', "1em", ["M6.23 6.18c-.13.27-.16.56-.1.82H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1V9.31l1.77-3.49c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge6Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge6Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm-.2 1c.12.55.6 1 1.23 1H8v1.67c0 1.4 1.88 1.85 2.52.6L11 9.3V12a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3.13Zm3.25-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge7Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge7Filled', "1em", ["M6.23 6.18c-.13.27-.16.56-.1.82H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h8.5a1 1 0 0 0 1-1V8a1 1 0 0 0-.42-.82l.69-1.36c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge7Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge7Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm-.2 1c.12.55.6 1 1.23 1H8v1.67c0 1.4 1.88 1.85 2.52.6l1.56-3.09a1 1 0 0 1 .42.82v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3.13Zm3.25-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge8Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge8Filled', "1em", ["M6.23 6.18c-.13.27-.16.56-.1.82H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1h-.83l.6-1.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge8Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge8Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm-.2 1c.12.55.6 1 1.23 1H8v1.67c0 1.4 1.88 1.85 2.52.6L12.17 7H13a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3.13Zm3.25-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge9Filled = ( /*#__PURE__*/createFluentIcon('BatteryCharge9Filled', "1em", ["M6.23 6.18c-.13.27-.16.56-.1.82H3a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h11.5a1 1 0 0 0 1-1V8a1 1 0 0 0-1-1h-2.33l.6-1.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.6 1.18Zm3.14-4c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCharge9Regular = ( /*#__PURE__*/createFluentIcon('BatteryCharge9Regular', "1em", ["M6.32 6H3a2 2 0 0 0-2 2v4c0 1.1.9 2 2 2h13a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-3.33l.1-.18c.13-.27.16-.56.1-.82H16a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H3a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h3.83l-.5 1Zm-.2 1c.12.55.6 1 1.23 1H8v1.67c0 1.4 1.88 1.85 2.52.6L12.17 7h2.33a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1h3.13Zm3.25-4.82c.16-.3.63-.2.63.15V5h1.64c.2 0 .32.2.23.37L9.62 9.82c-.15.3-.62.2-.62-.15V7H7.35a.26.26 0 0 1-.22-.37l2.24-4.45Z"]));
export const BatteryCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('BatteryCheckmarkFilled', "1em", ["M4.5 9a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm2.35 2.65a.5.5 0 0 0-.7 0L3.5 14.29l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7ZM16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H9.8A5.5 5.5 0 0 0 0 10.34V8a3 3 0 0 1 3-3h13Z"]));
export const BatteryCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('BatteryCheckmarkRegular', "1em", ["M4.5 9a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm2.35 2.65a.5.5 0 0 0-.7 0L3.5 14.29l-.65-.64a.5.5 0 1 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7ZM16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H9.8c.08-.32.15-.66.18-1H16a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v1.26c-.38.31-.72.68-1 1.08V8a3 3 0 0 1 3-3h13Z"]));
export const BatterySaverFilled = ( /*#__PURE__*/createFluentIcon('BatterySaverFilled', "1em", ["M4.18 4.27c.23-.36.78-.37.99.02C6.38 6.53 7 8.33 7 9.56c0 1.24-.58 2.28-1.14 2.77a.93.93 0 0 1-.15.1l-.09.05a.35.35 0 0 1-.5-.39l.03-.07c.47-1.19.7-2.36.68-3.5a.59.59 0 0 0-.59-.58.59.59 0 0 0-.57.56v.02c0 .29 0 .58-.04.88l-.05.37-.04.19-.05.26-.08.32-.03.12c-.13.48-.31.96-.53 1.44A5.55 5.55 0 0 1 .8 14.96a.58.58 0 0 1-.77-.32.6.6 0 0 1 .32-.77 4.69 4.69 0 0 0 1.8-1.28C.88 12.2.13 11.3.03 10.03-.1 8.6.43 7.64 1.78 6.56l.65-.5.29-.23a6.9 6.9 0 0 0 1.46-1.56ZM16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H4c-.18 0-.5-.12-.5-.5s.3-.5.5-.5h.04C5.32 14 8 13.01 8 9.72c0-1.02-.45-2.68-.96-3.92a.58.58 0 0 1 .47-.8H16Z"]));
export const BatterySaverRegular = ( /*#__PURE__*/createFluentIcon('BatterySaverRegular', "1em", ["M4.18 4.27c.23-.36.78-.37.99.02C6.38 6.53 7 8.33 7 9.56c0 1.24-.58 2.28-1.14 2.77a.93.93 0 0 1-.15.1l-.09.05a.35.35 0 0 1-.5-.39l.03-.07c.47-1.19.7-2.36.68-3.5a.59.59 0 0 0-.59-.58.59.59 0 0 0-.57.56v.02c0 .29 0 .58-.04.88l-.05.37-.04.19-.05.26-.08.32-.03.12c-.13.48-.31.96-.53 1.44A5.55 5.55 0 0 1 .8 14.96a.58.58 0 0 1-.77-.32.6.6 0 0 1 .32-.77 4.69 4.69 0 0 0 1.8-1.28C.88 12.2.13 11.3.03 10.03-.1 8.6.43 7.64 1.78 6.56l.65-.5.29-.23a6.9 6.9 0 0 0 1.46-1.56ZM16 5a3 3 0 0 1 3 3h1v4h-1a3 3 0 0 1-3 3H4a.5.5 0 0 1 0-1h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H7.5a.5.5 0 0 1 0-1H16Z"]));
export const BatteryWarningFilled = ( /*#__PURE__*/createFluentIcon('BatteryWarningFilled', "1em", ["M3.6 9.55a1 1 0 0 1 1.8 0l3.5 7A1 1 0 0 1 8 18H1a1 1 0 0 1-.9-1.45l3.5-7ZM4.5 16a.5.5 0 1 0 0 1 .5.5 0 0 0 0-1ZM16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v.15A3 3 0 0 1 16 15H9.24L6.29 9.1a2 2 0 0 0-3.58 0L.47 13.6A2.98 2.98 0 0 1 0 12V8a3 3 0 0 1 3-3h13ZM4.5 11a.5.5 0 0 0-.5.5v3a.5.5 0 1 0 1 0v-3a.5.5 0 0 0-.5-.5Z"]));
export const BatteryWarningRegular = ( /*#__PURE__*/createFluentIcon('BatteryWarningRegular', "1em", ["M3.6 9.55a1 1 0 0 1 1.8 0l3.5 7A1 1 0 0 1 8 18H1a1 1 0 0 1-.9-1.45l3.5-7ZM4.5 16a.5.5 0 1 0 0 1 .5.5 0 0 0 0-1ZM16 5a3 3 0 0 1 3 3 1 1 0 0 1 1 1v2a1 1 0 0 1-1 1 3 3 0 0 1-3 3H9.24l-.5-1H16a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v4c0 .15.02.3.05.44L.47 13.6A2.98 2.98 0 0 1 0 12V8a3 3 0 0 1 3-3h13ZM4.5 11a.5.5 0 0 0-.5.5v3a.5.5 0 1 0 1 0v-3a.5.5 0 0 0-.5-.5Z"]));
export const BeachColor = ( /*#__PURE__*/createFluentIcon('BeachColor', "1em", `<path d="m13.12 8.06-.87-.5-2.68 4.73.87.5 2.68-4.73Z" fill="url(#ic_fluent_beach_20_color__a)"/><path d="M4.86 16.42 7 17.5l2.39-.94 2.61.94 2.13-1 1.12.7a5.75 5.75 0 1 0-11.5.26l1.1-1.05v.01Z" fill="url(#ic_fluent_beach_20_color__b)"/><path d="M14.2 14.75c-.32 0-.6.2-.7.51-.57 1.7-2.74 1.68-3.3.09a.75.75 0 0 0-.7-.5c-.33 0-.6.2-.7.5-.55 1.59-2.72 1.63-3.29-.07a.74.74 0 0 0-.73-.5.76.76 0 0 0-.7.55v.01c-.16.64-.44.95-.74 1.13-.32.2-.76.28-1.28.3a.75.75 0 0 0-.74.74c0 .4.34.74.74.74.66 0 1.4-.11 2.05-.5.3-.18.55-.4.77-.68a3.2 3.2 0 0 0 4.63-.04 3.2 3.2 0 0 0 4.7-.07c.7.8 1.72 1.25 2.74 1.25.42 0 .75-.34.75-.74 0-.4-.34-.75-.75-.75-.88 0-1.74-.57-2.03-1.46a.75.75 0 0 0-.72-.51Z" fill="url(#ic_fluent_beach_20_color__c)"/><path d="M16.5 10.37a.5.5 0 0 0 .68-.18l.18-.31c1.42-2.5.6-5.63-1.9-7.05a5.2 5.2 0 0 0-7.1 1.94l-.18.3a.5.5 0 0 0 .19.68l8.13 4.62Z" fill="url(#ic_fluent_beach_20_color__d)"/><path d="M15.66 2.96c-1.16.38-3.41 1.96-4.66 4.3l3.37 1.9c1.36-2.27 1.56-5.01 1.29-6.2Z" fill="url(#ic_fluent_beach_20_color__e)"/><defs><linearGradient id="ic_fluent_beach_20_color__a" x1="10.29" y1="11.47" x2="13.76" y2="7.5" gradientUnits="userSpaceOnUse"><stop stop-color="#CD3E1D"/><stop offset="1" stop-color="#592A00"/></linearGradient><linearGradient id="ic_fluent_beach_20_color__b" x1="9.5" y1="16.65" x2="9.5" y2="11.53" gradientUnits="userSpaceOnUse"><stop stop-color="#FFC7A3"/><stop offset="1" stop-color="#FFA43D"/></linearGradient><linearGradient id="ic_fluent_beach_20_color__c" x1="9.52" y1="17.5" x2="9.52" y2="15" gradientUnits="userSpaceOnUse"><stop offset=".06" stop-color="#0FAFFF"/><stop offset="1" stop-color="#0078D4"/></linearGradient><linearGradient id="ic_fluent_beach_20_color__d" x1="17.02" y1="12" x2="9.6" y2="2.12" gradientUnits="userSpaceOnUse"><stop stop-color="#AA1D2D"/><stop offset="1" stop-color="#FB6F7B"/></linearGradient><linearGradient id="ic_fluent_beach_20_color__e" x1="15.56" y1="6.73" x2="11.38" y2="5.34" gradientUnits="userSpaceOnUse"><stop stop-color="#FECBE6"/><stop offset="1" stop-color="#FDAFD9"/></linearGradient></defs>`, { color: true }));
export const BeachFilled = ( /*#__PURE__*/createFluentIcon('BeachFilled', "1em", ["M15.39 2.7a5.21 5.21 0 0 0-7.13 1.9l-.2.35a.5.5 0 0 0 .19.68l3.83 2.21-2.1 3.68a5.94 5.94 0 0 0-5.32 2.73h.04a1.5 1.5 0 0 1 1.49 1.03c.35 1.05 1.58.98 1.9.07a1.5 1.5 0 0 1 2.83 0c.31.9 1.54.98 1.9-.07a1.5 1.5 0 0 1 1.51-1.03 6.32 6.32 0 0 0-3.31-2.52l1.93-3.39 3.47 2a.5.5 0 0 0 .68-.18l.2-.34a5.21 5.21 0 0 0-1.91-7.12ZM5.24 15.6a.5.5 0 0 0-.96.03c-.17.7-.5 1.08-.86 1.3-.38.23-.87.32-1.42.32a.5.5 0 0 0 0 1c.64 0 1.33-.1 1.94-.47.34-.2.64-.5.88-.87a2.96 2.96 0 0 0 4.68-.01 2.96 2.96 0 0 0 4.74-.06c.64.9 1.7 1.41 2.76 1.41a.5.5 0 1 0 0-1c-.98 0-1.96-.64-2.29-1.65a.5.5 0 0 0-.95 0 1.98 1.98 0 0 1-3.79.07.5.5 0 0 0-.94 0 1.98 1.98 0 0 1-3.8-.08Z"]));
export const BeachRegular = ( /*#__PURE__*/createFluentIcon('BeachRegular', "1em", ["M8.26 4.6a5.21 5.21 0 0 1 9.03 5.22l-.2.34a.5.5 0 0 1-.67.19l-3.47-2-1.93 3.38c1.34.4 2.5 1.33 3.31 2.52h-.09c-.34 0-.66.11-.92.31A4.9 4.9 0 0 0 9.5 12.5a4.9 4.9 0 0 0-3.82 2.06 1.5 1.5 0 0 0-1.01-.3 5.94 5.94 0 0 1 5.31-2.74l2.1-3.68-3.83-2.2a.5.5 0 0 1-.18-.7l.2-.33Zm.92.42 1.7.98.02-.02a8.08 8.08 0 0 1 3.27-2.74 4.22 4.22 0 0 0-4.99 1.78ZM14 7.8c.47-.82.7-1.46.77-2.09a5.8 5.8 0 0 0-.06-1.62 6.96 6.96 0 0 0-2.95 2.41L14 7.8Zm.87.5 1.61.93a4.22 4.22 0 0 0-.74-5.02c.07.56.09 1.1.02 1.63-.1.79-.38 1.56-.89 2.46Zm-9.63 7.3a.5.5 0 0 0-.96.03c-.17.7-.5 1.08-.86 1.3-.38.23-.87.32-1.42.32a.5.5 0 0 0 0 1c.64 0 1.33-.1 1.94-.47.34-.2.64-.5.88-.87a2.96 2.96 0 0 0 4.68-.01 2.96 2.96 0 0 0 4.74-.06c.64.9 1.7 1.41 2.76 1.41a.5.5 0 1 0 0-1c-.98 0-1.96-.64-2.29-1.65a.5.5 0 0 0-.95 0 1.98 1.98 0 0 1-3.79.07.5.5 0 0 0-.94 0 1.98 1.98 0 0 1-3.8-.08Z"]));
export const BeakerFilled = ( /*#__PURE__*/createFluentIcon('BeakerFilled', "1em", ["M5.5 3.5c0-.28.22-.5.5-.5h8a.5.5 0 0 1 0 1h-1v4.68c0 .58.15 1.15.42 1.66l.9 1.66H5.68l.9-1.65a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1-.5-.5ZM5.15 13l-.97 1.79A1.5 1.5 0 0 0 5.5 17h9a1.5 1.5 0 0 0 1.32-2.21L14.85 13h-9.7Z"]));
export const BeakerRegular = ( /*#__PURE__*/createFluentIcon('BeakerRegular', "1em", ["M14 3a.5.5 0 0 1 0 1h-1v4.68c0 .58.15 1.15.42 1.66l2.4 4.45A1.5 1.5 0 0 1 14.5 17h-9a1.5 1.5 0 0 1-1.32-2.21l2.4-4.44a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1 0-1h8ZM8 4v4.69a4.5 4.5 0 0 1-.54 2.13L6.82 12h6.36l-.64-1.18A4.5 4.5 0 0 1 12 8.68V4H8Zm5.72 9H6.28l-1.22 2.26a.5.5 0 0 0 .44.74h9a.5.5 0 0 0 .44-.74L13.72 13Z"]));
export const BeakerAddFilled = ( /*#__PURE__*/createFluentIcon('BeakerAddFilled', "1em", ["M5.5 3.5c0-.28.22-.5.5-.5h8a.5.5 0 0 1 0 1h-1v4.68c0 .18.02.35.04.52A5.51 5.51 0 0 0 9.6 12H5.68l.9-1.65a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1-.5-.5Zm3.5 11c0-.52.07-1.02.2-1.5H5.16l-.97 1.79A1.5 1.5 0 0 0 5.5 17h4.1c-.38-.75-.6-1.6-.6-2.5Zm10 0a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const BeakerAddRegular = ( /*#__PURE__*/createFluentIcon('BeakerAddRegular', "1em", ["M14 3a.5.5 0 0 1 0 1h-1v4.68c0 .18.02.35.04.52-.33.09-.65.2-.95.35a4.5 4.5 0 0 1-.09-.87V4H8v4.69a4.5 4.5 0 0 1-.54 2.13L6.82 12H9.6c-.16.32-.3.65-.4 1H6.29l-1.22 2.26a.5.5 0 0 0 .44.74h3.7c.1.35.24.68.4 1H5.5a1.5 1.5 0 0 1-1.32-2.21l2.4-4.44a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1 0-1h8Zm5 11.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const BeakerDismissFilled = ( /*#__PURE__*/createFluentIcon('BeakerDismissFilled', "1em", ["M5.5 3.5c0-.28.22-.5.5-.5h8a.5.5 0 0 1 0 1h-1v4.68c0 .18.02.35.04.52A5.51 5.51 0 0 0 9.6 12H5.68l.9-1.65a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1-.5-.5Zm3.5 11c0-.52.07-1.02.2-1.5H5.16l-.97 1.79A1.5 1.5 0 0 0 5.5 17h4.1c-.38-.75-.6-1.6-.6-2.5Zm10 0a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.8 0 1.15-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15Z"]));
export const BeakerDismissRegular = ( /*#__PURE__*/createFluentIcon('BeakerDismissRegular', "1em", ["M14 3a.5.5 0 0 1 0 1h-1v4.68c0 .18.02.35.04.52-.33.09-.65.2-.95.35a4.5 4.5 0 0 1-.09-.87V4H8v4.69a4.5 4.5 0 0 1-.54 2.13L6.82 12H9.6c-.16.32-.3.65-.4 1H6.29l-1.22 2.26a.5.5 0 0 0 .44.74h3.7c.1.35.24.68.4 1H5.5a1.5 1.5 0 0 1-1.32-2.21l2.4-4.44a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1 0-1h8Zm5 11.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-3.8 0 1.15-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15Z"]));
export const BeakerEditFilled = ( /*#__PURE__*/createFluentIcon('BeakerEditFilled', "1em", ["M5.5 3.5c0-.28.22-.5.5-.5h8a.5.5 0 0 1 0 1h-1v4.68c0 .58.15 1.15.42 1.66l.41.77-.89.89H5.68l.9-1.65a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1-.5-.5Zm4.77 11.17L11.94 13h-6.8l-.96 1.79A1.5 1.5 0 0 0 5.5 17h3.72l.21-.84a3.2 3.2 0 0 1 .84-1.49Zm.71.7 4.83-4.82a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const BeakerEditRegular = ( /*#__PURE__*/createFluentIcon('BeakerEditRegular', "1em", ["M14 3a.5.5 0 0 1 0 1h-1v4.68c0 .58.15 1.15.42 1.66l.41.77-.73.74-.56-1.03A4.5 4.5 0 0 1 12 8.68V4H8v4.69a4.5 4.5 0 0 1-.54 2.13L6.82 12h6.12l-1 1H6.28l-1.22 2.26a.5.5 0 0 0 .44.74h3.97l-.04.16-.21.84H5.5a1.5 1.5 0 0 1-1.32-2.21l2.4-4.44a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1 0-1h8Zm-3.02 12.38 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const BeakerOffFilled = ( /*#__PURE__*/createFluentIcon('BeakerOffFilled', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L6.99 7.7v.99a3.5 3.5 0 0 1-.41 1.66L5.68 12h5.61l1 1H5.15l-.97 1.79A1.5 1.5 0 0 0 5.5 17h9c.5 0 .93-.24 1.2-.6l1.45 1.45a.5.5 0 0 0 .7-.7l-15-15ZM7 4.87 14.12 12h.2l-.9-1.66A3.5 3.5 0 0 1 13 8.68V4h1a.5.5 0 0 0 0-1H6a.5.5 0 0 0-.49.4l.61.6H7v.87Z"]));
export const BeakerOffRegular = ( /*#__PURE__*/createFluentIcon('BeakerOffRegular', "1em", ["M2.85 2.15a.5.5 0 1 0-.7.7L6.99 7.7v.99a3.5 3.5 0 0 1-.41 1.66l-2.4 4.44A1.5 1.5 0 0 0 5.5 17h9c.5 0 .93-.24 1.2-.6l1.45 1.45a.5.5 0 0 0 .7-.7l-15-15Zm12.12 13.52a.5.5 0 0 1-.47.33h-9a.5.5 0 0 1-.44-.74L6.28 13h6.01l2.68 2.67ZM11.29 12H6.82l.64-1.18a4.5 4.5 0 0 0 .53-2.12l3.3 3.3ZM12 8.68c0 .5.08.98.24 1.44l2.3 2.3-1.12-2.08A3.5 3.5 0 0 1 13 8.68V4h1a.5.5 0 0 0 0-1H6a.5.5 0 0 0-.49.4l.61.6H7v.87l1 1V4H12v4.68Z"]));
export const BeakerSettingsFilled = ( /*#__PURE__*/createFluentIcon('BeakerSettingsFilled', "1em", ["M5.5 3.5c0-.28.22-.5.5-.5h8a.5.5 0 0 1 0 1h-1v4.68c0 .18.02.35.04.52A5.51 5.51 0 0 0 9.6 12H5.68l.9-1.65a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1-.5-.5Zm3.5 11c0-.52.07-1.02.2-1.5H5.16l-.97 1.79A1.5 1.5 0 0 0 5.5 17h4.1c-.38-.75-.6-1.6-.6-2.5Zm3.07-3.06a2 2 0 0 1-1.44 2.48l-.46.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const BeakerSettingsRegular = ( /*#__PURE__*/createFluentIcon('BeakerSettingsRegular', "1em", ["M14 3a.5.5 0 0 1 0 1h-1v4.68c0 .18.02.35.04.52-.33.09-.65.2-.95.35a4.5 4.5 0 0 1-.09-.87V4H8v4.69a4.5 4.5 0 0 1-.54 2.13L6.82 12H9.6c-.16.32-.3.65-.4 1H6.29l-1.22 2.26a.5.5 0 0 0 .44.74h3.7c.1.35.24.68.4 1H5.5a1.5 1.5 0 0 1-1.32-2.21l2.4-4.44a3.5 3.5 0 0 0 .41-1.66V4H6a.5.5 0 0 1 0-1h8Zm-1.93 8.44a2 2 0 0 1-1.44 2.48l-.46.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.7 4.7 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const BedFilled = ( /*#__PURE__*/createFluentIcon('BedFilled', "1em", ["M15.5 9a2.5 2.5 0 0 1 2.5 2.34v5.16a.5.5 0 0 1-1 .09V14H3v2.5a.5.5 0 0 1-1 .09V11.5A2.5 2.5 0 0 1 4.34 9H15.5Zm-9-6h7A2.5 2.5 0 0 1 16 5.34V8h-2v-.5a.5.5 0 0 0-.41-.5H11a.5.5 0 0 0-.5.41V8h-1v-.5a.5.5 0 0 0-.41-.5H6.5a.5.5 0 0 0-.5.41V8H4V5.5A2.5 2.5 0 0 1 6.34 3h.16Z"]));
export const BedRegular = ( /*#__PURE__*/createFluentIcon('BedRegular', "1em", ["M13.5 3A2.5 2.5 0 0 1 16 5.34v2.71a2.5 2.5 0 0 1 2 2.28v6.17a.5.5 0 0 1-1 .09V14H3v2.5a.5.5 0 0 1-1 .09V10.5a2.5 2.5 0 0 1 2-2.45V5.5A2.5 2.5 0 0 1 6.34 3h7.16Zm2 6h-11c-.78 0-1.42.6-1.5 1.36V13h14v-2.5c0-.78-.6-1.42-1.36-1.5h-.14Zm-2-5h-7c-.78 0-1.42.6-1.5 1.36V8h1v-.5c0-.28.22-.5.5-.5H9c.28 0 .5.22.5.5V8h1v-.5c0-.28.22-.5.5-.5h2.5c.28 0 .5.22.5.5V8h1V5.5c0-.78-.6-1.42-1.36-1.5h-.14Z"]));
export const BenchFilled = ( /*#__PURE__*/createFluentIcon('BenchFilled', "1em", ["M5 4a2 2 0 0 0-2 2v4h14V6a2 2 0 0 0-2-2H5Zm-2.5 7a1.5 1.5 0 0 0 0 3H3v1.5a.5.5 0 0 0 1 0V14h12v1.5a.5.5 0 0 0 1 0V14h.5a1.5 1.5 0 0 0 0-3h-15Z"]));
export const BenchRegular = ( /*#__PURE__*/createFluentIcon('BenchRegular', "1em", ["M3 6c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v4a2 2 0 1 1 0 4v1.5a.5.5 0 0 1-1 0V14H4v1.5a.5.5 0 0 1-1 0V14a2 2 0 1 1 0-4V6Zm14 7a1 1 0 1 0 0-2H3a1 1 0 1 0 0 2h14Zm-1-7a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v4h12V6Z"]));
export const BezierCurveSquareFilled = ( /*#__PURE__*/createFluentIcon('BezierCurveSquareFilled', "1em", ["M5 3a2 2 0 0 0-2 2v8c1.4 0 2.26-.4 2.86-.96.62-.57.99-1.35 1.3-2.2l.28-.87.13-.41c.14-.41.29-.83.47-1.19s.41-.7.74-.96C9.1 6.14 9.52 6 10 6s.89.14 1.22.4c.33.26.56.6.74.97.18.36.33.78.47 1.19l.13.4c.09.3.18.58.29.87.3.86.67 1.64 1.29 2.21.6.56 1.47.96 2.86.96V5a2 2 0 0 0-2-2H5Zm12 11c-1.6 0-2.74-.47-3.54-1.23a6.39 6.39 0 0 1-1.56-2.6l-.3-.92-.12-.38a8 8 0 0 0-.41-1.05c-.15-.3-.3-.5-.46-.63A.93.93 0 0 0 10 7a.93.93 0 0 0-.6.2c-.17.12-.32.32-.47.62-.14.3-.27.64-.4 1.05l-.13.38-.3.92c-.32.9-.76 1.86-1.56 2.6A4.95 4.95 0 0 1 3 14v1c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2v-1Z"]));
export const BezierCurveSquareRegular = ( /*#__PURE__*/createFluentIcon('BezierCurveSquareRegular', "1em", ["M5 3a2 2 0 0 0-2 2v10c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2H5Zm11 9.92a3.5 3.5 0 0 1-1.86-.88 5.42 5.42 0 0 1-1.3-2.2l-.28-.87-.13-.41a8.91 8.91 0 0 0-.47-1.19c-.18-.36-.41-.7-.74-.96C10.9 6.14 10.48 6 10 6s-.89.14-1.22.4c-.33.26-.56.6-.74.97-.18.36-.33.78-.47 1.19l-.13.4c-.09.3-.18.58-.29.87-.3.86-.67 1.64-1.29 2.21a3.5 3.5 0 0 1-1.86.88V5a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1v7.92ZM4 13.93a4.55 4.55 0 0 0 2.54-1.16c.8-.74 1.24-1.7 1.56-2.6l.3-.92.12-.38c.14-.4.27-.76.41-1.05.15-.3.3-.5.46-.63.16-.12.34-.19.61-.19.27 0 .45.07.6.2.17.12.32.32.47.62a8 8 0 0 1 .4 1.05l.13.38.3.92c.32.9.76 1.86 1.56 2.6.63.59 1.45 1 2.54 1.16V15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-1.07Z"]));
export const BinFullFilled = ( /*#__PURE__*/createFluentIcon('BinFullFilled', "1em", ["M14.75 2.93a.5.5 0 1 0-.5-.86l-12 7A.5.5 0 0 0 2 9.5v6A2.5 2.5 0 0 0 4.5 18h11a2.5 2.5 0 0 0 2.5-2.5v-6a.5.5 0 0 0-.5-.5H17V6.5c0-.83-.67-1.5-1.5-1.5h-2c-.83 0-1.5.67-1.5 1.5V7H9.5C8.67 7 8 7.67 8 8.5V9H4.35l10.4-6.07ZM12 8v1H9v-.5c0-.28.22-.5.5-.5H12Zm1 1V6.5c0-.28.22-.5.5-.5h2c.28 0 .5.22.5.5V9h-3Z"]));
export const BinFullRegular = ( /*#__PURE__*/createFluentIcon('BinFullRegular', "1em", ["M14.93 2.25a.5.5 0 0 1-.18.68L4.35 9H8v-.5C8 7.67 8.67 7 9.5 7H12v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5V9h.5c.28 0 .5.22.5.5v6a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 15.5v-6c0-.18.1-.34.25-.43l12-7a.5.5 0 0 1 .68.18ZM16.5 10H3v5.5c0 .83.67 1.5 1.5 1.5h11c.83 0 1.5-.67 1.5-1.5V10h-.5ZM12 9V8H9.5a.5.5 0 0 0-.5.5V9h3Zm1 0h3V6.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5V9Z"]));
export const BinRecycleFilled = ( /*#__PURE__*/createFluentIcon('BinRecycleFilled', "1em", ["M5.5 3h9a1 1 0 0 1 1 1h-11a1 1 0 0 1 1-1Zm-2 1v.5a.5.5 0 0 0 0 .06l1.35 11.67A2 2 0 0 0 6.84 18h6.32a2 2 0 0 0 1.99-1.77L16.5 4.56a.5.5 0 0 0 0-.04V4a2 2 0 0 0-2-2h-9a2 2 0 0 0-2 2Zm7.8 3.75.45.78a.5.5 0 1 1-.87.5l-.45-.78a.5.5 0 0 0-.86 0l-.45.78a.5.5 0 1 1-.87-.5l.45-.78c.58-1 2.02-1 2.6 0Zm.86 3.5-.1-.19a.5.5 0 0 1 .86-.5l.11.19a1.5 1.5 0 0 1-1.3 2.25H11a.5.5 0 0 1 0-1h.73a.5.5 0 0 0 .43-.75ZM9 12a.5.5 0 0 1 0 1h-.73a1.5 1.5 0 0 1-1.3-2.25l.1-.19a.5.5 0 0 1 .87.5l-.1.19a.5.5 0 0 0 .43.75H9Z"]));
export const BinRecycleRegular = ( /*#__PURE__*/createFluentIcon('BinRecycleRegular', "1em", ["M11.3 7.75c-.58-1-2.02-1-2.6 0l-.45.78a.5.5 0 1 0 .87.5l.45-.78a.5.5 0 0 1 .86 0l.45.78a.5.5 0 0 0 .87-.5l-.45-.78Zm.86 3.5-.1-.19a.5.5 0 0 1 .86-.5l.11.19a1.5 1.5 0 0 1-1.3 2.25H11a.5.5 0 0 1 0-1h.73a.5.5 0 0 0 .43-.75ZM9 12a.5.5 0 0 1 0 1h-.73a1.5 1.5 0 0 1-1.3-2.25l.1-.19a.5.5 0 0 1 .87.5l-.1.19a.5.5 0 0 0 .43.75H9Zm6.91-9.41A2 2 0 0 1 16.5 4v.56l-1.33 11.67a2 2 0 0 1-2 1.77H6.85a2 2 0 0 1-2-1.77L3.5 4.56V4a2 2 0 0 1 2-2h9a2 2 0 0 1 1.41.59ZM14.5 3h-9a1 1 0 0 0-1 1h11a1 1 0 0 0-1-1Zm-.67 13.75a1 1 0 0 0 .33-.64L15.44 5H4.56l1.28 11.11a1 1 0 0 0 1 .89h6.32a1 1 0 0 0 .67-.25Z"]));
export const BinRecycleFullFilled = ( /*#__PURE__*/createFluentIcon('BinRecycleFullFilled', "1em", ["M6 2.2V4h2.3L6.34 2.06a.2.2 0 0 0-.35.15ZM5 4V2.2a1.2 1.2 0 0 1 2.06-.85L9 3.3V2.5c0-.83.67-1.5 1.5-1.5h3c.83 0 1.5.67 1.5 1.5V4h1a.5.5 0 0 1 .5.56l-1.35 11.67A2 2 0 0 1 13.16 18H6.84a2 2 0 0 1-1.99-1.77L3.5 4.56A.5.5 0 0 1 4 4h1Zm9 0V2.5a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5V4h4Zm-2.7 3.75c-.58-1-2.02-1-2.6 0l-.45.78a.5.5 0 1 0 .87.5l.45-.78a.5.5 0 0 1 .86 0l.45.78a.5.5 0 0 0 .87-.5l-.45-.78Zm.86 3.5a.5.5 0 0 1-.43.75H11a.5.5 0 0 0 0 1h.73a1.5 1.5 0 0 0 1.3-2.25l-.1-.19a.5.5 0 0 0-.87.5l.1.19ZM9 12h-.73a.5.5 0 0 1-.44-.75l.11-.19a.5.5 0 0 0-.86-.5l-.11.19A1.5 1.5 0 0 0 8.27 13H9a.5.5 0 0 0 0-1Z"]));
export const BinRecycleFullRegular = ( /*#__PURE__*/createFluentIcon('BinRecycleFullRegular', "1em", ["M6.2 2c.06 0 .11.02.15.06L8.3 4H6V2.2c0-.1.1-.2.2-.2ZM5 2.2V4H4a.5.5 0 0 0-.5.56l1.35 11.67A2 2 0 0 0 6.84 18h6.32a2 2 0 0 0 1.99-1.77L16.5 4.56A.5.5 0 0 0 16 4h-1V2.5c0-.83-.67-1.5-1.5-1.5h-3C9.67 1 9 1.67 9 2.5v.8L7.06 1.34A1.2 1.2 0 0 0 5 2.21ZM10 4V2.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5V4h-4ZM4.56 5h10.88l-1.28 11.11a1 1 0 0 1-1 .89H6.84a1 1 0 0 1-1-.89L4.56 5Zm6.74 2.75c-.58-1-2.02-1-2.6 0l-.45.78a.5.5 0 0 0 .87.5l.45-.78a.5.5 0 0 1 .86 0l.45.78a.5.5 0 0 0 .87-.5l-.45-.78Zm.86 3.5-.1-.19a.5.5 0 0 1 .86-.5l.11.19a1.5 1.5 0 0 1-1.3 2.25H11a.5.5 0 0 1 0-1h.73a.5.5 0 0 0 .43-.75ZM9 12a.5.5 0 0 1 0 1h-.73a1.5 1.5 0 0 1-1.3-2.25l.1-.19a.5.5 0 0 1 .87.5l-.1.19a.5.5 0 0 0 .43.75H9Z"]));
export const BinderTriangleFilled = ( /*#__PURE__*/createFluentIcon('BinderTriangleFilled', "1em", ["M5 2a2 2 0 0 0-2 2h-.5a.5.5 0 0 0 0 1H3v3h-.5a.5.5 0 0 0 0 1H3v3h-.5a.5.5 0 0 0 0 1H3c0 1.1.9 2 2 2h1.35L14 5.9V4a2 2 0 0 0-2-2H5Zm1.5 4h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1 0-1Zm10.17-1.73a.75.75 0 0 1 1.33.48V16a2 2 0 0 1-2 2H6.75a.75.75 0 0 1-.57-1.23l10.5-12.5ZM15 14.25v-2.64c0-.23-.29-.34-.44-.16l-2.64 3.14a.25.25 0 0 0 .2.41h2.13c.41 0 .75-.33.75-.75Z"]));
export const BinderTriangleRegular = ( /*#__PURE__*/createFluentIcon('BinderTriangleRegular', "1em", ["M3 4c0-1.1.9-2 2-2h7a2 2 0 0 1 2 2v1.9l-1 1.19V4a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1h.5a.5.5 0 0 1 0 1H4v3h.5a.5.5 0 0 1 0 1H4v3h.5a.5.5 0 0 1 0 1H4a1 1 0 0 0 1 1h2.2l-.85 1H5a2 2 0 0 1-2-2h-.5a.5.5 0 0 1 0-1H3V9h-.5a.5.5 0 0 1 0-1H3V5h-.5a.5.5 0 0 1 0-1H3Zm12 7.61c0-.23-.29-.34-.44-.16l-2.64 3.14a.25.25 0 0 0 .2.41h2.13c.41 0 .75-.33.75-.75v-2.64Zm3-6.86a.75.75 0 0 0-1.33-.48l-10.5 12.5A.75.75 0 0 0 6.76 18H16a2 2 0 0 0 2-2V4.75Zm-1 .69V16a1 1 0 0 1-1 1H7.29l9.7-11.56ZM6 6.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const BluetoothFilled = ( /*#__PURE__*/createFluentIcon('BluetoothFilled', "1em", ["M9.46 2.06c.28-.12.6-.05.82.16l4 4a.75.75 0 0 1-.06 1.11L10.94 10l3.28 2.67a.75.75 0 0 1 .06 1.11l-4 4A.75.75 0 0 1 9 17.25v-5.67l-2.78 2.25a.75.75 0 0 1-.94-1.16L8.56 10 5.28 7.33a.75.75 0 1 1 .94-1.16L9 8.42V2.75c0-.3.18-.58.46-.7Zm1.04 9.52v3.86l2.13-2.13-2.13-1.73Zm0-3.16 2.13-1.73-2.13-2.13v3.86Z"]));
export const BluetoothRegular = ( /*#__PURE__*/createFluentIcon('BluetoothRegular', "1em", ["M9.3 2.04a.5.5 0 0 1 .55.1l4 4a.5.5 0 0 1-.02.74L10.26 10l3.57 3.12a.5.5 0 0 1 .02.73l-4 4A.5.5 0 0 1 9 17.5v-6.4l-3.17 2.78a.5.5 0 0 1-.66-.76L8.74 10 5.17 6.88a.5.5 0 0 1 .66-.76L9 8.9V2.5c0-.2.12-.38.3-.46Zm.7 9.06v5.2l2.77-2.78L10 11.1Zm0-2.2 2.77-2.42L10 3.7V8.9Z"]));
export const BluetoothConnectedFilled = ( /*#__PURE__*/createFluentIcon('BluetoothConnectedFilled', "1em", ["M10.28 2.22A.75.75 0 0 0 9 2.75v5.67L6.22 6.17a.75.75 0 1 0-.94 1.16L8.56 10l-3.28 2.67a.75.75 0 0 0 .94 1.16L9 11.58v5.67a.75.75 0 0 0 1.28.53l4-4a.75.75 0 0 0-.06-1.11L10.94 10l3.28-2.67a.75.75 0 0 0 .06-1.11l-4-4Zm.22 13.22v-3.86l2.13 1.73-2.13 2.13Zm2.13-8.75L10.5 8.42V4.56l2.13 2.13ZM4 10a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm13 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"]));
export const BluetoothConnectedRegular = ( /*#__PURE__*/createFluentIcon('BluetoothConnectedRegular', "1em", ["M9.3 2.04a.5.5 0 0 1 .55.1l4 4a.5.5 0 0 1-.02.74L10.26 10l3.57 3.12a.5.5 0 0 1 .02.73l-4 4A.5.5 0 0 1 9 17.5v-6.4l-3.17 2.78a.5.5 0 0 1-.66-.76L8.74 10 5.17 6.88a.5.5 0 0 1 .66-.76L9 8.9V2.5c0-.2.12-.38.3-.46Zm.7 9.06v5.2l2.77-2.78L10 11.1Zm0-2.2 2.77-2.42L10 3.7V8.9Zm7 1.1a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM3 11a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const BluetoothDisabledFilled = ( /*#__PURE__*/createFluentIcon('BluetoothDisabledFilled', "1em", ["m13.68 14.38 3.47 3.47a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7l6.81 6.82-3.68 3a.75.75 0 0 0 .94 1.16L9 11.58v5.67a.75.75 0 0 0 1.28.53l3.4-3.4Zm-1.21-1.2.15.14-2.12 2.12v-3.86l1.97 1.6Zm1.75-5.85L11.6 9.47 10.53 8.4l2.1-1.7-2.13-2.14v3.82L9 6.88V2.75a.75.75 0 0 1 1.28-.53l4 4a.75.75 0 0 1-.06 1.11Z"]));
export const BluetoothDisabledRegular = ( /*#__PURE__*/createFluentIcon('BluetoothDisabledRegular', "1em", ["m13.5 14.2 3.65 3.65a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7L9 9.71v.06l-3.83 3.35a.5.5 0 0 0 .66.76L9 11.1v6.4a.5.5 0 0 0 .85.35l3.65-3.64Zm.33-7.32-2.58 2.25-.7-.7 2.22-1.95L10 3.7v4.17l-1-1V2.5a.5.5 0 0 1 .85-.35l4 4a.5.5 0 0 1-.02.73ZM10 11.1l2.77 2.42L10 16.3V11.1Z"]));
export const BluetoothSearchingFilled = ( /*#__PURE__*/createFluentIcon('BluetoothSearchingFilled', "1em", ["M10.28 2.22A.75.75 0 0 0 9 2.75v5.67L6.22 6.17a.75.75 0 1 0-.94 1.16L8.56 10l-3.28 2.67a.75.75 0 0 0 .94 1.16L9 11.58v5.67a.75.75 0 0 0 1.28.53l4-4a.75.75 0 0 0-.06-1.11L10.94 10l3.28-2.67a.75.75 0 0 0 .06-1.11l-4-4Zm.22 13.22v-3.86l2.13 1.73-2.13 2.13Zm2.13-8.75L10.5 8.42V4.56l2.13 2.13Zm5.62-.01a.75.75 0 0 0-1.35.64 6.22 6.22 0 0 1 0 5.36.75.75 0 0 0 1.35.64 7.72 7.72 0 0 0 0-6.64Zm-3 1.13c.4-.14.82.07.96.46a5.24 5.24 0 0 1 0 3.46.75.75 0 0 1-1.42-.5 3.74 3.74 0 0 0 0-2.47.75.75 0 0 1 .46-.95Z"]));
export const BluetoothSearchingRegular = ( /*#__PURE__*/createFluentIcon('BluetoothSearchingRegular', "1em", ["M9.85 2.15A.5.5 0 0 0 9 2.5v6.4L5.83 6.12a.5.5 0 1 0-.66.76L8.74 10l-3.57 3.12a.5.5 0 0 0 .66.76L9 11.1v6.4a.5.5 0 0 0 .85.35l4-4a.5.5 0 0 0-.02-.73L10.26 10l3.57-3.12a.5.5 0 0 0 .02-.73l-4-4ZM10 16.29V11.1l2.77 2.42L10 16.3Zm2.77-9.81L10 8.9V3.7l2.77 2.78Zm4.26.25a.5.5 0 1 0-.84.55 5 5 0 0 1 0 5.45.5.5 0 0 0 .84.54 6 6 0 0 0 0-6.54Zm-2.29 1.03a.5.5 0 0 1 .69.17 4 4 0 0 1 0 4.13.5.5 0 1 1-.86-.51 3 3 0 0 0 0-3.1.5.5 0 0 1 .17-.69Z"]));
export const BlurFilled = ( /*#__PURE__*/createFluentIcon('BlurFilled', "1em", ["M10 2a8 8 0 1 0 5.3 14H10v-1h6.25a8 8 0 0 0 .68-1H10v-1h7.42c.13-.32.24-.66.33-1H10v-1h7.94c.04-.33.06-.66.06-1h-8V9h7.94c-.04-.34-.1-.67-.2-1H10V7h7.42c-.14-.35-.3-.68-.49-1H10V5h6.25c-.3-.36-.61-.7-.96-1H10V3h3.88A7.96 7.96 0 0 0 10 2Z"]));
export const BlurRegular = ( /*#__PURE__*/createFluentIcon('BlurRegular', "1em", ["M10 2a8 8 0 1 0 5.3 14H10v1a7 7 0 1 1 0-14h3.88A7.96 7.96 0 0 0 10 2Zm0 2h5.3c.34.3.66.64.95 1H10V4Zm6.93 2H10v1h7.42c-.14-.35-.3-.68-.49-1ZM10 8h7.75c.08.33.15.66.19 1H10V8Zm8 2h-8v1h7.94c.04-.33.06-.66.06-1Zm-8 2h7.75c-.09.34-.2.68-.33 1H10v-1Zm6.93 2H10v1h6.25a8 8 0 0 0 .68-1Z"]));
export const BoardColor = ( /*#__PURE__*/createFluentIcon('BoardColor', "1em", `<path d="m17 12-3.5-.5-3.5.5-.5 2.5.5 2.5h4a3 3 0 0 0 3-3v-2Z" fill="url(#ic_fluent_board_20_color__a)"/><path d="m10 3-.5 4.5.5 4.5h7V6a3 3 0 0 0-3-3h-4Z" fill="url(#ic_fluent_board_20_color__b)"/><path d="M10 17V8l-3.5-.5L3 8v6a3 3 0 0 0 3 3h4Z" fill="url(#ic_fluent_board_20_color__c)"/><path d="M10 3v5H3V6a3 3 0 0 1 3-3h4Z" fill="url(#ic_fluent_board_20_color__d)"/><defs><linearGradient id="ic_fluent_board_20_color__a" x1="7" y1="9.5" x2="11.1" y2="18.88" gradientUnits="userSpaceOnUse"><stop stop-color="#B0F098"/><stop offset="1" stop-color="#52D17C"/></linearGradient><linearGradient id="ic_fluent_board_20_color__b" x1="11" y1="4" x2="16.33" y2="10.74" gradientUnits="userSpaceOnUse"><stop stop-color="#52D17C"/><stop offset="1" stop-color="#309C61"/></linearGradient><linearGradient id="ic_fluent_board_20_color__c" x1="4" y1="9" x2="9.46" y2="14.56" gradientUnits="userSpaceOnUse"><stop stop-color="#42B870"/><stop offset="1" stop-color="#1A7F7C"/></linearGradient><linearGradient id="ic_fluent_board_20_color__d" x1="4" y1="4" x2="6.07" y2="9.01" gradientUnits="userSpaceOnUse"><stop stop-color="#B0F098"/><stop offset="1" stop-color="#64DE89"/></linearGradient></defs>`, { color: true }));
export const BoardFilled = ( /*#__PURE__*/createFluentIcon('BoardFilled', "1em", ["M9.5 3v4H3V6a3 3 0 0 1 3-3h3.5Zm1 0v9H17V6a3 3 0 0 0-3-3h-3.5ZM17 13h-6.5v4H14a3 3 0 0 0 3-3v-1Zm-7.5 4V8H3v6a3 3 0 0 0 3 3h3.5Z"]));
export const BoardRegular = ( /*#__PURE__*/createFluentIcon('BoardRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-2a2 2 0 0 0-2 2v1.06L9.5 7V4H6Zm4.5 0v8H16V6a2 2 0 0 0-2-2h-3.5Zm5.5 9h-5.5v3H14a2 2 0 0 0 2-2v-1Zm-6.5 3V8L4 8.06V14c0 1.1.9 2 2 2h3.5Z"]));
export const BoardGamesFilled = ( /*#__PURE__*/createFluentIcon('BoardGamesFilled', "1em", ["M15.95 5.5a2.6 2.6 0 0 1 .98.18 2.5 2.5 0 1 1-2.29 4.42l.45 1.86c.2.78-.4 1.54-1.21 1.54h-.76c-.81 0-1.41-.76-1.22-1.55l.45-1.85a2.48 2.48 0 0 1-1.41.4 2 2 0 0 0-.7-1.07 3.99 3.99 0 0 0-.4-3.64 2.5 2.5 0 0 1 1.2-.29 2.5 2.5 0 0 1 2.46-3 2.5 2.5 0 0 1 2.45 3ZM6.5 5a3 3 0 0 0-2.24 5H4a1 1 0 1 0 0 2h.52a5.76 5.76 0 0 1-1.9 3.3c-.35.28-.62.73-.62 1.25 0 .8.65 1.45 1.45 1.45h6.1c.8 0 1.45-.65 1.45-1.45 0-.52-.27-.97-.62-1.26A5.76 5.76 0 0 1 8.48 12H9a1 1 0 1 0 0-2h-.26A3 3 0 0 0 6.5 5Z"]));
export const BoardGamesRegular = ( /*#__PURE__*/createFluentIcon('BoardGamesRegular', "1em", ["M13.5 3a2 2 0 0 0-1.96 2.4.5.5 0 0 1-.54.6 2 2 0 0 0-.92.22 4 4 0 0 0-.55-.83c.3-.17.62-.29.97-.35V5a3 3 0 1 1 6 0v.04a3 3 0 1 1-1.14 5.9l.22.9a1.75 1.75 0 0 1-1.7 2.16h-.76a1.75 1.75 0 0 1-1.7-2.16l.45-1.86a.5.5 0 1 1 .97.24l-.45 1.85c-.12.47.24.93.73.93h.76c.49 0 .84-.45.73-.93l-.45-1.85a.5.5 0 0 1 .76-.54A2 2 0 1 0 15.96 6a.5.5 0 0 1-.5-.6A2 2 0 0 0 13.5 3Zm-9 5a2 2 0 1 1 3.6 1.2.5.5 0 0 0 .4.8H9a.5.5 0 0 1 0 1H7.9a.5.5 0 0 0-.5.56 6.86 6.86 0 0 0 2.34 4.5c.17.15.26.33.26.49 0 .25-.2.45-.45.45h-6.1a.45.45 0 0 1-.45-.45c0-.16.09-.34.26-.49a6.86 6.86 0 0 0 2.34-4.5.5.5 0 0 0-.5-.56H4a.5.5 0 0 1 0-1h.5a.5.5 0 0 0 .4-.8c-.25-.33-.4-.75-.4-1.2Zm2-3a3 3 0 0 0-2.82 4.03A1.5 1.5 0 0 0 4 12h.52a5.76 5.76 0 0 1-1.9 3.3c-.35.28-.62.73-.62 1.25 0 .8.65 1.45 1.45 1.45h6.1c.8 0 1.45-.65 1.45-1.45 0-.52-.27-.97-.62-1.26A5.76 5.76 0 0 1 8.48 12H9a1.5 1.5 0 0 0 .32-2.97A3 3 0 0 0 6.5 5Z"]));
export const BoardHeartFilled = ( /*#__PURE__*/createFluentIcon('BoardHeartFilled', "1em", ["M9.5 7V3H6a3 3 0 0 0-3 3v1h6.5Zm1.25 8.41 3.43 3.46c.18.17.46.17.64 0l3.43-3.46A2.6 2.6 0 0 0 17 11.06a2.55 2.55 0 0 0-2.38.7l-.12.12-.12-.12a2.55 2.55 0 0 0-3.84.24 2.6 2.6 0 0 0 .21 3.41ZM9.5 17v-1.58a3.6 3.6 0 0 1 0-3.67V8H3v6a3 3 0 0 0 3 3h3.5Zm5-6.43a3.55 3.55 0 0 1 2.5-.53V6a3 3 0 0 0-3-3h-3.5v7.66a3.55 3.55 0 0 1 4-.09Z"]));
export const BoardHeartRegular = ( /*#__PURE__*/createFluentIcon('BoardHeartRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h4.92l-.88-.89a3.53 3.53 0 0 1-.1-.11H6a2 2 0 0 1-2-2V8.06L9.5 8v3.75a3.59 3.59 0 0 1 1-1.09V4H14a2 2 0 0 1 2 2v4.03c.33-.04.67-.04 1 .01V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h3.5v3L4 7.06V6Zm13 5.06a2.6 2.6 0 0 1 1.25 4.35l-3.43 3.46a.45.45 0 0 1-.64 0l-3.43-3.46a2.6 2.6 0 0 1-.21-3.41 2.55 2.55 0 0 1 3.84-.24l.12.12.12-.12a2.55 2.55 0 0 1 2.38-.7Z"]));
export const BoardSplitFilled = ( /*#__PURE__*/createFluentIcon('BoardSplitFilled', "1em", ["M6 3a3 3 0 0 0-3 3v3h8V3H6Zm5 7H3v4a3 3 0 0 0 3 3h5v-7Zm3 7h-2v-4h5v1a3 3 0 0 1-3 3Zm3-5h-5V8h5v4Zm0-5h-5V3h2a3 3 0 0 1 3 3v1Z"]));
export const BoardSplitRegular = ( /*#__PURE__*/createFluentIcon('BoardSplitRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm1 4v4c0 1.1.9 2 2 2h5v-6H4Zm7-1V4H6a2 2 0 0 0-2 2v3h7Zm1 7h2a2 2 0 0 0 2-2v-1h-4v3Zm4-9V6a2 2 0 0 0-2-2h-2v3h4Zm0 1h-4v4h4V8Z"]));
export const BookColor = ( /*#__PURE__*/createFluentIcon('BookColor', "1em", `<path d="M4.5 15H16s-.5.5-.5 1.5.5 1 .5 1H5.5a1 1 0 0 1-1-1V15Z" fill="url(#ic_fluent_book_20_color__a)"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_20_color__b)"/><path d="M6 5a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V5Z" fill="url(#ic_fluent_book_20_color__c)"/><defs><linearGradient id="ic_fluent_book_20_color__a" x1="10" y1="17" x2="10" y2="15" gradientUnits="userSpaceOnUse"><stop stop-color="#9DEAFF"/><stop offset=".72" stop-color="#58AAFE"/></linearGradient><linearGradient id="ic_fluent_book_20_color__b" x1="8.14" y1="4.99" x2="10.76" y2="22.18" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset="1" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_20_color__c" x1="8.76" y1="3.49" x2="12.12" y2="9.06" gradientUnits="userSpaceOnUse"><stop stop-color="#9FF0F9"/><stop offset="1" stop-color="#6CE0FF"/></linearGradient></defs>`, { color: true }));
export const BookFilled = ( /*#__PURE__*/createFluentIcon('BookFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm.75 2.5h6.5a.75.75 0 0 1 0 1.5h-6.5a.75.75 0 0 1 0-1.5Z"]));
export const BookRegular = ( /*#__PURE__*/createFluentIcon('BookRegular', "1em", ["M6 5a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V5Zm1 0v1h6V5H7ZM4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Z"]));
export const BookAddFilled = ( /*#__PURE__*/createFluentIcon('BookAddFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v5.2A5.5 5.5 0 0 0 9.2 16H5a1 1 0 0 0 1 1h3.6c.18.36.4.7.66 1H6a2 2 0 0 1-2-2V4Zm10.5 15a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm0-7c.28 0 .5.22.5.5V14h1.5a.5.5 0 0 1 0 1H15v1.5a.5.5 0 0 1-1 0V15h-1.5a.5.5 0 0 1 0-1H14v-1.5c0-.28.22-.5.5-.5ZM6.75 4a.75.75 0 0 0-.75.75v.5c0 .41.34.75.75.75h6.5c.41 0 .75-.34.75-.75v-.5a.75.75 0 0 0-.75-.75h-6.5Z"]));
export const BookAddRegular = ( /*#__PURE__*/createFluentIcon('BookAddRegular', "1em", ["M14 3H6a1 1 0 0 0-1 1v11h4.02c.03.34.1.68.19 1H5a1 1 0 0 0 1 1h3.6c.18.36.4.7.66 1H6a2 2 0 0 1-2-2V4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v5.2c-.32-.08-.66-.15-1-.18V4a1 1 0 0 0-1-1ZM6 5v1a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1Zm1 0h6v1H7V5Zm12 9.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const BookArrowClockwiseFilled = ( /*#__PURE__*/createFluentIcon('BookArrowClockwiseFilled', "1em", ["M18 2.98a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1 0-1h.8a3.5 3.5 0 1 0 1.7 3 .5.5 0 0 1 1 0 4.5 4.5 0 1 1-2-3.74V.98a.5.5 0 0 1 .5-.5c.28 0 .5.22.5.5v2ZM9.02 6A5.5 5.5 0 0 0 16 10.77V15a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4c0-1.1.9-2 2-2h4.24a5.5 5.5 0 0 0-1.22 4Z"]));
export const BookArrowClockwiseRegular = ( /*#__PURE__*/createFluentIcon('BookArrowClockwiseRegular', "1em", ["M17.5 3.48a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v.76a4.5 4.5 0 1 0 2 3.74.5.5 0 0 0-1 0 3.5 3.5 0 1 1-1.7-3h-.8a.5.5 0 0 0 0 1h2Zm-1.5 7.3c-.32.08-.66.15-1 .18V15H5V4a1 1 0 0 1 1-1h3.59c.18-.36.4-.7.65-1H6a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1v-4.23Z"]));
export const BookClockFilled = ( /*#__PURE__*/createFluentIcon('BookClockFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4Zm6 9a4 4 0 1 0 0-8 4 4 0 0 0 0 8Zm-.5-6c.28 0 .5.22.5.5V9h1a.5.5 0 0 1 0 1H9.5a.5.5 0 0 1-.5-.5v-2c0-.28.22-.5.5-.5Z"]));
export const BookClockRegular = ( /*#__PURE__*/createFluentIcon('BookClockRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Zm-4 3a3 3 0 1 0 0 6 3 3 0 0 0 0-6ZM6 9a4 4 0 1 1 8 0 4 4 0 0 1-8 0Zm4-1.5a.5.5 0 0 0-1 0v2c0 .28.22.5.5.5H11a.5.5 0 0 0 0-1h-1V7.5Z"]));
export const BookCoinsFilled = ( /*#__PURE__*/createFluentIcon('BookCoinsFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4Zm6 1c-.76 0-1.47.16-2.02.48C7.43 5.8 7 6.31 7 7c0 .69.43 1.2.98 1.52.55.32 1.26.48 2.02.48s1.47-.16 2.02-.48c.55-.32.98-.83.98-1.52 0-.69-.43-1.2-.98-1.52A4.08 4.08 0 0 0 10 5ZM7.03 9.03a.79.79 0 0 0-.03.22c0 .3.18.55.33.71.17.18.4.36.65.5a4.1 4.1 0 0 0 4.04 0c.26-.14.48-.32.65-.5.15-.16.33-.41.33-.71a.79.79 0 0 0-.03-.22l-.45.3a5.1 5.1 0 0 1-5.49-.3Zm0 2a.79.79 0 0 0-.03.22c0 .3.18.55.33.71.17.18.4.36.65.5a4.1 4.1 0 0 0 4.04 0c.26-.14.48-.32.65-.5.15-.16.33-.41.33-.71a.79.79 0 0 0-.03-.22l-.45.3a5.1 5.1 0 0 1-5.49-.3Z"]));
export const BookCoinsRegular = ( /*#__PURE__*/createFluentIcon('BookCoinsRegular', "1em", ["M4 16V4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2ZM15 4a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v11h10V4Zm-8 7.25c0-.08.01-.15.03-.22l.45.3a5.1 5.1 0 0 0 5.49-.3c.02.07.03.14.03.22 0 .3-.18.55-.33.71-.17.18-.4.36-.65.5a4.1 4.1 0 0 1-4.04 0 2.8 2.8 0 0 1-.65-.5 1.1 1.1 0 0 1-.33-.71Zm.03-2.22a.79.79 0 0 0-.03.22c0 .3.18.55.33.71.17.18.4.36.65.5a4.1 4.1 0 0 0 4.04 0c.26-.14.48-.32.65-.5.15-.16.33-.41.33-.71a.79.79 0 0 0-.03-.22l-.45.3a5.1 5.1 0 0 1-5.49-.3ZM8 7c0-.21.13-.45.48-.66.36-.2.9-.34 1.52-.34.63 0 1.16.14 1.52.34.35.21.48.45.48.66 0 .21-.13.45-.48.66-.36.2-.9.34-1.52.34a3.1 3.1 0 0 1-1.52-.34C8.13 7.45 8 7.2 8 7Zm2-2c-.76 0-1.47.16-2.02.48C7.43 5.8 7 6.31 7 7c0 .69.43 1.2.98 1.52.55.32 1.26.48 2.02.48s1.47-.16 2.02-.48c.55-.32.98-.83.98-1.52 0-.69-.43-1.2-.98-1.52A4.08 4.08 0 0 0 10 5Z"]));
export const BookCompassFilled = ( /*#__PURE__*/createFluentIcon('BookCompassFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4Zm6 .5a.5.5 0 0 0-.5.5v1.06a2 2 0 0 0-.74 3.5L7.54 12.3a.5.5 0 0 0 .92.4l1.21-2.73a2.01 2.01 0 0 0 .66 0l1.21 2.73a.5.5 0 1 0 .92-.4l-1.22-2.73a2 2 0 0 0-.74-3.5V5a.5.5 0 0 0-.5-.5Zm-.5 2.63a1 1 0 1 0 1 1.74 1 1 0 0 0-1-1.74Z"]));
export const BookCompassRegular = ( /*#__PURE__*/createFluentIcon('BookCompassRegular', "1em", ["M4 16V4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2ZM15 4a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v11h10V4Zm-5 .5c.28 0 .5.22.5.5v1.06a2 2 0 0 1 .74 3.5l1.22 2.74a.5.5 0 0 1-.92.4l-1.21-2.73a2.01 2.01 0 0 1-.66 0L8.46 12.7a.5.5 0 1 1-.92-.4l1.22-2.73a2 2 0 0 1 .74-3.5V5c0-.28.22-.5.5-.5Zm-.5 2.63a1 1 0 1 0 1 1.74 1 1 0 0 0-1-1.74Z"]));
export const BookContactsColor = ( /*#__PURE__*/createFluentIcon('BookContactsColor', "1em", `<path d="M4.5 15H16s-.5.5-.5 1.5.5 1 .5 1H5.5a1 1 0 0 1-1-1V15Z" fill="url(#ic_fluent_book_contacts_20_color__a)"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_contacts_20_color__b)"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_contacts_20_color__c)" fill-opacity=".3"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_contacts_20_color__d)" fill-opacity=".3"/><path d="M10 13c2.14 0 3-.94 3-1.88 0-.62-.58-1.12-1.29-1.12H8.3C7.58 10 7 10.5 7 11.13c0 .93.86 1.87 3 1.87Zm1.5-5.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z" fill="url(#ic_fluent_book_contacts_20_color__e)" fill-opacity=".9"/><defs><linearGradient id="ic_fluent_book_contacts_20_color__a" x1="10" y1="17" x2="10" y2="15" gradientUnits="userSpaceOnUse"><stop stop-color="#9DEAFF"/><stop offset=".72" stop-color="#58AAFE"/></linearGradient><linearGradient id="ic_fluent_book_contacts_20_color__b" x1="8.27" y1="4.99" x2="10.81" y2="22.2" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset="1" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_contacts_20_color__e" x1="14.5" y1="19" x2="2.54" y2=".2" gradientUnits="userSpaceOnUse"><stop stop-color="#9DEAFF"/><stop offset="1" stop-color="#fff"/></linearGradient><radialGradient id="ic_fluent_book_contacts_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(4 0 0 2.23514 10 12)"><stop stop-color="#171155"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_book_contacts_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(2 0 0 1.94168 10.5 7.5)"><stop stop-color="#171155"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const BookContactsFilled = ( /*#__PURE__*/createFluentIcon('BookContactsFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm4 11c-2.14 0-3-.94-3-1.88C7 10.5 7.58 10 8.29 10h3.42c.71 0 1.29.5 1.29 1.13 0 .93-.86 1.87-3 1.87Zm1.5-5.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"]));
export const BookContactsRegular = ( /*#__PURE__*/createFluentIcon('BookContactsRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Zm-4 10c2.14 0 3-.94 3-1.88 0-.62-.58-1.12-1.29-1.12H8.3C7.58 10 7 10.5 7 11.13c0 .93.86 1.87 3 1.87Zm1.5-5.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"]));
export const BookDatabaseColor = ( /*#__PURE__*/createFluentIcon('BookDatabaseColor', "1em", `<path d="M4.5 15H16s-.5.5-.5 1.5.5 1 .5 1H5.5a1 1 0 0 1-1-1V15Z" fill="url(#ic_fluent_book_database_20_color__a)"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_database_20_color__b)"/><path d="M6 5a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V5Z" fill="url(#ic_fluent_book_database_20_color__c)"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 .5-.5V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_database_20_color__d)" fill-opacity=".3"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 .5-.5V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_database_20_color__e)" fill-opacity=".3"/><path d="M18.17 12.14c-1 .55-2.29.86-3.67.86s-2.68-.3-3.67-.86c-.29-.16-.58-.36-.83-.59v4.95c0 1.38 2.01 2.5 4.5 2.5s4.5-1.12 4.5-2.5a12566.18 12566.18 0 0 1 0-4.95c-.25.23-.54.43-.83.6Z" fill="url(#ic_fluent_book_database_20_color__f)"/><path d="M17 9.42A7.86 7.86 0 0 0 14.5 9c-2.49 0-4.5 1.12-4.5 2.5s2.01 2.5 4.5 2.5 4.5-1.12 4.5-2.5c0-.87-.8-1.63-2-2.08Z" fill="url(#ic_fluent_book_database_20_color__g)"/><defs><linearGradient id="ic_fluent_book_database_20_color__a" x1="10" y1="17" x2="10" y2="15" gradientUnits="userSpaceOnUse"><stop stop-color="#9DEAFF"/><stop offset=".72" stop-color="#58AAFE"/></linearGradient><linearGradient id="ic_fluent_book_database_20_color__b" x1="8.14" y1="4.99" x2="10.76" y2="22.18" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset="1" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_database_20_color__c" x1="8.76" y1="3.49" x2="12.12" y2="9.06" gradientUnits="userSpaceOnUse"><stop stop-color="#9FF0F9"/><stop offset="1" stop-color="#6CE0FF"/></linearGradient><linearGradient id="ic_fluent_book_database_20_color__f" x1="12.13" y1="9.88" x2="17.38" y2="18.19" gradientUnits="userSpaceOnUse"><stop stop-color="#3BD5FF"/><stop offset="1" stop-color="#4894FE"/></linearGradient><linearGradient id="ic_fluent_book_database_20_color__g" x1="17.5" y1="14.5" x2="12" y2="9" gradientUnits="userSpaceOnUse"><stop stop-color="#66C0FF"/><stop offset="1" stop-color="#C8F3FF"/></linearGradient><radialGradient id="ic_fluent_book_database_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-3.5 2 -2.23462 -3.91057 11.5 17)"><stop stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_book_database_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-90.57 13.67 2.3) scale(6 3.25)"><stop stop-color="#171155"/><stop offset=".33" stop-color="#171155"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const BookDatabaseFilled = ( /*#__PURE__*/createFluentIcon('BookDatabaseFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v4.13A8.88 8.88 0 0 0 14.5 8c-1.38 0-2.68.3-3.67.86-.9.5-1.74 1.33-1.82 2.46L9 11.3V16H5a1 1 0 0 0 1 1h3.05c.08.37.24.7.45 1H6a2 2 0 0 1-2-2V4Zm2.75 0a.75.75 0 0 0-.75.75v.5c0 .41.34.75.75.75h6.5c.41 0 .75-.34.75-.75v-.5a.75.75 0 0 0-.75-.75h-6.5ZM17 9.42A7.86 7.86 0 0 0 14.5 9c-2.49 0-4.5 1.12-4.5 2.5s2.01 2.5 4.5 2.5 4.5-1.12 4.5-2.5c0-.87-.8-1.63-2-2.08Zm1.17 4.72c-1 .55-2.29.86-3.67.86s-2.68-.3-3.67-.86c-.29-.16-.58-.36-.83-.59v2.95c0 1.38 2.01 2.5 4.5 2.5s4.5-1.12 4.5-2.5a2959.09 2959.09 0 0 1 0-2.95c-.25.23-.54.43-.83.6Z"]));
export const BookDatabaseRegular = ( /*#__PURE__*/createFluentIcon('BookDatabaseRegular', "1em", ["M6 5a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V5Zm1 0v1h6V5H7ZM4 4v12c0 1.1.9 2 2 2h3.5c-.21-.3-.37-.63-.45-1H6a1 1 0 0 1-1-1h4v-1H5V4a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v4.01c.34.02.68.06 1 .12V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm13 5.42A7.86 7.86 0 0 0 14.5 9c-2.49 0-4.5 1.12-4.5 2.5s2.01 2.5 4.5 2.5 4.5-1.12 4.5-2.5c0-.87-.8-1.63-2-2.08Zm1.17 4.72c-1 .55-2.29.86-3.67.86s-2.68-.3-3.67-.86c-.29-.16-.58-.36-.83-.59v2.95c0 1.38 2.01 2.5 4.5 2.5s4.5-1.12 4.5-2.5a2959.09 2959.09 0 0 1 0-2.95c-.25.23-.54.43-.83.6Z"]));
export const BookDefaultFilled = ( /*#__PURE__*/createFluentIcon('BookDefaultFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4Zm2.75 0a.75.75 0 0 0-.75.75v.5c0 .41.34.75.75.75h6.5c.41 0 .75-.34.75-.75v-.5a.75.75 0 0 0-.75-.75h-6.5Z"]));
export const BookDismissFilled = ( /*#__PURE__*/createFluentIcon('BookDismissFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v5.2A5.5 5.5 0 0 0 9.2 16H5a1 1 0 0 0 1 1h3.6c.18.36.4.7.66 1H6a2 2 0 0 1-2-2V4Zm2.75 0a.75.75 0 0 0-.75.75v.5c0 .41.34.75.75.75h6.5c.41 0 .75-.34.75-.75v-.5a.75.75 0 0 0-.75-.75h-6.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const BookDismissRegular = ( /*#__PURE__*/createFluentIcon('BookDismissRegular', "1em", ["M6 5a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1V5Zm1 0v1h6V5H7ZM4 4v12c0 1.1.9 2 2 2h4.26a5.5 5.5 0 0 1-.66-1H6a1 1 0 0 1-1-1h4.2c-.08-.32-.15-.66-.18-1H5V4a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v5.02c.34.03.68.1 1 .19V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm15 10.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const BookExclamationMarkFilled = ( /*#__PURE__*/createFluentIcon('BookExclamationMarkFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4Zm6 1a.5.5 0 0 0-.5.5v4a.5.5 0 0 0 1 0v-4A.5.5 0 0 0 10 5Zm.75 7.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z"]));
export const BookExclamationMarkRegular = ( /*#__PURE__*/createFluentIcon('BookExclamationMarkRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Zm-4 2c.28 0 .5.22.5.5v4a.5.5 0 0 1-1 0v-4c0-.28.22-.5.5-.5Zm0 8a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const BookGlobeFilled = ( /*#__PURE__*/createFluentIcon('BookGlobeFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm4 10.5-.04-.02a.62.62 0 0 1-.15-.14 2.76 2.76 0 0 1-.4-.82A9.4 9.4 0 0 1 9.01 9h1.98a9.4 9.4 0 0 1-.4 2.52c-.13.38-.27.65-.4.82a.62.62 0 0 1-.15.14.15.15 0 0 1-.03.02H10ZM13.97 9a4 4 0 0 1-2.6 3.26l.17-.42c.25-.76.41-1.75.45-2.84h1.98Zm0-1h-1.98a10.43 10.43 0 0 0-.61-3.26A4 4 0 0 1 13.97 8Zm-5.35 4.26A4 4 0 0 1 6.03 9h1.98a10.43 10.43 0 0 0 .61 3.26ZM6.03 8a4 4 0 0 1 2.6-3.26l-.17.42c-.25.76-.41 1.75-.45 2.84H6.03ZM10 4.5l.04.02c.04.02.09.06.15.14.13.17.27.44.4.82.21.64.36 1.52.4 2.52H9.01c.04-1 .19-1.88.4-2.52.13-.38.27-.65.4-.82a.62.62 0 0 1 .15-.14.15.15 0 0 1 .03-.02H10Z"]));
export const BookGlobeRegular = ( /*#__PURE__*/createFluentIcon('BookGlobeRegular', "1em", ["M4 16V4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2ZM15 4a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v11h10V4ZM7.04 8h.97c.05-.77.2-1.49.42-2.06A3 3 0 0 0 7.04 8ZM6 8.5a4 4 0 1 1 8 0 4 4 0 0 1-8 0Zm6.96-.5a3 3 0 0 0-1.4-2.06c.23.57.38 1.29.43 2.06h.97Zm-.97 1c-.05.77-.2 1.49-.42 2.06A3 3 0 0 0 12.96 9h-.97Zm-1-1a5.56 5.56 0 0 0-.39-1.78 1.88 1.88 0 0 0-.37-.59c-.11-.11-.2-.13-.23-.13-.04 0-.12.02-.23.13-.12.12-.25.31-.37.6-.2.45-.34 1.06-.38 1.77h1.96ZM9.01 9c.04.7.18 1.32.38 1.78.12.28.25.47.37.59.11.11.2.13.23.13.04 0 .12-.02.23-.13.12-.12.25-.31.37-.6.2-.45.34-1.06.38-1.77H9.02Zm-1 0h-.98a3 3 0 0 0 1.4 2.06A6.75 6.75 0 0 1 8 9Z"]));
export const BookInformationFilled = ( /*#__PURE__*/createFluentIcon('BookInformationFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm4.75 3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.25 6.75a.5.5 0 0 1-1 0v-4a.5.5 0 0 1 1 0v4Z"]));
export const BookInformationRegular = ( /*#__PURE__*/createFluentIcon('BookInformationRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Zm-3.25 2.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-.25 6.75a.5.5 0 0 1-1 0v-4a.5.5 0 0 1 1 0v4Z"]));
export const BookLetterFilled = ( /*#__PURE__*/createFluentIcon('BookLetterFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm4 3c.2 0 .38.12.46.3l3 7a.5.5 0 0 1-.92.4l-.73-1.7H8.2l-.73 1.7a.5.5 0 0 1-.92-.4l3-7A.5.5 0 0 1 10 5Zm-1.38 5h2.76L10 6.77 8.62 10Z"]));
export const BookLetterRegular = ( /*#__PURE__*/createFluentIcon('BookLetterRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Zm-4 2c.2 0 .38.12.46.3l3 7a.5.5 0 0 1-.92.4l-.73-1.7H8.2l-.73 1.7a.5.5 0 0 1-.92-.4l3-7A.5.5 0 0 1 10 5Zm-1.38 5h2.76L10 6.77 8.62 10Z"]));
export const BookNumberFilled = ( /*#__PURE__*/createFluentIcon('BookNumberFilled', "1em", ["M9.61 8h.98l-.2 1h-.98l.2-1ZM6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 1 0 0-1H6a1 1 0 0 1-1-1h10.5a.5.5 0 0 0 .5-.5V4a2 2 0 0 0-2-2H6Zm5.6 3.51a.5.5 0 0 1 .4.59l-.19.9h.94a.5.5 0 0 1 0 1h-1.14l-.2 1h1.1a.5.5 0 1 1 0 1h-1.3L11 11.1a.5.5 0 0 1-.98-.2l.18-.9h-.98l-.22 1.1a.5.5 0 1 1-.98-.2l.18-.9h-.94a.5.5 0 0 1 0-1H8.4l.2-1H7.5a.5.5 0 0 1 0-1h1.29l.22-1.1a.5.5 0 0 1 .98.2l-.18.9h.98l.22-1.1a.5.5 0 0 1 .59-.39Z"]));
export const BookNumberRegular = ( /*#__PURE__*/createFluentIcon('BookNumberRegular', "1em", ["M7 7.5c0-.27.22-.5.5-.5h1.29l.22-1.1a.5.5 0 0 1 .98.2l-.18.9h.98l.22-1.1a.5.5 0 0 1 .98.2l-.18.9h.94a.5.5 0 0 1 0 1h-1.14l-.2 1h1.1a.5.5 0 1 1 0 1h-1.3L11 11.1a.5.5 0 0 1-.98-.2l.18-.9h-.98l-.22 1.1a.5.5 0 1 1-.98-.2l.18-.9h-.94a.5.5 0 0 1 0-1H8.4l.2-1H7.5a.5.5 0 0 1-.5-.5ZM10.4 9l.2-1H9.6l-.2 1h.98ZM6 2h8a2 2 0 0 1 2 2v11.5a.5.5 0 0 1-.5.5H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4c0-1.1.9-2 2-2ZM5 15h10V4a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v11Z"]));
export const BookOpenColor = ( /*#__PURE__*/createFluentIcon('BookOpenColor', "1em", `<path d="M8 17c.82 0 1.54-.4 2-1l1-6-1-5.5C9.54 3.9 8.82 3 8 3H3.5C2.67 3 2 3.67 2 4.5v11c0 .83.67 1.5 1.5 1.5H8Z" fill="url(#ic_fluent_book_open_20_color__a)"/><path d="M12 17a2.5 2.5 0 0 1-2-1V4.5C10 4 11 3 12 3h4.5c.83 0 1.5.67 1.5 1.5v11c0 .83-.67 1.5-1.5 1.5H12Z" fill="url(#ic_fluent_book_open_20_color__b)"/><path d="M3.5 3.5c0-.28.22-.5.5-.5h4.5c.83 0 1.5.67 1.5 1.5l.5 4.5-.5 4.5a2 2 0 0 1-2 2H4a.5.5 0 0 1-.5-.5V3.5Z" fill="url(#ic_fluent_book_open_20_color__c)"/><path d="M16.5 3.5A.5.5 0 0 0 16 3h-4.5c-.83 0-1.5.67-1.5 1.5v9c0 1.1.9 2 2 2h4a.5.5 0 0 0 .5-.5V3.5Z" fill="url(#ic_fluent_book_open_20_color__d)"/><defs><linearGradient id="ic_fluent_book_open_20_color__a" x1="5.11" y1="5.62" x2="7.76" y2="20.53" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset="1" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_open_20_color__b" x1="16.5" y1="3.5" x2="13.25" y2="20.54" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset=".91" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_open_20_color__c" x1="4" y1="5.5" x2="18.51" y2="11.05" gradientUnits="userSpaceOnUse"><stop stop-color="#9DEAFF"/><stop offset="1" stop-color="#58AAFE"/></linearGradient><linearGradient id="ic_fluent_book_open_20_color__d" x1="16.51" y1="3.73" x2="5" y2="8" gradientUnits="userSpaceOnUse"><stop offset=".23" stop-color="#9DEAFF"/><stop offset=".85" stop-color="#4894FE"/></linearGradient></defs>`, { color: true }));
export const BookOpenFilled = ( /*#__PURE__*/createFluentIcon('BookOpenFilled', "1em", ["M10 16.14c-.5.53-1.21.86-2 .86H3.75C2.78 17 2 16.22 2 15.25V4.75C2 3.78 2.78 3 3.75 3H8c.79 0 1.5.33 2 .86.5-.53 1.21-.86 2-.86h4.25c.97 0 1.75.78 1.75 1.75v10.5c0 .97-.78 1.75-1.75 1.75H12c-.79 0-1.5-.33-2-.86ZM3.5 4.75v10.5c0 .14.11.25.25.25H8c.69 0 1.25-.56 1.25-1.25v-8.5c0-.69-.56-1.25-1.25-1.25H3.75a.25.25 0 0 0-.25.25Zm7.25 9.5c0 .69.56 1.25 1.25 1.25h4.25c.14 0 .25-.11.25-.25V4.75a.25.25 0 0 0-.25-.25H12c-.69 0-1.25.56-1.25 1.25v8.5Z"]));
export const BookOpenRegular = ( /*#__PURE__*/createFluentIcon('BookOpenRegular', "1em", ["M10 16c-.46.6-1.18 1-2 1H3.5A1.5 1.5 0 0 1 2 15.5v-11C2 3.67 2.67 3 3.5 3H8c.82 0 1.54.4 2 1 .46-.6 1.18-1 2-1h4.5c.83 0 1.5.67 1.5 1.5v11c0 .83-.67 1.5-1.5 1.5H12a2.5 2.5 0 0 1-2-1ZM3 4.5v11c0 .28.22.5.5.5H8c.83 0 1.5-.67 1.5-1.5v-9C9.5 4.67 8.83 4 8 4H3.5a.5.5 0 0 0-.5.5Zm7.5 10c0 .83.67 1.5 1.5 1.5h4.5a.5.5 0 0 0 .5-.5v-11a.5.5 0 0 0-.5-.5H12c-.83 0-1.5.67-1.5 1.5v9Z"]));
export const BookOpenGlobeFilled = ( /*#__PURE__*/createFluentIcon('BookOpenGlobeFilled', "1em", ["M18 4.75v5.5a5.5 5.5 0 0 0-1.5-.88V4.75a.25.25 0 0 0-.25-.25H12c-.69 0-1.25.56-1.25 1.25v4.73a5.5 5.5 0 0 0-1.5 2.38V5.75c0-.69-.56-1.25-1.25-1.25H3.75a.25.25 0 0 0-.25.25v10.5c0 .14.11.25.25.25H8c.42 0 .8-.2 1.02-.53.05.58.19 1.13.4 1.64-.42.25-.9.39-1.42.39H3.75C2.78 17 2 16.22 2 15.25V4.75C2 3.78 2.78 3 3.75 3H8c.79 0 1.5.33 2 .86.5-.53 1.21-.86 2-.86h4.25c.97 0 1.75.78 1.75 1.75Z", "M13.01 14a8.9 8.9 0 0 1 .54-2.85c.17-.42.35-.72.53-.91.19-.2.33-.24.42-.24.1 0 .23.05.42.24.18.19.36.5.53.91.3.73.5 1.72.54 2.85h-2.98Z", "M12.62 10.78c.07-.16.13-.31.21-.46a4.5 4.5 0 0 0-2.8 3.68H12c.05-1.23.27-2.36.61-3.22Z", "M16.38 10.78a5.35 5.35 0 0 0-.2-.46c1.5.6 2.6 2 2.8 3.68h-1.99a9.92 9.92 0 0 0-.61-3.22Z", "M17 15h1.97a4.5 4.5 0 0 1-2.8 3.68A9.92 9.92 0 0 0 17 15Z", "M14.92 18.76c-.19.2-.33.24-.42.24-.1 0-.23-.05-.42-.24-.18-.19-.36-.5-.53-.91a8.9 8.9 0 0 1-.54-2.85h2.98a8.9 8.9 0 0 1-.54 2.85c-.17.42-.35.72-.53.91Z", "M10.03 15a4.5 4.5 0 0 0 2.8 3.68A9.92 9.92 0 0 1 12 15h-1.98Z"]));
export const BookOpenGlobeRegular = ( /*#__PURE__*/createFluentIcon('BookOpenGlobeRegular', "1em", ["M18 4.5v5.76a5.5 5.5 0 0 0-1-.66V4.5a.5.5 0 0 0-.5-.5H12c-.83 0-1.5.67-1.5 1.5v5.23c-.4.43-.75.93-1 1.48V5.5C9.5 4.67 8.83 4 8 4H3.5a.5.5 0 0 0-.5.5v11c0 .28.22.5.5.5H8c.43 0 .82-.18 1.1-.48.06.37.17.72.3 1.05-.4.27-.88.43-1.4.43H3.5A1.5 1.5 0 0 1 2 15.5v-11C2 3.67 2.67 3 3.5 3H8c.82 0 1.54.4 2 1 .46-.6 1.18-1 2-1h4.5c.83 0 1.5.67 1.5 1.5Z", "M13.01 14a8.9 8.9 0 0 1 .54-2.85c.17-.42.35-.72.53-.91.19-.2.33-.24.42-.24.1 0 .23.05.42.24.18.19.36.5.53.91.3.73.5 1.72.54 2.85h-2.98Z", "m12.62 10.78.2-.46a4.5 4.5 0 0 0-2.8 3.68h1.99c.05-1.23.27-2.36.61-3.22Z", "M16.38 10.78a5.29 5.29 0 0 0-.21-.46c1.51.6 2.62 2 2.8 3.68H17a9.92 9.92 0 0 0-.61-3.22Z", "M16.99 15h1.98a4.5 4.5 0 0 1-2.8 3.68 9.92 9.92 0 0 0 .82-3.68Z", "M14.92 18.76c-.19.2-.33.24-.42.24-.1 0-.23-.05-.42-.24-.18-.19-.36-.5-.53-.91a8.9 8.9 0 0 1-.54-2.85h2.98a8.9 8.9 0 0 1-.54 2.85c-.17.42-.35.72-.53.91Z", "M10.03 15a4.5 4.5 0 0 0 2.8 3.68A9.92 9.92 0 0 1 12 15h-1.98Z"]));
export const BookOpenLightbulbColor = ( /*#__PURE__*/createFluentIcon('BookOpenLightbulbColor', "1em", `<path d="M8 17c.82 0 1.54-.4 2-1l1-6-1-5.5C9.54 3.9 8.82 3 8 3H3.5C2.67 3 2 3.67 2 4.5v11c0 .83.67 1.5 1.5 1.5H8Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__a)"/><path d="M3.5 3.5c0-.28.22-.5.5-.5h4.5c.83 0 1.5.67 1.5 1.5l.5 4.5-.5 4.5a2 2 0 0 1-2 2H4a.5.5 0 0 1-.5-.5V3.5Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__b)"/><path d="M16.5 3c.83 0 1.5.67 1.5 1.5V15h-3v2h-3a2.5 2.5 0 0 1-2-1V4.5C10 4 11 3 12 3h4.5Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__c)"/><path d="M16.5 3.5A.5.5 0 0 0 16 3h-4.5c-.83 0-1.5.67-1.5 1.5v9c0 1.1.9 2 2 2h4a.5.5 0 0 0 .5-.5V3.5Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__d)"/><path d="M16.5 3.5A.5.5 0 0 0 16 3h-4.5c-.83 0-1.5.67-1.5 1.5v9c0 1.1.9 2 2 2h4a.5.5 0 0 0 .5-.5V3.5Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__e)"/><path d="m14.6 17 .24 1.2c.1.46.5.8.98.8h.36a1 1 0 0 0 .98-.8l.24-1.2-1.53-.5-1.27.5Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__f)"/><path d="m14.6 17 .24 1.2c.1.46.5.8.98.8h.36a1 1 0 0 0 .98-.8l.24-1.2-1.53-.5-1.27.5Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__g)"/><path d="M19 13a3 3 0 0 1-1.3 2.47l-.1.53-1.6.5-1.6-.5-.1-.53A3 3 0 1 1 19 13Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__h)"/><path d="M17.4 17h-2.8l-.2-1h3.2l-.2 1Z" fill="url(#ic_fluent_book_open_lightbulb_20_color__i)"/><defs><linearGradient id="ic_fluent_book_open_lightbulb_20_color__a" x1="5.11" y1="5.62" x2="7.76" y2="20.53" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset="1" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_open_lightbulb_20_color__b" x1="4" y1="5.5" x2="18.51" y2="11.05" gradientUnits="userSpaceOnUse"><stop stop-color="#9DEAFF"/><stop offset="1" stop-color="#58AAFE"/></linearGradient><linearGradient id="ic_fluent_book_open_lightbulb_20_color__c" x1="16.5" y1="3.5" x2="13.25" y2="20.54" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset=".91" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_open_lightbulb_20_color__d" x1="16.51" y1="3.73" x2="5" y2="8" gradientUnits="userSpaceOnUse"><stop offset=".23" stop-color="#9DEAFF"/><stop offset=".85" stop-color="#4894FE"/></linearGradient><linearGradient id="ic_fluent_book_open_lightbulb_20_color__g" x1="16" y1="16.5" x2="16" y2="19" gradientUnits="userSpaceOnUse"><stop stop-color="#D34719"/><stop offset="1" stop-color="#D34719" stop-opacity="0"/></linearGradient><linearGradient id="ic_fluent_book_open_lightbulb_20_color__i" x1="15.75" y1="16.4" x2="16.85" y2="17.82" gradientUnits="userSpaceOnUse"><stop stop-color="#FFC7A3"/><stop offset="1" stop-color="#FF9C70"/></linearGradient><radialGradient id="ic_fluent_book_open_lightbulb_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-7.26476 -8.25854 8.14411 -7.1641 16.5 16)"><stop offset=".21" stop-color="#2063C3"/><stop offset=".71" stop-color="#8AD6FF" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_book_open_lightbulb_20_color__f" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(80 1.94 12.83) scale(9.97035 9.78347)"><stop stop-color="#FFE06B"/><stop offset=".38" stop-color="#FFA43D"/><stop offset="1" stop-color="#E67505"/></radialGradient><radialGradient id="ic_fluent_book_open_lightbulb_20_color__h" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(73.66 -.19 14.73) scale(7.01007 10.8653)"><stop stop-color="#FFE06B"/><stop offset=".38" stop-color="#FFA43D"/><stop offset="1" stop-color="#E67505"/></radialGradient></defs>`, { color: true }));
export const BookOpenLightbulbFilled = ( /*#__PURE__*/createFluentIcon('BookOpenLightbulbFilled', "1em", ["m17.4 17-.24 1.2a1 1 0 0 1-.98.8h-.36a1 1 0 0 1-.98-.8L14.6 17h2.8ZM8 3c.79 0 1.5.33 2 .86.5-.53 1.21-.86 2-.86h4.25c.97 0 1.75.78 1.75 1.75v4.79a3.97 3.97 0 0 0-1.5-.5V4.74a.25.25 0 0 0-.25-.25H12c-.69 0-1.25.56-1.25 1.25v8.5c0 .69.56 1.25 1.25 1.25h.88c.15.19.32.37.5.52l.04.18a1 1 0 0 0 .24.47 1 1 0 0 0-.06.33H12c-.79 0-1.5-.33-2-.86-.5.53-1.21.86-2 .86H3.75C2.78 17 2 16.22 2 15.25V4.75C2 3.78 2.78 3 3.75 3H8Zm8 7a3 3 0 0 1 1.7 5.47l-.1.53h-3.2l-.1-.53A3 3 0 0 1 16 10ZM3.75 4.5a.25.25 0 0 0-.25.25v10.5c0 .14.11.25.25.25H8c.69 0 1.25-.56 1.25-1.25v-8.5c0-.69-.56-1.25-1.25-1.25H3.75Z"]));
export const BookOpenLightbulbRegular = ( /*#__PURE__*/createFluentIcon('BookOpenLightbulbRegular', "1em", ["m17.4 17-.24 1.2a1 1 0 0 1-.98.8h-.36a1 1 0 0 1-.98-.8L14.6 17h2.8ZM8 3c.82 0 1.54.4 2 1 .46-.6 1.18-1 2-1h4.5c.83 0 1.5.67 1.5 1.5v5.04a3.97 3.97 0 0 0-1-.41V4.5a.5.5 0 0 0-.5-.5H12c-.83 0-1.5.67-1.5 1.5v9c0 .83.67 1.5 1.5 1.5h1.36l.02.02.04.18a1 1 0 0 0 .24.47 1 1 0 0 0-.06.33H12a2.5 2.5 0 0 1-2-1c-.46.6-1.18 1-2 1H3.5A1.5 1.5 0 0 1 2 15.5v-11C2 3.67 2.67 3 3.5 3H8ZM3.5 4a.5.5 0 0 0-.5.5v11c0 .28.22.5.5.5H8c.83 0 1.5-.67 1.5-1.5v-9C9.5 4.67 8.83 4 8 4H3.5ZM16 10a3 3 0 0 1 1.7 5.47l-.1.53h-3.2l-.1-.53A3 3 0 0 1 16 10Z"]));
export const BookOpenMicrophoneFilled = ( /*#__PURE__*/createFluentIcon('BookOpenMicrophoneFilled', "1em", ["M10 16.14c-.5.53-1.21.86-2 .86H3.75C2.78 17 2 16.22 2 15.25V4.75C2 3.78 2.78 3 3.75 3H8c.79 0 1.5.33 2 .86.5-.53 1.21-.86 2-.86h4.25c.97 0 1.75.78 1.75 1.75v6.75a2.5 2.5 0 0 0-1.5-2.3V4.76a.25.25 0 0 0-.25-.25H12c-.69 0-1.25.56-1.25 1.25v8.5c0 .3.1.58.28.8.09.7.34 1.37.72 1.94a2.74 2.74 0 0 1-1.75-.85ZM3.5 4.75v10.5c0 .14.11.25.25.25H8c.69 0 1.25-.56 1.25-1.25v-8.5c0-.69-.56-1.25-1.25-1.25H3.75a.25.25 0 0 0-.25.25Zm13.93 11.34c.35-.43.57-.98.57-1.59a.5.5 0 0 1 1 0 3.5 3.5 0 0 1-3 3.46v.54a.5.5 0 0 1-1 0v-.54a3.49 3.49 0 0 1-3-3.46.5.5 0 0 1 1 0 2.5 2.5 0 0 0 2.5 2.5 2.5 2.5 0 0 0 1.93-.9ZM15.5 16a1.5 1.5 0 0 1-1.5-1.5v-3a1.5 1.5 0 0 1 3 0v3c0 .83-.67 1.5-1.5 1.5Z"]));
export const BookOpenMicrophoneRegular = ( /*#__PURE__*/createFluentIcon('BookOpenMicrophoneRegular', "1em", ["M10 16c-.46.6-1.18 1-2 1H3.5A1.5 1.5 0 0 1 2 15.5v-11C2 3.67 2.67 3 3.5 3H8c.82 0 1.54.4 2 1 .46-.6 1.18-1 2-1h4.5c.83 0 1.5.67 1.5 1.5v7c0-.82-.4-1.54-1-2v-5a.5.5 0 0 0-.5-.5H12c-.83 0-1.5.67-1.5 1.5v9c0 .52.27.99.68 1.25.13.45.32.86.57 1.24A2.5 2.5 0 0 1 10 16ZM3 4.5v11c0 .28.22.5.5.5H8c.83 0 1.5-.67 1.5-1.5v-9C9.5 4.67 8.83 4 8 4H3.5a.5.5 0 0 0-.5.5Zm14.43 11.6c.35-.44.57-1 .57-1.6a.5.5 0 0 1 1 0 3.5 3.5 0 0 1-3 3.46v.54a.5.5 0 0 1-1 0v-.54a3.49 3.49 0 0 1-3-3.46.5.5 0 0 1 1 0 2.49 2.49 0 0 0 2.5 2.5 2.5 2.5 0 0 0 1.93-.9ZM14 11.5a1.5 1.5 0 0 1 3 0v3a1.5 1.5 0 0 1-3 0v-3Z"]));
export const BookPulseFilled = ( /*#__PURE__*/createFluentIcon('BookPulseFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4Zm5.46 2.3a.5.5 0 0 0-.9-.02L7.18 9H6.5a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .45-.28l1.03-2.06 2.06 4.55a.5.5 0 0 0 .89.05L13.28 10h.22a.5.5 0 0 0 0-1H13a.5.5 0 0 0-.43.24l-1 1.69-2.11-4.64Z"]));
export const BookPulseRegular = ( /*#__PURE__*/createFluentIcon('BookPulseRegular', "1em", ["M4 16V4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2ZM15 4a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v11h10V4ZM9.46 6.3a.5.5 0 0 0-.9-.02L7.18 9H6.5a.5.5 0 0 0 0 1h1a.5.5 0 0 0 .45-.28l1.03-2.06 2.06 4.55a.5.5 0 0 0 .89.05L13.28 10h.22a.5.5 0 0 0 0-1H13a.5.5 0 0 0-.43.24l-1 1.69-2.11-4.64Z"]));
export const BookQuestionMarkFilled = ( /*#__PURE__*/createFluentIcon('BookQuestionMarkFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm2.76 4.4a.9.9 0 0 0-.26.6.5.5 0 0 1-1 0c0-.37.14-.87.54-1.28C8.45 5.29 9.09 5 10 5c.91 0 1.55.29 1.96.72.4.41.54.91.54 1.28 0 1.05-.73 1.55-1.28 1.82a8 8 0 0 1-.39.18h-.01a5.75 5.75 0 0 0-.32.15V10a.5.5 0 0 1-1 0V9c0-.25.13-.43.24-.53.11-.1.24-.18.35-.23l.32-.15.02-.01a7 7 0 0 0 .35-.16c.45-.22.72-.47.72-.92a.9.9 0 0 0-.26-.6c-.19-.19-.55-.4-1.24-.4s-1.05.21-1.24.4ZM10 13a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Z"]));
export const BookQuestionMarkRegular = ( /*#__PURE__*/createFluentIcon('BookQuestionMarkRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8ZM8.76 6.4c.19-.19.55-.4 1.24-.4s1.05.21 1.24.4c.2.22.26.47.26.6 0 .45-.27.7-.72.92a7 7 0 0 1-.35.16l-.02.01-.32.15c-.1.05-.24.12-.35.23A.73.73 0 0 0 9.5 9v1a.5.5 0 1 0 1 0v-.85l.04-.02.28-.13h.01a8 8 0 0 0 .4-.18c.54-.27 1.27-.77 1.27-1.82 0-.37-.14-.87-.54-1.28C11.55 5.29 10.91 5 10 5c-.91 0-1.55.29-1.96.72-.4.41-.54.91-.54 1.28a.5.5 0 0 0 1 0 .9.9 0 0 1 .26-.6ZM10 13a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const BookQuestionMarkRtlFilled = ( /*#__PURE__*/createFluentIcon('BookQuestionMarkRtlFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm5.24 4.4c-.19-.19-.55-.4-1.24-.4s-1.05.21-1.24.4a.9.9 0 0 0-.26.6c0 .45.27.7.72.92l.35.16.02.01.32.15c.1.05.24.12.35.23.11.1.24.28.24.53v1a.5.5 0 1 1-1 0v-.85l-.04-.02A5.75 5.75 0 0 0 9.18 9h-.01a7.97 7.97 0 0 1-.4-.18C8.24 8.55 7.5 8.05 7.5 7c0-.37.14-.87.54-1.28C8.45 5.29 9.09 5 10 5c.91 0 1.55.29 1.96.72.4.41.54.91.54 1.28a.5.5 0 0 1-1 0 .9.9 0 0 0-.26-.6ZM10 13a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Z"]));
export const BookQuestionMarkRtlRegular = ( /*#__PURE__*/createFluentIcon('BookQuestionMarkRtlRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Zm-2.76 3.4c.2.22.26.47.26.6a.5.5 0 0 0 1 0c0-.37-.14-.87-.54-1.28C11.55 5.29 10.91 5 10 5c-.91 0-1.55.29-1.96.72-.4.41-.54.91-.54 1.28 0 1.05.73 1.55 1.28 1.82l.39.18h.01a5.75 5.75 0 0 1 .32.15V10a.5.5 0 0 0 1 0V9a.73.73 0 0 0-.24-.53c-.11-.1-.24-.18-.35-.23l-.32-.15-.02-.01-.35-.16C8.77 7.7 8.5 7.45 8.5 7a.9.9 0 0 1 .26-.6c.19-.19.55-.4 1.24-.4s1.05.21 1.24.4ZM10 13a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Z"]));
export const BookSearchFilled = ( /*#__PURE__*/createFluentIcon('BookSearchFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm5.59 7.88 1.26 1.27a.5.5 0 0 1-.7.7l-1.27-1.26a2.5 2.5 0 1 1 .7-.7ZM8 8.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Z"]));
export const BookSearchRegular = ( /*#__PURE__*/createFluentIcon('BookSearchRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8Zm-2.41 6.88a2.5 2.5 0 1 0-.7.7l1.26 1.27a.5.5 0 0 0 .7-.7L11.6 9.88ZM8 8.5a1.5 1.5 0 1 1 3 0 1.5 1.5 0 0 1-3 0Z"]));
export const BookStarColor = ( /*#__PURE__*/createFluentIcon('BookStarColor', "1em", `<path d="M4.5 15H16s-.5.5-.5 1.5.5 1 .5 1H5.5a1 1 0 0 1-1-1V15Z" fill="url(#ic_fluent_book_star_20_color__a)"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_star_20_color__b)"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_star_20_color__c)" fill-opacity=".3"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_star_20_color__d)" fill-opacity=".3"/><path d="M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Z" fill="url(#ic_fluent_book_star_20_color__e)" fill-opacity=".3"/><path d="M10.45 5.29a.5.5 0 0 0-.9 0l-.83 1.77-1.93.23a.5.5 0 0 0-.28.87l1.43 1.33-.38 1.91a.5.5 0 0 0 .73.53l1.71-.95 1.7.95a.5.5 0 0 0 .74-.53l-.38-1.91 1.43-1.33a.5.5 0 0 0-.28-.87l-1.93-.23-.83-1.77Z" fill="url(#ic_fluent_book_star_20_color__f)"/><defs><radialGradient id="ic_fluent_book_star_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(2 1.5 -.72656 .96875 10.5 11)"><stop stop-color="#171155"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_book_star_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(3.5 -2.5 1.44848 2.02787 11 9.5)"><stop stop-color="#171155"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_book_star_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(2 -2 1 1 9 11)"><stop stop-color="#171155"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><linearGradient id="ic_fluent_book_star_20_color__a" x1="10" y1="17" x2="10" y2="15" gradientUnits="userSpaceOnUse"><stop stop-color="#9DEAFF"/><stop offset=".72" stop-color="#58AAFE"/></linearGradient><linearGradient id="ic_fluent_book_star_20_color__b" x1="8.14" y1="4.99" x2="10.76" y2="22.18" gradientUnits="userSpaceOnUse"><stop stop-color="#20AC9D"/><stop offset="1" stop-color="#2052CB"/></linearGradient><linearGradient id="ic_fluent_book_star_20_color__f" x1="8.96" y1="6.27" x2="11.07" y2="13.68" gradientUnits="userSpaceOnUse"><stop stop-color="#FFE06B"/><stop offset="1" stop-color="#FF835C"/></linearGradient></defs>`, { color: true }));
export const BookStarFilled = ( /*#__PURE__*/createFluentIcon('BookStarFilled', "1em", ["M4 4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4Zm6.45 1.29a.5.5 0 0 0-.9 0l-.83 1.77-1.93.23a.5.5 0 0 0-.28.87l1.43 1.33-.38 1.91a.5.5 0 0 0 .73.53l1.71-.95 1.7.95a.5.5 0 0 0 .74-.53l-.38-1.91 1.43-1.33a.5.5 0 0 0-.28-.87l-1.93-.23-.83-1.77Zm-.94 2.44L10 6.7l.49 1.04a.5.5 0 0 0 .39.29l1.14.14-.84.78a.5.5 0 0 0-.15.46l.22 1.14-1-.56a.5.5 0 0 0-.5 0l-1 .56.22-1.14a.5.5 0 0 0-.15-.46l-.84-.78 1.14-.14a.5.5 0 0 0 .4-.29Z"]));
export const BookStarRegular = ( /*#__PURE__*/createFluentIcon('BookStarRegular', "1em", ["M4 16V4c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v11a1 1 0 0 1-1 1H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2ZM15 4a1 1 0 0 0-1-1H6a1 1 0 0 0-1 1v11h10V4Zm-4.55 1.29a.5.5 0 0 0-.9 0l-.83 1.77-1.93.23a.5.5 0 0 0-.28.87l1.43 1.33-.38 1.91a.5.5 0 0 0 .73.53l1.71-.95 1.7.95a.5.5 0 0 0 .74-.53l-.38-1.91 1.43-1.33a.5.5 0 0 0-.28-.87l-1.93-.23-.83-1.77Zm-.94 2.44L10 6.7l.49 1.04a.5.5 0 0 0 .39.29l1.14.14-.84.78a.5.5 0 0 0-.15.46l.22 1.14-1-.56a.5.5 0 0 0-.5 0l-1 .56.22-1.14a.5.5 0 0 0-.15-.46l-.84-.78 1.14-.14a.5.5 0 0 0 .4-.29Z"]));
export const BookTemplateFilled = ( /*#__PURE__*/createFluentIcon('BookTemplateFilled', "1em", ["M4.5 1A2.5 2.5 0 0 0 2 3.5v9A2.5 2.5 0 0 0 4.5 15H8V9H5.5a.5.5 0 0 1 0-1h2.67a3 3 0 0 1 .6-1H5.5a.5.5 0 0 1 0-1H16V3.5A2.5 2.5 0 0 0 13.5 1h-9ZM5 4.5c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5ZM18 9a2 2 0 0 0-2-2h-5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h6.5a.5.5 0 0 0 0-1H11a1 1 0 0 1-1-1h7.5a.5.5 0 0 0 .5-.5V9Zm-8 7V9a1 1 0 0 1 1-1h5a1 1 0 0 1 1 1v7h-7Z"]));
export const BookTemplateRegular = ( /*#__PURE__*/createFluentIcon('BookTemplateRegular', "1em", ["M2 3.5A2.5 2.5 0 0 1 4.5 1h9A2.5 2.5 0 0 1 16 3.5V6h-1V3.5c0-.83-.67-1.5-1.5-1.5h-9C3.67 2 3 2.67 3 3.5v9c0 .83.67 1.5 1.5 1.5H8v1H4.5A2.5 2.5 0 0 1 2 12.5v-9ZM5.5 6H11a3 3 0 0 0-2.24 1H5.5a.5.5 0 0 1 0-1Zm2.67 2H5.5a.5.5 0 0 0 0 1H8a3 3 0 0 1 .17-1ZM5.5 4a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-7ZM18 9a2 2 0 0 0-2-2h-5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h6.5a.5.5 0 0 0 0-1H11a1 1 0 0 1-1-1h7.5a.5.5 0 0 0 .5-.5V9Zm-8 7V9a1 1 0 0 1 1-1h5a1 1 0 0 1 1 1v7h-7Z"]));
export const BookThetaFilled = ( /*#__PURE__*/createFluentIcon('BookThetaFilled', "1em", ["M6 2a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6Zm1 7c0-1.06.3-2.04.83-2.77A2.7 2.7 0 0 1 10 5c.9 0 1.66.5 2.17 1.23.52.73.83 1.71.83 2.77s-.3 2.04-.83 2.77A2.7 2.7 0 0 1 10 13c-.9 0-1.66-.5-2.17-1.23A4.79 4.79 0 0 1 7 9Zm4.97.5c-.07.67-.3 1.25-.6 1.68-.4.54-.88.82-1.37.82-.49 0-.97-.28-1.36-.82a3.62 3.62 0 0 1-.61-1.68h3.94Zm0-1a3.62 3.62 0 0 0-.6-1.68C10.96 6.28 10.48 6 10 6c-.49 0-.97.28-1.36.82a3.62 3.62 0 0 0-.61 1.68h3.94Z"]));
export const BookThetaRegular = ( /*#__PURE__*/createFluentIcon('BookThetaRegular', "1em", ["M4 4v12c0 1.1.9 2 2 2h9.5a.5.5 0 0 0 0-1H6a1 1 0 0 1-1-1h10a1 1 0 0 0 1-1V4a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2Zm10-1a1 1 0 0 1 1 1v11H5V4a1 1 0 0 1 1-1h8ZM7 9c0-1.06.3-2.04.83-2.77A2.7 2.7 0 0 1 10 5c.9 0 1.66.5 2.17 1.23.52.73.83 1.71.83 2.77s-.3 2.04-.83 2.77A2.7 2.7 0 0 1 10 13c-.9 0-1.66-.5-2.17-1.23A4.79 4.79 0 0 1 7 9Zm4.97.5H8.03c.07.67.3 1.25.6 1.68.4.54.88.82 1.37.82.49 0 .97-.28 1.36-.82.31-.43.54-1.01.61-1.68Zm0-1a3.62 3.62 0 0 0-.6-1.68C10.96 6.28 10.48 6 10 6c-.49 0-.97.28-1.36.82a3.62 3.62 0 0 0-.61 1.68h3.94Z"]));
export const BookToolboxFilled = ( /*#__PURE__*/createFluentIcon('BookToolboxFilled', "1em", ["M12 3v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5V3h.5c.83 0 1.5.67 1.5 1.5V6h-2v-.5a.5.5 0 0 0-1 0V6h-3v-.5a.5.5 0 0 0-1 0V6h-2V4.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5V3h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5ZM17 7h2v1.5c0 .83-.67 1.5-1.5 1.5h-6A1.5 1.5 0 0 1 10 8.5V7h2v.5a.5.5 0 0 0 1 0V7h3v.5a.5.5 0 0 0 1 0V7Zm-5.96-4.96.01-.04H6a2 2 0 0 0-2 2v12c0 1.1.9 2 2 2h9.5a.5.5 0 1 0 0-1H6a1 1 0 0 1-1-1h10.5a.5.5 0 0 0 .5-.5V11h-4.5A2.5 2.5 0 0 1 9 8.5v-4a2.5 2.5 0 0 1 2.04-2.46Z"]));
export const BookToolboxRegular = ( /*#__PURE__*/createFluentIcon('BookToolboxRegular', "1em", ["M12 3v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5V3h.5c.83 0 1.5.67 1.5 1.5V6h-2v-.5a.5.5 0 0 0-1 0V6h-3v-.5a.5.5 0 0 0-1 0V6h-2V4.5c0-.83.67-1.5 1.5-1.5h.5Zm3.5-1h-2a.5.5 0 0 0-.5.5V3h3v-.5a.5.5 0 0 0-.5-.5ZM17 7h2v1.5c0 .83-.67 1.5-1.5 1.5h-6A1.5 1.5 0 0 1 10 8.5V7h2v.5a.5.5 0 0 0 1 0V7h3v.5a.5.5 0 0 0 1 0V7ZM6 2h5.05v.04A2.5 2.5 0 0 0 9.5 3H6a1 1 0 0 0-1 1v11h10v-4h1v4.5a.5.5 0 0 1-.5.5H5a1 1 0 0 0 1 1h9.5a.5.5 0 0 1 0 1H6a2 2 0 0 1-2-2V4c0-1.1.9-2 2-2Z"]));
export const BookmarkColor = ( /*#__PURE__*/createFluentIcon('BookmarkColor', "1em", `<path d="M4 4.5A2.5 2.5 0 0 1 6.5 2h7A2.5 2.5 0 0 1 16 4.5v13a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4v-13Z" fill="url(#ic_fluent_bookmark_20_color__a)"/><defs><linearGradient id="ic_fluent_bookmark_20_color__a" x1="4" y1="3.36" x2="12.65" y2="14.35" gradientUnits="userSpaceOnUse"><stop stop-color="#F97DBD"/><stop offset="1" stop-color="#D7257D"/></linearGradient></defs>`, { color: true }));
export const BookmarkFilled = ( /*#__PURE__*/createFluentIcon('BookmarkFilled', "1em", ["M4 4.5A2.5 2.5 0 0 1 6.5 2h7A2.5 2.5 0 0 1 16 4.5v13a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4v-13Z"]));
export const BookmarkRegular = ( /*#__PURE__*/createFluentIcon('BookmarkRegular', "1em", ["M4 4.5A2.5 2.5 0 0 1 6.5 2h7A2.5 2.5 0 0 1 16 4.5v13a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4v-13ZM6.5 3C5.67 3 5 3.67 5 4.5v12.02l4.7-3.42a.5.5 0 0 1 .6 0l4.7 3.42V4.5c0-.83-.67-1.5-1.5-1.5h-7Z"]));
export const BookmarkAddFilled = ( /*#__PURE__*/createFluentIcon('BookmarkAddFilled', "1em", ["M19 5.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V5h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V6h1.5a.5.5 0 0 0 0-1H15V3.5Zm-.5 7.5a5.5 5.5 0 0 0 1.5-.2v6.7a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4v-13A2.5 2.5 0 0 1 6.5 2h3.76a5.5 5.5 0 0 0 4.24 9Z"]));
export const BookmarkAddRegular = ( /*#__PURE__*/createFluentIcon('BookmarkAddRegular', "1em", ["M19 5.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V5h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V6h1.5a.5.5 0 0 0 0-1H15V3.5Zm0 13.02v-5.54c.34-.03.68-.1 1-.19v6.71a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4v-13A2.5 2.5 0 0 1 6.5 2h3.76c-.26.3-.48.64-.66 1H6.5C5.67 3 5 3.67 5 4.5v12.02l4.7-3.42a.5.5 0 0 1 .6 0l4.7 3.42Z"]));
export const BookmarkMultipleFilled = ( /*#__PURE__*/createFluentIcon('BookmarkMultipleFilled', "1em", ["M6.27 3A2 2 0 0 1 8 2h4.5A3.5 3.5 0 0 1 16 5.5v10a.5.5 0 0 1-.78.42l-.22-.15V5.5A2.5 2.5 0 0 0 12.5 3H6.27ZM6 4a2 2 0 0 0-2 2v11.5a.5.5 0 0 0 .78.42L9 15.1l4.22 2.82a.5.5 0 0 0 .78-.42V6a2 2 0 0 0-2-2H6Z"]));
export const BookmarkMultipleRegular = ( /*#__PURE__*/createFluentIcon('BookmarkMultipleRegular', "1em", ["M6.27 3A2 2 0 0 1 8 2h4.5A3.5 3.5 0 0 1 16 5.5v10a.5.5 0 0 1-.78.42l-.22-.15V5.5A2.5 2.5 0 0 0 12.5 3H6.27ZM6 4a2 2 0 0 0-2 2v11.5a.5.5 0 0 0 .78.42L9 15.1l4.22 2.82a.5.5 0 0 0 .78-.42V6a2 2 0 0 0-2-2H6ZM5 6a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v10.57l-3.72-2.49a.5.5 0 0 0-.56 0L5 16.57V6Z"]));
export const BookmarkOffFilled = ( /*#__PURE__*/createFluentIcon('BookmarkOffFilled', "1em", ["m16 16.7 1.15 1.15a.5.5 0 0 0 .7-.7l-15-15a.5.5 0 1 0-.7.7L4 4.71V17.5a.5.5 0 0 0 .8.4l5.2-3.78 5.2 3.78a.5.5 0 0 0 .8-.4v-.8Zm0-12.2v9.38L4.8 2.68A2.5 2.5 0 0 1 6.5 2h7A2.5 2.5 0 0 1 16 4.5Z"]));
export const BookmarkOffRegular = ( /*#__PURE__*/createFluentIcon('BookmarkOffRegular', "1em", ["M4 4.7 2.15 2.86a.5.5 0 1 1 .7-.7l15 15a.5.5 0 0 1-.7.7L16 16.71v.79a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4V4.7Zm11 11L5 5.7v10.82l4.7-3.42a.5.5 0 0 1 .6 0l4.7 3.42v-.81Zm0-11.2v8.38l1 1V4.5A2.5 2.5 0 0 0 13.5 2h-7a2.5 2.5 0 0 0-1.7.67l.7.71a1.5 1.5 0 0 1 1-.38h7c.83 0 1.5.67 1.5 1.5Z"]));
export const BookmarkSearchFilled = ( /*#__PURE__*/createFluentIcon('BookmarkSearchFilled', "1em", ["M15.6 7.3a3.5 3.5 0 1 1 .7-.7l2.55 2.55a.5.5 0 0 1-.7.7L15.6 7.3Zm.4-2.8a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Zm0 4.62v8.38a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4v-13A2.5 2.5 0 0 1 6.5 2h3.26a4.5 4.5 0 0 0 5.68 6.56l.56.56Z"]));
export const BookmarkSearchRegular = ( /*#__PURE__*/createFluentIcon('BookmarkSearchRegular', "1em", ["M15.6 7.3a3.5 3.5 0 1 1 .7-.7l2.55 2.55a.5.5 0 0 1-.7.7L15.6 7.3Zm.4-2.8a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Zm0 4.62v8.38a.5.5 0 0 1-.8.4L10 14.12 4.8 17.9a.5.5 0 0 1-.8-.4v-13A2.5 2.5 0 0 1 6.5 2h3.26c-.2.3-.38.64-.5 1H6.5C5.67 3 5 3.67 5 4.5v12.02l4.7-3.42a.5.5 0 0 1 .6 0l4.7 3.42V8.74c.15-.05.3-.11.44-.18l.56.56Z"]));
export const BorderAllFilled = ( /*#__PURE__*/createFluentIcon('BorderAllFilled', "1em", ["M6.25 4.5c-.97 0-1.75.78-1.75 1.75v3h4.75V4.5h-3Zm4.5 0v4.75h4.75v-3c0-.97-.78-1.75-1.75-1.75h-3Zm4.75 6.25h-4.75v4.75h3c.97 0 1.75-.78 1.75-1.75v-3ZM9.25 15.5v-4.75H4.5v3c0 .97.78 1.75 1.75 1.75h3ZM3 6.25C3 4.45 4.46 3 6.25 3h7.5C15.55 3 17 4.46 17 6.25v7.5c0 1.8-1.46 3.25-3.25 3.25h-7.5A3.25 3.25 0 0 1 3 13.75v-7.5Z"]));
export const BorderAllRegular = ( /*#__PURE__*/createFluentIcon('BorderAllRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-2a2 2 0 0 0-2 2v3.5h5.5V4H6Zm4.5 0v5.5H16V6a2 2 0 0 0-2-2h-3.5Zm5.5 6.5h-5.5V16H14a2 2 0 0 0 2-2v-3.5ZM9.5 16v-5.5H4V14c0 1.1.9 2 2 2h3.5Z"]));
export const BorderBottomFilled = ( /*#__PURE__*/createFluentIcon('BorderBottomFilled', "1em", ["M8 3.75c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 8 3.75Zm.71 11.75a.7.7 0 0 1 .04 0h2.5a.7.7 0 0 1 .04 0H14a1.5 1.5 0 0 0 1.43-1.03v-.01a.75.75 0 0 1 1.38.58A3 3 0 0 1 14 17H6a3 3 0 0 1-2.81-1.96.75.75 0 1 1 1.41-.49c.22.56.77.95 1.4.95h2.71ZM4.61 5.45a1.5 1.5 0 0 1 .93-.88.75.75 0 0 0-.58-1.38 3 3 0 0 0-1.77 1.77.75.75 0 1 0 1.41.49Zm9.94-.85a1.5 1.5 0 0 1 .88.94.75.75 0 0 0 1.38-.58 3 3 0 0 0-1.77-1.77.75.75 0 1 0-.5 1.41ZM3 11.25a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-1.5 0v2.5Zm13.25.75a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 1 1.5 0v2.5c0 .41-.34.75-.75.75Z"]));
export const BorderBottomRegular = ( /*#__PURE__*/createFluentIcon('BorderBottomRegular', "1em", ["M8.5 3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM5.54 4.05a2 2 0 0 0-1.5 1.55.5.5 0 0 1-.59.4.5.5 0 0 1-.38-.66 3 3 0 0 1 2.34-2.29.5.5 0 0 1 .6.4.5.5 0 0 1-.47.6ZM3.07 14.66a.5.5 0 0 1 .38-.66.5.5 0 0 1 .6.46A2 2 0 0 0 6 16h8a2 2 0 0 0 1.95-1.6.5.5 0 0 1 .6-.4.5.5 0 0 1 .38.66A3 3 0 0 1 14 17H6a3 3 0 0 1-2.93-2.34ZM14.6 3.06a3 3 0 0 1 2.36 2.36.5.5 0 0 1-.4.58.5.5 0 0 1-.6-.46 2 2 0 0 0-1.55-1.5.5.5 0 0 1-.4-.59.5.5 0 0 1 .6-.4ZM16.5 12a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v3a.5.5 0 0 1-.5.5ZM3 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3Z"]));
export const BorderBottomDoubleFilled = ( /*#__PURE__*/createFluentIcon('BorderBottomDoubleFilled', "1em", ["M8 3.75c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 8 3.75Zm-2.55.85a1.5 1.5 0 0 0-.88.94.75.75 0 0 1-1.38-.58 3 3 0 0 1 1.77-1.77.75.75 0 1 1 .5 1.41Zm9.95.85a1.5 1.5 0 0 0-.94-.88.75.75 0 0 1 .58-1.38 3 3 0 0 1 1.78 1.77h-.01a.75.75 0 1 1-1.41.49ZM3.75 11a.75.75 0 0 1-.75-.75v-1.5a.75.75 0 0 1 1.5 0v1.5c0 .41-.34.75-.75.75Zm11.75-.75a.75.75 0 0 0 1.5 0v-1.5a.75.75 0 0 0-1.5 0v1.5Zm-12.5 6c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75ZM3.75 13a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75Z"]));
export const BorderBottomDoubleRegular = ( /*#__PURE__*/createFluentIcon('BorderBottomDoubleRegular', "1em", ["M8.5 3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM4.05 5.54a2 2 0 0 1 1.55-1.5.5.5 0 0 0 .4-.59.5.5 0 0 0-.66-.38 3 3 0 0 0-2.29 2.34.5.5 0 0 0 .4.6.5.5 0 0 0 .6-.47ZM14.6 3.05a3 3 0 0 1 2.36 2.36.5.5 0 0 1-.4.6.5.5 0 0 1-.6-.47 2 2 0 0 0-1.55-1.5.5.5 0 0 1-.4-.59.5.5 0 0 1 .6-.4ZM16.5 12a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v3a.5.5 0 0 1-.5.5ZM3 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3Zm0 5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm.5-2.5a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Z"]));
export const BorderBottomThickFilled = ( /*#__PURE__*/createFluentIcon('BorderBottomThickFilled', "1em", ["M9 3a1 1 0 0 0 0 2h2a1 1 0 1 0 0-2H9Zm-4.64.5a1 1 0 1 1 1.16 1.62 1 1 0 0 0-.4.4 1 1 0 0 1-1.84-.33 1 1 0 0 1 .22-.83c.22-.35.51-.64.85-.87ZM6 15a1 1 0 0 1-.88-.52 1 1 0 0 0-1.84.33 1 1 0 0 0 .22.83A3 3 0 0 0 6 17h8a3 3 0 0 0 2.5-1.35 1 1 0 1 0-1.62-1.17A1 1 0 0 1 14 15H6Zm9.64-11.5a1 1 0 1 0-1.16 1.62c.17.1.3.23.4.4a1 1 0 0 0 1.84-.33 1 1 0 0 0-.22-.83 3.02 3.02 0 0 0-.85-.87ZM4 12a1 1 0 0 1-1-1V9a1 1 0 0 1 2 0v2a1 1 0 0 1-1 1Zm11-1a1 1 0 1 0 2 0V9a1 1 0 1 0-2 0v2Z"]));
export const BorderBottomThickRegular = ( /*#__PURE__*/createFluentIcon('BorderBottomThickRegular', "1em", ["M8 3.75c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 8 3.75Zm.71 11.75a.7.7 0 0 1 .04 0h2.5a.7.7 0 0 1 .04 0H14a1.5 1.5 0 0 0 1.43-1.03v-.01a.75.75 0 0 1 1.38.58A3 3 0 0 1 14 17H6a3 3 0 0 1-2.81-1.96.75.75 0 1 1 1.41-.49c.22.56.77.95 1.4.95h2.71ZM4.61 5.45a1.5 1.5 0 0 1 .93-.88.75.75 0 0 0-.58-1.38 3 3 0 0 0-1.77 1.77.75.75 0 1 0 1.41.49Zm9.94-.85a1.5 1.5 0 0 1 .88.94.75.75 0 0 0 1.38-.58 3 3 0 0 0-1.77-1.77.75.75 0 1 0-.5 1.41ZM3 11.25a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-1.5 0v2.5Zm13.25.75a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 1 1.5 0v2.5c0 .41-.34.75-.75.75Z"]));
export const BorderInsideFilled = ( /*#__PURE__*/createFluentIcon('BorderInsideFilled', "1em", ["M8 3.75c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5A.75.75 0 0 1 8 3.75Zm0 12.5c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75ZM4.6 5.45a1.5 1.5 0 0 1 .94-.88.75.75 0 0 0-.58-1.38 3 3 0 0 0-1.77 1.77.75.75 0 1 0 1.41.49Zm9.95-.85a1.5 1.5 0 0 1 .88.94.75.75 0 0 0 1.38-.58 3 3 0 0 0-1.77-1.77.75.75 0 1 0-.5 1.41ZM3 11.25a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-1.5 0v2.5Zm13.25.75a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 1 1.5 0v2.5c0 .41-.34.75-.75.75ZM4.6 14.55a1.5 1.5 0 0 0 .94.88.75.75 0 0 1-.58 1.38 3 3 0 0 1-1.77-1.77.75.75 0 1 1 1.41-.49Zm9.95.85a1.5 1.5 0 0 0 .88-.94.75.75 0 0 1 1.38.58 3 3 0 0 1-1.77 1.77.75.75 0 1 1-.5-1.41Zm-3.8-9.15a.75.75 0 0 0-1.5 0v3h-3a.75.75 0 0 0 0 1.5h3v3a.75.75 0 0 0 1.5 0v-3h3a.75.75 0 0 0 0-1.5h-3v-3Z"]));
export const BorderInsideRegular = ( /*#__PURE__*/createFluentIcon('BorderInsideRegular', "1em", ["M8.5 3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3ZM4.05 5.54a2 2 0 0 1 1.55-1.5.5.5 0 0 0 .4-.59.5.5 0 0 0-.66-.38 3 3 0 0 0-2.29 2.34.5.5 0 0 0 .4.6.5.5 0 0 0 .6-.47Zm0 8.92a2 2 0 0 0 1.55 1.5.5.5 0 0 1 .4.59.5.5 0 0 1-.66.38 3 3 0 0 1-2.29-2.34.5.5 0 0 1 .4-.6.5.5 0 0 1 .6.47ZM14.66 3.07a.5.5 0 0 0-.66.38.5.5 0 0 0 .46.6 2 2 0 0 1 1.5 1.55.5.5 0 0 0 .59.4.5.5 0 0 0 .38-.66 3 3 0 0 0-2.27-2.27Zm1.29 11.4a2 2 0 0 1-1.55 1.48.5.5 0 0 0-.4.6.5.5 0 0 0 .66.38 3 3 0 0 0 2.29-2.34.5.5 0 0 0-.4-.6.5.5 0 0 0-.6.47ZM16.5 12a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v3a.5.5 0 0 1-.5.5ZM3 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3Zm5 5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm2.5-11a.5.5 0 0 0-1 0v4h-4a.5.5 0 0 0 0 1h4v4a.5.5 0 0 0 1 0v-4h4a.5.5 0 0 0 0-1h-4v-4Z"]));
export const BorderLeftFilled = ( /*#__PURE__*/createFluentIcon('BorderLeftFilled', "1em", ["M16.25 8c.41 0 .75.34.75.75v2.5a.75.75 0 0 1-1.5 0v-2.5c0-.41.34-.75.75-.75ZM3 11.27V14a3 3 0 0 0 1.96 2.81.75.75 0 0 0 .58-1.38A1.5 1.5 0 0 1 4.5 14V6a1.5 1.5 0 0 1 1.03-1.43.75.75 0 0 0-.58-1.38A3 3 0 0 0 3 6v5.27ZM14.55 4.6a1.5 1.5 0 0 1 .88.94.75.75 0 0 0 1.38-.58 3 3 0 0 0-1.77-1.77.75.75 0 1 0-.49 1.41Zm.85 9.95a1.5 1.5 0 0 1-.94.88.75.75 0 0 0 .58 1.38 3 3 0 0 0 1.77-1.77.75.75 0 1 0-1.41-.5ZM8.75 3a.75.75 0 0 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5ZM8 16.25c0-.41.34-.75.75-.75h2.5a.75.75 0 0 1 0 1.5h-2.5a.75.75 0 0 1-.75-.75Z"]));
export const BorderLeftRegular = ( /*#__PURE__*/createFluentIcon('BorderLeftRegular', "1em", ["M17 8.5a.5.5 0 0 0-1 0v3a.5.5 0 0 0 1 0v-3Zm-1.05-2.96a2 2 0 0 0-1.55-1.5.5.5 0 0 1-.4-.59.5.5 0 0 1 .66-.38 3 3 0 0 1 2.29 2.34.5.5 0 0 1-.4.6.5.5 0 0 1-.6-.47ZM5.34 3.07a.5.5 0 0 1 .66.38.5.5 0 0 1-.46.6A2 2 0 0 0 4 6v8a2 2 0 0 0 1.6 1.95.5.5 0 0 1 .4.6.5.5 0 0 1-.66.38A3 3 0 0 1 3 14V6a3 3 0 0 1 2.34-2.93Zm11.6 11.52a3 3 0 0 1-2.36 2.36.5.5 0 0 1-.58-.4.5.5 0 0 1 .46-.6 2 2 0 0 0 1.5-1.55.5.5 0 0 1 .59-.4.5.5 0 0 1 .4.6ZM8 16.5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5ZM8.5 3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const BorderLeftRightFilled = ( /*#__PURE__*/createFluentIcon('BorderLeftRightFilled', "1em", ["M15.5 6a1.5 1.5 0 0 0-1.04-1.43.75.75 0 0 1 .58-1.38A3 3 0 0 1 17 6v8a3 3 0 0 1-1.96 2.82.75.75 0 0 1-.58-1.39l.07-.03c.57-.21.97-.76.97-1.4V6ZM8.75 3a.75.75 0 1 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5Zm0 12.5a.75.75 0 1 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5ZM5.45 4.6A1.5 1.5 0 0 0 4.5 6v8a1.5 1.5 0 0 0 1.03 1.43h.01a.75.75 0 0 1-.58 1.38A3 3 0 0 1 3 14.02V6a3 3 0 0 1 1.96-2.82.75.75 0 1 1 .49 1.42Z"]));
export const BorderLeftRightRegular = ( /*#__PURE__*/createFluentIcon('BorderLeftRightRegular', "1em", ["M14.66 3.07a.5.5 0 0 0-.66.38.5.5 0 0 0 .46.6A2 2 0 0 1 16 6v8a2 2 0 0 1-1.6 1.95.5.5 0 0 0-.4.6.5.5 0 0 0 .66.38A3 3 0 0 0 17 14V6a3 3 0 0 0-2.34-2.93Zm-9.32 0a.5.5 0 0 1 .66.38.5.5 0 0 1-.46.6A2 2 0 0 0 4 6v8a2 2 0 0 0 1.6 1.95.5.5 0 0 1 .4.6.5.5 0 0 1-.66.38A3 3 0 0 1 3 14V6a3 3 0 0 1 2.34-2.93ZM8 16.5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5ZM8.5 3a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const BorderNoneFilled = ( /*#__PURE__*/createFluentIcon('BorderNoneFilled', "1em", ["M8.75 3a.75.75 0 0 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5Zm0 12.5a.75.75 0 0 0 0 1.5h2.5a.75.75 0 0 0 0-1.5h-2.5ZM5.45 4.6a1.5 1.5 0 0 0-.88.94.75.75 0 0 1-1.38-.58 3 3 0 0 1 1.77-1.77.75.75 0 1 1 .5 1.41Zm9.95.85a1.5 1.5 0 0 0-.94-.88.75.75 0 0 1 .58-1.38 3 3 0 0 1 1.78 1.77h-.01a.75.75 0 1 1-1.41.49ZM3.75 12a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 1 1.5 0v2.5c0 .41-.34.75-.75.75Zm11.75-.75a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-1.5 0v2.5ZM5.45 15.4a1.5 1.5 0 0 1-.88-.94.75.75 0 0 0-1.38.58 3 3 0 0 0 1.77 1.77.75.75 0 1 0 .5-1.41Zm9.95-.85a1.5 1.5 0 0 1-.94.88.75.75 0 0 0 .58 1.38 3 3 0 0 0 1.78-1.77h-.01a.75.75 0 1 0-1.41-.49Z"]));
export const BorderNoneRegular = ( /*#__PURE__*/createFluentIcon('BorderNoneRegular', "1em", ["M8 3.5c0-.28.22-.5.5-.5h3a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5Zm-2.46.55a2 2 0 0 0-1.5 1.55.5.5 0 0 1-.59.4.5.5 0 0 1-.38-.66 3 3 0 0 1 2.34-2.29.5.5 0 0 1 .6.4.5.5 0 0 1-.47.6Zm0 11.9a2 2 0 0 1-1.5-1.55.5.5 0 0 0-.59-.4.5.5 0 0 0-.38.66 3 3 0 0 0 2.34 2.29.5.5 0 0 0 .6-.4.5.5 0 0 0-.47-.6Zm9.05-12.9a3 3 0 0 1 2.36 2.36.5.5 0 0 1-.4.6.5.5 0 0 1-.6-.47 2 2 0 0 0-1.55-1.5.5.5 0 0 1-.4-.59.5.5 0 0 1 .6-.4Zm-.13 12.9a2 2 0 0 0 1.5-1.55.5.5 0 0 1 .59-.4.5.5 0 0 1 .38.66 3 3 0 0 1-2.34 2.29.5.5 0 0 1-.6-.4.5.5 0 0 1 .47-.6ZM16 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3ZM3.5 12a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v3a.5.5 0 0 1-.5.5Zm5 4a.5.5 0 0 0 0 1h3a.5.5 0 0 0 0-1h-3Z"]));
export const BorderOutsideFilled = ( /*#__PURE__*/createFluentIcon('BorderOutsideFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-1.5c-.83 0-1.5.67-1.5 1.5v8c0 .83.67 1.5 1.5 1.5h8c.83 0 1.5-.67 1.5-1.5V6c0-.83-.67-1.5-1.5-1.5H6Z"]));
export const BorderOutsideRegular = ( /*#__PURE__*/createFluentIcon('BorderOutsideRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-2a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H6Z"]));
export const BorderOutsideThickFilled = ( /*#__PURE__*/createFluentIcon('BorderOutsideThickFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6Z"]));
export const BorderOutsideThickRegular = ( /*#__PURE__*/createFluentIcon('BorderOutsideThickRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6Zm3-1.5c-.83 0-1.5.67-1.5 1.5v8c0 .83.67 1.5 1.5 1.5h8c.83 0 1.5-.67 1.5-1.5V6c0-.83-.67-1.5-1.5-1.5H6Z"]));
export const BorderRightFilled = ( /*#__PURE__*/createFluentIcon('BorderRightFilled', "1em", ["M3.75 12a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 1 1.5 0v2.5c0 .41-.34.75-.75.75ZM17 8.73V6a3 3 0 0 0-1.96-2.81.75.75 0 1 0-.58 1.38l.07.03c.57.21.97.76.97 1.4v8a1.5 1.5 0 0 1-1.04 1.43.75.75 0 0 0 .58 1.38A3 3 0 0 0 17 14V8.73ZM5.45 15.4a1.5 1.5 0 0 1-.88-.94.75.75 0 0 0-1.38.58 3 3 0 0 0 1.77 1.77.75.75 0 1 0 .49-1.41ZM4.6 5.45a1.5 1.5 0 0 1 .94-.88.75.75 0 0 0-.58-1.38 3 3 0 0 0-1.77 1.77.75.75 0 1 0 1.41.5ZM11.25 17a.75.75 0 0 0 0-1.5h-2.5a.75.75 0 0 0 0 1.5h2.5ZM12 3.75c0 .41-.34.75-.75.75h-2.5a.75.75 0 0 1 0-1.5h2.5c.41 0 .75.34.75.75Z"]));
export const BorderRightRegular = ( /*#__PURE__*/createFluentIcon('BorderRightRegular', "1em", ["M3 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3Zm1.05 2.96a2 2 0 0 0 1.55 1.5.5.5 0 0 1 .4.59.5.5 0 0 1-.66.38 3 3 0 0 1-2.29-2.34.5.5 0 0 1 .4-.6.5.5 0 0 1 .6.47Zm10.61 2.47a.5.5 0 0 1-.66-.38.5.5 0 0 1 .46-.6A2 2 0 0 0 16 14V6a2 2 0 0 0-1.6-1.95.5.5 0 0 1-.4-.6.5.5 0 0 1 .66-.38A3 3 0 0 1 17 6v8a3 3 0 0 1-2.34 2.93ZM3.06 5.4a3 3 0 0 1 2.36-2.36.5.5 0 0 1 .58.4.5.5 0 0 1-.46.6 2 2 0 0 0-1.5 1.55.5.5 0 0 1-.59.4.5.5 0 0 1-.4-.59ZM12 3.5a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1 0-1h3c.28 0 .5.22.5.5ZM11.5 17a.5.5 0 0 0 0-1h-3a.5.5 0 0 0 0 1h3Z"]));
export const BorderTopFilled = ( /*#__PURE__*/createFluentIcon('BorderTopFilled', "1em", ["M12 16.25c0 .41-.34.75-.75.75h-2.5a.75.75 0 0 1 0-1.5h2.5c.41 0 .75.34.75.75ZM8.73 3H6a3 3 0 0 0-2.81 1.96.75.75 0 0 0 1.38.58l.03-.07A1.5 1.5 0 0 1 6 4.5h8a1.5 1.5 0 0 1 1.43 1.04.75.75 0 0 0 1.38-.58A3 3 0 0 0 14 3H8.73Zm6.67 11.55a1.5 1.5 0 0 1-.94.88.75.75 0 0 0 .58 1.38 3 3 0 0 0 1.77-1.77.75.75 0 1 0-1.41-.49Zm-9.95.85a1.5 1.5 0 0 1-.88-.94.75.75 0 0 0-1.38.58 3 3 0 0 0 1.77 1.77.75.75 0 1 0 .5-1.41ZM17 8.75a.75.75 0 0 0-1.5 0v2.5a.75.75 0 0 0 1.5 0v-2.5ZM3.75 8c.41 0 .75.34.75.75v2.5a.75.75 0 0 1-1.5 0v-2.5c0-.41.34-.75.75-.75Z"]));
export const BorderTopRegular = ( /*#__PURE__*/createFluentIcon('BorderTopRegular', "1em", ["M11.5 17a.5.5 0 0 0 0-1h-3a.5.5 0 0 0 0 1h3Zm2.96-1.05a2 2 0 0 0 1.5-1.55.5.5 0 0 1 .59-.4.5.5 0 0 1 .38.66 3 3 0 0 1-2.34 2.29.5.5 0 0 1-.6-.4.5.5 0 0 1 .47-.6Zm2.47-10.61a.5.5 0 1 1-.98.2A2 2 0 0 0 14 4H6a2 2 0 0 0-1.95 1.6.5.5 0 0 1-.6.4.5.5 0 0 1-.38-.66A3 3 0 0 1 6 3h8a3 3 0 0 1 2.93 2.34ZM5.4 16.94a3 3 0 0 1-2.36-2.36.5.5 0 0 1 .4-.58.5.5 0 0 1 .6.46 2 2 0 0 0 1.55 1.5.5.5 0 0 1 .4.59.5.5 0 0 1-.59.4ZM3.5 8c.28 0 .5.22.5.5v3a.5.5 0 0 1-1 0v-3c0-.28.22-.5.5-.5Zm13.5.5a.5.5 0 0 0-1 0v3a.5.5 0 0 0 1 0v-3Z"]));
export const BorderTopBottomFilled = ( /*#__PURE__*/createFluentIcon('BorderTopBottomFilled', "1em", ["M6 4.5a1.5 1.5 0 0 0-1.43 1.04.75.75 0 0 1-1.38-.58A3 3 0 0 1 6 3h8a3 3 0 0 1 2.81 1.96.75.75 0 0 1-1.38.58A1.5 1.5 0 0 0 14 4.5H6Zm-3 6.75a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-1.5 0v2.5Zm12.5 0a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-1.5 0v2.5Zm-10.9 3.3c.22.56.77.95 1.4.95h8a1.5 1.5 0 0 0 1.43-1.03v-.01a.75.75 0 0 1 1.38.58A3 3 0 0 1 14 17H6a3 3 0 0 1-2.81-1.96.75.75 0 1 1 1.41-.49Z"]));
export const BorderTopBottomRegular = ( /*#__PURE__*/createFluentIcon('BorderTopBottomRegular', "1em", ["M3.07 5.34a.5.5 0 0 0 .38.66.5.5 0 0 0 .6-.46A2 2 0 0 1 6 4h8a2 2 0 0 1 1.95 1.6.5.5 0 0 0 .6.4.5.5 0 0 0 .38-.66A3 3 0 0 0 14 3H6a3 3 0 0 0-2.93 2.34Zm0 9.32a.5.5 0 0 1 .38-.66.5.5 0 0 1 .6.46A2 2 0 0 0 6 16h8a2 2 0 0 0 1.95-1.6.5.5 0 0 1 .6-.4.5.5 0 0 1 .38.66A3 3 0 0 1 14 17H6a3 3 0 0 1-2.93-2.34ZM16.5 12a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v3a.5.5 0 0 1-.5.5ZM3 11.5a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3Z"]));
export const BorderTopBottomDoubleFilled = ( /*#__PURE__*/createFluentIcon('BorderTopBottomDoubleFilled', "1em", ["M6 4.5a1.5 1.5 0 0 0-1.43 1.04.75.75 0 0 1-1.38-.58A3 3 0 0 1 6 3h8a3 3 0 0 1 2.81 1.96.75.75 0 0 1-1.38.58A1.5 1.5 0 0 0 14 4.5H6ZM3.75 11a.75.75 0 0 1-.75-.75v-1.5a.75.75 0 0 1 1.5 0v1.5c0 .41-.34.75-.75.75Zm12.5 0a.75.75 0 0 1-.75-.75v-1.5a.75.75 0 0 1 1.5 0v1.5c0 .41-.34.75-.75.75Zm-12.5 4.5a.75.75 0 0 0 0 1.5h12.5a.75.75 0 0 0 0-1.5H3.75ZM3 13.75c0-.41.34-.75.75-.75h12.5a.75.75 0 0 1 0 1.5H3.75a.75.75 0 0 1-.75-.75Z"]));
export const BorderTopBottomDoubleRegular = ( /*#__PURE__*/createFluentIcon('BorderTopBottomDoubleRegular', "1em", ["M3.05 5.41A3 3 0 0 1 6 3h8a3 3 0 0 1 2.95 2.41.5.5 0 0 1-.4.6.5.5 0 0 1-.6-.47A2 2 0 0 0 14 4H6a2 2 0 0 0-1.95 1.6.5.5 0 0 1-.6.4.5.5 0 0 1-.4-.59ZM16.5 12a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 1 0v3a.5.5 0 0 1-.5.5Zm-13 4a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM3 14.5c0-.28.22-.5.5-.5h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1-.5-.5Zm0-3a.5.5 0 0 0 1 0v-3a.5.5 0 0 0-1 0v3Z"]));
export const BorderTopBottomThickFilled = ( /*#__PURE__*/createFluentIcon('BorderTopBottomThickFilled', "1em", ["M5.12 5.52A1 1 0 0 1 6 5h8a1 1 0 0 1 .88.52 1 1 0 0 0 1.84-.33 1 1 0 0 0-.22-.83A3 3 0 0 0 14 3H6a3 3 0 0 0-2.5 1.35 1 1 0 1 0 1.62 1.17Zm0 8.96A1 1 0 0 0 6 15h8a1 1 0 0 0 .88-.52 1 1 0 0 1 1.84.33 1 1 0 0 1-.22.83A3 3 0 0 1 14 17H6a3 3 0 0 1-2.5-1.35 1 1 0 1 1 1.62-1.17ZM4 12a1 1 0 0 1-1-1V9a1 1 0 1 1 2 0v2a1 1 0 0 1-1 1Zm11-1a1 1 0 0 0 2 0V9a1 1 0 1 0-2 0v2Z"]));
export const BorderTopBottomThickRegular = ( /*#__PURE__*/createFluentIcon('BorderTopBottomThickRegular', "1em", ["M6 4.5a1.5 1.5 0 0 0-1.43 1.04.75.75 0 0 1-1.38-.58A3 3 0 0 1 6 3h8a3 3 0 0 1 2.81 1.96.75.75 0 0 1-1.38.58A1.5 1.5 0 0 0 14 4.5H6ZM3.75 12a.75.75 0 0 1-.75-.75v-2.5a.75.75 0 0 1 1.5 0v2.5c0 .41-.34.75-.75.75ZM14 15.5H6a1.5 1.5 0 0 1-1.43-1.04.75.75 0 0 0-1.38.58A3 3 0 0 0 6 17h8a3 3 0 0 0 2.81-1.96.75.75 0 0 0-1.38-.58l-.03.08a1.5 1.5 0 0 1-1.4.96Zm1.5-4.25a.75.75 0 0 0 1.5 0v-2.5a.75.75 0 0 0-1.5 0v2.5Z"]));
export const BotColor = ( /*#__PURE__*/createFluentIcon('BotColor', "1em", `<path d="M10.25 18c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Z" fill="url(#ic_fluent_bot_20_color__a)"/><path d="M10.25 18c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Z" fill="url(#ic_fluent_bot_20_color__b)"/><path d="M10.5 2.5a.5.5 0 0 0-1 0v1h1v-1Z" fill="url(#ic_fluent_bot_20_color__c)"/><path d="M5 4.5C5 3.67 5.67 3 6.5 3h7c.83 0 1.5.67 1.5 1.5v4c0 .83-.67 1.5-1.5 1.5h-7A1.5 1.5 0 0 1 5 8.5v-4Z" fill="url(#ic_fluent_bot_20_color__d)"/><path d="M12 5.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z" fill="url(#ic_fluent_bot_20_color__e)"/><path d="M7 6.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z" fill="url(#ic_fluent_bot_20_color__f)"/><defs><linearGradient id="ic_fluent_bot_20_color__b" x1="10" y1="10.73" x2="12.94" y2="21.71" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_bot_20_color__c" x1="9.48" y1="2" x2="10.53" y2="3.23" gradientUnits="userSpaceOnUse"><stop stop-color="#8B52F4"/><stop offset="1" stop-color="#3D35B1"/></linearGradient><linearGradient id="ic_fluent_bot_20_color__e" x1="11.47" y1="5.58" x2="12.99" y2="8.19" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#F9DCFA"/></linearGradient><linearGradient id="ic_fluent_bot_20_color__f" x1="7.47" y1="5.58" x2="8.99" y2="8.19" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#F9DCFA"/></linearGradient><radialGradient id="ic_fluent_bot_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(15.59372 9.14999 -14.57328 24.83628 .5 9.5)"><stop stop-color="#F08AF4"/><stop offset=".54" stop-color="#9C6CFE"/><stop offset="1" stop-color="#4E44DB"/></radialGradient><radialGradient id="ic_fluent_bot_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(39.05 .75 2.11) scale(16.9824 32.4423)"><stop stop-color="#F08AF4"/><stop offset=".54" stop-color="#9C6CFE"/><stop offset="1" stop-color="#4E44DB"/></radialGradient></defs>`, { color: true }));
export const BotFilled = ( /*#__PURE__*/createFluentIcon('BotFilled', "1em", ["M14.7 11.5c.99 0 1.8.81 1.8 1.81v.7a3.52 3.52 0 0 1-1.13 2.55c-.95.87-2.6 1.44-5.37 1.44s-4.42-.57-5.37-1.44A3.52 3.52 0 0 1 3.5 14H3.5v-.69c0-1 .81-1.8 1.8-1.8h9.4ZM6.5 3C5.67 3 5 3.67 5 4.5v4c0 .83.67 1.5 1.5 1.5h7c.83 0 1.5-.67 1.5-1.5v-4c0-.83-.67-1.5-1.5-1.5h-3v-.5c0-.3-.22-.5-.5-.5a.5.5 0 0 0-.5.5V3h-3ZM7 6.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm4 0a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z"]));
export const BotRegular = ( /*#__PURE__*/createFluentIcon('BotRegular', "1em", ["M12 5.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-5 1a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm3.5-4a.5.5 0 0 0-1 0V3h-3C5.67 3 5 3.67 5 4.5v4c0 .83.67 1.5 1.5 1.5h7c.83 0 1.5-.67 1.5-1.5v-4c0-.83-.67-1.5-1.5-1.5h-3v-.5ZM6.5 4h7c.28 0 .5.22.5.5v4a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-4c0-.28.22-.5.5-.5Zm3.75 14c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Zm-4.94-5.5h9.38c.45 0 .81.37.81.81v.44c0 .69-.13 1.46-.8 2.07C14 16.45 12.66 17 10 17s-4.01-.55-4.7-1.18a2.63 2.63 0 0 1-.8-2.07v-.44c0-.44.36-.8.8-.8Z"]));
export const BotAddFilled = ( /*#__PURE__*/createFluentIcon('BotAddFilled', "1em", ["M14.5 9c.14 0 .27 0 .4.02.07-.17.1-.34.1-.52v-4c0-.83-.67-1.5-1.5-1.5h-3v-.5c0-.3-.22-.5-.5-.5a.5.5 0 0 0-.5.5V3h-3C5.67 3 5 3.67 5 4.5v4c0 .83.67 1.5 1.5 1.5h4.84c.9-.63 1.98-1 3.16-1ZM7 6.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm4 0a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm-2 8c0-1.1.33-2.13.89-3H5.3c-1 0-1.81.81-1.81 1.81v.7c.04.77.25 1.75 1.13 2.55.95.87 2.6 1.44 5.37 1.44h.26A5.48 5.48 0 0 1 9 14.5Zm10 0a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const BotAddRegular = ( /*#__PURE__*/createFluentIcon('BotAddRegular', "1em", ["M12 5.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-5 1a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm3.5-4a.5.5 0 0 0-1 0V3h-3C5.67 3 5 3.67 5 4.5v4c0 .83.67 1.5 1.5 1.5h4.84a5.47 5.47 0 0 1 3.57-.98c.06-.17.09-.34.09-.52v-4c0-.83-.67-1.5-1.5-1.5h-3v-.5ZM6.5 4h7c.28 0 .5.22.5.5v4a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-4c0-.28.22-.5.5-.5Zm2 7.5h1.39c-.2.31-.38.65-.52 1H5.31a.8.8 0 0 0-.81.81v.44c0 .69.13 1.46.8 2.07.65.6 1.9 1.12 4.3 1.18.18.35.4.69.66 1h-.51c-2.62-.04-4.2-.6-5.12-1.44A3.52 3.52 0 0 1 3.5 14H3.5v-.69c0-1 .81-1.8 1.8-1.8h3.2v-.01Zm10.5 3a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const BotSparkleColor = ( /*#__PURE__*/createFluentIcon('BotSparkleColor', "1em", `<path d="M10.25 18c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Z" fill="url(#ic_fluent_bot_sparkle_20_color__a)"/><path d="M10.25 18c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Z" fill="url(#ic_fluent_bot_sparkle_20_color__b)"/><path d="M10.25 18c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Z" fill="url(#ic_fluent_bot_sparkle_20_color__c)"/><path d="M10.25 18c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Z" fill="url(#ic_fluent_bot_sparkle_20_color__d)"/><path d="M10.25 18c2.62-.04 4.2-.6 5.12-1.44A3.52 3.52 0 0 0 16.5 14h.01v-.69c0-1-.81-1.8-1.8-1.8h-3.2v-.01H5.3c-.99 0-1.8.81-1.8 1.81v.7c.04.77.25 1.75 1.13 2.55.93.84 2.5 1.4 5.12 1.44h.5Z" fill="url(#ic_fluent_bot_sparkle_20_color__e)"/><path d="M10.5 2.5a.5.5 0 0 0-1 0v1h1v-1Z" fill="url(#ic_fluent_bot_sparkle_20_color__f)"/><path d="M5 4.5C5 3.67 5.67 3 6.5 3h7c.83 0 1.5.67 1.5 1.5v4c0 .83-.67 1.5-1.5 1.5h-7A1.5 1.5 0 0 1 5 8.5v-4Z" fill="url(#ic_fluent_bot_sparkle_20_color__g)"/><path d="M12 5.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z" fill="url(#ic_fluent_bot_sparkle_20_color__h)"/><path d="M7 6.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Z" fill="url(#ic_fluent_bot_sparkle_20_color__i)"/><path d="m19.78 17.21-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Z" fill="url(#ic_fluent_bot_sparkle_20_color__j)"/><path d="m14.88 9.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Z" fill="url(#ic_fluent_bot_sparkle_20_color__k)"/><defs><linearGradient id="ic_fluent_bot_sparkle_20_color__b" x1="10" y1="10.73" x2="12.94" y2="21.71" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_bot_sparkle_20_color__f" x1="9.48" y1="2" x2="10.53" y2="3.23" gradientUnits="userSpaceOnUse"><stop stop-color="#8B52F4"/><stop offset="1" stop-color="#3D35B1"/></linearGradient><linearGradient id="ic_fluent_bot_sparkle_20_color__h" x1="11.47" y1="5.58" x2="12.99" y2="8.19" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#F9DCFA"/></linearGradient><linearGradient id="ic_fluent_bot_sparkle_20_color__i" x1="7.47" y1="5.58" x2="8.99" y2="8.19" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#F9DCFA"/></linearGradient><linearGradient id="ic_fluent_bot_sparkle_20_color__j" x1="16" y1="15.5" x2="19" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FFA43D"/><stop offset="1" stop-color="#FB5937"/></linearGradient><linearGradient id="ic_fluent_bot_sparkle_20_color__k" x1="16.5" y1="15" x2="11.59" y2="9.36" gradientUnits="userSpaceOnUse"><stop stop-color="#FF8A69"/><stop offset="1" stop-color="#FFCD0F"/></linearGradient><radialGradient id="ic_fluent_bot_sparkle_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(15.59372 9.14999 -14.57328 24.83628 .5 9.5)"><stop stop-color="#F08AF4"/><stop offset=".54" stop-color="#9C6CFE"/><stop offset="1" stop-color="#4E44DB"/></radialGradient><radialGradient id="ic_fluent_bot_sparkle_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 -3 1.70313 0 14.5 14.5)"><stop stop-color="#4E44DB"/><stop offset="1" stop-color="#4E44DB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_bot_sparkle_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-2 -2 1.5 -1.5 14 13.5)"><stop stop-color="#4E44DB"/><stop offset="1" stop-color="#4E44DB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_bot_sparkle_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-4.5 0 0 -1.76562 14.5 13)"><stop stop-color="#4E44DB"/><stop offset="1" stop-color="#4E44DB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_bot_sparkle_20_color__g" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(39.05 .75 2.11) scale(16.9824 32.4423)"><stop stop-color="#F08AF4"/><stop offset=".54" stop-color="#9C6CFE"/><stop offset="1" stop-color="#4E44DB"/></radialGradient></defs>`, { color: true }));
export const BotSparkleFilled = ( /*#__PURE__*/createFluentIcon('BotSparkleFilled', "1em", ["M14.48 8c.18 0 .35.03.52.1V4.5c0-.83-.67-1.5-1.5-1.5h-3v-.5c0-.3-.22-.5-.5-.5a.5.5 0 0 0-.5.5V3h-3C5.67 3 5 3.67 5 4.5v4c0 .83.67 1.5 1.5 1.5h6.3l.33-1.04v-.01A1.42 1.42 0 0 1 14.49 8ZM7 6.5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm4 0a1 1 0 1 1 2 0 1 1 0 0 1-2 0ZM10 18c1.74 0 3.04-.23 4-.61.02-.15.06-.3.12-.44a1.42 1.42 0 0 1-.96-.9v-.01l-.36-1.08-.03-.1a1.2 1.2 0 0 0-.26-.37l-.06-.06a1.2 1.2 0 0 0-.4-.24l-1.09-.35h-.01a1.42 1.42 0 0 1-.54-2.34H5.3c-1 0-1.81.81-1.81 1.81v.7c.04.77.25 1.75 1.13 2.55.95.87 2.6 1.44 5.37 1.44Zm5.23-7.65-.35-1.07a.42.42 0 0 0-.8 0l-.35 1.07a2.2 2.2 0 0 1-1.38 1.4l-1.07.35a.42.42 0 0 0 0 .8l1.07.34a2.2 2.2 0 0 1 1.4 1.4l.35 1.08a.42.42 0 0 0 .8 0l.35-1.07a2.2 2.2 0 0 1 1.4-1.4l1.07-.35a.42.42 0 0 0 0-.8h-.02l-1.08-.35a2.2 2.2 0 0 1-1.4-1.4Zm3.79 6.61.76.25h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .57 0l.25.77a1.58 1.58 0 0 0 1 1Z"]));
export const BotSparkleRegular = ( /*#__PURE__*/createFluentIcon('BotSparkleRegular', "1em", ["M12 5.5a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm-5 1a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm3.5-4a.5.5 0 0 0-1 0V3h-3C5.67 3 5 3.67 5 4.5v4c0 .83.67 1.5 1.5 1.5h6.3l.32-1H6.5a.5.5 0 0 1-.5-.5v-4c0-.28.22-.5.5-.5h7c.28 0 .5.22.5.5v3.58a1.42 1.42 0 0 1 1 .02V4.5c0-.83-.67-1.5-1.5-1.5h-3v-.5Zm-2 9h1.9a1.41 1.41 0 0 0-.4 1H5.3a.8.8 0 0 0-.8.81v.44c0 .69.13 1.46.8 2.07C6 16.45 7.34 17 10 17c1.55 0 2.66-.19 3.44-.47a1.42 1.42 0 0 0 .68.42c-.06.14-.1.29-.12.44-.91.36-2.13.59-3.75.6V18h-.5c-2.62-.04-4.2-.6-5.12-1.44A3.52 3.52 0 0 1 3.5 14H3.5v-.69c0-1 .81-1.8 1.8-1.8h3.2v-.01Zm6.38-2.22.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0-.14.46.3.3 0 0 0 .14.11l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Zm-6.17-.52.07.05Z"]));
export const BowTieFilled = ( /*#__PURE__*/createFluentIcon('BowTieFilled', "1em", ["M7.46 4.63a2 2 0 0 1 .7.63C8.38 5.1 8.68 5 9 5h2c.31 0 .6.1.85.26a2 2 0 0 1 .7-.63l2.5-1.36A2 2 0 0 1 18 5.03v4.94a2 2 0 0 1-2.96 1.76l-2.5-1.36a2 2 0 0 1-.7-.63A1.5 1.5 0 0 1 11 10H9c-.31 0-.6-.1-.85-.26a2 2 0 0 1-.7.63l-2.5 1.36A2 2 0 0 1 2 9.97V5.03a2 2 0 0 1 2.96-1.76l2.5 1.36ZM5.5 7.5c0 .28.22.5.5.5h2V7H6a.5.5 0 0 0-.5.5ZM14 7h-2v1h2a.5.5 0 0 0 0-1Zm-5.7 4.05-.36.2-2.4 1.3-.96 2.4A1.5 1.5 0 0 0 5.98 17H7.5c.83 0 1.5-.67 1.5-1.5V11h-.6l-.1.05ZM11 15.5V11h.6l.18.1.28.14 2.4 1.3.96 2.4a1.5 1.5 0 0 1-1.4 2.06H12.5a1.5 1.5 0 0 1-1.5-1.5Z"]));
export const BowTieRegular = ( /*#__PURE__*/createFluentIcon('BowTieRegular', "1em", ["M11 10H9v5.5c0 .83-.67 1.5-1.5 1.5H5.89a1.5 1.5 0 0 1-1.43-1.97l1.24-3.7-.74.4A2 2 0 0 1 2 9.97V5.03a2 2 0 0 1 2.96-1.76l2.5 1.36a2 2 0 0 1 .7.63C8.38 5.1 8.68 5 9 5h2c.31 0 .6.1.85.26a2 2 0 0 1 .7-.63l2.5-1.36A2 2 0 0 1 18 5.03v4.94a2 2 0 0 1-2.96 1.76l-.74-.4 1.24 3.7A1.5 1.5 0 0 1 14.1 17H12.5a1.5 1.5 0 0 1-1.5-1.5V10Zm6-4.97a1 1 0 0 0-1.48-.88l-2.5 1.36a1 1 0 0 0-.52.88V7h2a.5.5 0 0 1 0 1h-2v.61c0 .37.2.7.52.88l2.5 1.36A1 1 0 0 0 17 9.97V5.03Zm-5 4.9v5.57c0 .28.22.5.5.5h1.61a.5.5 0 0 0 .48-.66l-1.56-4.68-.01-.04-.48-.25a2 2 0 0 1-.54-.44Zm-5.03.73-1.56 4.68a.5.5 0 0 0 .48.66H7.5a.5.5 0 0 0 .5-.5V9.93a2 2 0 0 1-.54.44l-.48.25a.5.5 0 0 1 0 .04ZM11.5 6.5A.5.5 0 0 0 11 6H9a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5h2a.5.5 0 0 0 .5-.5v-2ZM7.5 8h-2a.5.5 0 0 1 0-1h2v-.61a1 1 0 0 0-.52-.88l-2.5-1.36A1 1 0 0 0 3 5.03v4.94a1 1 0 0 0 1.48.88l2.5-1.36a1 1 0 0 0 .52-.88V8Z"]));
export const BowlChopsticksFilled = ( /*#__PURE__*/createFluentIcon('BowlChopsticksFilled', "1em", ["M4.24 2.07a.5.5 0 0 1 .69.17L9.09 9h1.82L7.07 2.76a.5.5 0 0 1 .86-.52L12.09 9h5.41c.28 0 .5.22.5.5v.5c0 .7-.09 1.36-.25 2H2.25A8.02 8.02 0 0 1 2 10v-.5c0-.28.22-.5.5-.5h5.41L4.07 2.76a.5.5 0 0 1 .17-.69ZM10 18a8 8 0 0 1-7.42-5h14.84A8 8 0 0 1 10 18Z"]));
export const BowlChopsticksRegular = ( /*#__PURE__*/createFluentIcon('BowlChopsticksRegular', "1em", ["M4.93 2.24a.5.5 0 0 0-.86.52L7.91 9H2.5a.5.5 0 0 0-.5.5v.5a8 8 0 0 0 16 0v-.5a.5.5 0 0 0-.5-.5h-5.41L7.93 2.24a.5.5 0 0 0-.86.52L10.91 9H9.1L4.93 2.24ZM3.29 12A7 7 0 0 1 3 10h14a7 7 0 0 1-.29 2H3.29Zm.38 1h12.66a7 7 0 0 1-12.66 0Z"]));
export const BowlSaladFilled = ( /*#__PURE__*/createFluentIcon('BowlSaladFilled', "1em", ["M6.92 4.83a3.5 3.5 0 0 1 6.25.17 3.75 3.75 0 0 0-3.39 2.32 6.15 6.15 0 0 0-2.86-2.49ZM17 9a3.76 3.76 0 0 0-2.7-3.85A4.5 4.5 0 0 0 6 4.48 10.07 10.07 0 0 0 3.14 4a9.5 9.5 0 0 0-.67 0 .5.5 0 0 0-.47.47 4.84 4.84 0 0 0 0 .67c.01.41.05.98.17 1.62.12.68.33 1.46.68 2.23H2.5a.5.5 0 0 0-.5.5v.5c0 .7.09 1.36.25 2h15.5c.16-.64.25-1.3.25-2v-.5a.5.5 0 0 0-.5-.5H17ZM4 9a7.87 7.87 0 0 1-.83-2.4A10.47 10.47 0 0 1 3 5a9.4 9.4 0 0 1 1.59.16c1.18.22 2.57.69 3.57 1.7A5.83 5.83 0 0 1 9.48 9H7.7L5.85 7.15a.5.5 0 1 0-.7.7L6.29 9H4Zm6.54 0-.02-.08-.01-.17a2.75 2.75 0 1 1 5.49.25h-5.46ZM10 18a8 8 0 0 1-7.42-5h14.84A8 8 0 0 1 10 18Z"]));
export const BowlSaladRegular = ( /*#__PURE__*/createFluentIcon('BowlSaladRegular', "1em", ["M6.92 4.83a3.5 3.5 0 0 1 6.25.17 3.75 3.75 0 0 0-3.39 2.32 6.15 6.15 0 0 0-2.86-2.49ZM17 9a3.76 3.76 0 0 0-2.7-3.85A4.5 4.5 0 0 0 6 4.48 10.07 10.07 0 0 0 3.14 4a9.5 9.5 0 0 0-.67 0 .5.5 0 0 0-.47.47 4.84 4.84 0 0 0 0 .67c.01.41.05.98.17 1.62.12.68.33 1.46.68 2.23H2.5a.5.5 0 0 0-.5.5v.5a8 8 0 1 0 16 0v-.5a.5.5 0 0 0-.5-.5H17ZM4 9a7.87 7.87 0 0 1-.83-2.4A10.47 10.47 0 0 1 3 5a9.4 9.4 0 0 1 1.59.16c1.18.22 2.57.69 3.57 1.7A5.83 5.83 0 0 1 9.48 9H7.7L5.85 7.15a.5.5 0 1 0-.7.7L6.29 9H4Zm6.54 0-.02-.08-.01-.17a2.75 2.75 0 1 1 5.49.25h-5.46ZM3 10h14a7 7 0 0 1-.29 2H3.29A7 7 0 0 1 3 10Zm7 7a7 7 0 0 1-6.33-4h12.66A7 7 0 0 1 10 17Z"]));
export const BoxFilled = ( /*#__PURE__*/createFluentIcon('BoxFilled', "1em", ["m10 7.96 3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96Zm-7.96-2.1c-.03.1-.04.2-.04.32v7.64c0 .62.37 1.17.94 1.4l5.76 2.3c.26.1.53.17.8.21v-8.9L2.04 5.86Zm8.46 11.87c.27-.04.54-.1.8-.21l5.76-2.3c.57-.23.94-.78.94-1.4V6.18c0-.11-.01-.22-.04-.33L10.5 8.84v8.9ZM17.42 5l-3.04 1.22-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21Z"]));
export const BoxRegular = ( /*#__PURE__*/createFluentIcon('BoxRegular', "1em", ["M11.3 2.48a3.5 3.5 0 0 0-2.6 0l-5.76 2.3A1.5 1.5 0 0 0 2 6.18v7.64c0 .62.37 1.17.94 1.4l5.76 2.3a3.5 3.5 0 0 0 2.6 0l5.76-2.3c.57-.23.94-.78.94-1.4V6.18a1.5 1.5 0 0 0-.94-1.4l-5.76-2.3Zm-2.23.93a2.5 2.5 0 0 1 1.86 0l5.22 2.09-2.27.91-6.16-2.46 1.35-.54Zm-2.7 1.08 6.16 2.46L10 7.96 3.85 5.5l2.53-1.01Zm4.13 4.35 6.5-2.6v7.58a.5.5 0 0 1-.31.47l-5.76 2.3c-.14.06-.28.1-.43.13V8.84Zm-1 0v7.88a2.5 2.5 0 0 1-.43-.13l-5.76-2.3a.5.5 0 0 1-.31-.47V6.24l6.5 2.6Z"]));
export const BoxArrowLeftFilled = ( /*#__PURE__*/createFluentIcon('BoxArrowLeftFilled', "1em", ["M17.42 5 14.38 6.2l-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21ZM10 7.95l3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96ZM2 6.18c0-.11.01-.22.04-.33L9.5 8.84v3.36a5.48 5.48 0 0 0 0 4.6v.93a3.5 3.5 0 0 1-.8-.21l-5.76-2.3a1.5 1.5 0 0 1-.94-1.4V6.18Zm16 0v4.08a5.48 5.48 0 0 0-7.5.46V8.84l7.46-2.99c.03.1.04.22.04.33Zm1 8.32a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-6.86-.35 2-2a.5.5 0 1 1 .71.7L13.71 14h2.79a.5.5 0 0 1 0 1h-2.8l1.15 1.15a.5.5 0 1 1-.7.7l-2-2a.5.5 0 0 1-.15-.35.5.5 0 0 1 .14-.35Z"]));
export const BoxArrowLeftRegular = ( /*#__PURE__*/createFluentIcon('BoxArrowLeftRegular', "1em", ["M11.3 2.48a3.5 3.5 0 0 0-2.6 0l-5.76 2.3A1.5 1.5 0 0 0 2 6.18v7.64c0 .62.37 1.17.94 1.4l5.76 2.3c.44.17.9.26 1.38.25a5.5 5.5 0 0 1-.62-1.06 2.5 2.5 0 0 1-.39-.12l-5.76-2.3a.5.5 0 0 1-.31-.47V6.24l6.5 2.6v3.36c.25-.54.6-1.04 1-1.48V8.84l6.5-2.6V9.6c.36.18.7.4 1 .66V6.18a1.5 1.5 0 0 0-.94-1.4l-5.76-2.3Zm-2.23.93a2.5 2.5 0 0 1 1.86 0l5.22 2.09-2.27.91-6.16-2.46 1.35-.54Zm-2.7 1.08 6.16 2.46L10 7.96 3.85 5.5l2.53-1.01Zm12.63 10a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-6.86-.34 2-2a.5.5 0 1 1 .71.7L13.71 14h2.79a.5.5 0 0 1 0 1h-2.8l1.15 1.15a.5.5 0 1 1-.7.7l-2-2a.5.5 0 0 1-.15-.35.5.5 0 0 1 .14-.35Z"]));
export const BoxArrowUpFilled = ( /*#__PURE__*/createFluentIcon('BoxArrowUpFilled', "1em", ["M17.42 5 14.38 6.2l-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21ZM10 7.95l3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96ZM2 6.18c0-.11.01-.22.04-.33L9.5 8.84v3.36a5.48 5.48 0 0 0 0 4.6v.93a3.5 3.5 0 0 1-.8-.21l-5.76-2.3a1.5 1.5 0 0 1-.94-1.4V6.18Zm16 0v4.08a5.48 5.48 0 0 0-7.5.46V8.84l7.46-2.99c.03.1.04.22.04.33ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm.35-6.86 2 2a.5.5 0 1 1-.7.71L15 13.71v2.79a.5.5 0 0 1-1 0v-2.8l-1.15 1.15a.5.5 0 1 1-.7-.7l2-2a.5.5 0 0 1 .35-.15.5.5 0 0 1 .35.14Z"]));
export const BoxArrowUpRegular = ( /*#__PURE__*/createFluentIcon('BoxArrowUpRegular', "1em", ["M11.3 2.48a3.5 3.5 0 0 0-2.6 0l-5.76 2.3A1.5 1.5 0 0 0 2 6.18v7.64c0 .62.37 1.17.94 1.4l5.76 2.3c.44.17.9.26 1.38.25a5.5 5.5 0 0 1-.62-1.06 2.5 2.5 0 0 1-.39-.12l-5.76-2.3a.5.5 0 0 1-.31-.47V6.24l6.5 2.6v3.36c.25-.54.6-1.04 1-1.48V8.84l6.5-2.6V9.6c.36.18.7.4 1 .66V6.18a1.5 1.5 0 0 0-.94-1.4l-5.76-2.3Zm-2.23.93a2.5 2.5 0 0 1 1.86 0l5.22 2.09-2.27.91-6.16-2.46 1.35-.54Zm-2.7 1.08 6.16 2.46L10 7.96 3.85 5.5l2.53-1.01Zm8.13 14.5a4.5 4.5 0 1 0 0-8.99 4.5 4.5 0 0 0 0 9Zm.35-6.85 2 2a.5.5 0 1 1-.7.71L15 13.71v2.79a.5.5 0 0 1-1 0v-2.8l-1.15 1.15a.5.5 0 1 1-.7-.7l2-2a.5.5 0 0 1 .35-.15.5.5 0 0 1 .35.14Z"]));
export const BoxCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('BoxCheckmarkFilled', "1em", ["M17.42 5 14.38 6.2l-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21ZM10 7.95l3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96ZM2 6.18c0-.11.01-.22.04-.33L9.5 8.84v3.36a5.48 5.48 0 0 0 0 4.6v.93a3.5 3.5 0 0 1-.8-.21l-5.76-2.3a1.5 1.5 0 0 1-.94-1.4V6.18Zm16 0v4.08a5.48 5.48 0 0 0-7.5.46V8.84l7.46-2.99c.03.1.04.22.04.33ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-1-3.7 2.65-2.65a.5.5 0 0 1 .7.7l-3 3a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64Z"]));
export const BoxCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('BoxCheckmarkRegular', "1em", ["M11.3 2.48a3.5 3.5 0 0 0-2.6 0l-5.76 2.3A1.5 1.5 0 0 0 2 6.18v7.64c0 .62.37 1.17.94 1.4l5.76 2.3c.44.17.9.26 1.38.25a5.5 5.5 0 0 1-.62-1.06 2.5 2.5 0 0 1-.39-.12l-5.76-2.3a.5.5 0 0 1-.31-.47V6.24l6.5 2.6v3.36c.25-.54.6-1.04 1-1.48V8.84l6.5-2.6V9.6c.36.18.7.4 1 .66V6.18a1.5 1.5 0 0 0-.94-1.4l-5.76-2.3Zm-2.23.93a2.5 2.5 0 0 1 1.86 0l5.22 2.09-2.27.91-6.16-2.46 1.35-.54Zm-2.7 1.08 6.16 2.46L10 7.96 3.85 5.5l2.53-1.01Zm8.13 14.5a4.5 4.5 0 1 0 0-8.99 4.5 4.5 0 0 0 0 9Zm-1-3.7 2.65-2.64a.5.5 0 0 1 .7.7l-3 3a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64Z"]));
export const BoxDismissFilled = ( /*#__PURE__*/createFluentIcon('BoxDismissFilled', "1em", ["M17.42 5 14.38 6.2l-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21ZM10 7.95l3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96Zm-7.96-2.1c-.03.1-.04.2-.04.32v7.64c0 .62.37 1.17.94 1.4l5.76 2.3c.26.1.53.17.8.21v-.94a5.48 5.48 0 0 1 0-4.58V8.84L2.04 5.85ZM18 6.17v4.08a5.48 5.48 0 0 0-7.5.46V8.84l7.46-2.99c.03.1.04.22.04.33Zm1 8.32a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const BoxDismissRegular = ( /*#__PURE__*/createFluentIcon('BoxDismissRegular', "1em", ["M11.3 2.48a3.5 3.5 0 0 0-2.6 0l-5.76 2.3A1.5 1.5 0 0 0 2 6.18v7.64c0 .62.37 1.17.94 1.4l5.76 2.3c.44.17.9.26 1.38.25a5.5 5.5 0 0 1-.62-1.06 2.51 2.51 0 0 1-.39-.12l-5.76-2.3a.5.5 0 0 1-.31-.47V6.24l6.5 2.6v3.37c.25-.55.6-1.05 1-1.49V8.84l6.5-2.6V9.6c.36.18.7.4 1 .66V6.18a1.5 1.5 0 0 0-.94-1.4l-5.76-2.3Zm-2.23.93a2.5 2.5 0 0 1 1.86 0l5.22 2.09-2.27.91-6.16-2.46 1.35-.54Zm-2.7 1.08 6.16 2.46L10 7.96 3.85 5.5l2.53-1.01ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.65-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14 1.15 1.14a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15Z"]));
export const BoxEditFilled = ( /*#__PURE__*/createFluentIcon('BoxEditFilled', "1em", ["M17.42 5 14.38 6.2l-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21ZM10 7.95l3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96Zm-7.96-2.1c-.03.1-.04.2-.04.32v7.64c0 .62.37 1.17.94 1.4l5.76 2.3.36.12.37-1.49.07-.23V8.84L2.04 5.85ZM18 6.17v2.95a2.87 2.87 0 0 0-2.9.71l-4.6 4.6v-5.6l7.46-2.99c.03.1.04.22.04.33Zm-7.02 9.2 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const BoxEditRegular = ( /*#__PURE__*/createFluentIcon('BoxEditRegular', "1em", ["M11.3 2.48a3.5 3.5 0 0 0-2.6 0l-5.76 2.3A1.5 1.5 0 0 0 2 6.18v7.64c0 .62.37 1.17.94 1.4l5.76 2.3.36.12.24-.97a2.53 2.53 0 0 1-.23-.08l-5.76-2.3a.5.5 0 0 1-.31-.47V6.24l6.5 2.6v7.08c.16-.47.42-.9.77-1.25l.23-.23v-5.6l6.5-2.6V9c.34-.01.68.03 1 .13V6.18a1.5 1.5 0 0 0-.94-1.4l-5.76-2.3Zm-2.23.93a2.5 2.5 0 0 1 1.86 0l5.22 2.09-2.27.91-6.16-2.46 1.35-.54Zm-2.7 1.08 6.16 2.46L10 7.96 3.85 5.5l2.53-1.01Zm4.61 10.89 4.83-4.83a1.87 1.87 0 1 1 2.64 2.64l-4.83 4.83a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02Z"]));
export const BoxMultipleFilled = ( /*#__PURE__*/createFluentIcon('BoxMultipleFilled', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.7A1.5 1.5 0 0 0 7 5.1v1.1a4 4 0 0 1 1.94.23l3.46 1.34A2.5 2.5 0 0 1 14 10.1v4.78c0 .2-.03.4-.07.6l3.1-1.2c.59-.22.97-.78.97-1.4V5.1a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33Zm1.87 2.15a.5.5 0 1 1 .35.94l-2.76 1.06a1.5 1.5 0 0 1-1.08 0L9.2 5.47a.5.5 0 0 1 .35-.94l2.77 1.07a.5.5 0 0 0 .36 0l2.77-1.07ZM6.42 7.38a3 3 0 0 1 2.16 0l3.46 1.33c.58.22.96.78.96 1.4v4.78a1.5 1.5 0 0 1-.96 1.4l-3.46 1.33a3 3 0 0 1-2.16 0l-3.46-1.33a1.5 1.5 0 0 1-.96-1.4V10.1c0-.62.38-1.18.96-1.4l3.46-1.33Zm4.67 2.91a.5.5 0 0 0-.64-.28L7.5 11.14 4.55 10a.5.5 0 1 0-.35.93L7 12.02v2.49a.5.5 0 0 0 1 0V12l2.8-1.07a.5.5 0 0 0 .3-.65Z"]));
export const BoxMultipleRegular = ( /*#__PURE__*/createFluentIcon('BoxMultipleRegular', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.71A1.5 1.5 0 0 0 7 5.11v1.1a4 4 0 0 1 1 0v-1.1c0-.2.13-.4.32-.47l3.46-1.33a2 2 0 0 1 1.44 0l3.46 1.33c.2.08.32.26.32.47v7.78c0 .2-.13.4-.32.47L14 14.39v.5c0 .2-.03.4-.07.6l3.1-1.2c.59-.22.97-.78.97-1.4V5.11a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33Zm2.51 2.92a.5.5 0 0 0-.64-.3l-2.77 1.07a.5.5 0 0 1-.36 0L9.55 5.01a.5.5 0 1 0-.35.93l2.76 1.07c.35.13.73.13 1.08 0l2.76-1.07a.5.5 0 0 0 .3-.64Zm-5 5a.5.5 0 0 0-.64-.3L7.5 11.15l-2.95-1.13a.5.5 0 0 0-.35.93L7 12.02v2.49a.5.5 0 1 0 1 0v-2.49l2.8-1.08a.5.5 0 0 0 .3-.64ZM8.58 7.38a3 3 0 0 0-2.16 0L2.96 8.71a1.5 1.5 0 0 0-.96 1.4v4.78c0 .62.38 1.18.96 1.4l3.46 1.33a3 3 0 0 0 2.16 0l3.46-1.33c.58-.22.96-.78.96-1.4v-4.78a1.5 1.5 0 0 0-.96-1.4L8.58 7.38Zm-1.8.93a2 2 0 0 1 1.44 0l3.46 1.33c.2.08.32.26.32.47v4.78c0 .2-.13.4-.32.47l-3.46 1.33a2 2 0 0 1-1.44 0l-3.46-1.33a.5.5 0 0 1-.32-.47v-4.78c0-.2.13-.4.32-.47l3.46-1.33Z"]));
export const BoxMultipleArrowLeftFilled = ( /*#__PURE__*/createFluentIcon('BoxMultipleArrowLeftFilled', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.7A1.5 1.5 0 0 0 7 5.1v1.1a4 4 0 0 1 1.94.23l3.46 1.34c.61.23 1.1.7 1.36 1.27a5.55 5.55 0 0 1 4.24 1.2V5.12a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33Zm1.87 2.15a.5.5 0 1 1 .35.94l-2.76 1.06a1.5 1.5 0 0 1-1.08 0L9.2 5.47a.5.5 0 0 1 .35-.94l2.77 1.07a.5.5 0 0 0 .36 0l2.77-1.07Zm-3.41 4.18c.3.11.54.32.71.57-.62.21-1.2.53-1.7.93a.5.5 0 0 0-.6-.2L7.5 11.14 4.55 10a.5.5 0 1 0-.35.93L7 12.02v2.49a.5.5 0 0 0 1 0V12l2.09-.8a5.48 5.48 0 0 0-.39 5.98l-1.12.43a3 3 0 0 1-2.16 0l-3.46-1.33a1.5 1.5 0 0 1-.96-1.4V10.1c0-.62.38-1.18.96-1.4l3.46-1.33a3 3 0 0 1 2.16 0l3.46 1.33ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-6.85-.35a.5.5 0 0 0-.15.35.5.5 0 0 0 .15.35l2 2a.5.5 0 0 0 .7-.7L13.71 15h2.79a.5.5 0 1 0 0-1h-2.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2Z"]));
export const BoxMultipleArrowLeftRegular = ( /*#__PURE__*/createFluentIcon('BoxMultipleArrowLeftRegular', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.7A1.5 1.5 0 0 0 7 5.1v1.1a4 4 0 0 1 1 0V5.1c0-.2.13-.4.32-.47l3.46-1.33a2 2 0 0 1 1.44 0l3.46 1.33c.2.08.32.26.32.47V9.6c.36.18.7.4 1 .66V5.1a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33ZM12.04 8.7c.3.11.54.32.71.57-.33.11-.65.26-.95.43a.5.5 0 0 0-.12-.07L8.22 8.31a2 2 0 0 0-1.44 0L3.32 9.64a.5.5 0 0 0-.32.47v4.78c0 .2.13.4.32.47l3.46 1.33a2 2 0 0 0 1.44 0l1.07-.42c.11.32.25.63.41.92l-1.12.43a3 3 0 0 1-2.16 0l-3.46-1.33a1.5 1.5 0 0 1-.96-1.4V10.1c0-.62.38-1.18.96-1.4l3.46-1.33a3 3 0 0 1 2.16 0l3.46 1.33Zm-1.6 1.3a.5.5 0 0 1 .61.2c-.36.3-.68.63-.96 1l-2.09.8v2.5a.5.5 0 0 1-1 0V12l-2.8-1.07a.5.5 0 1 1 .35-.93l2.95 1.13L10.45 10Zm5.65-4.72a.5.5 0 0 0-.64-.28l-2.77 1.06a.5.5 0 0 1-.36 0L9.55 5.01a.5.5 0 0 0-.35.93L11.96 7c.35.14.73.14 1.08 0l2.76-1.06a.5.5 0 0 0 .3-.65ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-6.85-.34a.5.5 0 0 0-.15.35.5.5 0 0 0 .15.35l2 2a.5.5 0 0 0 .7-.7L13.71 15h2.79a.5.5 0 1 0 0-1h-2.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2Z"]));
export const BoxMultipleArrowRightFilled = ( /*#__PURE__*/createFluentIcon('BoxMultipleArrowRightFilled', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.7A1.5 1.5 0 0 0 7 5.1v1.1a4 4 0 0 1 1.94.23l3.46 1.34c.61.23 1.1.7 1.36 1.27a5.55 5.55 0 0 1 4.24 1.2V5.12a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33Zm1.87 2.15a.5.5 0 1 1 .35.94l-2.76 1.06a1.5 1.5 0 0 1-1.08 0L9.2 5.47a.5.5 0 0 1 .35-.94l2.77 1.07a.5.5 0 0 0 .36 0l2.77-1.07Zm-3.41 4.18c.3.11.54.32.71.57-.62.21-1.2.53-1.7.93a.5.5 0 0 0-.6-.2L7.5 11.14 4.55 10a.5.5 0 1 0-.35.93L7 12.02v2.49a.5.5 0 0 0 1 0V12l2.09-.8a5.48 5.48 0 0 0-.39 5.98l-1.12.43a3 3 0 0 1-2.16 0l-3.46-1.33a1.5 1.5 0 0 1-.96-1.4V10.1c0-.62.38-1.18.96-1.4l3.46-1.33a3 3 0 0 1 2.16 0l3.46 1.33ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const BoxMultipleArrowRightRegular = ( /*#__PURE__*/createFluentIcon('BoxMultipleArrowRightRegular', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.7A1.5 1.5 0 0 0 7 5.1v1.1a4 4 0 0 1 1 0V5.1c0-.2.13-.4.32-.47l3.46-1.33a2 2 0 0 1 1.44 0l3.46 1.33c.2.08.32.26.32.47V9.6c.36.18.7.4 1 .66V5.1a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33ZM12.04 8.7c.3.11.54.32.71.57-.33.11-.65.26-.95.43a.5.5 0 0 0-.12-.07L8.22 8.31a2 2 0 0 0-1.44 0L3.32 9.64a.5.5 0 0 0-.32.47v4.78c0 .2.13.4.32.47l3.46 1.33a2 2 0 0 0 1.44 0l1.07-.42c.11.32.25.63.41.92l-1.12.43a3 3 0 0 1-2.16 0l-3.46-1.33a1.5 1.5 0 0 1-.96-1.4V10.1c0-.62.38-1.18.96-1.4l3.46-1.33a3 3 0 0 1 2.16 0l3.46 1.33Zm-1.6 1.3a.5.5 0 0 1 .61.2c-.36.3-.68.63-.96 1l-2.09.8v2.5a.5.5 0 0 1-1 0V12l-2.8-1.07a.5.5 0 1 1 .35-.93l2.95 1.13L10.45 10Zm5.65-4.72a.5.5 0 0 0-.64-.28l-2.77 1.06a.5.5 0 0 1-.36 0L9.55 5.01a.5.5 0 0 0-.35.93L11.96 7c.35.14.73.14 1.08 0l2.76-1.06a.5.5 0 0 0 .3-.65ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.36a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const BoxMultipleCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('BoxMultipleCheckmarkFilled', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.7A1.5 1.5 0 0 0 7 5.1v1.1a4 4 0 0 1 1.94.23l3.46 1.34c.61.23 1.1.7 1.36 1.27a5.55 5.55 0 0 1 4.24 1.2V5.12a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33Zm1.87 2.15a.5.5 0 1 1 .35.94l-2.76 1.06a1.5 1.5 0 0 1-1.08 0L9.2 5.47a.5.5 0 0 1 .35-.94l2.77 1.07a.5.5 0 0 0 .36 0l2.77-1.07Zm-3.41 4.18c.3.11.54.32.71.57-.62.21-1.2.53-1.7.93a.5.5 0 0 0-.6-.2L7.5 11.14 4.55 10a.5.5 0 1 0-.35.93L7 12.02v2.49a.5.5 0 0 0 1 0V12l2.09-.8a5.48 5.48 0 0 0-.39 5.98l-1.12.43a3 3 0 0 1-2.16 0l-3.46-1.33a1.5 1.5 0 0 1-.96-1.4V10.1c0-.62.38-1.18.96-1.4l3.46-1.33a3 3 0 0 1 2.16 0l3.46 1.33ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const BoxMultipleCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('BoxMultipleCheckmarkRegular', "1em", ["M13.58 2.38a3 3 0 0 0-2.16 0L7.96 3.7A1.5 1.5 0 0 0 7 5.1v1.1a4 4 0 0 1 1 0V5.1c0-.2.13-.4.32-.47l3.46-1.33a2 2 0 0 1 1.44 0l3.46 1.33c.2.08.32.26.32.47V9.6c.36.18.7.4 1 .66V5.1a1.5 1.5 0 0 0-.96-1.4l-3.46-1.33ZM12.04 8.7c.3.11.54.32.71.57-.33.11-.65.26-.95.43a.5.5 0 0 0-.12-.07L8.22 8.31a2 2 0 0 0-1.44 0L3.32 9.64a.5.5 0 0 0-.32.47v4.78c0 .2.13.4.32.47l3.46 1.33a2 2 0 0 0 1.44 0l1.07-.42c.11.32.25.63.41.92l-1.12.43a3 3 0 0 1-2.16 0l-3.46-1.33a1.5 1.5 0 0 1-.96-1.4V10.1c0-.62.38-1.18.96-1.4l3.46-1.33a3 3 0 0 1 2.16 0l3.46 1.33Zm-1.6 1.3a.5.5 0 0 1 .61.2c-.36.3-.68.63-.96 1l-2.09.8v2.5a.5.5 0 0 1-1 0V12l-2.8-1.07a.5.5 0 1 1 .35-.93l2.95 1.13L10.45 10Zm5.65-4.72a.5.5 0 0 0-.64-.28l-2.77 1.06a.5.5 0 0 1-.36 0L9.55 5.01a.5.5 0 0 0-.35.93L11.96 7c.35.14.73.14 1.08 0l2.76-1.06a.5.5 0 0 0 .3-.65ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.84a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const BoxMultipleSearchFilled = ( /*#__PURE__*/createFluentIcon('BoxMultipleSearchFilled', "1em", ["M11.42 2.38a3 3 0 0 1 2.16 0l3.46 1.33c.58.22.96.78.96 1.4v7.78c0 .07 0 .15-.02.22A4.5 4.5 0 0 0 13.74 9a2.5 2.5 0 0 0-1.34-1.23L8.94 6.44A4 4 0 0 0 7 6.21V5.1c0-.62.38-1.18.96-1.4l3.46-1.33Zm4.67 2.44a.5.5 0 0 0-.64-.29L12.68 5.6a.5.5 0 0 1-.36 0L9.55 4.53a.5.5 0 0 0-.35.94l2.76 1.06c.35.13.73.13 1.08 0l2.76-1.06a.5.5 0 0 0 .3-.65ZM12.6 9.09a1.5 1.5 0 0 0-.56-.38L8.58 7.38a3 3 0 0 0-2.16 0L2.96 8.7A1.5 1.5 0 0 0 2 10.1v4.78c0 .62.38 1.18.96 1.4l3.46 1.33a3 3 0 0 0 2.16 0l1.94-.75a4.49 4.49 0 0 1-1.02-5.43l-1.5.58v2.49a.5.5 0 0 1-1 0V12l-2.8-1.07a.5.5 0 1 1 .35-.93l2.95 1.13L10.45 10a.5.5 0 0 1 .25-.03c.54-.44 1.2-.75 1.9-.9Zm3.7 6.5a3.5 3.5 0 1 0-.7.7l2.55 2.56a.5.5 0 0 0 .7-.7L16.3 15.6Zm-.3-2.1a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"]));
export const BoxMultipleSearchRegular = ( /*#__PURE__*/createFluentIcon('BoxMultipleSearchRegular', "1em", ["M11.42 2.38a3 3 0 0 1 2.16 0l3.46 1.33c.58.22.96.78.96 1.4v7.78c0 .07 0 .15-.02.22a4.48 4.48 0 0 0-.98-2.44V5.11a.5.5 0 0 0-.32-.47l-3.46-1.33a2 2 0 0 0-1.44 0L8.32 4.64a.5.5 0 0 0-.32.47v1.1a4 4 0 0 0-1 0V5.1c0-.62.38-1.18.96-1.4l3.46-1.33Zm1.18 6.7a1.5 1.5 0 0 0-.56-.37L8.58 7.38a3 3 0 0 0-2.16 0L2.96 8.7A1.5 1.5 0 0 0 2 10.1v4.78c0 .62.38 1.18.96 1.4l3.46 1.33a3 3 0 0 0 2.16 0l1.94-.75c-.27-.23-.5-.5-.71-.8l-1.6.62a2 2 0 0 1-1.43 0l-3.46-1.33a.5.5 0 0 1-.32-.47V10.1c0-.2.13-.4.32-.47l3.46-1.33a2 2 0 0 1 1.44 0l3.16 1.22c.38-.2.79-.35 1.22-.44Zm-1.9.9a.5.5 0 0 0-.25.03L7.5 11.14 4.55 10a.5.5 0 1 0-.35.93L7 12.02v2.49a.5.5 0 0 0 1 0V12l1.5-.57c.29-.57.7-1.07 1.2-1.46ZM15.45 5a.5.5 0 1 1 .35.93L13.04 7a1.5 1.5 0 0 1-1.08 0L9.2 5.94A.5.5 0 0 1 9.55 5l2.77 1.06a.5.5 0 0 0 .36 0l2.77-1.06Zm.85 10.59a3.5 3.5 0 1 0-.7.7l2.55 2.55a.5.5 0 0 0 .7-.7L16.3 15.6Zm-.3-2.1a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"]));
export const BoxSearchFilled = ( /*#__PURE__*/createFluentIcon('BoxSearchFilled', "1em", ["m10 7.96 3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96Zm-7.96-2.1c-.03.1-.04.2-.04.32v3.08a4.5 4.5 0 0 1 5.56 6.18l1.94 1.94V8.84L2.04 5.85Zm8.46 11.87c.27-.04.54-.1.8-.21l5.76-2.3c.57-.23.94-.78.94-1.4V6.18c0-.11-.01-.22-.04-.33L10.5 8.84v8.9ZM17.42 5l-3.04 1.22-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21ZM3.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L6.3 15.6A3.5 3.5 0 1 0 3.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const BoxSearchRegular = ( /*#__PURE__*/createFluentIcon('BoxSearchRegular', "1em", ["M8.7 2.48a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.57.23.94.78.94 1.4v7.64a1.5 1.5 0 0 1-.94 1.4l-5.76 2.3c-.48.19-.99.27-1.5.24a1.5 1.5 0 0 0-.24-.32l-.06-.06V8.84L3 6.24v2.79c-.35.04-.68.11-1 .23V6.18c0-.62.37-1.17.94-1.4l5.76-2.3Zm2.23.93a2.5 2.5 0 0 0-1.86 0l-1.35.54 6.16 2.46 2.27-.91-5.22-2.1Zm1.6 3.54L6.38 4.49l-2.53 1L10 7.97l2.53-1.01ZM17 6.24l-6.5 2.6v7.88c.15-.03.29-.07.43-.13l5.76-2.3a.5.5 0 0 0 .31-.47V6.24ZM3.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L6.3 15.6A3.5 3.5 0 1 0 3.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const BoxToolboxFilled = ( /*#__PURE__*/createFluentIcon('BoxToolboxFilled', "1em", ["M17.42 5 14.38 6.2l-7.5-3 1.82-.73a3.5 3.5 0 0 1 2.6 0l5.76 2.3c.13.06.25.13.36.21ZM10 7.95l3.03-1.21-7.5-3-2.59 1.03a1.5 1.5 0 0 0-.36.21L10 7.96Zm-7.96-2.1c-.03.1-.04.2-.04.32v7.64c0 .62.37 1.17.94 1.4l5.76 2.3.3.1V13.5c0-.56.19-1.08.5-1.5V8.84L2.04 5.85ZM18 6.17v4.87h-.04A2.5 2.5 0 0 0 15.5 9h-2a2.5 2.5 0 0 0-2.46 2.04c-.19.04-.37.1-.54.17V8.84l7.46-2.99c.03.1.04.22.04.33ZM12 12v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 5V16h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 1 0 1 0V16h3v.5a.5.5 0 1 0 1 0Z"]));
export const BoxToolboxRegular = ( /*#__PURE__*/createFluentIcon('BoxToolboxRegular', "1em", ["M11.3 2.48a3.5 3.5 0 0 0-2.6 0l-5.76 2.3A1.5 1.5 0 0 0 2 6.18v7.64c0 .62.37 1.17.94 1.4l5.76 2.3.3.1v-1.06L3.31 14.3a.5.5 0 0 1-.31-.47V6.24l6.5 2.6V12c.26-.34.6-.62 1-.8V8.85l6.5-2.6V9.5c.5.37.84.91.96 1.54l.04.01V6.18a1.5 1.5 0 0 0-.94-1.4l-5.76-2.3Zm-2.23.93a2.5 2.5 0 0 1 1.86 0l5.22 2.09-2.27.91-6.16-2.46 1.35-.54Zm-2.7 1.08 6.16 2.46L10 7.96 3.85 5.5l2.53-1.01Zm5.63 7.5v-.5c0-.82.67-1.49 1.5-1.49h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm3.5-1h-2a.5.5 0 0 0-.5.5v.5h3v-.5a.5.5 0 0 0-.5-.5ZM17 16.5V16h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 1 0 1 0V16h3v.5a.5.5 0 1 0 1 0Z"]));
export const BracesFilled = ( /*#__PURE__*/createFluentIcon('BracesFilled', "1em", ["M3.5 5.75A2.75 2.75 0 0 1 6.23 3a.75.75 0 0 1 0 1.5C5.55 4.5 5 5.06 5 5.75L5 8.38c0 .6-.21 1.17-.58 1.62.37.45.58 1.02.58 1.62v2.63c0 .7.56 1.25 1.25 1.25a.75.75 0 1 1 0 1.5 2.75 2.75 0 0 1-2.75-2.75v-2.63c0-.4-.22-.76-.57-.94a.75.75 0 0 1 0-1.36c.35-.18.57-.54.57-.94V5.75Zm13 0A2.75 2.75 0 0 0 13.77 3a.75.75 0 0 0 0 1.5c.69 0 1.25.56 1.25 1.25L15 8.38c0 .6.21 1.17.58 1.62a2.56 2.56 0 0 0-.58 1.62v2.63c0 .7-.56 1.25-1.25 1.25a.75.75 0 1 0 0 1.5 2.75 2.75 0 0 0 2.75-2.75v-2.63c0-.4.22-.76.57-.94a.75.75 0 0 0 0-1.36 1.06 1.06 0 0 1-.57-.94V5.75Z"]));
export const BracesRegular = ( /*#__PURE__*/createFluentIcon('BracesRegular', "1em", ["M6.5 3A2.5 2.5 0 0 0 4 5.5v2.88c0 .5-.28.95-.72 1.17a.5.5 0 0 0 0 .9c.44.22.72.68.72 1.17v2.88A2.5 2.5 0 0 0 6.5 17a.5.5 0 0 0 0-1A1.5 1.5 0 0 1 5 14.5v-2.88c0-.62-.24-1.2-.66-1.62.42-.42.66-1 .66-1.62V5.5C5 4.67 5.67 4 6.5 4a.5.5 0 0 0 0-1Zm7 0A2.5 2.5 0 0 1 16 5.5v2.88c0 .5.28.95.72 1.17a.5.5 0 0 1 0 .9 1.3 1.3 0 0 0-.72 1.17v2.88a2.5 2.5 0 0 1-2.5 2.5.5.5 0 0 1 0-1c.83 0 1.5-.67 1.5-1.5v-2.88c0-.62.24-1.2.66-1.62A2.3 2.3 0 0 1 15 8.38V5.5c0-.83-.67-1.5-1.5-1.5a.5.5 0 0 1 0-1Z"]));
export const BracesVariableFilled = ( /*#__PURE__*/createFluentIcon('BracesVariableFilled', "1em", ["M5.75 2.5A2.75 2.75 0 0 0 3 5.25v3.13c0 .4-.22.76-.57.94a.75.75 0 0 0 0 1.36c.35.18.57.54.57.94v3.13a2.75 2.75 0 0 0 2.75 2.75.75.75 0 0 0 0-1.5c-.69 0-1.25-.56-1.25-1.25v-3.13c0-.6-.21-1.17-.58-1.62.37-.45.58-1.02.58-1.62V5.25C4.5 4.56 5.06 4 5.75 4a.75.75 0 0 0 0-1.5Zm8.5 0A2.75 2.75 0 0 1 17 5.25v3.13c0 .4.22.76.57.94a.75.75 0 0 1 0 1.36c-.35.18-.57.54-.57.94v3.13a2.75 2.75 0 0 1-2.75 2.75.75.75 0 0 1 0-1.5c.69 0 1.25-.56 1.25-1.25v-3.13c0-.6.21-1.17.58-1.62a2.56 2.56 0 0 1-.58-1.62V5.25c0-.69-.56-1.25-1.25-1.25a.75.75 0 0 1 0-1.5ZM8.11 6.06a.75.75 0 1 0-1.22.88L9.08 10l-2.19 3.06a.75.75 0 0 0 1.22.88L10 11.29l1.89 2.65a.75.75 0 0 0 1.22-.88L10.92 10l2.19-3.06a.75.75 0 0 0-1.22-.88L10 8.71 8.11 6.06Z"]));
export const BracesVariableRegular = ( /*#__PURE__*/createFluentIcon('BracesVariableRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v2.88c0 .5-.28.95-.72 1.17a.5.5 0 0 0 0 .9c.44.22.72.68.72 1.17v2.88A2.5 2.5 0 0 0 5.5 17a.5.5 0 0 0 0-1A1.5 1.5 0 0 1 4 14.5v-2.88c0-.62-.24-1.2-.66-1.62.42-.42.66-1 .66-1.62V5.5C4 4.67 4.67 4 5.5 4a.5.5 0 0 0 0-1Zm9 0A2.5 2.5 0 0 1 17 5.5v2.88c0 .5.28.95.72 1.17a.5.5 0 0 1 0 .9 1.3 1.3 0 0 0-.72 1.17v2.88a2.5 2.5 0 0 1-2.5 2.5.5.5 0 0 1 0-1c.83 0 1.5-.67 1.5-1.5v-2.88c0-.62.24-1.2.66-1.62A2.3 2.3 0 0 1 16 8.38V5.5c0-.83-.67-1.5-1.5-1.5a.5.5 0 0 1 0-1ZM7.9 6.2a.5.5 0 0 0-.8.6L9.38 10l-2.3 3.2a.5.5 0 0 0 .82.6L10 10.85l2.1 2.93a.5.5 0 0 0 .8-.58L10.62 10l2.3-3.2a.5.5 0 1 0-.82-.6L10 9.15 7.9 6.21Z"]));
export const BrainFilled = ( /*#__PURE__*/createFluentIcon('BrainFilled', "1em", ["M10.5 17.25a2.96 2.96 0 0 0 4.89-1.64l.04-.19a3.25 3.25 0 0 0 .77-6.08c.49-.46.8-1.11.8-1.84v-.2c0-1.28-.9-2.4-2.17-2.64l-.4-.08-.13-.63a2.42 2.42 0 0 0-3.8-1.49v14.8Zm-1-14.79a2.42 2.42 0 0 0-3.8 1.49l-.12.63-.41.08A2.7 2.7 0 0 0 3 7.3v.2c0 .73.31 1.38.8 1.84a3.25 3.25 0 0 0 .78 6.08l.03.19a2.97 2.97 0 0 0 4.89 1.64V2.46Z"]));
export const BrainRegular = ( /*#__PURE__*/createFluentIcon('BrainRegular', "1em", ["M5.7 3.95a2.42 2.42 0 0 1 4.3-1 2.42 2.42 0 0 1 4.3 1l.12.63.41.08A2.7 2.7 0 0 1 17 7.3v.2a2.5 2.5 0 0 1-.8 1.84 3.25 3.25 0 0 1-.77 6.08l-.04.19A2.97 2.97 0 0 1 10 16.68a2.97 2.97 0 0 1-5.39-1.07l-.03-.19a3.25 3.25 0 0 1-.78-6.08A2.5 2.5 0 0 1 3 7.5v-.2c0-1.28.9-2.4 2.17-2.64l.4-.08.13-.63ZM14.5 10a.5.5 0 0 1 0-1c.83 0 1.5-.67 1.5-1.5v-.2c0-.8-.57-1.5-1.37-1.66l-.73-.15a.5.5 0 0 1-.39-.4l-.2-.95a1.42 1.42 0 0 0-2.81.28v10.6a1.97 1.97 0 0 0 3.9.4l.11-.52a.5.5 0 0 1 .4-.39l.28-.06a2.25 2.25 0 0 0-.44-4.45h-.25Zm-5 4V4.42a1.42 1.42 0 0 0-2.82-.28l-.19.96a.5.5 0 0 1-.4.39l-.72.15A1.7 1.7 0 0 0 4 7.3v.2C4 8.33 4.67 9 5.5 9a.5.5 0 0 1 0 1h-.25a2.25 2.25 0 0 0-.44 4.45l.29.06c.2.04.35.2.39.4l.1.5a1.97 1.97 0 0 0 3.91-.38V14Z"]));
export const BrainCircuitFilled = ( /*#__PURE__*/createFluentIcon('BrainCircuitFilled', "1em", ["M8.08 2c.53 0 1.02.17 1.42.46V6h-.59a1.5 1.5 0 1 0 0 1h.59v10.23a3 3 0 0 1-4.97-1.82A3.24 3.24 0 0 1 2.9 10h2.6c.28 0 .5.22.5.5v.59a1.5 1.5 0 1 0 1 0v-.59C7 9.67 6.33 9 5.5 9h-2c-.3-.42-.5-.94-.5-1.5v-.2c0-1.28.9-2.4 2.17-2.64l.4-.09.13-.62A2.42 2.42 0 0 1 8.08 2Zm3.84 0c1.16 0 2.15.82 2.38 1.95l.12.62.41.09A2.7 2.7 0 0 1 17 7.3v.2c0 .73-.31 1.38-.8 1.84a3.25 3.25 0 0 1-.73 6.07 3 3 0 0 1-4.97 1.82V13h2c.83 0 1.5-.67 1.5-1.5v-.59a1.5 1.5 0 1 0-1 0v.59a.5.5 0 0 1-.5.5h-2V2.46c.4-.29.89-.46 1.42-.46ZM6.5 12a.5.5 0 1 1 0 1 .5.5 0 0 1 0-1Zm7-3a.5.5 0 1 1 0 1 .5.5 0 0 1 0-1Zm-6-3a.5.5 0 1 1 0 1 .5.5 0 0 1 0-1Z"]));
export const BrainCircuitRegular = ( /*#__PURE__*/createFluentIcon('BrainCircuitRegular', "1em", ["M5.7 3.95a2.42 2.42 0 0 1 4.3-1 2.42 2.42 0 0 1 4.3 1l.12.63.41.08A2.7 2.7 0 0 1 17 7.3v.2a2.5 2.5 0 0 1-.8 1.84 3.25 3.25 0 0 1-.77 6.08l-.04.19A2.97 2.97 0 0 1 10 16.68a2.97 2.97 0 0 1-5.39-1.07l-.03-.19a3.25 3.25 0 0 1-.78-6.08A2.5 2.5 0 0 1 3 7.5v-.2c0-1.28.9-2.4 2.17-2.64l.4-.08.13-.63ZM14 10.9v.59c0 .83-.67 1.5-1.5 1.5h-2v2.03a1.97 1.97 0 0 0 3.9.38l.11-.5a.5.5 0 0 1 .4-.4l.28-.06a2.25 2.25 0 0 0-.28-4.44 1.5 1.5 0 0 1-.91.9Zm-1 0a1.5 1.5 0 1 1 1.9-1.96A1.5 1.5 0 0 0 16 7.5v-.2c0-.8-.57-1.5-1.37-1.66l-.73-.15a.5.5 0 0 1-.39-.4l-.2-.95a1.42 1.42 0 0 0-2.81.28V12h2a.5.5 0 0 0 .5-.5v-.59ZM9.5 6V4.42a1.42 1.42 0 0 0-2.82-.28l-.19.96a.5.5 0 0 1-.4.39l-.72.15A1.7 1.7 0 0 0 4 7.3v.2C4 8.33 4.67 9 5.5 9h1c.83 0 1.5.67 1.5 1.5v.59a1.5 1.5 0 1 1-1 0v-.59a.5.5 0 0 0-.5-.5H5.25a2.25 2.25 0 0 0-.44 4.45l.29.06c.2.04.35.2.39.4l.1.5a1.97 1.97 0 0 0 3.91-.38V7h-.59a1.5 1.5 0 1 1 0-1h.59ZM8 6.5a.5.5 0 1 0-1 0 .5.5 0 0 0 1 0ZM7.5 13a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Zm6-3a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1Z"]));
export const BrainSparkleFilled = ( /*#__PURE__*/createFluentIcon('BrainSparkleFilled', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM17.5 12c-.27 0-.52-.08-.74-.23a1.4 1.4 0 0 1-.48-.62l-.26-.8a.52.52 0 0 0-.14-.22.64.64 0 0 0-.22-.14l-.77-.25c-.27-.1-.49-.26-.65-.48a1.3 1.3 0 0 1-.12-1.3 1.32 1.32 0 0 1-.45-.22 1.51 1.51 0 0 1-.52-.69l-.36-1.09a1.27 1.27 0 0 0-.29-.47 1.3 1.3 0 0 0-.47-.3l-1.06-.34a1.4 1.4 0 0 1-.47-.27v12.67a2.96 2.96 0 0 0 4.89-1.64l.04-.19a3.25 3.25 0 0 0 2.55-3.5c-.15.06-.31.08-.48.08Zm-8-9.54a2.42 2.42 0 0 0-3.8 1.49l-.12.63-.41.08A2.7 2.7 0 0 0 3 7.3v.2c0 .73.31 1.38.8 1.84a3.25 3.25 0 0 0 .78 6.08l.03.19a2.97 2.97 0 0 0 4.89 1.64V2.46Z"]));
export const BrainSparkleRegular = ( /*#__PURE__*/createFluentIcon('BrainSparkleRegular', "1em", ["m14.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Zm-2.8 3.68a1.47 1.47 0 0 0 1.01.04l.01.32a3.25 3.25 0 0 1-2.57 3.17l-.04.19A2.97 2.97 0 0 1 10 16.68a2.97 2.97 0 0 1-5.39-1.07l-.03-.19a3.25 3.25 0 0 1-.78-6.08A2.5 2.5 0 0 1 3 7.5v-.2c0-1.28.9-2.4 2.17-2.64l.4-.08.13-.63a2.42 2.42 0 0 1 4.3-1 2.44 2.44 0 0 1 .26-.28 1.4 1.4 0 0 0-.26.83 1.4 1.4 0 0 0 .5 1.08v10.45a1.97 1.97 0 0 0 3.9.38l.11-.5a.5.5 0 0 1 .4-.4l.28-.06a2.25 2.25 0 0 0 1.78-2.56ZM9.5 15.03V4.43a1.42 1.42 0 0 0-2.82-.29l-.19.96a.5.5 0 0 1-.4.39l-.72.15A1.7 1.7 0 0 0 4 7.3v.2C4 8.33 4.67 9 5.5 9a.5.5 0 0 1 0 1h-.25a2.25 2.25 0 0 0-.44 4.45l.29.06c.2.04.35.2.39.4l.1.5a1.97 1.97 0 0 0 3.91-.38Z"]));
export const BranchFilled = ( /*#__PURE__*/createFluentIcon('BranchFilled', "1em", ["M10 5a3 3 0 0 1-2.15 2.88A5.76 5.76 0 0 0 12 9.98a3 3 0 1 1 .17 1.01A6.8 6.8 0 0 1 7.5 9v3.05a3 3 0 1 1-1 0V7.96A3 3 0 1 1 10 5Z"]));
export const BranchRegular = ( /*#__PURE__*/createFluentIcon('BranchRegular', "1em", ["M10 5a3 3 0 0 1-2.15 2.88A5.76 5.76 0 0 0 12 9.98a3 3 0 1 1 .17 1.01A6.8 6.8 0 0 1 7.5 9v3.05a3 3 0 1 1-1 0V7.96A3 3 0 1 1 10 5ZM7 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm10 3a2 2 0 1 0-4 0 2 2 0 0 0 4 0ZM7 17a2 2 0 1 0 0-4 2 2 0 0 0 0 4Z"]));
export const BranchCompareFilled = ( /*#__PURE__*/createFluentIcon('BranchCompareFilled', "1em", ["M11.15 6.85a.5.5 0 0 0 .7-.7L10.71 5h1.79A2.5 2.5 0 0 1 15 7.5V12a3 3 0 1 0 1 .17V7.5A3.5 3.5 0 0 0 12.5 4h-1.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2ZM5 8a3 3 0 1 0-1-.17v4.67A3.5 3.5 0 0 0 7.5 16h1.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L9.29 15H7.5A2.5 2.5 0 0 1 5 12.5V8Z"]));
export const BranchCompareRegular = ( /*#__PURE__*/createFluentIcon('BranchCompareRegular', "1em", ["M11.15 6.85a.5.5 0 0 0 .7-.7L10.71 5h1.79A2.5 2.5 0 0 1 15 7.5V12a3 3 0 1 0 1 .17V7.5A3.5 3.5 0 0 0 12.5 4h-1.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2ZM17 15a2 2 0 1 1-4 0 2 2 0 0 1 4 0ZM8 5a3 3 0 0 1-3 3v4.5A2.5 2.5 0 0 0 7.5 15h1.8l-1.15-1.15a.5.5 0 0 1 .7-.7l2 2c.2.2.2.5 0 .7l-2 2a.5.5 0 0 1-.7-.7L9.29 16H7.5A3.5 3.5 0 0 1 4 12.5V7.83A3 3 0 1 1 8 5ZM7 5a2 2 0 1 0-4 0 2 2 0 0 0 4 0Z"]));
export const BranchForkFilled = ( /*#__PURE__*/createFluentIcon('BranchForkFilled', "1em", ["M9 5a3 3 0 0 1-2.5 2.96V10H12c.83 0 1.5-.67 1.5-1.5v-.54a3 3 0 1 1 1 0v.54A2.5 2.5 0 0 1 12 11H6.5v1.04a3 3 0 1 1-1 0V7.96A3 3 0 1 1 9 5Z"]));
export const BranchForkRegular = ( /*#__PURE__*/createFluentIcon('BranchForkRegular', "1em", ["M9 5a3 3 0 1 0-3.5 2.96v4.08a3 3 0 1 0 1 0V11H12a2.5 2.5 0 0 0 2.5-2.5v-.54a3 3 0 1 0-1 0v.54c0 .83-.67 1.5-1.5 1.5H6.5V7.96A3 3 0 0 0 9 5ZM6 7a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm0 10a2 2 0 1 1 0-4 2 2 0 0 1 0 4ZM16 5a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"]));
export const BranchForkHintFilled = ( /*#__PURE__*/createFluentIcon('BranchForkHintFilled', "1em", ["M6 2a3 3 0 0 0-.5 5.96v3.79a.5.5 0 0 0 1 0V11H12a2.5 2.5 0 0 0 2.5-2.5v-.54a3 3 0 1 0-1 0v.54c0 .83-.67 1.5-1.5 1.5H6.5V7.96A3 3 0 0 0 6 2ZM4.87 13.4a.5.5 0 1 0-.58-.8 3.02 3.02 0 0 0-1.12 1.54.5.5 0 1 0 .96.3 1.99 1.99 0 0 1 .74-1.03Zm2.9-.8a.5.5 0 1 0-.57.8 2.02 2.02 0 0 1 .75 1.04.5.5 0 1 0 .95-.3 2.99 2.99 0 0 0-1.12-1.55ZM4.3 16a.5.5 0 0 0-.88.5 3 3 0 0 0 1.38 1.27.5.5 0 1 0 .42-.91 2 2 0 0 1-.92-.85Zm4.37.5a.5.5 0 0 0-.87-.5 2 2 0 0 1-.98.88.5.5 0 1 0 .38.92 3 3 0 0 0 1.47-1.3Z"]));
export const BranchForkHintRegular = ( /*#__PURE__*/createFluentIcon('BranchForkHintRegular', "1em", ["M6 2a3 3 0 0 0-.5 5.96v3.79a.5.5 0 0 0 1 0V11H12a2.5 2.5 0 0 0 2.5-2.5v-.54a3 3 0 1 0-1 0v.54c0 .83-.67 1.5-1.5 1.5H6.5V7.96A3 3 0 0 0 6 2Zm8 5a2 2 0 1 1 0-4 2 2 0 0 1 0 4ZM6 7a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm-1.13 6.4a.5.5 0 1 0-.58-.8 3.02 3.02 0 0 0-1.12 1.54.5.5 0 1 0 .96.3 1.99 1.99 0 0 1 .74-1.03Zm2.9-.8a.5.5 0 1 0-.57.8 2.02 2.02 0 0 1 .75 1.04.5.5 0 1 0 .95-.3 2.99 2.99 0 0 0-1.12-1.55ZM4.3 16a.5.5 0 0 0-.88.5 3 3 0 0 0 1.38 1.27.5.5 0 1 0 .42-.91 2 2 0 0 1-.92-.85Zm4.37.5a.5.5 0 0 0-.87-.5 2 2 0 0 1-.98.88.5.5 0 1 0 .38.92 3 3 0 0 0 1.47-1.3Z"]));
export const BranchForkLinkFilled = ( /*#__PURE__*/createFluentIcon('BranchForkLinkFilled', "1em", ["M5.5 7.96a3 3 0 1 0-1 0v4.08a3 3 0 1 0 1 0V11H11a2.5 2.5 0 0 0 2.5-2.5v-.54a3 3 0 1 0-1 0v.54c0 .83-.67 1.5-1.5 1.5H5.5V7.96Zm7 5.04a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const BranchForkLinkRegular = ( /*#__PURE__*/createFluentIcon('BranchForkLinkRegular', "1em", ["M5 2a3 3 0 0 1 .5 5.96V10H11c.83 0 1.5-.67 1.5-1.5v-.54a3 3 0 1 1 1 0v.54A2.5 2.5 0 0 1 11 11H5.5v1.04a3 3 0 1 1-1 0V7.96A3 3 0 0 1 5 2ZM3 5a2 2 0 1 0 4 0 2 2 0 0 0-4 0Zm0 10a2 2 0 1 0 4 0 2 2 0 0 0-4 0Zm10-8a2 2 0 1 0 0-4 2 2 0 0 0 0 4Zm-.5 6a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 0 0 0 1h.5a1.5 1.5 0 0 1 0 3H16a.5.5 0 0 0 0 1h.5a2.5 2.5 0 0 0 0-5H16Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const BranchRequestFilled = ( /*#__PURE__*/createFluentIcon('BranchRequestFilled', "1em", ["M8 5a3 3 0 0 1-2.5 2.96v4.08a3 3 0 1 1-1 0V7.96A3 3 0 1 1 8 5Zm3.85 1.85a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 0-.7l2-2a.5.5 0 0 1 .7.7L10.71 4h1.79A3.5 3.5 0 0 1 16 7.5v4.67a3 3 0 1 1-1-.17V7.5A2.5 2.5 0 0 0 12.5 5h-1.8l1.15 1.15c.2.2.2.5 0 .7Z"]));
export const BranchRequestRegular = ( /*#__PURE__*/createFluentIcon('BranchRequestRegular', "1em", ["M5.5 7.96a3 3 0 1 0-1 0v4.08a3 3 0 1 0 1 0V7.96ZM5 7a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm2 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm4.15-8.15a.5.5 0 0 0 .7-.7L10.71 5h1.79A2.5 2.5 0 0 1 15 7.5V12a3 3 0 1 0 1 .17V7.5A3.5 3.5 0 0 0 12.5 4h-1.8l1.15-1.15a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2ZM17 15a2 2 0 1 1-4 0 2 2 0 0 1 4 0Z"]));
export const BranchRequestClosedFilled = ( /*#__PURE__*/createFluentIcon('BranchRequestClosedFilled', "1em", ["M5.5 7.96a3 3 0 1 0-1 0v4.08a3 3 0 1 0 1 0V7.96ZM18 15a3 3 0 1 1-3.5-2.96V8.5a.5.5 0 0 1 1 0v3.54A3 3 0 0 1 18 15ZM13.35 2.65a.5.5 0 0 0-.7.7L14.29 5l-1.64 1.65a.5.5 0 0 0 .7.7L15 5.71l1.65 1.64a.5.5 0 0 0 .7-.7L15.71 5l1.64-1.65a.5.5 0 0 0-.7-.7L15 4.29l-1.65-1.64Z"]));
export const BranchRequestClosedRegular = ( /*#__PURE__*/createFluentIcon('BranchRequestClosedRegular', "1em", ["M3 5a2 2 0 1 1 4 0 2 2 0 0 1-4 0Zm2.5 2.96a3 3 0 1 0-1 0v4.08a3 3 0 1 0 1 0V7.96ZM5 13a2 2 0 1 1 0 4 2 2 0 0 1 0-4Zm10 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-3 2a3 3 0 0 1 2.5-2.96V8.5a.5.5 0 0 1 1 0v3.54A3 3 0 1 1 12 15Zm1.35-12.35a.5.5 0 0 0-.7.7L14.29 5l-1.64 1.65a.5.5 0 0 0 .7.7L15 5.71l1.65 1.64a.5.5 0 0 0 .7-.7L15.71 5l1.64-1.65a.5.5 0 0 0-.7-.7L15 4.29l-1.65-1.64Z"]));
export const BranchRequestDraftFilled = ( /*#__PURE__*/createFluentIcon('BranchRequestDraftFilled', "1em", ["M5.5 7.96a3 3 0 1 0-1 0v4.08a3 3 0 1 0 1 0V7.96ZM18 15a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm-1.75-6.5a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM15 5.25a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const BranchRequestDraftRegular = ( /*#__PURE__*/createFluentIcon('BranchRequestDraftRegular', "1em", ["M3 5a2 2 0 1 1 4 0 2 2 0 0 1-4 0Zm2.5 2.96a3 3 0 1 0-1 0v4.08a3 3 0 1 0 1 0V7.96ZM5 13a2 2 0 1 1 0 4 2 2 0 0 1 0-4Zm10 0a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm-3 2a3 3 0 1 1 6 0 3 3 0 0 1-6 0Zm4.25-6.5a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM15 5.25a1.25 1.25 0 1 0 0-2.5 1.25 1.25 0 0 0 0 2.5Z"]));
export const BreakoutRoomFilled = ( /*#__PURE__*/createFluentIcon('BreakoutRoomFilled', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3h-3.35A3.99 3.99 0 0 0 12 14v-2a4 4 0 0 0-4-4H6c-1.2 0-2.27.52-3 1.35V6Zm3 3a3 3 0 0 0-3 3v2a3 3 0 0 0 3 3h2a3 3 0 0 0 3-3v-2a3 3 0 0 0-3-3H6Z"]));
export const BreakoutRoomRegular = ( /*#__PURE__*/createFluentIcon('BreakoutRoomRegular', "1em", ["M3 6a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3h-3.35c.32-.29.6-.62.81-1H14a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2H6a2 2 0 0 0-2 2v2.54c-.38.21-.71.49-1 .81V6Zm3 3a3 3 0 0 0-3 3v2a3 3 0 0 0 3 3h2a3 3 0 0 0 3-3v-2a3 3 0 0 0-3-3H6Zm-2 3c0-1.1.9-2 2-2h2a2 2 0 0 1 2 2v2a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2v-2Z"]));
export const BriefcaseColor = ( /*#__PURE__*/createFluentIcon('BriefcaseColor', "1em", `<path fill-rule="evenodd" clip-rule="evenodd" d="M11.25 2c.97 0 1.75.78 1.75 1.75V5l-3 1.5L7 5V3.75C7 2.78 7.78 2 8.75 2h2.5Zm-2.5 1a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z" fill="url(#ic_fluent_briefcase_20_color__a)"/><path d="M3 8h14v5.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 13.5V8Z" fill="url(#ic_fluent_briefcase_20_color__b)"/><path d="M3 8h14v5.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 13.5V8Z" fill="url(#ic_fluent_briefcase_20_color__c)"/><path d="M3 7.5A2.5 2.5 0 0 1 5.5 5h9A2.5 2.5 0 0 1 17 7.5v2c0 .83-.67 1.5-1.5 1.5h-11A1.5 1.5 0 0 1 3 9.5v-2Z" fill="url(#ic_fluent_briefcase_20_color__d)"/><path d="M10.5 9h-1a.5.5 0 0 0-.5.5v2.01c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5V9.5a.5.5 0 0 0-.5-.5Z" fill="url(#ic_fluent_briefcase_20_color__e)"/><defs><linearGradient id="ic_fluent_briefcase_20_color__a" x1="6.73" y1="2.45" x2="8.31" y2="7.22" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#163697"/></linearGradient><linearGradient id="ic_fluent_briefcase_20_color__b" x1="3.5" y1="9.5" x2="8.32" y2="23.89" gradientUnits="userSpaceOnUse"><stop stop-color="#0FAFFF"/><stop offset="1" stop-color="#CC23D1"/></linearGradient><linearGradient id="ic_fluent_briefcase_20_color__d" x1="4.4" y1="5.25" x2="10.98" y2="13.02" gradientUnits="userSpaceOnUse"><stop stop-color="#80F1E6"/><stop offset=".55" stop-color="#40C4F5"/><stop offset="1" stop-color="#00A2FA"/></linearGradient><linearGradient id="ic_fluent_briefcase_20_color__e" x1="10" y1="9" x2="10" y2="11" gradientUnits="userSpaceOnUse"><stop stop-color="#B8F5FF"/><stop offset=".84" stop-color="#7CECFF"/></linearGradient><radialGradient id="ic_fluent_briefcase_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 8 -15.6051 0 10 8)"><stop offset=".24" stop-color="#194694"/><stop offset=".75" stop-color="#367AF2" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const BriefcaseFilled = ( /*#__PURE__*/createFluentIcon('BriefcaseFilled', "1em", ["M18 14a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3v-3.36c.73.83 1.8 1.36 3 1.36h4v.5c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5V12h4c1.2 0 2.27-.53 3-1.36V14ZM11.25 2c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 1 1 0 6h-4v-.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v.5H5a3 3 0 0 1 0-6h2V3.75C7 2.78 7.78 2 8.75 2h2.5Zm-2.5 1a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BriefcaseRegular = ( /*#__PURE__*/createFluentIcon('BriefcaseRegular', "1em", ["M11.25 2c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H5a3 3 0 0 1-3-2.85V8a3 3 0 0 1 3-3h2V3.75C7 2.78 7.78 2 8.75 2h2.5ZM17 11.23c-.53.48-1.23.77-2 .77h-4v.5a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5V12H5c-.77 0-1.47-.3-2-.77V14l.01.2A2 2 0 0 0 5 16h10a2 2 0 0 0 2-2v-2.77ZM5 6a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h4v-.5c0-.28.22-.5.5-.5h1c.28 0 .5.22.5.5v.5h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H5Zm3.75-3a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BriefcaseMedicalFilled = ( /*#__PURE__*/createFluentIcon('BriefcaseMedicalFilled', "1em", ["M11.25 2c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3h2V3.75C7 2.78 7.78 2 8.75 2h2.5ZM10 8a.5.5 0 0 0-.5.5v2h-2a.5.5 0 0 0 0 1h2v2a.5.5 0 0 0 1 0v-2h2a.5.5 0 0 0 0-1h-2v-2A.5.5 0 0 0 10 8ZM8.75 3a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BriefcaseMedicalRegular = ( /*#__PURE__*/createFluentIcon('BriefcaseMedicalRegular', "1em", ["M11.25 2c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3H5a3 3 0 0 1-3-2.85V8a3 3 0 0 1 3-3h2V3.75C7 2.78 7.78 2 8.75 2h2.5ZM5 6a2 2 0 0 0-2 2v6l.01.2A2 2 0 0 0 5 16h10a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H5Zm5 2c.27 0 .5.23.5.5v2h2a.5.5 0 0 1 0 1h-2v2a.5.5 0 0 1-1 0v-2h-2a.5.5 0 0 1 0-1h2v-2c0-.27.22-.5.5-.5ZM8.75 3a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BriefcaseOffFilled = ( /*#__PURE__*/createFluentIcon('BriefcaseOffFilled', "1em", ["M2.15 2.15c.2-.2.5-.2.7 0l15 15a.5.5 0 0 1-.7.7l-1.06-1.06c-.34.13-.7.21-1.09.21H5a3 3 0 0 1-3-3v-3.36c.73.83 1.8 1.36 3 1.36h4v.5c0 .28.22.5.5.5h1a.5.5 0 0 0 .5-.5V12h.3l-1.97-1.97a.5.5 0 0 0-.33.47v.5H5a3 3 0 0 1-.64-5.93L2.15 2.85a.5.5 0 0 1 0-.7ZM18 14c0 .54-.15 1.05-.4 1.48L14.12 12H15c1.2 0 2.27-.53 3-1.36V14ZM11.25 2c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 1 1 0 6h-1.88L7 4.88V3.75C7 2.78 7.78 2 8.75 2h2.5Zm-2.5 1a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BriefcaseOffRegular = ( /*#__PURE__*/createFluentIcon('BriefcaseOffRegular', "1em", ["M2.15 2.15c.2-.2.5-.2.7 0l15 15a.5.5 0 0 1-.7.7l-1.06-1.06c-.34.13-.7.21-1.09.21H5a3 3 0 0 1-3-2.85V8a3 3 0 0 1 2.36-2.93L2.15 2.85a.5.5 0 0 1 0-.7ZM3 14l.01.2A2 2 0 0 0 5 16h10c.1 0 .18 0 .27-.02L11.3 12H11v.5a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5V12H5c-.77 0-1.47-.3-2-.77V14Zm8.25-12c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 0 1 3 3v6c0 .54-.15 1.05-.4 1.48l-.74-.74A2 2 0 0 0 17 14v-2.77c-.53.48-1.23.77-2 .77h-.88l-1-1H15a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H8.12L7 4.88V3.75C7 2.78 7.78 2 8.75 2h2.5ZM5 6a2 2 0 0 0-2 2v1c0 1.1.9 2 2 2h4v-.5c0-.21.14-.4.33-.47L5.29 6H5Zm3.75-3a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BriefcaseSearchFilled = ( /*#__PURE__*/createFluentIcon('BriefcaseSearchFilled', "1em", ["M4.5 10a3.5 3.5 0 0 1 2.8 5.6l2.55 2.55a.5.5 0 1 1-.7.7L6.6 16.3A3.5 3.5 0 1 1 4.5 10ZM18 14a3 3 0 0 1-3 3h-4.88l-1.56-1.56A4.48 4.48 0 0 0 8.97 13h1.53a.5.5 0 0 0 .5-.5V12h4c1.2 0 2.27-.53 3-1.36V14ZM4.5 11a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Zm6.75-9c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 1 1 0 6h-4v-.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v.5h-.76a4.5 4.5 0 0 0-5.83-1.49A3 3 0 0 1 5 5h2V3.75C7 2.78 7.78 2 8.75 2h2.5Zm-2.5 1a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BriefcaseSearchRegular = ( /*#__PURE__*/createFluentIcon('BriefcaseSearchRegular', "1em", ["M4.5 10a3.5 3.5 0 0 1 2.8 5.6l2.55 2.55a.5.5 0 1 1-.7.7L6.6 16.3A3.5 3.5 0 1 1 4.5 10Zm6.75-8c.97 0 1.75.78 1.75 1.75V5h2a3 3 0 0 1 3 3v6a3 3 0 0 1-3 3h-4.88l-1-1H15a2 2 0 0 0 2-2v-2.77c-.53.48-1.23.77-2 .77h-4v.5a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5v-2c0-.28.22-.5.5-.5h1c.28 0 .5.22.5.5v.5h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v1c0 .09 0 .17.02.25-.36.13-.7.3-1.02.5V8a3 3 0 0 1 3-3h2V3.75C7 2.78 7.78 2 8.75 2h2.5ZM4.5 11a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5Zm4.25-8a.75.75 0 0 0-.75.75V5h4V3.75a.75.75 0 0 0-.75-.75h-2.5Z"]));
export const BrightnessHighFilled = ( /*#__PURE__*/createFluentIcon('BrightnessHighFilled', "1em", ["M10.5 2.5a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0v-1ZM10 6a4 4 0 1 1 0 8 4 4 0 0 1 0-8Zm3 4a3 3 0 0 0-3-3v6a3 3 0 0 0 3-3Zm5 0a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h1c.28 0 .5.22.5.5Zm-7.5 6.5a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0v-1ZM4 10a.5.5 0 0 1-.5.5H2.46a.5.5 0 0 1 0-1H3.5c.28 0 .5.22.5.5Zm.85-5.85a.5.5 0 1 0-.7.7l1 1a.5.5 0 1 0 .7-.7l-1-1Zm-.7 11.7c.2.2.5.2.7 0l1-1a.5.5 0 0 0-.7-.7l-1 1a.5.5 0 0 0 0 .7Zm11-11.7a.5.5 0 0 1 .7.7l-1 1a.5.5 0 0 1-.7-.7l1-1Zm.7 11.7a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l1 1c.2.2.2.5 0 .7Z"]));
export const BrightnessHighRegular = ( /*#__PURE__*/createFluentIcon('BrightnessHighRegular', "1em", ["M10 2c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm0 12a4 4 0 1 0 0-8 4 4 0 0 0 0 8Zm0-1a3 3 0 1 1 0-6 3 3 0 0 1 0 6Zm7.5-2.5a.5.5 0 0 0 0-1h-1a.5.5 0 0 0 0 1h1ZM10 16c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm-6.5-5.5a.5.5 0 0 0 0-1H2.46a.5.5 0 0 0 0 1H3.5Zm.65-6.35c.2-.2.5-.2.7 0l1 1a.5.5 0 1 1-.7.7l-1-1a.5.5 0 0 1 0-.7Zm.7 11.7a.5.5 0 0 1-.7-.7l1-1a.5.5 0 0 1 .7.7l-1 1Zm11-11.7a.5.5 0 0 0-.7 0l-1 1a.5.5 0 0 0 .7.7l1-1a.5.5 0 0 0 0-.7Zm-.7 11.7a.5.5 0 0 0 .7-.7l-1-1a.5.5 0 0 0-.7.7l1 1Z"]));
export const BrightnessLowFilled = ( /*#__PURE__*/createFluentIcon('BrightnessLowFilled', "1em", ["M10 3c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm0 3a4 4 0 1 0 0 8 4 4 0 0 0 0-8Zm0 7V7a3 3 0 1 1 0 6Zm6.5-2.5a.5.5 0 0 0 0-1h-1a.5.5 0 0 0 0 1h1ZM10 15c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm-5.5-4.5a.5.5 0 0 0 0-1h-1a.5.5 0 0 0 0 1h1Zm.65-5.35c.2-.2.5-.2.7 0l.5.5a.5.5 0 1 1-.7.7l-.5-.5a.5.5 0 0 1 0-.7Zm.7 9.7a.5.5 0 0 1-.7-.7l.5-.5a.5.5 0 0 1 .7.7l-.5.5Zm9-9.7a.5.5 0 0 0-.7 0l-.5.5a.5.5 0 0 0 .7.7l.5-.5a.5.5 0 0 0 0-.7Zm-.7 9.7a.5.5 0 0 0 .7-.7l-.5-.5a.5.5 0 0 0-.7.7l.5.5Z"]));
export const BrightnessLowRegular = ( /*#__PURE__*/createFluentIcon('BrightnessLowRegular', "1em", ["M10.5 3.5a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0v-1ZM10 6a4 4 0 1 0 0 8 4 4 0 0 0 0-8Zm-3 4a3 3 0 1 1 6 0 3 3 0 0 1-6 0Zm10 0a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h1c.28 0 .5.22.5.5Zm-6.5 5.5a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0v-1ZM5 10a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1 0-1h1c.28 0 .5.22.5.5Zm.85-4.85a.5.5 0 1 0-.7.7l.5.5a.5.5 0 1 0 .7-.7l-.5-.5Zm-.7 9.7c.2.2.5.2.7 0l.5-.5a.5.5 0 0 0-.7-.7l-.5.5a.5.5 0 0 0 0 .7Zm9-9.7a.5.5 0 0 1 .7.7l-.5.5a.5.5 0 0 1-.7-.7l.5-.5Zm.7 9.7a.5.5 0 0 1-.7 0l-.5-.5a.5.5 0 0 1 .7-.7l.5.5c.2.2.2.5 0 .7Z"]));
export const BroadActivityFeedFilled = ( /*#__PURE__*/createFluentIcon('BroadActivityFeedFilled', "1em", ["M3.5 3C2.67 3 2 3.67 2 4.5v4c0 .83.67 1.5 1.5 1.5h13c.83 0 1.5-.67 1.5-1.5v-4c0-.83-.67-1.5-1.5-1.5h-13Zm0 9c-.83 0-1.5.67-1.5 1.5v2c0 .83.67 1.5 1.5 1.5h4c.83 0 1.5-.67 1.5-1.5v-2c0-.83-.67-1.5-1.5-1.5h-4Zm9 0c-.83 0-1.5.67-1.5 1.5v2c0 .83.67 1.5 1.5 1.5h4c.83 0 1.5-.67 1.5-1.5v-2c0-.83-.67-1.5-1.5-1.5h-4Z"]));
export const BroadActivityFeedRegular = ( /*#__PURE__*/createFluentIcon('BroadActivityFeedRegular', "1em", ["M2 4.5C2 3.67 2.67 3 3.5 3h13c.83 0 1.5.67 1.5 1.5v4c0 .83-.67 1.5-1.5 1.5h-13A1.5 1.5 0 0 1 2 8.5v-4ZM3.5 4a.5.5 0 0 0-.5.5v4c0 .28.22.5.5.5h13a.5.5 0 0 0 .5-.5v-4a.5.5 0 0 0-.5-.5h-13ZM2 13.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5v2c0 .83-.67 1.5-1.5 1.5h-4A1.5 1.5 0 0 1 2 15.5v-2Zm1.5-.5a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5h4a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5h-4Zm9-1c-.83 0-1.5.67-1.5 1.5v2c0 .83.67 1.5 1.5 1.5h4c.83 0 1.5-.67 1.5-1.5v-2c0-.83-.67-1.5-1.5-1.5h-4Zm-.5 1.5c0-.28.22-.5.5-.5h4c.28 0 .5.22.5.5v2a.5.5 0 0 1-.5.5h-4a.5.5 0 0 1-.5-.5v-2Z"]));
export const BroomFilled = ( /*#__PURE__*/createFluentIcon('BroomFilled', "1em", ["M17.91 2.18c.2.2.2.51 0 .7L13.3 7.5a5.6 5.6 0 0 0-.7-.7l4.6-4.62c.2-.2.51-.2.71 0Zm-5.66 5.66a4.5 4.5 0 0 0-6.36 0l-.42.42 6.36 6.36.42-.42a4.5 4.5 0 0 0 0-6.36Zm-10.5 2.75 2.9-1.74 6.5 6.5a.5.5 0 0 0 .1.08L9.5 18.35a.5.5 0 0 1-.78.1l-7.07-7.08a.5.5 0 0 1 .1-.78Z"]));
export const BroomRegular = ( /*#__PURE__*/createFluentIcon('BroomRegular', "1em", ["M17.91 2.18c.2.2.2.51 0 .7l-5.32 5.33a4.5 4.5 0 0 1-.34 6l-.66.66-2.09 3.48a.5.5 0 0 1-.78.1l-7.07-7.08a.5.5 0 0 1 .1-.78L5.22 8.5l.66-.66a4.5 4.5 0 0 1 5.99-.34l5.32-5.32c.2-.2.51-.2.71 0ZM6.24 8.9l4.95 4.95.36-.35A3.5 3.5 0 1 0 6.6 8.55l-.36.35Zm-.78.63L2.8 11.12l6.16 6.17 1.6-2.66-5.11-5.1Z"]));
export const BroomSparkleFilled = ( /*#__PURE__*/createFluentIcon('BroomSparkleFilled', "1em", ["M12.15 15.35a.5.5 0 0 0 .1.08l-1.75 2.92a.5.5 0 0 1-.78.1l-5.1-5.1c.04-.07.08-.14.1-.22l.02-.02.24-.76a.58.58 0 0 1 .14-.23l.05-.04A.58.58 0 0 1 5.3 12l.06-.03.76-.24.02-.01.1-.04a1.3 1.3 0 0 0 .72-1.53l5.2 5.2ZM6.89 7.84a4.5 4.5 0 0 1 6.36 6.36l-.42.42-6.36-6.36.42-.42ZM3.49 8a.3.3 0 0 1 .28.2l.25.77c.08.23.2.44.38.61v.01l.14.12a1.57 1.57 0 0 0 .48.25l.76.25h.02a.3.3 0 0 1 .2.3l-.01.08a.3.3 0 0 1-.05.09l-.06.06a.3.3 0 0 1-.08.05l-.77.25c-.23.07-.44.2-.61.38l-.13.13a1.58 1.58 0 0 0-.26.48l-.24.77a.3.3 0 0 1-.58 0l-.24-.77a1.58 1.58 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.2-.28.3.3 0 0 1 .2-.29l.77-.25a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2ZM18.2 2.18a.5.5 0 0 1 .71.7L14.3 7.5a5.6 5.6 0 0 0-.7-.7l4.6-4.62ZM5.48 0a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4L5.9 6.72a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.2 2.2 0 0 0-1.4-1.4L2.28 3.9a.42.42 0 0 1 0-.8l1.07-.35a2.21 2.21 0 0 0 1.38-1.4L5.08.28a.42.42 0 0 1 .4-.28Z"]));
export const BroomSparkleRegular = ( /*#__PURE__*/createFluentIcon('BroomSparkleRegular', "1em", ["M18.2 2.18a.5.5 0 0 1 .7.7L13.6 8.22a4.5 4.5 0 0 1-.34 6l-.66.66-2.1 3.48a.5.5 0 0 1-.77.1l-5.1-5.1c.04-.07.08-.14.1-.22l.02-.02.24-.76.02-.04 4.97 4.98 1.6-2.66-4.7-4.7-.06-.1-.05-.08-.06-.08a1.3 1.3 0 0 0-.57-.4l-.05-.01h-.02l-.7-.24.86-.52.67-.66a4.5 4.5 0 0 1 5.99-.34l5.32-5.32Zm-5.66 6.37a3.5 3.5 0 0 0-4.94 0l-.36.35 4.95 4.95.35-.35a3.5 3.5 0 0 0 0-4.95ZM3.48 8a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.18.05.28.1.3.1h.02a.3.3 0 0 1 .2.28.3.3 0 0 1-.2.29l-.77.25a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.58 1.58 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.2-.28.3.3 0 0 1 .2-.29l.77-.25a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm2-8a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4L5.9 6.72a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.2 2.2 0 0 0-1.4-1.4L2.28 3.9a.42.42 0 0 1 0-.8l1.07-.35a2.21 2.21 0 0 0 1.38-1.4L5.08.28a.42.42 0 0 1 .4-.28Z"]));
export const BubbleMultipleFilled = ( /*#__PURE__*/createFluentIcon('BubbleMultipleFilled', "1em", ["M19 4.5a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0ZM9.17 15.6a3.5 3.5 0 1 0 3.74-4.58 6 6 0 0 1-3.74 4.57ZM12 10a5 5 0 1 1-10 0 5 5 0 0 1 10 0ZM7.03 7.5a.5.5 0 0 0 .3.64 2.5 2.5 0 0 1 1.53 1.53.5.5 0 1 0 .94-.34A3.5 3.5 0 0 0 7.67 7.2a.5.5 0 0 0-.64.3Z"]));
export const BubbleMultipleRegular = ( /*#__PURE__*/createFluentIcon('BubbleMultipleRegular', "1em", ["M15.5 2a2.5 2.5 0 1 0 0 5 2.5 2.5 0 0 0 0-5ZM12 4.5a3.5 3.5 0 1 1 7 0 3.5 3.5 0 0 1-7 0ZM3 10a4 4 0 1 1 8 0 4 4 0 0 1-8 0Zm4-5a5 5 0 1 0 0 10A5 5 0 0 0 7 5Zm5.5 13a3.5 3.5 0 0 1-3.33-2.4c.32-.13.63-.28.91-.45A2.5 2.5 0 1 0 12.66 12c.1-.31.2-.64.25-.98A3.5 3.5 0 0 1 12.5 18ZM7.67 7.2a.5.5 0 1 0-.34.94 2.5 2.5 0 0 1 1.53 1.53.5.5 0 1 0 .94-.34A3.5 3.5 0 0 0 7.67 7.2Z"]));
export const BugFilled = ( /*#__PURE__*/createFluentIcon('BugFilled', "1em", ["M9 2.5a.5.5 0 0 0-1 0V3c0 .4.12.77.32 1.08A3 3 0 0 0 6 7h-.5A1.5 1.5 0 0 1 4 5.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 5.5 8H6v1.5H2.5a.5.5 0 0 0 0 1H6V12h-.5A2.5 2.5 0 0 0 3 14.5v2a.5.5 0 0 0 1 0v-2c0-.83.67-1.5 1.5-1.5H6a4 4 0 0 0 8 0h.5c.83 0 1.5.67 1.5 1.5v2a.5.5 0 0 0 1 0v-2a2.5 2.5 0 0 0-2.5-2.5H14v-1.5h3.5a.5.5 0 0 0 0-1H14V8h.5A2.5 2.5 0 0 0 17 5.5v-2a.5.5 0 0 0-1 0v2c0 .83-.67 1.5-1.5 1.5H14a3 3 0 0 0-2.32-2.92A2 2 0 0 0 12 3v-.5a.5.5 0 0 0-1 0V3a1 1 0 1 1-2 0v-.5Z"]));
export const BugRegular = ( /*#__PURE__*/createFluentIcon('BugRegular', "1em", ["M9 2.5a.5.5 0 0 0-1 0V3c0 .4.12.77.32 1.08A3 3 0 0 0 6 7h-.5A1.5 1.5 0 0 1 4 5.5v-2a.5.5 0 0 0-1 0v2A2.5 2.5 0 0 0 5.5 8H6v1.5H2.5a.5.5 0 0 0 0 1H6V12h-.5A2.5 2.5 0 0 0 3 14.5v2a.5.5 0 0 0 1 0v-2c0-.83.67-1.5 1.5-1.5H6a4 4 0 0 0 8 0h.5c.83 0 1.5.67 1.5 1.5v2a.5.5 0 0 0 1 0v-2a2.5 2.5 0 0 0-2.5-2.5H14v-1.5h3.5a.5.5 0 0 0 0-1H14V8h.5A2.5 2.5 0 0 0 17 5.5v-2a.5.5 0 0 0-1 0v2c0 .83-.67 1.5-1.5 1.5H14a3 3 0 0 0-2.32-2.92A2 2 0 0 0 12 3v-.5a.5.5 0 0 0-1 0V3a1 1 0 1 1-2 0v-.5ZM13 7v6a3 3 0 1 1-6 0V7c0-1.1.9-2 2-2h2a2 2 0 0 1 2 2Z"]));
export const BugArrowCounterclockwiseFilled = ( /*#__PURE__*/createFluentIcon('BugArrowCounterclockwiseFilled', "1em", ["M17 3.5a.5.5 0 0 0-1 0v2A1.5 1.5 0 0 1 14.5 7H14a3 3 0 0 0-2.31-2.92A2 2 0 0 0 12 3v-.5a.5.5 0 0 0-1 0V3a1 1 0 0 1-2 0v-.5a.5.5 0 1 0-1 0V3c0 .38.1.76.31 1.08A3 3 0 0 0 6 7h-.5A1.5 1.5 0 0 1 4 5.5v-2a.5.5 0 1 0-1 0v2A2.5 2.5 0 0 0 5.5 8H6v1.5H2.5a.5.5 0 1 0 0 1H6V12h-.5A2.5 2.5 0 0 0 3 14.5v2a.5.5 0 0 0 1 0v-2A1.5 1.5 0 0 1 5.5 13H6a3.99 3.99 0 0 0 3.59 3.96A5.49 5.49 0 0 1 14 9.02V8h.5A2.5 2.5 0 0 0 17 5.5v-2ZM14.5 10a4.5 4.5 0 1 0 0 9 4.5 4.5 0 0 0 0-9Zm0 7.25a2.74 2.74 0 0 1-2.05-.92.5.5 0 1 1 .75-.66 1.75 1.75 0 1 0 .4-2.67h.4a.5.5 0 0 1 0 1h-1.5a.5.5 0 0 1-.5-.63V12a.5.5 0 0 1 1 0v.2a2.75 2.75 0 1 1 1.5 5.05Z"]));
export const BugArrowCounterclockwiseRegular = ( /*#__PURE__*/createFluentIcon('BugArrowCounterclockwiseRegular', "1em", ["M17 3.5a.5.5 0 0 0-1 0v2A1.5 1.5 0 0 1 14.5 7H14a3 3 0 0 0-2.31-2.92A2 2 0 0 0 12 3v-.5a.5.5 0 0 0-1 0V3a1 1 0 0 1-2 0v-.5a.5.5 0 1 0-1 0V3c0 .38.1.76.31 1.08A3 3 0 0 0 6 7h-.5A1.5 1.5 0 0 1 4 5.5v-2a.5.5 0 1 0-1 0v2A2.5 2.5 0 0 0 5.5 8H6v1.5H2.5a.5.5 0 1 0 0 1H6V12h-.5A2.5 2.5 0 0 0 3 14.5v2a.5.5 0 0 0 1 0v-2A1.5 1.5 0 0 1 5.5 13H6a3.99 3.99 0 0 0 3.59 3.96 5.46 5.46 0 0 1-.41-1.09A2.99 2.99 0 0 1 7 13V7a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v2.21c.33-.09.66-.15 1-.19V8h.5A2.5 2.5 0 0 0 17 5.5v-2ZM14.5 10a4.5 4.5 0 1 0 0 9 4.5 4.5 0 0 0 0-9Zm0 7.25a2.74 2.74 0 0 1-2.05-.92.5.5 0 1 1 .75-.66 1.75 1.75 0 1 0 .4-2.67h.4a.5.5 0 0 1 0 1h-1.5a.5.5 0 0 1-.5-.63V12a.5.5 0 0 1 1 0v.2a2.75 2.75 0 1 1 1.5 5.05Z"]));
export const BugProhibitedFilled = ( /*#__PURE__*/createFluentIcon('BugProhibitedFilled', "1em", ["M14.5 10a4.5 4.5 0 1 0 0 9 4.5 4.5 0 0 0 0-9ZM11 14.5a3.5 3.5 0 0 1 5.6-2.8l-4.9 4.9c-.46-.6-.7-1.34-.7-2.1Zm3.5 3.5c-.76 0-1.5-.24-2.1-.7l4.9-4.9a3.48 3.48 0 0 1-.33 4.57A3.5 3.5 0 0 1 14.5 18ZM17 3.5a.5.5 0 0 0-1 0v2A1.5 1.5 0 0 1 14.5 7H14a3 3 0 0 0-2.31-2.92A2 2 0 0 0 12 3v-.5a.5.5 0 0 0-1 0V3a1 1 0 0 1-2 0v-.5a.5.5 0 1 0-1 0V3c0 .38.1.76.31 1.08A3 3 0 0 0 6 7h-.5A1.5 1.5 0 0 1 4 5.5v-2a.5.5 0 1 0-1 0v2A2.5 2.5 0 0 0 5.5 8H6v1.5H2.5a.5.5 0 1 0 0 1H6V12h-.5A2.5 2.5 0 0 0 3 14.5v2a.5.5 0 0 0 1 0v-2A1.5 1.5 0 0 1 5.5 13H6a3.99 3.99 0 0 0 3.59 3.96 5.46 5.46 0 0 1 .85-6.17A5.5 5.5 0 0 1 14 9.03V8h.5A2.5 2.5 0 0 0 17 5.5v-2Z"]));
export const BugProhibitedRegular = ( /*#__PURE__*/createFluentIcon('BugProhibitedRegular', "1em", ["M9.18 15.87c.1.38.23.74.4 1.09A3.99 3.99 0 0 1 6 13h-.5A1.5 1.5 0 0 0 4 14.5v2a.5.5 0 0 1-1 0v-2A2.5 2.5 0 0 1 5.5 12H6v-1.5H2.5a.5.5 0 0 1 0-1H6V8h-.5A2.5 2.5 0 0 1 3 5.5v-2a.5.5 0 0 1 1 0v2A1.5 1.5 0 0 0 5.5 7H6a3 3 0 0 1 2.31-2.92A2 2 0 0 1 8 3v-.5a.5.5 0 0 1 1 0V3a1 1 0 0 0 2 0v-.5a.5.5 0 0 1 1 0V3a2 2 0 0 1-.31 1.08A3 3 0 0 1 14 7h.5A1.5 1.5 0 0 0 16 5.5v-2a.5.5 0 0 1 1 0v2A2.5 2.5 0 0 1 14.5 8H14v1.03c-.34.03-.67.09-1 .18V7a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v6a2.99 2.99 0 0 0 2.18 2.87ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-7.3 2.1 4.9-4.9a3.48 3.48 0 0 0-4.57.33 3.5 3.5 0 0 0-.33 4.57Zm6.3-2.1c0-.76-.24-1.5-.7-2.1l-4.9 4.9a3.48 3.48 0 0 0 4.57-.33A3.5 3.5 0 0 0 18 14.5Z"]));
export const BuildingColor = ( /*#__PURE__*/createFluentIcon('BuildingColor', "1em", `<path d="M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5h11a.5.5 0 0 0 .5-.5v-8c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Z" fill="url(#ic_fluent_building_20_color__a)"/><path d="M10 18h3v-3.5a.5.5 0 0 0-.5-.5H10l-.5 2 .5 2Z" fill="url(#ic_fluent_building_20_color__b)"/><path d="M10 14H7.5a.5.5 0 0 0-.5.5V18h3v-4Z" fill="url(#ic_fluent_building_20_color__c)"/><path d="M7.5 5.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_20_color__d)"/><path d="M9.75 5a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z" fill="url(#ic_fluent_building_20_color__e)"/><path d="M9.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_20_color__f)"/><path d="M6.75 8a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z" fill="url(#ic_fluent_building_20_color__g)"/><path d="M6.75 12.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_20_color__h)"/><path d="M10.5 11.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_20_color__i)"/><path d="M12.75 12.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_20_color__j)"/><defs><linearGradient id="ic_fluent_building_20_color__a" x1="4" y1="2.5" x2="19.26" y2="17.15" gradientUnits="userSpaceOnUse"><stop stop-color="#29C3FF"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_building_20_color__b" x1="9.63" y1="14.75" x2="12.38" y2="17.25" gradientUnits="userSpaceOnUse"><stop stop-color="#0067BF"/><stop offset="1" stop-color="#003580"/></linearGradient><linearGradient id="ic_fluent_building_20_color__c" x1="7.11" y1="14.75" x2="9.79" y2="16.84" gradientUnits="userSpaceOnUse"><stop stop-color="#0067BF"/><stop offset="1" stop-color="#003580"/></linearGradient><linearGradient id="ic_fluent_building_20_color__d" x1="8.25" y1="4.17" x2="10.99" y2="14.03" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_20_color__e" x1="8.25" y1="4.17" x2="10.99" y2="14.03" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_20_color__f" x1="8.25" y1="4.17" x2="10.99" y2="14.03" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_20_color__g" x1="8.25" y1="4.17" x2="10.99" y2="14.03" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_20_color__h" x1="8.25" y1="4.17" x2="10.99" y2="14.03" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_20_color__i" x1="8.25" y1="4.17" x2="10.99" y2="14.03" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_20_color__j" x1="8.25" y1="4.17" x2="10.99" y2="14.03" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient></defs>`, { color: true }));
export const BuildingFilled = ( /*#__PURE__*/createFluentIcon('BuildingFilled', "1em", ["M4 3.5C4 2.67 4.67 2 5.5 2h6c.83 0 1.5.67 1.5 1.5V8h1.5c.83 0 1.5.67 1.5 1.5v8a.5.5 0 0 1-.5.5H13v-3.5a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0-.5.5V18H4.5a.5.5 0 0 1-.5-.5v-14Zm2.75 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm3.75-6.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM9.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm2.25.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM12 15v3h-1.5v-3H12Zm-2.5 0H8v3h1.5v-3Z"]));
export const BuildingRegular = ( /*#__PURE__*/createFluentIcon('BuildingRegular', "1em", ["M6.75 6.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm3.75-6.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm2.25.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM4.5 18a.5.5 0 0 1-.5-.5v-14C4 2.67 4.67 2 5.5 2h6c.83 0 1.5.67 1.5 1.5V8h1.5c.83 0 1.5.67 1.5 1.5v8a.5.5 0 0 1-.5.5h-11ZM5 3.5V17h2v-2.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5V17h2V9.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 1-.5-.5v-5a.5.5 0 0 0-.5-.5h-6a.5.5 0 0 0-.5.5ZM12 15h-1.5v2H12v-2Zm-2.5 0H8v2h1.5v-2Z"]));
export const BuildingBankFilled = ( /*#__PURE__*/createFluentIcon('BuildingBankFilled', "1em", ["M9.23 2.18a1.33 1.33 0 0 1 1.54 0l5.85 4.15A.92.92 0 0 1 16.1 8H3.9a.92.92 0 0 1-.52-1.67l5.85-4.15Zm.77 3.7a.83.83 0 1 0 0-1.67.83.83 0 0 0 0 1.66ZM4.5 9v4h2V9h-2ZM3 16.17c0-1.2.97-2.17 2.17-2.17h9.66c1.2 0 2.17.97 2.17 2.17v.33a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5v-.33ZM15.5 9v4h-2V9h2Zm-3 0v4h-2V9h2Zm-3 0v4h-2V9h2Z"]));
export const BuildingBankRegular = ( /*#__PURE__*/createFluentIcon('BuildingBankRegular', "1em", ["M10 5.87a.83.83 0 1 0 0-1.66.83.83 0 0 0 0 1.66Zm6 7.47V8h.1a.92.92 0 0 0 .52-1.67l-5.85-4.15a1.33 1.33 0 0 0-1.54 0L3.38 6.33A.92.92 0 0 0 3.9 8H4v5.34c-.6.38-1 1.06-1 1.83v1.33c0 .28.22.5.5.5h13a.5.5 0 0 0 .5-.5v-1.33c0-.77-.4-1.45-1-1.83ZM9.8 3a.33.33 0 0 1 .4 0l5.63 4H4.17L9.8 3ZM15 8v5h-2V8h2ZM5 13V8h2v5H5Zm.17 1h9.66c.65 0 1.17.52 1.17 1.17V16H4v-.83c0-.65.52-1.17 1.17-1.17Zm4.33-1H8V8h1.5v5Zm1 0V8H12v5h-1.5Z"]));
export const BuildingBankLinkFilled = ( /*#__PURE__*/createFluentIcon('BuildingBankLinkFilled', "1em", ["M9.23 2.18a1.33 1.33 0 0 1 1.54 0l5.85 4.15A.92.92 0 0 1 16.1 8H3.9a.92.92 0 0 1-.52-1.67l5.85-4.15Zm.77 3.7a.83.83 0 1 0 0-1.67.83.83 0 0 0 0 1.66ZM4.5 9v4h2V9h-2ZM3 16.17c0-1.2.97-2.17 2.17-2.17h3.17a3.49 3.49 0 0 0 0 3H3.5a.5.5 0 0 1-.5-.5v-.33ZM9.05 13c.14-.14.29-.26.45-.37V9h-2v4h1.55Zm2.45-1h1V9h-2v3.14c.32-.09.65-.14 1-.14Zm2 0h2V9h-2v3Zm-2 1a2.5 2.5 0 0 0 0 5h.5a.5.5 0 0 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 0 0 0-1h-.5Zm3.5 0a.5.5 0 1 0 0 1h.5a1.5 1.5 0 0 1 0 3H15a.5.5 0 1 0 0 1h.5a2.5 2.5 0 0 0 0-5H15Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 1 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const BuildingBankLinkRegular = ( /*#__PURE__*/createFluentIcon('BuildingBankLinkRegular', "1em", ["M10 5.87a.83.83 0 1 0 0-1.66.83.83 0 0 0 0 1.66ZM3.5 17h4.84a3.48 3.48 0 0 1-.3-1H4v-.83c0-.65.52-1.17 1.17-1.17h3.17c.17-.38.42-.71.71-1H8V8h1.5v4.63c.3-.21.64-.38 1-.49V8H12v4h1V8h2v4h.5c.17 0 .34.01.5.03V8h.1a.92.92 0 0 0 .52-1.67l-5.85-4.15a1.33 1.33 0 0 0-1.54 0L3.38 6.33A.92.92 0 0 0 3.9 8H4v5.34c-.6.38-1 1.06-1 1.83v1.33c0 .28.22.5.5.5ZM9.8 3a.33.33 0 0 1 .4 0l5.63 4H4.17L9.8 3ZM5 13V8h2v5H5Zm6.5 0a2.5 2.5 0 0 0 0 5h.5a.5.5 0 1 0 0-1h-.5a1.5 1.5 0 0 1 0-3h.5a.5.5 0 1 0 0-1h-.5Zm3.5 0a.5.5 0 1 0 0 1h.5a1.5 1.5 0 1 1 0 3H15a.5.5 0 1 0 0 1h.5a2.5 2.5 0 0 0 0-5H15Zm-4 2.5c0-.28.22-.5.5-.5h4a.5.5 0 1 1 0 1h-4a.5.5 0 0 1-.5-.5Z"]));
export const BuildingBankToolboxFilled = ( /*#__PURE__*/createFluentIcon('BuildingBankToolboxFilled', "1em", ["M8.23 2.18a1.33 1.33 0 0 1 1.54 0l5.85 4.15A.92.92 0 0 1 15.1 8H2.9a.92.92 0 0 1-.52-1.67l5.85-4.15ZM9 5.88A.83.83 0 1 0 9 4.2a.83.83 0 0 0 0 1.66ZM3.5 9v4h2V9h-2Zm.67 5C2.97 14 2 14.97 2 16.17v.33c0 .28.22.5.5.5H9v-3H4.17Zm7.33-4V9h-2v3c.37-.5.91-.84 1.54-.96.07-.38.23-.74.46-1.04Zm-3 3V9h-2v4h2Zm3.5-1v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 4.5h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 1 0 1 0V16h3v.5a.5.5 0 1 0 1 0V16Z"]));
export const BuildingBankToolboxRegular = ( /*#__PURE__*/createFluentIcon('BuildingBankToolboxRegular', "1em", ["M9 5.87a.83.83 0 1 0 0-1.66.83.83 0 0 0 0 1.66ZM2.5 17H9v-1H3v-.83c0-.65.52-1.17 1.17-1.17H9v-.5c0-.56.19-1.08.5-1.5V8H11v3.05h.04A2.5 2.5 0 0 1 12 9.5V8h2v1h1V8h.1a.92.92 0 0 0 .52-1.67L9.77 2.18a1.33 1.33 0 0 0-1.54 0L2.38 6.33A.92.92 0 0 0 2.9 8H3v5.34c-.6.38-1 1.06-1 1.83v1.33c0 .28.22.5.5.5ZM8.8 3a.33.33 0 0 1 .4 0l5.63 4H3.17L8.8 3ZM4 13V8h2v5H4Zm4.5 0H7V8h1.5v5Zm3.5-1v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 1 0-1 0v.5h-3v-.5a.5.5 0 1 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 4.5h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 1 0 1 0V16h3v.5a.5.5 0 1 0 1 0V16Z"]));
export const BuildingCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('BuildingCheckmarkFilled', "1em", ["M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5H7v-3.5c0-.28.22-.5.5-.5h1.52c.05-.56.19-1.09.39-1.58a.75.75 0 1 1 .75-1.3 5.49 5.49 0 0 1 5.81-1.92A1.5 1.5 0 0 0 14.5 8H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Zm2 3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 8a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Zm.75 3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9.75 5a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Zm.75 3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9.02 15c.1 1.13.55 2.17 1.24 3H8v-3h1.02Zm9.98-.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const BuildingCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('BuildingCheckmarkRegular', "1em", ["M6.75 6.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm3.75-6.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm-.34 2.92c.19-.47.44-.9.75-1.3a.75.75 0 1 0-.75 1.3ZM7.5 14h1.52a5.57 5.57 0 0 0 0 1H8v2h1.5v-.2c.2.43.46.83.76 1.2H4.5a.5.5 0 0 1-.5-.5v-14C4 2.67 4.67 2 5.5 2h6c.83 0 1.5.67 1.5 1.5V8h1.5c.73 0 1.33.51 1.47 1.2A5.5 5.5 0 0 0 14.5 9h-2a.5.5 0 0 1-.5-.5v-5a.5.5 0 0 0-.5-.5h-6a.5.5 0 0 0-.5.5V17h2v-2.5c0-.28.22-.5.5-.5Zm11.5.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const BuildingDesktopFilled = ( /*#__PURE__*/createFluentIcon('BuildingDesktopFilled', "1em", ["M2 3.25C2 2.56 2.56 2 3.25 2h5.5C9.44 2 10 2.56 10 3.25v2.5c0 .14.11.25.25.25h1.5c.69 0 1.25.56 1.25 1.25V8h-3c-.82 0-1.57.33-2.1.86A.75.75 0 1 0 7.16 10 3 3 0 0 0 7 11v4H3.25C2.56 15 2 14.44 2 13.75V3.25ZM8.27 10A2 2 0 0 1 10 9h7a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-2v1h1.5a.5.5 0 0 1 0 1h-6a.5.5 0 0 1 0-1H12v-1h-2a2 2 0 0 1-2-2v-4c0-.36.1-.7.27-1ZM10 10a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h7a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-7ZM4 4.75a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0Zm.75 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM4 9.25a.75.75 0 1 0 1.5 0 .75.75 0 0 0-1.5 0ZM7.25 5.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM6.5 7A.75.75 0 1 0 8 7a.75.75 0 0 0-1.5 0ZM14 18v-1h-1v1h1Z"]));
export const BuildingDesktopRegular = ( /*#__PURE__*/createFluentIcon('BuildingDesktopRegular', "1em", ["M3 3.25c0-.14.11-.25.25-.25h5.5c.14 0 .25.11.25.25v2.5C9 6.44 9.56 7 10.25 7h1.5c.14 0 .25.11.25.25V8h1v-.75C13 6.56 12.44 6 11.75 6h-1.5a.25.25 0 0 1-.25-.25v-2.5C10 2.56 9.44 2 8.75 2h-5.5C2.56 2 2 2.56 2 3.25v10.5c0 .69.56 1.25 1.25 1.25H7v-1H3.25a.25.25 0 0 1-.25-.25V3.25ZM7.25 8.5c.27 0 .51.15.64.36A3 3 0 0 0 7.17 10a.75.75 0 0 1 .08-1.5Zm-2.5-3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM5.5 7A.75.75 0 1 1 4 7a.75.75 0 0 1 1.5 0Zm-.75 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM8 4.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM8 11c0-1.1.9-2 2-2h7a2 2 0 0 1 2 2v4a2 2 0 0 1-2 2h-2v1h1.5a.5.5 0 0 1 0 1h-6a.5.5 0 0 1 0-1H12v-1h-2a2 2 0 0 1-2-2v-4Zm2 5h7a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-7a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1Zm4 2v-1h-1v1h1Z"]));
export const BuildingFactoryFilled = ( /*#__PURE__*/createFluentIcon('BuildingFactoryFilled', "1em", ["M2.94 3.4c.05-.79.7-1.4 1.5-1.4h1.12c.8 0 1.45.61 1.5 1.4l.87 13a1.5 1.5 0 0 1-1.5 1.6H3.57a1.5 1.5 0 0 1-1.5-1.6l.87-13ZM8.44 18c.34-.46.53-1.04.49-1.67L8.4 8.51l3.76-3.38a.5.5 0 0 1 .84.37v3.38l4.16-3.75a.5.5 0 0 1 .84.37v11c0 .83-.67 1.5-1.5 1.5H8.43ZM16 17v-4.2a.8.8 0 0 0-.8-.8h-3.4a.8.8 0 0 0-.8.8V17h5Z"]));
export const BuildingFactoryRegular = ( /*#__PURE__*/createFluentIcon('BuildingFactoryRegular', "1em", ["M4.44 2a1.5 1.5 0 0 0-1.5 1.4l-.87 13a1.5 1.5 0 0 0 1.5 1.6h2.86a1.5 1.5 0 0 0 1.5-1.6l-.87-13A1.5 1.5 0 0 0 5.56 2H4.44Zm-.5 1.47a.5.5 0 0 1 .5-.47h1.12c.27 0 .49.2.5.47l.87 13a.5.5 0 0 1-.5.53H3.57a.5.5 0 0 1-.5-.53l.87-13ZM16.5 18H8.43c.22-.3.38-.63.45-1H10v-4a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v4h.5a.5.5 0 0 0 .5-.5V6.62l-4.17 3.75A.5.5 0 0 1 12 10V6.62L8.49 9.78 8.4 8.51l3.76-3.38a.5.5 0 0 1 .84.37v3.38l4.16-3.75a.5.5 0 0 1 .84.37v11c0 .83-.67 1.5-1.5 1.5ZM11 17h4v-4h-4v4Z"]));
export const BuildingGovernmentColor = ( /*#__PURE__*/createFluentIcon('BuildingGovernmentColor', "1em", `<path d="M9 3h1v2.5H9V3Z" fill="#70777D"/><path d="M9 2.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1Z" fill="#F83F54"/><path d="M10 5a5 5 0 0 0-5 5v1.5h10V10a5 5 0 0 0-5-5Z" fill="url(#ic_fluent_building_government_20_color__a)"/><path d="M10 5a5 5 0 0 0-5 5v1.5h10V10a5 5 0 0 0-5-5Z" fill="url(#ic_fluent_building_government_20_color__b)"/><path d="M4 11a2 2 0 0 0-2 2v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a2 2 0 0 0-2-2H4Z" fill="url(#ic_fluent_building_government_20_color__c)"/><path d="M4 11a2 2 0 0 0-2 2v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a2 2 0 0 0-2-2H4Z" fill="url(#ic_fluent_building_government_20_color__d)" fill-opacity=".6"/><path d="M8 15v3h4v-3a1 1 0 0 0-1-1H9a1 1 0 0 0-1 1Z" fill="#55595E"/><path d="M6 13.5a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Zm9 0a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Z" fill="#63686E"/><path d="M8.5 7.5A.5.5 0 0 0 8 8v1a.5.5 0 0 0 1 0V8a.5.5 0 0 0-.5-.5ZM12 8a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0V8Z" fill="#CA6407"/><defs><radialGradient id="ic_fluent_building_government_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 3.5 -5.33673 0 13.5 6)"><stop stop-color="#FFD638"/><stop offset="1" stop-color="#FFD638" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_building_government_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-.5 4 -8.9853 -1.12316 17 11)"><stop stop-color="#FFB357"/><stop offset="1" stop-color="#FFB357" stop-opacity="0"/></radialGradient><linearGradient id="ic_fluent_building_government_20_color__a" x1="10" y1="5" x2="10" y2="11.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FFC205"/><stop offset=".73" stop-color="#FFA43D"/><stop offset="1" stop-color="#E67505"/></linearGradient><linearGradient id="ic_fluent_building_government_20_color__c" x1="8.25" y1="11" x2="15.5" y2="18.63" gradientUnits="userSpaceOnUse"><stop stop-color="#AAB3BD"/><stop offset="1" stop-color="#889096"/></linearGradient></defs>`, { color: true }));
export const BuildingGovernmentFilled = ( /*#__PURE__*/createFluentIcon('BuildingGovernmentFilled', "1em", ["M9.5 2a.5.5 0 0 0-.5.5v2.6A5 5 0 0 0 5 10v1H4a2 2 0 0 0-2 2v4a1 1 0 0 0 1 1h4.5a.5.5 0 0 0 .5-.5v-2c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v2c0 .28.22.5.5.5H17a1 1 0 0 0 1-1v-4a2 2 0 0 0-2-2h-1v-1a5 5 0 0 0-5-5V4h2.5a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-3ZM6 13.5v2a.5.5 0 0 1-1 0v-2a.5.5 0 0 1 1 0Zm8.5-.5c.28 0 .5.22.5.5v2a.5.5 0 0 1-1 0v-2c0-.28.22-.5.5-.5ZM9 9.5v2a.5.5 0 0 1-1 0v-2a.5.5 0 0 1 1 0Zm2.5-.5c.28 0 .5.22.5.5v2a.5.5 0 0 1-1 0v-2c0-.28.22-.5.5-.5Z"]));
export const BuildingGovernmentRegular = ( /*#__PURE__*/createFluentIcon('BuildingGovernmentRegular', "1em", ["M9 2.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5H10v1a5 5 0 0 1 5 5v1h1a2 2 0 0 1 2 2v4a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1v-4c0-1.1.9-2 2-2h1v-1a5 5 0 0 1 4-4.9V2.5Zm7 9.5h-1.5a.5.5 0 0 1-.5-.5V10a4 4 0 0 0-8 0v1.5a.5.5 0 0 1-.5.5H4a1 1 0 0 0-1 1v4h5v-2a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2h5v-4a1 1 0 0 0-1-1ZM6 13.5a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Zm9 0a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2ZM8.5 9a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm3.5.5a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2ZM9 17h2v-2H9v2Z"]));
export const BuildingGovernmentSearchColor = ( /*#__PURE__*/createFluentIcon('BuildingGovernmentSearchColor', "1em", `<path d="M9 3h1v2.5H9V3Z" fill="#70777D"/><path d="M9 2.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1Z" fill="#F83F54"/><path d="M10 5a5 5 0 0 0-5 5v1.5h10V10a5 5 0 0 0-5-5Z" fill="url(#ic_fluent_building_government_search_20_color__a)"/><path d="M10 5a5 5 0 0 0-5 5v1.5h10V10a5 5 0 0 0-5-5Z" fill="url(#ic_fluent_building_government_search_20_color__b)"/><path d="M10 5a5 5 0 0 0-5 5v1.5h10V10a5 5 0 0 0-5-5Z" fill="url(#ic_fluent_building_government_search_20_color__c)"/><path d="M2 13c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v4a1 1 0 0 1-1 1H9l-2-2c-.33.33-1.3 1-2.5 1s-2.17-.67-2.5-1v-3Z" fill="url(#ic_fluent_building_government_search_20_color__d)"/><path d="M2 13c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v4a1 1 0 0 1-1 1H9l-2-2c-.33.33-1.3 1-2.5 1s-2.17-.67-2.5-1v-3Z" fill="url(#ic_fluent_building_government_search_20_color__e)" fill-opacity=".5"/><path d="M2 13c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v4a1 1 0 0 1-1 1H9l-2-2c-.33.33-1.3 1-2.5 1s-2.17-.67-2.5-1v-3Z" fill="url(#ic_fluent_building_government_search_20_color__f)" fill-opacity=".6"/><path d="M2 13c0-1.1.9-2 2-2h12a2 2 0 0 1 2 2v4a1 1 0 0 1-1 1H9l-2-2c-.33.33-1.3 1-2.5 1s-2.17-.67-2.5-1v-3Z" fill="url(#ic_fluent_building_government_search_20_color__g)" fill-opacity=".6"/><path d="M15 13.5a.5.5 0 0 0-1 0v2a.5.5 0 0 0 1 0v-2Z" fill="#63686E"/><path d="M8.5 7.5A.5.5 0 0 0 8 8v1a.5.5 0 0 0 1 0V8a.5.5 0 0 0-.5-.5ZM12 8a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0V8Z" fill="#CA6407"/><path d="M7.5 13.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" fill="url(#ic_fluent_building_government_search_20_color__h)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M4.5 9.5a4 4 0 1 0 2.25 7.3l1.97 1.98a.75.75 0 0 0 1.06-1.06l-1.97-1.97A4 4 0 0 0 4.5 9.5Zm-2.5 4a2.5 2.5 0 1 1 5 0 2.5 2.5 0 0 1-5 0Z" fill="url(#ic_fluent_building_government_search_20_color__i)"/><defs><linearGradient id="ic_fluent_building_government_search_20_color__a" x1="10" y1="5" x2="10" y2="11.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FFC205"/><stop offset=".73" stop-color="#FFA43D"/><stop offset="1" stop-color="#E67505"/></linearGradient><linearGradient id="ic_fluent_building_government_search_20_color__d" x1="8.25" y1="11" x2="15.5" y2="18.63" gradientUnits="userSpaceOnUse"><stop stop-color="#AAB3BD"/><stop offset="1" stop-color="#889096"/></linearGradient><linearGradient id="ic_fluent_building_government_search_20_color__e" x1="7.5" y1="17.5" x2="12.08" y2="12.22" gradientUnits="userSpaceOnUse"><stop offset=".14" stop-opacity=".69"/><stop offset=".62" stop-opacity="0"/></linearGradient><linearGradient id="ic_fluent_building_government_search_20_color__h" x1="6" y1="11.5" x2="1.5" y2="16.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_government_search_20_color__i" x1="1" y1="18" x2="9" y2="11.5" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#29C3FF"/></linearGradient><radialGradient id="ic_fluent_building_government_search_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(5 -5 5 5 4.5 13.5)"><stop offset=".49" stop-color="#E67505"/><stop offset=".84" stop-color="#E67505" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_building_government_search_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 3.5 -5.33673 0 13.5 6)"><stop stop-color="#FFD638"/><stop offset="1" stop-color="#FFD638" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_building_government_search_20_color__f" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(5 -5 5 5 4.5 13.5)"><stop offset=".12"/><stop offset=".88" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_building_government_search_20_color__g" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-.5 4 -8.9853 -1.12316 17 11)"><stop stop-color="#FFB357"/><stop offset="1" stop-color="#FFB357" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const BuildingGovernmentSearchFilled = ( /*#__PURE__*/createFluentIcon('BuildingGovernmentSearchFilled', "1em", ["M9 2.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5H10v1a5 5 0 0 1 5 5v1h1a2 2 0 0 1 2 2v4a1 1 0 0 1-1 1h-4.5a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 0-.5-.5H8.74a4.5 4.5 0 0 0-.02-3.05.5.5 0 0 0 .28-.45v-2a.5.5 0 1 0-1 0v1.17a4.5 4.5 0 0 0-2.9-1.63A5 5 0 0 1 9 5.1V2.5Zm6 11a.5.5 0 0 0-1 0v2a.5.5 0 1 0 1 0v-2Zm-3-4a.5.5 0 0 0-1 0v2a.5.5 0 1 0 1 0v-2ZM4.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const BuildingGovernmentSearchRegular = ( /*#__PURE__*/createFluentIcon('BuildingGovernmentSearchRegular', "1em", ["M9 2.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5H10v1a5 5 0 0 1 5 5v1h1a2 2 0 0 1 2 2v4a1 1 0 0 1-1 1h-6.09a1.5 1.5 0 0 0-.35-.56l-.44-.44H11v-2H8.74c.12-.32.2-.65.23-1H11a1 1 0 0 1 1 1v2h5v-4a1 1 0 0 0-1-1h-1.5a.5.5 0 0 1-.5-.5V10a4 4 0 0 0-7.94-.72c-.3-.12-.63-.2-.97-.24A5 5 0 0 1 9 5.1V2.5Zm0 9a.5.5 0 0 1-.28.45A4.5 4.5 0 0 0 8 10.67V9.5a.5.5 0 0 1 1 0v2Zm6 2a.5.5 0 0 0-1 0v2a.5.5 0 1 0 1 0v-2Zm-3-4a.5.5 0 0 0-1 0v2a.5.5 0 1 0 1 0v-2ZM4.5 17c.79 0 1.51-.26 2.1-.7l2.55 2.55a.5.5 0 1 0 .7-.7L7.3 15.6A3.5 3.5 0 1 0 4.5 17Zm0-1a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5Z"]));
export const BuildingHomeColor = ( /*#__PURE__*/createFluentIcon('BuildingHomeColor', "1em", `<path d="M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5h10c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Z" fill="url(#ic_fluent_building_home_20_color__a)"/><path d="M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5h10c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Z" fill="url(#ic_fluent_building_home_20_color__b)"/><path d="M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5h10c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Z" fill="url(#ic_fluent_building_home_20_color__c)"/><path d="M6.75 6.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_home_20_color__d)"/><path d="M11 5.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z" fill="url(#ic_fluent_building_home_20_color__e)"/><path d="M11 8.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_home_20_color__f)"/><path d="M7.5 8.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z" fill="url(#ic_fluent_building_home_20_color__g)"/><path d="M7.5 11.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_home_20_color__h)"/><path d="M14 15h3v4h-3v-4Z" fill="url(#ic_fluent_building_home_20_color__i)"/><path d="M12 15.46a1 1 0 0 1 .35-.76l2.83-2.42a.5.5 0 0 1 .65 0l2.82 2.42a1 1 0 0 1 .35.76v3.04a.5.5 0 0 1-.5.5h-2v-2.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5V19h-2a.5.5 0 0 1-.5-.5v-3.04Z" fill="url(#ic_fluent_building_home_20_color__j)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14.52 11.36a1.5 1.5 0 0 1 1.96 0l3.26 2.82a.75.75 0 1 1-.98 1.14l-3.26-2.83-3.26 2.83a.75.75 0 0 1-.98-1.14l3.26-2.82Z" fill="url(#ic_fluent_building_home_20_color__k)"/><defs><linearGradient id="ic_fluent_building_home_20_color__a" x1="4" y1="2.5" x2="19.26" y2="17.15" gradientUnits="userSpaceOnUse"><stop stop-color="#29C3FF"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__d" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__e" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__f" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__g" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__h" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__i" x1="15.5" y1="15" x2="12.85" y2="19.41" gradientUnits="userSpaceOnUse"><stop stop-color="#944600"/><stop offset="1" stop-color="#CD8E02"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__j" x1="11.76" y1="12.35" x2="18.12" y2="18.86" gradientUnits="userSpaceOnUse"><stop stop-color="#FFD394"/><stop offset="1" stop-color="#FFB357"/></linearGradient><linearGradient id="ic_fluent_building_home_20_color__k" x1="15.93" y1="9.71" x2="15.19" y2="15.11" gradientUnits="userSpaceOnUse"><stop stop-color="#FF921F"/><stop offset="1" stop-color="#EB4824"/></linearGradient><radialGradient id="ic_fluent_building_home_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 3.5 -2.3125 0 13 17)"><stop stop-color="#4A43CB"/><stop offset=".91" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_building_home_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(-4.5 3.5 -1.8232 -2.3441 15 14)"><stop stop-color="#4A43CB"/><stop offset=".91" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const BuildingHomeFilled = ( /*#__PURE__*/createFluentIcon('BuildingHomeFilled', "1em", ["M3.25 2C2.56 2 2 2.56 2 3.25v10.5c0 .69.56 1.25 1.25 1.25H7.5v-1.74c0-.68.3-1.33.82-1.78l3.47-2.96c.35-.3.78-.47 1.21-.52v-.75C13 6.56 12.44 6 11.75 6h-1.5a.25.25 0 0 1-.25-.25v-2.5C10 2.56 9.44 2 8.75 2h-5.5Zm1.5 3.5a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5ZM5.5 7A.75.75 0 1 1 4 7a.75.75 0 0 1 1.5 0Zm-.75 3a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5ZM8 4.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5ZM8 9.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm6.06.03c-.47-.4-1.15-.4-1.62 0l-3.47 2.96c-.3.26-.47.63-.47 1.02v4.61C8.5 18.5 9 19 9.63 19h1.74c.63 0 1.13-.5 1.13-1.13v-1.75c0-.06.06-.12.13-.12h1.24c.07 0 .13.06.13.13v1.74c0 .63.5 1.13 1.13 1.13h1.74c.63 0 1.13-.5 1.13-1.13v-4.61c0-.4-.17-.76-.47-1.02l-3.47-2.96Zm-.97.77c.1-.08.23-.08.32 0L16.88 13c.08.07.12.16.12.26v4.61c0 .07-.06.13-.13.13h-1.75a.12.12 0 0 1-.12-.13v-1.75c0-.62-.5-1.12-1.13-1.12h-1.24c-.63 0-1.13.5-1.13 1.13v1.74c0 .07-.06.13-.13.13H9.63a.12.12 0 0 1-.13-.13v-4.61c0-.1.04-.2.12-.26l3.47-2.95Z"]));
export const BuildingHomeRegular = ( /*#__PURE__*/createFluentIcon('BuildingHomeRegular', "1em", ["M3.25 3a.25.25 0 0 0-.25.25v10.5c0 .14.11.25.25.25H7.5v1H3.25C2.56 15 2 14.44 2 13.75V3.25C2 2.56 2.56 2 3.25 2h5.5C9.44 2 10 2.56 10 3.25v2.5c0 .14.11.25.25.25h1.5c.69 0 1.25.56 1.25 1.25V8c-.35.04-.7.16-1 .37V7.25a.25.25 0 0 0-.25-.25h-1.5C9.56 7 9 6.44 9 5.75v-2.5A.25.25 0 0 0 8.75 3h-5.5Zm10.81 6.28c-.47-.4-1.15-.4-1.62 0l-3.47 2.96c-.3.26-.47.63-.47 1.02v4.61C8.5 18.5 9 19 9.63 19h1.74c.63 0 1.13-.5 1.13-1.13v-1.75c0-.06.06-.12.13-.12h1.24c.07 0 .13.06.13.13v1.74c0 .63.5 1.13 1.13 1.13h1.74c.63 0 1.13-.5 1.13-1.13v-4.61c0-.4-.17-.76-.47-1.02l-3.47-2.96Zm-.97.77c.1-.08.23-.08.32 0L16.88 13c.08.07.12.16.12.26v4.61c0 .07-.06.13-.13.13h-1.75a.12.12 0 0 1-.12-.13v-1.75c0-.62-.5-1.12-1.13-1.12h-1.24c-.63 0-1.13.5-1.13 1.13v1.74c0 .07-.06.13-.13.13H9.63a.12.12 0 0 1-.13-.13v-4.61c0-.1.04-.2.12-.26l3.47-2.95ZM5.5 4.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 1.5a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM7.25 5.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM8 7a.75.75 0 1 1-1.5 0A.75.75 0 0 1 8 7Zm-.75 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const BuildingLighthouseFilled = ( /*#__PURE__*/createFluentIcon('BuildingLighthouseFilled', "1em", ["M8.45 2.17a1 1 0 0 1 1.1 0l3 2A1 1 0 0 1 12 6v2.16a2 2 0 0 1 1.2 1.62l.8 7.1A1 1 0 0 1 13 18H5a1 1 0 0 1-1-1.11l.8-7.11A2 2 0 0 1 6 8.16V6a1 1 0 0 1-.55-1.83l3-2ZM7 6v2h4V6H7Zm5.33 5.07-6.87 1.81-.22 2.03 7.3-1.93-.2-1.9ZM14.5 7h2a.5.5 0 1 0 0-1h-2a.5.5 0 0 0 0 1Zm1.35-3.85c.2.2.2.5 0 .7l-1 1a.5.5 0 0 1-.7-.7l1-1c.2-.2.5-.2.7 0Zm0 6a.5.5 0 0 1-.7.7l-1-1a.5.5 0 1 1 .7-.7l1 1Z"]));
export const BuildingLighthouseRegular = ( /*#__PURE__*/createFluentIcon('BuildingLighthouseRegular', "1em", ["m10.33 2.69-.77-.52a1 1 0 0 0-1.1 0l-.78.5-2.1 1.21A1.13 1.13 0 0 0 5 4.93 1 1 0 0 0 6 6v2.16a2 2 0 0 0-1.2 1.62l-.8 7.1A1 1 0 0 0 5 18h8a1 1 0 0 0 1-1.11l-.8-7.11A2 2 0 0 0 12 8.16V6a1 1 0 0 0 1-1.09v-.04c0-.4-.22-.78-.57-.99l-2.1-1.2ZM11 8H7V6h4v2ZM6.1 5a.13.13 0 0 1-.05-.03L8.2 3.53l.8-.45.8.46 2.15 1.43a.13.13 0 0 1-.06.03H6.11Zm.74 4h4.32a1 1 0 0 1 1 .89l.01.18-3.55.95-2.98.78.2-1.91a1 1 0 0 1 1-.89Zm2.03 2.99 3.41-.9.22 1.9-3.88 1.03-3.33.87.23-2.01 3.35-.9Zm-3.7 3.98 3.7-.98 3.74-.99.33 3H5.06l.11-1.03ZM16.5 7h-2a.5.5 0 0 1 0-1h2a.5.5 0 0 1 0 1Zm-.65-3.85c.2.2.2.5 0 .7l-1 1a.5.5 0 1 1-.7-.7l1-1a.5.5 0 0 1 .7 0Zm0 6a.5.5 0 0 1-.7.7l-1-1a.5.5 0 1 1 .7-.7l1 1Z"]));
export const BuildingMosqueFilled = ( /*#__PURE__*/createFluentIcon('BuildingMosqueFilled', "1em", ["M3.25 4.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm14.25.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm-7.3-1.46a.5.5 0 0 0-.4 0l-.02.01-.04.02a9.75 9.75 0 0 0-.68.34c-.44.24-1.02.58-1.6 1-.59.42-1.19.94-1.65 1.53A3.38 3.38 0 0 0 5 9c0 .71.15 1.39.42 2H3V6.5a.5.5 0 0 0-1 0V17a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-1a2 2 0 1 1 4 0v1a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1V6.5a.5.5 0 0 0-1 0V11h-2.42c.27-.61.42-1.29.42-2 0-.77-.35-1.47-.81-2.06a8.24 8.24 0 0 0-1.65-1.53 14.62 14.62 0 0 0-2.28-1.34l-.04-.02h-.01Z"]));
export const BuildingMosqueRegular = ( /*#__PURE__*/createFluentIcon('BuildingMosqueRegular', "1em", ["M2.5 5.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm15.75-.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-8.05-.7a.5.5 0 0 0-.4 0h-.02l-.04.02a9.75 9.75 0 0 0-.68.34c-.44.24-1.02.58-1.6 1-.59.42-1.19.94-1.65 1.53A3.38 3.38 0 0 0 5 9c0 .71.15 1.39.42 2H3V6.5a.5.5 0 0 0-1 0V17a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1V6.5a.5.5 0 0 0-1 0V11h-2.42c.27-.61.42-1.29.42-2 0-.77-.35-1.47-.81-2.06a8.24 8.24 0 0 0-1.65-1.53 14.62 14.62 0 0 0-2.28-1.34l-.04-.02h-.01ZM17 17h-5v-2a2 2 0 1 0-4 0v2H3v-5h14v5Zm-7-3a1 1 0 0 1 1 1v2H9v-2a1 1 0 0 1 1-1Zm3.4-6.44c.39.49.6.97.6 1.44 0 .73-.2 1.41-.54 2H6.54A3.98 3.98 0 0 1 6 9c0-.47.21-.95.6-1.44.38-.5.9-.94 1.44-1.34A13.63 13.63 0 0 1 10 5.05a13.55 13.55 0 0 1 1.96 1.17c.54.4 1.06.85 1.44 1.34Z"]));
export const BuildingMultipleColor = ( /*#__PURE__*/createFluentIcon('BuildingMultipleColor', "1em", `<path d="M2 4c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v13a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Z" fill="url(#ic_fluent_building_multiple_20_color__a)"/><path d="M2 4c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v13a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Z" fill="url(#ic_fluent_building_multiple_20_color__b)" fill-opacity=".2"/><path d="M2 4c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v13a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Z" fill="url(#ic_fluent_building_multiple_20_color__c)"/><path d="M5.25 6.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_multiple_20_color__d)"/><path d="M6 8.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z" fill="url(#ic_fluent_building_multiple_20_color__e)"/><path d="M6 11.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_multiple_20_color__f)"/><path d="M5.25 15.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_multiple_20_color__g)"/><path d="M16 5a2 2 0 0 1 2 2v10a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1V7c0-1.1.9-2 2-2h6Z" fill="url(#ic_fluent_building_multiple_20_color__h)"/><path d="M11 15.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5V18h-4v-2.5Z" fill="url(#ic_fluent_building_multiple_20_color__i)"/><path d="M11.25 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_multiple_20_color__j)"/><path d="M14.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_multiple_20_color__k)"/><path d="M12 11.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_multiple_20_color__l)"/><path d="M14.75 12.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_multiple_20_color__m)"/><defs><linearGradient id="ic_fluent_building_multiple_20_color__a" x1="2.36" y1="5" x2="12.45" y2="11.55" gradientUnits="userSpaceOnUse"><stop stop-color="#A3A3FF"/><stop offset="1" stop-color="#5750E2"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__b" x1="5.5" y1="4" x2="9" y2="4" gradientUnits="userSpaceOnUse"><stop stop-color="#30116E" stop-opacity="0"/><stop offset="1" stop-color="#30116E"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__c" x1="9.13" y1="6.88" x2="9" y2="2" gradientUnits="userSpaceOnUse"><stop stop-color="#A3A3FF" stop-opacity="0"/><stop offset="1" stop-color="#A3A3FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__d" x1="4" y1="4.5" x2="6" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#D1D1FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__e" x1="4" y1="4.5" x2="6" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#D1D1FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__f" x1="4" y1="4.5" x2="6" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#D1D1FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__g" x1="4" y1="4.5" x2="6" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#D1D1FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__h" x1="8" y1="5.41" x2="20.41" y2="17.62" gradientUnits="userSpaceOnUse"><stop stop-color="#3BD5FF"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__i" x1="11.14" y1="15.56" x2="13.11" y2="18.29" gradientUnits="userSpaceOnUse"><stop stop-color="#0067BF"/><stop offset="1" stop-color="#003580"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__j" x1="12" y1="7.5" x2="13.5" y2="13.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__k" x1="12" y1="7.5" x2="13.5" y2="13.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__l" x1="12" y1="7.5" x2="13.5" y2="13.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_multiple_20_color__m" x1="12" y1="7.5" x2="13.5" y2="13.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient></defs>`, { color: true }));
export const BuildingMultipleFilled = ( /*#__PURE__*/createFluentIcon('BuildingMultipleFilled', "1em", ["M4 2a2 2 0 0 0-2 2v13a1 1 0 0 0 1 1h7.5a.5.5 0 0 0 .5-.5v-2c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v2c0 .28.22.5.5.5H17a1 1 0 0 0 1-1V7a2 2 0 0 0-2-2h-4V4a2 2 0 0 0-2-2H4Zm7 3h-1a2 2 0 0 0-2 2v10H3V4a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v1ZM5.25 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM6 5.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 9.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM6 11.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm5.25-2.25a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm2.75-2.25a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z"]));
export const BuildingMultipleRegular = ( /*#__PURE__*/createFluentIcon('BuildingMultipleRegular', "1em", ["M2 4c0-1.1.9-2 2-2h6a2 2 0 0 1 2 2v1h4a2 2 0 0 1 2 2v10a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Zm10 13h2v-2h-2v2Zm3 0h2V7a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v10h2v-2a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2ZM11 4a1 1 0 0 0-1-1H4a1 1 0 0 0-1 1v13h5V7c0-1.1.9-2 2-2h1V4Zm1 4.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-6.75.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM6 5.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm5.25 6.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM6 14.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75-2.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM15.5 8.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const BuildingPeopleColor = ( /*#__PURE__*/createFluentIcon('BuildingPeopleColor', "1em", `<path d="M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5h10c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Z" fill="url(#ic_fluent_building_people_20_color__a)"/><path d="M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5h10c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Z" fill="url(#ic_fluent_building_people_20_color__b)"/><path d="M5.5 2C4.67 2 4 2.67 4 3.5v14c0 .28.22.5.5.5h10c.83 0 1.5-.67 1.5-1.5v-7c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6Z" fill="url(#ic_fluent_building_people_20_color__c)"/><path d="M6.75 6.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z" fill="url(#ic_fluent_building_people_20_color__d)"/><path d="M11 5.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z" fill="url(#ic_fluent_building_people_20_color__e)"/><path d="M11 8.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_people_20_color__f)"/><path d="M7.5 8.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Z" fill="url(#ic_fluent_building_people_20_color__g)"/><path d="M7.5 11.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z" fill="url(#ic_fluent_building_people_20_color__h)"/><path d="M16.75 18c1.65 0 2.25-.91 2.25-1.8 0-.66-.54-1.2-1.2-1.2h-2.1c-.66 0-1.2.54-1.2 1.2 0 .89.6 1.8 2.25 1.8Z" fill="url(#ic_fluent_building_people_20_color__i)"/><path d="M16.75 18c1.65 0 2.25-.91 2.25-1.8 0-.66-.54-1.2-1.2-1.2h-2.1c-.66 0-1.2.54-1.2 1.2 0 .89.6 1.8 2.25 1.8Z" fill="url(#ic_fluent_building_people_20_color__j)" fill-opacity=".5"/><path d="M18 12.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0Z" fill="url(#ic_fluent_building_people_20_color__k)"/><path d="M13 19c2.2 0 3-1.22 3-2.4 0-.88-.72-1.6-1.6-1.6h-2.8c-.88 0-1.6.72-1.6 1.6 0 1.18.8 2.4 3 2.4Z" fill="url(#ic_fluent_building_people_20_color__l)"/><path d="M13 19c2.2 0 3-1.22 3-2.4 0-.88-.72-1.6-1.6-1.6h-2.8c-.88 0-1.6.72-1.6 1.6 0 1.18.8 2.4 3 2.4Z" fill="url(#ic_fluent_building_people_20_color__m)"/><path d="M14.75 12.25a1.75 1.75 0 1 1-3.5 0 1.75 1.75 0 0 1 3.5 0Z" fill="url(#ic_fluent_building_people_20_color__n)"/><defs><linearGradient id="ic_fluent_building_people_20_color__a" x1="4" y1="2.5" x2="19.26" y2="17.15" gradientUnits="userSpaceOnUse"><stop stop-color="#29C3FF"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__d" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__e" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__f" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__g" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__h" x1="7.35" y1="4.17" x2="11.4" y2="12.92" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__i" x1="15.57" y1="15.4" x2="16.78" y2="18.29" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__k" x1="16.09" y1="11.83" x2="17.37" y2="13.87" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__l" x1="11.43" y1="15.53" x2="13.04" y2="19.39" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#BD96FF"/><stop offset="1" stop-color="#9C6CFE"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__m" x1="13" y1="14.52" x2="15.29" y2="20.95" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_building_people_20_color__n" x1="12.08" y1="10.97" x2="13.87" y2="13.81" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#BD96FF"/><stop offset="1" stop-color="#9C6CFE"/></linearGradient><radialGradient id="ic_fluent_building_people_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(4 0 0 3.69444 12 17)"><stop stop-color="#4A43CB"/><stop offset=".91" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_building_people_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 3 -3 0 13.5 13)"><stop stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_building_people_20_color__j" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-8.4 119.26 -86.55) scale(2.9936 3.52614)"><stop offset=".39" stop-color="#3B148A"/><stop offset="1" stop-color="#3B148A" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const BuildingPeopleFilled = ( /*#__PURE__*/createFluentIcon('BuildingPeopleFilled', "1em", ["M4 3.5C4 2.67 4.67 2 5.5 2h6c.83 0 1.5.67 1.5 1.5V8h1.5c.83 0 1.5.67 1.5 1.5v1.23c-.19.1-.36.21-.51.35a2.75 2.75 0 1 0-4.54 3A2.6 2.6 0 0 0 9 16.6c0 .46.09.95.3 1.4H4.5a.5.5 0 0 1-.5-.5v-14Zm3.5 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM6.75 8a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5Zm.75 3.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM10.25 5a.75.75 0 1 0 0 1.5.75.75 0 0 0 0-1.5ZM11 8.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm3.75 3.5a1.75 1.75 0 1 1-3.5 0 1.75 1.75 0 0 1 3.5 0Zm3.5.5a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM16 16.6c0 1.18-.8 2.4-3 2.4s-3-1.22-3-2.4c0-.88.72-1.6 1.6-1.6h2.8c.88 0 1.6.72 1.6 1.6Zm.7 1.4h.05c1.65 0 2.25-.91 2.25-1.8 0-.66-.54-1.2-1.2-1.2h-1.35c.34.44.55 1 .55 1.6 0 .46-.09.95-.3 1.4Z"]));
export const BuildingPeopleRegular = ( /*#__PURE__*/createFluentIcon('BuildingPeopleRegular', "1em", ["M6.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm3-3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM4 17.5c0 .28.22.5.5.5h4.8a3.32 3.32 0 0 1-.28-1H5V3.5c0-.28.22-.5.5-.5h6c.28 0 .5.22.5.5v5c0 .28.22.5.5.5h2c.28 0 .5.22.5.5v.86c.2.21.37.46.49.72.15-.14.32-.25.51-.35V9.5c0-.83-.67-1.5-1.5-1.5H13V3.5c0-.83-.67-1.5-1.5-1.5h-6C4.67 2 4 2.67 4 3.5v14Zm2.75-5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm3.75-3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 6.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm8 5.75a1.75 1.75 0 1 1-3.5 0 1.75 1.75 0 0 1 3.5 0Zm3.5.5a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0ZM16 16.6c0 1.18-.8 2.4-3 2.4s-3-1.22-3-2.4c0-.88.72-1.6 1.6-1.6h2.8c.88 0 1.6.72 1.6 1.6Zm.7 1.4h.05c1.65 0 2.25-.91 2.25-1.8 0-.66-.54-1.2-1.2-1.2h-1.35c.34.44.55 1 .55 1.6 0 .46-.09.95-.3 1.4Z"]));
export const BuildingRetailFilled = ( /*#__PURE__*/createFluentIcon('BuildingRetailFilled', "1em", ["M6 10V8h8v2H6Zm6 4v-1h2v1h-2Zm6-9.5c0 .65-.42 1.2-1 1.41V16.5a.5.5 0 0 1-.5.5H10v-4.5a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0-.5.5V17H3.5a.5.5 0 0 1-.5-.5V5.91A1.5 1.5 0 0 1 3.5 3h13c.83 0 1.5.67 1.5 1.5Zm-15 0c0 .28.22.5.5.5h13a.5.5 0 0 0 0-1h-13a.5.5 0 0 0-.5.5ZM5.5 7a.5.5 0 0 0-.5.5v3c0 .28.22.5.5.5h9a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-9Zm6 5a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5h3a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5h-3ZM6 17h3v-4H6v4Z"]));
export const BuildingRetailRegular = ( /*#__PURE__*/createFluentIcon('BuildingRetailRegular', "1em", ["M5.5 7a.5.5 0 0 0-.5.5v3c0 .28.22.5.5.5h9a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-9Zm.5 3V8h8v2H6Zm5.5 2a.5.5 0 0 0-.5.5v2c0 .28.22.5.5.5h3a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-.5-.5h-3Zm.5 2v-1h2v1h-2ZM2 4.5C2 3.67 2.67 3 3.5 3h13a1.5 1.5 0 0 1 .5 2.91V16.5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5V5.91c-.58-.2-1-.76-1-1.41ZM3.5 4a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM4 6v10h1v-3.5c0-.28.22-.5.5-.5h4c.28 0 .5.22.5.5V16h6V6H4Zm2 10h3v-3H6v3Z"]));
export const BuildingRetailMoneyFilled = ( /*#__PURE__*/createFluentIcon('BuildingRetailMoneyFilled', "1em", ["M6 10V8h8v2H6Zm11-4.09A1.5 1.5 0 0 0 16.5 3h-13A1.5 1.5 0 0 0 3 5.91V16.5c0 .28.22.5.5.5H5v-4.5c0-.28.22-.5.5-.5h4c.2 0 .38.12.46.3.3-.2.66-.3 1.04-.3h6V5.91ZM3.5 4h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1 0-1ZM5 7.5c0-.28.22-.5.5-.5h9c.28 0 .5.22.5.5v3a.5.5 0 0 1-.5.5h-9a.5.5 0 0 1-.5-.5v-3ZM9 13v4H6v-4h3Zm8.5 0c.83 0 1.5.67 1.5 1.5v3c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5v-3c0-.83.67-1.5 1.5-1.5h6Zm0 5c0-.28.22-.5.5-.5v-1c-.83 0-1.5.67-1.5 1.5h1Zm.5-3.5a.5.5 0 0 1-.5-.5h-1c0 .83.67 1.5 1.5 1.5v-1Zm-6.5-.5a.5.5 0 0 1-.5.5v1c.83 0 1.5-.67 1.5-1.5h-1Zm-.5 3.5c.28 0 .5.22.5.5h1c0-.83-.67-1.5-1.5-1.5v1Zm3.5-3a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z"]));
export const BuildingRetailMoneyRegular = ( /*#__PURE__*/createFluentIcon('BuildingRetailMoneyRegular', "1em", ["M2 4.5C2 3.67 2.67 3 3.5 3h13a1.5 1.5 0 0 1 .5 2.91V12h-1V6H4v10h1v-3.5c0-.28.22-.5.5-.5h4c.2 0 .38.12.46.3A2 2 0 0 0 9 14v-1H6v3h3v1H3.5a.5.5 0 0 1-.5-.5V5.91c-.58-.2-1-.76-1-1.41ZM3.5 4a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Zm2 3a.5.5 0 0 0-.5.5v3c0 .28.22.5.5.5h9a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-9Zm.5 3V8h8v2H6Zm13 4.5v3c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5v-3c0-.83.67-1.5 1.5-1.5h6c.83 0 1.5.67 1.5 1.5ZM17.5 18c0-.28.22-.5.5-.5v-1c-.83 0-1.5.67-1.5 1.5h1Zm.5-3.5a.5.5 0 0 1-.5-.5h-1c0 .83.67 1.5 1.5 1.5v-1Zm-6.5-.5a.5.5 0 0 1-.5.5v1c.83 0 1.5-.67 1.5-1.5h-1Zm-.5 3.5c.28 0 .5.22.5.5h1c0-.83-.67-1.5-1.5-1.5v1Zm3.5-3a1.5 1.5 0 1 0 0 3 1.5 1.5 0 0 0 0-3Z"]));
export const BuildingRetailMoreFilled = ( /*#__PURE__*/createFluentIcon('BuildingRetailMoreFilled', "1em", ["M4 3.3a1 1 0 0 1 .7-.3h10.6a1 1 0 0 1 .7.3l2.64 2.63c.76.77.22 2.07-.85 2.07H2.2a1.21 1.21 0 0 1-.85-2.07L4 3.3ZM17 9H3v6c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V9ZM7 13a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm3 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm3 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const BuildingRetailMoreRegular = ( /*#__PURE__*/createFluentIcon('BuildingRetailMoreRegular', "1em", ["M7 13a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-1a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2 1a1 1 0 1 0 0-2 1 1 0 0 0 0 2ZM4 3.3a1 1 0 0 1 .7-.3h10.6a1 1 0 0 1 .7.3l2.64 2.63c.76.77.22 2.07-.85 2.07H17v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8h-.79a1.21 1.21 0 0 1-.85-2.07L4 3.3ZM16 15V8H4v7a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1Zm1.79-8c.18 0 .28-.23.14-.36L15.3 4H4.71L2.07 6.64A.21.21 0 0 0 2.2 7H17.8Z"]));
export const BuildingRetailShieldFilled = ( /*#__PURE__*/createFluentIcon('BuildingRetailShieldFilled', "1em", ["M14.12 9.96c.2-.19.56-.19.76 0 .5.49 1.48 1.26 2.68 1.41.24.04.44.22.44.44v2.11c0 2.84-2.78 3.87-3.39 4.06a.37.37 0 0 1-.22 0c-.6-.19-3.39-1.22-3.39-4.06v-2.1c0-.23.2-.41.44-.45a5.07 5.07 0 0 0 2.68-1.4ZM16.5 3a1.5 1.5 0 0 1 .5 2.92v4.27c-.49-.2-.92-.5-1.24-.78l-.19-.17-.11-.1c-.14-.1-.3-.19-.46-.24V7.5a.5.5 0 0 0-.5-.5h-9a.5.5 0 0 0-.5.5v3c0 .28.22.5.5.5h4.76c-.13.18-.22.4-.25.66l-.01.15V12H5.5a.5.5 0 0 0-.5.5V17H3.5a.5.5 0 0 1-.5-.5V5.92A1.5 1.5 0 0 1 3.5 3h13ZM10 17H6v-4h4v4Zm4-8.1c-.16.05-.32.13-.46.24l-.11.1a5.1 5.1 0 0 1-1.03.76H6V8h8v.9ZM3.5 4a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Z"]));
export const BuildingRetailShieldRegular = ( /*#__PURE__*/createFluentIcon('BuildingRetailShieldRegular', "1em", ["M14.12 9.96c.2-.19.56-.19.76 0 .5.49 1.48 1.26 2.68 1.41.24.04.44.22.44.44v2.11c0 2.84-2.78 3.87-3.39 4.06a.37.37 0 0 1-.22 0c-.6-.19-3.39-1.22-3.39-4.06v-2.1c0-.23.2-.41.44-.45a5.07 5.07 0 0 0 2.68-1.4ZM16.5 3a1.5 1.5 0 0 1 .5 2.92v4.27a4.32 4.32 0 0 1-1-.58V6H4v10h1v-3.5c0-.28.22-.5.5-.5h4c.28 0 .5.22.5.5V16h.46c.18.38.4.7.65 1H3.5a.5.5 0 0 1-.5-.5V5.92A1.5 1.5 0 0 1 3.5 3h13ZM6 16h3v-3H6v3Zm8.5-9c.28 0 .5.22.5.5v1.4a1.6 1.6 0 0 0-1 0V8H6v2h6.4c-.28.16-.6.29-.93.36l-.27.04c-.34.07-.7.28-.94.6H5.5a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5h9Zm-11-3a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13Z"]));
export const BuildingRetailToolboxFilled = ( /*#__PURE__*/createFluentIcon('BuildingRetailToolboxFilled', "1em", ["M17 5.91A1.5 1.5 0 0 0 16.5 3h-13A1.5 1.5 0 0 0 3 5.91V16.5c0 .28.22.5.5.5H5v-4.5c0-.28.22-.5.5-.5h4c.37-.5.91-.84 1.54-.96l.01-.04H5.5a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5h9c.28 0 .5.22.5.5V9h.5c.56 0 1.08.19 1.5.5V5.91ZM3.5 4h13a.5.5 0 0 1 0 1h-13a.5.5 0 0 1 0-1ZM9 13v4H6v-4h3Zm4.5-4h.5V8H6v2h5.5c.46-.6 1.18-1 2-1ZM12 12v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 5V16h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 0 0 1 0V16h3v.5a.5.5 0 0 0 1 0Z"]));
export const BuildingRetailToolboxRegular = ( /*#__PURE__*/createFluentIcon('BuildingRetailToolboxRegular', "1em", ["M2 4.5C2 3.67 2.67 3 3.5 3h13a1.5 1.5 0 0 1 .5 2.91V9.5c-.3-.22-.63-.38-1-.45V6H4v10h1v-3.5c0-.28.22-.5.5-.5h4c-.31.42-.5.94-.5 1.5V13H6v3h3v1H3.5a.5.5 0 0 1-.5-.5V5.91c-.58-.2-1-.76-1-1.41ZM3.5 4a.5.5 0 0 0 0 1h13a.5.5 0 0 0 0-1h-13ZM15 7.5V9h-1V8H6v2h5.5c-.22.3-.38.63-.45 1H5.5a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5h9c.28 0 .5.22.5.5ZM12 12v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 5V16h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 0 0 1 0V16h3v.5a.5.5 0 0 0 1 0Z"]));
export const BuildingShopFilled = ( /*#__PURE__*/createFluentIcon('BuildingShopFilled', "1em", ["M12 12h2v2h-2v-2ZM5 2h10a.5.5 0 0 1 .38.18l2.5 3c.12.14.12.21.12.3V7a3 3 0 0 1-1 2.24v8.26a.5.5 0 0 1-.5.5H10v-6.5a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0-.5.5V18H3.5a.5.5 0 0 1-.5-.5V9.24A3 3 0 0 1 2 7V5.5a.5.5 0 0 1 .12-.32l2.5-3A.5.5 0 0 1 5 2ZM3 6v1a2 2 0 1 0 4 0V6H3Zm5 0v1a2 2 0 1 0 4 0V6H8Zm5 0v1a2 2 0 1 0 4 0V6h-4ZM5.23 3 3.57 5h3.57l.67-2H5.23Zm6.58 2-.67-2H8.86l-.67 2h3.62Zm1.05 0h3.57l-1.66-2h-2.58l.67 2ZM11 11.5v3c0 .28.22.5.5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5ZM9 18v-6H6v6h3Z"]));
export const BuildingShopRegular = ( /*#__PURE__*/createFluentIcon('BuildingShopRegular', "1em", ["M11 11.5v3c0 .28.22.5.5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5Zm1 2.5v-2h2v2h-2ZM5 2a.5.5 0 0 0-.38.18l-2.5 3A.5.5 0 0 0 2 5.5V7a3 3 0 0 0 1 2.24v8.26c0 .28.22.5.5.5h13a.5.5 0 0 0 .5-.5V9.24A3 3 0 0 0 18 7V5.48c0-.09 0-.16-.12-.3l-2.5-3A.5.5 0 0 0 15 2H5Zm0 7a2 2 0 0 1-2-2V6h4v1a2 2 0 0 1-2 2Zm5 0a2 2 0 0 1-2-2V6h4v1a2 2 0 0 1-2 2Zm5 0a2 2 0 0 1-2-2V6h4v1a2 2 0 0 1-2 2ZM5 17H4V9.83a3 3 0 0 0 3.5-1.17 3 3 0 0 0 5 0A3 3 0 0 0 16 9.83V17h-6v-5.5a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0-.5.5V17ZM7.14 5H3.57l1.66-2h2.58l-.67 2Zm4.67 0H8.19l.67-2h2.28l.67 2Zm1.05 0-.67-2h2.58l1.66 2h-3.57ZM6 17v-5h3v5H6Z"]));
export const BuildingSkyscraperFilled = ( /*#__PURE__*/createFluentIcon('BuildingSkyscraperFilled', "1em", ["M7 2.5c0-.28.22-.5.5-.5h1c.28 0 .5.22.5.5V3H7v-.5ZM5.46 4a.5.5 0 0 0-.46.5V5h6v-.5a.5.5 0 0 0-.46-.5H5.46Zm8.29 11a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75-3.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM5 6h6v.02c.6.34 1 .99 1 1.73V8h.5a4.5 4.5 0 0 1 4.5 4.5v4a.5.5 0 0 1-.5.5H9v-2.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5V17H4.5a.5.5 0 0 1-.5-.5V7.75a2 2 0 0 1 1-1.73V6Zm7 10h4v-3.5A3.5 3.5 0 0 0 12.5 9H12v7ZM7.5 8.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm1.75.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM7.5 11.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm1.75.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"]));
export const BuildingSkyscraperRegular = ( /*#__PURE__*/createFluentIcon('BuildingSkyscraperRegular', "1em", ["M7.5 8.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm1.75.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM7.5 11.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm1.75.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm5.25 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75-1.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5ZM7 2a.5.5 0 0 0-.5.5V4h-.94a.5.5 0 0 0-.5.5v1.74A2 2 0 0 0 4 8v8.5c0 .27.22.5.5.5h12a.5.5 0 0 0 .5-.5v-4A4.5 4.5 0 0 0 12.5 8H12a2 2 0 0 0-.94-1.7V4.5a.5.5 0 0 0-.5-.5H9.5V2.5A.5.5 0 0 0 9 2H7Zm3 4H6.06V5h4v1H10Zm1 10h-1v-2a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v2H5V8a1 1 0 0 1 1-1h4a1 1 0 0 1 1 1v8Zm-4 0v-2h2v2H7Zm9 0h-4V9h.5a3.5 3.5 0 0 1 3.5 3.5V16ZM8.5 4h-1V3h1v1Z"]));
export const BuildingStoreColor = ( /*#__PURE__*/createFluentIcon('BuildingStoreColor', "1em", `<path d="M3 7h14v10.5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5V7Z" fill="url(#ic_fluent_building_store_20_color__a)"/><path d="M5 11.5c0-.28.22-.5.5-.5h4c.28 0 .5.22.5.5v6a.5.5 0 0 1-.5.5h-4a.5.5 0 0 1-.5-.5v-6Z" fill="url(#ic_fluent_building_store_20_color__b)" fill-opacity=".8"/><path d="M11 11.5c0-.28.22-.5.5-.5h3c.28 0 .5.22.5.5v3a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-3Z" fill="url(#ic_fluent_building_store_20_color__c)" fill-opacity=".8"/><path d="M4.6 2.18 2.13 5.15A.55.55 0 0 0 2 5.5V7a3 3 0 0 0 6 0V5.5h-.5l1-3.5H4.98a.5.5 0 0 0-.38.18Z" fill="url(#ic_fluent_building_store_20_color__d)"/><path d="m11.5 2 1 3.5H12V7a3 3 0 1 0 6 0V5.5a.55.55 0 0 0-.13-.35L15.4 2.18a.5.5 0 0 0-.38-.18H11.5Z" fill="url(#ic_fluent_building_store_20_color__e)"/><path d="M8.1 2 7 5.5v1.75C7 8.77 8.34 10 10 10s3-1.23 3-2.75V5.5L11.9 2H8.1Z" fill="url(#ic_fluent_building_store_20_color__f)"/><defs><linearGradient id="ic_fluent_building_store_20_color__a" x1="6.5" y1="8" x2="8.5" y2="18.5" gradientUnits="userSpaceOnUse"><stop offset=".31" stop-color="#29C3FF"/><stop offset="1" stop-color="#0094F0"/></linearGradient><linearGradient id="ic_fluent_building_store_20_color__b" x1="5.18" y1="12.31" x2="9.81" y2="15.75" gradientUnits="userSpaceOnUse"><stop stop-color="#0067BF"/><stop offset="1" stop-color="#003580"/></linearGradient><linearGradient id="ic_fluent_building_store_20_color__c" x1="12.2" y1="10.56" x2="13.66" y2="15.82" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_building_store_20_color__d" x1="5" y1="2" x2="5" y2="5.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FB6F7B"/><stop offset="1" stop-color="#D7257D"/></linearGradient><linearGradient id="ic_fluent_building_store_20_color__e" x1="14.5" y1="2" x2="14.5" y2="5.5" gradientUnits="userSpaceOnUse"><stop stop-color="#FB6F7B"/><stop offset="1" stop-color="#D7257D"/></linearGradient><linearGradient id="ic_fluent_building_store_20_color__f" x1="10" y1="2" x2="10" y2="5.5" gradientUnits="userSpaceOnUse"><stop offset=".3" stop-color="#FF9FB2"/><stop offset="1" stop-color="#F97DBD"/></linearGradient></defs>`, { color: true }));
export const BuildingSwapFilled = ( /*#__PURE__*/createFluentIcon('BuildingSwapFilled', "1em", ["M4 3.5C4 2.67 4.67 2 5.5 2h6c.83 0 1.5.67 1.5 1.5V8h1.5c.83 0 1.5.67 1.5 1.5v2.59a1.5 1.5 0 0 0-.91 1.91H13.9a1.5 1.5 0 0 0-2.47-1.56l-2 2a1.5 1.5 0 0 0 0 2.12L10.88 18H4.5a.5.5 0 0 1-.5-.5v-14Zm2.75 3a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm3.75-6.75a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0ZM9.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 0-1.5 0 .75.75 0 0 0 1.5 0Zm2.35 2.1a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2a.5.5 0 0 0 .7-.7L11.71 16h5.58l-1.14 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L17.29 15h-5.58l1.14-1.15Z"]));
export const BuildingSwapRegular = ( /*#__PURE__*/createFluentIcon('BuildingSwapRegular', "1em", ["M7.5 5.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM6.75 9.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0ZM9.75 6.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.13 4.5 1 1H4.5a.5.5 0 0 1-.5-.5v-14C4 2.67 4.67 2 5.5 2h6c.83 0 1.5.67 1.5 1.5V8h1.5c.83 0 1.5.67 1.5 1.5v2.59a1.5 1.5 0 0 0-1 1.4V9.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 1-.5-.5v-5a.5.5 0 0 0-.5-.5h-6a.5.5 0 0 0-.5.5V17h4.88Zm2.97-3.15a.5.5 0 0 0-.7-.7l-2 2a.5.5 0 0 0 0 .7l2 2a.5.5 0 0 0 .7-.7L11.71 16h5.58l-1.14 1.15a.5.5 0 0 0 .7.7l2-2a.5.5 0 0 0 0-.7l-2-2a.5.5 0 0 0-.7.7L17.29 15h-5.58l1.14-1.15Z"]));
export const BuildingTownhouseFilled = ( /*#__PURE__*/createFluentIcon('BuildingTownhouseFilled', "1em", ["M6.96 3.3a1 1 0 0 0-1.42 0l-2.1 2.1A1.5 1.5 0 0 0 3 6.44v9.05c0 .83.67 1.5 1.5 1.5H7v-3.5c0-.28.22-.5.5-.5h2V6.45c0-.4-.16-.78-.44-1.06l-2.1-2.1Zm3.54 3.15V13h2c.28 0 .5.22.5.5V17h2.5c.83 0 1.5-.67 1.5-1.5V6.45c0-.4-.16-.78-.44-1.06l-2.1-2.1a1 1 0 0 0-1.42 0l-2.1 2.1a1.5 1.5 0 0 0-.44 1.06Zm0 7.55v3H12v-3h-1.5Zm-1 3v-3H8v3h1.5ZM7 7.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Zm8.25-3.75a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm-.75 3.75a.75.75 0 1 1 0-1.5.75.75 0 0 1 0 1.5Z"]));
export const BuildingTownhouseRegular = ( /*#__PURE__*/createFluentIcon('BuildingTownhouseRegular', "1em", ["M6.1 3.24a1 1 0 0 1 1.3 0L9.97 5.4l.03.03.03-.03 2.57-2.17a1 1 0 0 1 1.3 0l2.57 2.17c.34.28.53.7.53 1.15v8.94c0 .83-.67 1.5-1.5 1.5h-11A1.5 1.5 0 0 1 3 15.5V6.56c0-.45.2-.87.53-1.15L6.1 3.24ZM10.5 13h2c.28 0 .5.22.5.5V16h2.5a.5.5 0 0 0 .5-.5V6.56a.5.5 0 0 0-.18-.39L13.25 4l-2.57 2.17a.5.5 0 0 0-.18.39V13Zm-1 0V6.56a.5.5 0 0 0-.18-.39L6.75 4 4.18 6.17a.5.5 0 0 0-.18.39v8.94c0 .28.22.5.5.5H7v-2.5c0-.28.22-.5.5-.5h2ZM8 16h1.5v-2H8v2Zm2.5-2v2H12v-2h-1.5ZM6.75 8.5a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Zm5.75-2.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Zm.75 2.25a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0Z"]));
export const ButtonFilled = ( /*#__PURE__*/createFluentIcon('ButtonFilled', "1em", ["M2 8a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v3a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V8Zm7 1.5c0 .28.22.5.5.5H14a.5.5 0 0 0 0-1H9.5a.5.5 0 0 0-.5.5Zm-1 0a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0Z"]));
export const ButtonRegular = ( /*#__PURE__*/createFluentIcon('ButtonRegular', "1em", ["M2 8a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v3a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V8Zm3-2a2 2 0 0 0-2 2v3c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2H5Zm4 3.5c0-.28.22-.5.5-.5H14a.5.5 0 0 1 0 1H9.5a.5.5 0 0 1-.5-.5Zm-1 0a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"]));
export const CalculatorFilled = ( /*#__PURE__*/createFluentIcon('CalculatorFilled', "1em", ["M13.5 2h-7A2.5 2.5 0 0 0 4 4.5v11A2.5 2.5 0 0 0 6.5 18h7a2.5 2.5 0 0 0 2.5-2.5v-11A2.5 2.5 0 0 0 13.5 2Zm-6 2h5c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5h-5A1.5 1.5 0 0 1 6 6.5v-1C6 4.67 6.67 4 7.5 4Zm.5 7a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm0 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm5-2a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-4-2a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"]));
export const CalculatorRegular = ( /*#__PURE__*/createFluentIcon('CalculatorRegular', "1em", ["M8 11a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm0 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm5-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-4-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0ZM7.5 4C6.67 4 6 4.67 6 5.5v1C6 7.33 6.67 8 7.5 8h5c.83 0 1.5-.67 1.5-1.5v-1c0-.83-.67-1.5-1.5-1.5h-5ZM7 5.5c0-.28.22-.5.5-.5h5c.28 0 .5.22.5.5v1a.5.5 0 0 1-.5.5h-5a.5.5 0 0 1-.5-.5v-1Zm9 10a2.5 2.5 0 0 1-2.5 2.5h-7A2.5 2.5 0 0 1 4 15.5v-11A2.5 2.5 0 0 1 6.5 2h7A2.5 2.5 0 0 1 16 4.5v11Zm-1-11c0-.83-.67-1.5-1.5-1.5h-7C5.67 3 5 3.67 5 4.5v11c0 .83.67 1.5 1.5 1.5h7c.83 0 1.5-.67 1.5-1.5v-11Z"]));
export const CalculatorArrowClockwiseFilled = ( /*#__PURE__*/createFluentIcon('CalculatorArrowClockwiseFilled', "1em", ["M13.5 2h-7A2.5 2.5 0 0 0 4 4.5v11A2.5 2.5 0 0 0 6.5 18h3.77a5.48 5.48 0 0 1-.64-6.07 1 1 0 1 1 1.17-1.52A5.48 5.48 0 0 1 16 9.19V4.5A2.5 2.5 0 0 0 13.5 2Zm-6 2h5c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5h-5A1.5 1.5 0 0 1 6 6.5v-1C6 4.67 6.67 4 7.5 4Zm.5 7a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm0 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm9.5-1.52a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v.76a4.5 4.5 0 1 0 2 3.74.5.5 0 1 0-1 0 3.5 3.5 0 1 1-1.7-3h-.8a.5.5 0 1 0 0 1h2Z"]));
export const CalculatorArrowClockwiseRegular = ( /*#__PURE__*/createFluentIcon('CalculatorArrowClockwiseRegular', "1em", ["M7 12a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm0 3a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm2.63-3.07c.3-.58.7-1.1 1.17-1.52a1 1 0 1 0-1.17 1.52ZM6.5 17h3.11c.18.36.4.7.66 1H6.5A2.5 2.5 0 0 1 4 15.5v-11A2.5 2.5 0 0 1 6.5 2h7A2.5 2.5 0 0 1 16 4.5v4.69c-.32-.1-.66-.16-1-.19V4.5c0-.83-.67-1.5-1.5-1.5h-7C5.67 3 5 3.67 5 4.5v11c0 .83.67 1.5 1.5 1.5ZM6 5.5C6 4.67 6.67 4 7.5 4h5c.83 0 1.5.67 1.5 1.5v1c0 .83-.67 1.5-1.5 1.5h-5A1.5 1.5 0 0 1 6 6.5v-1ZM7.5 5a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h5a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-5Zm10 7.48a.5.5 0 0 0 .5-.5v-2a.5.5 0 0 0-1 0v.76a4.5 4.5 0 1 0 2 3.74.5.5 0 1 0-1 0 3.5 3.5 0 1 1-1.7-3h-.8a.5.5 0 1 0 0 1h2Z"]));
export const CalculatorMultipleFilled = ( /*#__PURE__*/createFluentIcon('CalculatorMultipleFilled', "1em", ["M5.5 2A2.5 2.5 0 0 0 3 4.5v9A2.5 2.5 0 0 0 5.5 16h7a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 12.5 2h-7ZM5 5a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V5Zm0 5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm4-1a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm0 2.75a1 1 0 1 1 0 2 1 1 0 0 1 0-2ZM11 10a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1 1.75a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm-6 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2ZM7.5 18a2.5 2.5 0 0 1-2-1h7a3.5 3.5 0 0 0 3.5-3.5v-9c.6.46 1 1.18 1 2v7a4.5 4.5 0 0 1-4.5 4.5h-5Z"]));
export const CalculatorMultipleRegular = ( /*#__PURE__*/createFluentIcon('CalculatorMultipleRegular', "1em", ["M6 4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1H6Zm0 1h6v2H6V5Zm2 5a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1 1.75a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM11 10a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1 1.75a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM5 10a1 1 0 1 1 2 0 1 1 0 0 1-2 0Zm1 1.75a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM5.5 2A2.5 2.5 0 0 0 3 4.5v9A2.5 2.5 0 0 0 5.5 16h7a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 12.5 2h-7ZM4 4.5C4 3.67 4.67 3 5.5 3h7c.83 0 1.5.67 1.5 1.5v9c0 .83-.67 1.5-1.5 1.5h-7A1.5 1.5 0 0 1 4 13.5v-9ZM7.5 18a2.5 2.5 0 0 1-2-1h7a3.5 3.5 0 0 0 3.5-3.5v-9c.6.46 1 1.18 1 2v7a4.5 4.5 0 0 1-4.5 4.5h-5Z"]));
export const CalendarColor = ( /*#__PURE__*/createFluentIcon('CalendarColor', "1em", `<path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_20_color__a)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_20_color__b)"/><g filter="url(#ic_fluent_calendar_20_color__c)"><path d="M8 10a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_20_color__d)"/><path d="M8 13a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_20_color__e)"/><path d="M11 13a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_20_color__f)"/><path d="M10 11a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" fill="url(#ic_fluent_calendar_20_color__g)"/><path d="M14 10a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_20_color__h)"/></g><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_20_color__i)"/><defs><linearGradient id="ic_fluent_calendar_20_color__a" x1="12.53" y1="18.35" x2="8.5" y2="6.56" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_20_color__d" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_20_color__e" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_20_color__f" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_20_color__g" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_20_color__h" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_20_color__i" x1="3" y1="3" x2="15.02" y2="-.77" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><filter id="ic_fluent_calendar_20_color__c" x="4.67" y="8.33" width="10.67" height="7.67" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy=".67"/><feGaussianBlur stdDeviation=".67"/><feColorMatrix values="0 0 0 0 0.1242 0 0 0 0 0.323337 0 0 0 0 0.7958 0 0 0 0.32 0"/><feBlend in2="BackgroundImageFix" result="effect1_dropShadow_378174_9787"/><feBlend in="SourceGraphic" in2="effect1_dropShadow_378174_9787" result="shape"/></filter></defs>`, { color: true }));
export const CalendarFilled = ( /*#__PURE__*/createFluentIcon('CalendarFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5V6h14v-.5A2.5 2.5 0 0 0 14.5 3h-9ZM17 7H3v7.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V7Zm-9 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"], { flipInRtl: true }));
export const CalendarRegular = ( /*#__PURE__*/createFluentIcon('CalendarRegular', "1em", ["M7 11a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9ZM4 7h12v7.5c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 4 14.5V7Zm1.5-3h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Z"], { flipInRtl: true }));
export const Calendar3DayFilled = ( /*#__PURE__*/createFluentIcon('Calendar3DayFilled', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm-8 3a.5.5 0 0 0-.5.41v7.18a.5.5 0 0 0 1 0V6.41A.5.5 0 0 0 6.5 6ZM10 6a.5.5 0 0 0-.5.41v7.18a.5.5 0 0 0 1 0V6.41A.5.5 0 0 0 10 6Zm3.5 0a.5.5 0 0 0-.5.41v7.18a.5.5 0 0 0 1 0V6.41a.5.5 0 0 0-.5-.41Z"]));
export const Calendar3DayRegular = ( /*#__PURE__*/createFluentIcon('Calendar3DayRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5Zm-8 2a.5.5 0 0 1 .5.41v7.09a.5.5 0 0 1-1 .09V6.5c0-.28.22-.5.5-.5ZM10 6a.5.5 0 0 1 .5.41v7.09a.5.5 0 0 1-1 .09V6.5c0-.28.22-.5.5-.5Zm3.5 0a.5.5 0 0 1 .5.41v7.09a.5.5 0 0 1-1 .09V6.5c0-.28.22-.5.5-.5Z"]));
export const CalendarAddFilled = ( /*#__PURE__*/createFluentIcon('CalendarAddFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const CalendarAddRegular = ( /*#__PURE__*/createFluentIcon('CalendarAddRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 0 0 0 1H14v1.5a.5.5 0 0 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const CalendarAgendaFilled = ( /*#__PURE__*/createFluentIcon('CalendarAgendaFilled', "1em", ["M17 14.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9Zm-3-8a.5.5 0 0 0-.41-.5H6.41a.5.5 0 0 0 0 1h7.18a.5.5 0 0 0 .41-.5Zm0 3.5a.5.5 0 0 0-.41-.5H6.41a.5.5 0 0 0 0 1h7.18A.5.5 0 0 0 14 10Zm0 3.5a.5.5 0 0 0-.41-.5H6.41a.5.5 0 0 0 0 1h7.18a.5.5 0 0 0 .41-.5Z"]));
export const CalendarAgendaRegular = ( /*#__PURE__*/createFluentIcon('CalendarAgendaRegular', "1em", ["M17 14.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9Zm-1 0v-9c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5Zm-2-8a.5.5 0 0 1-.41.5H6.5a.5.5 0 0 1-.09-1h7.09c.28 0 .5.22.5.5Zm0 3.5a.5.5 0 0 1-.41.5H6.5a.5.5 0 0 1-.09-1h7.09c.28 0 .5.22.5.5Zm0 3.5a.5.5 0 0 1-.41.5H6.5a.5.5 0 0 1-.09-1h7.09c.28 0 .5.22.5.5Z"]));
export const CalendarArrowCounterclockwiseFilled = ( /*#__PURE__*/createFluentIcon('CalendarArrowCounterclockwiseFilled', "1em", ["M3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5V6H6.11A1.5 1.5 0 0 0 4 5.87V7.3l.65-.64a.5.5 0 1 1 .7.7l-1.5 1.5a.5.5 0 0 1-.7 0l-1.5-1.5a.5.5 0 1 1 .7-.7l.65.64V5.5ZM17 7v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V9.92a1.5 1.5 0 0 0 1.55-.36l1.5-1.5c.3-.3.44-.68.44-1.06H17ZM7 11a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-1 2a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm4-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-1 2a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm4-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z"]));
export const CalendarArrowCounterclockwiseRegular = ( /*#__PURE__*/createFluentIcon('CalendarArrowCounterclockwiseRegular', "1em", ["M5.5 17A2.5 2.5 0 0 1 3 14.5v-4a.5.5 0 0 1 1 0v4c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V7H6.5c0-.36-.14-.72-.4-1H16v-.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5v1.8l.65-.65a.5.5 0 1 1 .7.7l-1.5 1.5a.5.5 0 0 1-.7 0l-1.5-1.5a.5.5 0 1 1 .7-.7l.65.64V5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9ZM8 10a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"]));
export const CalendarArrowDownFilled = ( /*#__PURE__*/createFluentIcon('CalendarArrowDownFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5V6h14v-.5A2.5 2.5 0 0 0 14.5 3h-9ZM17 7H3v7.5A2.5 2.5 0 0 0 5.5 17h4.1A5.5 5.5 0 0 1 17 9.6V7Zm2 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.85 2.35a.5.5 0 0 0 .35.15.5.5 0 0 0 .35-.15l2-2a.5.5 0 0 0-.7-.7L15 15.29V12.5a.5.5 0 0 0-1 0v2.8l-1.15-1.15a.5.5 0 0 0-.7.7l2 2Z"]));
export const CalendarArrowDownRegular = ( /*#__PURE__*/createFluentIcon('CalendarArrowDownRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.2c.35.1.68.24 1 .4V5.5A2.5 2.5 0 0 0 14.5 3h-9ZM4 5.5C4 4.67 4.67 4 5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5Zm15 9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.85 2.35a.5.5 0 0 0 .35.15.5.5 0 0 0 .35-.15l2-2a.5.5 0 0 0-.7-.7L15 15.29V12.5a.5.5 0 0 0-1 0v2.8l-1.15-1.15a.5.5 0 0 0-.7.7l2 2Z"]));
export const CalendarArrowRepeatAllFilled = ( /*#__PURE__*/createFluentIcon('CalendarArrowRepeatAllFilled', "1em", ["M17 11V7H3v7.5A2.5 2.5 0 0 0 5.5 17h4.47a1.5 1.5 0 0 1-1.17-.6A3.99 3.99 0 0 1 12 10h.5a1.5 1.5 0 0 1 2.56-1.06l1.5 1.5c.17.16.28.36.36.56H17Zm0-5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5Zm-2.65 4.15a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const CalendarArrowRepeatAllRegular = ( /*#__PURE__*/createFluentIcon('CalendarArrowRepeatAllRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.47a1.5 1.5 0 0 1-1.17-.6c-.1-.13-.18-.26-.26-.4H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.88l.56.56c.17.16.28.36.36.56H17V5.5ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Zm8.85 5.65a.5.5 0 0 0-.7.7l.64.65H12a3 3 0 0 0-2.4 4.8.5.5 0 1 0 .8-.6A2 2 0 0 1 12 12h2.3l-.65.65a.5.5 0 0 0 .7.7l1.5-1.5a.5.5 0 0 0 0-.7l-1.5-1.5Zm3.05 2.55a.5.5 0 0 0-.8.6A2 2 0 0 1 15 16h-2.3l.65-.65a.5.5 0 0 0-.7-.7l-1.5 1.5a.5.5 0 0 0 0 .7l1.5 1.5a.5.5 0 0 0 .7-.7l-.64-.65H15a3 3 0 0 0 2.4-4.8Z"]));
export const CalendarArrowRightFilled = ( /*#__PURE__*/createFluentIcon('CalendarArrowRightFilled', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5Zm0 4.1V7H3v7.5A2.5 2.5 0 0 0 5.5 17h4.1A5.5 5.5 0 0 1 17 9.6Zm2 4.9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const CalendarArrowRightRegular = ( /*#__PURE__*/createFluentIcon('CalendarArrowRightRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.2c.35.1.68.24 1 .4V5.5ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15.35a.5.5 0 0 0 .15-.35.5.5 0 0 0-.15-.35l-2-2a.5.5 0 0 0-.7.7L15.29 14H12.5a.5.5 0 0 0 0 1h2.8l-1.15 1.15a.5.5 0 0 0 .7.7l2-2Z"]));
export const CalendarAssistantFilled = ( /*#__PURE__*/createFluentIcon('CalendarAssistantFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm0 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-1.1-7.17a.5.5 0 0 1 .48-.33h1.18a.5.5 0 0 1 .47.66l-.28.84H16a.5.5 0 0 1 .42.77l-2.25 3.5a.5.5 0 0 1-.9-.4l.5-1.87H13a.5.5 0 0 1-.47-.67l.88-2.5Z"]));
export const CalendarAssistantRegular = ( /*#__PURE__*/createFluentIcon('CalendarAssistantRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.2c.35.1.68.24 1 .4V5.5ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-5.12-3a.5.5 0 0 0-.47.33l-.88 2.5A.5.5 0 0 0 13 15h.78l-.51 1.87a.5.5 0 0 0 .9.4l2.25-3.5A.5.5 0 0 0 16 13h-.75l.28-.84a.5.5 0 0 0-.47-.66h-1.18Z"]));
export const CalendarCancelColor = ( /*#__PURE__*/createFluentIcon('CalendarCancelColor', "1em", `<path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_cancel_20_color__a)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_cancel_20_color__b)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_cancel_20_color__c)" fill-opacity=".3"/><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_cancel_20_color__d)"/><path d="M19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Z" fill="url(#ic_fluent_calendar_cancel_20_color__e)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M12.65 12.65c.2-.2.5-.2.7 0l1.15 1.14 1.15-1.14a.5.5 0 0 1 .7.7l-1.14 1.15 1.14 1.15a.5.5 0 0 1-.7.7l-1.15-1.14-1.15 1.14a.5.5 0 0 1-.7-.7l1.14-1.15-1.14-1.15a.5.5 0 0 1 0-.7Z" fill="url(#ic_fluent_calendar_cancel_20_color__f)"/><defs><linearGradient id="ic_fluent_calendar_cancel_20_color__a" x1="8" y1="6" x2="11.5" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#8CD0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_cancel_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_cancel_20_color__d" x1="3.56" y1="3" x2="4.9" y2="9.82" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_cancel_20_color__e" x1="11.41" y1="10.56" x2="17.31" y2="19.28" gradientUnits="userSpaceOnUse"><stop stop-color="#F83F54"/><stop offset="1" stop-color="#CA2134"/></linearGradient><linearGradient id="ic_fluent_calendar_cancel_20_color__f" x1="12.98" y1="14.65" x2="14.77" y2="16.52" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#FECBE6"/></linearGradient><radialGradient id="ic_fluent_calendar_cancel_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(90 -.5 15) scale(6.5)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const CalendarCancelFilled = ( /*#__PURE__*/createFluentIcon('CalendarCancelFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.5.7 1.15 1.15a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14Z"]));
export const CalendarCancelRegular = ( /*#__PURE__*/createFluentIcon('CalendarCancelRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.5.7 1.15 1.15a.5.5 0 0 0 .7-.7l-1.14-1.15 1.14-1.15a.5.5 0 0 0-.7-.7l-1.15 1.14-1.15-1.14a.5.5 0 0 0-.7.7l1.14 1.15-1.14 1.15a.5.5 0 0 0 .7.7l1.15-1.14Z"]));
export const CalendarChatFilled = ( /*#__PURE__*/createFluentIcon('CalendarChatFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5V6h14v-.5A2.5 2.5 0 0 0 14.5 3h-9ZM17 7H3v7.5A2.5 2.5 0 0 0 5.5 17h3.92l.07-.23A5.48 5.48 0 0 1 14.5 9c.9 0 1.75.22 2.5.6V7Zm-7 7.5c0 .8.2 1.54.56 2.18l-.54 1.8c-.1.3.2.6.51.5l1.79-.54A4.5 4.5 0 1 0 10 14.5Zm2.5-1.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 1 1 0-1Zm-.5 2.5c0-.28.22-.5.5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5Z"]));
export const CalendarChatRegular = ( /*#__PURE__*/createFluentIcon('CalendarChatRegular', "1em", ["M5.5 16h3.7c.08.27.18.52.29.77l-.07.23H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5Zm0-12C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5h-9Zm5.06 12.68-.54 1.8c-.1.3.2.6.5.5l1.8-.54a4.5 4.5 0 1 0-1.76-1.75ZM12.5 16a.5.5 0 0 1 0-1h2a.5.5 0 1 1 0 1h-2Zm0-3h4a.5.5 0 1 1 0 1h-4a.5.5 0 0 1 0-1Z"]));
export const CalendarCheckmarkColor = ( /*#__PURE__*/createFluentIcon('CalendarCheckmarkColor', "1em", `<path d="M3 6h14v8.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V6Z" fill="url(#ic_fluent_calendar_checkmark_20_color__a)"/><path d="M3 6h14v8.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V6Z" fill="url(#ic_fluent_calendar_checkmark_20_color__b)"/><path d="M3 6h14v8.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V6Z" fill="url(#ic_fluent_calendar_checkmark_20_color__c)" fill-opacity=".3"/><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_checkmark_20_color__d)"/><path d="M19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Z" fill="url(#ic_fluent_calendar_checkmark_20_color__e)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16.85 12.65c.2.2.2.5 0 .7l-3 3a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 2.65-2.64c.2-.2.5-.2.7 0Z" fill="url(#ic_fluent_calendar_checkmark_20_color__f)"/><defs><linearGradient id="ic_fluent_calendar_checkmark_20_color__a" x1="8" y1="6" x2="11.5" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#8CD0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_checkmark_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_checkmark_20_color__d" x1="3.56" y1="3" x2="4.9" y2="9.82" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_checkmark_20_color__e" x1="10.32" y1="11.69" x2="16.53" y2="18.14" gradientUnits="userSpaceOnUse"><stop stop-color="#52D17C"/><stop offset="1" stop-color="#22918B"/></linearGradient><linearGradient id="ic_fluent_calendar_checkmark_20_color__f" x1="12.94" y1="12.91" x2="13.95" y2="17.36" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#E3FFD9"/></linearGradient><radialGradient id="ic_fluent_calendar_checkmark_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(90 -.5 15) scale(6.5)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const CalendarCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('CalendarCheckmarkFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const CalendarCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('CalendarCheckmarkRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0l-2.65 2.64-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z"]));
export const CalendarCheckmarkCenterFilled = ( /*#__PURE__*/createFluentIcon('CalendarCheckmarkCenterFilled', "1em", ["M17 14.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V7h14v7.5Zm-3.65-5.35a.5.5 0 0 0-.7 0L9 12.79l-1.65-1.64-.07-.07a.5.5 0 0 0-.63.77l2 2c.2.2.5.2.7 0l4-4a.5.5 0 0 0 0-.7ZM14.5 3A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Z"]));
export const CalendarCheckmarkCenterRegular = ( /*#__PURE__*/createFluentIcon('CalendarCheckmarkCenterRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9ZM4 14.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V7H4v7.5Zm8.65-5.35a.5.5 0 1 1 .7.7l-4 4a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .63-.77l.07.07L9 12.79l3.65-3.64ZM5.5 4C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5h-9Z"]));
export const CalendarCheckmarkSparkleFilled = ( /*#__PURE__*/createFluentIcon('CalendarCheckmarkSparkleFilled', "1em", ["M12.15 7.05c.1.25.25.48.52.7.14.1.3.16.45.2a1.3 1.3 0 0 0-.01 1.06.5.5 0 0 0-.46.14L9 12.79l-1.65-1.64-.07-.07a.5.5 0 0 0-.63.77l2 2c.2.2.5.2.7 0l4-4a.5.5 0 0 0 .15-.33c.11.09.25.16.4.22l.76.25c.08.03.15.08.21.14.08.06.12.14.15.22l.26.8c.1.25.26.46.48.62.21.15.47.23.74.23.17 0 .34-.02.5-.08v2.58a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V7h9.14l.01.05ZM16.48 6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-3-6a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Zm-4.4 3a1.42 1.42 0 0 0 .18 1.32c.17.24.41.43.71.53l1.06.35c.15.05.3.13.47.29.11.1.2.24.3.47V6H3v-.5A2.5 2.5 0 0 1 5.5 3h3.59Z"]));
export const CalendarCheckmarkSparkleRegular = ( /*#__PURE__*/createFluentIcon('CalendarCheckmarkSparkleRegular', "1em", ["M9.09 3a1.42 1.42 0 0 0 0 1H5.5C4.67 4 4 4.67 4 5.5V6h7.8l.34 1H4v7.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-2.6a1.45 1.45 0 0 0 1 .02v2.58a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h3.59Zm3.56 6.15a.5.5 0 1 1 .7.7l-4 4a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .63-.77l.07.07L9 12.79l3.65-3.64ZM16.48 6a.3.3 0 0 1 .29.2l.25.77a1.58 1.58 0 0 0 1 1l.76.24h.02a.3.3 0 0 1 .14.47.3.3 0 0 1-.14.1l-.77.26a1.58 1.58 0 0 0-1 1l-.24.76a.3.3 0 0 1-.58 0l-.24-.77a1.57 1.57 0 0 0-1-1l-.77-.25a.3.3 0 0 1-.14-.46.3.3 0 0 1 .14-.1l.77-.26a1.58 1.58 0 0 0 .98-1l.25-.76a.3.3 0 0 1 .28-.2Zm-3-6a.42.42 0 0 1 .4.28l.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.64.2l-.02-.01a.43.43 0 0 1-.14-.2l-.35-1.06a2.22 2.22 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .4-.28Z"]));
export const CalendarClockColor = ( /*#__PURE__*/createFluentIcon('CalendarClockColor', "1em", `<path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_clock_20_color__a)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_clock_20_color__b)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_clock_20_color__c)" fill-opacity=".3"/><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_clock_20_color__d)"/><path d="M19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Z" fill="url(#ic_fluent_calendar_clock_20_color__e)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 12c.28 0 .5.22.5.5V14h1a.5.5 0 0 1 0 1h-1.5a.5.5 0 0 1-.5-.5v-2c0-.28.22-.5.5-.5Z" fill="url(#ic_fluent_calendar_clock_20_color__f)"/><defs><linearGradient id="ic_fluent_calendar_clock_20_color__a" x1="8" y1="6" x2="11.5" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#8CD0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_clock_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_clock_20_color__d" x1="3.56" y1="3" x2="4.9" y2="9.82" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_clock_20_color__e" x1="11.5" y1="9.5" x2="16" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#1EC8B0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_clock_20_color__f" x1="14.22" y1="12.46" x2="13.51" y2="14.89" gradientUnits="userSpaceOnUse"><stop stop-color="#FDFDFD"/><stop offset="1" stop-color="#D1D1FF"/></linearGradient><radialGradient id="ic_fluent_calendar_clock_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(90 -.5 15) scale(6.5)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const CalendarClockFilled = ( /*#__PURE__*/createFluentIcon('CalendarClockFilled', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5Zm0 4.1V7H3v7.5A2.5 2.5 0 0 0 5.5 17h4.1A5.5 5.5 0 0 1 17 9.6ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.5-6.5a.5.5 0 0 1 1 0V14h1a.5.5 0 0 1 0 1h-1.5a.5.5 0 0 1-.5-.5v-2Z"]));
export const CalendarClockRegular = ( /*#__PURE__*/createFluentIcon('CalendarClockRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.2c.35.1.68.24 1 .4V5.5ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Zm9 15a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.5-6.5a.5.5 0 0 1 1 0V14h1a.5.5 0 0 1 0 1h-1.5a.5.5 0 0 1-.5-.5v-2Z"]));
export const CalendarDataBarColor = ( /*#__PURE__*/createFluentIcon('CalendarDataBarColor', "1em", `<path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_data_bar_20_color__a)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_data_bar_20_color__b)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_data_bar_20_color__c)" fill-opacity=".3"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_data_bar_20_color__d)" fill-opacity=".3"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_data_bar_20_color__e)" fill-opacity=".3"/><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_data_bar_20_color__f)"/><path d="M17 13a1 1 0 1 1 2 0v5a1 1 0 1 1-2 0v-5Z" fill="url(#ic_fluent_calendar_data_bar_20_color__g)"/><path d="M15 10a1 1 0 0 0-1 1v7a1 1 0 1 0 2 0v-7a1 1 0 0 0-1-1Z" fill="url(#ic_fluent_calendar_data_bar_20_color__h)"/><path d="M12 14a1 1 0 0 0-1 1v3a1 1 0 1 0 2 0v-3a1 1 0 0 0-1-1Z" fill="url(#ic_fluent_calendar_data_bar_20_color__i)"/><defs><linearGradient id="ic_fluent_calendar_data_bar_20_color__a" x1="8" y1="6" x2="11.5" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#8CD0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_data_bar_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_data_bar_20_color__f" x1="3.56" y1="3" x2="4.9" y2="9.82" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_data_bar_20_color__g" x1="18.83" y1="17.72" x2="17.76" y2="11.93" gradientUnits="userSpaceOnUse"><stop stop-color="#D7257D"/><stop offset="1" stop-color="#E656EB"/></linearGradient><linearGradient id="ic_fluent_calendar_data_bar_20_color__h" x1="16.5" y1="20" x2="14.86" y2="10.09" gradientUnits="userSpaceOnUse"><stop stop-color="#5B2AB5"/><stop offset="1" stop-color="#DD3CE2"/></linearGradient><linearGradient id="ic_fluent_calendar_data_bar_20_color__i" x1="11.25" y1="14.21" x2="15.47" y2="16.2" gradientUnits="userSpaceOnUse"><stop stop-color="#16BBDA"/><stop offset="1" stop-color="#2052CB"/></linearGradient><radialGradient id="ic_fluent_calendar_data_bar_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 4 -2 0 12 18)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_calendar_data_bar_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 6.5 -2.15625 0 15 15.5)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_calendar_data_bar_20_color__e" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 5.5 -1.82452 0 18 15.5)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const CalendarDataBarFilled = ( /*#__PURE__*/createFluentIcon('CalendarDataBarFilled', "1em", ["M5.5 17H10v-2a2 2 0 0 1 3-1.73V11a2 2 0 1 1 4 0V7H3v7.5A2.5 2.5 0 0 0 5.5 17Zm9-14A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm.5 7a1 1 0 0 0-1 1v7a1 1 0 1 0 2 0v-7a1 1 0 0 0-1-1Zm-3 4a1 1 0 0 0-1 1v3a1 1 0 1 0 2 0v-3a1 1 0 0 0-1-1Zm5-1a1 1 0 1 1 2 0v5a1 1 0 1 1-2 0v-5Z"]));
export const CalendarDataBarRegular = ( /*#__PURE__*/createFluentIcon('CalendarDataBarRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17H10v-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.27c.6.34 1 .99 1 1.73V5.5ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Zm9.5 6a1 1 0 0 0-1 1v7a1 1 0 1 0 2 0v-7a1 1 0 0 0-1-1Zm-3 4a1 1 0 0 0-1 1v3a1 1 0 1 0 2 0v-3a1 1 0 0 0-1-1Zm5-1a1 1 0 1 1 2 0v5a1 1 0 1 1-2 0v-5Z"]));
export const CalendarDateFilled = ( /*#__PURE__*/createFluentIcon('CalendarDateFilled', "1em", ["M17 7v7.5a2.5 2.5 0 0 1-2.34 2.5H5.5A2.5 2.5 0 0 1 3 14.66V7h14Zm-5.48 1.23c-.53 0-.96.15-1.27.43-.31.28-.47.67-.47 1.15 0 .28.07.53.21.75.15.21.34.39.58.51-.29.13-.51.32-.67.56-.17.24-.25.51-.25.82 0 .5.17.9.51 1.19a2 2 0 0 0 1.36.44 2 2 0 0 0 1.35-.44c.34-.3.51-.7.51-1.2 0-.3-.08-.56-.24-.8a1.62 1.62 0 0 0-.69-.57c.25-.12.45-.3.59-.51.14-.22.21-.47.21-.75 0-.48-.15-.87-.46-1.15a1.82 1.82 0 0 0-1.27-.43ZM8.5 8.3h-.13l-2.21.82v.8l1.4-.48V14h.94V8.3Zm3.01 3.17c.28 0 .5.09.67.26.17.17.25.4.25.68 0 .3-.08.52-.24.68a.9.9 0 0 1-.67.24.9.9 0 0 1-.67-.25.91.91 0 0 1-.25-.67c0-.28.09-.5.25-.68a.88.88 0 0 1 .66-.26Zm0-2.46c.25 0 .44.08.58.24.15.16.22.36.22.6 0 .27-.07.48-.21.63a.75.75 0 0 1-.58.23.75.75 0 0 1-.58-.23.88.88 0 0 1-.2-.62c0-.27.06-.47.2-.63a.74.74 0 0 1 .58-.22Zm2.99-6A2.5 2.5 0 0 1 17 5.34V6H3v-.5A2.5 2.5 0 0 1 5.34 3h9.16Z"]));
export const CalendarDateRegular = ( /*#__PURE__*/createFluentIcon('CalendarDateRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.34v9.16a2.5 2.5 0 0 1-2.34 2.5H5.5A2.5 2.5 0 0 1 3 14.66V5.5A2.5 2.5 0 0 1 5.34 3h9.16ZM16 7H4v7.5c0 .78.6 1.42 1.36 1.5h9.14c.78 0 1.42-.6 1.5-1.36V7Zm-4.48 1.23c.53 0 .95.15 1.27.43.3.28.46.67.46 1.15 0 .28-.07.53-.21.75-.14.21-.34.39-.59.51.3.14.53.33.69.57.16.24.24.5.24.8 0 .5-.17.9-.5 1.2a2 2 0 0 1-1.36.44 2 2 0 0 1-1.36-.44 1.5 1.5 0 0 1-.5-1.2c0-.3.07-.57.24-.81.16-.24.38-.43.67-.56-.24-.12-.43-.3-.58-.51a1.33 1.33 0 0 1-.2-.75c0-.48.15-.87.46-1.15.31-.28.74-.43 1.27-.43ZM8.5 8.3V14h-.95V9.43l-1.4.48v-.8l2.22-.82h.13Zm3.01 3.17c-.27 0-.5.09-.66.26a.94.94 0 0 0-.25.68c0 .28.08.5.25.67a.9.9 0 0 0 .67.25.9.9 0 0 0 .67-.24.92.92 0 0 0 .24-.68c0-.28-.08-.5-.25-.68a.89.89 0 0 0-.67-.26Zm0-2.46a.74.74 0 0 0-.57.22.88.88 0 0 0-.2.63c0 .26.06.47.2.62.15.15.34.23.58.23.24 0 .43-.08.58-.23a.88.88 0 0 0 .2-.62.88.88 0 0 0-.2-.61.74.74 0 0 0-.58-.24Zm2.99-5h-9c-.78 0-1.42.6-1.5 1.36V6h12v-.5c0-.78-.6-1.42-1.36-1.5h-.14Z"]));
export const CalendarDayFilled = ( /*#__PURE__*/createFluentIcon('CalendarDayFilled', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm-1.78 6H7.28c-.44 0-.6.05-.77.13a.9.9 0 0 0-.38.38c-.07.14-.12.29-.13.62v2.59c0 .44.05.6.13.77.1.16.22.29.38.38.14.07.29.12.62.13H12.72c.44 0 .6-.05.77-.13a.9.9 0 0 0 .38-.38c.07-.14.12-.29.13-.62v-2.59c0-.44-.05-.6-.13-.77a.9.9 0 0 0-.38-.38 1.24 1.24 0 0 0-.62-.13h-.15Zm.2 1h.07V13H7.01v-2.98h5.9Zm.58-4H6.41a.5.5 0 0 0 0 1h7.18a.5.5 0 0 0 0-1h-.09Z"]));
export const CalendarDayRegular = ( /*#__PURE__*/createFluentIcon('CalendarDayRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5Zm-1.78 5c.44 0 .6.05.77.13.16.1.29.22.38.38.08.16.13.33.13.77v2.44c0 .44-.05.6-.13.77a.9.9 0 0 1-.38.38c-.16.08-.33.13-.77.13H7.28c-.44 0-.6-.05-.77-.13a.9.9 0 0 1-.38-.38c-.08-.16-.13-.33-.13-.77v-2.44c0-.44.05-.6.13-.77a.9.9 0 0 1 .38-.38c.16-.08.33-.13.77-.13h5.44Zm.2 1H7V13h5.98v-2.98h-.08Zm.58-4a.5.5 0 0 1 .09 1H6.5a.5.5 0 0 1-.09-1h7.09Z"]));
export const CalendarEditColor = ( /*#__PURE__*/createFluentIcon('CalendarEditColor', "1em", `<path d="M3 6h14v7.7L12.22 17H5.5A2.5 2.5 0 0 1 3 14.5V6Z" fill="url(#ic_fluent_calendar_edit_20_color__a)"/><path d="M3 6h14v7.7L12.22 17H5.5A2.5 2.5 0 0 1 3 14.5V6Z" fill="url(#ic_fluent_calendar_edit_20_color__b)"/><path d="M3 6h14v7.7L12.22 17H5.5A2.5 2.5 0 0 1 3 14.5V6Z" fill="url(#ic_fluent_calendar_edit_20_color__c)" fill-opacity=".3"/><g filter="url(#ic_fluent_calendar_edit_20_color__d)"><path d="M8 10a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_edit_20_color__e)"/><path d="M8 13a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_edit_20_color__f)"/><path d="M11 13a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_edit_20_color__g)"/><path d="M10 11a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" fill="url(#ic_fluent_calendar_edit_20_color__h)"/><path d="M14 10a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" fill="url(#ic_fluent_calendar_edit_20_color__i)"/></g><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_edit_20_color__j)"/><path d="M14.35 12H17v2.65l-3.37 3.37a2.2 2.2 0 0 1-1.02.58l-1.5.37a.89.89 0 0 1-1.07-1.07l.37-1.5c.1-.39.3-.74.58-1.02L14.35 12Z" fill="url(#ic_fluent_calendar_edit_20_color__k)"/><path d="M13.49 18.14a2.2 2.2 0 0 1-.89.46l-1.5.37a.89.89 0 0 1-1.07-1.08l.37-1.5c.08-.31.23-.6.44-.86a3.5 3.5 0 0 0 2.65 2.61Z" fill="url(#ic_fluent_calendar_edit_20_color__l)"/><path d="m14.54 11.82 1.27-1.27a1.87 1.87 0 1 1 2.64 2.64l-1.17 1.18-2.74-2.55Z" fill="url(#ic_fluent_calendar_edit_20_color__m)"/><path d="M18 13.65A3.5 3.5 0 0 1 15.34 11l-1 1A3.5 3.5 0 0 0 17 14.65l1-1Z" fill="url(#ic_fluent_calendar_edit_20_color__n)"/><defs><linearGradient id="ic_fluent_calendar_edit_20_color__a" x1="12.53" y1="18.35" x2="8.5" y2="6.56" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#B3E0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__e" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__f" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__g" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__h" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__i" x1="9.27" y1="8.42" x2="10.91" y2="18.39" gradientUnits="userSpaceOnUse"><stop stop-color="#0078D4"/><stop offset="1" stop-color="#0067BF"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__j" x1="3" y1="3" x2="15.02" y2="-.77" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__k" x1="11.85" y1="13.72" x2="15.29" y2="17.15" gradientUnits="userSpaceOnUse"><stop stop-color="#FFA43D"/><stop offset="1" stop-color="#FB5937"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__l" x1="9.5" y1="16.5" x2="12" y2="18.99" gradientUnits="userSpaceOnUse"><stop offset=".26" stop-color="#FFD394"/><stop offset="1" stop-color="#FF921F"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__m" x1="18.07" y1="10.91" x2="16.46" y2="12.46" gradientUnits="userSpaceOnUse"><stop stop-color="#F97DBD"/><stop offset="1" stop-color="#DD3CE2"/></linearGradient><linearGradient id="ic_fluent_calendar_edit_20_color__n" x1="16.24" y1="13.5" x2="13.66" y2="12.36" gradientUnits="userSpaceOnUse"><stop stop-color="#FF921F"/><stop offset="1" stop-color="#FFE994"/></linearGradient><radialGradient id="ic_fluent_calendar_edit_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(139.76 4.75 10.25) scale(8.51469 3.9309)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><filter id="ic_fluent_calendar_edit_20_color__d" x="4.67" y="8.33" width="10.67" height="7.67" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy=".67"/><feGaussianBlur stdDeviation=".67"/><feColorMatrix values="0 0 0 0 0.1242 0 0 0 0 0.323337 0 0 0 0 0.7958 0 0 0 0.32 0"/><feBlend in2="BackgroundImageFix" result="effect1_dropShadow_72095_10133"/><feBlend in="SourceGraphic" in2="effect1_dropShadow_72095_10133" result="shape"/></filter></defs>`, { color: true }));
export const CalendarEditFilled = ( /*#__PURE__*/createFluentIcon('CalendarEditFilled', "1em", ["M17 9c-.7.03-1.37.31-1.9.84l-4.83 4.83c-.4.4-.7.92-.84 1.48l-.21.85H5.5A2.5 2.5 0 0 1 3 14.5V7h14v2ZM7 11a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-1 2a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm4-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-1 2a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm4-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5Zm-1.2 5.05-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64Z"]));
export const CalendarEditRegular = ( /*#__PURE__*/createFluentIcon('CalendarEditRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h3.72l.21-.85.04-.15H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.23c.32-.14.66-.21 1-.23V5.5ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Zm10.3 6.55-4.82 4.83a2.2 2.2 0 0 0-.58 1.02l-.37 1.5a.89.89 0 0 0 1.08 1.07l1.5-.37c.38-.1.73-.3 1.01-.58l4.83-4.83a1.87 1.87 0 0 0-2.64-2.64ZM8 10a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"]));
export const CalendarEmptyFilled = ( /*#__PURE__*/createFluentIcon('CalendarEmptyFilled', "1em", ["M17 7v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Z"]));
export const CalendarEmptyRegular = ( /*#__PURE__*/createFluentIcon('CalendarEmptyRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9ZM16 7H4v7.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V7Zm-1.5-3h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Z"]));
export const CalendarErrorFilled = ( /*#__PURE__*/createFluentIcon('CalendarErrorFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5V6h14v-.5A2.5 2.5 0 0 0 14.5 3h-9ZM17 7H3v7.5A2.5 2.5 0 0 0 5.5 17h4.1A5.5 5.5 0 0 1 17 9.6V7Zm2 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.24Z"]));
export const CalendarErrorRegular = ( /*#__PURE__*/createFluentIcon('CalendarErrorRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.2c.35.1.68.24 1 .4V5.5A2.5 2.5 0 0 0 14.5 3h-9ZM4 5.5C4 4.67 4.67 4 5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5Zm15 9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 12a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.24Z"]));
export const CalendarEyeFilled = ( /*#__PURE__*/createFluentIcon('CalendarEyeFilled', "1em", ["M14.5 11c2.76 0 4.5 2.3 4.5 3.5 0 1.18-1.74 3.5-4.5 3.5S10 15.7 10 14.5c0-1.18 1.74-3.5 4.5-3.5Zm2.5-.43a5.74 5.74 0 0 0-6.47 1c-.46.44-.84.93-1.1 1.41-.25.47-.43 1-.43 1.52 0 .82.45 1.74 1.12 2.5H5.5A2.5 2.5 0 0 1 3 14.5V7h14v3.57Zm-1.54 1.62a2.5 2.5 0 1 0-1.92 4.62 2.5 2.5 0 0 0 1.92-4.62Zm-.96.81a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm0-10A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Z"]));
export const CalendarEyeRegular = ( /*#__PURE__*/createFluentIcon('CalendarEyeRegular', "1em", ["M14.5 11c2.76 0 4.5 2.3 4.5 3.5 0 1.18-1.74 3.5-4.5 3.5S10 15.7 10 14.5c0-1.18 1.74-3.5 4.5-3.5Zm0-8A2.5 2.5 0 0 1 17 5.5v5.07a5.75 5.75 0 0 0-1-.37V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.92c.19.35.42.69.7 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm.96 9.19a2.5 2.5 0 1 0-1.92 4.62 2.5 2.5 0 0 0 1.92-4.62Zm-.96.81a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm-9-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5h-9Z"]));
export const CalendarInfoFilled = ( /*#__PURE__*/createFluentIcon('CalendarInfoFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm-.63 9.5a.62.62 0 1 1 1.25 0 .62.62 0 0 1-1.24 0Zm1.13 4a.5.5 0 0 1-1 0v-2a.5.5 0 0 1 1 0v2Zm-5-2a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0Zm1 0a3.5 3.5 0 1 0 7 0 3.5 3.5 0 0 0-7 0Z"]));
export const CalendarInfoRegular = ( /*#__PURE__*/createFluentIcon('CalendarInfoRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm-.63 8.5a.62.62 0 1 1 1.25 0 .62.62 0 0 1-1.24 0Zm1.13 4a.5.5 0 0 1-1 0v-2a.5.5 0 0 1 1 0v2Zm-5-2a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0Zm1 0a3.5 3.5 0 1 0 7 0 3.5 3.5 0 0 0-7 0Z"]));
export const CalendarLockFilled = ( /*#__PURE__*/createFluentIcon('CalendarLockFilled', "1em", ["M17 7v2.4a3 3 0 0 0-4.5 2.6v.06A2 2 0 0 0 11 14v3H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm-1 9v1H13a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-.5v-1a2 2 0 1 0-4 0Zm1 1v-1a1 1 0 1 1 2 0v1h-2Zm1 2.25a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z"]));
export const CalendarLockRegular = ( /*#__PURE__*/createFluentIcon('CalendarLockRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v3.9c-.3-.17-.64-.3-1-.36V7H4v7.5c0 .83.67 1.5 1.5 1.5H11v1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm-1 8v1H13a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-.5v-1a2 2 0 1 0-4 0Zm1 1v-1a1 1 0 1 1 2 0v1h-2Zm1 2.25a.75.75 0 1 1 0 1.5.75.75 0 0 1 0-1.5Z"]));
export const CalendarLtrFilled = ( /*#__PURE__*/createFluentIcon('CalendarLtrFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5V6h14v-.5A2.5 2.5 0 0 0 14.5 3h-9ZM17 7H3v7.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V7Zm-9 3a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm-1 4a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm4-4a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z"]));
export const CalendarLtrRegular = ( /*#__PURE__*/createFluentIcon('CalendarLtrRegular', "1em", ["M7 11a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm1 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm2-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm4-5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9ZM4 7h12v7.5c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 4 14.5V7Zm1.5-3h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Z"]));
export const CalendarMailFilled = ( /*#__PURE__*/createFluentIcon('CalendarMailFilled', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5V5h12v-.5A2.5 2.5 0 0 0 11.5 2h-7ZM14 6H2v5.5A2.5 2.5 0 0 0 4.5 14H5v-3a3 3 0 0 1 3-3h6V6Zm-7.93 4.48A2 2 0 0 1 8 9h8a2 2 0 0 1 1.93 1.48L12 13.96l-5.93-3.48Zm6.31 4.42L18 11.6V16a2 2 0 0 1-2 2H8a2 2 0 0 1-2-2v-4.4l5.62 3.3c.23.14.53.14.76 0Z"]));
export const CalendarMailRegular = ( /*#__PURE__*/createFluentIcon('CalendarMailRegular', "1em", ["M2 4.5A2.5 2.5 0 0 1 4.5 2h7A2.5 2.5 0 0 1 14 4.5V8h-1V6H3v5.5c0 .83.67 1.5 1.5 1.5H5v1h-.5A2.5 2.5 0 0 1 2 11.5v-7Zm11 0c0-.83-.67-1.5-1.5-1.5h-7C3.67 3 3 3.67 3 4.5V5h10v-.5ZM8 9a2 2 0 0 0-2 2v5c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2v-5a2 2 0 0 0-2-2H8Zm-1 2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v.02l-5 2.94-5-2.94V11Zm0 1.18 4.62 2.72c.23.14.53.14.76 0L17 12.18V16a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1v-3.82Z"]));
export const CalendarMentionFilled = ( /*#__PURE__*/createFluentIcon('CalendarMentionFilled', "1em", ["M17 7v2.34A5.99 5.99 0 0 0 9.34 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm.5 8a4 4 0 1 0 1.33 7.77.5.5 0 0 1 .34.95A5 5 0 1 1 20 15c0 1.45-.9 2.44-1.97 2.5a1.75 1.75 0 0 1-1.6-.84c-.4.5-.99.84-1.68.84-1.3 0-2.25-1.18-2.25-2.5s.95-2.5 2.25-2.5c.48 0 .9.16 1.26.42A.5.5 0 0 1 17 13v2c0 .62.16 1 .35 1.22.18.2.4.29.62.28.43-.03 1.03-.45 1.03-1.5a4 4 0 0 0-4-4Zm-.25 5.5c.63 0 1.25-.6 1.25-1.5s-.62-1.5-1.25-1.5-1.25.6-1.25 1.5.62 1.5 1.25 1.5Z"]));
export const CalendarMentionRegular = ( /*#__PURE__*/createFluentIcon('CalendarMentionRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v3.84c-.32-.11-.66-.2-1-.26V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.58c.06.34.15.68.26 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm.5 7a4 4 0 1 0 1.33 7.77.5.5 0 0 1 .34.95A5 5 0 1 1 20 15c0 1.45-.9 2.44-1.97 2.5a1.75 1.75 0 0 1-1.6-.84c-.4.5-.99.84-1.68.84-1.3 0-2.25-1.18-2.25-2.5s.95-2.5 2.25-2.5c.48 0 .9.16 1.26.42A.5.5 0 0 1 17 13v2c0 .62.16 1 .35 1.22.18.2.4.29.62.28.43-.03 1.03-.45 1.03-1.5a4 4 0 0 0-4-4Zm-.25 5.5c.63 0 1.25-.6 1.25-1.5s-.62-1.5-1.25-1.5-1.25.6-1.25 1.5.62 1.5 1.25 1.5Z"]));
export const CalendarMonthFilled = ( /*#__PURE__*/createFluentIcon('CalendarMonthFilled', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9ZM7 11a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2ZM7 7a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2Zm3 0a1 1 0 1 0 0 2 1 1 0 0 0 0-2Z"]));
export const CalendarMonthRegular = ( /*#__PURE__*/createFluentIcon('CalendarMonthRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5ZM7 11a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm3 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2ZM7 7a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm3 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm3 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2Z"]));
export const CalendarMultipleFilled = ( /*#__PURE__*/createFluentIcon('CalendarMultipleFilled', "1em", ["M16 13.5V6H2v7.5A2.5 2.5 0 0 0 4.5 16h9a2.5 2.5 0 0 0 2.5-2.5Zm0-9A2.5 2.5 0 0 0 13.5 2h-9A2.5 2.5 0 0 0 2 4.5V5h14v-.5ZM5 17c.46.6 1.18 1 2 1h6.5a4.5 4.5 0 0 0 4.5-4.5v-7c0-.82-.4-1.54-1-2v9a3.5 3.5 0 0 1-3.5 3.5H5Z"]));
export const CalendarMultipleRegular = ( /*#__PURE__*/createFluentIcon('CalendarMultipleRegular', "1em", ["M16 4.5A2.5 2.5 0 0 0 13.5 2h-9A2.5 2.5 0 0 0 2 4.5v9A2.5 2.5 0 0 0 4.5 16h9a2.5 2.5 0 0 0 2.5-2.5v-9ZM3 6h12v7.5c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 3 13.5V6Zm1.5-3h9c.83 0 1.5.67 1.5 1.5V5H3v-.5C3 3.67 3.67 3 4.5 3ZM5 17c.46.6 1.18 1 2 1h6.5a4.5 4.5 0 0 0 4.5-4.5v-7c0-.82-.4-1.54-1-2v9a3.5 3.5 0 0 1-3.5 3.5H5Z"]));
export const CalendarNoteFilled = ( /*#__PURE__*/createFluentIcon('CalendarNoteFilled', "1em", ["M17 7v3h-5.5A2.5 2.5 0 0 0 9 12.5V17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9ZM10 12.5c0-.83.67-1.5 1.5-1.5h6c.83 0 1.5.67 1.5 1.5v5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5v-5Zm7 4a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0 0 1h4a.5.5 0 0 0 .5-.5ZM12.5 13a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const CalendarNoteRegular = ( /*#__PURE__*/createFluentIcon('CalendarNoteRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5V10h-1V7H4v7.5c0 .83.67 1.5 1.5 1.5H9v1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5ZM10 12.5c0-.83.67-1.5 1.5-1.5h6c.83 0 1.5.67 1.5 1.5v5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5v-5Zm7 4a.5.5 0 0 0-.5-.5h-4a.5.5 0 0 0 0 1h4a.5.5 0 0 0 .5-.5ZM12.5 13a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4Z"]));
export const CalendarPatternFilled = ( /*#__PURE__*/createFluentIcon('CalendarPatternFilled', "1em", ["M5.75 3h8.5A2.75 2.75 0 0 1 17 5.75v8.5A2.75 2.75 0 0 1 14.25 17h-8.5A2.75 2.75 0 0 1 3 14.25v-8.5A2.75 2.75 0 0 1 5.75 3ZM4.5 5.75V7h11V5.75c0-.69-.56-1.25-1.25-1.25h-8.5c-.69 0-1.25.56-1.25 1.25ZM14.7 8l-4 4h2.6l2.2-2.2V8h-.8Zm-1.4 0h-2.6l-4 4h2.6l4-4Zm-8 4 4-4H6.7l-2.2 2.2V12h.8Zm-.8-3.2.8-.8h-.8v.8ZM14.7 12h.8v-.8l-.8.8Z"]));
export const CalendarPatternRegular = ( /*#__PURE__*/createFluentIcon('CalendarPatternRegular', "1em", ["M5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3ZM4 5.5V7h12V5.5c0-.83-.67-1.5-1.5-1.5h-9C4.67 4 4 4.67 4 5.5ZM14.7 8l-4 4h2.6L16 9.3V8h-1.3Zm-1.4 0h-2.6l-4 4h2.6l4-4Zm-8 4 4-4H6.7L4 10.7V12h1.3ZM4 9.3 5.3 8H4v1.3ZM14.7 12H16v-1.3L14.7 12Z"]));
export const CalendarPeopleColor = ( /*#__PURE__*/createFluentIcon('CalendarPeopleColor', "1em", `<path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_people_20_color__a)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_people_20_color__b)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_people_20_color__c)" fill-opacity=".3"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_people_20_color__d)" fill-opacity=".3"/><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_people_20_color__e)"/><path d="M16.75 18c1.65 0 2.25-.91 2.25-1.8 0-.66-.54-1.2-1.2-1.2h-2.1c-.66 0-1.2.54-1.2 1.2 0 .89.6 1.8 2.25 1.8Z" fill="url(#ic_fluent_calendar_people_20_color__f)"/><path d="M16.75 18c1.65 0 2.25-.91 2.25-1.8 0-.66-.54-1.2-1.2-1.2h-2.1c-.66 0-1.2.54-1.2 1.2 0 .89.6 1.8 2.25 1.8Z" fill="url(#ic_fluent_calendar_people_20_color__g)" fill-opacity=".5"/><path d="M13 19c2.2 0 3-1.22 3-2.4 0-.88-.72-1.6-1.6-1.6h-2.8c-.88 0-1.6.72-1.6 1.6 0 1.18.8 2.4 3 2.4Z" fill="url(#ic_fluent_calendar_people_20_color__h)"/><path d="M13 19c2.2 0 3-1.22 3-2.4 0-.88-.72-1.6-1.6-1.6h-2.8c-.88 0-1.6.72-1.6 1.6 0 1.18.8 2.4 3 2.4Z" fill="url(#ic_fluent_calendar_people_20_color__i)"/><path d="M13 19c2.2 0 3-1.22 3-2.4 0-.88-.72-1.6-1.6-1.6h-2.8c-.88 0-1.6.72-1.6 1.6 0 1.18.8 2.4 3 2.4Z" fill="#5750E2" fill-opacity=".2"/><path d="M18 12.75a1.25 1.25 0 1 1-2.5 0 1.25 1.25 0 0 1 2.5 0Z" fill="url(#ic_fluent_calendar_people_20_color__j)"/><path d="M14.75 12.25a1.75 1.75 0 1 1-3.5 0 1.75 1.75 0 0 1 3.5 0Z" fill="url(#ic_fluent_calendar_people_20_color__k)"/><path d="M14.75 12.25a1.75 1.75 0 1 1-3.5 0 1.75 1.75 0 0 1 3.5 0Z" fill="#5750E2" fill-opacity=".2"/><defs><linearGradient id="ic_fluent_calendar_people_20_color__a" x1="8" y1="6" x2="11.5" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#8CD0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_people_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_people_20_color__e" x1="3.56" y1="3" x2="4.9" y2="9.82" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_people_20_color__f" x1="15.57" y1="15.4" x2="16.78" y2="18.29" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient><linearGradient id="ic_fluent_calendar_people_20_color__h" x1="11.43" y1="15.53" x2="13.04" y2="19.39" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#BD96FF"/><stop offset="1" stop-color="#9C6CFE"/></linearGradient><linearGradient id="ic_fluent_calendar_people_20_color__i" x1="13" y1="14.52" x2="15.29" y2="20.95" gradientUnits="userSpaceOnUse"><stop stop-color="#885EDB" stop-opacity="0"/><stop offset="1" stop-color="#E362F8"/></linearGradient><linearGradient id="ic_fluent_calendar_people_20_color__j" x1="16.09" y1="11.83" x2="17.37" y2="13.87" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#9C6CFE"/><stop offset="1" stop-color="#7A41DC"/></linearGradient><linearGradient id="ic_fluent_calendar_people_20_color__k" x1="12.08" y1="10.97" x2="13.87" y2="13.81" gradientUnits="userSpaceOnUse"><stop offset=".13" stop-color="#BD96FF"/><stop offset="1" stop-color="#9C6CFE"/></linearGradient><radialGradient id="ic_fluent_calendar_people_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(4.5 0 0 3.01516 13 16.5)"><stop stop-color="#4A43CB"/><stop offset=".91" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_calendar_people_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(0 2.5 -2.5 0 13.5 13)"><stop stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_calendar_people_20_color__g" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-8.4 119.26 -86.55) scale(2.9936 3.52614)"><stop offset=".39" stop-color="#3B148A"/><stop offset="1" stop-color="#3B148A" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const CalendarPersonFilled = ( /*#__PURE__*/createFluentIcon('CalendarPersonFilled', "1em", ["M17 7v2.4a3 3 0 0 0-3.73 4.6 2.5 2.5 0 0 0-2.23 3H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm3 9a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const CalendarPersonRegular = ( /*#__PURE__*/createFluentIcon('CalendarPersonRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v3.9c-.3-.17-.64-.3-1-.36V7H4v7.5c0 .83.67 1.5 1.5 1.5h5.55a2.51 2.51 0 0 0-.01 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm3 8a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm1.5 4.5c0 1.25-1 2.5-3.5 2.5S12 17.75 12 16.5c0-.83.67-1.5 1.5-1.5h4c.83 0 1.5.67 1.5 1.5Z"]));
export const CalendarPhoneFilled = ( /*#__PURE__*/createFluentIcon('CalendarPhoneFilled', "1em", ["M17 7v1.05a2.51 2.51 0 0 0-.5-.05h-3a2.5 2.5 0 0 0-2.5 2.5v6c0 .17.02.34.05.5H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm-.75 6c-.97 0-1.75.78-1.75 1.75v5.5c0 .97.78 1.75 1.75 1.75h2.5c.97 0 1.75-.78 1.75-1.75v-5.5C18 9.78 17.22 9 16.25 9h-2.5Zm.25 6.5c0-.28.22-.5.5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Z"]));
export const CalendarPhoneRegular = ( /*#__PURE__*/createFluentIcon('CalendarPhoneRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v2.55a2.51 2.51 0 0 0-.5-.05H16V7H4v7.5c0 .83.67 1.5 1.5 1.5H11v.5c0 .17.02.34.05.5H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm-.75 5c-.97 0-1.75.78-1.75 1.75v5.5c0 .97.78 1.75 1.75 1.75h2.5c.97 0 1.75-.78 1.75-1.75v-5.5C18 9.78 17.22 9 16.25 9h-2.5Zm.25 6.5c0-.28.22-.5.5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5Z"]));
export const CalendarPlayFilled = ( /*#__PURE__*/createFluentIcon('CalendarPlayFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm0 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.74-6.55c.1 0 .18.03.26.08l2.3 1.51c.07.05.12.1.16.18a.54.54 0 0 1-.03.54.46.46 0 0 1-.13.13l-2.3 1.57a.54.54 0 0 1-.12.06.45.45 0 0 1-.32-.02.57.57 0 0 1-.16-.1.5.5 0 0 1-.14-.36v-3.08a.51.51 0 0 1 .3-.46.44.44 0 0 1 .18-.05Z"]));
export const CalendarPlayRegular = ( /*#__PURE__*/createFluentIcon('CalendarPlayRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm0 15a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.74-6.55c.1 0 .18.03.26.08l2.3 1.51c.07.05.12.1.16.18a.54.54 0 0 1-.03.54.46.46 0 0 1-.13.13l-2.3 1.57a.54.54 0 0 1-.12.06.45.45 0 0 1-.32-.02.57.57 0 0 1-.16-.1.5.5 0 0 1-.14-.36v-3.08a.51.51 0 0 1 .3-.46.44.44 0 0 1 .18-.05Z"]));
export const CalendarQuestionMarkFilled = ( /*#__PURE__*/createFluentIcon('CalendarQuestionMarkFilled', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5Zm0 4.1V7H3v7.5A2.5 2.5 0 0 0 5.5 17h4.1A5.5 5.5 0 0 1 17 9.6ZM14.5 19a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.62-2a.62.62 0 1 1 1.24 0 .62.62 0 0 1-1.24 0Zm-1.23-3.54c-.01-1.14.8-1.96 1.85-1.96 1.03 0 1.85.85 1.85 1.95 0 .59-.21.91-.72 1.32l-.28.22c-.25.19-.33.3-.35.44v.16a.5.5 0 0 1-1-.09c0-.57.21-.88.72-1.29l.27-.21c.3-.23.36-.35.36-.55 0-.55-.38-.95-.85-.95-.5 0-.86.37-.85.95a.5.5 0 1 1-1 0Z"]));
export const CalendarQuestionMarkRegular = ( /*#__PURE__*/createFluentIcon('CalendarQuestionMarkRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm0 15a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.62-2a.62.62 0 1 1 1.24 0 .62.62 0 0 1-1.24 0Zm-1.23-3.54c-.01-1.14.8-1.96 1.85-1.96 1.03 0 1.85.85 1.85 1.95 0 .59-.21.91-.72 1.32l-.28.22c-.25.19-.33.3-.35.44v.16a.5.5 0 0 1-1-.09c0-.57.21-.88.72-1.29l.27-.21c.3-.23.36-.35.36-.55 0-.55-.38-.95-.85-.95-.5 0-.86.37-.85.95a.5.5 0 1 1-1 0Z"]));
export const CalendarRecordFilled = ( /*#__PURE__*/createFluentIcon('CalendarRecordFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm0 8a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7Zm0 8a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm2.5-4.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"], { flipInRtl: true }));
export const CalendarRecordRegular = ( /*#__PURE__*/createFluentIcon('CalendarRecordRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm0 7a3.5 3.5 0 1 1 0 7 3.5 3.5 0 0 1 0-7Zm0 8a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm2.5-4.5a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0Z"], { flipInRtl: true }));
export const CalendarReplyFilled = ( /*#__PURE__*/createFluentIcon('CalendarReplyFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm0 16a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const CalendarReplyRegular = ( /*#__PURE__*/createFluentIcon('CalendarReplyRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm0 15a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm-.9-6.4-.9.9h1.55A2.75 2.75 0 0 1 17 16.25v.25a.5.5 0 0 1-1 0v-.25c0-.97-.78-1.75-1.75-1.75h-1.54l.9.9a.5.5 0 0 1-.71.7l-1.76-1.75a.5.5 0 0 1 0-.7l1.76-1.75a.5.5 0 0 1 .7.7Z"]));
export const CalendarRtlFilled = ( /*#__PURE__*/createFluentIcon('CalendarRtlFilled', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9ZM3 7h14v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V7Zm9 3a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm1 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-4-4a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm1 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm-4-4a1 1 0 1 0 2 0 1 1 0 0 0-2 0Z"]));
export const CalendarRtlRegular = ( /*#__PURE__*/createFluentIcon('CalendarRtlRegular', "1em", ["M13 11a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-1 2a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm-2-2a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm-1 2a1 1 0 1 0 2 0 1 1 0 0 0-2 0Zm-2-2a1 1 0 1 1 0-2 1 1 0 0 1 0 2ZM3 5.5A2.5 2.5 0 0 1 5.5 3h9A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9ZM16 7H4v7.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5V7Zm-1.5-3h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Z"]));
export const CalendarSearchFilled = ( /*#__PURE__*/createFluentIcon('CalendarSearchFilled', "1em", ["M17 14.5V7H3v2.47a4.5 4.5 0 0 1 6.06 5.97L10.62 17h3.88a2.5 2.5 0 0 0 2.5-2.5Zm0-9A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5ZM7.1 16.3a3.5 3.5 0 1 1 .7-.7l2.55 2.55a.5.5 0 0 1-.7.7L7.1 16.3Zm.4-2.8a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"]));
export const CalendarSearchRegular = ( /*#__PURE__*/createFluentIcon('CalendarSearchRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v3.76c.32-.12.65-.2 1-.23V7h12v7.5c0 .83-.67 1.5-1.5 1.5H9.12l1 1h4.38a2.5 2.5 0 0 0 2.5-2.5v-9ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Zm1.1 12.3a3.5 3.5 0 1 1 .7-.7l2.55 2.55a.5.5 0 0 1-.7.7L6.6 16.3Zm.4-2.8a2.5 2.5 0 1 0-5 0 2.5 2.5 0 0 0 5 0Z"]));
export const CalendarSettingsFilled = ( /*#__PURE__*/createFluentIcon('CalendarSettingsFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9Zm-2.43 8.44a2 2 0 0 1-1.43 2.48l-.47.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const CalendarSettingsRegular = ( /*#__PURE__*/createFluentIcon('CalendarSettingsRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5Zm-2.43 7.44a2 2 0 0 1-1.43 2.48l-.47.12a4.7 4.7 0 0 0 .01 1.01l.35.09A2 2 0 0 1 12 17.66l-.13.42c.26.2.54.38.84.52l.32-.35a2 2 0 0 1 2.91 0l.34.36c.3-.13.57-.3.82-.5l-.15-.55a2 2 0 0 1 1.43-2.48l.46-.12a4.73 4.73 0 0 0-.01-1.01l-.35-.09A2 2 0 0 1 17 11.34l.13-.42c-.26-.2-.54-.38-.84-.52l-.32.35a2 2 0 0 1-2.91 0l-.34-.36c-.3.13-.57.3-.82.5l.16.55Zm2.43 4.06a1 1 0 1 1 0-2 1 1 0 0 1 0 2Z"]));
export const CalendarShieldFilled = ( /*#__PURE__*/createFluentIcon('CalendarShieldFilled', "1em", ["M17 7v1.61c-.2-.04-.41-.1-.61-.18-.46-.2-.92-.52-1.38-1A1.39 1.39 0 0 0 14 7H17ZM3 7h11c-.36 0-.73.14-1 .43a3.5 3.5 0 0 1-2.6 1.24c-.81 0-1.4.67-1.4 1.41v2.8A6.49 6.49 0 0 0 10.53 17H5.5A2.5 2.5 0 0 1 3 14.5V7Zm11.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9ZM16 9.35a4.06 4.06 0 0 0 1.6.32c.2 0 .35.14.4.33v2.58c0 2.69-1.31 4.51-3.87 5.4a.39.39 0 0 1-.26 0A6.66 6.66 0 0 1 12 17c-.39-.3-.72-.63-.99-1a5.5 5.5 0 0 1-1-3.15l-.01-.27v-2.5a.4.4 0 0 1 .4-.41 4.5 4.5 0 0 0 3.32-1.55.39.39 0 0 1 .56 0c.54.57 1.11.97 1.72 1.23Z"]));
export const CalendarShieldRegular = ( /*#__PURE__*/createFluentIcon('CalendarShieldRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h5.03a5.81 5.81 0 0 1-.7-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v1.23c.33.2.66.32 1 .38V5.5A2.5 2.5 0 0 0 14.5 3h-9Zm0 1h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4ZM17 9.62a4.06 4.06 0 0 1-1-.27 5.16 5.16 0 0 1-1.72-1.23.39.39 0 0 0-.56 0 4.5 4.5 0 0 1-3.32 1.55.4.4 0 0 0-.4.41v2.77A5.5 5.5 0 0 0 11.01 16c.27.37.6.7.99 1 .52.4 1.15.73 1.87.98.09.03.17.03.26 0 2.56-.89 3.87-2.71 3.87-5.4V10a.4.4 0 0 0-.4-.33c-.2 0-.4-.02-.6-.05Z"]));
export const CalendarSparkleFilled = ( /*#__PURE__*/createFluentIcon('CalendarSparkleFilled', "1em", ["m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02Zm-3.02 3.56c.21.15.47.23.74.23.17 0 .34-.02.5-.08v2.58a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5V7h9.14l.01.05c.1.25.25.48.52.7.14.1.3.16.45.2a1.3 1.3 0 0 0 .77 1.79l.77.25c.08.03.16.08.22.14.07.06.1.14.14.22l.26.8c.1.25.26.46.48.62ZM11.8 6l-.02-.04a1.27 1.27 0 0 0-.29-.47 1.3 1.3 0 0 0-.47-.3l-1.06-.34A1.41 1.41 0 0 1 9 3.5c0-.18.03-.34.09-.5H5.5A2.5 2.5 0 0 0 3 5.5V6h8.8Z"], { flipInRtl: true }));
export const CalendarSparkleRegular = ( /*#__PURE__*/createFluentIcon('CalendarSparkleRegular', "1em", ["m13.88.28.35 1.07a2.2 2.2 0 0 0 1.4 1.4l1.07.35h.02a.42.42 0 0 1 0 .8l-1.07.35a2.2 2.2 0 0 0-1.4 1.4l-.35 1.07a.42.42 0 0 1-.8 0l-.35-1.07a2.23 2.23 0 0 0-1.4-1.4l-1.07-.35a.42.42 0 0 1 0-.8l1.07-.35a2.2 2.2 0 0 0 1.38-1.4l.35-1.07a.42.42 0 0 1 .8 0Zm4.9 7.93-.76-.25a1.58 1.58 0 0 1-1-1l-.25-.76a.3.3 0 0 0-.57 0l-.25.77a1.58 1.58 0 0 1-.98 1l-.77.24a.3.3 0 0 0 0 .57l.77.25a1.58 1.58 0 0 1 1 1l.24.77a.3.3 0 0 0 .58 0l.24-.77a1.58 1.58 0 0 1 1-1l.77-.24a.3.3 0 0 0 0-.57h-.02ZM16 11.91c.16.06.33.09.5.09.17 0 .34-.02.5-.08v2.58a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h3.59a1.42 1.42 0 0 0 0 1H5.5C4.67 4 4 4.67 4 5.5V6h7.8l.34 1H4v7.5c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-2.6Z"], { flipInRtl: true }));
export const CalendarStarFilled = ( /*#__PURE__*/createFluentIcon('CalendarStarFilled', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5Zm0 4.1V7H3v7.5A2.5 2.5 0 0 0 5.5 17h4.1A5.5 5.5 0 0 1 17 9.6Zm2 4.9a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.02-2.64a.5.5 0 0 0-.96 0l-.47 1.53H12c-.48 0-.69.65-.3.95l1.26.94-.48 1.53c-.15.49.38.89.77.59l1.25-.95 1.25.95c.4.3.92-.1.77-.59l-.48-1.53 1.25-.94c.4-.3.2-.95-.3-.95h-1.54l-.47-1.53Z"]));
export const CalendarStarRegular = ( /*#__PURE__*/createFluentIcon('CalendarStarRegular', "1em", ["M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h4.1c-.16-.32-.3-.65-.4-1H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.2c.35.1.68.24 1 .4V5.5ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.02-2.64a.5.5 0 0 0-.96 0l-.47 1.53H12c-.48 0-.69.65-.3.95l1.26.94-.48 1.53c-.15.49.38.89.77.59l1.25-.95 1.25.95c.4.3.92-.1.77-.59l-.48-1.53 1.25-.94c.4-.3.2-.95-.3-.95h-1.54l-.47-1.53Z"]));
export const CalendarSyncColor = ( /*#__PURE__*/createFluentIcon('CalendarSyncColor', "1em", `<path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_sync_20_color__a)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_sync_20_color__b)"/><path d="M17 6H3v8.5A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5V6Z" fill="url(#ic_fluent_calendar_sync_20_color__c)" fill-opacity=".3"/><path d="M17 5.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V7h14V5.5Z" fill="url(#ic_fluent_calendar_sync_20_color__d)"/><path d="M19 14.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Z" fill="url(#ic_fluent_calendar_sync_20_color__e)"/><path d="M16.5 11.5c.28 0 .5.22.5.5v1.5a.5.5 0 0 1-.5.5H15a.5.5 0 0 1 0-1h.47a1.97 1.97 0 0 0-.94-.25 2 2 0 0 0-1.44.59.5.5 0 0 1-.71-.71 3 3 0 0 1 3.62-.48V12c0-.28.22-.5.5-.5Zm-.88 5.53a3 3 0 0 1-2.62-.18V17a.5.5 0 0 1-1 0v-1.5c0-.28.22-.5.5-.5H14a.5.5 0 0 1 0 1h-.47a1.97 1.97 0 0 0 .94.25 2 2 0 0 0 1.44-.59.5.5 0 0 1 .71.71 3 3 0 0 1-1 .66Z" fill="url(#ic_fluent_calendar_sync_20_color__f)"/><defs><linearGradient id="ic_fluent_calendar_sync_20_color__a" x1="8" y1="6" x2="11.5" y2="17" gradientUnits="userSpaceOnUse"><stop stop-color="#B3E0FF"/><stop offset="1" stop-color="#8CD0FF"/></linearGradient><linearGradient id="ic_fluent_calendar_sync_20_color__b" x1="11.5" y1="10.5" x2="13.5" y2="19.5" gradientUnits="userSpaceOnUse"><stop stop-color="#DCF8FF" stop-opacity="0"/><stop offset="1" stop-color="#FF6CE8" stop-opacity=".7"/></linearGradient><linearGradient id="ic_fluent_calendar_sync_20_color__d" x1="3.56" y1="3" x2="4.9" y2="9.82" gradientUnits="userSpaceOnUse"><stop stop-color="#0094F0"/><stop offset="1" stop-color="#2764E7"/></linearGradient><linearGradient id="ic_fluent_calendar_sync_20_color__e" x1="10.32" y1="11.69" x2="16.53" y2="18.14" gradientUnits="userSpaceOnUse"><stop stop-color="#52D17C"/><stop offset="1" stop-color="#22918B"/></linearGradient><linearGradient id="ic_fluent_calendar_sync_20_color__f" x1="12" y1="11" x2="16.14" y2="17.24" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#E3FFD9"/></linearGradient><radialGradient id="ic_fluent_calendar_sync_20_color__c" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(90 -.5 15) scale(6.5)"><stop offset=".54" stop-color="#4A43CB"/><stop offset="1" stop-color="#4A43CB" stop-opacity="0"/></radialGradient></defs>`, { color: true }));
export const CalendarSyncFilled = ( /*#__PURE__*/createFluentIcon('CalendarSyncFilled', "1em", ["M17 7v2.6A5.5 5.5 0 0 0 9.6 17H5.5A2.5 2.5 0 0 1 3 14.5V7h14Zm-2.5-4A2.5 2.5 0 0 1 17 5.5V6H3v-.5A2.5 2.5 0 0 1 5.5 3h9ZM10 14.5a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm6.5-3c.28 0 .5.22.5.5v1.5a.5.5 0 0 1-.5.5H15a.5.5 0 0 1 0-1h.47a1.97 1.97 0 0 0-.94-.25 2 2 0 0 0-1.44.59.5.5 0 0 1-.71-.71 3 3 0 0 1 3.62-.48V12c0-.28.22-.5.5-.5Zm-.88 5.53a3 3 0 0 1-2.62-.18V17a.5.5 0 0 1-1 0v-1.5c0-.28.22-.5.5-.5H14a.5.5 0 0 1 0 1h-.47a1.97 1.97 0 0 0 .94.25 2 2 0 0 0 1.44-.59.5.5 0 0 1 .71.71 3 3 0 0 1-1 .66Z"]));
export const CalendarSyncRegular = ( /*#__PURE__*/createFluentIcon('CalendarSyncRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v4.1c-.32-.16-.65-.3-1-.4V7H4v7.5c0 .83.67 1.5 1.5 1.5h3.7c.1.35.24.68.4 1H5.5A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5ZM10 14.5a4.5 4.5 0 1 0 9 0 4.5 4.5 0 0 0-9 0Zm6.5-3c.28 0 .5.22.5.5v1.5a.5.5 0 0 1-.5.5H15a.5.5 0 0 1 0-1h.47a1.97 1.97 0 0 0-.94-.25 2 2 0 0 0-1.44.59.5.5 0 0 1-.71-.71 3 3 0 0 1 3.62-.48V12c0-.28.22-.5.5-.5Zm-.88 5.53a3 3 0 0 1-2.62-.18V17a.5.5 0 0 1-1 0v-1.5c0-.28.22-.5.5-.5H14a.5.5 0 0 1 0 1h-.47a1.97 1.97 0 0 0 .94.25 2 2 0 0 0 1.44-.59.5.5 0 0 1 .71.71 3 3 0 0 1-1 .66Z"]));
export const CalendarTemplateFilled = ( /*#__PURE__*/createFluentIcon('CalendarTemplateFilled', "1em", ["M5 2a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h2.04a3.53 3.53 0 0 1-.04-.5v-5c0-.98.4-1.86 1.05-2.5H5.5a.5.5 0 0 1 0-1h10c.17 0 .34.01.5.04V5a3 3 0 0 0-3-3H5Zm0 3.5c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5Zm3 5A2.5 2.5 0 0 1 10.5 8h5a2.5 2.5 0 0 1 2.5 2.5v.5H8v-.5Zm0 5V12h10v3.5a2.5 2.5 0 0 1-2.5 2.5h-5A2.5 2.5 0 0 1 8 15.5Z"]));
export const CalendarTemplateRegular = ( /*#__PURE__*/createFluentIcon('CalendarTemplateRegular', "1em", ["M2 5a3 3 0 0 1 3-3h8a3 3 0 0 1 3 3v2.04a3.53 3.53 0 0 0-.5-.04H15V5a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v8c0 1.1.9 2 2 2h2v.5c0 .17.01.34.04.5H5a3 3 0 0 1-3-3V5Zm3.5 2h5c-.95 0-1.82.38-2.45 1H5.5a.5.5 0 0 1 0-1ZM5 5.5c0-.28.22-.5.5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5ZM10.5 8A2.5 2.5 0 0 0 8 10.5v5a2.5 2.5 0 0 0 2.5 2.5h5a2.5 2.5 0 0 0 2.5-2.5v-5A2.5 2.5 0 0 0 15.5 8h-5ZM9 10.5c0-.83.67-1.5 1.5-1.5h5c.83 0 1.5.67 1.5 1.5v.5H9v-.5Zm0 5V12h8v3.5c0 .83-.67 1.5-1.5 1.5h-5A1.5 1.5 0 0 1 9 15.5Z"]));
export const CalendarTodayFilled = ( /*#__PURE__*/createFluentIcon('CalendarTodayFilled', "1em", ["M10 10a1 1 0 1 0 0-2 1 1 0 0 0 0 2Zm7 4.5V7H3v7.5A2.5 2.5 0 0 0 5.5 17h3v-1.75a1.5 1.5 0 0 1-.98-2.64h.01l1.5-1.25a1.5 1.5 0 0 1 1.94 0l1.5 1.25a1.5 1.5 0 0 1-.97 2.64V17h3a2.5 2.5 0 0 0 2.5-2.5ZM12 9a2 2 0 1 1-4 0 2 2 0 0 1 4 0Zm5-3.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5V6h14v-.5Zm-5.82 8.63a.5.5 0 0 0 .64-.76l-1.5-1.25a.5.5 0 0 0-.64 0l-1.5 1.25a.5.5 0 1 0 .64.76l.68-.56v3.93a.5.5 0 1 0 1 0v-3.93l.68.56Z"]));
export const CalendarTodayRegular = ( /*#__PURE__*/createFluentIcon('CalendarTodayRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-3v-1h3c.83 0 1.5-.67 1.5-1.5V7H4v7.5c0 .83.67 1.5 1.5 1.5h3v1h-3A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5V6h12v-.5c0-.83-.67-1.5-1.5-1.5ZM11 9a1 1 0 1 1-2 0 1 1 0 0 1 2 0Zm.88 5.07a.5.5 0 0 1-.7.06l-.68-.56v3.93a.5.5 0 1 1-1 0v-3.93l-.68.56a.5.5 0 0 1-.64-.76l1.5-1.25a.5.5 0 0 1 .64 0l1.5 1.25c.21.17.24.49.06.7Z"]));
export const CalendarToolboxFilled = ( /*#__PURE__*/createFluentIcon('CalendarToolboxFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5V6h14v-.5A2.5 2.5 0 0 0 14.5 3h-9ZM17 7H3v7.5A2.5 2.5 0 0 0 5.5 17H9v-3.5a2.5 2.5 0 0 1 2.04-2.46A2.5 2.5 0 0 1 13.5 9h2c.56 0 1.08.19 1.5.5V7Zm-5 5v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 4.5h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 0 0 1 0V16h3v.5a.5.5 0 0 0 1 0V16Z"]));
export const CalendarToolboxRegular = ( /*#__PURE__*/createFluentIcon('CalendarToolboxRegular', "1em", ["M9 16H5.5A1.5 1.5 0 0 1 4 14.5V7h12v2.05c.37.07.7.23 1 .45v-4A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17H9v-1ZM5.5 4h9c.83 0 1.5.67 1.5 1.5V6H4v-.5C4 4.67 4.67 4 5.5 4Zm6.5 8v-.5c0-.83.67-1.5 1.5-1.5h2c.83 0 1.5.67 1.5 1.5v.5h.5c.83 0 1.5.67 1.5 1.5V15h-2v-.5a.5.5 0 0 0-1 0v.5h-3v-.5a.5.5 0 0 0-1 0v.5h-2v-1.5c0-.83.67-1.5 1.5-1.5h.5Zm1-.5v.5h3v-.5a.5.5 0 0 0-.5-.5h-2a.5.5 0 0 0-.5.5Zm4 4.5h2v1.5c0 .83-.67 1.5-1.5 1.5h-6a1.5 1.5 0 0 1-1.5-1.5V16h2v.5a.5.5 0 0 0 1 0V16h3v.5a.5.5 0 0 0 1 0V16Z"]));
export const CalendarVideoFilled = ( /*#__PURE__*/createFluentIcon('CalendarVideoFilled', "1em", ["M2 4.5A2.5 2.5 0 0 1 4.5 2h7A2.5 2.5 0 0 1 14 4.5V5H2v-.5ZM2 6h12v2H8.5A3.5 3.5 0 0 0 5 11.5V14h-.5A2.5 2.5 0 0 1 2 11.5V6Zm4 5.5A2.5 2.5 0 0 1 8.5 9h5a2.5 2.5 0 0 1 2.5 2.5v.13l2.04-1.4c.82-.58 1.96.01 1.96 1.02v5.5c0 1-1.14 1.6-1.96 1.03L16 16.38v.12a2.5 2.5 0 0 1-2.5 2.5h-5A2.5 2.5 0 0 1 6 16.5v-5Z"], { flipInRtl: true }));
export const CalendarVideoRegular = ( /*#__PURE__*/createFluentIcon('CalendarVideoRegular', "1em", ["M4.5 2A2.5 2.5 0 0 0 2 4.5v7A2.5 2.5 0 0 0 4.5 14H5v-1h-.5A1.5 1.5 0 0 1 3 11.5V6h10v2h1V4.5A2.5 2.5 0 0 0 11.5 2h-7Zm7 1c.83 0 1.5.67 1.5 1.5V5H3v-.5C3 3.67 3.67 3 4.5 3h7ZM6 11.5A2.5 2.5 0 0 1 8.5 9h5a2.5 2.5 0 0 1 2.5 2.5v.13l2.04-1.4c.82-.58 1.96.01 1.96 1.02v5.5c0 1-1.14 1.6-1.96 1.03L16 16.38v.12a2.5 2.5 0 0 1-2.5 2.5h-5A2.5 2.5 0 0 1 6 16.5v-5Zm12.6-.45-2.6 1.8v2.3l2.6 1.8c.17.12.4 0 .4-.2v-5.5c0-.2-.23-.32-.4-.2ZM8.5 10c-.83 0-1.5.67-1.5 1.5v5c0 .83.67 1.5 1.5 1.5h5c.83 0 1.5-.67 1.5-1.5v-5c0-.83-.67-1.5-1.5-1.5h-5Z"], { flipInRtl: true }));
export const CalendarWeekNumbersFilled = ( /*#__PURE__*/createFluentIcon('CalendarWeekNumbersFilled', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9ZM7 6.5v1a.5.5 0 0 1-1 0v-1a.5.5 0 0 1 1 0ZM6.5 9c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm.5 3.5v1a.5.5 0 0 1-1 0v-1a.5.5 0 0 1 1 0Z"]));
export const CalendarWeekNumbersRegular = ( /*#__PURE__*/createFluentIcon('CalendarWeekNumbersRegular', "1em", ["M5.5 3A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 14.5 3h-9ZM4 5.5C4 4.67 4.67 4 5.5 4h9c.83 0 1.5.67 1.5 1.5v9c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 4 14.5v-9Zm3 1a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0v-1ZM6.5 9c.28 0 .5.22.5.5v1a.5.5 0 0 1-1 0v-1c0-.28.22-.5.5-.5Zm.5 3.5a.5.5 0 0 0-1 0v1a.5.5 0 0 0 1 0v-1Z"]));
export const CalendarWeekStartFilled = ( /*#__PURE__*/createFluentIcon('CalendarWeekStartFilled', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm-8 3a.5.5 0 0 0-.5.41v7.18a.5.5 0 0 0 1 0V6.41A.5.5 0 0 0 6.5 6Z"]));
export const CalendarWeekStartRegular = ( /*#__PURE__*/createFluentIcon('CalendarWeekStartRegular', "1em", ["M14.5 3A2.5 2.5 0 0 1 17 5.5v9a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 3 14.5v-9A2.5 2.5 0 0 1 5.5 3h9Zm0 1h-9C4.67 4 4 4.67 4 5.5v9c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-9c0-.83-.67-1.5-1.5-1.5Zm-8 2a.5.5 0 0 1 .5.41v7.09a.5.5 0 0 1-1 .09V6.5c0-.28.22-.5.5-.5Z"]));
export const CalendarWorkWeekFilled = ( /*#__PURE__*/createFluentIcon('CalendarWorkWeekFilled', "1em", ["M7 9V7h6v2H7Zm10-3.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9ZM6.5 6h7c.28 0 .5.22.5.5v3a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-3c0-.28.22-.5.5-.5Z"]));
export const CalendarWorkWeekRegular = ( /*#__PURE__*/createFluentIcon('CalendarWorkWeekRegular', "1em", ["M6.5 6a.5.5 0 0 0-.5.5v3c0 .28.22.5.5.5h7a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-7ZM7 9V7h6v2H7Zm10-3.5A2.5 2.5 0 0 0 14.5 3h-9A2.5 2.5 0 0 0 3 5.5v9A2.5 2.5 0 0 0 5.5 17h9a2.5 2.5 0 0 0 2.5-2.5v-9ZM5.5 4h9c.83 0 1.5.67 1.5 1.5v9c0 .83-.67 1.5-1.5 1.5h-9A1.5 1.5 0 0 1 4 14.5v-9C4 4.67 4.67 4 5.5 4Z"]));
export const CallFilled = ( /*#__PURE__*/createFluentIcon('CallFilled', "1em", ["M6.99 2.07A2 2 0 0 1 9.3 3l.08.15.66 1.47a2.5 2.5 0 0 1-.44 2.72l-.13.13-1.05.98c-.19.17-.04.86.64 2.04.6 1.06 1.1 1.56 1.35 1.58h.1l2.05-.64a1.5 1.5 0 0 1 1.56.45l.1.11 1.35 1.88a2 2 0 0 1-.13 2.5l-.12.12-.54.52a3.5 3.5 0 0 1-3.72.7c-1.93-.78-3.69-2.56-5.29-5.33S3.52 7.2 3.82 5.14a3.5 3.5 0 0 1 2.26-2.8l.19-.06.72-.21Z"]));
export const CallRegular = ( /*#__PURE__*/createFluentIcon('CallRegular', "1em", ["m6.99 2.07-.72.21a3.5 3.5 0 0 0-2.45 2.86c-.3 2.06.36 4.48 1.96 7.25 1.6 2.77 3.36 4.55 5.3 5.33a3.5 3.5 0 0 0 3.7-.7l.55-.52a2 2 0 0 0 .25-2.62L14.22 12a1.5 1.5 0 0 0-1.65-.56l-2.05.63-.06.01c-.22.04-.74-.45-1.4-1.58-.67-1.18-.82-1.87-.63-2.04l1.05-.98a2.5 2.5 0 0 0 .57-2.85l-.66-1.47a2 2 0 0 0-2.4-1.1Zm1.49 1.5.66 1.47a1.5 1.5 0 0 1-.35 1.71l-1.04.98c-.67.63-.45 1.71.45 3.27.85 1.47 1.62 2.19 2.45 2.06l.12-.02 2.09-.64a.5.5 0 0 1 .55.19l1.36 1.88a1 1 0 0 1-.13 1.3l-.54.52a2.5 2.5 0 0 1-2.65.5c-1.7-.68-3.3-2.3-4.8-4.9-1.5-2.59-2.1-4.8-1.84-6.61a2.5 2.5 0 0 1 1.75-2.04l.72-.22a1 1 0 0 1 1.2.55Z"]));
export const CallAddFilled = ( /*#__PURE__*/createFluentIcon('CallAddFilled', "1em", ["M3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.9 1.57a2.5 2.5 0 0 1-.84 3.36l-.79.5c-.32.2-.44.52-.37.77.27.9.86 1.9 1.52 2.58.19.2.54.25.9.05l.43-.26a2.5 2.5 0 0 1 3.44.94l.8 1.44c.27.47.31 1.03.12 1.53a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5ZM15 2.5a.5.5 0 0 0-1 0V5h-2.5a.5.5 0 0 0 0 1H14v2.5a.5.5 0 0 0 1 0V6h2.5a.5.5 0 0 0 0-1H15V2.5Z"]));
export const CallAddRegular = ( /*#__PURE__*/createFluentIcon('CallAddRegular', "1em", ["M3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.97 1.7a2.5 2.5 0 0 1-.67 3.24l-.6.45c-.28.22-.4.52-.34.77.18.82.59 1.57 1.15 2.13.17.16.47.22.8.1l.66-.26a2.5 2.5 0 0 1 3.07 1.11l.95 1.7c.27.48.31 1.04.12 1.54a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5Zm.49.87c-.59.33-.98.89-1 1.66-.04 1.61.33 3.85 1.9 6.53a15.3 15.3 0 0 0 4.62 5.15 1.9 1.9 0 0 0 1.91.16 2.91 2.91 0 0 0 1.45-1.65.84.84 0 0 0-.06-.7l-.95-1.7a1.5 1.5 0 0 0-1.85-.68l-.66.26c-.58.22-1.33.2-1.85-.32A5.32 5.32 0 0 1 6.13 9.4c-.17-.72.2-1.4.71-1.78l.6-.46c.6-.45.78-1.29.4-1.94l-.97-1.7a.93.93 0 0 0-.58-.43 3.1 3.1 0 0 0-2.25.22ZM15 2.5a.5.5 0 0 0-1 0V5h-2.5a.5.5 0 0 0 0 1H14v2.5a.5.5 0 0 0 1 0V6h2.5a.5.5 0 0 0 0-1H15V2.5Z"]));
export const CallCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('CallCheckmarkFilled', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.8-1.44a2.5 2.5 0 0 0-3.44-.94l-.44.26c-.35.2-.7.15-.9-.05a6.83 6.83 0 0 1-1.5-2.58c-.08-.25.04-.56.36-.77l.8-.5a2.5 2.5 0 0 0 .82-3.36l-.9-1.56c-.25-.46-.69-.79-1.2-.91Zm11.31.03c.2.2.2.5 0 .7l-5 5a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .7-.7l1.65 1.64 4.65-4.64c.2-.2.5-.2.7 0Z"]));
export const CallCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('CallCheckmarkRegular', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.25c-.32.13-.62.07-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.25.06-.55.34-.77l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Zm-3.5 2.85c.02-.77.41-1.33 1-1.66a3.1 3.1 0 0 1 2.25-.22c.24.06.45.22.58.43l.97 1.7c.38.65.2 1.49-.4 1.94l-.6.46c-.52.39-.88 1.06-.71 1.78.22.99.7 1.92 1.42 2.62.52.51 1.27.54 1.85.32l.66-.26a1.5 1.5 0 0 1 1.85.67l.95 1.7c.12.22.14.47.06.7a2.91 2.91 0 0 1-1.45 1.66 1.9 1.9 0 0 1-1.9-.16 15.3 15.3 0 0 1-4.64-5.15 12.28 12.28 0 0 1-1.89-6.53Zm14.81-2.82c.2.2.2.5 0 .7l-5 5a.5.5 0 0 1-.7 0l-2-2a.5.5 0 0 1 .7-.7l1.65 1.64 4.65-4.64c.2-.2.5-.2.7 0Z"]));
export const CallConnectingFilled = ( /*#__PURE__*/createFluentIcon('CallConnectingFilled', "1em", ["M3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.9 1.57a2.5 2.5 0 0 1-.84 3.36l-.79.5c-.32.2-.44.52-.37.77.27.9.86 1.9 1.52 2.58.19.2.54.25.9.05l.43-.26a2.5 2.5 0 0 1 3.44.94l.8 1.44c.27.47.31 1.03.12 1.53a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5Zm9.2-.38a.5.5 0 1 0-.5.88l.4.21a8.5 8.5 0 0 1 4.32 6.58l.03.32a.5.5 0 1 0 1-.1l-.03-.32a9.5 9.5 0 0 0-4.84-7.35l-.39-.22Zm-1.18 2.68a.5.5 0 0 1 .69-.17l.12.07a6.5 6.5 0 0 1 3.07 4.51l.04.27a.5.5 0 1 1-.98.16l-.05-.27a5.5 5.5 0 0 0-2.6-3.8l-.12-.08a.5.5 0 0 1-.17-.69Z"]));
export const CallConnectingRegular = ( /*#__PURE__*/createFluentIcon('CallConnectingRegular', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.25c-.32.13-.62.07-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.25.06-.55.34-.77l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Zm-3.5 2.85c.02-.77.41-1.33 1-1.66a3.1 3.1 0 0 1 2.25-.22c.24.06.45.22.58.43l.97 1.7c.38.65.2 1.49-.4 1.94l-.6.46c-.52.39-.88 1.06-.71 1.78.22.99.7 1.92 1.42 2.62.52.51 1.27.54 1.85.32l.66-.26a1.5 1.5 0 0 1 1.85.67l.95 1.7c.12.22.14.47.06.7a2.91 2.91 0 0 1-1.45 1.66 1.9 1.9 0 0 1-1.9-.16 15.3 15.3 0 0 1-4.64-5.15 12.28 12.28 0 0 1-1.89-6.53Zm9.7-2.9a.5.5 0 1 0-.48.87l.38.21a8.5 8.5 0 0 1 4.33 6.58l.03.32a.5.5 0 1 0 1-.1l-.03-.32a9.5 9.5 0 0 0-4.84-7.35l-.39-.22Zm-1.17 2.67a.5.5 0 0 1 .69-.17l.12.08a6.5 6.5 0 0 1 3.07 4.5l.04.27a.5.5 0 1 1-.98.16l-.05-.27a5.5 5.5 0 0 0-2.6-3.8l-.12-.08a.5.5 0 0 1-.17-.69Z"]));
export const CallDismissFilled = ( /*#__PURE__*/createFluentIcon('CallDismissFilled', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.8-1.44a2.5 2.5 0 0 0-3.44-.94l-.44.26c-.35.2-.7.15-.9-.05a6.83 6.83 0 0 1-1.5-2.58c-.08-.25.04-.56.36-.77l.8-.5a2.5 2.5 0 0 0 .82-3.36l-.9-1.56c-.25-.46-.69-.79-1.2-.91Zm11.31.03c.2.2.2.5 0 .7L15.21 5.5l2.64 2.65a.5.5 0 0 1-.7.7L14.5 6.21l-2.65 2.64a.5.5 0 0 1-.7-.7l2.64-2.65-2.64-2.65a.5.5 0 0 1 .7-.7l2.65 2.64 2.65-2.64c.2-.2.5-.2.7 0Z"]));
export const CallDismissRegular = ( /*#__PURE__*/createFluentIcon('CallDismissRegular', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.25c-.32.13-.62.07-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.25.06-.55.34-.77l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Zm-3.5 2.85c.02-.77.41-1.33 1-1.66a3.1 3.1 0 0 1 2.25-.22c.24.06.45.22.58.43l.97 1.7c.38.65.2 1.49-.4 1.94l-.6.46c-.52.39-.88 1.06-.71 1.78.22.99.7 1.92 1.42 2.62.52.51 1.27.54 1.85.32l.66-.26a1.5 1.5 0 0 1 1.85.67l.95 1.7c.12.22.14.47.06.7a2.91 2.91 0 0 1-1.45 1.66 1.9 1.9 0 0 1-1.9-.16 15.3 15.3 0 0 1-4.64-5.15 12.28 12.28 0 0 1-1.89-6.53Zm14.81-2.82c.2.2.2.5 0 .7L15.21 5.5l2.64 2.65a.5.5 0 0 1-.7.7L14.5 6.21l-2.65 2.64a.5.5 0 0 1-.7-.7l2.64-2.65-2.64-2.65a.5.5 0 0 1 .7-.7l2.65 2.64 2.65-2.64c.2-.2.5-.2.7 0Z"]));
export const CallEndFilled = ( /*#__PURE__*/createFluentIcon('CallEndFilled', "1em", ["m17.96 10.94-.16.83c-.15.78-.87 1.3-1.7 1.22l-1.63-.16c-.72-.07-1.25-.59-1.47-1.33-.3-1-.5-1.75-.5-1.75a6.63 6.63 0 0 0-5 0s-.2.75-.5 1.75c-.2.67-.5 1.26-1.2 1.33l-1.63.16c-.81.08-1.6-.43-1.82-1.2l-.25-.84c-.25-.82-.03-1.7.58-2.28C4.1 7.3 6.67 6.51 9.99 6.5c3.33 0 5.6.78 7.16 2.16.66.58.97 1.46.8 2.28Z"]));
export const CallEndRegular = ( /*#__PURE__*/createFluentIcon('CallEndRegular', "1em", ["M10 6c3.33 0 5.59 1.28 7.15 2.66.66.58.97 1.46.8 2.28l-.15.83c-.15.78-.87 1.3-1.7 1.22l-1.63-.16c-.72-.07-1.25-.59-1.47-1.33-.3-1-.5-1.75-.5-1.75a6.63 6.63 0 0 0-5 0s-.2.75-.5 1.75c-.2.67-.5 1.26-1.2 1.33l-1.63.16c-.81.08-1.6-.43-1.82-1.2l-.25-.84c-.25-.82-.03-1.7.58-2.28C4.1 7.3 6.68 6 10 6Zm3.48 3.53.02.1a46.1 46.1 0 0 0 .46 1.58c.13.45.39.6.6.62l1.64.16c.35.04.57-.17.62-.4l.16-.84c.09-.46-.08-.98-.49-1.34A9.37 9.37 0 0 0 10 7C6.93 7 4.6 8.2 3.37 9.39c-.33.32-.46.8-.31 1.28l.24.83c.1.3.43.53.77.5l1.63-.17.05-.01.05-.05c.07-.09.15-.26.24-.55a115.65 115.65 0 0 0 .46-1.6l.03-.1c.1-.37.45-.62.62-.7a7.62 7.62 0 0 1 5.73 0c.15.07.48.29.59.68v.03Z"]));
export const CallExclamationFilled = ( /*#__PURE__*/createFluentIcon('CallExclamationFilled', "1em", ["m17.8 7.77.16-.83c.16-.82-.15-1.7-.8-2.28-1.57-1.38-3.84-2.16-7.17-2.16-3.32 0-5.89.79-7.31 2.17-.6.59-.83 1.46-.58 2.28l.25.83A1.74 1.74 0 0 0 4.17 9l1.63-.16c.7-.07 1-.66 1.2-1.33.3-1 .5-1.75.5-1.75a6.63 6.63 0 0 1 5 0s.2.75.5 1.75c.22.74.75 1.26 1.47 1.33l1.63.16c.83.08 1.55-.44 1.7-1.22Zm-3.3 5.73a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM10 11a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.24Z"]));
export const CallExclamationRegular = ( /*#__PURE__*/createFluentIcon('CallExclamationRegular', "1em", ["M10 2c3.33 0 5.59 1.28 7.15 2.66.66.58.97 1.46.8 2.28l-.15.83c-.15.78-.87 1.3-1.7 1.22l-1.63-.16c-.72-.07-1.25-.59-1.47-1.33-.3-1-.5-1.75-.5-1.75a6.63 6.63 0 0 0-5 0S7.3 6.5 7 7.5c-.2.67-.5 1.26-1.2 1.33l-1.63.16c-.81.08-1.6-.43-1.82-1.2l-.25-.84c-.25-.82-.03-1.7.58-2.28C4.1 3.3 6.68 2 10 2Zm3.48 3.53.02.1a46.1 46.1 0 0 0 .46 1.58c.13.45.39.6.6.62L16.2 8c.35.04.57-.17.62-.4l.16-.84c.09-.46-.08-.98-.49-1.34A9.37 9.37 0 0 0 10 3C6.93 3 4.6 4.2 3.37 5.39c-.33.32-.46.8-.31 1.28l.24.83c.1.3.43.53.77.5l1.63-.17.05-.01.05-.05c.07-.09.15-.26.24-.55a115.6 115.6 0 0 0 .46-1.6l.03-.1c.1-.37.45-.62.62-.7a7.62 7.62 0 0 1 5.73 0c.15.07.48.29.59.68v.03Zm1.02 7.97a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM10 11a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.24Z"]));
export const CallForwardFilled = ( /*#__PURE__*/createFluentIcon('CallForwardFilled', "1em", ["m9.29 2.2-.85-.16a2.53 2.53 0 0 0-2.32.81C4.7 4.42 4 6.87 4 10.2c0 3.32.72 5.7 2.13 7.12.6.6 1.5.83 2.34.58l.84-.25c.8-.23 1.33-1 1.24-1.82l-.17-1.63a1.53 1.53 0 0 0-1.26-1.36l-1.8-.32a6.36 6.36 0 0 1-.16-4.98l1.93-.5c.7-.19 1.21-.8 1.28-1.5l.17-1.65a1.54 1.54 0 0 0-1.25-1.7Zm5.06 3.45a.5.5 0 0 0-.7.7L16.29 9H10.5a.5.5 0 0 0 0 1h5.8l-2.65 2.65a.5.5 0 0 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5Z"]));
export const CallForwardRegular = ( /*#__PURE__*/createFluentIcon('CallForwardRegular', "1em", ["m8.93 2.08-.18-.04c-1-.17-2.02.18-2.71.94C4.67 4.5 4 6.85 4 10c0 3.15.67 5.5 2.03 7.01a2.97 2.97 0 0 0 2.9.9l.65-.15a2.2 2.2 0 0 0 1.67-2.36L11.1 14a2.2 2.2 0 0 0-1.69-1.92l-1.4-.32-.03-.02-.04-.07a1.63 1.63 0 0 1-.1-.24c-.09-.32-.14-.8-.14-1.43 0-.85.1-1.42.25-1.68a.2.2 0 0 1 .13-.09l1.33-.3A2.2 2.2 0 0 0 11.11 6l.14-1.4a2.2 2.2 0 0 0-1.68-2.37l-.64-.15ZM5.19 10c0-2.88.59-4.95 1.73-6.21.4-.45 1-.66 1.6-.57l.13.03.65.15a1 1 0 0 1 .76 1.08l-.14 1.4a1 1 0 0 1-.76.87l-1.34.31a1.4 1.4 0 0 0-.88.64c-.3.49-.42 1.25-.42 2.3 0 1.6.29 2.58 1.08 2.88l.11.03 1.45.34a1 1 0 0 1 .76.87l.14 1.4a1 1 0 0 1-.75 1.07l-.65.16c-.64.15-1.3-.05-1.74-.54-1.14-1.27-1.73-3.33-1.73-6.2Zm9.16-4.35a.5.5 0 0 0-.7.7L16.29 9H10.5a.5.5 0 0 0 0 1h5.8l-2.65 2.65a.5.5 0 0 0 .7.7l3.5-3.5a.5.5 0 0 0 0-.7l-3.5-3.5Z"]));
export const CallInboundFilled = ( /*#__PURE__*/createFluentIcon('CallInboundFilled', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.8-1.44a2.5 2.5 0 0 0-3.44-.94l-.44.26c-.35.2-.7.15-.9-.05a6.83 6.83 0 0 1-1.5-2.58c-.08-.25.04-.56.36-.77l.8-.5a2.5 2.5 0 0 0 .82-3.36l-.9-1.56c-.25-.46-.69-.79-1.2-.91Zm11.31.03c.2.2.2.5 0 .7L12.71 8h3.79a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5v-5a.5.5 0 1 1 1 0v3.8l5.15-5.15c.2-.2.5-.2.7 0Z"]));
export const CallInboundRegular = ( /*#__PURE__*/createFluentIcon('CallInboundRegular', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.25c-.32.13-.62.07-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.25.06-.55.34-.77l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Zm-3.5 2.85c.02-.77.41-1.33 1-1.66a3.1 3.1 0 0 1 2.25-.22c.24.06.45.22.58.43l.97 1.7c.38.65.2 1.49-.4 1.94l-.6.46c-.52.39-.88 1.06-.71 1.78.22.99.7 1.92 1.42 2.62.52.51 1.27.54 1.85.32l.66-.26a1.5 1.5 0 0 1 1.85.67l.95 1.7c.12.22.14.47.06.7a2.91 2.91 0 0 1-1.45 1.66 1.9 1.9 0 0 1-1.9-.16 15.3 15.3 0 0 1-4.64-5.15 12.28 12.28 0 0 1-1.89-6.53Zm14.81-2.12a.5.5 0 1 0-.7-.7L12 7.29V3.5a.5.5 0 0 0-1 0v5c0 .29.22.5.5.5h5a.5.5 0 0 0 0-1h-3.8l5.15-5.14Z"]));
export const CallMissedFilled = ( /*#__PURE__*/createFluentIcon('CallMissedFilled', "1em", ["m17.8 7.77.16-.83c.16-.82-.15-1.7-.8-2.28-1.57-1.38-3.84-2.16-7.17-2.16-3.32 0-5.89.79-7.31 2.17-.6.59-.83 1.46-.58 2.28l.25.83A1.74 1.74 0 0 0 4.17 9l1.63-.16c.7-.07 1-.66 1.2-1.33.3-1 .5-1.75.5-1.75a6.63 6.63 0 0 1 5 0s.2.75.5 1.75c.22.74.75 1.26 1.47 1.33l1.63.16c.83.08 1.55-.44 1.7-1.22ZM9.5 11.5c.28 0 .5.22.5.5v1.5h1a.5.5 0 1 1 0 1H9.5A.5.5 0 0 1 9 14v-2c0-.28.22-.5.5-.5Zm-4 2a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM10 10a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Z"]));
export const CallMissedRegular = ( /*#__PURE__*/createFluentIcon('CallMissedRegular', "1em", ["M10 2c3.33 0 5.59 1.28 7.15 2.66.66.58.97 1.46.8 2.28l-.15.83c-.15.78-.87 1.3-1.7 1.22l-1.63-.16c-.72-.07-1.25-.59-1.47-1.33-.3-1-.5-1.75-.5-1.75a6.63 6.63 0 0 0-5 0S7.3 6.5 7 7.5c-.2.67-.5 1.26-1.2 1.33l-1.63.16c-.81.08-1.6-.43-1.82-1.2l-.25-.84c-.25-.82-.03-1.7.58-2.28C4.1 3.3 6.68 2 10 2Zm3.48 3.53.02.1a46.1 46.1 0 0 0 .46 1.58c.13.45.39.6.6.62L16.2 8c.35.04.57-.17.62-.4l.16-.84c.09-.46-.08-.98-.49-1.34A9.37 9.37 0 0 0 10 3C6.93 3 4.6 4.2 3.37 5.39c-.33.32-.46.8-.31 1.28l.24.83c.1.3.43.53.77.5l1.63-.17.05-.01.05-.05c.07-.09.15-.26.24-.55a115.6 115.6 0 0 0 .46-1.6l.03-.1c.1-.37.45-.62.62-.7a7.62 7.62 0 0 1 5.73 0c.15.07.48.29.59.68v.03ZM10 12a.5.5 0 0 0-1 0v2c0 .28.22.5.5.5H11a.5.5 0 1 0 0-1h-1V12Zm-4.5 1.5a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM10 10a3.5 3.5 0 1 0 0 7 3.5 3.5 0 0 0 0-7Z"]));
export const CallOutboundFilled = ( /*#__PURE__*/createFluentIcon('CallOutboundFilled', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.8-1.44a2.5 2.5 0 0 0-3.44-.94l-.44.26c-.35.2-.7.15-.9-.05a6.83 6.83 0 0 1-1.5-2.58c-.08-.25.04-.56.36-.77l.8-.5a2.5 2.5 0 0 0 .82-3.36l-.9-1.56c-.25-.46-.69-.79-1.2-.91Zm4.6 6.73a.5.5 0 0 1 0-.7L16.3 3H12.5a.5.5 0 1 1 0-1h5c.28 0 .5.22.5.5v5a.5.5 0 0 1-1 0V3.7l-5.15 5.15a.5.5 0 0 1-.7 0Z"]));
export const CallOutboundRegular = ( /*#__PURE__*/createFluentIcon('CallOutboundRegular', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.25c-.32.13-.62.07-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.25.06-.55.34-.77l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Zm-3.5 2.85c.02-.77.41-1.33 1-1.66a3.1 3.1 0 0 1 2.25-.22c.24.06.45.22.58.43l.97 1.7c.38.65.2 1.49-.4 1.94l-.6.46c-.52.39-.88 1.06-.71 1.78.22.99.7 1.92 1.42 2.62.52.51 1.27.54 1.85.32l.66-.26a1.5 1.5 0 0 1 1.85.67l.95 1.7c.12.22.14.47.06.7a2.91 2.91 0 0 1-1.45 1.66 1.9 1.9 0 0 1-1.9-.16 15.3 15.3 0 0 1-4.64-5.15 12.28 12.28 0 0 1-1.89-6.53Zm8.1 3.18a.5.5 0 1 0 .71.7L17 3.71V7.5a.5.5 0 1 0 1 0v-5a.5.5 0 0 0-.5-.5h-5a.5.5 0 1 0 0 1h3.8l-5.15 5.15Z"]));
export const CallParkFilled = ( /*#__PURE__*/createFluentIcon('CallParkFilled', "1em", ["M3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.9 1.57a2.5 2.5 0 0 1-.84 3.36l-.79.5c-.32.2-.44.52-.37.77.27.9.86 1.9 1.52 2.58.19.2.54.25.9.05l.43-.26a2.5 2.5 0 0 1 3.44.94l.8 1.44c.27.47.31 1.03.12 1.53a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5ZM12.5 2a.5.5 0 0 0-.5.5v7a.5.5 0 1 0 1 0V7h1.5a2.5 2.5 0 0 0 0-5h-2Zm2 4H13V3h1.5a1.5 1.5 0 0 1 0 3Z"]));
export const CallParkRegular = ( /*#__PURE__*/createFluentIcon('CallParkRegular', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.25c-.32.13-.62.07-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.25.06-.55.34-.77l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Zm-3.5 2.85c.02-.77.41-1.33 1-1.66a3.1 3.1 0 0 1 2.25-.22c.24.06.45.22.58.43l.97 1.7c.38.65.2 1.49-.4 1.94l-.6.46c-.52.39-.88 1.06-.71 1.78.22.99.7 1.92 1.42 2.62.52.51 1.27.54 1.85.32l.66-.26a1.5 1.5 0 0 1 1.85.67l.95 1.7c.12.22.14.47.06.7a2.91 2.91 0 0 1-1.45 1.66 1.9 1.9 0 0 1-1.9-.16 15.3 15.3 0 0 1-4.64-5.15 12.28 12.28 0 0 1-1.89-6.53ZM12.5 2a.5.5 0 0 0-.5.5v7a.5.5 0 1 0 1 0V7h1.5a2.5 2.5 0 0 0 0-5h-2Zm2 4H13V3h1.5a1.5 1.5 0 0 1 0 3Z"]));
export const CallPauseFilled = ( /*#__PURE__*/createFluentIcon('CallPauseFilled', "1em", ["M3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.9 1.57a2.5 2.5 0 0 1-.84 3.36l-.79.5c-.32.2-.44.52-.37.77.27.9.86 1.9 1.52 2.58.19.2.54.25.9.05l.43-.26a2.5 2.5 0 0 1 3.44.94l.8 1.44c.27.47.31 1.03.12 1.53a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5ZM13 2.5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0v-6Zm3 0a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0v-6Z"]));
export const CallPauseRegular = ( /*#__PURE__*/createFluentIcon('CallPauseRegular', "1em", ["M3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.97 1.7a2.5 2.5 0 0 1-.67 3.24l-.6.45c-.28.22-.4.52-.34.77.18.82.59 1.57 1.15 2.13.17.16.47.22.8.1l.66-.26a2.5 2.5 0 0 1 3.07 1.11l.95 1.7c.27.48.31 1.04.12 1.54a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5Zm.49.87c-.59.33-.98.89-1 1.66-.04 1.61.33 3.85 1.9 6.53a15.3 15.3 0 0 0 4.62 5.15 1.9 1.9 0 0 0 1.91.16 2.91 2.91 0 0 0 1.45-1.65.84.84 0 0 0-.06-.7l-.95-1.7a1.5 1.5 0 0 0-1.85-.68l-.66.26c-.58.22-1.33.2-1.85-.32A5.32 5.32 0 0 1 6.13 9.4c-.17-.72.2-1.4.71-1.78l.6-.46c.6-.45.78-1.29.4-1.94l-.97-1.7a.93.93 0 0 0-.58-.43 3.1 3.1 0 0 0-2.25.22ZM13 2.5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0v-6Zm3 0a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0v-6Z"]));
export const CallProhibitedFilled = ( /*#__PURE__*/createFluentIcon('CallProhibitedFilled', "1em", ["m17.96 6.94-.16.83c-.15.78-.87 1.3-1.7 1.22l-1.63-.16c-.72-.07-1.25-.59-1.47-1.33-.3-1-.5-1.75-.5-1.75a6.63 6.63 0 0 0-5 0S7.3 6.5 7 7.5c-.2.67-.5 1.26-1.2 1.33l-1.63.16c-.81.08-1.6-.43-1.82-1.2l-.25-.84c-.25-.82-.03-1.7.58-2.28C4.1 3.3 6.67 2.51 9.99 2.5c3.33 0 5.6.78 7.16 2.16.66.58.97 1.46.8 2.28ZM6.82 16.68a4.5 4.5 0 1 0 6.36-6.36 4.5 4.5 0 0 0-6.36 6.36Zm5.65-.7a3.5 3.5 0 0 1-4.57.32l4.9-4.9a3.5 3.5 0 0 1-.33 4.57Zm-.37-5.28-4.9 4.9a3.5 3.5 0 0 1 4.9-4.9Z"]));
export const CallProhibitedRegular = ( /*#__PURE__*/createFluentIcon('CallProhibitedRegular', "1em", ["M17.15 4.66A10.37 10.37 0 0 0 10 2C6.67 2 4.1 3.29 2.68 4.67c-.6.59-.83 1.46-.58 2.28l.25.83A1.74 1.74 0 0 0 4.17 9l1.63-.16c.7-.07 1-.66 1.2-1.33.3-1 .5-1.75.5-1.75a6.63 6.63 0 0 1 5 0s.2.75.5 1.75c.22.74.75 1.26 1.47 1.33l1.63.16c.83.08 1.55-.44 1.7-1.22l.16-.83c.16-.82-.15-1.7-.8-2.28Zm-3.65.96-.02-.1-.01-.02c-.1-.4-.44-.61-.6-.68a7.62 7.62 0 0 0-5.73-.01c-.16.09-.51.34-.61.7l-.03.1a90.96 90.96 0 0 1-.46 1.6c-.09.3-.17.47-.24.56a.2.2 0 0 1-.05.05l-.05.01L4.07 8a.74.74 0 0 1-.77-.5l-.24-.83c-.15-.48-.02-.96.31-1.28A9.62 9.62 0 0 1 10 3a9.37 9.37 0 0 1 6.5 2.4c.4.37.57.89.48 1.35l-.16.83c-.05.24-.27.45-.62.41l-1.64-.16c-.21-.02-.47-.17-.6-.62a59.02 59.02 0 0 1-.46-1.59ZM6.82 16.68a4.5 4.5 0 1 0 6.36-6.36 4.5 4.5 0 0 0-6.36 6.36Zm5.65-.7a3.5 3.5 0 0 1-4.57.32l4.9-4.9a3.5 3.5 0 0 1-.33 4.57Zm-.37-5.28-4.9 4.9a3.5 3.5 0 0 1 4.9-4.9Z"]));
export const CallRectangleLandscapeFilled = ( /*#__PURE__*/createFluentIcon('CallRectangleLandscapeFilled', "1em", ["M5 4a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3H5Zm1.6 4.21A7.8 7.8 0 0 1 10 7.5c1.3 0 2.5.26 3.4.71.87.44 1.6 1.13 1.6 2.04v.74a1.5 1.5 0 0 1-1.65 1.5l-.71-.07a1.5 1.5 0 0 1-1.3-1.1l-.29-1.06-.02-.08v-.02c-.07-.04-.32-.16-1.03-.16-.7 0-.96.12-1.03.16v.02l-.02.08-.29 1.05a1.5 1.5 0 0 1-1.3 1.1l-.71.08A1.5 1.5 0 0 1 5 10.99v-.74c0-.91.73-1.6 1.6-2.04Z"]));
export const CallRectangleLandscapeRegular = ( /*#__PURE__*/createFluentIcon('CallRectangleLandscapeRegular', "1em", ["M5 4a3 3 0 0 0-3 3v6a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3H5ZM3 7c0-1.1.9-2 2-2h10a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V7Zm3.6 1.21A7.8 7.8 0 0 1 10 7.5c1.3 0 2.5.26 3.4.71.87.44 1.6 1.13 1.6 2.04v.74a1.5 1.5 0 0 1-1.65 1.5l-.71-.07a1.5 1.5 0 0 1-1.3-1.1l-.29-1.06-.02-.08v-.02c-.07-.04-.32-.16-1.03-.16-.7 0-.96.12-1.03.16v.02l-.02.08-.29 1.05a1.5 1.5 0 0 1-1.3 1.1l-.71.08A1.5 1.5 0 0 1 5 10.99v-.74c0-.91.73-1.6 1.6-2.04Z"]));
export const CallSquareFilled = ( /*#__PURE__*/createFluentIcon('CallSquareFilled', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6Zm.6 5.21A7.8 7.8 0 0 1 10 7.5c1.3 0 2.5.26 3.4.71.87.44 1.6 1.13 1.6 2.04v.74a1.5 1.5 0 0 1-1.65 1.5l-.71-.07a1.5 1.5 0 0 1-1.3-1.1l-.29-1.06-.02-.08v-.02c-.07-.04-.32-.16-1.03-.16-.7 0-.96.12-1.03.16v.02l-.02.08-.29 1.05a1.5 1.5 0 0 1-1.3 1.1l-.71.08A1.5 1.5 0 0 1 5 10.99v-.74c0-.91.73-1.6 1.6-2.04Z"]));
export const CallSquareRegular = ( /*#__PURE__*/createFluentIcon('CallSquareRegular', "1em", ["M6 3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3H6ZM4 6c0-1.1.9-2 2-2h8a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6Zm2.6 2.21A7.8 7.8 0 0 1 10 7.5c1.3 0 2.5.26 3.4.71.87.44 1.6 1.13 1.6 2.04v.74a1.5 1.5 0 0 1-1.65 1.5l-.71-.07a1.5 1.5 0 0 1-1.3-1.1l-.29-1.06-.02-.08v-.02c-.07-.04-.32-.16-1.03-.16-.7 0-.96.12-1.03.16v.02l-.02.08-.29 1.05a1.5 1.5 0 0 1-1.3 1.1l-.71.08A1.5 1.5 0 0 1 5 10.99v-.74c0-.91.73-1.6 1.6-2.04Z"]));
export const CallTransferFilled = ( /*#__PURE__*/createFluentIcon('CallTransferFilled', "1em", ["M3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.97 1.7a2.5 2.5 0 0 1-.67 3.24l-.6.45c-.28.22-.4.52-.34.77.18.82.59 1.57 1.15 2.13.17.16.47.22.8.1l.66-.26a2.5 2.5 0 0 1 3.07 1.11l.95 1.7c.27.48.31 1.04.12 1.54a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5ZM12 8.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm.5-.5a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1ZM14 6.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm3 1a.5.5 0 0 0 1 0v-5a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h3.8l-2.15 2.15a.5.5 0 0 0 .7.7L17 3.71V7.5Z"]));
export const CallTransferRegular = ( /*#__PURE__*/createFluentIcon('CallTransferRegular', "1em", ["M6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.25c-.32.13-.62.07-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.25.06-.55.34-.77l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Zm-3.5 2.85c.02-.77.41-1.33 1-1.66a3.1 3.1 0 0 1 2.25-.22c.24.06.45.22.58.43l.97 1.7c.38.65.2 1.49-.4 1.94l-.6.46c-.52.39-.88 1.06-.71 1.78.22.99.7 1.92 1.42 2.62.52.51 1.27.54 1.85.32l.66-.26a1.5 1.5 0 0 1 1.85.67l.95 1.7c.12.22.14.47.06.7a2.91 2.91 0 0 1-1.45 1.66 1.9 1.9 0 0 1-1.9-.16 15.3 15.3 0 0 1-4.64-5.15 12.28 12.28 0 0 1-1.89-6.53ZM12 8.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm1-1a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0Zm1-1a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0ZM17.5 8a.5.5 0 0 1-.5-.5V3.7l-2.15 2.15a.5.5 0 1 1-.7-.7L16.29 3H12.5a.5.5 0 1 1 0-1h5c.28 0 .5.22.5.5v5a.5.5 0 0 1-.5.5Z"]));
export const CallWarningFilled = ( /*#__PURE__*/createFluentIcon('CallWarningFilled', "1em", ["m12.6 1.55-3.5 7A1 1 0 0 0 10 10h7a1 1 0 0 0 .9-1.45l-3.5-7a1 1 0 0 0-1.8 0ZM14 3.5v3a.5.5 0 1 1-1 0v-3a.5.5 0 1 1 1 0ZM13.5 9a.5.5 0 1 1 0-1 .5.5 0 0 1 0 1ZM6.54 2.12a4.1 4.1 0 0 0-2.99.32 2.87 2.87 0 0 0-1.5 2.5c-.06 1.8.36 4.22 2.02 7.06A16.28 16.28 0 0 0 9 17.48c.94.63 1.99.65 2.88.24a3.9 3.9 0 0 0 1.96-2.22c.2-.5.15-1.06-.12-1.53l-.95-1.7a2.5 2.5 0 0 0-3.07-1.12l-.67.26c-.32.12-.62.06-.79-.1A4.32 4.32 0 0 1 7.1 9.19c-.06-.26.06-.56.34-.78l.6-.45a2.5 2.5 0 0 0 .67-3.24l-.97-1.7c-.26-.45-.7-.78-1.2-.9Z"]));
export const CallWarningRegular = ( /*#__PURE__*/createFluentIcon('CallWarningRegular', "1em", ["m12.6 1.55-3.5 7A1 1 0 0 0 10 10h7a1 1 0 0 0 .9-1.45l-3.5-7a1 1 0 0 0-1.8 0ZM14 3.5v3a.5.5 0 1 1-1 0v-3a.5.5 0 1 1 1 0ZM13.5 9a.5.5 0 1 1 0-1 .5.5 0 0 1 0 1ZM3.55 2.44a4.1 4.1 0 0 1 2.99-.32c.5.12.94.45 1.2.9l.97 1.7a2.5 2.5 0 0 1-.67 3.24l-.6.45c-.28.22-.4.52-.34.78.18.8.59 1.56 1.15 2.12.17.16.47.22.8.1l.66-.26a2.5 2.5 0 0 1 3.07 1.11l.95 1.7c.27.48.31 1.04.12 1.54a3.9 3.9 0 0 1-1.96 2.22c-.9.41-1.94.4-2.88-.24-1.5-1-3.3-2.68-4.94-5.48a13.27 13.27 0 0 1-2.03-7.06 2.87 2.87 0 0 1 1.51-2.5Zm.49.88c-.59.32-.98.88-1 1.65-.04 1.61.33 3.85 1.9 6.53a15.3 15.3 0 0 0 4.62 5.15 1.9 1.9 0 0 0 1.91.16 2.91 2.91 0 0 0 1.45-1.65.84.84 0 0 0-.06-.7l-.95-1.7a1.5 1.5 0 0 0-1.85-.68l-.66.26c-.58.22-1.33.2-1.85-.32a5.32 5.32 0 0 1-1.42-2.61c-.17-.73.2-1.4.71-1.8l.6-.45c.6-.45.78-1.29.4-1.94l-.97-1.7a.93.93 0 0 0-.58-.43 3.1 3.1 0 0 0-2.25.23Z"]));
export const CalligraphyPenFilled = ( /*#__PURE__*/createFluentIcon('CalligraphyPenFilled', "1em", ["M6 2.5a.5.5 0 0 0-1 0v2C5 5.33 5.67 6 6.5 6h.2L5.24 9.08a2.5 2.5 0 0 0 .1 2.33l3.47 5.91c.16.27.4.48.69.59v-7.04a1 1 0 1 1 1 0v7.03c.28-.11.52-.31.67-.58l3.47-5.9a2.5 2.5 0 0 0 .1-2.34L13.28 6h.22c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 0-1 0v2a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-2Z"]));
export const CalligraphyPenRegular = ( /*#__PURE__*/createFluentIcon('CalligraphyPenRegular', "1em", ["M6 2.5a.5.5 0 0 0-1 0v2C5 5.33 5.67 6 6.5 6h.21L5.25 9.08a2.5 2.5 0 0 0 .1 2.33l3.47 5.91a1.37 1.37 0 0 0 2.36 0l3.47-5.9a2.5 2.5 0 0 0 .1-2.34L13.29 6h.21c.83 0 1.5-.67 1.5-1.5v-2a.5.5 0 0 0-1 0v2a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5v-2ZM12.18 6l1.67 3.5c.2.46.18.98-.07 1.4l-3.28 5.61v-5.64a1 1 0 1 0-1 0v5.64l-3.28-5.6a1.5 1.5 0 0 1-.07-1.4L7.82 6h4.36Z"]));
export const CalligraphyPenCheckmarkFilled = ( /*#__PURE__*/createFluentIcon('CalligraphyPenCheckmarkFilled', "1em", ["M19 5.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-2.15-1.85a.5.5 0 0 0-.7 0L13.5 6.29l-.65-.64a.5.5 0 0 0-.7.7l1 1c.2.2.5.2.7 0l3-3a.5.5 0 0 0 0-.7Z", "m14.5 11 .33-.01a2.5 2.5 0 0 1-.2.42l-3.46 5.91c-.15.27-.4.47-.67.58v-7.03a1 1 0 0 0 .46-1.16c.95.8 2.19 1.29 3.54 1.29Z", "M9 5.5c0 1.35.49 2.59 1.3 3.54a1 1 0 0 0-.8 1.83v7.04a1.37 1.37 0 0 1-.7-.59l-3.46-5.9a2.5 2.5 0 0 1-.1-2.34L6.7 6h-.2A1.5 1.5 0 0 1 5 4.5v-2a.5.5 0 0 1 1 0v2c0 .28.22.5.5.5h2.52L9 5.5Z"]));
export const CalligraphyPenCheckmarkRegular = ( /*#__PURE__*/createFluentIcon('CalligraphyPenCheckmarkRegular', "1em", ["M14.5 10a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9Zm2.35-5.65-3 3a.5.5 0 0 1-.7 0l-1-1a.5.5 0 0 1 .7-.7l.65.64 2.65-2.64a.5.5 0 0 1 .7.7Z", "M14.85 10.99a5.64 5.64 0 0 1-1.09-.04l-3.26 5.56v-5.64a1 1 0 1 0-1 0v5.64l-3.28-5.6a1.5 1.5 0 0 1-.07-1.4L7.82 6h1.2a5.57 5.57 0 0 1 0-1H6.5a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 0-1 0v2C5 5.33 5.67 6 6.5 6h.21L5.25 9.08a2.5 2.5 0 0 0 .1 2.33l3.47 5.91a1.37 1.37 0 0 0 2.36 0l3.47-5.9c.08-.14.14-.28.2-.43Z"]));
export const CalligraphyPenErrorFilled = ( /*#__PURE__*/createFluentIcon('CalligraphyPenErrorFilled', "1em", ["M19 5.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0ZM14.5 3a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5Zm0 5.13a.62.62 0 1 0 0-1.25.62.62 0 0 0 0 1.25Zm0 2.87.35-.01a2.5 2.5 0 0 1-.2.42l-3.47 5.91c-.15.27-.4.48-.68.59v-7.04a1 1 0 0 0 .46-1.16c.95.8 2.19 1.29 3.54 1.29ZM9 5.5c0 1.35.49 2.59 1.3 3.54a1 1 0 0 0-.8 1.83v7.04a1.37 1.37 0 0 1-.68-.59l-3.47-5.9a2.5 2.5 0 0 1-.1-2.34l1.23-2.6A1.75 1.75 0 0 1 5 4.75v-2a.75.75 0 0 1 1.5 0v2c0 .14.11.25.25.25h2.27L9 5.5Z"]));
export const CalligraphyPenErrorRegular = ( /*#__PURE__*/createFluentIcon('CalligraphyPenErrorRegular', "1em", ["M14.5 10a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9ZM14 3.5a.5.5 0 0 1 1 0v2a.5.5 0 0 1-1 0v-2Zm1.13 4a.62.62 0 1 1-1.25 0 .62.62 0 0 1 1.24 0Zm-.28 3.49a5.64 5.64 0 0 1-1.09-.04l-3.26 5.56v-5.64a1 1 0 1 0-1 0v5.64l-3.28-5.6a1.5 1.5 0 0 1-.07-1.4L7.82 6h1.2a5.57 5.57 0 0 1 0-1H6.5a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 0-1 0v2C5 5.33 5.67 6 6.5 6h.21L5.25 9.08a2.5 2.5 0 0 0 .1 2.33l3.47 5.91a1.37 1.37 0 0 0 2.36 0l3.47-5.9c.08-.14.14-.28.2-.43Z"]));
export const CalligraphyPenQuestionMarkFilled = ( /*#__PURE__*/createFluentIcon('CalligraphyPenQuestionMarkFilled', "1em", ["M14.5 1a4.5 4.5 0 1 1 0 9 4.5 4.5 0 0 1 0-9Zm.62 7a.62.62 0 1 0-1.24 0 .62.62 0 0 0 1.24 0Zm1.23-3.55c0-1.1-.82-1.95-1.85-1.95-1.05 0-1.86.82-1.85 1.96a.5.5 0 1 0 1-.01c0-.58.36-.95.85-.95.47 0 .85.4.85.95 0 .2-.07.32-.36.55l-.27.21c-.51.4-.72.72-.72 1.29a.5.5 0 0 0 1 .09v-.16c.02-.14.1-.25.35-.44l.28-.22c.5-.4.72-.73.72-1.32Z", "m14.5 11 .33-.01a2.5 2.5 0 0 1-.2.42l-3.46 5.91c-.15.27-.4.47-.67.58v-7.03a1 1 0 0 0 .46-1.16c.95.8 2.19 1.29 3.54 1.29Z", "M9 5.5c0 1.35.49 2.59 1.3 3.54a1 1 0 0 0-.8 1.83v7.04a1.37 1.37 0 0 1-.7-.59l-3.46-5.9a2.5 2.5 0 0 1-.1-2.34L6.7 6h-.2A1.5 1.5 0 0 1 5 4.5v-2a.5.5 0 0 1 1 0v2c0 .28.22.5.5.5h2.52L9 5.5Z"]));
export const CalligraphyPenQuestionMarkRegular = ( /*#__PURE__*/createFluentIcon('CalligraphyPenQuestionMarkRegular', "1em", ["M19 5.5a4.5 4.5 0 1 0-9 0 4.5 4.5 0 0 0 9 0Zm-4.5 1.88a.62.62 0 1 1 0 1.25.62.62 0 0 1 0-1.25Zm0-4.88c1.03 0 1.85.85 1.85 1.95 0 .59-.21.91-.72 1.32l-.28.22c-.25.19-.33.3-.35.44v.16a.5.5 0 0 1-1-.09c0-.57.21-.88.72-1.29l.27-.21c.3-.23.36-.35.36-.55 0-.55-.38-.95-.85-.95-.5 0-.86.37-.85.95a.5.5 0 1 1-1 0c-.01-1.13.8-1.95 1.85-1.95Z", "M14.85 10.99a5.64 5.64 0 0 1-1.09-.04l-3.26 5.56v-5.64a1 1 0 1 0-1 0v5.64l-3.28-5.6a1.5 1.5 0 0 1-.07-1.4L7.82 6h1.2a5.57 5.57 0 0 1 0-1H6.5a.5.5 0 0 1-.5-.5v-2a.5.5 0 0 0-1 0v2C5 5.33 5.67 6 6.5 6h.21L5.25 9.08a2.5 2.5 0 0 0 .1 2.33l3.47 5.91a1.37 1.37 0 0 0 2.36 0l3.47-5.9c.08-.14.14-.28.2-.43Z"]));
export const CameraColor = ( /*#__PURE__*/createFluentIcon('CameraColor', "1em", `<path d="M6.78 2.83c.25-.51.77-.83 1.34-.83h3.76c.57 0 1.1.32 1.35.83L13.8 4h1.69A2.5 2.5 0 0 1 18 6.5v8a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 14.5v-8A2.5 2.5 0 0 1 4.5 4h1.69l.59-1.17Z" fill="url(#ic_fluent_camera_20_color__a)"/><path d="M6.78 2.83c.25-.51.77-.83 1.34-.83h3.76c.57 0 1.1.32 1.35.83L13.8 4h1.69A2.5 2.5 0 0 1 18 6.5v8a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 14.5v-8A2.5 2.5 0 0 1 4.5 4h1.69l.59-1.17Z" fill="url(#ic_fluent_camera_20_color__b)" fill-opacity=".5"/><path d="M14 10a4 4 0 1 1-8 0 4 4 0 0 1 8 0Z" fill="url(#ic_fluent_camera_20_color__c)"/><path d="M13 10a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" fill="url(#ic_fluent_camera_20_color__d)"/><path d="M15 8a1 1 0 1 0 0-2 1 1 0 0 0 0 2Z" fill="url(#ic_fluent_camera_20_color__e)"/><defs><radialGradient id="ic_fluent_camera_20_color__a" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="rotate(40.73 -4.3 .83) scale(23.7539 49.3244)"><stop stop-color="#F08AF4"/><stop offset=".54" stop-color="#9C6CFE"/><stop offset="1" stop-color="#4E44DB"/></radialGradient><radialGradient id="ic_fluent_camera_20_color__b" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(.5 5.76923 -5.23393 .45361 12 11.23)"><stop stop-color="#312A9A"/><stop offset="1" stop-color="#312A9A" stop-opacity="0"/></radialGradient><radialGradient id="ic_fluent_camera_20_color__d" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="matrix(5.5 6.5 -6.5 5.5 6 5.5)"><stop offset=".24" stop-color="#3BD5FF"/><stop offset="1" stop-color="#2052CB"/></radialGradient><linearGradient id="ic_fluent_camera_20_color__c" x1="7.5" y1="6" x2="11.5" y2="15.5" gradientUnits="userSpaceOnUse"><stop stop-color="#fff"/><stop offset="1" stop-color="#DECBFF"/></linearGradient><linearGradient id="ic_fluent_camera_20_color__e" x1="14" y1="6.5" x2="16" y2="8" gradientUnits="userSpaceOnUse"><stop stop-color="#F08AF4"/><stop offset="1" stop-color="#F462AB"/></linearGradient></defs>`, { color: true }));
export const CameraFilled = ( /*#__PURE__*/createFluentIcon('CameraFilled', "1em", ["M7 10a3 3 0 1 1 6 0 3 3 0 0 1-6 0Zm-.22-7.17c.26-.51.78-.83 1.34-.83h3.77c.57 0 1.09.32 1.34.83L13.81 4h1.7A2.5 2.5 0 0 1 18 6.5v8a2.5 2.5 0 0 1-2.5 2.5h-11A2.5 2.5 0 0 1 2 14.5v-8A2.5 2.5 0 0 1 4.5 4h1.68l.6-1.17ZM10 6a4 4 0 1 0 0 8 4 4 0 0 0 0-8Z"]));
export const CameraRegular = ( /*#__PURE__*/createFluentIcon('CameraRegular', "1em", ["M10 6a4 4 0 1 0 0 8 4 4 0 0 0 0-8Zm-3 4a3 3 0 1 1 6 0 3 3 0 0 1-6 0Zm1.12-8a1.5 1.5 0 0 0-1.34.83L6.2 4H4.5A2.5 2.5 0 0 0 2 6.5v8A2.5 2.5 0 0 0 4.5 17h11a2.5 2.5 0 0 0 2.5-2.5v-8A2.5 2.5 0 0 0 15.5 4h-1.69l-.58-1.17A1.5 1.5 0 0 0 11.89 2H8.12Zm-.44 1.28A.5.5 0 0 1 8.12 3h3.77c.19 0 .36.1.45.28l.72 1.44a.5.5 0 0 0 .45.28h2c.82 0 1.5.67 1.5 1.5v8c0 .83-.68 1.5-1.5 1.5h-11A1.5 1.5 0 0 1 3 14.5v-8C3 5.67 3.67 5 4.5 5h2a.5.5 0 0 0 .44-.28l.73-1.44Z"]));
export const CameraAddFilled = ( /*#__PURE__*/createFluentIcon('CameraAddFilled', "1em", ["M6.78 2.83c.26-.51.78-.83 1.34-.83h3.77c.57 0 1.09.32 1.34.83L13.81 4h1.7A2.5 2.5 0 0 1 18 6.5v3.76a5.48 5.48 0 0 0-4.13-1.23 4 4 0 1 0-4.85 4.85A5.56 5.56 0 0 0 9.6 17H4.5A2.5 2.5 0 0 1 2 14.5v-8A2.5 2.5 0 0 1 4.5 4h1.7l.58-1.17ZM10 7a3 3 0 0 1 2.9 2.24 5.51 5.51 0 0 0-3.66 3.66A3 3 0 0 1 10 7Zm9 7.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 1 0 0 1H14v1.5a.5.5 0 1 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const CameraAddRegular = ( /*#__PURE__*/createFluentIcon('CameraAddRegular', "1em", ["M8.12 2a1.5 1.5 0 0 0-1.34.83L6.2 4H4.5A2.5 2.5 0 0 0 2 6.5v8A2.5 2.5 0 0 0 4.5 17h5.1c-.16-.32-.3-.65-.4-1H4.5A1.5 1.5 0 0 1 3 14.5v-8C3 5.67 3.68 5 4.5 5h2a.5.5 0 0 0 .45-.28l.73-1.44A.5.5 0 0 1 8.12 3h3.77c.19 0 .36.1.45.28l.72 1.44a.5.5 0 0 0 .45.28h2c.82 0 1.5.67 1.5 1.5v3.1c.35.19.69.4 1 .66V6.5A2.5 2.5 0 0 0 15.5 4h-1.7l-.58-1.17A1.5 1.5 0 0 0 11.89 2H8.12ZM10 6a4 4 0 0 1 3.88 3.03c-.33.04-.66.11-.98.2a3 3 0 1 0-3.66 3.67c-.1.32-.17.65-.2.98A4 4 0 0 1 10 6Zm9 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4-2a.5.5 0 0 0-1 0V14h-1.5a.5.5 0 1 0 0 1H14v1.5a.5.5 0 1 0 1 0V15h1.5a.5.5 0 0 0 0-1H15v-1.5Z"]));
export const CameraArrowUpFilled = ( /*#__PURE__*/createFluentIcon('CameraArrowUpFilled', "1em", ["M7 10a3 3 0 0 1 5.9-.76 5.51 5.51 0 0 0-3.66 3.66A3 3 0 0 1 7 10Zm3-4a4 4 0 0 1 3.88 3.03A5.56 5.56 0 0 1 18 10.26V6.5A2.5 2.5 0 0 0 15.5 4h-1.69l-.58-1.17A1.5 1.5 0 0 0 11.89 2H8.12a1.5 1.5 0 0 0-1.34.83L6.2 4H4.5A2.5 2.5 0 0 0 2 6.5v8A2.5 2.5 0 0 0 4.5 17h5.1a5.48 5.48 0 0 1-.57-3.12A4 4 0 0 1 10 6Zm9 8.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.85-2.35-2 2a.5.5 0 0 0 .7.7L14 13.71v2.79a.5.5 0 0 0 1 0v-2.8l1.15 1.15a.5.5 0 0 0 .7-.7l-2-2a.5.5 0 0 0-.35-.15.5.5 0 0 0-.35.14Z"]));
export const CameraArrowUpRegular = ( /*#__PURE__*/createFluentIcon('CameraArrowUpRegular', "1em", ["M10 6a4 4 0 0 0-.97 7.88c.04-.33.11-.66.2-.98a3 3 0 1 1 3.67-3.66c.32-.1.64-.17.98-.2A4 4 0 0 0 10 6ZM4.5 16h4.7c.1.35.24.68.4 1H4.5A2.5 2.5 0 0 1 2 14.5v-8A2.5 2.5 0 0 1 4.5 4h1.7l.58-1.17c.26-.51.78-.83 1.34-.83h3.77c.57 0 1.08.32 1.34.83L13.8 4h1.7A2.5 2.5 0 0 1 18 6.5v3.76a5.5 5.5 0 0 0-1-.66V6.5c0-.83-.68-1.5-1.5-1.5h-2a.5.5 0 0 1-.45-.28l-.73-1.44A.5.5 0 0 0 11.9 3H8.12a.5.5 0 0 0-.44.28l-.73 1.44A.5.5 0 0 1 6.5 5h-2C3.68 5 3 5.67 3 6.5v8c0 .83.68 1.5 1.5 1.5ZM19 14.5a4.5 4.5 0 1 1-9 0 4.5 4.5 0 0 1 9 0Zm-4.85-2.35-2 2a.5.5 0 0 0 .7.7L14 13.71v2.79a.5.5 0 0 0 1 0v-2.8l1.15 1.15a.5.5 0 0 0 .7-.7l-2-2a.5.5 0 0 0-.35-.15.5.5 0 0 0-.35.14Z"]));
export const CameraDomeFilled = ( /*#__PURE__*/createFluentIcon('CameraDomeFilled', "1em", ["M2 4.5C2 3.67 2.67 3 3.5 3h13a1.5 1.5 0 0 1 0 3h-13A1.5 1.5 0 0 1 2 4.5ZM10 9a3 3 0 1 0 0 6 3 3 0 0 0 0-6Zm-2 3a2 2 0 1 1 4 0 2 2 0 0 1-4 0ZM3 7h14v4a7 7 0 1 1-14 0V7Zm7 1a4 4 0 1 0 0 8 4 4 0 0 0 0-8Z"]));
export const CameraDomeRegular = ( /*#__PURE__*/createFluentIcon('CameraDomeRegular', "1em", ["M8 12a2 2 0 1 1 4 0 2 2 0 0 1-4 0Zm2-4a4 4 0 1 0 0 8 4 4 0 0 0 0-8Zm-3 4a3 3 0 1 1 6 0 3 3 0 0 1-6 0ZM2 4.5C2 3.67 2.67 3 3.5 3h13c.83 0 1.5.67 1.5 1.5v1c0 .65-.42 1.2-1 1.41V11a7 7 0 1 1-14 0V6.91c-.58-.2-1-.76-1-1.41v-1ZM4 7v4a6 6 0 1 0 12 0V7H4Zm-.5-3a.5.5 0 0 0-.5.5v1c0 .28.22.5.5.5h13a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-13Z"]));
