"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const useIconState_1 = require("./useIconState");
const wrapIcon = (Icon, displayName, options) => {
    const WrappedIcon = React.forwardRef((props, ref) => {
        const state = {
            ...useIconState_1.useIconState(props, { flipInRtl: options === null || options === void 0 ? void 0 : options.flipInRtl }),
            ref
        };
        return React.createElement(Icon, Object.assign({}, state));
    });
    WrappedIcon.displayName = displayName;
    return WrappedIcon;
};
exports.default = wrapIcon;
