'use client';

import { tokens, typographyStyles } from '@fluentui/react-theme';
import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
export const fieldClassNames = {
  root: `fui-Field`,
  label: `fui-Field__label`,
  validationMessage: `fui-Field__validationMessage`,
  validationMessageIcon: `fui-Field__validationMessageIcon`,
  hint: `fui-Field__hint`
};
// Size of the icon in the validation message
const iconSize = '12px';
/**
 * Styles for the root slot
 */
const useRootStyles = /*#__PURE__*/__styles({
  base: {
    mc9l5x: "f13qh94s"
  },
  horizontal: {
    Budl1dq: "f2wwaib",
    wkccdc: "f1645dqt"
  },
  horizontalNoLabel: {
    uwmqm3: ["f15jqgz8", "fggqkej"],
    Budl1dq: "f1c2z91y"
  }
}, {
  d: [".f13qh94s{display:grid;}", ".f2wwaib{grid-template-columns:33% 1fr;}", ".f1645dqt{grid-template-rows:auto auto auto 1fr;}", ".f15jqgz8{padding-left:33%;}", ".fggqkej{padding-right:33%;}", ".f1c2z91y{grid-template-columns:1fr;}"]
});
const useLabelStyles = /*#__PURE__*/__styles({
  vertical: {
    z8tnut: "fclwglc",
    Byoj8tv: "fywfov9",
    jrapky: "fyacil5"
  },
  verticalLarge: {
    z8tnut: "f1sl3k7w",
    Byoj8tv: "f1brlhvm",
    jrapky: "f8l5zjj"
  },
  horizontal: {
    z8tnut: "fp2oml8",
    Byoj8tv: "f1tdddsa",
    t21cq0: ["fkujibs", "f199hnxi"],
    Ijaq50: "f16hsg94",
    nk6f5a: "f1nzqi2z"
  },
  horizontalSmall: {
    z8tnut: "f1ywm7hm",
    Byoj8tv: "f14wxoun"
  },
  horizontalLarge: {
    z8tnut: "f1hqyr95",
    Byoj8tv: "fm4hlj0"
  }
}, {
  d: [".fclwglc{padding-top:var(--spacingVerticalXXS);}", ".fywfov9{padding-bottom:var(--spacingVerticalXXS);}", ".fyacil5{margin-bottom:var(--spacingVerticalXXS);}", ".f1sl3k7w{padding-top:1px;}", ".f1brlhvm{padding-bottom:1px;}", ".f8l5zjj{margin-bottom:var(--spacingVerticalXS);}", ".fp2oml8{padding-top:var(--spacingVerticalSNudge);}", ".f1tdddsa{padding-bottom:var(--spacingVerticalSNudge);}", ".fkujibs{margin-right:var(--spacingHorizontalM);}", ".f199hnxi{margin-left:var(--spacingHorizontalM);}", ".f16hsg94{grid-row-start:1;}", ".f1nzqi2z{grid-row-end:-1;}", ".f1ywm7hm{padding-top:var(--spacingVerticalXS);}", ".f14wxoun{padding-bottom:var(--spacingVerticalXS);}", ".f1hqyr95{padding-top:9px;}", ".fm4hlj0{padding-bottom:9px;}"]
});
const useSecondaryTextBaseClassName = /*#__PURE__*/__resetStyles("r5c4z9l", null, [".r5c4z9l{margin-top:var(--spacingVerticalXXS);color:var(--colorNeutralForeground3);font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase200);}"]);
const useSecondaryTextStyles = /*#__PURE__*/__styles({
  error: {
    sj55zd: "f1hcrxcs"
  },
  withIcon: {
    uwmqm3: ["frawy03", "fg4c52"]
  }
}, {
  d: [".f1hcrxcs{color:var(--colorPaletteRedForeground1);}", ".frawy03{padding-left:calc(12px + var(--spacingHorizontalXS));}", ".fg4c52{padding-right:calc(12px + var(--spacingHorizontalXS));}"]
});
const useValidationMessageIconBaseClassName = /*#__PURE__*/__resetStyles("ra7h1uk", "r1rh6bd7", [".ra7h1uk{display:inline-block;font-size:12px;margin-left:calc(-12px - var(--spacingHorizontalXS));margin-right:var(--spacingHorizontalXS);line-height:0;vertical-align:-1px;}", ".r1rh6bd7{display:inline-block;font-size:12px;margin-right:calc(-12px - var(--spacingHorizontalXS));margin-left:var(--spacingHorizontalXS);line-height:0;vertical-align:-1px;}"]);
const useValidationMessageIconStyles = /*#__PURE__*/__styles({
  error: {
    sj55zd: "f1hcrxcs"
  },
  warning: {
    sj55zd: "f1k5f75o"
  },
  success: {
    sj55zd: "ffmvakt"
  }
}, {
  d: [".f1hcrxcs{color:var(--colorPaletteRedForeground1);}", ".f1k5f75o{color:var(--colorPaletteDarkOrangeForeground1);}", ".ffmvakt{color:var(--colorPaletteGreenForeground1);}"]
});
/**
 * Apply styling to the Field slots based on the state
 */
export const useFieldStyles_unstable = state => {
  'use no memo';

  const {
    validationState,
    size
  } = state;
  const horizontal = state.orientation === 'horizontal';
  const rootStyles = useRootStyles();
  state.root.className = mergeClasses(fieldClassNames.root, rootStyles.base, horizontal && rootStyles.horizontal, horizontal && !state.label && rootStyles.horizontalNoLabel, state.root.className);
  const labelStyles = useLabelStyles();
  if (state.label) {
    state.label.className = mergeClasses(fieldClassNames.label, horizontal && labelStyles.horizontal, horizontal && size === 'small' && labelStyles.horizontalSmall, horizontal && size === 'large' && labelStyles.horizontalLarge, !horizontal && labelStyles.vertical, !horizontal && size === 'large' && labelStyles.verticalLarge, state.label.className);
  }
  const validationMessageIconBaseClassName = useValidationMessageIconBaseClassName();
  const validationMessageIconStyles = useValidationMessageIconStyles();
  if (state.validationMessageIcon) {
    state.validationMessageIcon.className = mergeClasses(fieldClassNames.validationMessageIcon, validationMessageIconBaseClassName, validationState !== 'none' && validationMessageIconStyles[validationState], state.validationMessageIcon.className);
  }
  const secondaryTextBaseClassName = useSecondaryTextBaseClassName();
  const secondaryTextStyles = useSecondaryTextStyles();
  if (state.validationMessage) {
    state.validationMessage.className = mergeClasses(fieldClassNames.validationMessage, secondaryTextBaseClassName, validationState === 'error' && secondaryTextStyles.error, !!state.validationMessageIcon && secondaryTextStyles.withIcon, state.validationMessage.className);
  }
  if (state.hint) {
    state.hint.className = mergeClasses(fieldClassNames.hint, secondaryTextBaseClassName, state.hint.className);
  }
  return state;
};