'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    fieldClassNames: function() {
        return fieldClassNames;
    },
    useFieldStyles_unstable: function() {
        return useFieldStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const fieldClassNames = {
    root: `fui-Field`,
    label: `fui-Field__label`,
    validationMessage: `fui-Field__validationMessage`,
    validationMessageIcon: `fui-Field__validationMessageIcon`,
    hint: `fui-Field__hint`
};
// Size of the icon in the validation message
const iconSize = '12px';
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeStyles)({
    base: {
        display: 'grid'
    },
    // In horizontal layout, the field is a grid with the label taking up the entire first column.
    // The last row is slack space in case the label is taller than the rest of the content.
    horizontal: {
        gridTemplateColumns: '33% 1fr',
        gridTemplateRows: 'auto auto auto 1fr'
    },
    // In horizontal layout without a label, replace the label's column with padding.
    // This lets grid auto-flow properly place the other children, and keeps fields with and without labels aligned.
    horizontalNoLabel: {
        paddingLeft: '33%',
        gridTemplateColumns: '1fr'
    }
});
const useLabelStyles = (0, _react.makeStyles)({
    vertical: {
        paddingTop: _reacttheme.tokens.spacingVerticalXXS,
        paddingBottom: _reacttheme.tokens.spacingVerticalXXS,
        marginBottom: _reacttheme.tokens.spacingVerticalXXS
    },
    verticalLarge: {
        paddingTop: '1px',
        paddingBottom: '1px',
        marginBottom: _reacttheme.tokens.spacingVerticalXS
    },
    horizontal: {
        paddingTop: _reacttheme.tokens.spacingVerticalSNudge,
        paddingBottom: _reacttheme.tokens.spacingVerticalSNudge,
        marginRight: _reacttheme.tokens.spacingHorizontalM,
        gridRowStart: '1',
        gridRowEnd: '-1'
    },
    horizontalSmall: {
        paddingTop: _reacttheme.tokens.spacingVerticalXS,
        paddingBottom: _reacttheme.tokens.spacingVerticalXS
    },
    horizontalLarge: {
        // To align the label text with the Input text, it should be centered within the 40px height of the Input.
        // This is (40px - lineHeightBase400) / 2 = 9px. Hardcoded since there is no 9px padding token.
        paddingTop: '9px',
        paddingBottom: '9px'
    }
});
const useSecondaryTextBaseClassName = (0, _react.makeResetStyles)({
    marginTop: _reacttheme.tokens.spacingVerticalXXS,
    color: _reacttheme.tokens.colorNeutralForeground3,
    ..._reacttheme.typographyStyles.caption1
});
const useSecondaryTextStyles = (0, _react.makeStyles)({
    error: {
        color: _reacttheme.tokens.colorPaletteRedForeground1
    },
    withIcon: {
        // Add a gutter for the icon, to allow multiple lines of text to line up to the right of the icon.
        paddingLeft: `calc(${iconSize} + ${_reacttheme.tokens.spacingHorizontalXS})`
    }
});
const useValidationMessageIconBaseClassName = (0, _react.makeResetStyles)({
    display: 'inline-block',
    fontSize: iconSize,
    // Negative left margin puts the icon in the gutter of the validation message div's withIcon style.
    marginLeft: `calc(-${iconSize} - ${_reacttheme.tokens.spacingHorizontalXS})`,
    marginRight: _reacttheme.tokens.spacingHorizontalXS,
    // Line height of 0 prevents the verticalAlign from affecting the line height of the text.
    lineHeight: '0',
    // Negative verticalAlign shifts the inline icon down to align with the text (effectively top padding).
    verticalAlign: '-1px'
});
const useValidationMessageIconStyles = (0, _react.makeStyles)({
    error: {
        color: _reacttheme.tokens.colorPaletteRedForeground1
    },
    warning: {
        color: _reacttheme.tokens.colorPaletteDarkOrangeForeground1
    },
    success: {
        color: _reacttheme.tokens.colorPaletteGreenForeground1
    }
});
const useFieldStyles_unstable = (state)=>{
    'use no memo';
    const { validationState, size } = state;
    const horizontal = state.orientation === 'horizontal';
    const rootStyles = useRootStyles();
    state.root.className = (0, _react.mergeClasses)(fieldClassNames.root, rootStyles.base, horizontal && rootStyles.horizontal, horizontal && !state.label && rootStyles.horizontalNoLabel, state.root.className);
    const labelStyles = useLabelStyles();
    if (state.label) {
        state.label.className = (0, _react.mergeClasses)(fieldClassNames.label, horizontal && labelStyles.horizontal, horizontal && size === 'small' && labelStyles.horizontalSmall, horizontal && size === 'large' && labelStyles.horizontalLarge, !horizontal && labelStyles.vertical, !horizontal && size === 'large' && labelStyles.verticalLarge, state.label.className);
    }
    const validationMessageIconBaseClassName = useValidationMessageIconBaseClassName();
    const validationMessageIconStyles = useValidationMessageIconStyles();
    if (state.validationMessageIcon) {
        state.validationMessageIcon.className = (0, _react.mergeClasses)(fieldClassNames.validationMessageIcon, validationMessageIconBaseClassName, validationState !== 'none' && validationMessageIconStyles[validationState], state.validationMessageIcon.className);
    }
    const secondaryTextBaseClassName = useSecondaryTextBaseClassName();
    const secondaryTextStyles = useSecondaryTextStyles();
    if (state.validationMessage) {
        state.validationMessage.className = (0, _react.mergeClasses)(fieldClassNames.validationMessage, secondaryTextBaseClassName, validationState === 'error' && secondaryTextStyles.error, !!state.validationMessageIcon && secondaryTextStyles.withIcon, state.validationMessage.className);
    }
    if (state.hint) {
        state.hint.className = (0, _react.mergeClasses)(fieldClassNames.hint, secondaryTextBaseClassName, state.hint.className);
    }
    return state;
};
