"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useField_unstable", {
    enumerable: true,
    get: function() {
        return useField_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacticons = require("@fluentui/react-icons");
const _reactlabel = require("@fluentui/react-label");
const _reactutilities = require("@fluentui/react-utilities");
const validationMessageIcons = {
    error: /*#__PURE__*/ _react.createElement(_reacticons.ErrorCircle12Filled, null),
    warning: /*#__PURE__*/ _react.createElement(_reacticons.Warning12Filled, null),
    success: /*#__PURE__*/ _react.createElement(_reacticons.CheckmarkCircle12Filled, null),
    none: undefined
};
const useField_unstable = (props, ref)=>{
    const { children, orientation = 'vertical', required = false, validationState = props.validationMessage ? 'error' : 'none', size = 'medium' } = props;
    const baseId = (0, _reactutilities.useId)('field-');
    const generatedControlId = baseId + '__control';
    const root = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
        ...props,
        ref
    }, /*excludedPropNames:*/ [
        'children'
    ]), {
        elementType: 'div'
    });
    const label = _reactutilities.slot.optional(props.label, {
        defaultProps: {
            htmlFor: generatedControlId,
            id: baseId + '__label',
            required,
            size
        },
        elementType: _reactlabel.Label
    });
    const validationMessage = _reactutilities.slot.optional(props.validationMessage, {
        defaultProps: {
            id: baseId + '__validationMessage',
            role: validationState === 'error' || validationState === 'warning' ? 'alert' : undefined
        },
        elementType: 'div'
    });
    const hint = _reactutilities.slot.optional(props.hint, {
        defaultProps: {
            id: baseId + '__hint'
        },
        elementType: 'div'
    });
    const defaultIcon = validationMessageIcons[validationState];
    const validationMessageIcon = _reactutilities.slot.optional(props.validationMessageIcon, {
        renderByDefault: !!defaultIcon,
        defaultProps: {
            children: defaultIcon
        },
        elementType: 'span'
    });
    return {
        children,
        generatedControlId,
        orientation,
        required,
        size,
        validationState,
        components: {
            root: 'div',
            label: _reactlabel.Label,
            validationMessage: 'div',
            validationMessageIcon: 'span',
            hint: 'div'
        },
        root,
        label,
        validationMessageIcon,
        validationMessage,
        hint
    };
};
