import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import { Label } from '@fluentui/react-label';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

export declare const Field: ForwardRefComponent<FieldProps>;

export declare const fieldClassNames: SlotClassNames<FieldSlots>;

export declare const FieldContextProvider: React_2.Provider<Readonly<Pick<FieldState, "required" | "size" | "orientation" | "validationState" | "generatedControlId"> & {
    labelFor?: string;
    labelId?: string;
    validationMessageId?: string;
    hintId?: string;
}> | undefined>;

export declare type FieldContextValue = Readonly<Pick<FieldState, 'generatedControlId' | 'orientation' | 'required' | 'size' | 'validationState'> & {
    /** The label's for prop. Undefined if there is no label. */
    labelFor?: string;
    /** The label's id prop. Undefined if there is no label. */
    labelId?: string;
    /** The validationMessage's id prop. Undefined if there is no validationMessage. */
    validationMessageId?: string;
    /** The hint's id prop. Undefined if there is no hint. */
    hintId?: string;
}>;

export declare type FieldContextValues = {
    field: FieldContextValue;
};

/**
 * The props added to the control inside the Field.
 */
export declare type FieldControlProps = Pick<React_2.HTMLAttributes<HTMLElement>, 'id' | 'aria-labelledby' | 'aria-describedby' | 'aria-invalid' | 'aria-required'>;

/**
 * Options for `useFieldControlProps_unstable`.
 */
export declare type FieldControlPropsOptions = {
    /**
     * Skips setting `aria-labelledby` on the control if the `label.htmlFor` refers to the control.
     *
     * This should be used with controls that can be the target of a label's `for` prop:
     * `<button>`, `<input>`, `<progress>`, `<select>`, `<textarea>`.
     */
    supportsLabelFor?: boolean;
    /**
     * Sets `required` instead of `aria-required` when the Field is marked required.
     *
     * This should be used with controls that support the `required` prop:
     * `<input>` (except `range` or `color`), `<select>`, `<textarea>`.
     */
    supportsRequired?: boolean;
    /**
     * Sets the size prop on the control to match the Field's size: `'small' | 'medium' | 'large'`.
     *
     * This should be used with controls that have a custom size prop that matches the Field's size prop.
     */
    supportsSize?: boolean;
};

/**
 * Field Props
 */
export declare type FieldProps = Omit<ComponentProps<FieldSlots>, 'children'> & {
    /**
     * The Field's child can be a single form control, or a render function that takes the props that should be spread on
     * a form control.
     *
     * All form controls in this library can be used directly as children (such as `<Input>` or `<RadioGroup>`).
     *
     * For other controls, there are two options:
     * 1. The child of Field can be a render function that is given the props that should be spread on the control.
     *    `<Field>{(props) => <MyInput {...props} />}</Field>`
     * 2. The control itself can merge props from field with useFieldControlProps_unstable().
     *    `props = useFieldControlProps_unstable(props);`
     */
    children?: React_2.ReactNode | ((props: FieldControlProps) => React_2.ReactNode);
    /**
     * The orientation of the label relative to the field component.
     * This only affects the label, and not the validationMessage or hint (which always appear below the field component).
     *
     * @default vertical
     */
    orientation?: 'vertical' | 'horizontal';
    /**
     * The `validationState` affects the display of the `validationMessage` and `validationMessageIcon`.
     *
     * * error: (default) The validation message has a red error icon and red text, with `role="alert"` so it is
     *     announced by screen readers. Additionally, the control inside the field has `aria-invalid` set, which adds a
     *     red border to some field components (such as `Input`).
     * * success: The validation message has a green checkmark icon and gray text.
     * * warning: The validation message has a yellow exclamation icon and gray text, with `role="alert"` so it is
     *     announced by screen readers.
     * * none: The validation message has no icon and gray text.
     *
     * @default error when validationMessage is set; none otherwise.
     */
    validationState?: 'error' | 'warning' | 'success' | 'none';
    /**
     * Marks the Field as required. If `true`, an asterisk will be appended to the label, and `aria-required` will be set
     * on the Field's child.
     */
    required?: boolean;
    /**
     * The size of the Field's label.
     *
     * @default medium
     */
    size?: 'small' | 'medium' | 'large';
};

/**
 * Slots of the Field component
 */
export declare type FieldSlots = {
    root: NonNullable<Slot<'div'>>;
    /**
     * The label associated with the field.
     */
    label?: Slot<typeof Label>;
    /**
     * A message about the validation state. By default, this is an error message, but it can be a success, warning,
     * or custom message by setting `validationState`.
     */
    validationMessage?: Slot<'div'>;
    /**
     * The icon associated with the `validationMessage`. This will only be displayed if `validationMessage` is set.
     *
     * The default depends on `validationState`:
     * * error: `<ErrorCircle12Filled />`
     * * warning: `<Warning12Filled />`
     * * success: `<CheckmarkCircle12Filled />`
     * * none: `null`
     */
    validationMessageIcon?: Slot<'span'>;
    /**
     * Additional hint text below the field.
     */
    hint?: Slot<'div'>;
};

/**
 * State used in rendering Field
 */
export declare type FieldState = ComponentState<Required<FieldSlots>> & Required<Pick<FieldProps, 'orientation' | 'required' | 'size' | 'validationState'>> & Pick<FieldProps, 'children'> & {
    /**
     * The ID generated for the control inside the field, and the default value of label.htmlFor prop.
     */
    generatedControlId: string;
};

/**
 * Render the final JSX of Field
 */
export declare const renderField_unstable: (state: FieldState, contextValues: FieldContextValues) => JSXElement;

/**
 * Create the state required to render Field.
 *
 * The returned state can be modified with hooks such as useFieldStyles_unstable,
 * before being passed to renderField_unstable.
 *
 * @param props - Props passed to this field
 * @param ref - Ref to the root
 */
export declare const useField_unstable: (props: FieldProps, ref: React_2.Ref<HTMLDivElement>) => FieldState;

export declare const useFieldContext_unstable: () => FieldContextValue | undefined;

/**
 * Get the context values used when rendering Field.
 */
export declare const useFieldContextValues_unstable: (state: FieldState) => FieldContextValues;

/**
 * Gets the control props from the field context, if this inside a `<Field>`.
 *
 * When called with no arguments, returns the FieldControlProps that should be applied to the control.
 *
 * @returns A FieldControlProps object if inside a `<Field>`, otherwise undefined.
 */
export declare function useFieldControlProps_unstable(): FieldControlProps | undefined;

/**
 * Copies and merges the FieldControlProps with the given props, if this inside a `<Field>`.
 *
 * @param props - The existing props for the control. These will be merged with the control props from the field context.
 * @param options - Option to include the size prop.
 * @returns Merged props if inside a `<Field>`, otherwise the original props, or undefined if no props given.
 */
export declare function useFieldControlProps_unstable<Props extends FieldControlProps>(props: Props, options?: FieldControlPropsOptions): Props;

/**
 * Apply styling to the Field slots based on the state
 */
export declare const useFieldStyles_unstable: (state: FieldState) => FieldState;

export { }
