'use client';
import * as React from 'react';
import { mount } from '@fluentui/scripts-cypress';
import { FluentProvider } from '@fluentui/react-provider';
import { webLightTheme } from '@fluentui/react-theme';
const mountFluent = (element)=>{
    mount(/*#__PURE__*/ React.createElement(FluentProvider, {
        theme: webLightTheme
    }, element));
};
export function testDrawerBaseScenarios(Component) {
    describe('basic functionality', ()=>{
        it('should not render any element when closed', ()=>{
            mountFluent(/*#__PURE__*/ React.createElement(Component, {
                id: "drawer"
            }));
            cy.get('#drawer').should('not.exist');
        });
        it('should render an element when opened', ()=>{
            mountFluent(/*#__PURE__*/ React.createElement(Component, {
                id: "drawer",
                open: true
            }));
            cy.get('#drawer').should('exist');
        });
        it('should render children content', ()=>{
            const content = 'Test the renderization';
            mountFluent(/*#__PURE__*/ React.createElement(Component, {
                id: "drawer",
                open: true
            }, content));
            cy.get('#drawer').contains(content);
        });
        it('should toggle visibility on open prop change', ()=>{
            const ExampleDrawer = ()=>{
                const [open, setOpen] = React.useState(false);
                return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(Component, {
                    id: "drawer",
                    open: open
                }), /*#__PURE__*/ React.createElement("button", {
                    id: "button",
                    onClick: ()=>setOpen(true)
                }, "Open"));
            };
            mountFluent(/*#__PURE__*/ React.createElement(ExampleDrawer, null));
            cy.get('#drawer').should('not.exist');
            cy.get('#button').click();
            cy.get('#drawer').should('exist');
        });
    });
    describe('size prop', ()=>{
        const sizes = {
            small: 320,
            medium: 592,
            large: 940,
            full: 1000
        };
        Object.entries(sizes).forEach(([size, width])=>{
            const sizeProp = size;
            it(`should have correct size when size is ${size}`, ()=>{
                mountFluent(/*#__PURE__*/ React.createElement(Component, {
                    size: sizeProp,
                    id: "drawer",
                    open: true
                }));
                cy.viewport(1000, 1000);
                cy.get('#drawer').should('have.css', 'width', width + 'px');
                cy.get('#drawer').invoke('outerWidth').should('equal', width);
            });
        });
        it('width should not be bigger than viewport', ()=>{
            mountFluent(/*#__PURE__*/ React.createElement(Component, {
                id: "drawer",
                open: true
            }));
            cy.viewport(319, 319);
            cy.get('#drawer').should('have.css', 'width', '319px');
            cy.get('#drawer').invoke('outerWidth').should('equal', 319);
        });
        it('should have custom size', ()=>{
            mountFluent(/*#__PURE__*/ React.createElement(Component, {
                id: "drawer",
                open: true,
                style: {
                    width: '200px'
                }
            }));
            cy.get('#drawer').should('have.css', 'width', '200px');
            cy.get('#drawer').invoke('outerWidth').should('equal', 200);
        });
    });
    describe('position prop', ()=>{
        const positions = {
            start: 'left',
            end: 'right',
            bottom: 'bottom'
        };
        Object.entries(positions).forEach(([position, side])=>{
            const positionProp = position;
            it(`should have correct position when position is ${position}`, ()=>{
                mountFluent(/*#__PURE__*/ React.createElement(Component, {
                    position: positionProp,
                    id: "drawer",
                    open: true
                }));
                cy.get('#drawer').should('have.css', side, '0px');
            });
        });
    });
}
