'use client';

import * as React from 'react';
import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { createFocusOutlineStyle } from '@fluentui/react-tabster';
import { drawerCSSVars, drawerDefaultStyles, useDrawerBaseClassNames } from '../../shared/useDrawerBaseStyles.styles';
export const overlayDrawerClassNames = {
  root: 'fui-OverlayDrawer',
  backdrop: 'fui-OverlayDrawer__backdrop'
};
/**
 * Styles for the root slot
 */
const useDrawerResetStyles = /*#__PURE__*/__resetStyles("r7dfyj8", "rmx02j7", {
  r: [".r7dfyj8{overflow:hidden;width:var(--fui-Drawer--size);max-width:100vw;height:auto;max-height:100vh;box-sizing:border-box;display:flex;flex-direction:column;align-items:flex-start;justify-content:flex-start;background-color:var(--colorNeutralBackground1);color:var(--colorNeutralForeground1);position:fixed;top:0;bottom:0;}", ".r7dfyj8:focus{outline-style:none;}", ".r7dfyj8:focus-visible{outline-style:none;}", ".r7dfyj8[data-fui-focus-visible]{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}", ".r7dfyj8[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}", ".rmx02j7{overflow:hidden;width:var(--fui-Drawer--size);max-width:100vw;height:auto;max-height:100vh;box-sizing:border-box;display:flex;flex-direction:column;align-items:flex-start;justify-content:flex-start;background-color:var(--colorNeutralBackground1);color:var(--colorNeutralForeground1);position:fixed;top:0;bottom:0;}", ".rmx02j7:focus{outline-style:none;}", ".rmx02j7:focus-visible{outline-style:none;}", ".rmx02j7[data-fui-focus-visible]{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}", ".rmx02j7[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}"],
  s: ["@media (forced-colors: active){.r7dfyj8[data-fui-focus-visible]::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}", "@media (forced-colors: active){.rmx02j7[data-fui-focus-visible]::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}"]
});
const useDrawerRootStyles = /*#__PURE__*/__styles({
  start: {},
  end: {},
  bottom: {
    Bhzewxz: "f198g47y",
    Bqenvij: "fub80nq",
    a9b677: "fr97h3j"
  },
  absolute: {
    qhf8xq: "f1euv43f"
  }
}, {
  d: [".f198g47y{top:auto;}", ".fub80nq{height:var(--fui-Drawer--size);}", ".fr97h3j{width:100vw;}", ".f1euv43f{position:absolute;}"]
});
/**
 * Apply styling to the OverlayDrawer slots based on the state
 */
export const useOverlayDrawerStyles_unstable = state => {
  'use no memo';

  const baseClassNames = useDrawerBaseClassNames(state);
  const resetStyles = useDrawerResetStyles();
  const rootStyles = useDrawerRootStyles();
  const absoluteStyles = state.hasMountNodeElement && rootStyles.absolute;
  const backdrop = state.root.backdrop;
  state.root.className = mergeClasses(overlayDrawerClassNames.root, baseClassNames, resetStyles, rootStyles[state.position], absoluteStyles, state.root.className);
  if (backdrop) {
    backdrop.className = mergeClasses(overlayDrawerClassNames.backdrop, absoluteStyles, backdrop.className);
  }
  return state;
};