'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
/**
 * Styles for the backdrop slot
 */
const useBackdropResetStyles = /*#__PURE__*/__resetStyles("rl76ifk", null, [".rl76ifk{inset:0px;position:fixed;background-color:var(--colorBackgroundOverlay);}"]);
const useBackdropStyles = /*#__PURE__*/__styles({
  nested: {
    De3pzq: "f1c21dwh"
  }
}, {
  d: [".f1c21dwh{background-color:var(--colorTransparentBackground);}"]
});
/**
 * Apply styling to the OverlayDrawerSurface slots based on the state
 */
export const useOverlayDrawerSurfaceStyles_unstable = state => {
  'use no memo';

  const backdropResetStyles = useBackdropResetStyles();
  const backdropStyles = useBackdropStyles();
  if (state.backdrop) {
    state.backdrop.className = mergeClasses(backdropResetStyles, state.isNestedDialog && backdropStyles.nested, state.backdrop.className);
  }
  return state;
};