'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { useDialogTitleStyles_unstable } from '@fluentui/react-dialog';
import { tokens } from '@fluentui/react-theme';
export const drawerHeaderTitleClassNames = {
  root: 'fui-DrawerHeaderTitle',
  heading: 'fui-DrawerHeaderTitle__heading',
  action: 'fui-DrawerHeaderTitle__action'
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f22iagw",
    Brf1p80: "f1869bpl",
    Bt984gj: "f122n59",
    i8kkvl: "fsnqrgy"
  },
  action: {
    t21cq0: ["faqnl2i", "fd75udd"]
  }
}, {
  d: [".f22iagw{display:flex;}", ".f1869bpl{justify-content:space-between;}", ".f122n59{align-items:center;}", ".fsnqrgy{column-gap:var(--spacingHorizontalS);}", ".faqnl2i{margin-right:calc(var(--spacingHorizontalS) * -1);}", ".fd75udd{margin-left:calc(var(--spacingHorizontalS) * -1);}"]
});
/**
 * Apply styling to the DrawerHeaderTitle slots based on the state
 */
export const useDrawerHeaderTitleStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const {
    heading: root = {},
    action,
    // We should not use components to pass along the base element type of a slot
    // but there's no way to retrieve the element type of a slot from the slot definition
    // right now without using SLOT_ELEMENT_TYPE_SYMBOL
    // TODO: create a method to retrieve the element type of a slot
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    components
  } = state;
  useDialogTitleStyles_unstable({
    components: {
      root: components.heading,
      action: components.action
    },
    root,
    action
  });
  state.root.className = mergeClasses(drawerHeaderTitleClassNames.root, styles.root, state.root.className);
  if (state.heading) {
    state.heading.className = mergeClasses(drawerHeaderTitleClassNames.heading, state.heading.className);
  }
  if (state.action) {
    state.action.className = mergeClasses(drawerHeaderTitleClassNames.action, styles.action, state.action.className);
  }
  return state;
};