'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { drawerSeparatorStyles } from '../../shared/drawerSeparatorStyles';
export const drawerHeaderClassNames = {
  root: 'fui-DrawerHeader'
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__resetStyles("r3ovn4i", null, [".r3ovn4i{width:100%;max-width:100%;padding:var(--spacingVerticalXXL) var(--spacingHorizontalXXL) var(--spacingVerticalS);gap:var(--spacingHorizontalS);align-self:stretch;display:flex;flex-direction:column;box-sizing:border-box;position:relative;z-index:2;}"]);
const useDrawerHeaderStyles = /*#__PURE__*/__styles({
  separator: {
    Dlnsje: "fxnjyrl",
    E3zdtr: "f1mdlcz9",
    B1piin3: ["f15yvnhg", "f1n6gb5g"],
    Eqx8gd: ["f1n6gb5g", "f15yvnhg"],
    Bp15pi3: "f1564nw5",
    Bjyk6c5: "fdlpgxj",
    F2fol1: "f15cmg8x",
    Ba2ppi3: "f3f8dgl",
    B1dyfl9: "fjvo4va",
    Bsft5z2: "f13zj6fq",
    By385i5: "fo72kxq"
  },
  separatorVisible: {
    Bp15pi3: "fjsqi2x"
  }
}, {
  d: [".fxnjyrl::after{height:1px;}", ".f1mdlcz9::after{position:absolute;}", ".f15yvnhg::after{right:0;}", ".f1n6gb5g::after{left:0;}", ".f1564nw5::after{opacity:0;}", ".fdlpgxj::after{background-color:var(--colorNeutralStroke1);}", ".f15cmg8x::after{transition-duration:var(--durationNormal);}", ".f3f8dgl::after{transition-property:opacity;}", ".fjvo4va::after{transition-timing-function:var(--curveEasyEase);}", ".f13zj6fq::after{content:\"\";}", ".fo72kxq::after{bottom:0;}", ".fjsqi2x::after{opacity:1;}"]
});
/**
 * Apply styling to the DrawerHeader slots based on the state
 */
export const useDrawerHeaderStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const rootStyles = useDrawerHeaderStyles();
  state.root.className = mergeClasses(drawerHeaderClassNames.root, styles, state.scrollState !== 'none' && rootStyles.separator, ['middle', 'bottom'].includes(state.scrollState) && rootStyles.separatorVisible, state.root.className);
  return state;
};