'use client';
import * as React from 'react';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
import { useDrawerBody_unstable } from './useDrawerBody';
import { renderDrawerBody_unstable } from './renderDrawerBody';
import { useDrawerBodyStyles_unstable } from './useDrawerBodyStyles.styles';
/**
 * DrawerBody provides with a container for the main content of a Drawer.
 */ export const DrawerBody = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useDrawerBody_unstable(props, ref);
    useDrawerBodyStyles_unstable(state);
    useCustomStyleHook_unstable('useDrawerBodyStyles_unstable')(state);
    return renderDrawerBody_unstable(state);
});
DrawerBody.displayName = 'DrawerBody';
