'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    drawerCSSVars: function() {
        return drawerCSSVars;
    },
    drawerDefaultStyles: function() {
        return drawerDefaultStyles;
    },
    useDrawerBaseClassNames: function() {
        return useDrawerBaseClassNames;
    },
    useDrawerBottomBaseStyles: function() {
        return useDrawerBottomBaseStyles;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const drawerCSSVars = {
    drawerSizeVar: '--fui-Drawer--size'
};
const drawerDefaultStyles = {
    overflow: 'hidden',
    width: `var(${drawerCSSVars.drawerSizeVar})`,
    maxWidth: '100vw',
    height: 'auto',
    maxHeight: '100vh',
    boxSizing: 'border-box',
    display: 'flex',
    flexDirection: 'column',
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
    color: _reacttheme.tokens.colorNeutralForeground1
};
/**
 * Shared dynamic styles for the Drawer component
 */ const useDrawerStyles = (0, _react.makeStyles)({
    /* Positioning */ start: {
        borderRight: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
        left: 0,
        right: 'auto'
    },
    end: {
        borderLeft: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
        right: 0,
        left: 'auto'
    },
    bottom: {
        bottom: 0,
        top: 'auto'
    },
    /* Sizes */ small: {
        [drawerCSSVars.drawerSizeVar]: '320px'
    },
    medium: {
        [drawerCSSVars.drawerSizeVar]: '592px'
    },
    large: {
        [drawerCSSVars.drawerSizeVar]: '940px'
    },
    full: {
        [drawerCSSVars.drawerSizeVar]: '100vw'
    }
});
const useDrawerBottomBaseStyles = (0, _react.makeStyles)({
    /* Sizes for position bottom */ small: {
        [drawerCSSVars.drawerSizeVar]: '320px'
    },
    medium: {
        [drawerCSSVars.drawerSizeVar]: '592px'
    },
    large: {
        [drawerCSSVars.drawerSizeVar]: '940px'
    },
    full: {
        [drawerCSSVars.drawerSizeVar]: '100%'
    }
});
const useDrawerBaseClassNames = ({ position, size })=>{
    const baseStyles = useDrawerStyles();
    const bottomBaseStyles = useDrawerBottomBaseStyles();
    return (0, _react.mergeClasses)(baseStyles[position], position === 'bottom' && bottomBaseStyles[size], position !== 'bottom' && baseStyles[size]);
};
