'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    drawerCSSVars: function() {
        return drawerCSSVars;
    },
    drawerDefaultStyles: function() {
        return drawerDefaultStyles;
    },
    useDrawerBaseClassNames: function() {
        return useDrawerBaseClassNames;
    },
    useDrawerBottomBaseStyles: function() {
        return useDrawerBottomBaseStyles;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const drawerCSSVars = {
    drawerSizeVar: '--fui-Drawer--size'
};
const drawerDefaultStyles = {
    overflow: 'hidden',
    width: `var(${drawerCSSVars.drawerSizeVar})`,
    maxWidth: '100vw',
    height: 'auto',
    maxHeight: '100vh',
    boxSizing: 'border-box',
    display: 'flex',
    flexDirection: 'column',
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
    color: _reacttheme.tokens.colorNeutralForeground1
};
/**
 * Shared dynamic styles for the Drawer component
 */ const useDrawerStyles = /*#__PURE__*/ (0, _react.__styles)({
    start: {
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        u1mtju: [
            "f1xteiwb",
            "fsqykmd"
        ],
        oyh7mz: [
            "f1vgc2s3",
            "f1e31b4d"
        ],
        j35jbq: [
            "fvfyk4",
            "frppm18"
        ]
    },
    end: {
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        B4g9neb: [
            "fsqykmd",
            "f1xteiwb"
        ],
        j35jbq: [
            "f1e31b4d",
            "f1vgc2s3"
        ],
        oyh7mz: [
            "frppm18",
            "fvfyk4"
        ]
    },
    bottom: {
        B5kzvoi: "f1yab3r1",
        Bhzewxz: "f198g47y"
    },
    small: {
        Bjr0ffy: "f1exhnwo"
    },
    medium: {
        Bjr0ffy: "fqofjzu"
    },
    large: {
        Bjr0ffy: "fce6y3m"
    },
    full: {
        Bjr0ffy: "fsdmzs6"
    }
}, {
    d: [
        [
            ".f1xteiwb{border-right:var(--strokeWidthThin) solid var(--colorTransparentStroke);}",
            {
                p: -1
            }
        ],
        [
            ".fsqykmd{border-left:var(--strokeWidthThin) solid var(--colorTransparentStroke);}",
            {
                p: -1
            }
        ],
        ".f1vgc2s3{left:0;}",
        ".f1e31b4d{right:0;}",
        ".fvfyk4{right:auto;}",
        ".frppm18{left:auto;}",
        [
            ".fsqykmd{border-left:var(--strokeWidthThin) solid var(--colorTransparentStroke);}",
            {
                p: -1
            }
        ],
        [
            ".f1xteiwb{border-right:var(--strokeWidthThin) solid var(--colorTransparentStroke);}",
            {
                p: -1
            }
        ],
        ".f1yab3r1{bottom:0;}",
        ".f198g47y{top:auto;}",
        ".f1exhnwo{--fui-Drawer--size:320px;}",
        ".fqofjzu{--fui-Drawer--size:592px;}",
        ".fce6y3m{--fui-Drawer--size:940px;}",
        ".fsdmzs6{--fui-Drawer--size:100vw;}"
    ]
});
const useDrawerBottomBaseStyles = /*#__PURE__*/ (0, _react.__styles)({
    small: {
        Bjr0ffy: "f1exhnwo"
    },
    medium: {
        Bjr0ffy: "fqofjzu"
    },
    large: {
        Bjr0ffy: "fce6y3m"
    },
    full: {
        Bjr0ffy: "f1rat34m"
    }
}, {
    d: [
        ".f1exhnwo{--fui-Drawer--size:320px;}",
        ".fqofjzu{--fui-Drawer--size:592px;}",
        ".fce6y3m{--fui-Drawer--size:940px;}",
        ".f1rat34m{--fui-Drawer--size:100%;}"
    ]
});
const useDrawerBaseClassNames = ({ position, size })=>{
    const baseStyles = useDrawerStyles();
    const bottomBaseStyles = useDrawerBottomBaseStyles();
    return (0, _react.mergeClasses)(baseStyles[position], position === 'bottom' && bottomBaseStyles[size], position !== 'bottom' && baseStyles[size]);
};
