"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    InlineDrawerMotion: function() {
        return InlineDrawerMotion;
    },
    OverlayDrawerMotion: function() {
        return OverlayDrawerMotion;
    },
    OverlaySurfaceBackdropMotion: function() {
        return OverlaySurfaceBackdropMotion;
    },
    getPositionTransform: function() {
        return getPositionTransform;
    }
});
const _reactmotion = require("@fluentui/react-motion");
const _reacttheme = require("@fluentui/react-theme");
const _useDrawerBaseStylesstyles = require("./useDrawerBaseStyles.styles");
const durations = {
    small: _reactmotion.motionTokens.durationGentle,
    medium: _reactmotion.motionTokens.durationSlow,
    large: _reactmotion.motionTokens.durationSlower,
    full: _reactmotion.motionTokens.durationUltraSlow
};
function getPositionTransform(position, sizeVar, dir) {
    const leftToRightTransform = `translate3d(var(${sizeVar}), 0, 0)`;
    const rightToLeftTransform = `translate3d(calc(var(${sizeVar}) * -1), 0, 0)`;
    const bottomToTopTransform = `translate3d(0, var(${sizeVar}), 0)`;
    if (position === 'start') {
        return dir === 'ltr' ? rightToLeftTransform : leftToRightTransform;
    }
    if (position === 'end') {
        return dir === 'ltr' ? leftToRightTransform : rightToLeftTransform;
    }
    if (position === 'bottom') {
        return bottomToTopTransform;
    }
    return 'translate3d(0, 0, 0)';
}
const InlineDrawerMotion = (0, _reactmotion.createPresenceComponent)(({ position, size, dir })=>{
    const keyframes = [
        {
            /**
       * TODO: Once the #31663 lands, we should update the RTL logic to use Motion APIs
       * The work will be done in the #32817
       */ transform: getPositionTransform(position, _useDrawerBaseStylesstyles.drawerCSSVars.drawerSizeVar, dir),
            opacity: 0
        },
        {
            transform: 'translate3d(0, 0, 0)',
            opacity: 1
        }
    ];
    const duration = durations[size];
    return {
        enter: {
            keyframes,
            duration,
            easing: _reactmotion.motionTokens.curveDecelerateMid
        },
        exit: {
            keyframes: [
                ...keyframes
            ].reverse(),
            duration,
            easing: _reactmotion.motionTokens.curveAccelerateMin
        }
    };
});
const OverlayDrawerMotion = (0, _reactmotion.createPresenceComponent)(({ position, size, dir })=>{
    const keyframes = [
        {
            /**
       * TODO: Once the #31663 lands, we should update the RTL logic to use Motion APIs
       * The work will be done in the #32817
       */ transform: getPositionTransform(position, _useDrawerBaseStylesstyles.drawerCSSVars.drawerSizeVar, dir),
            boxShadow: `0px ${_reacttheme.tokens.colorTransparentBackground}`,
            opacity: 0
        },
        {
            transform: 'translate3d(0, 0, 0)',
            boxShadow: _reacttheme.tokens.shadow64,
            opacity: 1
        }
    ];
    const duration = durations[size];
    return {
        enter: {
            keyframes,
            duration,
            easing: _reactmotion.motionTokens.curveDecelerateMid
        },
        exit: {
            keyframes: [
                ...keyframes
            ].reverse(),
            duration,
            easing: _reactmotion.motionTokens.curveAccelerateMin
        }
    };
});
const OverlaySurfaceBackdropMotion = (0, _reactmotion.createPresenceComponent)(({ size })=>{
    const keyframes = [
        {
            opacity: 0
        },
        {
            opacity: 1
        }
    ];
    const duration = durations[size];
    return {
        enter: {
            keyframes,
            easing: _reactmotion.motionTokens.curveLinear,
            duration
        },
        exit: {
            keyframes: [
                ...keyframes
            ].reverse(),
            easing: _reactmotion.motionTokens.curveLinear,
            duration
        }
    };
});
