'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "testDrawerBaseScenarios", {
    enumerable: true,
    get: function() {
        return testDrawerBaseScenarios;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _scriptscypress = require("@fluentui/scripts-cypress");
const _reactprovider = require("@fluentui/react-provider");
const _reacttheme = require("@fluentui/react-theme");
const mountFluent = (element)=>{
    (0, _scriptscypress.mount)(/*#__PURE__*/ _react.createElement(_reactprovider.FluentProvider, {
        theme: _reacttheme.webLightTheme
    }, element));
};
function testDrawerBaseScenarios(Component) {
    describe('basic functionality', ()=>{
        it('should not render any element when closed', ()=>{
            mountFluent(/*#__PURE__*/ _react.createElement(Component, {
                id: "drawer"
            }));
            cy.get('#drawer').should('not.exist');
        });
        it('should render an element when opened', ()=>{
            mountFluent(/*#__PURE__*/ _react.createElement(Component, {
                id: "drawer",
                open: true
            }));
            cy.get('#drawer').should('exist');
        });
        it('should render children content', ()=>{
            const content = 'Test the renderization';
            mountFluent(/*#__PURE__*/ _react.createElement(Component, {
                id: "drawer",
                open: true
            }, content));
            cy.get('#drawer').contains(content);
        });
        it('should toggle visibility on open prop change', ()=>{
            const ExampleDrawer = ()=>{
                const [open, setOpen] = _react.useState(false);
                return /*#__PURE__*/ _react.createElement(_react.Fragment, null, /*#__PURE__*/ _react.createElement(Component, {
                    id: "drawer",
                    open: open
                }), /*#__PURE__*/ _react.createElement("button", {
                    id: "button",
                    onClick: ()=>setOpen(true)
                }, "Open"));
            };
            mountFluent(/*#__PURE__*/ _react.createElement(ExampleDrawer, null));
            cy.get('#drawer').should('not.exist');
            cy.get('#button').click();
            cy.get('#drawer').should('exist');
        });
    });
    describe('size prop', ()=>{
        const sizes = {
            small: 320,
            medium: 592,
            large: 940,
            full: 1000
        };
        Object.entries(sizes).forEach(([size, width])=>{
            const sizeProp = size;
            it(`should have correct size when size is ${size}`, ()=>{
                mountFluent(/*#__PURE__*/ _react.createElement(Component, {
                    size: sizeProp,
                    id: "drawer",
                    open: true
                }));
                cy.viewport(1000, 1000);
                cy.get('#drawer').should('have.css', 'width', width + 'px');
                cy.get('#drawer').invoke('outerWidth').should('equal', width);
            });
        });
        it('width should not be bigger than viewport', ()=>{
            mountFluent(/*#__PURE__*/ _react.createElement(Component, {
                id: "drawer",
                open: true
            }));
            cy.viewport(319, 319);
            cy.get('#drawer').should('have.css', 'width', '319px');
            cy.get('#drawer').invoke('outerWidth').should('equal', 319);
        });
        it('should have custom size', ()=>{
            mountFluent(/*#__PURE__*/ _react.createElement(Component, {
                id: "drawer",
                open: true,
                style: {
                    width: '200px'
                }
            }));
            cy.get('#drawer').should('have.css', 'width', '200px');
            cy.get('#drawer').invoke('outerWidth').should('equal', 200);
        });
    });
    describe('position prop', ()=>{
        const positions = {
            start: 'left',
            end: 'right',
            bottom: 'bottom'
        };
        Object.entries(positions).forEach(([position, side])=>{
            const positionProp = position;
            it(`should have correct position when position is ${position}`, ()=>{
                mountFluent(/*#__PURE__*/ _react.createElement(Component, {
                    position: positionProp,
                    id: "drawer",
                    open: true
                }));
                cy.get('#drawer').should('have.css', side, '0px');
            });
        });
    });
}
