'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    overlayDrawerClassNames: function() {
        return overlayDrawerClassNames;
    },
    useOverlayDrawerStyles_unstable: function() {
        return useOverlayDrawerStyles_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _react1 = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _useDrawerBaseStylesstyles = require("../../shared/useDrawerBaseStyles.styles");
const overlayDrawerClassNames = {
    root: 'fui-OverlayDrawer',
    backdrop: 'fui-OverlayDrawer__backdrop'
};
/**
 * Styles for the root slot
 */ const useDrawerResetStyles = (0, _react1.makeResetStyles)({
    ...(0, _reacttabster.createFocusOutlineStyle)(),
    ..._useDrawerBaseStylesstyles.drawerDefaultStyles,
    position: 'fixed',
    top: 0,
    bottom: 0
});
const useDrawerRootStyles = (0, _react1.makeStyles)({
    /* Positioning */ start: {},
    end: {},
    bottom: {
        top: 'auto',
        height: `var(${_useDrawerBaseStylesstyles.drawerCSSVars.drawerSizeVar})`,
        width: '100vw'
    },
    absolute: {
        position: 'absolute'
    }
});
const useOverlayDrawerStyles_unstable = (state)=>{
    'use no memo';
    const baseClassNames = (0, _useDrawerBaseStylesstyles.useDrawerBaseClassNames)(state);
    const resetStyles = useDrawerResetStyles();
    const rootStyles = useDrawerRootStyles();
    const absoluteStyles = state.hasMountNodeElement && rootStyles.absolute;
    const backdrop = state.root.backdrop;
    state.root.className = (0, _react1.mergeClasses)(overlayDrawerClassNames.root, baseClassNames, resetStyles, rootStyles[state.position], absoluteStyles, state.root.className);
    if (backdrop) {
        backdrop.className = (0, _react1.mergeClasses)(overlayDrawerClassNames.backdrop, absoluteStyles, backdrop.className);
    }
    return state;
};
