'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useOverlayDrawer_unstable", {
    enumerable: true,
    get: function() {
        return useOverlayDrawer_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactdialog = require("@fluentui/react-dialog");
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reactportal = require("@fluentui/react-portal");
const _drawerMotions = require("../../shared/drawerMotions");
const _useDrawerDefaultProps = require("../../shared/useDrawerDefaultProps");
const _OverlayDrawerSurface = require("./OverlayDrawerSurface");
const _drawerMotionUtils = require("../../shared/drawerMotionUtils");
const STATIC_MOTION = {
    active: true,
    canRender: true,
    ref: /*#__PURE__*/ _react.createRef(),
    type: 'idle'
};
const useOverlayDrawer_unstable = (props, ref)=>{
    const { open, size, position } = (0, _useDrawerDefaultProps.useDrawerDefaultProps)(props);
    const { backdropMotion, modalType = 'modal', inertTrapFocus, onOpenChange, surfaceMotion, mountNode } = props;
    const { dir, targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const { element: mountNodeElement } = (0, _reactportal.toMountNodeProps)(mountNode);
    const hasMountNodeElement = Boolean(mountNodeElement && (targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.body) !== mountNodeElement);
    const backdropProps = _reactutilities.slot.resolveShorthand(props.backdrop);
    const hasCustomBackdrop = modalType !== 'non-modal' && backdropProps !== null;
    const root = _reactutilities.slot.always({
        ...props,
        ref,
        backdrop: hasCustomBackdrop ? {
            ...backdropProps
        } : null,
        backdropMotion: (0, _drawerMotionUtils.mergePresenceSlots)(backdropMotion, _drawerMotions.OverlaySurfaceBackdropMotion, {
            size
        })
    }, {
        /**
       * Drawer accepts a `div` or `aside` element type, but Dialog only accepts a `div` element type.
       * We need to cast the ref to a `div` element type to not break Dialog's ref type.
       */ elementType: _OverlayDrawerSurface.OverlayDrawerSurface
    });
    const dialog = _reactutilities.slot.always({
        open,
        onOpenChange,
        inertTrapFocus,
        modalType,
        surfaceMotion: (0, _drawerMotionUtils.mergePresenceSlots)(surfaceMotion, _drawerMotions.OverlayDrawerMotion, {
            position,
            size,
            dir
        }),
        /**
       * children is not needed here because we construct the children in the render function,
       * but it's required by DialogProps
       */ children: null
    }, {
        elementType: _reactdialog.Dialog
    });
    return {
        components: {
            root: _OverlayDrawerSurface.OverlayDrawerSurface,
            dialog: _reactdialog.Dialog
        },
        root,
        dialog,
        open,
        size,
        position,
        hasMountNodeElement,
        // Deprecated props
        mountNode,
        motion: STATIC_MOTION
    };
};
