'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useOverlayDrawerSurfaceStyles_unstable", {
    enumerable: true,
    get: function() {
        return useOverlayDrawerSurfaceStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
/**
 * Styles for the backdrop slot
 */ const useBackdropResetStyles = (0, _react.makeResetStyles)({
    inset: '0px',
    position: 'fixed',
    backgroundColor: _reacttheme.tokens.colorBackgroundOverlay
});
const useBackdropStyles = (0, _react.makeStyles)({
    nested: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground
    }
});
const useOverlayDrawerSurfaceStyles_unstable = (state)=>{
    'use no memo';
    const backdropResetStyles = useBackdropResetStyles();
    const backdropStyles = useBackdropStyles();
    if (state.backdrop) {
        state.backdrop.className = (0, _react.mergeClasses)(backdropResetStyles, state.isNestedDialog && backdropStyles.nested, state.backdrop.className);
    }
    return state;
};
