'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    inlineDrawerClassNames: function() {
        return inlineDrawerClassNames;
    },
    useInlineDrawerStyles_unstable: function() {
        return useInlineDrawerStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _useDrawerBaseStylesstyles = require("../../shared/useDrawerBaseStyles.styles");
const inlineDrawerClassNames = {
    root: 'fui-InlineDrawer'
};
const useDrawerResetStyles = (0, _react.makeResetStyles)({
    ..._useDrawerBaseStylesstyles.drawerDefaultStyles,
    position: 'relative'
});
/**
 * Styles for the root slot
 */ const borderValue = `1px solid ${_reacttheme.tokens.colorNeutralBackground3}`;
const useDrawerRootStyles = (0, _react.makeStyles)({
    /* Separator */ separatorStart: {
        borderRight: borderValue
    },
    separatorEnd: {
        borderLeft: borderValue
    },
    separatorBottom: {
        borderTop: borderValue
    },
    /* Positioning */ start: {},
    end: {},
    bottom: {
        width: '100%',
        height: `var(${_useDrawerBaseStylesstyles.drawerCSSVars.drawerSizeVar})`
    }
});
function getSeparatorClass(state, classNames) {
    if (!state.separator) {
        return undefined;
    }
    switch(state.position){
        case 'start':
            return classNames.separatorStart;
        case 'end':
            return classNames.separatorEnd;
        case 'bottom':
            return classNames.separatorBottom;
        default:
            return undefined;
    }
}
const useInlineDrawerStyles_unstable = (state)=>{
    'use no memo';
    const resetStyles = useDrawerResetStyles();
    const baseClassNames = (0, _useDrawerBaseStylesstyles.useDrawerBaseClassNames)(state);
    const rootStyles = useDrawerRootStyles();
    state.root.className = (0, _react.mergeClasses)(inlineDrawerClassNames.root, resetStyles, baseClassNames, getSeparatorClass(state, rootStyles), rootStyles[state.position], state.root.className);
    return state;
};
