'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    drawerHeaderTitleClassNames: function() {
        return drawerHeaderTitleClassNames;
    },
    useDrawerHeaderTitleStyles_unstable: function() {
        return useDrawerHeaderTitleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reactdialog = require("@fluentui/react-dialog");
const _reacttheme = require("@fluentui/react-theme");
const drawerHeaderTitleClassNames = {
    root: 'fui-DrawerHeaderTitle',
    heading: 'fui-DrawerHeaderTitle__heading',
    action: 'fui-DrawerHeaderTitle__action'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        justifyContent: 'space-between',
        alignItems: 'center',
        columnGap: _reacttheme.tokens.spacingHorizontalS
    },
    action: {
        marginRight: `calc(${_reacttheme.tokens.spacingHorizontalS} * -1)`
    }
});
const useDrawerHeaderTitleStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { heading: root = {}, action, // but there's no way to retrieve the element type of a slot from the slot definition
    // right now without using SLOT_ELEMENT_TYPE_SYMBOL
    // TODO: create a method to retrieve the element type of a slot
    // eslint-disable-next-line @typescript-eslint/no-deprecated
    components } = state;
    (0, _reactdialog.useDialogTitleStyles_unstable)({
        components: {
            root: components.heading,
            action: components.action
        },
        root,
        action
    });
    state.root.className = (0, _react.mergeClasses)(drawerHeaderTitleClassNames.root, styles.root, state.root.className);
    if (state.heading) {
        state.heading.className = (0, _react.mergeClasses)(drawerHeaderTitleClassNames.heading, state.heading.className);
    }
    if (state.action) {
        state.action.className = (0, _react.mergeClasses)(drawerHeaderTitleClassNames.action, styles.action, state.action.className);
    }
    return state;
};
