'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDrawerHeaderTitle_unstable", {
    enumerable: true,
    get: function() {
        return useDrawerHeaderTitle_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactdialog = require("@fluentui/react-dialog");
const useDrawerHeaderTitle_unstable = (props, ref)=>{
    const { children, heading } = props;
    const headingId = (0, _reactdialog.useDialogContext_unstable)((ctx)=>ctx.dialogTitleId);
    return {
        components: {
            root: 'div',
            heading: 'h2',
            action: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            ...props
        }), {
            elementType: 'div'
        }),
        heading: _reactutilities.slot.optional(heading, {
            defaultProps: {
                id: headingId,
                children
            },
            renderByDefault: true,
            elementType: 'h2'
        }),
        action: _reactutilities.slot.optional(props.action, {
            elementType: 'div'
        })
    };
};
