'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    drawerHeaderClassNames: function() {
        return drawerHeaderClassNames;
    },
    useDrawerHeaderStyles_unstable: function() {
        return useDrawerHeaderStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _drawerSeparatorStyles = require("../../shared/drawerSeparatorStyles");
const drawerHeaderClassNames = {
    root: 'fui-DrawerHeader'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeResetStyles)({
    width: '100%',
    maxWidth: '100%',
    padding: `${_reacttheme.tokens.spacingVerticalXXL} ${_reacttheme.tokens.spacingHorizontalXXL} ${_reacttheme.tokens.spacingVerticalS}`,
    gap: _reacttheme.tokens.spacingHorizontalS,
    alignSelf: 'stretch',
    display: 'flex',
    flexDirection: 'column',
    boxSizing: 'border-box',
    position: 'relative',
    zIndex: 2
});
const useDrawerHeaderStyles = (0, _react.makeStyles)({
    separator: {
        '::after': {
            ..._drawerSeparatorStyles.drawerSeparatorStyles,
            bottom: 0
        }
    },
    separatorVisible: {
        '::after': {
            opacity: 1
        }
    }
});
const useDrawerHeaderStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const rootStyles = useDrawerHeaderStyles();
    state.root.className = (0, _react.mergeClasses)(drawerHeaderClassNames.root, styles, state.scrollState !== 'none' && rootStyles.separator, [
        'middle',
        'bottom'
    ].includes(state.scrollState) && rootStyles.separatorVisible, state.root.className);
    return state;
};
