'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    drawerFooterClassNames: function() {
        return drawerFooterClassNames;
    },
    useDrawerFooterStyles_unstable: function() {
        return useDrawerFooterStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _drawerSeparatorStyles = require("../../shared/drawerSeparatorStyles");
const drawerFooterClassNames = {
    root: 'fui-DrawerFooter'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeResetStyles)({
    width: '100%',
    maxWidth: '100%',
    padding: `${_reacttheme.tokens.spacingVerticalL} ${_reacttheme.tokens.spacingHorizontalXXL} ${_reacttheme.tokens.spacingVerticalXXL}`,
    display: 'flex',
    justifyContent: 'flex-start',
    alignItems: 'center',
    columnGap: _reacttheme.tokens.spacingHorizontalS,
    boxSizing: 'border-box',
    position: 'relative',
    zIndex: 2
});
const useDrawerFooterStyles = (0, _react.makeStyles)({
    separator: {
        '::before': {
            ..._drawerSeparatorStyles.drawerSeparatorStyles,
            top: 0
        }
    },
    separatorVisible: {
        '::before': {
            opacity: 1
        }
    }
});
const useDrawerFooterStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const rootStyles = useDrawerFooterStyles();
    state.root.className = (0, _react.mergeClasses)(drawerFooterClassNames.root, styles, state.scrollState !== 'none' && rootStyles.separator, [
        'middle',
        'top'
    ].includes(state.scrollState) && rootStyles.separatorVisible, state.root.className);
    return state;
};
