'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    drawerBodyClassNames: function() {
        return drawerBodyClassNames;
    },
    useDrawerBodyStyles_unstable: function() {
        return useDrawerBodyStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const drawerBodyClassNames = {
    root: 'fui-DrawerBody'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeResetStyles)({
    padding: `0 ${_reacttheme.tokens.spacingHorizontalXXL}`,
    flex: 1,
    alignSelf: 'stretch',
    position: 'relative',
    zIndex: 1,
    overflow: 'auto',
    ':last-child': {
        paddingBottom: `calc(${_reacttheme.tokens.spacingHorizontalXXL} + 1px)`
    },
    ':first-child': {
        paddingTop: `calc(${_reacttheme.tokens.spacingHorizontalXXL} + 1px)`
    }
});
const useDrawerBodyStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(drawerBodyClassNames.root, styles, state.root.className);
    return state;
};
