import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { DialogProps } from '@fluentui/react-dialog';
import type { DialogSurfaceProps } from '@fluentui/react-dialog';
import type { DialogSurfaceSlots } from '@fluentui/react-dialog';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import type { PresenceMotionSlotProps } from '@fluentui/react-motion';
import { ProviderContextValue_unstable } from '@fluentui/react-shared-contexts';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Drawer contains supplementary content and are used for complex creation, edit, or management experiences.
 */
export declare const Drawer: ForwardRefComponent<DrawerProps>;

declare type DrawerBaseProps = {
    /**
     * Position of the drawer.
     *
     * Note: 'bottom' does not supports size, but it supports customized height.
     *
     * @default 'start'
     */
    position?: 'start' | 'end' | 'bottom';
    /**
     * Size of the drawer.
     *
     * - 'small' - Drawer is 320px wide.
     * - 'medium' - Drawer is 592px wide.
     * - 'large' - Drawer is 940px wide.
     * - 'full' - Drawer is 100vw wide.
     *
     * @default 'small'
     */
    size?: 'small' | 'medium' | 'large' | 'full';
    /**
     * Controls the open state of the Drawer
     *
     * @default false
     */
    open?: boolean;
};

declare type DrawerBaseState = Required<Pick<DrawerBaseProps, 'position' | 'size'>> & {
    /**
     * @deprecated Passed values will be static.
     */
    motion: MotionState<HTMLElement>;
    open?: boolean;
};

/**
 * DrawerBody provides with a container for the main content of a Drawer.
 */
export declare const DrawerBody: ForwardRefComponent<DrawerBodyProps>;

export declare const drawerBodyClassNames: SlotClassNames<DrawerBodySlots>;

/**
 * DrawerBody Props
 */
export declare type DrawerBodyProps = ComponentProps<DrawerBodySlots>;

export declare type DrawerBodySlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering DrawerBody
 */
export declare type DrawerBodyState = ComponentState<DrawerBodySlots>;

export declare type DrawerContextValue = {
    scrollState: DrawerScrollState;
    setScrollState: (scrollState: DrawerScrollState) => void;
};

/**
 * DrawerFooter provides a structured footer for the drawer component.
 */
export declare const DrawerFooter: ForwardRefComponent<DrawerFooterProps>;

export declare const drawerFooterClassNames: SlotClassNames<DrawerFooterSlots>;

/**
 * DrawerFooter Props
 */
export declare type DrawerFooterProps = ComponentProps<DrawerFooterSlots>;

export declare type DrawerFooterSlots = {
    root: Slot<'footer'>;
};

/**
 * State used in rendering DrawerFooter
 */
export declare type DrawerFooterState = ComponentState<DrawerFooterSlots> & {
    scrollState: DrawerScrollState;
};

/**
 * DrawerHeader provides a structured header for the drawer component.
 */
export declare const DrawerHeader: ForwardRefComponent<DrawerHeaderProps>;

export declare const drawerHeaderClassNames: SlotClassNames<DrawerHeaderSlots>;

/**
 * DrawerHeaderNavigation provides a header navigation area for the Drawer.
 */
export declare const DrawerHeaderNavigation: ForwardRefComponent<DrawerHeaderNavigationProps>;

export declare const drawerHeaderNavigationClassNames: SlotClassNames<DrawerHeaderNavigationSlots>;

/**
 * DrawerHeaderNavigation Props
 */
export declare type DrawerHeaderNavigationProps = ComponentProps<DrawerHeaderNavigationSlots>;

export declare type DrawerHeaderNavigationSlots = {
    root: Slot<'nav'>;
};

/**
 * State used in rendering DrawerHeaderNavigation
 */
export declare type DrawerHeaderNavigationState = ComponentState<DrawerHeaderNavigationSlots>;

/**
 * DrawerHeader Props
 */
export declare type DrawerHeaderProps = ComponentProps<DrawerHeaderSlots>;

export declare type DrawerHeaderSlots = {
    /**
     * The root of the DrawerHeader.
     */
    root: Slot<'header'>;
};

/**
 * State used in rendering DrawerHeader
 */
export declare type DrawerHeaderState = ComponentState<DrawerHeaderSlots> & {
    scrollState: DrawerScrollState;
};

/**
 * DrawerHeader provides a structured header for the drawer component.
 */
export declare const DrawerHeaderTitle: ForwardRefComponent<DrawerHeaderTitleProps>;

export declare const drawerHeaderTitleClassNames: SlotClassNames<DrawerHeaderTitleSlots>;

/**
 * DrawerHeaderTitle Props
 */
export declare type DrawerHeaderTitleProps = ComponentProps<DrawerHeaderTitleSlots>;

export declare type DrawerHeaderTitleSlots = {
    root: Slot<'div'>;
    /**
     * By default this is a h2, but can be any heading or div.
     * If `div` is provided do not forget to also provide proper `role="heading"` and `aria-level` attributes
     */
    heading?: Slot<'h2', 'h1' | 'h3' | 'h4' | 'h5' | 'h6' | 'div'>;
    /**
     * Action slot for the close button
     */
    action?: Slot<'div'>;
};

/**
 * State used in rendering DrawerHeaderTitle
 */
export declare type DrawerHeaderTitleState = ComponentState<DrawerHeaderTitleSlots>;

declare type DrawerMotionParams = Required<Pick<DrawerBaseProps, 'size' | 'position'> & Pick<ProviderContextValue_unstable, 'dir'>>;

/**
 * Drawer Props
 */
export declare type DrawerProps = ComponentProps<DrawerSlots> & {
    /**
     * Type of the drawer.
     *
     * - 'overlay' - Drawer is hidden by default and can be opened by clicking on the trigger.
     * - 'inline' - Drawer is stacked with the content
     *
     * @default overlay
     */
    type?: 'inline' | 'overlay';
} & (OverlayDrawerProps | InlineDrawerProps);

export declare const DrawerProvider: React_2.Provider<DrawerContextValue | undefined>;

declare type DrawerScrollState = 'none' | 'top' | 'middle' | 'bottom';

export declare type DrawerSlots = Pick<OverlayDrawerSlots, 'root'> | Pick<InlineDrawerSlots, 'root'>;

/**
 * State used in rendering Drawer
 */
export declare type DrawerState = ComponentState<DrawerSlots>;

/**
 * InlineDrawer is often used for navigation that is not dismissible. As it is on the same level as
 * the main surface, users can still interact with other UI elements.
 */
export declare const InlineDrawer: ForwardRefComponent<InlineDrawerProps>;

export declare const inlineDrawerClassNames: SlotClassNames<Omit<InlineDrawerSlots, 'surfaceMotion'>>;

/**
 * InlineDrawer Props
 */
export declare type InlineDrawerProps = ComponentProps<InlineDrawerSlots> & DrawerBaseProps & {
    /**
     * Whether the drawer has a separator line.
     *
     * @default false
     */
    separator?: boolean;
};

export declare type InlineDrawerSlots = {
    root: Slot<'div', 'aside'>;
    surfaceMotion?: Slot<SurfaceMotionSlotProps>;
};

/**
 * State used in rendering InlineDrawer
 */
export declare type InlineDrawerState = Required<ComponentState<NonNullable<InlineDrawerSlots>> & DrawerBaseState & Pick<InlineDrawerProps, 'separator'>>;

declare type MotionState<Element extends HTMLElement = HTMLElement> = {
    /**
     * Ref to the element.
     */
    ref: React_2.Ref<Element>;
    /**
     * Current state of the element.
     *
     * - `unmounted` - The element is not yet rendered or can be safely removed from the DOM.
     * - `entering` - The element is performing enter animation.
     * - `entered` - The element has finished enter animation.
     * - `idle` - The element is currently not animating, but rendered on screen.
     * - `exiting` - The element is performing exit animation.
     * - `exited` - The element has finished exit animation.
     */
    type: MotionType;
    /**
     * Indicates whether the component can be rendered.
     * Useful to render the element before animating it or to remove it from the DOM after exit animation.
     */
    canRender: boolean;
    /**
     * Indicates whether the component is ready to receive a CSS transition className.
     * Useful to apply CSS transitions when the element is mounted and ready to be animated.
     */
    active: boolean;
};

declare type MotionType = 'entering' | 'entered' | 'idle' | 'exiting' | 'exited' | 'unmounted';

/**
 * OverlayDrawer contains supplementary content and are used for complex creation, edit, or management experiences.
 */
export declare const OverlayDrawer: ForwardRefComponent<OverlayDrawerProps>;

export declare const overlayDrawerClassNames: SlotClassNames<Omit<OverlayDrawerSurfaceSlots, 'backdropMotion'>>;

/**
 * OverlayDrawer internal slots for when using with composition API
 */
declare type OverlayDrawerInternalSlots = Pick<OverlayDrawerSlots, 'root'> & {
    /**
     * Slot for the dialog component that wraps the drawer.
     */
    dialog: NonNullable<Slot<DialogProps>>;
};

/**
 * OverlayDrawer Props
 */
export declare type OverlayDrawerProps = ComponentProps<OverlayDrawerSlots> & Pick<DialogProps, 'modalType' | 'onOpenChange' | 'inertTrapFocus'> & DrawerBaseProps & {
    /**
     * @deprecated OverlayDrawer can work only as a controlled component
     * and does not support uncontrolled mode i.e. defaultOpen prop
     */
    defaultOpen?: boolean;
};

/**
 * OverlayDrawer slots
 */
export declare type OverlayDrawerSlots = {
    /**
     * Slot for the root element.
     */
    root: Slot<OverlayDrawerSurfaceProps>;
    /**
     * For more information refer to the [Motion docs page](https://react.fluentui.dev/?path=/docs/motion-motion-slot--docs).
     *
     */
    backdropMotion?: Slot<PresenceMotionSlotProps<OverlayDrawerSurfaceMotionParams>>;
    /**
     * For more information refer to the [Motion docs page](https://react.fluentui.dev/?path=/docs/motion-motion-slot--docs).
     *
     */
    surfaceMotion?: Slot<PresenceMotionSlotProps<DrawerMotionParams>>;
};

/**
 * State used in rendering OverlayDrawer
 */
export declare type OverlayDrawerState = ComponentState<OverlayDrawerInternalSlots> & Required<DrawerBaseState> & Pick<OverlayDrawerProps, 'mountNode'> & {
    hasMountNodeElement: boolean;
};

declare type OverlayDrawerSurfaceMotionParams = Required<Pick<DrawerBaseProps, 'size'>>;

/**
 * OverlayDrawerSurface Props
 */
declare type OverlayDrawerSurfaceProps = ComponentProps<OverlayDrawerSurfaceSlots> & Pick<DialogSurfaceProps, 'mountNode'>;

/**
 * OverlayDrawerSurface slots
 */
declare type OverlayDrawerSurfaceSlots = Partial<Pick<DialogSurfaceSlots, 'backdrop' | 'backdropMotion'>> & {
    root: Slot<'div', 'aside'>;
};

/**
 * Render the final JSX of Drawer
 */
export declare const renderDrawer_unstable: (state: DrawerState, contextValue: DrawerContextValue) => JSXElement;

/**
 * Render the final JSX of DrawerBody
 */
export declare const renderDrawerBody_unstable: (state: DrawerBodyState) => JSXElement;

/**
 * Render the final JSX of DrawerFooter
 */
export declare const renderDrawerFooter_unstable: (state: DrawerFooterState) => JSXElement;

/**
 * Render the final JSX of DrawerHeader
 */
export declare const renderDrawerHeader_unstable: (state: DrawerHeaderState) => JSXElement;

/**
 * Render the final JSX of DrawerHeaderNavigation
 */
export declare const renderDrawerHeaderNavigation_unstable: (state: DrawerHeaderNavigationState) => JSXElement;

/**
 * Render the final JSX of DrawerHeaderTitle
 */
export declare const renderDrawerHeaderTitle_unstable: (state: DrawerHeaderTitleState) => JSXElement;

/**
 * Render the final JSX of InlineDrawer
 */
export declare const renderInlineDrawer_unstable: (state: InlineDrawerState, contextValue: DrawerContextValue) => JSXElement;

/**
 * Render the final JSX of OverlayDrawer
 */
export declare const renderOverlayDrawer_unstable: (state: OverlayDrawerState, contextValue: DrawerContextValue) => JSXElement;

declare type SurfaceMotionSlotProps = PresenceMotionSlotProps<DrawerMotionParams>;

/**
 * Create the state required to render Drawer.
 *
 * The returned state can be modified with hooks such as useDrawerStyles_unstable,
 * before being passed to renderDrawer_unstable.
 *
 * @param props - props from this instance of Drawer
 * @param ref - reference to root HTMLElement of Drawer
 */
export declare const useDrawer_unstable: (props: DrawerProps, ref: React_2.Ref<HTMLElement>) => DrawerState;

/**
 * Create the state required to render DrawerBody.
 *
 * The returned state can be modified with hooks such as useDrawerBodyStyles_unstable,
 * before being passed to renderDrawerBody_unstable.
 *
 * @param props - props from this instance of DrawerBody
 * @param ref - reference to root HTMLElement of DrawerBody
 */
export declare const useDrawerBody_unstable: (props: DrawerBodyProps, ref: React_2.Ref<HTMLElement>) => DrawerBodyState;

/**
 * Apply styling to the DrawerBody slots based on the state
 */
export declare const useDrawerBodyStyles_unstable: (state: DrawerBodyState) => DrawerBodyState;

export declare const useDrawerContext_unstable: () => DrawerContextValue;

export declare const useDrawerContextValue: () => DrawerContextValue;

/**
 * Create the state required to render DrawerFooter.
 *
 * The returned state can be modified with hooks such as useDrawerFooterStyles_unstable,
 * before being passed to renderDrawerFooter_unstable.
 *
 * @param props - props from this instance of DrawerFooter
 * @param ref - reference to root HTMLElement of DrawerFooter
 */
export declare const useDrawerFooter_unstable: (props: DrawerFooterProps, ref: React_2.Ref<HTMLElement>) => DrawerFooterState;

/**
 * Apply styling to the DrawerFooter slots based on the state
 */
export declare const useDrawerFooterStyles_unstable: (state: DrawerFooterState) => DrawerFooterState;

/**
 * Create the state required to render DrawerHeader.
 *
 * The returned state can be modified with hooks such as useDrawerHeaderStyles_unstable,
 * before being passed to renderDrawerHeader_unstable.
 *
 * @param props - props from this instance of DrawerHeader
 * @param ref - reference to root HTMLElement of DrawerHeader
 */
export declare const useDrawerHeader_unstable: (props: DrawerHeaderProps, ref: React_2.Ref<HTMLElement>) => DrawerHeaderState;

/**
 * Create the state required to render DrawerHeaderNavigation.
 *
 * The returned state can be modified with hooks such as useDrawerHeaderNavigationStyles_unstable,
 * before being passed to renderDrawerHeaderNavigation_unstable.
 *
 * @param props - props from this instance of DrawerHeaderNavigation
 * @param ref - reference to root HTMLElement of DrawerHeaderNavigation
 */
export declare const useDrawerHeaderNavigation_unstable: (props: DrawerHeaderNavigationProps, ref: React_2.Ref<HTMLElement>) => DrawerHeaderNavigationState;

/**
 * Apply styling to the DrawerHeaderNavigation slots based on the state
 */
export declare const useDrawerHeaderNavigationStyles_unstable: (state: DrawerHeaderNavigationState) => DrawerHeaderNavigationState;

/**
 * Apply styling to the DrawerHeader slots based on the state
 */
export declare const useDrawerHeaderStyles_unstable: (state: DrawerHeaderState) => DrawerHeaderState;

/**
 * Create the state required to render DrawerHeaderTitle.
 *
 * The returned state can be modified with hooks such as useDrawerHeaderTitleStyles_unstable,
 * before being passed to renderDrawerHeaderTitle_unstable.
 *
 * @param props - props from this instance of DrawerHeaderTitle
 * @param ref - reference to root HTMLElement of DrawerHeaderTitle
 */
export declare const useDrawerHeaderTitle_unstable: (props: DrawerHeaderTitleProps, ref: React_2.Ref<HTMLDivElement>) => DrawerHeaderTitleState;

/**
 * Apply styling to the DrawerHeaderTitle slots based on the state
 */
export declare const useDrawerHeaderTitleStyles_unstable: (state: DrawerHeaderTitleState) => DrawerHeaderTitleState;

/**
 * Apply styling to the Drawer slots based on the state
 */
export declare const useDrawerStyles_unstable: (state: DrawerState) => DrawerState;

/**
 * Create the state required to render InlineDrawer.
 *
 * The returned state can be modified with hooks such as useInlineDrawerStyles_unstable,
 * before being passed to renderInlineDrawer_unstable.
 *
 * @param props - props from this instance of InlineDrawer
 * @param ref - reference to root HTMLElement of InlineDrawer
 */
export declare const useInlineDrawer_unstable: (props: InlineDrawerProps, ref: React_2.Ref<HTMLElement>) => InlineDrawerState;

/**
 * Apply styling to the InlineDrawer slots based on the state
 */
export declare const useInlineDrawerStyles_unstable: (state: InlineDrawerState) => InlineDrawerState;

/**
 * Create the state required to render OverlayDrawer.
 *
 * The returned state can be modified with hooks such as useOverlayDrawerStyles_unstable,
 * before being passed to renderOverlayDrawer_unstable.
 *
 * @param props - props from this instance of OverlayDrawer
 * @param ref - reference to root HTMLElement of OverlayDrawer
 */
export declare const useOverlayDrawer_unstable: (props: OverlayDrawerProps, ref: React_2.Ref<HTMLElement>) => OverlayDrawerState;

/**
 * Apply styling to the OverlayDrawer slots based on the state
 */
export declare const useOverlayDrawerStyles_unstable: (state: OverlayDrawerState) => OverlayDrawerState;

export { }
