'use client';
import * as React from 'react';
import { renderDivider_unstable } from './renderDivider';
import { useDivider_unstable } from './useDivider';
import { useDividerStyles_unstable } from './useDividerStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * A divider visually segments content into groups.
 */ export const Divider = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useDivider_unstable(props, ref);
    useDividerStyles_unstable(state);
    useCustomStyleHook_unstable('useDividerStyles_unstable')(state);
    return renderDivider_unstable(state);
});
Divider.displayName = 'Divider';
