'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dividerClassNames: function() {
        return dividerClassNames;
    },
    useDividerStyles_unstable: function() {
        return useDividerStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const dividerClassNames = {
    root: 'fui-Divider',
    wrapper: 'fui-Divider__wrapper'
};
const contentSpacing = '12px';
const insetSpacing = '12px';
const maxStartEndLength = '8px';
const minStartEndLength = '8px;';
const useBaseStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        alignItems: 'center',
        boxSizing: 'border-box',
        display: 'flex',
        flexDirection: 'row',
        flexGrow: 1,
        position: 'relative',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        fontSize: _reacttheme.tokens.fontSizeBase200,
        fontWeight: _reacttheme.tokens.fontWeightRegular,
        lineHeight: _reacttheme.tokens.lineHeightBase200,
        textAlign: 'center',
        '::before': {
            boxSizing: 'border-box',
            display: 'flex',
            flexGrow: 1
        },
        '::after': {
            boxSizing: 'border-box',
            display: 'flex',
            flexGrow: 1
        }
    },
    // Childless styles
    childless: {
        '::before': {
            marginBottom: 0,
            marginRight: 0
        },
        '::after': {
            marginLeft: 0,
            marginTop: 0
        }
    },
    // Alignment variations
    start: {
        '::after': {
            content: '""'
        }
    },
    center: {
        '::before': {
            content: '""'
        },
        '::after': {
            content: '""'
        }
    },
    end: {
        '::before': {
            content: '""'
        }
    },
    // Appearance variations
    brand: {
        color: _reacttheme.tokens.colorBrandForeground1,
        '::before': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorBrandStroke1)
        },
        '::after': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorBrandStroke1)
        }
    },
    default: {
        color: _reacttheme.tokens.colorNeutralForeground2,
        '::before': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke2)
        },
        '::after': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke2)
        }
    },
    subtle: {
        color: _reacttheme.tokens.colorNeutralForeground3,
        '::before': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke3)
        },
        '::after': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke3)
        }
    },
    strong: {
        color: _reacttheme.tokens.colorNeutralForeground1,
        '::before': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1)
        },
        '::after': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1)
        }
    }
});
const useHorizontalStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        width: '100%',
        '::before': {
            borderTopStyle: 'solid',
            borderTopWidth: _reacttheme.tokens.strokeWidthThin,
            minWidth: minStartEndLength
        },
        '::after': {
            borderTopStyle: 'solid',
            borderTopWidth: _reacttheme.tokens.strokeWidthThin,
            minWidth: minStartEndLength
        }
    },
    // Inset styles
    inset: {
        paddingLeft: insetSpacing,
        paddingRight: insetSpacing
    },
    // Alignment variations
    start: {
        textAlign: 'left',
        '::before': {
            content: '""',
            marginRight: contentSpacing,
            maxWidth: maxStartEndLength
        },
        '::after': {
            marginLeft: contentSpacing
        }
    },
    center: {
        textAlign: 'center',
        '::before': {
            marginRight: contentSpacing
        },
        '::after': {
            marginLeft: contentSpacing
        }
    },
    end: {
        textAlign: 'right',
        '::before': {
            marginRight: contentSpacing
        },
        '::after': {
            content: '""',
            marginLeft: contentSpacing,
            maxWidth: maxStartEndLength
        }
    }
});
const useVerticalStyles = (0, _react.makeStyles)({
    // Base styles
    base: {
        flexDirection: 'column',
        minHeight: '20px',
        '::before': {
            borderRightStyle: 'solid',
            borderRightWidth: _reacttheme.tokens.strokeWidthThin,
            minHeight: minStartEndLength
        },
        '::after': {
            borderRightStyle: 'solid',
            borderRightWidth: _reacttheme.tokens.strokeWidthThin,
            minHeight: minStartEndLength
        }
    },
    // Inset styles
    inset: {
        marginTop: insetSpacing,
        marginBottom: insetSpacing
    },
    // With children styles
    withChildren: {
        minHeight: '84px'
    },
    // Alignment variations
    start: {
        '::before': {
            content: '""',
            marginBottom: contentSpacing,
            maxHeight: maxStartEndLength
        },
        '::after': {
            marginTop: contentSpacing
        }
    },
    center: {
        '::before': {
            marginBottom: contentSpacing
        },
        '::after': {
            marginTop: contentSpacing
        }
    },
    end: {
        '::before': {
            marginBottom: contentSpacing
        },
        '::after': {
            content: '""',
            marginTop: contentSpacing,
            maxHeight: maxStartEndLength
        }
    }
});
const useDividerStyles_unstable = (state)=>{
    'use no memo';
    const baseStyles = useBaseStyles();
    const horizontalStyles = useHorizontalStyles();
    const verticalStyles = useVerticalStyles();
    const { alignContent, appearance, inset, vertical } = state;
    state.root.className = (0, _react.mergeClasses)(dividerClassNames.root, baseStyles.base, baseStyles[alignContent], appearance && baseStyles[appearance], !vertical && horizontalStyles.base, !vertical && inset && horizontalStyles.inset, !vertical && horizontalStyles[alignContent], vertical && verticalStyles.base, vertical && inset && verticalStyles.inset, vertical && verticalStyles[alignContent], vertical && state.root.children !== undefined && verticalStyles.withChildren, state.root.children === undefined && baseStyles.childless, state.root.className);
    if (state.wrapper) {
        state.wrapper.className = (0, _react.mergeClasses)(dividerClassNames.wrapper, state.wrapper.className);
    }
    return state;
};
