import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * A divider visually segments content into groups.
 */
export declare const Divider: ForwardRefComponent<DividerProps>;

export declare const dividerClassNames: SlotClassNames<DividerSlots>;

export declare type DividerProps = ComponentProps<Partial<DividerSlots>> & {
    /**
     * Determines the alignment of the content within the divider.
     *
     * @default 'center'
     */
    alignContent?: 'start' | 'center' | 'end';
    /**
     * A divider can have one of the preset appearances.
     * When not specified, the divider has its default appearance.
     *
     * @default 'default'
     */
    appearance?: 'brand' | 'default' | 'strong' | 'subtle';
    /**
     * Adds padding to the beginning and end of the divider.
     *
     * @default false
     */
    inset?: boolean;
    /**
     * A divider can be horizontal (default) or vertical.
     *
     * @default false
     */
    vertical?: boolean;
};

export declare type DividerSlots = {
    /**
     * Root of the component that renders as a `<div>` tag.
     */
    root: NonNullable<Slot<'div'>>;
    /**
     * Wrapper for content when presented.
     */
    wrapper: NonNullable<Slot<'div'>>;
};

export declare type DividerState = ComponentState<DividerSlots> & Required<Pick<DividerProps, 'alignContent' | 'appearance' | 'inset' | 'vertical'>>;

/**
 * Renders a Divider component by passing the slot props (defined in `state`) to the appropriate slots.
 */
export declare const renderDivider_unstable: (state: DividerState) => JSXElement;

/**
 * Returns the props and state required to render the component
 * @param props - User-provided props to the Divider component.
 * @param ref - User-provided ref to be passed to the Divider component.
 */
export declare const useDivider_unstable: (props: DividerProps, ref: React_2.Ref<HTMLElement>) => DividerState;

export declare const useDividerStyles_unstable: (state: DividerState) => DividerState;

export { }
