'use client';
import * as React from 'react';
import { useFluent_unstable } from '@fluentui/react-shared-contexts';
import { useBodyNoScrollStyles, useHTMLNoScrollStyles } from './useDisableBodyScroll.styles';
/**
 * @internal
 * A React *hook* that disables body scrolling through `overflowY: hidden` CSS property
 */ export function useDisableBodyScroll() {
    const htmlNoScrollStyles = useHTMLNoScrollStyles();
    const bodyNoScrollStyles = useBodyNoScrollStyles();
    const { targetDocument } = useFluent_unstable();
    const disableBodyScroll = React.useCallback(()=>{
        var _targetDocument_defaultView;
        if (!targetDocument) {
            return;
        }
        var _targetDocument_defaultView_innerHeight;
        const isHorizontalScrollbarVisible = // When the window is a fractional height, `innerHeight` always rounds down but `clientHeight` rounds either up or down depending on the value.
        // To properly compare the body clientHeight to the window innerHeight, manually round down the fractional value to match innerHeight's calculation.
        Math.floor(targetDocument.body.getBoundingClientRect().height) > ((_targetDocument_defaultView_innerHeight = (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.innerHeight) !== null && _targetDocument_defaultView_innerHeight !== void 0 ? _targetDocument_defaultView_innerHeight : 0);
        if (!isHorizontalScrollbarVisible) {
            return;
        }
        targetDocument.documentElement.classList.add(htmlNoScrollStyles);
        targetDocument.body.classList.add(bodyNoScrollStyles);
        return;
    }, [
        targetDocument,
        htmlNoScrollStyles,
        bodyNoScrollStyles
    ]);
    const enableBodyScroll = React.useCallback(()=>{
        if (!targetDocument) {
            return;
        }
        targetDocument.documentElement.classList.remove(htmlNoScrollStyles);
        targetDocument.body.classList.remove(bodyNoScrollStyles);
    }, [
        targetDocument,
        htmlNoScrollStyles,
        bodyNoScrollStyles
    ]);
    return {
        disableBodyScroll,
        enableBodyScroll
    };
}
