'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { createFocusOutlineStyle } from '@fluentui/react-tabster';
import { DIALOG_FULLSCREEN_DIALOG_SCROLLBAR_OFFSET, DIALOG_MEDIA_QUERY_BREAKPOINT_SELECTOR, DIALOG_MEDIA_QUERY_SHORT_SCREEN, SURFACE_BORDER_WIDTH, SURFACE_PADDING } from '../../contexts';
export const dialogSurfaceClassNames = {
  root: 'fui-DialogSurface',
  backdrop: 'fui-DialogSurface__backdrop'
};
/**
 * Styles for the root slot
 */
const useRootBaseStyle = /*#__PURE__*/__resetStyles("r1u3t6p6", "r5coedp", {
  r: [".r1u3t6p6{inset:0;padding:24px;margin:auto;border-style:none;overflow:unset;border:1px solid var(--colorTransparentStroke);border-radius:var(--borderRadiusXLarge);display:block;-webkit-user-select:unset;-moz-user-select:unset;user-select:unset;visibility:unset;position:fixed;height:fit-content;max-width:600px;max-height:100vh;max-height:100dvh;box-sizing:border-box;background-color:var(--colorNeutralBackground1);color:var(--colorNeutralForeground1);box-shadow:var(--shadow64);}", ".r1u3t6p6:focus{outline-style:none;}", ".r1u3t6p6:focus-visible{outline-style:none;}", ".r1u3t6p6[data-fui-focus-visible]{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}", ".r1u3t6p6[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}", ".r5coedp{inset:0;padding:24px;margin:auto;border-style:none;overflow:unset;border:1px solid var(--colorTransparentStroke);border-radius:var(--borderRadiusXLarge);display:block;-webkit-user-select:unset;-moz-user-select:unset;user-select:unset;visibility:unset;position:fixed;height:fit-content;max-width:600px;max-height:100vh;max-height:100dvh;box-sizing:border-box;background-color:var(--colorNeutralBackground1);color:var(--colorNeutralForeground1);box-shadow:var(--shadow64);}", ".r5coedp:focus{outline-style:none;}", ".r5coedp:focus-visible{outline-style:none;}", ".r5coedp[data-fui-focus-visible]{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}", ".r5coedp[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}"],
  s: ["@media (forced-colors: active){.r1u3t6p6[data-fui-focus-visible]::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}", "@media screen and (max-width: 480px){.r1u3t6p6{max-width:100vw;}}", "@media screen and (max-height: 359px){.r1u3t6p6{overflow-y:auto;padding-right:calc(24px - 4px);border-right-width:4px;border-top-width:4px;border-bottom-width:4px;}}", "@media (forced-colors: active){.r5coedp[data-fui-focus-visible]::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}", "@media screen and (max-width: 480px){.r5coedp{max-width:100vw;}}", "@media screen and (max-height: 359px){.r5coedp{overflow-y:auto;padding-left:calc(24px - 4px);border-left-width:4px;border-top-width:4px;border-bottom-width:4px;}}"]
});
const useBackdropBaseStyle = /*#__PURE__*/__resetStyles("r1e18s3l", null, [".r1e18s3l{inset:0px;background-color:var(--colorBackgroundOverlay);position:fixed;}"]);
const useStyles = /*#__PURE__*/__styles({
  nestedDialogBackdrop: {
    De3pzq: "f1c21dwh"
  },
  dialogHidden: {
    Bkecrkj: "f1aehjj5"
  }
}, {
  d: [".f1c21dwh{background-color:var(--colorTransparentBackground);}", ".f1aehjj5{pointer-events:none;}"]
});
/**
 * Apply styling to the DialogSurface slots based on the state
 */
export const useDialogSurfaceStyles_unstable = state => {
  'use no memo';

  const {
    isNestedDialog,
    root,
    backdrop,
    open,
    unmountOnClose
  } = state;
  const rootBaseStyle = useRootBaseStyle();
  const backdropBaseStyle = useBackdropBaseStyle();
  const styles = useStyles();
  const mountedAndClosed = !unmountOnClose && !open;
  root.className = mergeClasses(dialogSurfaceClassNames.root, rootBaseStyle, mountedAndClosed && styles.dialogHidden, root.className);
  if (backdrop) {
    backdrop.className = mergeClasses(dialogSurfaceClassNames.backdrop, backdropBaseStyle, isNestedDialog && styles.nestedDialogBackdrop, mountedAndClosed && styles.dialogHidden, backdrop.className);
  }
  return state;
};