'use client';

import { __resetStyles, mergeClasses } from '@griffel/react';
import { tokens, typographyStyles } from '@fluentui/react-theme';
import { DIALOG_MEDIA_QUERY_SHORT_SCREEN } from '../../contexts';
export const dialogContentClassNames = {
  root: 'fui-DialogContent'
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__resetStyles("r1v5zwsm", null, {
  r: [".r1v5zwsm{padding:var(--strokeWidthThick);margin:calc(var(--strokeWidthThick) * -1);font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);overflow-y:auto;min-height:32px;box-sizing:border-box;grid-row-start:2;grid-row-end:2;grid-column-start:1;grid-column-end:4;}"],
  s: ["@media screen and (max-height: 359px){.r1v5zwsm{overflow-y:unset;}}"]
});
/**
 * Apply styling to the DialogContent slots based on the state
 */
export const useDialogContentStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  state.root.className = mergeClasses(dialogContentClassNames.root, styles, state.root.className);
  return state;
};