'use client';

import { __resetStyles, mergeClasses } from '@griffel/react';
import { DIALOG_GAP, DIALOG_MEDIA_QUERY_BREAKPOINT_SELECTOR, DIALOG_MEDIA_QUERY_SHORT_SCREEN, SURFACE_PADDING } from '../../contexts';
export const dialogBodyClassNames = {
  root: 'fui-DialogBody'
};
/**
 * Styles for the root slot
 */
const useResetStyles = /*#__PURE__*/__resetStyles("rhwx3p8", null, {
  r: [".rhwx3p8{overflow:unset;gap:8px;display:grid;max-height:calc(100vh - 2 * 24px);max-height:calc(100dvh - 2 * 24px);box-sizing:border-box;grid-template-rows:auto 1fr;grid-template-columns:1fr 1fr auto;}"],
  s: ["@media screen and (max-width: 480px){.rhwx3p8{max-width:100vw;grid-template-rows:auto 1fr auto;}}", "@media screen and (max-height: 359px){.rhwx3p8{max-height:unset;}}"]
});
/**
 * Apply styling to the DialogBody slots based on the state
 */
export const useDialogBodyStyles_unstable = state => {
  'use no memo';

  const resetStyles = useResetStyles();
  state.root.className = mergeClasses(dialogBodyClassNames.root, resetStyles, state.root.className);
  return state;
};