'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFocusFirstElement", {
    enumerable: true,
    get: function() {
        return useFocusFirstElement;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttabster = require("@fluentui/react-tabster");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
function useFocusFirstElement(open, modalType) {
    const { findFirstFocusable } = (0, _reacttabster.useFocusFinders)();
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const dialogRef = _react.useRef(null);
    _react.useEffect(()=>{
        if (!open) {
            return;
        }
        const element = dialogRef.current && findFirstFocusable(dialogRef.current);
        if (element) {
            element.focus();
        } else {
            var _dialogRef_current;
            (_dialogRef_current = dialogRef.current) === null || _dialogRef_current === void 0 ? void 0 : _dialogRef_current.focus(); // https://github.com/microsoft/fluentui/issues/25150
            if (process.env.NODE_ENV === 'development') {
                // eslint-disable-next-line no-console
                console.warn(`@fluentui/react-dialog [useFocusFirstElement]:
A Dialog should have at least one focusable element inside DialogSurface.
Please add at least a close button either on \`DialogTitle\` action slot or inside \`DialogActions\``);
            }
        }
    }, [
        findFirstFocusable,
        open,
        modalType,
        targetDocument
    ]);
    return dialogRef;
}
