'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDisableBodyScroll", {
    enumerable: true,
    get: function() {
        return useDisableBodyScroll;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useDisableBodyScrollstyles = require("./useDisableBodyScroll.styles");
function useDisableBodyScroll() {
    const htmlNoScrollStyles = (0, _useDisableBodyScrollstyles.useHTMLNoScrollStyles)();
    const bodyNoScrollStyles = (0, _useDisableBodyScrollstyles.useBodyNoScrollStyles)();
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const disableBodyScroll = _react.useCallback(()=>{
        var _targetDocument_defaultView;
        if (!targetDocument) {
            return;
        }
        var _targetDocument_defaultView_innerHeight;
        const isHorizontalScrollbarVisible = // To properly compare the body clientHeight to the window innerHeight, manually round down the fractional value to match innerHeight's calculation.
        Math.floor(targetDocument.body.getBoundingClientRect().height) > ((_targetDocument_defaultView_innerHeight = (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.innerHeight) !== null && _targetDocument_defaultView_innerHeight !== void 0 ? _targetDocument_defaultView_innerHeight : 0);
        if (!isHorizontalScrollbarVisible) {
            return;
        }
        targetDocument.documentElement.classList.add(htmlNoScrollStyles);
        targetDocument.body.classList.add(bodyNoScrollStyles);
        return;
    }, [
        targetDocument,
        htmlNoScrollStyles,
        bodyNoScrollStyles
    ]);
    const enableBodyScroll = _react.useCallback(()=>{
        if (!targetDocument) {
            return;
        }
        targetDocument.documentElement.classList.remove(htmlNoScrollStyles);
        targetDocument.body.classList.remove(bodyNoScrollStyles);
    }, [
        targetDocument,
        htmlNoScrollStyles,
        bodyNoScrollStyles
    ]);
    return {
        disableBodyScroll,
        enableBodyScroll
    };
}
