'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDialogTrigger_unstable", {
    enumerable: true,
    get: function() {
        return useDialogTrigger_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _contexts = require("../../contexts");
const _reactaria = require("@fluentui/react-aria");
const _reacttabster = require("@fluentui/react-tabster");
const useDialogTrigger_unstable = (props)=>{
    const isInsideSurfaceDialog = (0, _contexts.useDialogSurfaceContext_unstable)();
    const { children, disableButtonEnhancement = false, action = isInsideSurfaceDialog ? 'close' : 'open' } = props;
    const child = (0, _reactutilities.getTriggerChild)(children);
    const requestOpenChange = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.requestOpenChange);
    const { triggerAttributes } = (0, _reacttabster.useModalAttributes)();
    const handleClick = (0, _reactutilities.useEventCallback)((event)=>{
        var _child_props_onClick, _child_props;
        child === null || child === void 0 ? void 0 : (_child_props_onClick = (_child_props = child.props).onClick) === null || _child_props_onClick === void 0 ? void 0 : _child_props_onClick.call(_child_props, event);
        if (!event.isDefaultPrevented()) {
            requestOpenChange({
                event,
                type: 'triggerClick',
                open: action === 'open'
            });
        }
    });
    const triggerChildProps = {
        ...child === null || child === void 0 ? void 0 : child.props,
        ref: (0, _reactutilities.getReactElementRef)(child),
        onClick: handleClick,
        ...triggerAttributes
    };
    const ariaButtonTriggerChildProps = (0, _reactaria.useARIAButtonProps)((child === null || child === void 0 ? void 0 : child.type) === 'button' || (child === null || child === void 0 ? void 0 : child.type) === 'a' ? child.type : 'div', {
        ...triggerChildProps,
        type: 'button'
    });
    return {
        children: (0, _reactutilities.applyTriggerPropsToChildren)(children, disableButtonEnhancement ? triggerChildProps : ariaButtonTriggerChildProps)
    };
};
