'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dialogTitleClassNames: function() {
        return dialogTitleClassNames;
    },
    useDialogTitleInternalStyles: function() {
        return useDialogTitleInternalStyles;
    },
    useDialogTitleStyles_unstable: function() {
        return useDialogTitleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const dialogTitleClassNames = {
    root: 'fui-DialogTitle',
    action: 'fui-DialogTitle__action'
};
/**
 * Styles for the root slot
 */ const useRootResetStyles = (0, _react.makeResetStyles)({
    ..._reacttheme.typographyStyles.subtitle1,
    margin: 0,
    gridRowStart: 1,
    gridRowEnd: 1,
    gridColumnStart: 1,
    gridColumnEnd: 3
});
const useStyles = (0, _react.makeStyles)({
    rootWithoutAction: {
        gridColumnEnd: 4
    }
});
/**
 * Styles for the action slot
 */ const useActionResetStyles = (0, _react.makeResetStyles)({
    gridRowStart: 1,
    gridRowEnd: 1,
    gridColumnStart: 3,
    justifySelf: 'end',
    alignSelf: 'start'
});
const useDialogTitleInternalStyles = (0, _react.makeResetStyles)({
    ...(0, _reacttabster.createFocusOutlineStyle)(),
    overflow: 'visible',
    padding: 0,
    borderStyle: 'none',
    position: 'relative',
    boxSizing: 'content-box',
    backgroundColor: 'inherit',
    color: 'inherit',
    fontFamily: 'inherit',
    fontSize: 'inherit',
    cursor: 'pointer',
    lineHeight: 0,
    WebkitAppearance: 'button',
    textAlign: 'unset'
});
const useDialogTitleStyles_unstable = (state)=>{
    'use no memo';
    const rootResetStyles = useRootResetStyles();
    const actionResetStyles = useActionResetStyles();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(dialogTitleClassNames.root, rootResetStyles, !state.action && styles.rootWithoutAction, state.root.className);
    if (state.action) {
        state.action.className = (0, _react.mergeClasses)(dialogTitleClassNames.action, actionResetStyles, state.action.className);
    }
    return state;
};
