'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dialogTitleClassNames: function() {
        return dialogTitleClassNames;
    },
    useDialogTitleInternalStyles: function() {
        return useDialogTitleInternalStyles;
    },
    useDialogTitleStyles_unstable: function() {
        return useDialogTitleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const dialogTitleClassNames = {
    root: 'fui-DialogTitle',
    action: 'fui-DialogTitle__action'
};
/**
 * Styles for the root slot
 */ const useRootResetStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rxjm636", null, [
    ".rxjm636{font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase500);font-weight:var(--fontWeightSemibold);line-height:var(--lineHeightBase500);margin:0;grid-row-start:1;grid-row-end:1;grid-column-start:1;grid-column-end:3;}"
]);
const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    rootWithoutAction: {
        Bw0ie65: "fsyjsko"
    }
}, {
    d: [
        ".fsyjsko{grid-column-end:4;}"
    ]
});
/**
 * Styles for the action slot
 */ const useActionResetStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r13kcrze", null, [
    ".r13kcrze{grid-row-start:1;grid-row-end:1;grid-column-start:3;justify-self:end;align-self:start;}"
]);
const useDialogTitleInternalStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r2avt6e", "roj2bbc", {
    r: [
        ".r2avt6e{overflow:visible;padding:0;border-style:none;position:relative;box-sizing:content-box;background-color:inherit;color:inherit;font-family:inherit;font-size:inherit;cursor:pointer;line-height:0;-webkit-appearance:button;text-align:unset;}",
        ".r2avt6e:focus{outline-style:none;}",
        ".r2avt6e:focus-visible{outline-style:none;}",
        ".r2avt6e[data-fui-focus-visible]{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}",
        ".r2avt6e[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}",
        ".roj2bbc{overflow:visible;padding:0;border-style:none;position:relative;box-sizing:content-box;background-color:inherit;color:inherit;font-family:inherit;font-size:inherit;cursor:pointer;line-height:0;-webkit-appearance:button;text-align:unset;}",
        ".roj2bbc:focus{outline-style:none;}",
        ".roj2bbc:focus-visible{outline-style:none;}",
        ".roj2bbc[data-fui-focus-visible]{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}",
        ".roj2bbc[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}"
    ],
    s: [
        "@media (forced-colors: active){.r2avt6e[data-fui-focus-visible]::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}",
        "@media (forced-colors: active){.roj2bbc[data-fui-focus-visible]::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}"
    ]
});
const useDialogTitleStyles_unstable = (state)=>{
    'use no memo';
    const rootResetStyles = useRootResetStyles();
    const actionResetStyles = useActionResetStyles();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(dialogTitleClassNames.root, rootResetStyles, !state.action && styles.rootWithoutAction, state.root.className);
    if (state.action) {
        state.action.className = (0, _react.mergeClasses)(dialogTitleClassNames.action, actionResetStyles, state.action.className);
    }
    return state;
};
