'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDialogTitle_unstable", {
    enumerable: true,
    get: function() {
        return useDialogTitle_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _dialogContext = require("../../contexts/dialogContext");
const _reacticons = require("@fluentui/react-icons");
const _DialogTrigger = require("../DialogTrigger/DialogTrigger");
const _useDialogTitleStylesstyles = require("./useDialogTitleStyles.styles");
const useDialogTitle_unstable = (props, ref)=>{
    const { action } = props;
    const modalType = (0, _dialogContext.useDialogContext_unstable)((ctx)=>ctx.modalType);
    const internalStyles = (0, _useDialogTitleStylesstyles.useDialogTitleInternalStyles)();
    return {
        components: {
            root: 'h2',
            action: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('h2', {
            ref,
            id: (0, _dialogContext.useDialogContext_unstable)((ctx)=>ctx.dialogTitleId),
            ...props
        }), {
            elementType: 'h2'
        }),
        action: _reactutilities.slot.optional(action, {
            renderByDefault: modalType === 'non-modal',
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(_DialogTrigger.DialogTrigger, {
                    disableButtonEnhancement: true,
                    action: "close"
                }, /*#__PURE__*/ _react.createElement("button", {
                    type: "button",
                    className: internalStyles,
                    // TODO: find a better way to add internal labels
                    "aria-label": "close"
                }, /*#__PURE__*/ _react.createElement(_reacticons.Dismiss20Regular, null)))
            },
            elementType: 'div'
        })
    };
};
