'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDialogSurface_unstable", {
    enumerable: true,
    get: function() {
        return useDialogSurface_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reactmotion = require("@fluentui/react-motion");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _contexts = require("../../contexts");
const _useDisableBodyScroll = require("../../utils/useDisableBodyScroll");
const _DialogBackdropMotion = require("../DialogBackdropMotion");
const _MotionRefForwarder = require("../MotionRefForwarder");
const useDialogSurface_unstable = (props, ref)=>{
    const contextRef = (0, _MotionRefForwarder.useMotionForwardedRef)();
    const modalType = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.modalType);
    const isNestedDialog = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.isNestedDialog);
    const modalAttributes = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.modalAttributes);
    const dialogRef = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.dialogRef);
    const requestOpenChange = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.requestOpenChange);
    const dialogTitleID = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.dialogTitleId);
    const open = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.open);
    const unmountOnClose = (0, _contexts.useDialogContext_unstable)((ctx)=>ctx.unmountOnClose);
    const handledBackdropClick = (0, _reactutilities.useEventCallback)((event)=>{
        if ((0, _reactutilities.isResolvedShorthand)(props.backdrop)) {
            var _props_backdrop_onClick, _props_backdrop;
            (_props_backdrop_onClick = (_props_backdrop = props.backdrop).onClick) === null || _props_backdrop_onClick === void 0 ? void 0 : _props_backdrop_onClick.call(_props_backdrop, event);
        }
        if (modalType === 'modal' && !event.isDefaultPrevented()) {
            requestOpenChange({
                event,
                open: false,
                type: 'backdropClick'
            });
        }
    });
    const handleKeyDown = (0, _reactutilities.useEventCallback)((event)=>{
        var _props_onKeyDown;
        (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, event);
        if (event.key === _keyboardkeys.Escape && !event.isDefaultPrevented()) {
            requestOpenChange({
                event,
                open: false,
                type: 'escapeKeyDown'
            });
            // stop propagation to avoid conflicting with other elements that listen for `Escape`
            // e,g: nested Dialog, Popover, Menu and Tooltip
            event.preventDefault();
        }
    });
    const backdrop = _reactutilities.slot.optional(props.backdrop, {
        renderByDefault: modalType !== 'non-modal',
        defaultProps: {
            'aria-hidden': 'true'
        },
        elementType: 'div'
    });
    if (backdrop) {
        backdrop.onClick = handledBackdropClick;
    }
    const { disableBodyScroll, enableBodyScroll } = (0, _useDisableBodyScroll.useDisableBodyScroll)();
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        if (!open) {
            enableBodyScroll();
            return;
        }
        if (isNestedDialog || modalType === 'non-modal') {
            return;
        }
        disableBodyScroll();
        return ()=>enableBodyScroll();
    }, [
        open,
        modalType,
        isNestedDialog,
        disableBodyScroll,
        enableBodyScroll
    ]);
    return {
        components: {
            backdrop: 'div',
            root: 'div',
            backdropMotion: _DialogBackdropMotion.DialogBackdropMotion
        },
        open,
        backdrop,
        isNestedDialog,
        unmountOnClose,
        mountNode: props.mountNode,
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            tabIndex: -1,
            role: modalType === 'alert' ? 'alertdialog' : 'dialog',
            'aria-modal': modalType !== 'non-modal',
            'aria-labelledby': props['aria-label'] ? undefined : dialogTitleID,
            'aria-hidden': !unmountOnClose && !open ? true : undefined,
            ...props,
            ...modalAttributes,
            onKeyDown: handleKeyDown,
            // FIXME:
            // `DialogSurfaceElement` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, contextRef, dialogRef)
        }), {
            elementType: 'div'
        }),
        backdropMotion: (0, _reactmotion.presenceMotionSlot)(props.backdropMotion, {
            elementType: _DialogBackdropMotion.DialogBackdropMotion,
            defaultProps: {
                appear: unmountOnClose,
                visible: open
            }
        }),
        // Deprecated properties
        transitionStatus: undefined
    };
};
