'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dialogContentClassNames: function() {
        return dialogContentClassNames;
    },
    useDialogContentStyles_unstable: function() {
        return useDialogContentStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _contexts = require("../../contexts");
const dialogContentClassNames = {
    root: 'fui-DialogContent'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeResetStyles)({
    padding: _reacttheme.tokens.strokeWidthThick,
    margin: `calc(${_reacttheme.tokens.strokeWidthThick} * -1)`,
    ..._reacttheme.typographyStyles.body1,
    overflowY: 'auto',
    minHeight: '32px',
    boxSizing: 'border-box',
    gridRowStart: 2,
    gridRowEnd: 2,
    gridColumnStart: 1,
    gridColumnEnd: 4,
    [_contexts.DIALOG_MEDIA_QUERY_SHORT_SCREEN]: {
        overflowY: 'unset'
    }
});
const useDialogContentStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(dialogContentClassNames.root, styles, state.root.className);
    return state;
};
