'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dialogBodyClassNames: function() {
        return dialogBodyClassNames;
    },
    useDialogBodyStyles_unstable: function() {
        return useDialogBodyStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _contexts = require("../../contexts");
const dialogBodyClassNames = {
    root: 'fui-DialogBody'
};
/**
 * Styles for the root slot
 */ const useResetStyles = (0, _react.makeResetStyles)({
    overflow: 'unset',
    gap: _contexts.DIALOG_GAP,
    display: 'grid',
    maxHeight: [
        `calc(100vh - 2 * ${_contexts.SURFACE_PADDING})`,
        `calc(100dvh - 2 * ${_contexts.SURFACE_PADDING})`
    ],
    boxSizing: 'border-box',
    gridTemplateRows: 'auto 1fr',
    gridTemplateColumns: '1fr 1fr auto',
    [_contexts.DIALOG_MEDIA_QUERY_BREAKPOINT_SELECTOR]: {
        maxWidth: '100vw',
        gridTemplateRows: 'auto 1fr auto'
    },
    [_contexts.DIALOG_MEDIA_QUERY_SHORT_SCREEN]: {
        maxHeight: 'unset'
    }
});
const useDialogBodyStyles_unstable = (state)=>{
    'use no memo';
    const resetStyles = useResetStyles();
    state.root.className = (0, _react.mergeClasses)(dialogBodyClassNames.root, resetStyles, state.root.className);
    return state;
};
