'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dialogActionsClassNames: function() {
        return dialogActionsClassNames;
    },
    useDialogActionsStyles_unstable: function() {
        return useDialogActionsStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _constants = require("../../contexts/constants");
const dialogActionsClassNames = {
    root: 'fui-DialogActions'
};
/**
 * Styles for the root slot
 */ const useResetStyles = (0, _react.makeResetStyles)({
    gap: _constants.DIALOG_GAP,
    height: 'fit-content',
    boxSizing: 'border-box',
    display: 'flex',
    gridRowStart: 3,
    gridRowEnd: 3,
    [_constants.DIALOG_MEDIA_QUERY_BREAKPOINT_SELECTOR]: {
        flexDirection: 'column',
        justifySelf: 'stretch'
    }
});
const useStyles = (0, _react.makeStyles)({
    gridPositionEnd: {
        justifySelf: 'end',
        gridColumnStart: 2,
        gridColumnEnd: 4,
        [_constants.DIALOG_MEDIA_QUERY_BREAKPOINT_SELECTOR]: {
            gridColumnStart: 1,
            gridRowStart: 4,
            gridRowEnd: 'auto'
        }
    },
    gridPositionStart: {
        justifySelf: 'start',
        gridColumnStart: 1,
        gridColumnEnd: 2,
        [_constants.DIALOG_MEDIA_QUERY_BREAKPOINT_SELECTOR]: {
            gridColumnEnd: 4,
            gridRowStart: 3,
            gridRowEnd: 'auto'
        }
    },
    fluidStart: {
        gridColumnEnd: 4
    },
    fluidEnd: {
        gridColumnStart: 1
    }
});
const useDialogActionsStyles_unstable = (state)=>{
    'use no memo';
    const resetStyles = useResetStyles();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(dialogActionsClassNames.root, resetStyles, state.position === 'start' && styles.gridPositionStart, state.position === 'end' && styles.gridPositionEnd, state.fluid && state.position === 'start' && styles.fluidStart, state.fluid && state.position === 'end' && styles.fluidEnd, state.root.className);
    return state;
};
