'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDialog_unstable", {
    enumerable: true,
    get: function() {
        return useDialog_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactcontextselector = require("@fluentui/react-context-selector");
const _reacttabster = require("@fluentui/react-tabster");
const _reactmotion = require("@fluentui/react-motion");
const _reactutilities = require("@fluentui/react-utilities");
const _utils = require("../../utils");
const _contexts = require("../../contexts");
const _DialogSurfaceMotion = require("../DialogSurfaceMotion");
const useDialog_unstable = (props)=>{
    const { children, modalType = 'modal', onOpenChange, inertTrapFocus = false, unmountOnClose = true } = props;
    const dialogTitleId = (0, _reactutilities.useId)('dialog-title-');
    const [trigger, content] = childrenToTriggerAndContent(children);
    const [open, setOpen] = (0, _reactutilities.useControllableState)({
        state: props.open,
        defaultState: props.defaultOpen,
        initialState: false
    });
    const requestOpenChange = (0, _reactutilities.useEventCallback)((data)=>{
        onOpenChange === null || onOpenChange === void 0 ? void 0 : onOpenChange(data.event, data);
        // if user prevents default then do not change state value
        // otherwise updates state value and trigger reference to the element that caused the opening
        if (!data.event.isDefaultPrevented()) {
            setOpen(data.open);
        }
    });
    const dialogRef = (0, _utils.useFocusFirstElement)(open, modalType);
    const { modalAttributes, triggerAttributes } = (0, _reacttabster.useModalAttributes)({
        trapFocus: modalType !== 'non-modal',
        legacyTrapFocus: !inertTrapFocus
    });
    const isNestedDialog = (0, _reactcontextselector.useHasParentContext)(_contexts.DialogContext);
    return {
        components: {
            surfaceMotion: _DialogSurfaceMotion.DialogSurfaceMotion
        },
        inertTrapFocus,
        open,
        modalType,
        content,
        trigger,
        requestOpenChange,
        dialogTitleId,
        isNestedDialog,
        unmountOnClose,
        dialogRef,
        modalAttributes,
        triggerAttributes,
        surfaceMotion: (0, _reactmotion.presenceMotionSlot)(props.surfaceMotion, {
            elementType: _DialogSurfaceMotion.DialogSurfaceMotion,
            defaultProps: {
                visible: open,
                appear: unmountOnClose,
                unmountOnExit: unmountOnClose
            }
        })
    };
};
/**
 * Extracts trigger and content from children
 */ function childrenToTriggerAndContent(children) {
    const childrenArray = _react.Children.toArray(children);
    if (process.env.NODE_ENV !== 'production') {
        if (childrenArray.length !== 1 && childrenArray.length !== 2) {
            // eslint-disable-next-line no-console
            console.warn(`@fluentui/react-dialog [useDialog]:
Dialog must contain at least one child <DialogSurface/>,
and at most two children <DialogTrigger/> <DialogSurface/> (in this order).`);
        }
    }
    switch(childrenArray.length){
        // case where there's a trigger followed by content
        case 2:
            return childrenArray;
        // case where there's only content
        case 1:
            return [
                undefined,
                childrenArray[0]
            ];
        // unknown case
        default:
            return [
                undefined,
                undefined
            ];
    }
}
