import { ARIAButtonResultProps } from '@fluentui/react-aria';
import { ARIAButtonType } from '@fluentui/react-aria';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import { ContextSelector } from '@fluentui/react-context-selector';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import type { PortalProps } from '@fluentui/react-portal';
import type { PresenceMotionSlotProps } from '@fluentui/react-motion';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';
import type { TriggerProps } from '@fluentui/react-utilities';
import { useModalAttributes } from '@fluentui/react-tabster';

/**
 * The `Dialog` root level component serves as an interface for interaction with all possible behaviors exposed.
 * It provides context down the hierarchy to `children` compound components to allow functionality.
 * This component expects to receive as children either a `DialogSurface` or a `DialogTrigger`
 * and a `DialogSurface` (or some component that will eventually render one of those compound components)
 * in this specific order
 */
export declare const Dialog: React_2.FC<DialogProps>;

export declare const DIALOG_FULLSCREEN_DIALOG_SCROLLBAR_OFFSET = "4px";

export declare const DIALOG_MEDIA_QUERY_BREAKPOINT_SELECTOR = "@media screen and (max-width: 480px)";

export declare const DIALOG_MEDIA_QUERY_SHORT_SCREEN = "@media screen and (max-height: 359px)";

/**
 * `DialogActions` is a container for the actions of the dialog.
 * Apart from styling, this component does not have other behavior.
 */
export declare const DialogActions: ForwardRefComponent<DialogActionsProps>;

export declare const dialogActionsClassNames: SlotClassNames<DialogActionsSlots>;

export declare type DialogActionsPosition = 'start' | 'end';

/**
 * DialogActions Props
 */
export declare type DialogActionsProps = ComponentProps<DialogActionsSlots> & {
    /**
     * defines the position on the dialog grid of the actions
     * @default 'end'
     */
    position?: DialogActionsPosition;
    /**
     * Makes the actions expand the entire width of the DialogBody
     * @default false
     */
    fluid?: boolean;
};

export declare type DialogActionsSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering DialogActions
 */
export declare type DialogActionsState = ComponentState<DialogActionsSlots> & Pick<Required<DialogActionsProps>, 'position' | 'fluid'>;

/**
 * The `DialogBody` is a container where the content of the dialog is rendered.
 * Apart from styling, this component does not have other behavior.
 */
export declare const DialogBody: ForwardRefComponent<DialogBodyProps>;

export declare const dialogBodyClassNames: SlotClassNames<DialogBodySlots>;

/**
 * DialogBody Props
 */
export declare type DialogBodyProps = ComponentProps<DialogBodySlots> & {};

export declare type DialogBodySlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering DialogBody
 */
export declare type DialogBodyState = ComponentState<DialogBodySlots>;

/**
 * The `DialogContent` is a container where the content of the dialog is rendered.
 * Apart from styling, this component does not have other behavior.
 */
export declare const DialogContent: ForwardRefComponent<DialogContentProps>;

export declare const dialogContentClassNames: SlotClassNames<DialogContentSlots>;

/**
 * DialogContent Props
 */
export declare type DialogContentProps = ComponentProps<DialogContentSlots>;

export declare type DialogContentSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering DialogContent
 */
export declare type DialogContentState = ComponentState<DialogContentSlots>;

export declare type DialogContextValue = {
    open: boolean;
    inertTrapFocus: boolean;
    dialogTitleId?: string;
    isNestedDialog: boolean;
    dialogRef: React_2.Ref<DialogSurfaceElement | null>;
    unmountOnClose?: boolean;
    modalType: DialogModalType;
    /**
     * Requests dialog main component to update it's internal open state
     */
    requestOpenChange: (data: DialogOpenChangeData) => void;
} & Partial<ReturnType<typeof useModalAttributes>>;

export declare type DialogContextValues = {
    dialog: DialogContextValue;
    /**
     * dialogSurface context is provided by Dialog as false
     * to ensure components inside Dialog but outside DialogSurface will consume this as false
     */
    dialogSurface: DialogSurfaceContextValue;
};

export declare type DialogModalType = 'modal' | 'non-modal' | 'alert';

export declare type DialogOpenChangeData = {
    type: 'escapeKeyDown';
    open: boolean;
    event: React_2.KeyboardEvent<DialogSurfaceElement>;
} | {
    type: 'backdropClick';
    open: boolean;
    event: React_2.MouseEvent<DialogSurfaceElement>;
} | {
    type: 'triggerClick';
    open: boolean;
    event: React_2.MouseEvent<DialogSurfaceElement>;
};

export declare type DialogOpenChangeEvent = DialogOpenChangeData['event'];

/**
 * Callback fired when the component changes value from open state.
 *
 * @param event - a React's Synthetic event or a KeyboardEvent in case of `documentEscapeKeyDown`
 * @param data - A data object with relevant information,
 * such as open value and type of interaction that created the event
 */
export declare type DialogOpenChangeEventHandler = (event: DialogOpenChangeEvent, data: DialogOpenChangeData) => void;

export declare type DialogProps = ComponentProps<Partial<DialogSlots>> & {
    /**
     * Dialog variations.
     *
     * `modal`: When this type of dialog is open, the rest of the page is dimmed out and cannot be interacted with.
     * The tab sequence is kept within the dialog and moving the focus outside
     * the dialog will imply closing it. This is the default type of the component.
     *
     * `non-modal`: When a non-modal dialog is open, the rest of the page is not dimmed out
     * and users can interact with the rest of the page.
     * This also implies that the tab focus can move outside the dialog when it reaches the last focusable element.
     *
     * `alert`: is a special type of modal dialogs that interrupts the user's workflow
     * to communicate an important message or ask for a decision.
     * Unlike a typical modal dialog, the user must take an action through the options given to dismiss the dialog,
     * and it cannot be dismissed through the dimmed background.
     *
     * @default modal
     */
    modalType?: DialogModalType;
    /**
     * Controls the open state of the dialog
     * @default false
     */
    open?: boolean;
    /**
     * Default value for the uncontrolled open state of the dialog.
     * @default false
     */
    defaultOpen?: boolean;
    /**
     * Callback fired when the component changes value from open state.
     *
     * @param event - a React's Synthetic event or a KeyboardEvent in case of `documentEscapeKeyDown`
     * @param data - A data object with relevant information,
     * such as open value and type of interaction that created the event
     */
    onOpenChange?: DialogOpenChangeEventHandler;
    /**
     * Can contain two children including `DialogTrigger` and `DialogSurface`.
     * Alternatively can only contain `DialogSurface` if using trigger outside dialog, or controlling state.
     */
    children: [JSXElement, JSXElement] | JSXElement;
    /**
     * Enables standard behavior according to the [HTML dialog spec](https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement/showModal)
     * where the focus trap involves setting outside elements inert.
     *
     * @default false
     */
    inertTrapFocus?: boolean;
    /**
     * Decides whether the dialog should be removed from the DOM tree when it is closed.
     * This can be useful when dealing with components that may contain state that should not
     * be reset when the dialog is closed.
     *
     * @default true
     */
    unmountOnClose?: boolean;
};

export declare const DialogProvider: React_2.Provider<DialogContextValue | undefined> & React_2.FC<React_2.ProviderProps<DialogContextValue | undefined>>;

export declare type DialogSlots = {
    /**
     * For more information refer to the [Motion docs page](https://react.fluentui.dev/?path=/docs/motion-motion-slot--docs).
     *
     */
    surfaceMotion: Slot<PresenceMotionSlotProps>;
};

export declare type DialogState = ComponentState<InternalDialogSlots> & DialogContextValue & {
    content: React_2.ReactNode;
    trigger: React_2.ReactNode;
};

/**
 * DialogSurface component represents the visual part of a `Dialog` as a whole,
 * it contains everything that should be visible.
 */
export declare const DialogSurface: ForwardRefComponent<DialogSurfaceProps>;

export declare const dialogSurfaceClassNames: SlotClassNames<Omit<DialogSurfaceSlots, 'backdropMotion'>>;

export declare type DialogSurfaceContextValue = boolean;

export declare type DialogSurfaceContextValues = {
    dialogSurface: DialogSurfaceContextValue;
};

/**
 * Union between all possible semantic element that represent a DialogSurface
 */
export declare type DialogSurfaceElement = HTMLElement;

/**
 * DialogSurface Props
 */
export declare type DialogSurfaceProps = ComponentProps<Partial<DialogSurfaceSlots>> & Pick<PortalProps, 'mountNode'>;

export declare const DialogSurfaceProvider: React_2.Provider<boolean | undefined>;

export declare type DialogSurfaceSlots = {
    /**
     * Dimmed background of dialog.
     * The default backdrop is rendered as a `<div>` with styling.
     * This slot expects a `<div>` element which will replace the default backdrop.
     * The backdrop should have `aria-hidden="true"`.
     *
     */
    backdrop?: Slot<'div'>;
    root: Slot<'div'>;
    /**
     * For more information refer to the [Motion docs page](https://react.fluentui.dev/?path=/docs/motion-motion-slot--docs).
     *
     */
    backdropMotion: Slot<PresenceMotionSlotProps>;
};

/**
 * State used in rendering DialogSurface
 */
export declare type DialogSurfaceState = ComponentState<DialogSurfaceSlots> & Pick<DialogContextValue, 'isNestedDialog'> & Pick<PortalProps, 'mountNode'> & {
    open?: boolean;
    unmountOnClose?: boolean;
    /**
     * Transition status for animation.
     * In test environment, this is always `undefined`.
     *
     * @deprecated Will be always `undefined`.
     */
    transitionStatus?: 'entering' | 'entered' | 'idle' | 'exiting' | 'exited' | 'unmounted';
};

/**
 * The `DialogTitle` component expects to have a title/header
 * and when `Dialog` is `non-modal` a close (X icon) button is provided through `action` slot by default.
 */
export declare const DialogTitle: ForwardRefComponent<DialogTitleProps>;

export declare const dialogTitleClassNames: SlotClassNames<DialogTitleSlots>;

/**
 * DialogTitle Props
 */
export declare type DialogTitleProps = ComponentProps<DialogTitleSlots>;

export declare type DialogTitleSlots = {
    /**
     * By default this is a h2, but can be any heading or div,
     * if `div` is provided do not forget to also provide proper `role="heading"` and `aria-level` attributes
     */
    root: Slot<'h2', 'h1' | 'h3' | 'h4' | 'h5' | 'h6' | 'div'>;
    /**
     * By default a Dialog with modalType='non-modal' will have a close button action
     */
    action?: Slot<'div'>;
};

/**
 * State used in rendering DialogTitle
 */
export declare type DialogTitleState = ComponentState<DialogTitleSlots>;

/**
 * A non-visual component that wraps its child
 * and configures them to be the trigger that will open or close a `Dialog`.
 * This component should only accept one child.
 *
 * This component sole purpose is to avoid opting out of the internal controlled open state of a `Dialog`
 * Besides being a trigger that opens/close a dialog through context this component doesn't do much,
 * making it basically unnecessary in cases where the trigger is outside of the `Dialog` component.
 */
export declare const DialogTrigger: React_2.FC<DialogTriggerProps>;

export declare type DialogTriggerAction = 'open' | 'close';

/**
 * Props that are passed to the child of the DialogTrigger when cloned to ensure correct behaviour for the Dialog
 */
export declare type DialogTriggerChildProps<Type extends ARIAButtonType = ARIAButtonType, Props = {}> = ARIAButtonResultProps<Type, Props & {
    'aria-haspopup'?: 'dialog';
}>;

export declare type DialogTriggerProps = TriggerProps<DialogTriggerChildProps> & {
    /**
     * Explicitly declare if the trigger is responsible for opening or
     * closing a Dialog visibility state.
     *
     * If `DialogTrigger` is outside `DialogSurface` then it'll be `open` by default
     *
     * If `DialogTrigger` is inside `DialogSurface` then it'll be `close` by default
     */
    action?: DialogTriggerAction;
    /**
     * Disables internal trigger mechanism that ensures a child provided will be a compliant ARIA button.
     * @default false
     */
    disableButtonEnhancement?: boolean;
};

export declare type DialogTriggerState = {
    children: React_2.ReactElement | null;
};

declare type InternalDialogSlots = {
    surfaceMotion: NonNullable<Slot<PresenceMotionSlotProps>>;
};

/**
 * Render the final JSX of Dialog
 */
export declare const renderDialog_unstable: (state: DialogState, contextValues: DialogContextValues) => JSXElement;

/**
 * Render the final JSX of DialogActions
 */
export declare const renderDialogActions_unstable: (state: DialogActionsState) => JSXElement;

/**
 * Render the final JSX of DialogBody
 */
export declare const renderDialogBody_unstable: (state: DialogBodyState) => JSXElement;

/**
 * Render the final JSX of DialogContent
 */
export declare const renderDialogContent_unstable: (state: DialogContentState) => JSXElement;

/**
 * Render the final JSX of DialogSurface
 */
export declare const renderDialogSurface_unstable: (state: DialogSurfaceState, contextValues: DialogSurfaceContextValues) => JSXElement;

/**
 * Render the final JSX of DialogTitle
 */
export declare const renderDialogTitle_unstable: (state: DialogTitleState) => JSXElement;

/**
 * Render the final JSX of MenuTrigger
 *
 * Only renders children
 */
export declare const renderDialogTrigger_unstable: (state: DialogTriggerState) => JSXElement | null;

/**
 * Create the state required to render Dialog.
 *
 * The returned state can be modified with hooks such as useDialogStyles_unstable,
 * before being passed to renderDialog_unstable.
 *
 * @param props - props from this instance of Dialog
 */
export declare const useDialog_unstable: (props: DialogProps) => DialogState;

/**
 * Create the state required to render DialogActions.
 *
 * The returned state can be modified with hooks such as useDialogActionsStyles_unstable,
 * before being passed to renderDialogActions_unstable.
 *
 * @param props - props from this instance of DialogActions
 * @param ref - reference to root HTMLElement of DialogActions
 */
export declare const useDialogActions_unstable: (props: DialogActionsProps, ref: React_2.Ref<HTMLElement>) => DialogActionsState;

/**
 * Apply styling to the DialogActions slots based on the state
 */
export declare const useDialogActionsStyles_unstable: (state: DialogActionsState) => DialogActionsState;

/**
 * Create the state required to render DialogBody.
 *
 * The returned state can be modified with hooks such as useDialogBodyStyles_unstable,
 * before being passed to renderDialogBody_unstable.
 *
 * @param props - props from this instance of DialogBody
 * @param ref - reference to root HTMLElement of DialogBody
 */
export declare const useDialogBody_unstable: (props: DialogBodyProps, ref: React_2.Ref<HTMLElement>) => DialogBodyState;

/**
 * Apply styling to the DialogBody slots based on the state
 */
export declare const useDialogBodyStyles_unstable: (state: DialogBodyState) => DialogBodyState;

/**
 * Create the state required to render DialogBody.
 *
 * The returned state can be modified with hooks such as useDialogBodyStyles_unstable,
 * before being passed to renderDialogBody_unstable.
 *
 * @param props - props from this instance of DialogBody
 * @param ref - reference to root HTMLElement of DialogBody
 */
export declare const useDialogContent_unstable: (props: DialogContentProps, ref: React_2.Ref<HTMLElement>) => DialogContentState;

/**
 * Apply styling to the DialogContent slots based on the state
 */
export declare const useDialogContentStyles_unstable: (state: DialogContentState) => DialogContentState;

export declare const useDialogContext_unstable: <T>(selector: ContextSelector<DialogContextValue, T>) => T;

export declare function useDialogContextValues_unstable(state: DialogState): DialogContextValues;

/**
 * Create the state required to render DialogSurface.
 *
 * The returned state can be modified with hooks such as useDialogSurfaceStyles_unstable,
 * before being passed to renderDialogSurface_unstable.
 *
 * @param props - props from this instance of DialogSurface
 * @param ref - reference to root HTMLElement of DialogSurface
 */
export declare const useDialogSurface_unstable: (props: DialogSurfaceProps, ref: React_2.Ref<DialogSurfaceElement>) => DialogSurfaceState;

export declare const useDialogSurfaceContext_unstable: () => DialogSurfaceContextValue;

export declare function useDialogSurfaceContextValues_unstable(state: DialogSurfaceState): DialogSurfaceContextValues;

/**
 * Apply styling to the DialogSurface slots based on the state
 */
export declare const useDialogSurfaceStyles_unstable: (state: DialogSurfaceState) => DialogSurfaceState;

/**
 * Create the state required to render DialogTitle.
 *
 * The returned state can be modified with hooks such as useDialogTitleStyles_unstable,
 * before being passed to renderDialogTitle_unstable.
 *
 * @param props - props from this instance of DialogTitle
 * @param ref - reference to root HTMLElement of DialogTitle
 */
export declare const useDialogTitle_unstable: (props: DialogTitleProps, ref: React_2.Ref<HTMLDivElement>) => DialogTitleState;

/**
 * Apply styling to the DialogTitle slots based on the state
 */
export declare const useDialogTitleStyles_unstable: (state: DialogTitleState) => DialogTitleState;

/**
 * Create the state required to render DialogTrigger.
 * Clones the only child component and adds necessary event handling behaviours to open a popup Dialog
 *
 * @param props - props from this instance of DialogTrigger
 */
export declare const useDialogTrigger_unstable: (props: DialogTriggerProps) => DialogTriggerState;

export { }
