'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useContextSelector", {
    enumerable: true,
    get: function() {
        return useContextSelector;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const useContextSelector = (context, selector)=>{
    const contextValue = _react.useContext(context);
    const { value: { current: value }, version: { current: version }, listeners } = contextValue;
    const selected = selector(value);
    const [state, setState] = _react.useState([
        value,
        selected
    ]);
    const dispatch = (payload)=>{
        setState((prevState)=>{
            if (!payload) {
                // early bail out when is dispatched during render
                return [
                    value,
                    selected
                ];
            }
            if (payload[0] <= version) {
                if (Object.is(prevState[1], selected)) {
                    return prevState; // bail out
                }
                return [
                    value,
                    selected
                ];
            }
            try {
                if (Object.is(prevState[0], payload[1])) {
                    return prevState; // do not update
                }
                const nextSelected = selector(payload[1]);
                if (Object.is(prevState[1], nextSelected)) {
                    return prevState; // do not update
                }
                return [
                    payload[1],
                    nextSelected
                ];
            } catch (e) {
            // ignored (stale props or some other reason)
            }
            // explicitly spread to enforce typing
            return [
                prevState[0],
                prevState[1]
            ]; // schedule update
        });
    };
    if (!Object.is(state[1], selected)) {
        // schedule re-render
        // this is safe because it's self contained
        dispatch(undefined);
    }
    const stableDispatch = (0, _reactutilities.useEventCallback)(dispatch);
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        listeners.push(stableDispatch);
        return ()=>{
            const index = listeners.indexOf(stableDispatch);
            listeners.splice(index, 1);
        };
    }, [
        stableDispatch,
        listeners
    ]);
    return state[1];
};
