import * as React_2 from 'react';

/**
 * @internal
 */
export declare type Context<Value> = React_2.Context<Value> & {
    Provider: React_2.FC<React_2.ProviderProps<Value>>;
    Consumer: never;
};

export declare type ContextSelector<Value, SelectedValue> = (value: Value) => SelectedValue;

/**
 * @internal
 */
export declare type ContextValue<Value> = {
    /** Holds a set of subscribers from components. */
    listeners: ((payload: readonly [ContextVersion, Value]) => void)[];
    /** Holds an actual value of React's context that will be propagated down for computations. */
    value: React_2.MutableRefObject<Value>;
    /** A version field is used to sync a context value and consumers. */
    version: React_2.MutableRefObject<ContextVersion>;
};

/**
 * @internal
 */
export declare type ContextValues<Value> = ContextValue<Value> & {
    /** List of listners to publish changes */
    listeners: ((payload: readonly [ContextVersion, Record<string, Value>]) => void)[];
};

/**
 * @internal
 */
export declare type ContextVersion = number;

/**
 * @internal
 */
export declare const createContext: <Value>(defaultValue: Value) => Context<Value>;

/**
 * @internal
 * This hook returns context selected value by selector.
 * It will only accept context created by `createContext`.
 * It will trigger re-render if only the selected value is referentially changed.
 */
export declare const useContextSelector: <Value, SelectedValue>(context: Context<Value>, selector: ContextSelector<Value, SelectedValue>) => SelectedValue;

/**
 * @internal
 * Utility hook for contexts created by react-context-selector to determine if a parent context exists
 * WARNING: This hook will not work for native React contexts
 *
 * @param context - context created by react-context-selector
 * @returns whether the hook is wrapped by a parent context
 */
export declare function useHasParentContext<Value>(context: Context<Value>): boolean;

export { }
