'use client';
import * as React from 'react';
import { Option } from '../Option';
function defaultFilter(optionText, query) {
    if (query === '') {
        return true;
    }
    return optionText.toLowerCase().includes(query.toLowerCase());
}
function defaultToString(option) {
    return typeof option === 'string' ? option : option.value;
}
/**
 * @internal
 */ export function useComboboxFilter(query, options, config) {
    const { filter = defaultFilter, noOptionsMessage = "We couldn't find any matches.", optionToReactKey = defaultToString, optionToText = defaultToString, renderOption = (option)=>{
        if (typeof option === 'string') {
            return /*#__PURE__*/ React.createElement(Option, {
                key: option
            }, option);
        }
        return /*#__PURE__*/ React.createElement(Option, {
            ...option,
            key: optionToReactKey(option),
            text: optionToText(option),
            value: option.value
        }, option.children);
    } } = config;
    const filteredOptions = React.useMemo(()=>{
        const searchValue = query.trim();
        return options.filter((option)=>filter(optionToText(option), searchValue));
    }, [
        options,
        optionToText,
        filter,
        query
    ]);
    if (filteredOptions.length === 0) {
        return [
            /*#__PURE__*/ React.createElement(Option, {
                "aria-disabled": "true",
                key: "no-results",
                text: ""
            }, noOptionsMessage)
        ];
    }
    return filteredOptions.map((option)=>renderOption(option));
}
