'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useOptionCollection", {
    enumerable: true,
    get: function() {
        return useOptionCollection;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const useOptionCollection = ()=>{
    const optionsById = _react.useRef(new Map());
    const collectionAPI = _react.useMemo(()=>{
        const getCount = ()=>optionsById.current.size;
        // index searches are no longer used
        const getOptionAtIndex = ()=>undefined;
        const getIndexOfId = ()=>-1;
        const getOptionById = (id)=>{
            return optionsById.current.get(id);
        };
        const getOptionsMatchingText = (matcher)=>{
            return Array.from(optionsById.current.values()).filter(({ text })=>matcher(text));
        };
        const getOptionsMatchingValue = (matcher)=>{
            const matches = [];
            for (const option of optionsById.current.values()){
                if (matcher(option.value)) {
                    matches.push(option);
                }
            }
            return matches;
        };
        return {
            getCount,
            getOptionAtIndex,
            getIndexOfId,
            getOptionById,
            getOptionsMatchingText,
            getOptionsMatchingValue
        };
    }, []);
    const registerOption = _react.useCallback((option)=>{
        optionsById.current.set(option.id, option);
        return ()=>optionsById.current.delete(option.id);
    }, []);
    return {
        ...collectionAPI,
        options: Array.from(optionsById.current.values()),
        registerOption
    };
};
