'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useListboxSlot", {
    enumerable: true,
    get: function() {
        return useListboxSlot;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reactutilities = require("@fluentui/react-utilities");
const _Listbox = require("../Listbox");
function useListboxSlot(listboxSlotFromProp, ref, options) {
    const { state: { multiselect }, triggerRef, defaultProps } = options;
    const listboxId = (0, _reactutilities.useId)('fluent-listbox', (0, _reactutilities.isResolvedShorthand)(listboxSlotFromProp) ? listboxSlotFromProp.id : undefined);
    const listboxSlot = _reactutilities.slot.optional(listboxSlotFromProp, {
        renderByDefault: true,
        elementType: _Listbox.Listbox,
        defaultProps: {
            id: listboxId,
            multiselect,
            tabIndex: undefined,
            ...defaultProps
        }
    });
    const fieldControlProps = (0, _reactfield.useFieldControlProps_unstable)({
        id: listboxId
    }, {
        supportsLabelFor: true
    });
    // Use the field's label to provide an accessible name for the listbox if it doesn't already have one
    if (listboxSlot && !listboxSlot['aria-label'] && !listboxSlot['aria-labelledby'] && fieldControlProps['aria-labelledby']) {
        listboxSlot['aria-labelledby'] = fieldControlProps['aria-labelledby'];
    }
    /**
   * Clicking on the listbox should never blur the trigger
   * in a combobox
   */ const onMouseDown = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)((event)=>{
        event.preventDefault();
    }, listboxSlot === null || listboxSlot === void 0 ? void 0 : listboxSlot.onMouseDown));
    const onClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)((event)=>{
        var _triggerRef_current;
        event.preventDefault();
        (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
    }, listboxSlot === null || listboxSlot === void 0 ? void 0 : listboxSlot.onClick));
    const listboxRef = (0, _reactutilities.useMergedRefs)(listboxSlot === null || listboxSlot === void 0 ? void 0 : listboxSlot.ref, ref);
    if (listboxSlot) {
        listboxSlot.ref = listboxRef;
        listboxSlot.onMouseDown = onMouseDown;
        listboxSlot.onClick = onClick;
    }
    return listboxSlot;
}
